/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.formplugin.writeoff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.wf.PurOmWfAdjustFacade;
import kd.fi.cal.common.enums.PurOmAdjustTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.BillUnitAndQtytHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PermissionHelper;
import kd.fi.cal.common.model.PurOmWfAdjustInfo;
import kd.fi.cal.common.model.PurOmWfReqOutBillInfo;
import kd.fi.cal.common.util.CommonUtils;

public class CalOutVerificationAdjPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private Map<Long, DynamicObject> omInBillEntryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObject> reqBillEntryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Map<Long, BigDecimal>> orderMatRatioMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
    private static String BILLSELECT = "id,billno,bookdate,invscheme,org as storageorg,billentry.seq as entryseq,billentry.id entryid,billentry.material.masterid matid,billentry.material.number,billentry.auxpty assist,billentry.lotnumber lot,billentry.configuredcode configuredcode,billentry.tracknumber tracknumber,billentry.unit unit,billentry.baseunit baseunit,billentry.qty qty,billentry.baseqty baseqty,billentry.osverifybaseqty as osverifybaseqty,billentry.mainbillnumber mainbillnumber,billentry.mainbillentryseq mainbillentryseq,billentry.mainbillid as mainbillid,billentry.mainbillentryid as mainbillentryid";
    private static final String CARD_ENTITY = "cardentryentity";
    private static final String RESULT_ALL_WF_SUM_FIELD = "result_allwf_sum";
    private static final String RESULT_CUR_WF_FIELD = "result_curwf";
    private static final String RESULT_NEE_WF_FIELD = "result_needwf";
    private static final String RESULT_MAT_FIELD = "result_matpk";
    private static final String RESULT_MAT_NAME = "result_matname";
    private static final String RESULT_MAT_NUM = "result_matnum";
    private static final String RESULT_BASE_UNIT = "result_baseunit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "org");
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("subentryentity");
        EntryGrid purWfEntryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                String key = evt.getFieldName();
                if ("subwfbaseqty".equals(key)) {
                    CalOutVerificationAdjPlugin.this.hyperLinkWfQtyClick(evt);
                }
            }
        });
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                CalOutVerificationAdjPlugin.this.wfOutBillRowClick();
            }
        });
        purWfEntryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                CalOutVerificationAdjPlugin.this.wfOutBillRowClick();
            }
        });
    }

    private void wfOutBillRowClick() {
        int i;
        EntryGrid entryGrid = (EntryGrid)this.getControl("subentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        HashSet<Long> matIds = new HashSet<Long>(16);
        for (int i2 = 0; i2 < selectRows.length; ++i2) {
            DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), selectRows[i2]);
            Long materialPK = CommonUtils.getBaseId((DynamicObject)row, (String)"submaterialnum");
            matIds.add(materialPK);
        }
        DynamicObjectCollection cardDycs = this.getModel().getEntryEntity(CARD_ENTITY);
        for (int i3 = cardDycs.size() - 1; i3 >= 0; --i3) {
            DynamicObject cardDyc = (DynamicObject)cardDycs.get(i3);
            Long materialPK = cardDyc.getLong(RESULT_MAT_FIELD);
            if (matIds.contains(materialPK)) continue;
            this.getModel().deleteEntryRow(CARD_ENTITY, i3);
        }
        int size = this.getModel().getEntryRowCount(CARD_ENTITY);
        for (i = 0; i < size; ++i) {
            this.getModel().setValue(RESULT_ALL_WF_SUM_FIELD, (Object)BigDecimal.ZERO, i);
            this.getModel().setValue(RESULT_CUR_WF_FIELD, (Object)BigDecimal.ZERO, i);
            this.getModel().setValue(RESULT_NEE_WF_FIELD, (Object)BigDecimal.ZERO, i);
        }
        for (i = 0; i < selectRows.length; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), selectRows[i]);
            BigDecimal adjWfBaseQty = row.getBigDecimal("adjwfbaseqty");
            Long materialPK = CommonUtils.getBaseId((DynamicObject)row, (String)"submaterialnum");
            Set<String> materialPks = this.getExistSet();
            if (materialPks.contains(String.valueOf(materialPK))) {
                int size0 = this.getModel().getEntryRowCount(CARD_ENTITY);
                for (int j = 0; j < size0; ++j) {
                    DynamicObject entry = this.getModel().getEntryRowEntity(CARD_ENTITY, j);
                    if (!materialPK.equals(entry.getLong(RESULT_MAT_FIELD))) continue;
                    BigDecimal oldValue = entry.getBigDecimal(RESULT_ALL_WF_SUM_FIELD);
                    this.getModel().setValue(RESULT_ALL_WF_SUM_FIELD, (Object)oldValue.add(adjWfBaseQty), j);
                }
                continue;
            }
            int index = this.getModel().createNewEntryRow(CARD_ENTITY);
            String matName = row.getString("submaterialnum.name");
            matName = this.formatNumNameStr(matName);
            this.getModel().setValue(RESULT_MAT_NAME, (Object)matName, index);
            String matNumber = row.getString("submaterialnum.number");
            matNumber = this.formatNumNameStr(matNumber);
            this.getModel().setValue(RESULT_MAT_NUM, (Object)matNumber, index);
            this.getModel().setValue(RESULT_MAT_FIELD, (Object)materialPK, index);
            this.getModel().setValue(RESULT_ALL_WF_SUM_FIELD, (Object)adjWfBaseQty, index);
            this.getModel().setValue(RESULT_BASE_UNIT, row.getDynamicObject("subbaseunit").getPkValue(), index);
        }
        HashMap<Long, BigDecimal> matIdRateMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> matIdCurBIllQtySumMap = new HashMap<Long, BigDecimal>(16);
        int subSize = this.getModel().getEntryRowCount(entryGrid.getEntryKey());
        for (int i4 = 0; i4 < subSize; ++i4) {
            DynamicObject row = this.getModel().getEntryRowEntity(entryGrid.getEntryKey(), i4);
            Long materialPK = CommonUtils.getBaseId((DynamicObject)row, (String)"submaterialnum");
            BigDecimal curBillQtySum = matIdCurBIllQtySumMap.computeIfAbsent(materialPK, k -> BigDecimal.ZERO);
            BigDecimal adjWfBaseQty = row.getBigDecimal("adjwfbaseqty");
            curBillQtySum = curBillQtySum.add(adjWfBaseQty);
            matIdCurBIllQtySumMap.put(materialPK, curBillQtySum);
            BigDecimal curRate = row.getBigDecimal("qtyratio");
            matIdRateMap.put(materialPK, curRate);
        }
        int cardSize = this.getModel().getEntryRowCount(CARD_ENTITY);
        int wfPurInIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        BigDecimal purWfBaseQty = (BigDecimal)this.getModel().getValue("baseqty", wfPurInIndex);
        for (int i5 = 0; i5 < cardSize; ++i5) {
            DynamicObject row = this.getModel().getEntryRowEntity(CARD_ENTITY, i5);
            Long materialPK = row.getLong(RESULT_MAT_FIELD);
            BigDecimal curBillQtySum = (BigDecimal)matIdCurBIllQtySumMap.get(materialPK);
            this.getModel().setValue(RESULT_CUR_WF_FIELD, (Object)curBillQtySum, i5);
            BigDecimal rate = (BigDecimal)matIdRateMap.get(materialPK);
            int precision = row.getInt("result_baseunit.precision");
            BigDecimal needWfBaseQty = purWfBaseQty.multiply(rate).setScale(precision, 4);
            this.getModel().setValue(RESULT_NEE_WF_FIELD, (Object)needWfBaseQty, i5);
        }
    }

    private String formatNumNameStr(String srcStr) {
        boolean numContainsChinese = this.isContainsChinese(srcStr);
        int numStrMaxSize = numContainsChinese ? 10 : 15;
        boolean numAddPoint = srcStr.length() > numStrMaxSize;
        int numSize = srcStr.length() > numStrMaxSize ? numStrMaxSize : srcStr.length();
        srcStr = srcStr.substring(0, numSize);
        if (numAddPoint) {
            srcStr = srcStr + "...";
        }
        return srcStr;
    }

    private boolean isContainsChinese(String str) {
        boolean numContainsChinese = false;
        for (char item : str.toCharArray()) {
            if (!String.valueOf(item).matches("[\u4e00-\u9fa5]")) continue;
            numContainsChinese = true;
            break;
        }
        return numContainsChinese;
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCalOrg();
        Container queryCondition = (Container)this.getControl("querycondition");
        queryCondition.setCollapse(false);
        this.setBookDateDefaultVal();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.beforeF7Org(e);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"operationadjust"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"imospurinbill"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"imosmaterialreqoutbill"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"crtrecord"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("historyrecord".equals(key) || "crtrecord".equals(key)) {
            String crtRecordId;
            ListShowParameter listParameter = new ListShowParameter();
            listParameter.setBillFormId("cal_omwfadjustrecord");
            listParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if ("crtrecord".equals(key) && (crtRecordId = this.getPageCache().get("crtadjustrecordid")) != null) {
                QFilter listQ = new QFilter("id", "=", (Object)Long.valueOf(crtRecordId));
                listParameter.getListFilterParameter().setFilter(listQ);
            }
            this.getView().showForm((FormShowParameter)listParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("addbill".equals(operateKey)) {
            boolean isNullSubEntry = false;
            Object subEntryObj = this.getModel().getValue("subentryentity");
            if (subEntryObj == null) {
                isNullSubEntry = true;
            } else if (((DynamicObjectCollection)subEntryObj).size() < 1) {
                isNullSubEntry = true;
            }
            if (isNullSubEntry || this.getModel().getValue("supplier") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u3002", (String)"CalOutVerificationAdjPlugin_10", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                return;
            }
            Long inBillId = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(0)).getLong("billid");
            QFilter recordQ = new QFilter("bizbillid", "=", (Object)inBillId);
            recordQ.and("costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
            Date maxDate = null;
            DynamicObject recordBill = QueryServiceHelper.queryOne((String)"cal_costrecord_subentity", (String)"period.enddate as enddate", (QFilter[])recordQ.toArray());
            if (recordBill != null) {
                maxDate = recordBill.getDate("enddate");
            }
            if (maxDate == null) {
                maxDate = this.getModel().getValue("enddate") == null ? null : (Date)this.getModel().getValue("enddate");
            }
            HashSet<Long> subMatIds = new HashSet<Long>(16);
            HashSet<Long> reqBillEntryIds = new HashSet<Long>(16);
            for (DynamicObject subEntry : (DynamicObjectCollection)subEntryObj) {
                subMatIds.add(subEntry.getLong("submaterialnum_id"));
                reqBillEntryIds.add(subEntry.getLong("subbillentryid"));
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("supplierid", this.getModel().getValue("supplier_id"));
            paramMap.put("orderid", this.getModel().getValue("orderid"));
            paramMap.put("startdate", this.getModel().getValue("startdate"));
            paramMap.put("enddate", this.getModel().getValue("enddate"));
            paramMap.put("maxdate", SerializationUtils.toJsonString((Object)maxDate));
            paramMap.put("matids", subMatIds.toArray(new Long[0]));
            paramMap.put("reqentryids", reqBillEntryIds.toArray(new Long[0]));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParams(paramMap);
            showParameter.setFormId("cal_newmdc_bill");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addMdcBillBack"));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "addMdcBillBack".equals(key)) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
            Object reqBillEntryIds = paramMap.get("entryid");
            Object reqBillIds = paramMap.get("id");
            QFilter reqBillQ = new QFilter("id", "in", reqBillIds);
            reqBillQ.and("billentry.id", "in", reqBillEntryIds);
            DynamicObjectCollection reqBillEntrys = QueryServiceHelper.query((String)"im_osmaterialreqoutbill", (String)BILLSELECT, (QFilter[])reqBillQ.toArray(), (String)"billentry.material.number");
            this.setMatRatio(reqBillEntrys);
            DynamicObjectCollection subEntryEntity = (DynamicObjectCollection)this.getModel().getValue("subentryentity");
            this.getModel().beginInit();
            for (DynamicObject reqBillEntry : reqBillEntrys) {
                subEntryEntity.addNew();
                int subRow = subEntryEntity.size() - 1;
                this.getModel().setValue("subinvscheme", reqBillEntry.get("invscheme"), subRow);
                this.getModel().setValue("submainbillentryseq", reqBillEntry.get("mainbillentryseq"), subRow);
                this.getModel().setValue("subbillid", reqBillEntry.get("id"), subRow);
                this.getModel().setValue("subbillentryid", reqBillEntry.get("entryid"), subRow);
                this.getModel().setValue("subbillentryseq", reqBillEntry.get("entryseq"), subRow);
                this.getModel().setValue("submaterialnum", reqBillEntry.get("matid"), subRow);
                this.getModel().setValue("orderbillno", reqBillEntry.get("mainbillnumber"), subRow);
                this.getModel().setValue("reqbillno", reqBillEntry.get("billno"), subRow);
                this.getModel().setValue("subbookdate", reqBillEntry.get("bookdate"), subRow);
                this.getModel().setValue("storageorg", reqBillEntry.get("storageorg"), subRow);
                this.getModel().setValue("subassist", reqBillEntry.get("assist"), subRow);
                this.getModel().setValue("sublot", reqBillEntry.get("lot"), subRow);
                this.getModel().setValue("subconfiguredcode", reqBillEntry.get("configuredcode"), subRow);
                this.getModel().setValue("subtracknumber", reqBillEntry.get("tracknumber"), subRow);
                this.getModel().setValue("subunit", reqBillEntry.get("unit"), subRow);
                this.getModel().setValue("subbaseunit", reqBillEntry.get("baseunit"), subRow);
                this.getModel().setValue("subqty", reqBillEntry.get("qty"), subRow);
                Long orderEntryId = reqBillEntry.getLong("mainbillentryid");
                if (this.orderMatRatioMap.get(orderEntryId) != null) {
                    BigDecimal qtyRatio = this.orderMatRatioMap.get(orderEntryId).get(reqBillEntry.get("matid"));
                    qtyRatio = qtyRatio == null ? BigDecimal.ONE : qtyRatio;
                    this.getModel().setValue("qtyratio", (Object)qtyRatio, subRow);
                }
                BigDecimal baseQty = reqBillEntry.getBigDecimal("baseqty");
                BigDecimal billWfBaseQty = reqBillEntry.getBigDecimal("osverifybaseqty");
                BigDecimal canWfQty = baseQty.subtract(billWfBaseQty);
                this.getModel().setValue("subcanwfqty", (Object)canWfQty, subRow);
                this.getModel().setValue("subwfbaseqty", (Object)billWfBaseQty, subRow);
                this.getModel().setValue("subbaseqty", (Object)baseQty, subRow);
            }
            this.getModel().endInit();
            this.getView().updateView("subentryentity");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f\u3002", (String)"CalOutVerificationAdjPlugin_11", (String)"fi-cal-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (e.getCallBackId().equals("doadjust") && MessageBoxResult.Yes.equals((Object)result)) {
            this.checkBillWfqty();
            PurOmWfAdjustInfo adjustInfo = this.buildAdjustInfo();
            PurOmWfAdjustFacade facade = new PurOmWfAdjustFacade();
            Long adjustRecordId = facade.executeWfAdjust(adjustInfo);
            if (adjustRecordId != null) {
                this.getPageCache().put("crtadjustrecordid", adjustRecordId.toString());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u6574\u6210\u529f\u3002", (String)"CalOutVerificationAdjPlugin_6", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"crtrecord"});
                this.getView().invokeOperation("query");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        String operateKey;
        super.afterDoOperation(arg);
        switch (operateKey = arg.getOperateKey()) {
            case "query": {
                this.exeQueryOperation();
                break;
            }
            case "adjust": {
                Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
                if (!isNewGroupModel.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5207\u6362\u4e3a\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u3002", (String)"CalOutVerificationAdjPlugin_14", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    return;
                }
                int[] entryRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
                if (entryRows.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u5206\u5f55\u3002", (String)"CalOutVerificationAdjPlugin_2", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    return;
                }
                int[] subEntryRows = ((EntryGrid)this.getView().getControl("subentryentity")).getSelectRows();
                if (subEntryRows.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u59d4\u5916\u91c7\u8d2d\u9886\u6599\u5355\u5206\u5f55\u3002", (String)"CalOutVerificationAdjPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<Object, BigDecimal> matSumWfQtyMap = new HashMap<Object, BigDecimal>(16);
                HashMap<Object, String> matNumMap = new HashMap<Object, String>(16);
                for (DynamicObject subEntry : (DynamicObjectCollection)this.getModel().getValue("subentryentity")) {
                    Long matId = subEntry.getLong("submaterialnum.id");
                    matNumMap.put(matId, subEntry.getString("submaterialnum.number"));
                    BigDecimal wfBaseQty = subEntry.getBigDecimal("subcurwfbaseqty");
                    matSumWfQtyMap.putIfAbsent(matId, BigDecimal.ZERO);
                    BigDecimal sumWfQty = (BigDecimal)matSumWfQtyMap.get(matId);
                    sumWfQty = sumWfQty.add(wfBaseQty);
                    matSumWfQtyMap.put(matId, sumWfQty);
                }
                HashMap<Long, BigDecimal> matSumDiffQtyMap = new HashMap<Long, BigDecimal>(16);
                boolean isAllZeroDiff = true;
                for (Object subEntryIndex : (Long)subEntryRows) {
                    BigDecimal diffBaseQty = (BigDecimal)this.getModel().getValue("diffbaseqty", (int)subEntryIndex);
                    Long matId = (Long)this.getModel().getValue("submaterialnum_id", (int)subEntryIndex);
                    matSumDiffQtyMap.putIfAbsent(matId, BigDecimal.ZERO);
                    BigDecimal sumDiffQty = (BigDecimal)matSumDiffQtyMap.get(matId);
                    sumDiffQty = sumDiffQty.add(diffBaseQty);
                    matSumDiffQtyMap.put(matId, sumDiffQty);
                    if (BigDecimal.ZERO.compareTo(diffBaseQty) == 0) continue;
                    isAllZeroDiff = false;
                }
                if (isAllZeroDiff) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u9886\u6599\u5355\u5206\u5f55\u8c03\u6574\u5dee\u5f02\u6570\u91cf\u5747\u4e3a0\u3002", (String)"CalOutVerificationAdjPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringBuilder errmsgBuilder = new StringBuilder();
                for (Map.Entry entry : matSumDiffQtyMap.entrySet()) {
                    Long matId = (Long)entry.getKey();
                    BigDecimal sumDiffQty = (BigDecimal)entry.getValue();
                    BigDecimal sumWfQty = (BigDecimal)matSumWfQtyMap.get(matId);
                    if (sumWfQty.add(sumDiffQty).compareTo(BigDecimal.ZERO) != 0) continue;
                    errmsgBuilder.append(String.format(ResManager.loadKDString((String)"\u5b50\u4ef6\u7269\u6599\u201c%1$s\u201d\u8c03\u6574\u6838\u9500\u6570\u91cf\u5408\u8ba1\u4e0d\u80fd\u7b49\u4e8e0\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u540e\u518d\u8c03\u6574\u3002", (String)"CalOutVerificationAdjPlugin_7", (String)"fi-cal-formplugin", (Object[])new Object[0]), matNumMap.get(matId)));
                    errmsgBuilder.append("\n");
                }
                if (!StringUtils.isEmpty((String)errmsgBuilder.toString())) {
                    this.getView().showErrorNotification(errmsgBuilder.toString());
                    return;
                }
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("doadjust", (IFormPlugin)this);
                String confirmStr = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5bf9\u6210\u54c1\u7269\u6599\u201c%1$s\u201d\u8fdb\u884c\u6838\u9500\u8c03\u6574\u5417\uff1f", (String)"CalOutVerificationAdjPlugin_5", (String)"fi-cal-formplugin", (Object[])new Object[0]);
                confirmStr = String.format(confirmStr, ((DynamicObject)this.getModel().getValue("materialnum", entryRows[0])).getString("name"));
                this.getView().showConfirm(confirmStr, null, MessageBoxOptions.OKCancel, null, callBackListener, null, "");
                break;
            }
        }
    }

    private void exeQueryOperation() {
        long org = this.getModel().getDataEntity().getLong("org.id");
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        Date endDate = this.getModel().getDataEntity().getDate("enddate");
        String purNumber = this.getModel().getDataEntity().getString("purnumber");
        long material = this.getModel().getDataEntity().getLong("material.id");
        long supplier = this.getModel().getDataEntity().getLong("supplier.id");
        if (org == 0L || startDate == null || endDate == null || StringUtils.isEmpty((String)purNumber)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalOutVerificationAdjPlugin_0", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter returnQ = new QFilter("billentry.entrysettleorg", "=", (Object)org);
        returnQ.and("bookdate", ">=", (Object)startDate);
        returnQ.and("billentry.srcbillnumber", "=", (Object)purNumber);
        if (QueryServiceHelper.exists((String)"im_ospurinbill", (QFilter[])returnQ.toArray())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9000\u8d27\u7684\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"CalOutVerificationAdjPlugin_8", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter redQ = new QFilter("billentry.entrysettleorg", "=", (Object)org);
        redQ.and("bookdate", ">=", (Object)startDate);
        redQ.and("bookdate", "<", (Object)endDate);
        redQ.and("billno", "=", (Object)purNumber);
        redQ.and("billentry.baseqty", "<", (Object)BigDecimal.ZERO);
        if (QueryServiceHelper.exists((String)"im_ospurinbill", (QFilter[])redQ.toArray())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ea2\u5b57\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"CalOutVerificationAdjPlugin_12", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter omInRecordQ = new QFilter("org", "=", (Object)org);
        omInRecordQ.and("entry.datefield", ">=", (Object)startDate);
        omInRecordQ.and("entry.datefield", "<=", (Object)endDate);
        omInRecordQ.and("entry.billno", "=", (Object)purNumber);
        omInRecordQ.and("entry.billtype", "=", (Object)"im_ospurinbill");
        omInRecordQ.and("entry.qty", ">", (Object)BigDecimal.ZERO);
        if (material != 0L) {
            omInRecordQ.and("entry.asstmaterial.masterid", "=", (Object)material);
        }
        if (supplier != 0L) {
            omInRecordQ.and("supply.id", "=", (Object)supplier);
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        entryEntitys.clear();
        DynamicObject[] omInRecords = BusinessDataServiceHelper.load((String)"im_oswfrecord", (String)"id,entry.id,entry.billid,entry.billentryid,entry.asstmaterial,entry.asstmaterial.number,entry.qty,entry.asstbasewritqty,entry.billtype,entry.asstsrcbillentryseq", (QFilter[])omInRecordQ.toArray());
        if (omInRecords == null || omInRecords.length < 1) {
            this.afterDoQuery();
            return;
        }
        this.bubbleSortRecord(omInRecords);
        this.setBillEntryMap(omInRecords);
        this.setMatRatio(null);
        for (DynamicObject omInRecord : omInRecords) {
            Long recordId = omInRecord.getLong("id");
            DynamicObject omInRecordEntry = null;
            ArrayList<DynamicObject> reqRecordEntrys = new ArrayList<DynamicObject>(16);
            for (DynamicObject entry : omInRecord.getDynamicObjectCollection("entry")) {
                if ("im_ospurinbill".equals(entry.getString("billtype.number"))) {
                    omInRecordEntry = entry;
                    continue;
                }
                reqRecordEntrys.add(entry);
            }
            if (omInRecordEntry == null) continue;
            Long omInBillEntryId = omInRecordEntry.getLong("billentryid");
            DynamicObject omInBillEntry = this.omInBillEntryMap.get(omInBillEntryId);
            int entryRow = this.getModel().createNewEntryRow("entryentity");
            ((EntryGrid)this.getView().getControl("entryentity")).selectRows(entryRow);
            this.getModel().setValue("billid", omInBillEntry.get("id"), entryRow);
            this.getModel().setValue("billentryid", omInBillEntry.get("entryid"), entryRow);
            this.getModel().setValue("billno", omInBillEntry.get("billno"), entryRow);
            this.getModel().setValue("billentryseq", omInBillEntry.get("entryseq"), entryRow);
            this.getModel().setValue("materialnum", omInBillEntry.get("matid"), entryRow);
            this.getModel().setValue("assist", omInBillEntry.get("assist"), entryRow);
            this.getModel().setValue("lot", omInBillEntry.get("lot"), entryRow);
            this.getModel().setValue("configuredcode", omInBillEntry.get("configuredcode"), entryRow);
            this.getModel().setValue("tracknumber", omInBillEntry.get("tracknumber"), entryRow);
            this.getModel().setValue("meterunit", omInBillEntry.get("unit"), entryRow);
            this.getModel().setValue("baseunit", omInBillEntry.get("baseunit"), entryRow);
            this.getModel().setValue("qty", omInBillEntry.get("qty"), entryRow);
            this.getModel().setValue("baseqty", omInBillEntry.get("baseqty"), entryRow);
            this.getModel().setValue("recordid", (Object)recordId, entryRow);
            this.getModel().setValue("wfqty", omInRecordEntry.get("asstbasewritqty"), entryRow);
            this.getModel().setValue("wfbaseqty", omInRecordEntry.get("qty"), entryRow);
            if (reqRecordEntrys == null) continue;
            DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", entryRow);
            DynamicObjectCollection subEntryEntity = entryentity.getDynamicObjectCollection("subentryentity");
            subEntryEntity.clear();
            Collections.sort(reqRecordEntrys, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject entry1, DynamicObject entry2) {
                    return entry1.getString("asstmaterial.masterid.number").compareTo(entry2.getString("asstmaterial.masterid.number"));
                }
            });
            this.getModel().beginInit();
            for (DynamicObject reqRecordEntry : reqRecordEntrys) {
                Long reqBillEntryId = reqRecordEntry.getLong("billentryid");
                DynamicObject reqBillEntry = this.reqBillEntryMap.get(reqBillEntryId);
                if (reqBillEntry == null) continue;
                subEntryEntity.addNew();
                int subRow = subEntryEntity.size() - 1;
                this.getModel().setValue("subinvscheme", reqBillEntry.get("invscheme"), subRow, entryRow);
                this.getModel().setValue("submainbillentryseq", reqBillEntry.get("mainbillentryseq"), subRow, entryRow);
                this.getModel().setValue("subbillid", reqBillEntry.get("id"), subRow, entryRow);
                this.getModel().setValue("subbillentryid", reqBillEntry.get("entryid"), subRow, entryRow);
                this.getModel().setValue("subbillentryseq", reqBillEntry.get("entryseq"), subRow, entryRow);
                this.getModel().setValue("submaterialnum", reqBillEntry.get("matid"), subRow, entryRow);
                this.getModel().setValue("orderbillno", reqBillEntry.get("mainbillnumber"), subRow, entryRow);
                this.getModel().setValue("reqbillno", reqBillEntry.get("billno"), subRow, entryRow);
                this.getModel().setValue("subbookdate", reqBillEntry.get("bookdate"), subRow, entryRow);
                this.getModel().setValue("storageorg", reqBillEntry.get("storageorg"), subRow, entryRow);
                this.getModel().setValue("subassist", reqBillEntry.get("assist"), subRow, entryRow);
                this.getModel().setValue("sublot", reqBillEntry.get("lot"), subRow, entryRow);
                this.getModel().setValue("subconfiguredcode", reqBillEntry.get("configuredcode"), subRow, entryRow);
                this.getModel().setValue("subtracknumber", reqBillEntry.get("tracknumber"), subRow, entryRow);
                this.getModel().setValue("subunit", reqBillEntry.get("unit"), subRow, entryRow);
                this.getModel().setValue("subbaseunit", reqBillEntry.get("baseunit"), subRow, entryRow);
                this.getModel().setValue("subqty", reqBillEntry.get("qty"), subRow, entryRow);
                Long orderEntryId = reqBillEntry.getLong("mainbillentryid");
                if (this.orderMatRatioMap.get(orderEntryId) != null) {
                    BigDecimal qtyRatio = this.orderMatRatioMap.get(orderEntryId).get(reqBillEntry.get("matid"));
                    qtyRatio = qtyRatio == null ? BigDecimal.ONE : qtyRatio;
                    this.getModel().setValue("qtyratio", (Object)qtyRatio, subRow, entryRow);
                }
                this.getModel().setValue("subrecordid", (Object)recordId, subRow, entryRow);
                this.getModel().setValue("subrecordentryid", reqRecordEntry.get("id"), subRow, entryRow);
                BigDecimal baseQty = reqBillEntry.getBigDecimal("baseqty");
                BigDecimal billWfBaseQty = reqBillEntry.getBigDecimal("osverifybaseqty");
                BigDecimal recordWfBaseQty = reqRecordEntry.getBigDecimal("qty");
                BigDecimal recordWfQty = reqRecordEntry.getBigDecimal("asstbasewritqty");
                BigDecimal canWfQty = baseQty.subtract(billWfBaseQty).add(recordWfBaseQty);
                this.getModel().setValue("subcanwfqty", (Object)canWfQty, subRow, entryRow);
                this.getModel().setValue("subwfbaseqty", (Object)billWfBaseQty, subRow, entryRow);
                this.getModel().setValue("subcurwfqty", (Object)recordWfQty, subRow, entryRow);
                this.getModel().setValue("subcurwfbaseqty", (Object)recordWfBaseQty, subRow, entryRow);
                this.getModel().setValue("subbaseqty", (Object)baseQty, subRow, entryRow);
                this.getModel().setValue("adjwfbaseqty", (Object)recordWfBaseQty, subRow, entryRow);
            }
            this.getModel().endInit();
        }
        this.afterDoQuery();
    }

    private void afterDoQuery() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"imospurinbill"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"imosmaterialreqoutbill"});
        this.getView().updateView("entryentity");
        this.getView().updateView("subentryentity");
        if (((DynamicObjectCollection)this.getModel().getValue("entryentity")).size() > 0) {
            ((EntryGrid)this.getView().getControl("entryentity")).selectRows(0);
        }
        ((Container)this.getControl("querycondition")).setCollapse(Boolean.TRUE.booleanValue());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"operationadjust"});
        this.wfOutBillRowClick();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        int rowIndex = data.getRowIndex();
        Object oldValue = data.getOldValue();
        Object newValue = data.getNewValue();
        switch (proName) {
            case "org": {
                this.setBookDateDefaultVal();
                break;
            }
            case "adjwfbaseqty": {
                BigDecimal canWfQty;
                if (newValue == null) {
                    newValue = BigDecimal.ZERO;
                }
                if ((canWfQty = (BigDecimal)this.getModel().getValue("subcanwfqty", rowIndex)).compareTo((BigDecimal)newValue) < 0) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8c03\u6574\u672c\u5355\u6838\u9500\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u6838\u9500\u57fa\u672c\u6570\u91cf%1$s\u3002", (String)"CalOutVerificationAdjPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]), canWfQty));
                    this.getModel().beginInit();
                    this.getModel().setValue("adjwfbaseqty", oldValue, rowIndex);
                    this.getModel().endInit();
                } else {
                    BigDecimal diffBaseQty = ((BigDecimal)newValue).subtract((BigDecimal)this.getModel().getValue("subcurwfbaseqty", rowIndex));
                    this.getModel().setValue("diffbaseqty", (Object)diffBaseQty, rowIndex);
                    if (BigDecimal.ZERO.compareTo(diffBaseQty) == 0) {
                        this.getModel().setValue("diffqty", (Object)diffBaseQty, rowIndex);
                        this.wfOutBillRowClick();
                        return;
                    }
                    Long matId = ((DynamicObject)this.getModel().getValue("submaterialnum", rowIndex)).getLong("id");
                    DynamicObject unitDym = (DynamicObject)this.getModel().getValue("subunit", rowIndex);
                    Long unitId = unitDym.getLong("id");
                    int unitPrecision = unitDym.getInt("precision");
                    Long baseUnitId = ((DynamicObject)this.getModel().getValue("subbaseunit", rowIndex)).getLong("id");
                    BigDecimal convertrate = BillUnitAndQtytHelper.getUnitRateConv((Long)matId, (Long)unitId, (Long)baseUnitId);
                    BigDecimal diffQty = diffBaseQty.divide(convertrate, unitPrecision, 4);
                    this.getModel().setValue("diffqty", (Object)diffQty, rowIndex);
                }
                this.wfOutBillRowClick();
                break;
            }
            case "purnumber": {
                String purNumber = this.getModel().getDataEntity().getString("purnumber");
                QFilter filter = new QFilter("billno", "=", (Object)purNumber);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"im_ospurinbill", (String)"supplier,billentry.mainbillid as mainbillid", (QFilter[])new QFilter[]{filter});
                if (dynamicObject != null) {
                    this.getModel().setValue("supplier", (Object)dynamicObject.getLong("supplier"));
                    this.getModel().setValue("orderid", (Object)dynamicObject.getLong("mainbillid"));
                } else {
                    this.getModel().setValue("supplier", null);
                    this.getModel().setValue("orderid", null);
                }
                this.getView().updateView("supplier");
                break;
            }
        }
    }

    private void setBookDateDefaultVal() {
        this.getModel().beginInit();
        long org = this.getModel().getDataEntity().getLong("org.id");
        if (org != 0L) {
            QFilter filter = new QFilter("calorg", "=", (Object)org);
            filter.and("ismainaccount", "=", (Object)"1");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dynamicObject != null) {
                QFilter perFilter = new QFilter("entry.costaccount", "=", (Object)dynamicObject.getLong("id"));
                DynamicObject periodDyo = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod.begindate as begindate,entry.currentperiod.enddate as enddate", (QFilter[])new QFilter[]{perFilter});
                if (periodDyo != null) {
                    this.getModel().setValue("startdate", (Object)periodDyo.getDate("begindate"));
                    this.getModel().setValue("enddate", (Object)periodDyo.getDate("enddate"));
                    DateRangeEdit dateControl = (DateRangeEdit)this.getView().getControl("bookdate");
                    dateControl.setMinDate(periodDyo.getDate("begindate"));
                }
            } else {
                this.getModel().setValue("startdate", null);
                this.getModel().setValue("enddate", null);
            }
        } else {
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
        }
        this.getModel().endInit();
        this.getView().updateView("bookdate");
    }

    private void setBillEntryMap(DynamicObject[] omInRecords) {
        HashSet<Long> omInBillIds = new HashSet<Long>(16);
        HashSet<Long> omInBillEntryIds = new HashSet<Long>(16);
        HashSet<Long> reqBillIds = new HashSet<Long>(16);
        HashSet<Long> reqBillEntryIds = new HashSet<Long>(16);
        for (DynamicObject omInRecord : omInRecords) {
            DynamicObjectCollection entrys = omInRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if ("im_ospurinbill".equals(entry.getString("billtype.number"))) {
                    omInBillIds.add(entry.getLong("billid"));
                    omInBillEntryIds.add(entry.getLong("billentryid"));
                    continue;
                }
                reqBillIds.add(entry.getLong("billid"));
                reqBillEntryIds.add(entry.getLong("billentryid"));
            }
        }
        QFilter omInBillQ = new QFilter("id", "in", omInBillIds);
        omInBillQ.and("billentry.id", "in", omInBillEntryIds);
        DynamicObjectCollection omInBills = QueryServiceHelper.query((String)"im_ospurinbill", (String)BILLSELECT, (QFilter[])omInBillQ.toArray());
        QFilter reqBillQ = new QFilter("id", "in", reqBillIds);
        reqBillQ.and("billentry.id", "in", reqBillEntryIds);
        DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"im_osmaterialreqoutbill", (String)BILLSELECT, (QFilter[])reqBillQ.toArray(), (String)"billentry.material.number");
        for (DynamicObject omInBill : omInBills) {
            this.omInBillEntryMap.put(omInBill.getLong("entryid"), omInBill);
        }
        for (DynamicObject reqBill : reqBills) {
            this.reqBillEntryMap.put(reqBill.getLong("entryid"), reqBill);
        }
    }

    private PurOmWfAdjustInfo buildAdjustInfo() {
        int[] entryRowIds = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        int[] subEntryRowIds = ((EntryGrid)this.getView().getControl("subentryentity")).getSelectRows();
        DynamicObject omInEntry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryRowIds[0]);
        ArrayList<DynamicObject> reqEntrys = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection subEntrys = omInEntry.getDynamicObjectCollection("subentryentity");
        for (int subEntryRowId : subEntryRowIds) {
            DynamicObject reqEntry = (DynamicObject)subEntrys.get(subEntryRowId);
            BigDecimal diffBaseQty = reqEntry.getBigDecimal("diffbaseqty");
            if (BigDecimal.ZERO.compareTo(diffBaseQty) == 0) continue;
            reqEntrys.add(reqEntry);
        }
        PurOmWfAdjustInfo purOmWfAdjustInfo = new PurOmWfAdjustInfo();
        purOmWfAdjustInfo.setInBillEntryId(Long.valueOf(omInEntry.getLong("billentryid")));
        purOmWfAdjustInfo.setInBillId(Long.valueOf(omInEntry.getLong("billid")));
        purOmWfAdjustInfo.setInBillSeq(Long.valueOf(omInEntry.getLong("billentryseq")));
        purOmWfAdjustInfo.setInBillNo(omInEntry.getString("billno"));
        purOmWfAdjustInfo.setOmWfRecordId(Long.valueOf(omInEntry.getLong("recordid")));
        ArrayList<PurOmWfReqOutBillInfo> reqBillInfoList = new ArrayList<PurOmWfReqOutBillInfo>(16);
        for (DynamicObject subEntry : reqEntrys) {
            PurOmWfReqOutBillInfo reqBillInfo = new PurOmWfReqOutBillInfo();
            BigDecimal qty = subEntry.getBigDecimal("subqty");
            BigDecimal recordWfQty = subEntry.getBigDecimal("subcurwfqty");
            BigDecimal recordWfBaseQty = subEntry.getBigDecimal("subcurwfbaseqty");
            BigDecimal crtAdjustWfBaseQty = subEntry.getBigDecimal("diffbaseqty");
            BigDecimal crtAdjustWfQty = subEntry.getBigDecimal("diffqty");
            BigDecimal wfBaseqty = subEntry.getBigDecimal("adjwfbaseqty");
            BigDecimal wfqty = recordWfQty.add(crtAdjustWfQty);
            String adjustType = PurOmAdjustTypeEnum.ADJUST_UPDATE.getValue();
            if (BigDecimal.ZERO.compareTo(wfBaseqty) == 0) {
                adjustType = PurOmAdjustTypeEnum.ADJUST_DELETE.getValue();
            } else if (BigDecimal.ZERO.compareTo(recordWfBaseQty) == 0) {
                adjustType = PurOmAdjustTypeEnum.ADJUST_ADD.getValue();
            }
            reqBillInfo.setAdjustType(adjustType);
            reqBillInfo.setQty(qty);
            reqBillInfo.setRecordWfQty(recordWfQty);
            reqBillInfo.setRecordWfBaseQty(recordWfBaseQty);
            reqBillInfo.setCrtAdjustWfBaseQty(crtAdjustWfBaseQty);
            reqBillInfo.setCrtAdjustWfQty(crtAdjustWfQty);
            reqBillInfo.setCrtWfBaseQty(wfBaseqty);
            reqBillInfo.setCrtWfQty(wfqty);
            reqBillInfo.setUnitId(Long.valueOf(subEntry.getLong("subunit.id")));
            reqBillInfo.setBaseunitId(Long.valueOf(subEntry.getLong("subbaseunit.id")));
            reqBillInfo.setBookDate(subEntry.getDate("subbookdate"));
            reqBillInfo.setInvschemeId(Long.valueOf(subEntry.getLong("subinvscheme.id")));
            reqBillInfo.setMainBillEntrySeq(Long.valueOf(subEntry.getLong("submainbillentryseq")));
            reqBillInfo.setMainBillNum(subEntry.getString("orderbillno"));
            reqBillInfo.setMatId(Long.valueOf(subEntry.getLong("submaterialnum.id")));
            reqBillInfo.setRecordEntryId(Long.valueOf(subEntry.getLong("subrecordentryid")));
            reqBillInfo.setRecordId(Long.valueOf(subEntry.getLong("subrecordid")));
            reqBillInfo.setReqBillEntryId(Long.valueOf(subEntry.getLong("subbillentryid")));
            reqBillInfo.setReqBillEntrySeq(Long.valueOf(subEntry.getLong("subbillentryseq")));
            reqBillInfo.setReqBillId(Long.valueOf(subEntry.getLong("subbillid")));
            reqBillInfo.setReqBillNo(subEntry.getString("reqbillno"));
            reqBillInfoList.add(reqBillInfo);
        }
        purOmWfAdjustInfo.setReqBillList(reqBillInfoList);
        return purOmWfAdjustInfo;
    }

    private void setCalOrg() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long userOrgId = RequestContext.get().getOrgId();
        Long calOrgId = OrgHelper.getCalOrgByUserOrg((Long)userId, (Long)userOrgId, (String)"cal_outverification_adj");
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_outverification_adj", (String)"47150e89000000ac");
        if (list == null) {
            if (calOrgId != null && calOrgId != 0L) {
                this.getModel().setValue("org", (Object)calOrgId);
            }
            return;
        }
        if (!list.isEmpty()) {
            if (calOrgId != null && calOrgId != 0L) {
                if (list.contains(calOrgId)) {
                    this.getModel().setValue("org", (Object)calOrgId);
                } else {
                    this.getModel().setValue("org", list.get(0));
                }
            } else {
                this.getModel().setValue("org", list.get(0));
            }
        }
        this.setBookDateDefaultVal();
    }

    private void beforeF7Org(BeforeF7SelectEvent e) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        List list = PermissionHelper.getUserPermOrgs((Long)userId, (String)"cal_puromwfmanual", (String)"47150e89000000ac");
        if (list != null) {
            QFilter q = new QFilter("id", "in", (Object)list);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    private void hyperLinkWfQtyClick(HyperLinkClickEvent evt) {
        Long billEntryId = (Long)this.getModel().getValue("subbillentryid", evt.getRowIndex());
        if (Long.compare(0L, billEntryId) == 0) {
            return;
        }
        HashSet<Long> recordIds = new HashSet<Long>(16);
        DataSet recordDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_oswfrecord", (String)"id", (QFilter[])new QFilter("entry.billentryid", "=", (Object)billEntryId).toArray(), null);
        for (Row row : recordDs) {
            recordIds.add(row.getLong("id"));
        }
        if (recordIds.isEmpty()) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId("im_oswfrecord");
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Long recordId : recordIds) {
            linkQueryPkIdCollection.addLinkQueryPkId((Object)recordId);
        }
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", recordIds));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject[] bubbleSortRecord(DynamicObject[] omInRecords) {
        for (int i = 0; i < omInRecords.length - 1; ++i) {
            for (int j = 0; j < omInRecords.length - i - 1; ++j) {
                String inBillMatNum = "";
                String nextInBillMatNum = "";
                for (DynamicObject entry : omInRecords[j].getDynamicObjectCollection("entry")) {
                    if (!"im_ospurinbill".equals(entry.getString("billtype.number"))) continue;
                    inBillMatNum = entry.getString("asstmaterial.masterid.number");
                }
                for (DynamicObject entry : omInRecords[j + 1].getDynamicObjectCollection("entry")) {
                    if (!"im_ospurinbill".equals(entry.getString("billtype.number"))) continue;
                    nextInBillMatNum = entry.getString("asstmaterial.masterid.number");
                }
                if (inBillMatNum.compareTo(nextInBillMatNum) <= 0) continue;
                DynamicObject tempRecord = omInRecords[j];
                omInRecords[j] = omInRecords[j + 1];
                omInRecords[j + 1] = tempRecord;
            }
        }
        return omInRecords;
    }

    private void setMatRatio(DynamicObjectCollection reqBills) {
        DynamicObject[] reqBillArr = null;
        reqBillArr = reqBills == null ? this.reqBillEntryMap.values().toArray(new DynamicObject[0]) : (DynamicObject[])reqBills.toArray((Object[])new DynamicObject[0]);
        if (reqBillArr == null) {
            return;
        }
        for (DynamicObject reqBillEntry : reqBillArr) {
            Long orderId = reqBillEntry.getLong("mainbillid");
            Long orderEntryId = reqBillEntry.getLong("mainbillentryid");
            QFilter orderQ = new QFilter("id", "=", (Object)orderId);
            orderQ.and("billentry.id", "=", (Object)orderEntryId);
            DataSet orderDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sctm_scpo", (String)"billentry.id as entryid,billentry.billentry_sub.submaterial as submatid,billentry.billentry_sub.qtyratio as qtyratio", (QFilter[])orderQ.toArray(), null);
            for (Row row : orderDs) {
                Long entryId = row.getLong("entryid");
                Map matRatioMap = this.orderMatRatioMap.computeIfAbsent(entryId, k -> new HashMap(16));
                matRatioMap.put(row.getLong("submatid"), row.getBigDecimal("qtyratio"));
            }
        }
    }

    private Set<String> getExistSet() {
        int entryRowCount = this.getModel().getEntryRowCount(CARD_ENTITY);
        HashSet<String> materialPks = new HashSet<String>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity(CARD_ENTITY, i);
            materialPks.add(entry.getString(RESULT_MAT_FIELD));
        }
        return materialPks;
    }

    private void checkBillWfqty() {
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> billEntryIds = new HashSet<Long>(16);
        int[] subEntryRowIds = ((EntryGrid)this.getView().getControl("subentryentity")).getSelectRows();
        DynamicObjectCollection subEntrys = (DynamicObjectCollection)this.getModel().getValue("subentryentity");
        for (int subEntryRowId : subEntryRowIds) {
            DynamicObject dynamicObject = (DynamicObject)subEntrys.get(subEntryRowId);
            BigDecimal diffBaseQty = dynamicObject.getBigDecimal("diffbaseqty");
            if (BigDecimal.ZERO.compareTo(diffBaseQty) == 0) continue;
            billIds.add(dynamicObject.getLong("subbillid"));
            billEntryIds.add(dynamicObject.getLong("subbillentryid"));
        }
        QFilter reqBillQ = new QFilter("id", "in", billIds);
        reqBillQ.and("billentry.id", "in", billEntryIds);
        DataSet reqBills = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_osmaterialreqoutbill", (String)"billentry.id as entryid,billentry.osverifybaseqty as wfbaseqty", (QFilter[])reqBillQ.toArray(), null);
        HashMap<Long, BigDecimal> entryWfQtyMap = new HashMap<Long, BigDecimal>(16);
        for (Row row : reqBills) {
            entryWfQtyMap.put(row.getLong("entryid"), row.getBigDecimal("wfbaseqty"));
        }
        ArrayList<String> seqNums = new ArrayList<String>(16);
        for (int subEntryRowId : subEntryRowIds) {
            BigDecimal billWfBaseQty;
            DynamicObject reqEntry = (DynamicObject)subEntrys.get(subEntryRowId);
            BigDecimal wfBaseQty = reqEntry.getBigDecimal("subwfbaseqty");
            Long entryId = reqEntry.getLong("subbillentryid");
            BigDecimal diffBaseQty = reqEntry.getBigDecimal("diffbaseqty");
            if (BigDecimal.ZERO.compareTo(diffBaseQty) == 0 || (billWfBaseQty = (BigDecimal)entryWfQtyMap.get(entryId)) != null && wfBaseQty.compareTo(billWfBaseQty) == 0) continue;
            seqNums.add(String.valueOf(subEntryRowId + 1));
        }
        if (!seqNums.isEmpty()) {
            String string = String.join((CharSequence)",", seqNums);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u9886\u6599\u5355\u5206\u5f55\u7b2c[%1$s]\u884c\uff0c\u5df2\u6838\u9500\u6570\u91cf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"CalOutVerificationAdjPlugin_13", (String)"fi-cal-formplugin", (Object[])new Object[0]), string);
            throw new KDBizException(errorMsg);
        }
    }
}

