/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algo.output.IgnoreOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.calx.algox.BalanceReCalParams;
import kd.fi.calx.algox.CalCulateOutParamEntry;
import kd.fi.calx.algox.CalCulateOutParams;
import kd.fi.calx.algox.CalOutDataRangeHolder;
import kd.fi.calx.algox.CostAccount;
import kd.fi.calx.algox.CostSubElement;
import kd.fi.calx.algox.DataInputFactory;
import kd.fi.calx.algox.ParamCache;
import kd.fi.calx.algox.accounttype.AccountTypeEnum;
import kd.fi.calx.algox.balance.BalanceCalculator;
import kd.fi.calx.algox.balance.BalanceSourceEnum;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.function.BuildCostRecordUpdateInfoFunction;
import kd.fi.calx.algox.function.CommonInfo;
import kd.fi.calx.algox.function.CostAdjustDeleteFunction;
import kd.fi.calx.algox.function.CostPriceSourceAvtCostRecordFunction;
import kd.fi.calx.algox.function.CostRecordUpdateCalFlagFunction;
import kd.fi.calx.algox.function.CostRecordUpdateFunction;
import kd.fi.calx.algox.function.FilterBalanceByCalRangeFunction;
import kd.fi.calx.algox.function.FilterInQueueFunction;
import kd.fi.calx.algox.function.FilterNoneQueue4EmptyFunction;
import kd.fi.calx.algox.function.FilterNoneQueue4NotEmptyFunction;
import kd.fi.calx.algox.function.FilterOutQueueFunction;
import kd.fi.calx.algox.function.GroupIdBakFunction;
import kd.fi.calx.algox.function.GroupRecordAggFunction;
import kd.fi.calx.algox.function.InAccountTypeFunction;
import kd.fi.calx.algox.function.MatchCalRangeFunction;
import kd.fi.calx.algox.function.NoneAccountTypeFunction;
import kd.fi.calx.algox.function.OutAccountTypeFunction;
import kd.fi.calx.algox.function.SubElementCostDealFunction;
import kd.fi.calx.algox.function.UncaluteAvtCostRecordFunction;
import kd.fi.calx.algox.helper.AcctGroupModelHelper;
import kd.fi.calx.algox.helper.BalanceInvokeHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CalServiceHelper;
import kd.fi.calx.algox.helper.CostAccountGroupRecordHelper;
import kd.fi.calx.algox.helper.CustomEventCallHelper;
import kd.fi.calx.algox.helper.FIFOPeriodDataCalculate;
import kd.fi.calx.algox.helper.GPAPrevCostAdjustHelper;
import kd.fi.calx.algox.helper.StopSyncSettingModifyHelper;
import kd.fi.calx.algox.matrix.CalOutByMatrixService;
import kd.fi.calx.algox.util.CommonUtils;
import kd.fi.calx.algox.util.DataSetUtil;
import org.apache.flink.util.SerializedThrowable;

public class CalculateOutService {
    private static final Log logger = LogFactory.getLog(CalculateOutService.class);
    private static final String DLOCK_KEY = "calx_calculateout#";
    private static final Long CHECKBEFORETASK_ID = 1228995490352290816L;
    private static final Long CHECKAFTERTASK_ID = 1234050040448761856L;
    public static final String WRITE_HEADID_SQL = "update t_cal_task set fresultparams_tag = ? where fid = ? ";
    private String checkStatus = "A";
    private String taskId;
    private DynamicObject progressInfo;
    private DynamicObject taskInfo;
    private Map<Long, DynamicObject> progressEntryMap = new HashMap<Long, DynamicObject>(16);
    private long startTime = 0L;
    private Integer BALUPDATE_BATCHSIZE = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.BALUPDATE_BATCHSIZE);
    private Integer COSTRECORDUPDATE_BATCHSIZE = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COSTRECORDUPDATE_BATCHSIZE);

    public CalculateOutService() {
    }

    public String getCheckStatus() {
        return this.checkStatus;
    }

    public CalculateOutService(String taskId) {
        this.taskId = taskId;
        this.taskInfo = BusinessDataServiceHelper.loadSingle((Object)taskId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_task"));
        QFilter q = new QFilter("taskid", "=", (Object)Long.valueOf(taskId));
        this.progressInfo = BusinessDataServiceHelper.loadSingle((String)"cal_progress", (String)"id,progress,entry.status,entry.time,entry.step,entry.errorinfo,entry.errorinfo_tag", (QFilter[])q.toArray());
        for (DynamicObject entry : this.progressInfo.getDynamicObjectCollection("entry")) {
            this.progressEntryMap.put(entry.getDynamicObject("step").getLong("id"), entry);
        }
    }

    public String calCulateOutAsync(CalCulateOutParams param) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        try {
            jobParams.put("param", JSONUtils.toString((Object)param));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        jobParams.put("taskid", this.taskId);
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97 \u64cd\u4f5c\u4eba: %1$s", (String)"CalculateOutCostPlugin_8", (String)"fi-calx-algox", (Object[])new Object[0]), RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEF93NS2PXT");
        job.setRunByLang(Lang.get());
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        return JobClient.dispatch((JobInfo)job);
    }

    public String calCulateOutAsync(CalCulateOutParams param, int batch, int size, String timestampStr) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        try {
            jobParams.put("param", JSONUtils.toString((Object)param));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        jobParams.put("taskid", this.taskId);
        JobInfo job = new JobInfo();
        String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u3010%1$s\u3011\u7b2c\u3010%2$s\u3011\u6279\uff0c\u64cd\u4f5c\u4eba:%3$s", (String)"CalculateOutCostPlugin_20", (String)"fi-calx-algox", (Object[])new Object[0]);
        OpName = String.format(OpName, timestampStr, batch + "/" + size, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setTaskDefineId("2TEF93NS2PXT");
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("calx");
        job.setTaskClassname("kd.fi.calx.formplugin.calculate.out.CalculateOutTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        job.setRunByLang(Lang.get());
        return JobClient.dispatch((JobInfo)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void calCulateOut(CalCulateOutParams param) throws KDBizException {
        Iterator t2;
        this.setOtherAcctNoCal(param);
        this.convertParamMatIds(param);
        this.startTime = System.currentTimeMillis();
        this.setProgress(10, 0L, 0L, null, 1047020178682303488L);
        CalOutDataRangeHolder holder = null;
        CommonInfo commonInfo = null;
        Map runningModeMap = param.getRunningModeMap();
        ArrayList<DLock> lockList = new ArrayList<DLock>(16);
        ArrayList<String> lockStrings = new ArrayList<String>(16);
        IAppCache calCache = AppCache.get((String)"cal");
        String userName = RequestContext.get().getUserName();
        try {
            try {
                if (!param.isSubTask()) {
                    CostAccountGroupRecordHelper.refreshGroupRecordByTime();
                    this.rebuildDomainAndSort();
                }
                holder = new CalOutDataRangeHolder(param);
                Set costAccountIds = holder.getCostAccountSet();
                commonInfo = this.buildCommonInfo(param, holder);
                this.setProgress(15);
                if (!param.isSubTask()) {
                    Map<Long, String> runningTaskCostAccountMap = this.getRunningTaskCostAccountIds();
                    for (Long costAccountId : costAccountIds) {
                        String lockKey = DLOCK_KEY + costAccountId;
                        DLock lock = DLock.create((String)lockKey);
                        lockList.add(lock);
                        String useName = null;
                        if (!lock.tryLock()) {
                            useName = (String)calCache.get(lockKey, String.class);
                        }
                        if (runningTaskCostAccountMap.get(costAccountId) != null) {
                            useName = runningTaskCostAccountMap.get(costAccountId);
                        }
                        if (useName != null) {
                            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalculateOutService_5", (String)"fi-calx-algox", (Object[])new Object[0]), ((CostAccount)holder.getCostAccountMap().get(costAccountId)).getCostAccountName());
                            throw new KDBizException(msg);
                        }
                        lockStrings.add(lockKey);
                        calCache.put(lockKey, (Object)userName);
                    }
                    this.addLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                }
            }
            catch (KDBizException e) {
                this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage((Throwable)e), 0L);
                throw e;
            }
            catch (Throwable t2) {
                logger.error("\u51fa\u5e93\u6838\u7b97\u51fa\u73b0\u5f02\u5e38", t2);
                this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage((Throwable)t2), 0L);
                throw t2;
            }
            this.doCalculateOut(param, holder, commonInfo);
        }
        catch (Throwable throwable) {
            Iterator iterator;
            try {
                if (!param.isSubTask() && holder != null) {
                    this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
                }
                iterator = lockList.iterator();
            }
            catch (Throwable throwable2) {
                for (DLock lock : lockList) {
                    lock.close();
                }
                for (String lockString : lockStrings) {
                    calCache.remove(lockString);
                }
                this.setProgress(100);
                if (this.taskInfo == null) throw throwable2;
                this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
                this.taskInfo.set("status", (Object)"A");
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
                    throw throwable2;
                }
            }
            while (iterator.hasNext()) {
                DLock lock = (DLock)iterator.next();
                lock.close();
            }
            for (String lockString : lockStrings) {
                calCache.remove(lockString);
            }
            this.setProgress(100);
            if (this.taskInfo != null) {
                this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
                this.taskInfo.set("status", (Object)"A");
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
                }
            }
            Algo.closeAllDataSet();
            throw throwable;
        }
        try {
            if (!param.isSubTask() && holder != null) {
                this.releaseLock(runningModeMap, holder.getCalorgMapPeriod().keySet());
            }
            t2 = lockList.iterator();
        }
        catch (Throwable throwable) {
            for (DLock lock : lockList) {
                lock.close();
            }
            for (String lockString : lockStrings) {
                calCache.remove(lockString);
            }
            this.setProgress(100);
            if (this.taskInfo == null) throw throwable;
            this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
            this.taskInfo.set("status", (Object)"A");
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
                throw throwable;
            }
        }
        while (t2.hasNext()) {
            DLock lock = (DLock)t2.next();
            lock.close();
        }
        for (String lockString : lockStrings) {
            calCache.remove(lockString);
        }
        this.setProgress(100);
        if (this.taskInfo != null) {
            this.taskInfo.set("endtime", (Object)TimeServiceHelper.now());
            this.taskInfo.set("status", (Object)"A");
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.taskInfo});
            }
        }
        Algo.closeAllDataSet();
    }

    private void rebuildDomainAndSort() {
        Boolean isRebuildDomain = CalDbParamServiceHelper.getBoolean((String)"cal_out_rebuild_domain");
        if (!isRebuildDomain.booleanValue()) {
            return;
        }
        DynamicObject domainGroupDyc = QueryServiceHelper.queryOne((String)"cal_costdomaingroup", (String)"id", null);
        if (domainGroupDyc == null) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        Object[] ids = new Object[]{domainGroupDyc.getLong("id")};
        String key = "calout-rebuildDomainAndSort" + CacheKeyUtil.getAcctId();
        try (DLock lock = DLock.create((String)key, (String)"fi-calout-rebuildDomainAndSort-dlock");){
            lock.lock();
            OperationServiceHelper.executeOperate((String)"rebuildalldomain", (String)"cal_costdomaingroup", (Object[])ids, (OperateOption)option);
        }
    }

    private Map<Long, String> getRunningTaskCostAccountIds() {
        DynamicObject[] allMainTasks;
        HashMap<Long, String> runningTaskCostAccountIdMap = new HashMap<Long, String>(16);
        Calendar now = Calendar.getInstance();
        now.set(5, now.get(5) - 1);
        QFilter mainTaskFilter = new QFilter("ismaintask", "=", (Object)"1");
        mainTaskFilter.and("starttime", ">", (Object)now.getTime());
        mainTaskFilter.and("status", "=", (Object)"B");
        mainTaskFilter.and("tasktype", "=", (Object)"A");
        for (DynamicObject mainTask : allMainTasks = BusinessDataServiceHelper.load((String)"cal_task", (String)"id,calnumber,params_tag,creator.name", (QFilter[])mainTaskFilter.toArray())) {
            String params = mainTask.getString("params_tag");
            try {
                CalCulateOutParams runningParam = (CalCulateOutParams)kd.bos.util.JSONUtils.cast((String)params, CalCulateOutParams.class);
                Long runnintCostAccountId = ((CalCulateOutParamEntry)runningParam.getEntrys().values().iterator().next()).getCostAccountId();
                runningTaskCostAccountIdMap.put(runnintCostAccountId, mainTask.getString("creator.name"));
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u8fd0\u884c\u4e2d\u7684\u51fa\u5e93\u6838\u7b97\u4efb\u52a1\u6210\u672c\u8d26\u7c3f\u53cd\u5e8f\u5217\u5316\u9519\u8bef", (Throwable)e);
            }
        }
        return runningTaskCostAccountIdMap;
    }

    private void addLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet(), true);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet(), true);
        }
    }

    private void releaseLock(Map<String, Integer> runningModeMap, Set<Long> calOrgIdSet) {
        if (runningModeMap.get(AccountTypeEnum.MOVEDAVG_INTIME.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.MOVEDAVG_INTIME.getValue(), null, new HashSet(), false);
        }
        if (runningModeMap.get(AccountTypeEnum.FIFO.getValue()) != 0) {
            new StopSyncSettingModifyHelper().modifySetting(calOrgIdSet, null, AccountTypeEnum.FIFO.getValue(), null, new HashSet(), false);
        }
    }

    private void doCalculateOut(CalCulateOutParams param, CalOutDataRangeHolder holder, CommonInfo commonInfo) {
        if (param.getCheckItems().get("D") == null) {
            this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, null, 1043473988375819264L);
        } else {
            this.setProgress(20, 1047020178682303488L, System.currentTimeMillis() - this.startTime, null, 1229515981550833664L);
            this.startTime = System.currentTimeMillis();
            try {
                boolean voucherdutweightedavgat = commonInfo.isVoucherdutweightedavgat();
                Map<String, Map<Integer, Object>> calOutRangeMap = this.getCalOutRangeMap(holder, voucherdutweightedavgat);
                this.taskId = this.taskId == null ? String.valueOf(DB.genLongId((String)"t_cal_task")) : this.taskId;
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalOutDataCheckService", (String)"doCalOutDataCheck", (Object[])new Object[]{calOutRangeMap, param.getCheckItems().get("D"), this.taskId, CHECKBEFORETASK_ID});
                this.checkStatus = this.getCheckStatus(CHECKBEFORETASK_ID);
                if (!"A".equals(this.checkStatus) && !"E".equals(this.checkStatus)) {
                    this.setProgress(50, 1229515981550833664L, System.currentTimeMillis() - this.startTime, "fail", 0L);
                    return;
                }
                this.setProgress(50, 1229515981550833664L, System.currentTimeMillis() - this.startTime, null, 1043473988375819264L);
                this.setProgressStatus(1229515981550833664L, this.checkStatus);
            }
            catch (Exception e) {
                this.setProgress(50, 1229515981550833664L, System.currentTimeMillis() - this.startTime, "fail", 0L);
                logger.info("\u51fa\u5e93\u6838\u7b97(\u524d)\u6267\u884c\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u51fa\u9519:" + e.toString());
                return;
            }
        }
        this.startTime = System.currentTimeMillis();
        if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.FIFO.getValue())) {
            this.calFIFOBalBegin(holder);
        }
        if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.FIN_FOUT_PERIOD.getValue())) {
            this.calFIFOPeriodBalBegin(holder);
        }
        if (param.isInvockCostprice4Rework() && commonInfo.enableRework()) {
            commonInfo.invockCostprice4Rework(param);
        }
        JobSession session = AlgoX.createSession((String)"kd.fi.calx.algox.CalculateOutService");
        String calcModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.CALCULATEOUT_MODEL, null);
        String resultId = null;
        DataInputFactory factory = null;
        CalOutByMatrixService calMatrixService = null;
        if (!param.getMatrix() && "A".equals(calcModel)) {
            resultId = this.calculateByNomal(param, holder, commonInfo, session, factory);
        } else {
            try {
                calMatrixService = new CalOutByMatrixService(param, holder, commonInfo);
                resultId = calMatrixService.calCulateOut(param, holder, session);
            }
            catch (Exception e) {
                this.setProgress(55, 1043473988375819264L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage((Throwable)e), 0L);
                throw e;
            }
        }
        try {
            this.setProgress(55, 1043473988375819264L, System.currentTimeMillis() - this.startTime, null, 1043474328139609088L);
            logger.info("\u51fa\u5e93\u6838\u7b97\u53d6\u6570\u4ee5\u53ca\u5206\u5e03\u5f0f\u8ba1\u7b97\u62d3\u6251\u7ed3\u6784\u6784\u5efa\u8017\u65f6:" + (System.currentTimeMillis() - this.startTime));
            this.startTime = System.currentTimeMillis();
            try {
                session.commit(10, TimeUnit.HOURS);
                logger.info("\u51fa\u5e93\u6838\u7b97\u5206\u5e03\u5f0f\u8ba1\u7b97\u8017\u65f6:" + (System.currentTimeMillis() - this.startTime));
                if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_BAL).booleanValue()) {
                    this.callBalReCal(holder);
                }
            }
            catch (Exception e) {
                this.setProgress(80, 1043474328139609088L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage((Throwable)e), 0L);
                throw e;
            }
            finally {
                if (factory != null) {
                    factory.closeBizGroup();
                }
                if (calMatrixService != null) {
                    calMatrixService.close();
                }
            }
            this.setProgress(80, 1043474328139609088L, System.currentTimeMillis() - this.startTime, null, 1043474456359482368L);
            this.startTime = System.currentTimeMillis();
            try {
                Integer maxSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.COST_UPDATE_NOTICE_OPENDETAIL_COUNT);
                boolean isDetail = true;
                Set<String> salOutBillNums = CalculateOutService.getSalOutBillNums();
                HashSet<Long> recordIds = new HashSet<Long>(10000);
                DataSet recordEntryIdSet = session.readDataSet(resultId);
                HashSet<Long> entryIdSet = new HashSet<Long>(16);
                HashSet<Long> headIdSet = new HashSet<Long>(16);
                ArrayList fieldList = new ArrayList(20);
                Collections.addAll(fieldList, recordEntryIdSet.getRowMeta().getFieldNames());
                for (Row row : recordEntryIdSet) {
                    String billTypeNum = row.getString("billtypenum");
                    if (recordIds.size() > maxSize) {
                        isDetail = false;
                    }
                    entryIdSet.add(row.getLong("entryid"));
                    if (fieldList.contains("headid")) {
                        if (salOutBillNums.contains(billTypeNum)) {
                            recordIds.add(row.getLong("headid"));
                        }
                        headIdSet.add(row.getLong("headid"));
                        continue;
                    }
                    if (salOutBillNums.contains(billTypeNum)) {
                        recordIds.add(row.getLong("id"));
                    }
                    headIdSet.add(row.getLong("id"));
                }
                CustomEventCallHelper.calDeliveryAccEventCall((CalOutDataRangeHolder)holder, (boolean)isDetail, recordIds);
                if (!headIdSet.isEmpty() && !entryIdSet.isEmpty()) {
                    HashSet<Long> partSet;
                    boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
                    if (isNewBalance && param.isSubTask()) {
                        try {
                            String str = JSONUtils.toString(headIdSet);
                            DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)WRITE_HEADID_SQL, (Object[])new Object[]{str, Long.valueOf(this.taskId)});
                        }
                        catch (IOException e) {
                            throw new KDBizException(e.getMessage());
                        }
                    } else if (isNewBalance && !param.isSubTask()) {
                        partSet = new HashSet<Long>(this.BALUPDATE_BATCHSIZE);
                        for (Long id : headIdSet) {
                            partSet.add(id);
                            if (partSet.size() < this.BALUPDATE_BATCHSIZE) continue;
                            new BalanceInvokeHelper().updateBalance(partSet, BalanceSourceEnum.CAL_OUTCOST);
                            partSet.clear();
                        }
                        if (!partSet.isEmpty()) {
                            new BalanceInvokeHelper().updateBalance(partSet, BalanceSourceEnum.CAL_OUTCOST);
                        }
                    } else if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_BAL).booleanValue()) {
                        partSet = new HashSet(this.BALUPDATE_BATCHSIZE);
                        for (Long id : entryIdSet) {
                            partSet.add(id);
                            if (partSet.size() < this.BALUPDATE_BATCHSIZE) continue;
                            commonInfo.getBalanceCalculator().updateBalance4Others(partSet.toArray(), BalanceSourceEnum.CAL_OUTCOST);
                            partSet.clear();
                        }
                        if (!partSet.isEmpty()) {
                            commonInfo.getBalanceCalculator().updateBalance4Others(partSet.toArray(), BalanceSourceEnum.CAL_OUTCOST);
                        }
                    }
                }
                logger.info("\u51fa\u5e93\u6838\u7b97\u4f59\u989d\u66f4\u65b0\u5171" + entryIdSet.size() + "\u6761\u8bb0\u5f55\uff0c\u8017\u65f6:" + (System.currentTimeMillis() - this.startTime));
            }
            catch (Exception e) {
                this.setProgress(95, 1043474456359482368L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage((Throwable)e), 0L);
                throw e;
            }
        }
        catch (AlgoException e) {
            this.analysisException(e);
        }
        if (param.getCheckItems().get("E") == null) {
            this.setProgress(100, 1043474456359482368L, System.currentTimeMillis() - this.startTime, null, 0L);
        } else {
            this.setProgress(95, 1043474456359482368L, System.currentTimeMillis() - this.startTime, null, 1234070852702711808L);
            this.startTime = System.currentTimeMillis();
            try {
                boolean voucherdutweightedavgat = commonInfo.isVoucherdutweightedavgat();
                Map<String, Map<Integer, Object>> calOutRangeMap = this.getCalOutRangeMap(holder, voucherdutweightedavgat);
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalOutDataCheckService", (String)"doCalOutDataCheck", (Object[])new Object[]{calOutRangeMap, param.getCheckItems().get("E"), this.taskId, CHECKAFTERTASK_ID});
                String afterCheckStatus = this.getCheckStatus(CHECKAFTERTASK_ID);
                if ("A".equals(afterCheckStatus) || "E".equals(afterCheckStatus)) {
                    this.setProgress(100, 1234070852702711808L, System.currentTimeMillis() - this.startTime, null, 0L);
                    this.setProgressStatus(1234070852702711808L, afterCheckStatus);
                } else {
                    this.setProgress(100, 1234070852702711808L, System.currentTimeMillis() - this.startTime, "fail", 0L);
                }
            }
            catch (Exception e) {
                this.setProgress(100, 1234070852702711808L, System.currentTimeMillis() - this.startTime, "fail", 0L);
                logger.info("\u51fa\u5e93\u6838\u7b97\uff08\u540e\uff09\u6267\u884c\u68c0\u67e5\u9879\u5fae\u670d\u52a1\u51fa\u9519:", (Object)e);
            }
        }
    }

    private String calculateByNomal(CalCulateOutParams param, CalOutDataRangeHolder holder, CommonInfo commonInfo, JobSession session, DataInputFactory factory) {
        String resultId = null;
        factory = new DataInputFactory(holder, param);
        try {
            if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.WEIGHTAVG.getValue()) || 0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.SPPRICE.getValue())) {
                GPAPrevCostAdjustHelper costAdjustHelper = new GPAPrevCostAdjustHelper();
                costAdjustHelper.dealOutAdjustGpa(holder);
            }
            if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.FIN_FOUT_PERIOD.getValue())) {
                this.handlePreCostAdjustBill(holder);
            }
            Map elementMap = commonInfo.getElementMap();
            DataSetX costAdjustBizData = session.fromInput(factory.createCostAdjustBizDataInput());
            costAdjustBizData = costAdjustBizData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(costAdjustBizData.getRowMeta(), elementMap));
            costAdjustBizData = costAdjustBizData.addFields(new Field[]{new Field("groupid", (DataType)DataType.StringType), new Field("grouptype", (DataType)DataType.StringType)}, new Object[]{"0", "0"});
            DataSetX groupBillCostAdjustData = costAdjustBizData.filter("createtype in ('F','N','B-A2') or (createtype = 'V' and accounttype = 'C')");
            groupBillCostAdjustData = groupBillCostAdjustData.groupBy(new String[]{"id"}).reduceGroup((GroupReduceFunction)new CostAdjustDeleteFunction(groupBillCostAdjustData.getRowMeta(), commonInfo.getBalanceCalculator(), commonInfo.getRunningModeMap()));
            costAdjustBizData = costAdjustBizData.filter("createtype not in ('F','N','B-A2') and (createtype != 'V' or accounttype != 'C') and billstatus = 'C'");
            DataSetX costRecordBizData = session.fromInput(factory.createCostRecordBizDataInput(null));
            costRecordBizData = costRecordBizData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(costRecordBizData.getRowMeta(), elementMap));
            DataSetX billGroupRecordData = session.fromInput(factory.createBillGroupInput());
            costRecordBizData = costRecordBizData.leftJoin(billGroupRecordData).on("entryid", "groupentryid").select(DataSetUtil.getAllFieldStr((DataSetX)costRecordBizData), new String[]{"groupid", "grouptype"});
            DataSetX balanceBizData = session.fromInput(factory.createBalanceBizDataInput());
            String[] groupFields = new String[]{"entryid", "periodid"};
            RowMeta balMeta = balanceBizData.getRowMeta();
            SubElementCostDealFunction func = new SubElementCostDealFunction(balMeta, elementMap);
            if (CalBalanceModelHelper.isNewBalance()) {
                groupFields = (CalBalanceModelHelper.getDimFields((boolean)false) + ",periodid").split(",");
                balMeta = factory.getBizDataMeta();
                func = new SubElementCostDealFunction(balMeta, balanceBizData.getRowMeta(), elementMap);
            }
            balanceBizData = balanceBizData.groupBy(groupFields).reduceGroup((GroupReduceFunction)func);
            balanceBizData = balanceBizData.addFields(new Field[]{new Field("groupid", (DataType)DataType.StringType), new Field("grouptype", (DataType)DataType.StringType)}, new Object[]{"0", "0"});
            DataSetX allData = costRecordBizData.union(costAdjustBizData).union(balanceBizData);
            boolean hasFifo = false;
            DataSetX fifoBalData = null;
            if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.FIFO.getValue())) {
                hasFifo = true;
                fifoBalData = session.fromInput(factory.createFIFOBalDataInput());
            }
            if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.FIN_FOUT_PERIOD.getValue())) {
                hasFifo = true;
                fifoBalData = fifoBalData == null ? session.fromInput(factory.createFIFOPeriodBalDataInput()) : fifoBalData.union(session.fromInput(factory.createFIFOPeriodBalDataInput()));
            }
            if (hasFifo) {
                fifoBalData = fifoBalData.groupBy(new String[]{"entryid", "periodid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(fifoBalData.getRowMeta(), elementMap));
                fifoBalData = fifoBalData.addFields(new Field[]{new Field("groupid", (DataType)DataType.StringType), new Field("grouptype", (DataType)DataType.StringType)}, new Object[]{"0", "0"});
                allData = allData.union(fifoBalData);
                DataSetX ancestorDataSet = session.fromInput(factory.createCostRecordChildDataInput());
                allData = allData.leftJoin(ancestorDataSet).on("costrecordentryid", "entryid").select(DataSetUtil.getAllFieldStr((DataSetX)allData), new String[]{"ancestorentryid"});
            }
            DataSetX materialGroupNoSet = session.fromInput(factory.createMaterialGroupNoInput());
            allData = allData.leftJoin(materialGroupNoSet).on("material", "material").select(DataSetUtil.getAllFieldStr((DataSetX)allData), new String[]{"materialGroupNo"});
            allData = allData.flatMap((FlatMapFunction)new MatchCalRangeFunction(allData.getRowMeta(), holder.getCostAccountMap()));
            allData = allData.filter((FilterFunction)new FilterBalanceByCalRangeFunction(allData.getRowMeta(), holder.getCalOutRangeList()));
            if (AcctGroupModelHelper.isNewGroupModel()) {
                DataSetX inMaterialSeqSet = session.fromInput(factory.createInMaterialSeqInput());
                allData = allData.leftJoin(inMaterialSeqSet).on("material", "material").on("costaccount", "costaccount").on("calRange", "calrange").on("divideBasisStr", "divideBasisStr").on("divideBasisValue", "divideBasisValue").on("calDimensionStr", "calDimensionStr").on("calDimensionValue", "calDimensionValue").select(DataSetUtil.getAllFieldStr((DataSetX)allData), new String[]{"groupno", "groupseq", "sortlistid", "ingroupseq"});
            } else {
                DataSetX outMaterialSeqSet = session.fromInput(factory.createOutSortInput());
                allData = allData.leftJoin(outMaterialSeqSet).on("material", "material").on("costaccount", "costaccount").on("calRange", "calrange").select(DataSetUtil.getAllFieldStr((DataSetX)allData), new String[]{"groupno", "groupseq"});
                DataSetX inMaterialSeqSet = session.fromInput(factory.createInMaterialSeqInput());
                allData = allData.leftJoin(inMaterialSeqSet).on("material", "material").on("costaccount", "costaccount").on("calRange", "calrange").on("divideBasisStr", "divideBasisStr").on("divideBasisValue", "divideBasisValue").on("calDimensionStr", "calDimensionStr").on("calDimensionValue", "calDimensionValue").select(DataSetUtil.getAllFieldStr((DataSetX)allData), new String[]{"sortlistid", "ingroupseq"});
            }
            DataSetX billGroupRecordDataCopy = session.fromInput(factory.createBillGroupInput());
            DataSetX notSplitedAllData = session.fromInput(factory.createAllGroupData());
            notSplitedAllData = notSplitedAllData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(notSplitedAllData.getRowMeta(), elementMap));
            billGroupRecordDataCopy = billGroupRecordDataCopy.join(notSplitedAllData).on("groupentryid", "entryid").select(new String[]{"groupid", "costfields", "costcolumn", "iscompleted", "grouptype", "groupentryid", "groupweight", "groupoccupiedqty", "groupgroupno"}, this.getGroupBizFields(elementMap, notSplitedAllData.getRowMeta()));
            commonInfo.setGroupInfoRowMeta(billGroupRecordDataCopy.getRowMeta());
            billGroupRecordDataCopy = billGroupRecordDataCopy.groupBy(new String[]{"groupid"}).reduceGroup((GroupReduceFunction)new GroupRecordAggFunction(billGroupRecordDataCopy.getRowMeta()));
            String[] allFieldStr = DataSetUtil.getAllFieldStr((DataSetX)allData);
            DataSetX groupDataSetx = allData.filter("rowtype in ('1','2')");
            groupDataSetx = groupDataSetx.groupBy(new String[]{"groupid"}).reduceGroup((GroupReduceFunction)new GroupIdBakFunction(groupDataSetx.getRowMeta()));
            groupDataSetx = groupDataSetx.leftJoin(billGroupRecordDataCopy).on("groupidbak", "groupid").select(allFieldStr, new String[]{"groupinfovalues"});
            String billNoFilterStr = param.getBillNoFilterStr();
            if (0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.WEIGHTAVG.getValue()) || 0 != (Integer)param.getRunningModeMap().get(AccountTypeEnum.SPPRICE.getValue())) {
                groupDataSetx = groupDataSetx.map((MapFunction)new CostPriceSourceAvtCostRecordFunction(groupDataSetx.getRowMeta(), commonInfo));
                if (StringUtils.isNotEmpty((String)billNoFilterStr)) {
                    DataSetX unCalcostRecordBizData = session.fromInput(factory.createCostRecordBizDataInput(billNoFilterStr));
                    groupDataSetx = groupDataSetx.leftJoin(unCalcostRecordBizData).on("entryid", "entryid").select(groupDataSetx.getRowMeta().getFieldNames(), new String[]{"uncaluteentryname"});
                    groupDataSetx = groupDataSetx.map((MapFunction)new UncaluteAvtCostRecordFunction(groupDataSetx.getRowMeta()));
                }
            }
            DataSetX unGroupDataSetx = allData.filter("rowtype not in ('1','2')");
            unGroupDataSetx = StringUtils.isNotEmpty((String)billNoFilterStr) ? unGroupDataSetx.addFields(new Field[]{new Field("groupinfovalues", (DataType)DataType.StringType), new Field("uncaluteentryname", (DataType)DataType.StringType)}, new Object[]{" ", "0"}) : unGroupDataSetx.addFields(new Field[]{new Field("groupinfovalues", (DataType)DataType.StringType)}, new Object[]{" "});
            allData = groupDataSetx.union(unGroupDataSetx);
            DataSetX outQueueData = allData.filter((FilterFunction)new FilterOutQueueFunction(allData.getRowMeta()));
            outQueueData = outQueueData.groupBy(new String[]{"groupno"}).reduceGroup((GroupReduceFunction)new OutAccountTypeFunction(outQueueData.getRowMeta(), commonInfo, holder.getCostAccountMap()));
            DataSetX inQueueData = allData.filter((FilterFunction)new FilterInQueueFunction(allData.getRowMeta()));
            inQueueData = inQueueData.groupBy(new String[]{"sortlistid", "material", "costaccount", "periodid", "calRange"}).reduceGroup((GroupReduceFunction)new InAccountTypeFunction(inQueueData.getRowMeta(), commonInfo, holder.getCostAccountMap()));
            DataSetX noneQueueData4Empty = allData.filter((FilterFunction)new FilterNoneQueue4EmptyFunction(allData.getRowMeta()));
            noneQueueData4Empty = noneQueueData4Empty.groupBy(new String[]{"material", "costaccount", "periodid", "calRange", "divideBasisValue", "calDimensionValue"}).reduceGroup((GroupReduceFunction)new NoneAccountTypeFunction(noneQueueData4Empty.getRowMeta(), commonInfo, holder.getCostAccountMap()));
            DataSetX noneQueueData4NotEmpty = allData.filter((FilterFunction)new FilterNoneQueue4NotEmptyFunction(allData.getRowMeta()));
            noneQueueData4NotEmpty = noneQueueData4NotEmpty.groupBy(new String[]{"material", "costaccount", "periodid", "calRange", "calDimensionValue"}).reduceGroup((GroupReduceFunction)new NoneAccountTypeFunction(noneQueueData4NotEmpty.getRowMeta(), commonInfo, holder.getCostAccountMap()));
            DataSetX costUpdateData = inQueueData.union(outQueueData).union(noneQueueData4Empty).union(noneQueueData4NotEmpty);
            costUpdateData = costUpdateData.leftJoin(groupBillCostAdjustData).on("entryid", "id").select(costUpdateData.getRowMeta().getFieldNames(), new String[0]);
            DataSetX updateCalFlagData = costUpdateData.filter("iscalculated = true");
            updateCalFlagData = updateCalFlagData.groupBy(new String[]{"modvalue", "costAccount"}).reduceGroup((GroupReduceFunction)new CostRecordUpdateCalFlagFunction(updateCalFlagData.getRowMeta(), this.COSTRECORDUPDATE_BATCHSIZE));
            updateCalFlagData.output((Output)new IgnoreOutput());
            costUpdateData = costUpdateData.filter("iscalculated = false");
            DataSetX splitedAllData = session.fromInput(factory.createAllSplitData());
            splitedAllData = splitedAllData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new SubElementCostDealFunction(splitedAllData.getRowMeta(), elementMap));
            costUpdateData = costUpdateData.leftJoin(splitedAllData).on("entryid", "ancestorentryid").select(DataSetUtil.getAllFieldStr((DataSetX)costUpdateData), new String[]{"writeoffperiod", "writeoffendperiod", "writeoffstatus", "id childheadid", "entryid childid", "parentid parentid", "baseqty childbaseqty", "issplit childissplit", "isvoucher childisvoucher", "signnum groupsignnum", "materialcost childmaterialcost", "fee childfee", "processcost childprocesscost", "manufacturecost childmanufacturecost", "resource childresource", "ischargeoff childischargeoff", "ischargeoffed childischargeoffed"});
            costUpdateData = costUpdateData.groupBy(new String[]{"entryid"}).reduceGroup((GroupReduceFunction)new BuildCostRecordUpdateInfoFunction(costUpdateData.getRowMeta(), elementMap));
            RowMeta resultMeta = this.buildEntryIdMeta();
            costUpdateData = costUpdateData.groupBy(new String[]{"mod", "costAccount"}).reduceGroup((GroupReduceFunction)new CostRecordUpdateFunction(costUpdateData.getRowMeta(), resultMeta, this.COSTRECORDUPDATE_BATCHSIZE));
            DataSetOutput resultSet = new DataSetOutput(resultMeta);
            resultId = resultSet.getId();
            costUpdateData.output((Output)resultSet);
        }
        catch (Exception e) {
            this.setProgress(55, 1043473988375819264L, System.currentTimeMillis() - this.startTime, CommonUtils.getLogMessage((Throwable)e), 0L);
            throw e;
        }
        return resultId;
    }

    private String getCheckStatus(Long checkTaskId) {
        String checkStatus = "A";
        QFilter q = new QFilter("checkplan", "=", (Object)Long.parseLong(this.taskId));
        q.and("checktask", "=", (Object)checkTaskId);
        DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
        for (Row row : checkResultDataSet) {
            String result = row.getString("entryentity.entrystatus");
            if ("B".equals(result) || "C".equals(result)) {
                checkStatus = "B";
                break;
            }
            if (!"A".equals(result)) continue;
            checkStatus = "E";
        }
        return checkStatus;
    }

    private void callBalReCal(CalOutDataRangeHolder holder) {
        HashMap costAccountMatIDsMap = new HashMap(16);
        HashMap<Long, Long> costAccountPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, String> costAccountNumberMap = new HashMap<Long, String>(16);
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            Long l = range.getCostAccountId();
            if (costAccountPeriodMap.get(l) == null) {
                costAccountPeriodMap.put(l, range.getPeriodId());
            }
            List materialSetList = range.getMaterialSetList();
            HashSet<Long> matIds = new HashSet<Long>();
            if (materialSetList != null && !materialSetList.isEmpty()) {
                for (Set materialIdSet : range.getMaterialSetList()) {
                    for (Object materialId : materialIdSet) {
                        matIds.add((Long)materialId);
                    }
                }
            }
            if (costAccountMatIDsMap.get(l) == null) {
                costAccountMatIDsMap.put(l, matIds);
                continue;
            }
            ((Set)costAccountMatIDsMap.get(l)).addAll(matIds);
        }
        DynamicObject[] costAccounts = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id,number", (QFilter[])new QFilter("id", "in", costAccountMatIDsMap.keySet()).toArray());
        for (DynamicObject costAccount : costAccounts) {
            costAccountNumberMap.put(costAccount.getLong("id"), costAccount.getString("number"));
        }
        for (Map.Entry entry : costAccountMatIDsMap.entrySet()) {
            BalanceReCalParams reCalParam = new BalanceReCalParams();
            Long costAccountId = (Long)entry.getKey();
            HashSet<Long> costAccoutSet = new HashSet<Long>(16);
            costAccoutSet.add(costAccountId);
            reCalParam.setCostAccColl(costAccoutSet);
            reCalParam.setPeriod((Long)costAccountPeriodMap.get(costAccountId));
            reCalParam.setMaterialIdSet((Set)entry.getValue());
            HashMap<String, String> jobParams = new HashMap<String, String>();
            jobParams.put("param", SerializationUtils.toJsonString((Object)reCalParam));
            jobParams.put("taskid", this.taskId);
            JobInfo job = new JobInfo();
            String OpName = ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u3010%1$s\u3011\u8c03\u7528\u4f59\u989d\u91cd\u7b97\uff0c\u6210\u672c\u8d26\u7c3f\u7f16\u53f7\u3010%2$s\u3011", (String)"CalculateOutService_8", (String)"fi-calx-algox", (Object[])new Object[0]);
            OpName = String.format(OpName, this.taskId, costAccountNumberMap.get(costAccountId));
            job.setTaskDefineId("2TEDDALLDB2J");
            job.setName(OpName);
            job.setJobType(JobType.BIZ);
            job.setParams(jobParams);
            job.setAppId("cal");
            job.setTaskClassname("kd.fi.cal.formplugin.calculate.in.BalanceReCalTask");
            job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
            job.setRunByLang(Lang.get());
            JobClient.dispatch((JobInfo)job);
        }
    }

    private RowMeta buildEntryIdMeta() {
        Field[] resultFields = new Field[]{new Field("entryid", (DataType)DataType.LongType), new Field("headid", (DataType)DataType.LongType), new Field("billtypenum", (DataType)DataType.StringType)};
        return new RowMeta(resultFields);
    }

    private void analysisException(AlgoException e) {
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            SerializedThrowable st;
            Throwable kt;
            if (t instanceof SerializedThrowable && (kt = (st = (SerializedThrowable)t).deserializeError(null)) instanceof KDBizException) {
                throw (KDBizException)kt;
            }
            if (!(t instanceof KDBizException)) continue;
            throw (KDBizException)t;
        }
        throw e;
    }

    private ParamCache buildParamCache(CalOutDataRangeHolder holder) {
        ParamCache cache = new ParamCache();
        DynamicObjectCollection costAccountCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg,calpolicy.calbycostelement", null);
        HashSet<Long> calOrgIdSet = new HashSet<Long>(costAccountCol.size());
        HashMap<Long, Boolean> calByElementMap = new HashMap<Long, Boolean>(costAccountCol.size());
        for (DynamicObject costAccount : costAccountCol) {
            calOrgIdSet.add(costAccount.getLong("calorg"));
            calByElementMap.put(costAccount.getLong("id"), costAccount.getBoolean("calpolicy.calbycostelement"));
        }
        cache.setCostAccountCalbyElement(calByElementMap);
        cache.loadOrgParams(calOrgIdSet, new String[]{"iscyclebillcal", "creatediffbilltype", "diffrange"});
        Map costAccoumtMap = holder.getCostAccountMap();
        HashMap periodMap = new HashMap(costAccoumtMap.size());
        for (Map.Entry entry : costAccoumtMap.entrySet()) {
            CostAccount account = (CostAccount)entry.getValue();
            periodMap.put(entry.getKey(), account.getCurrentPeriod());
        }
        cache.setCostAccountPeriods(periodMap);
        return cache;
    }

    private String[] getGroupBizFields(Map<Long, CostSubElement> elementMap, RowMeta rowMeta) {
        ArrayList<String> fields = new ArrayList<String>(25 + elementMap.size());
        fields.add("periodid groupperiodid");
        fields.add("baseqty groupbaseqty");
        fields.add("queuetype groupqueuetype");
        fields.add("signnum groupsignnum");
        fields.add("localcurrency grouplocalcurrency");
        fields.add("exratetable groupexratetable");
        fields.add("convertmode groupconvertmode");
        fields.add("amtprecision groupamtprecision");
        fields.add("priceprecision grouppriceprecision");
        fields.add("isvoucher groupisvoucher");
        fields.add("actualcost groupactualcost");
        fields.add("materialcost groupmaterialcost");
        fields.add("fee groupfee");
        fields.add("processcost groupprocesscost");
        fields.add("manufacturecost groupmanufacturecost");
        fields.add("resource groupresource");
        fields.add("accounttype groupaccounttype");
        fields.add("iscalculated groupiscalculated");
        fields.add("calorg groupcalorg");
        fields.add("isinitbill groupisinitbill");
        fields.add("costaccount groupcostaccount");
        fields.add("isrework groupisrework");
        fields.add("bizentityobject groupbizentityobject");
        fields.add("issubbillinvoiceverify groupissubbillinvoiceverify");
        fields.add("id groupbillheadid");
        fields.add("invzerocost groupinvzerocost");
        fields.add("billno groupsrcbillno");
        fields.add("costpricesource groupcostpricesource");
        fields.add("designatedcost groupdesignatedcost");
        fields.add("ischargeoffed");
        fields.add("auditdate groupauditdate");
        int addPriceFieldIndex = rowMeta.getFieldIndex("addpricefield", false);
        if (addPriceFieldIndex > -1) {
            fields.add("addpricefield groupaddpricefield");
        }
        for (Long key : elementMap.keySet()) {
            fields.add(key + " group" + key);
        }
        return fields.toArray(fields.toArray(new String[fields.size()]));
    }

    /*
     * Exception decompiling
     */
    private Map<Long, CostSubElement> getElementMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void calFIFOBalBegin(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            long costAccountId = range.getCostAccountId();
            if (range.isAllMaterial()) {
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, null, new HashSet(1));
                cal.calculate();
                continue;
            }
            for (Set materialSet : range.getMaterialSetList()) {
                HashSet<Long> mSet = new HashSet<Long>(materialSet.size());
                for (Object id : materialSet) {
                    mSet.add(Long.valueOf(id.toString()));
                }
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, null, mSet);
                cal.calculate();
            }
        }
    }

    private void calFIFOPeriodBalBegin(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            long costAccountId = range.getCostAccountId();
            if (range.isAllMaterial()) {
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), new HashSet(1));
                cal.calFIFOPeriodBal();
                continue;
            }
            for (Set materialSet : range.getMaterialSetList()) {
                HashSet<Long> mSet = new HashSet<Long>(materialSet.size());
                for (Object id : materialSet) {
                    mSet.add(Long.valueOf(id.toString()));
                }
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), mSet);
                cal.calFIFOPeriodBal();
            }
        }
    }

    private void handlePreCostAdjustBill(CalOutDataRangeHolder holder) {
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            long costAccountId = range.getCostAccountId();
            if (range.isAllMaterial()) {
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), new HashSet(1));
                cal.handlePreCostAdjustBills();
                continue;
            }
            for (Set materialSet : range.getMaterialSetList()) {
                HashSet<Long> mSet = new HashSet<Long>(materialSet.size());
                for (Object id : materialSet) {
                    mSet.add(Long.valueOf(id.toString()));
                }
                FIFOPeriodDataCalculate cal = new FIFOPeriodDataCalculate(costAccountId, range.getCalRangeId(), mSet);
                cal.handlePreCostAdjustBills();
            }
        }
    }

    private CommonInfo buildCommonInfo(CalCulateOutParams param, CalOutDataRangeHolder holder) {
        CommonInfo commonInfo = new CommonInfo();
        commonInfo.setWriteRpt(param.isWriteRpt());
        commonInfo.setOnlyWriteErrRpt(param.isWriteErrRpt());
        commonInfo.setRunningModeMap(param.getRunningModeMap());
        commonInfo.setBalanceCalculator(new BalanceCalculator());
        commonInfo.setParamCache(this.buildParamCache(holder));
        commonInfo.setElementMap(this.getElementMap());
        commonInfo.setCalGroupCostImplClasses(this.getCalGroupCostClasses());
        commonInfo.setCalOutTime(TimeServiceHelper.now());
        commonInfo.setCalNumber(param.getCalNumber());
        commonInfo.setTaskId(this.taskId);
        commonInfo.setCostatenddateenable(param.isCostatenddateenable());
        commonInfo.setCostatenddate(param.getCostatenddate());
        commonInfo.setVoucherdutweightedavgat(param.isVoucherdutweightedavgat());
        commonInfo.setDesigoutweightedavgat(param.isDesigoutweightedavgat());
        commonInfo.setCoverdesigoutcost(param.isCoverdesigoutcost());
        commonInfo.setMatrix(param.getMatrix());
        return commonInfo;
    }

    private void setProgress(int progress) {
        if (this.progressInfo == null) {
            return;
        }
        this.progressInfo.set("progress", (Object)progress);
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.progressInfo});
        }
    }

    private void setProgress(int progress, long stepId, long time, String errInfo, long nextStepId) {
        if (this.progressInfo == null) {
            return;
        }
        this.progressInfo.set("progress", (Object)progress);
        if (stepId != 0L) {
            DynamicObject entry = this.progressEntryMap.get(stepId);
            entry.set("status", (Object)"A");
            entry.set("time", (Object)time);
            if (!StringUtils.isEmpty((String)errInfo)) {
                entry.set("errorinfo_tag", (Object)errInfo);
                entry.set("status", (Object)"B");
            }
        }
        if (nextStepId != 0L) {
            DynamicObject nextEntry = this.progressEntryMap.get(nextStepId);
            nextEntry.set("status", (Object)"C");
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.progressInfo});
        }
    }

    private void setProgressStatus(long stepId, String status) {
        if (this.progressInfo == null) {
            return;
        }
        if (stepId != 0L) {
            DynamicObject entry = this.progressEntryMap.get(stepId);
            entry.set("status", (Object)status);
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.progressInfo});
        }
    }

    private void setRangeMapValue(Map<String, Map<Integer, Object>> calOutRangeMap, String key, Object value, int index) {
        Map<Object, Object> dimMap;
        if (calOutRangeMap.get(key) == null) {
            dimMap = new HashMap(16);
            dimMap.put(index, value);
        } else {
            dimMap = calOutRangeMap.get(key);
            dimMap.put(index, value);
        }
        calOutRangeMap.put(key, dimMap);
    }

    private Map<String, Map<Integer, Object>> getCalOutRangeMap(CalOutDataRangeHolder holder, boolean voucherdutweightedavgat) {
        HashMap<String, Map<Integer, Object>> calOutRangeMap = new HashMap<String, Map<Integer, Object>>(16);
        int index = 0;
        boolean isNeedCalculatedLater = holder.isNeedCalculatedLater();
        for (CalOutDataRangeHolder.CalOutRange range : holder.getCalOutRangeList()) {
            List materialSetList = range.getMaterialSetList();
            Long costAccountId = range.getCostAccountId();
            Long periodId = range.getPeriodId();
            Long crtPeriod = holder.getCurrentPeirod(costAccountId);
            if (crtPeriod.compareTo(periodId) != 0) continue;
            Long calOrgId = range.getCalOrgId();
            Long calRangeId = range.getCalRangeId();
            Date startDate = range.getStartDate();
            Date endDate = range.getEndDate();
            Integer period = range.getPeriod();
            boolean isAllMaterial = range.isAllMaterial();
            this.setRangeMapValue(calOutRangeMap, "materialSetListMap", materialSetList, index);
            this.setRangeMapValue(calOutRangeMap, "calOrgIdMap", calOrgId, index);
            this.setRangeMapValue(calOutRangeMap, "calRangeIdMap", calRangeId, index);
            this.setRangeMapValue(calOutRangeMap, "costAccountIdMap", costAccountId, index);
            this.setRangeMapValue(calOutRangeMap, "startDateMap", startDate, index);
            this.setRangeMapValue(calOutRangeMap, "endDateMap", endDate, index);
            this.setRangeMapValue(calOutRangeMap, "periodMap", period, index);
            this.setRangeMapValue(calOutRangeMap, "periodIdMap", periodId, index);
            this.setRangeMapValue(calOutRangeMap, "isAllMaterialMap", isAllMaterial, index);
            this.setRangeMapValue(calOutRangeMap, "isNeedCalculatedLaterMap", isNeedCalculatedLater, index);
            this.setRangeMapValue(calOutRangeMap, "voucherdutweightedavgat", voucherdutweightedavgat, index);
            ++index;
        }
        return calOutRangeMap;
    }

    private List<String> getCalGroupCostClasses() {
        String serviceType = "B";
        String actionName = "ADDAVERAG";
        List implClassList = CalServiceHelper.getServiceSetting((String)serviceType, (String)actionName);
        return implClassList;
    }

    private static Set<String> getSalOutBillNums() {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("status", "=", (Object)"C");
        filter.and("billformid", "=", (Object)"im_saloutbill");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{filter});
        return dynamicObjects.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
    }

    private void setOtherAcctNoCal(CalCulateOutParams param) {
        boolean isMatrix;
        String calcModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.CALCULATEOUT_MODEL, null);
        boolean bl = isMatrix = param.getMatrix() || "B".equals(calcModel);
        if (isMatrix) {
            Map runningModeMap = param.getRunningModeMap();
            for (Map.Entry entry : runningModeMap.entrySet()) {
                String key = (String)entry.getKey();
                if (AccountTypeEnum.WEIGHTAVG.getValue().equals(key) || AccountTypeEnum.SPPRICE.getValue().equals(key)) {
                    entry.setValue(1);
                    continue;
                }
                entry.setValue(0);
            }
        }
    }

    private void convertParamMatIds(CalCulateOutParams param) {
        if (param == null) {
            return;
        }
        for (CalCulateOutParamEntry paramEntry : param.getEntrys().values()) {
            if (paramEntry.getMaterialIdSet() == null) continue;
            HashSet<Long> materialIDs = new HashSet<Long>();
            for (Object materialid : paramEntry.getMaterialIdSet()) {
                if (materialid instanceof Integer) {
                    materialIDs.add(Long.parseLong(materialid.toString()));
                    continue;
                }
                materialIDs.add((Long)materialid);
            }
            paramEntry.setMaterialIdSet(materialIDs);
        }
    }
}

