/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.calx.algox.diff;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.calx.algox.constant.CalDbParamConstant;
import kd.fi.calx.algox.diff.DiffAllocDataFactory;
import kd.fi.calx.algox.diff.DiffAllocParamter;
import kd.fi.calx.algox.diff.DiffAllocParamterEntry;
import kd.fi.calx.algox.diff.DiffAllocResultInfo;
import kd.fi.calx.algox.diff.DiffRateCalcService;
import kd.fi.calx.algox.diff.LinearEquationsDataFactory;
import kd.fi.calx.algox.diff.function.DealAllocOutTailDiffFunction;
import kd.fi.calx.algox.diff.function.DealCostDomainByOthBillFunction;
import kd.fi.calx.algox.diff.function.DealCostDomainFunction;
import kd.fi.calx.algox.diff.function.DealFinalStdBillCreateFunction;
import kd.fi.calx.algox.diff.function.DealGenDiffAllocRptFunction;
import kd.fi.calx.algox.diff.function.DealGenDiffBillFunction;
import kd.fi.calx.algox.diff.function.DealGroupTailDiffFunction;
import kd.fi.calx.algox.diff.function.DealGroupWeightFunction;
import kd.fi.calx.algox.diff.function.DealInBillToRowFunction;
import kd.fi.calx.algox.diff.function.DealStandCostDiffFunction;
import kd.fi.calx.algox.diff.function.DealStdBillCreateFunction;
import kd.fi.calx.algox.diff.function.DealTotalTailDiffFunction;
import kd.fi.calx.algox.diff.function.DiffAllocDebugFunction;
import kd.fi.calx.algox.diff.function.FilterByAllocDimValsFunction;
import kd.fi.calx.algox.diff.function.FilterByAllocDimValsFunctionNew;
import kd.fi.calx.algox.diff.function.TestFunction;
import kd.fi.calx.algox.diff.function.UpdateTotalTailDiffFunction;
import kd.fi.calx.algox.diff.helper.AllocRecordHelper;
import kd.fi.calx.algox.diff.helper.BalCheckHelper;
import kd.fi.calx.algox.diff.helper.DiffAllocHelper;
import kd.fi.calx.algox.diff.helper.ExFieldHelper;
import kd.fi.calx.algox.diff.helper.UnDiffAllocWizardCostAdjustHelper;
import kd.fi.calx.algox.diff.model.DealGenDiffParamService;
import kd.fi.calx.algox.helper.AcctGroupModelHelper;
import kd.fi.calx.algox.helper.CalBalanceModelHelper;
import kd.fi.calx.algox.helper.CalDbParamServiceHelper;
import kd.fi.calx.algox.helper.CostAccountGroupRecordHelper;
import kd.fi.calx.algox.helper.NegativeUnitPriceProcess;
import kd.fi.calx.algox.helper.ParamsHelper;
import kd.fi.calx.algox.helper.WhiteListHelper;
import kd.fi.calx.algox.util.ArrayUtils;

public class DiffAllocServiceNew {
    private static final Log logger = LogFactory.getLog(DiffAllocServiceNew.class);
    private static final String DLOCK_KEY = "settleaccount_cal";

    public void alloc(DiffAllocParamter param) {
        ArrayList<DLock> lockList = new ArrayList<DLock>(param.getEntityEntry().size());
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        param.setNewBalance(isNewBalance);
        try {
            if (!param.isParallel() || !param.isAllocByCostSys()) {
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":param.isParallel():" + param.isParallel() + ";param.isAllocByCostSys():" + param.isAllocByCostSys());
                for (Map.Entry entityEntry : param.getEntityEntry().entrySet()) {
                    DLock lock = DLock.create((String)(DLOCK_KEY + ((DiffAllocParamterEntry)entityEntry.getValue()).getCostAccountId()));
                    lockList.add(lock);
                    if (lock.tryLock()) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u5dee\u5f02\u5206\u644a\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DiffAllocService_3", (String)"fi-calx-algox", (Object[])new Object[0]), ((DiffAllocParamterEntry)entityEntry.getValue()).getCostAccountName());
                    throw new KDBizException(msg);
                }
            }
            for (Map.Entry entityEntry : param.getEntityEntry().entrySet()) {
                if (entityEntry.getValue() == null) {
                    logger.info("task's-currBatch:" + param.getBatchInfo() + ":param.entityEentry.isEmpty");
                    continue;
                }
                param.setEquationSetDims(CalDbParamServiceHelper.getString((String)CalDbParamConstant.EQUATION_DIMS, (String)((DiffAllocParamterEntry)entityEntry.getValue()).getCalOrgId().toString()));
                this.doAllocNew(param, (DiffAllocParamterEntry)entityEntry.getValue());
            }
            if (!param.isAllocByCostSys() && !AllocRecordHelper.isFail((DiffAllocParamter)param)) {
                AllocRecordHelper.updateAllocRecord((DiffAllocParamter)param, (String)"B");
            }
        }
        catch (KDBizException e) {
            logger.error("\u5dee\u5f02\u5206\u644a\u51fa\u73b0\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            AllocRecordHelper.updateAllocRecord((DiffAllocParamter)param, (String)"C");
            AllocRecordHelper.addAllocRecordEntry((DiffAllocParamter)param, (String)e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            logger.error("\u5dee\u5f02\u5206\u644a\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", e);
            if (!param.isAllocByCostSys() && !AllocRecordHelper.isFail((DiffAllocParamter)param)) {
                String logError = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u540e\u53f0\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"DiffAllocService_6", (String)"fi-calx-algox", (Object[])new Object[0]);
                logger.error(logError, e);
                AllocRecordHelper.updateAllocRecord((DiffAllocParamter)param, (String)"C");
                String error = ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAllocService_7", (String)"fi-calx-algox", (Object[])new Object[0]);
                AllocRecordHelper.addAllocRecordEntry((DiffAllocParamter)param, (String)error);
            }
            throw e;
        }
        finally {
            for (DLock lock : lockList) {
                if (lock == null) continue;
                lock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAllocNew(DiffAllocParamter param, DiffAllocParamterEntry paramEntry) {
        block17: {
            DiffAllocDataFactory dataFactory;
            if ((paramEntry.getAllocDimKeyCols() == null || paramEntry.getAllocDimKeyCols().isEmpty()) && param.isAllocByCostSys()) {
                logger.info(param.getBatchInfo() + ":paramEntry.getAllocDimKeyCols():" + paramEntry.getAllocDimKeyCols() + ",paramEntry.getAllocDimKeyCols().isEmpty():" + paramEntry.getAllocDimKeyCols().isEmpty());
                return;
            }
            BalCheckHelper.checkCalBalAndStdBalIsSame((DiffAllocParamter)param, (DiffAllocParamterEntry)paramEntry);
            Map entrys = param.getEntityEntry();
            HashSet<Long> costAccountIDs = new HashSet<Long>(entrys.size());
            for (Map.Entry entry : entrys.entrySet()) {
                costAccountIDs.add(((DiffAllocParamterEntry)entry.getValue()).getCostAccountId());
            }
            if (!param.isAllocByCostSys()) {
                if (!AcctGroupModelHelper.isNewGroupModel()) {
                    CostAccountGroupRecordHelper.refreshGroupRecordByTimeWithoutSort();
                    CostAccountGroupRecordHelper.refreshGroupRecordByBizRecordNoSort(costAccountIDs);
                }
                dataFactory = null;
                try {
                    DiffAllocResultInfo result;
                    DiffAllocResultInfo diffAllocResultInfo = result = param.isNewBalance() ? DiffAllocHelper.deleteAllocResultByNewBal((DiffAllocParamter)param, (DiffAllocParamterEntry)paramEntry) : DiffAllocHelper.deleteAllocResult((DiffAllocParamter)param, (DiffAllocParamterEntry)paramEntry, (DiffAllocDataFactory)dataFactory);
                    if (!result.isSuccess()) {
                        AllocRecordHelper.addAllocRecordEntry((DiffAllocParamter)param, (List)result.getError());
                        throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u4e0a\u6b21\u5206\u644a\u7ed3\u679c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6570\u636e\u3002", (String)"DiffAllocService_8", (String)"fi-calx-algox", (Object[])new Object[0]));
                    }
                    break block17;
                }
                finally {
                    if (dataFactory != null) {
                        dataFactory.closeBizGroup();
                    }
                }
            }
            dataFactory = null;
            try {
                dataFactory = new DiffAllocDataFactory(param, paramEntry);
                Long startTime = DiffAllocHelper.writeLogBegin((Log)logger, (String)"deal_CrossMonth_diff_bill_begin");
                Long startTime2 = System.currentTimeMillis();
                Set crossRecordEntryIds = dataFactory.getGenCrossMonthGroupBill();
                DiffAllocHelper.writeLogEnd((Log)logger, (String)"deal_CrossMonth_diff_bill_end", (Long)startTime);
                Long endTime = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":dataFactory.getGenCrossMonthGroupBill_time:" + (endTime - startTime2) + "ms");
                param.setCrossRecordEntryIds(new HashSet(crossRecordEntryIds));
            }
            finally {
                if (dataFactory != null) {
                    dataFactory.closeBizGroup();
                }
            }
        }
        Long startTime = DiffAllocHelper.writeLogBegin((Log)logger, (String)(param.getBatchInfo() + ":deal repairStdCost begin"));
        startTime = System.currentTimeMillis();
        this.repairStdCost(param);
        Long endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":repairStdCost:" + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        UnDiffAllocWizardCostAdjustHelper unAllHelper = new UnDiffAllocWizardCostAdjustHelper();
        unAllHelper.dealUnDiffAllocWizardCostAdjust(paramEntry, param);
        endTime = System.currentTimeMillis();
        logger.info("task's-currBatch:" + param.getBatchInfo() + ":dealUnDiffAlloc:" + (endTime - startTime) + "ms");
        DiffAllocDataFactory dataFactory = null;
        try {
            this.doAlloc(param, paramEntry, dataFactory);
        }
        finally {
            if (dataFactory != null) {
                dataFactory.closeBizGroup();
            }
        }
    }

    public void doAlloc(DiffAllocParamter param, DiffAllocParamterEntry paramEntry, DiffAllocDataFactory dataFactory) {
        Long startTime = DiffAllocHelper.writeLogBegin((Log)logger, (String)(param.getBatchInfo() + ":deal_doAlloc_begin"));
        logger.info(param.getBatchInfo() + ":doAlloc.param is null:" + (param == null));
        if (param != null) {
            JoinDataSetX selectDx;
            JoinDataSetX allDataJoinSetX;
            String groupfields;
            DataSetX outputDiffDataSetX;
            JoinDataSetX join;
            DataSetX totalDiffDataSetX;
            DataSetX qtyZeroDimsDx;
            HashSet matIds;
            String diffAllocDims;
            if (param.isCircle().booleanValue() || param.isRework().booleanValue()) {
                if (param.isCircle().booleanValue()) {
                    param.setEquationSetDims("costaccount");
                } else {
                    param.setEquationSetDims("costaccount,material");
                }
                String diffAllocDims2 = ParamsHelper.getAppParam((long)paramEntry.getCalOrgId(), (String)"diffalloccols").toString();
                if (!param.getAllocDims().contains("tracknumber") && diffAllocDims2.contains("tracknumber")) {
                    param.setAllocDims(param.getAllocDims() + ",tracknumber");
                }
                if (!param.getAllocDims().contains("material")) {
                    param.setAllocDims(param.getAllocDims() + ",material");
                }
            }
            String allDims = DiffAllocHelper.mergDiffAllocDims((String)param.getEquationSetDims(), (String)param.getAllocDims());
            dataFactory = new DiffAllocDataFactory(param, paramEntry);
            LinearEquationsDataFactory linearEquationsDataFactory = new LinearEquationsDataFactory(param, paramEntry);
            DiffRateCalcService rateService = new DiffRateCalcService(param, paramEntry, param.getCrossRecordEntryIds());
            Long startTime1 = System.currentTimeMillis();
            Map rateData = rateService.calcRate(param);
            Long endTime1 = System.currentTimeMillis();
            logger.info("task's-currBatch:" + param.getBatchInfo() + ":rateService.calcRate_time:" + (endTime1 - startTime1) + "ms");
            DealGenDiffParamService diffParamService = new DealGenDiffParamService(rateService.getPeriodOutputQtyMap(), rateService.getPeriodFixedOutputQtyMap(), rateService.getTransInQtyWithDmMap(), rateService.getPeriodIntputQtyMap(), rateService.getCrossPeriodOutputDiffMap(), rateService.getPeriodInputDiffMap(), rateService.getPeriodBeginDiffMap());
            DataSet calResultDataSet = null;
            if (!rateData.isEmpty()) {
                startTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":algox_task_begin:" + (endTime1 - startTime1) + "ms");
                JobSession session = AlgoX.createSession((String)("DiffAllocService_mainService\uff1a" + param.getBatchInfo()));
                DataSetX outBillDataSetX = session.fromInput(dataFactory.getOutBillQtyByOrmInput());
                outBillDataSetX = this.printDataSetX(outBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>outBillDataSetX");
                DataSetX fixDiffoutBillDataSetX = session.fromInput(dataFactory.getFixDiffOutBillEntryData());
                JoinDataSetX filtedOutBillDataSetX = outBillDataSetX.leftJoin(fixDiffoutBillDataSetX).on("outbillentryid", "fixDiffCostRecordEntryId").select(outBillDataSetX.getRowMeta().getFieldNames(), new String[]{"fixDiffCostRecordEntryId"});
                filtedOutBillDataSetX = this.printDataSetX((DataSetX)filtedOutBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>filtedOutBillDataSetX");
                filtedOutBillDataSetX = filtedOutBillDataSetX.filter((FilterFunction)new FilterByAllocDimValsFunction(filtedOutBillDataSetX.getRowMeta(), param, paramEntry, Boolean.FALSE));
                outBillDataSetX = filtedOutBillDataSetX.select(outBillDataSetX.getRowMeta().getFieldNames());
                outBillDataSetX = this.printDataSetX(outBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>outBillDataSetX2");
                DataSetX transOut_1ToIn_1DataSetX = session.fromInput((Input)new DataSetInput(linearEquationsDataFactory.getTransOutToIn_1(param.getCrossRecordEntryIds())));
                JoinDataSetX outBillJoinTransDataSetX = outBillDataSetX.leftJoin(transOut_1ToIn_1DataSetX).on("costrecordentryid", "in_1costrecordentryid").select(outBillDataSetX.getRowMeta().getFieldNames(), transOut_1ToIn_1DataSetX.getRowMeta().getFieldNames());
                outBillJoinTransDataSetX = this.printDataSetX((DataSetX)outBillJoinTransDataSetX, "DiffAllocServiceNew.doAlloc\u2014>outBillJoinTransDataSetX");
                DealCostDomainByOthBillFunction dealCostDomainByOthBillFunction = new DealCostDomainByOthBillFunction(outBillJoinTransDataSetX.getRowMeta(), param, rateData, outBillDataSetX.getRowMeta());
                outBillDataSetX = outBillJoinTransDataSetX.groupBy(new String[]{"costrecordentryid"}).reduceGroup((GroupReduceFunction)dealCostDomainByOthBillFunction);
                outBillDataSetX = this.printDataSetX(outBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>outBillDataSetX");
                DataSetX groupDataSetX = session.fromInput(dataFactory.getSrcGroupDataSet());
                groupDataSetX = groupDataSetX.distinct(groupDataSetX.getRowMeta().getFieldNames());
                groupDataSetX = this.printDataSetX(groupDataSetX, "DiffAllocServiceNew.doAlloc\u2014>groupDataSetX");
                DataSetX srcGroupDataSetX = groupDataSetX.filter("type = '0'");
                DataSetX targGroupDataSetX = groupDataSetX.filter("type = '1'");
                outBillDataSetX = outBillDataSetX.leftJoin(srcGroupDataSetX).on("outbillentryid", "calRecordEntryid").select(outBillDataSetX.getRowMeta().getFieldNames(), new String[]{"bizgrouprecordid", "calRecordEntryid", "iscompleted", "occupiedqty"});
                outBillDataSetX = this.printDataSetX(outBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>outBillDataSetX");
                DataSetX groupBillDataSetX = session.fromInput(dataFactory.getGroupBillDataSet());
                JoinDataSetX targBillDataSetX = groupBillDataSetX.join(targGroupDataSetX).on("gcostrecordentryid", "calRecordEntryid").select(groupBillDataSetX.getRowMeta().getFieldNames(), new String[]{"bizgrouprecordid", "weight", "totalweight"});
                targBillDataSetX = this.printDataSetX((DataSetX)targBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>targBillDataSetX");
                JoinDataSetX allBillDataSetX = outBillDataSetX.leftJoin((DataSetX)targBillDataSetX).on("bizgrouprecordid", "bizgrouprecordid").on("subelementid", "gsubelementid").select(outBillDataSetX.getRowMeta().getFieldNames(), (String[])ArrayUtils.concatAll((Object[])groupBillDataSetX.getRowMeta().getFieldNames(), (Object[][])new String[][]{{"weight", "totalweight"}}));
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX1");
                DealGroupWeightFunction dealGroupWeightFunction = new DealGroupWeightFunction(allBillDataSetX.getRowMeta());
                allBillDataSetX = allBillDataSetX.groupBy(new String[]{"costrecordentryid", "subelementid", "bizgrouprecordid"}).reduceGroup((GroupReduceFunction)dealGroupWeightFunction);
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX2");
                DealCostDomainFunction dealCostDomainFunction = new DealCostDomainFunction(allBillDataSetX.getRowMeta(), param, rateData);
                allBillDataSetX = allBillDataSetX.groupBy(new String[]{"costrecordentryid"}).reduceGroup((GroupReduceFunction)dealCostDomainFunction);
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX3");
                DealAllocOutTailDiffFunction dealAllocOutTailDiffFunction = new DealAllocOutTailDiffFunction(allBillDataSetX.getRowMeta(), param, rateData);
                String[] groupFields = (allDims + ",costDomain,subelementid").split(",");
                allBillDataSetX = allBillDataSetX.groupBy(groupFields).reduceGroup((GroupReduceFunction)dealAllocOutTailDiffFunction);
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX4");
                DealGroupTailDiffFunction dealGroupTailDiffFunction = new DealGroupTailDiffFunction(allBillDataSetX.getRowMeta());
                allBillDataSetX = allBillDataSetX.groupBy(new String[]{"costrecordentryid", "subelementid"}).reduceGroup((GroupReduceFunction)dealGroupTailDiffFunction);
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX5");
                DealGenDiffBillFunction dealGenDiffBillFunction = new DealGenDiffBillFunction(allBillDataSetX.getRowMeta(), dataFactory.getSubElementIds());
                ExFieldHelper exFieldHelper = new ExFieldHelper();
                dealGenDiffBillFunction.setEntityExInfos(exFieldHelper.getEntityExInfos("cal_costrecord_subentity"));
                allBillDataSetX = allBillDataSetX.groupBy(new String[]{"material"}).reduceGroup((GroupReduceFunction)dealGenDiffBillFunction);
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX6");
                DealInBillToRowFunction dealInBillToRowFunction = new DealInBillToRowFunction(allBillDataSetX.getRowMeta(), param, null, outBillDataSetX.getRowMeta());
                allBillDataSetX = allBillDataSetX.groupBy(new String[]{"material"}).reduceGroup((GroupReduceFunction)dealInBillToRowFunction);
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX7");
                if (param.isWriterpt()) {
                    DealGenDiffAllocRptFunction dealGenDiffAllocRptFunction = new DealGenDiffAllocRptFunction(allBillDataSetX.getRowMeta(), param, rateData, diffParamService);
                    String[] allocDims = DiffAllocHelper.mergDiffAllocDims((String)param.getAllocDims(), (String)param.getEquationSetDims()).split(",");
                    allBillDataSetX = allBillDataSetX.groupBy(allocDims).reduceGroup((GroupReduceFunction)dealGenDiffAllocRptFunction);
                }
                allBillDataSetX = this.printDataSetX((DataSetX)allBillDataSetX, "DiffAllocServiceNew.doAlloc\u2014>allBillDataSetX8");
                DataSetOutput resultSet = new DataSetOutput(this.buildOutputMeta());
                String resultId = resultSet.getId();
                allBillDataSetX.output((Output)resultSet);
                session.commit(2, TimeUnit.HOURS);
                calResultDataSet = session.readDataSet(resultId);
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":algox_task_time:" + (endTime1 - startTime1) + "ms");
            } else {
                Algo algo = Algo.create((String)"");
                calResultDataSet = algo.createDataSet(new ArrayList(), this.buildOutputMeta());
            }
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISDO_DEALTAILDIFF, (String)paramEntry.getCalOrgId().toString()).booleanValue() && !param.isCircle().booleanValue() && !param.isRework().booleanValue()) {
                startTime1 = System.currentTimeMillis();
                diffAllocDims = DiffAllocHelper.mergDiffAllocDims((String)param.getAllocDims(), (String)param.getEquationSetDims());
                if (!diffAllocDims.contains("material")) {
                    diffAllocDims = diffAllocDims + ",material";
                }
                JobSession session2 = AlgoX.createSession((String)("DiffAllocService_doTailDiff\uff1a" + param.getBatchInfo()));
                matIds = new HashSet(1000);
                qtyZeroDimsDx = session2.fromInput(dataFactory.getBalQtyIsZero(paramEntry, matIds));
                qtyZeroDimsDx = qtyZeroDimsDx.filter((FilterFunction)new FilterByAllocDimValsFunctionNew(qtyZeroDimsDx.getRowMeta(), param, paramEntry));
                totalDiffDataSetX = session2.fromInput(dataFactory.getTotalDiffData(paramEntry, matIds));
                join = totalDiffDataSetX.join(qtyZeroDimsDx);
                for (String[] field : diffAllocDims.split(",")) {
                    join.on((String)field, (String)field);
                }
                totalDiffDataSetX = join.select(totalDiffDataSetX.getRowMeta().getFieldNames());
                outputDiffDataSetX = session2.fromInput(dataFactory.getOutputDiffData(paramEntry, matIds));
                groupfields = diffAllocDims + ",costelement,costsubelement";
                allDataJoinSetX = totalDiffDataSetX.leftJoin(outputDiffDataSetX);
                for (String field : groupfields.split(",")) {
                    allDataJoinSetX.on(field, field);
                }
                selectDx = allDataJoinSetX.select(totalDiffDataSetX.getRowMeta().getFieldNames(), new String[]{"bizdate", "invbillentryid", "entryid", "createtype", "outddiff_g", "outddiff_h", "outddiff_k", "outddiff_p", "outddiff_q", "outddiff_r", "outddiff_m", "outddiff_s", "outddiff_t", "outddiff_w", "outddiff_x", "outddiff_y", "outddiff_c", "outddiff", "outdiff_g", "outdiff_h", "outdiff_k", "outdiff_p", "outdiff_q", "outdiff_r", "outdiff_m", "outdiff_s", "outdiff_t", "outdiff_w", "outdiff_x", "outdiff_y", "outdiff_c", "outdiff", "subentryentity", "gcostrecordentryid"});
                DataSetX allDataSetX = selectDx.filter("entryid is not null");
                DataSetX noOutDataSetX = selectDx.filter("entryid is null");
                Map billHeadData = dataFactory.buildStdHeadData(paramEntry, matIds);
                Date endDate = dataFactory.getEndDateByAccount(paramEntry);
                DealStdBillCreateFunction dealStdBillCreateFunction = new DealStdBillCreateFunction(noOutDataSetX.getRowMeta(), endDate, paramEntry.getPeriodId(), billHeadData, diffAllocDims);
                noOutDataSetX = noOutDataSetX.groupBy(diffAllocDims.split(",")).reduceGroup((GroupReduceFunction)dealStdBillCreateFunction);
                DealTotalTailDiffFunction dealTotalTailDiffFunction = new DealTotalTailDiffFunction(allDataJoinSetX.getRowMeta(), param, allDataJoinSetX.getRowMeta());
                DataSetX dealTotalTailDiffDataX = allDataSetX.groupBy(diffAllocDims.split(",")).reduceGroup((GroupReduceFunction)dealTotalTailDiffFunction);
                Iterator updateTotalTailDiffFunction = new UpdateTotalTailDiffFunction(dealTotalTailDiffDataX.getRowMeta(), param, dealTotalTailDiffDataX.getRowMeta());
                dealTotalTailDiffDataX = dealTotalTailDiffDataX.groupBy(new String[]{"mod"}).reduceGroup((GroupReduceFunction)updateTotalTailDiffFunction);
                DataSetOutput resultSet1 = new DataSetOutput(this.buildOutputMeta());
                dealTotalTailDiffDataX.output((Output)resultSet1);
                DataSetOutput resultSet2 = new DataSetOutput(DealStdBillCreateFunction.targetRowMeta);
                noOutDataSetX.output((Output)resultSet2);
                String stdId = resultSet2.getId();
                session2.commit(60, TimeUnit.MINUTES);
                DataSet dataSet = session2.readDataSet(stdId);
                for (Row row : dataSet) {
                    param.getStdBillIds().add(row.getLong("stdId"));
                }
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":DiffAllocService_doTailDiff:" + (endTime1 - startTime1) + "ms");
            }
            if (!param.isCircle().booleanValue() && !param.isRework().booleanValue() && CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISDO_FINAL_ADJUSTMENT, (String)paramEntry.getCalOrgId().toString()).booleanValue()) {
                startTime1 = System.currentTimeMillis();
                diffAllocDims = DiffAllocHelper.mergDiffAllocDims((String)param.getAllocDims(), (String)param.getEquationSetDims());
                if (!diffAllocDims.contains("material")) {
                    diffAllocDims = diffAllocDims + ",material";
                }
                JobSession session3 = AlgoX.createSession((String)("DiffAllocService_doFinalTailDiff\uff1a" + param.getBatchInfo()));
                matIds = new HashSet(1000);
                qtyZeroDimsDx = session3.fromInput(dataFactory.getBalQtyIsZero(paramEntry, matIds));
                qtyZeroDimsDx = qtyZeroDimsDx.filter((FilterFunction)new FilterByAllocDimValsFunctionNew(qtyZeroDimsDx.getRowMeta(), param, paramEntry));
                totalDiffDataSetX = session3.fromInput(dataFactory.getTotalDiffData(paramEntry, matIds));
                join = totalDiffDataSetX.join(qtyZeroDimsDx);
                for (String[] field : diffAllocDims.split(",")) {
                    join.on((String)field, (String)field);
                }
                totalDiffDataSetX = join.select(totalDiffDataSetX.getRowMeta().getFieldNames());
                outputDiffDataSetX = session3.fromInput(dataFactory.getOutputDiffData(paramEntry, matIds));
                groupfields = diffAllocDims + ",costelement,costsubelement";
                allDataJoinSetX = totalDiffDataSetX.leftJoin(outputDiffDataSetX);
                for (String field : groupfields.split(",")) {
                    allDataJoinSetX.on(field, field);
                }
                selectDx = allDataJoinSetX.select(totalDiffDataSetX.getRowMeta().getFieldNames(), new String[]{"bizdate", "invbillentryid", "entryid", "createtype", "outddiff_g", "outddiff_h", "outddiff_k", "outddiff_p", "outddiff_q", "outddiff_r", "outddiff_m", "outddiff_s", "outddiff_t", "outddiff_w", "outddiff_x", "outddiff_y", "outddiff_c", "outddiff", "outdiff_g", "outdiff_h", "outdiff_k", "outdiff_p", "outdiff_q", "outdiff_r", "outdiff_m", "outdiff_s", "outdiff_t", "outdiff_w", "outdiff_x", "outdiff_y", "outdiff_c", "outdiff", "subentryentity", "gcostrecordentryid"});
                DataSetX dataSetx = selectDx.filter("balqty == 0");
                Map billHeadData = dataFactory.buildStdHeadData(paramEntry, matIds);
                Date endDate = dataFactory.getEndDateByAccount(paramEntry);
                DealFinalStdBillCreateFunction dealFinalStdBillCreateFunction = new DealFinalStdBillCreateFunction(dataSetx.getRowMeta(), endDate, paramEntry.getPeriodId(), billHeadData, diffAllocDims);
                dataSetx = dataSetx.groupBy(diffAllocDims.split(",")).reduceGroup((GroupReduceFunction)dealFinalStdBillCreateFunction);
                DataSetOutput resultSet3 = new DataSetOutput(DealFinalStdBillCreateFunction.targetRowMeta);
                dataSetx.output((Output)resultSet3);
                String stdId = resultSet3.getId();
                session3.commit(60, TimeUnit.MINUTES);
                DataSet dataSet = session3.readDataSet(stdId);
                for (Row row : dataSet) {
                    param.getStdBillIds().add(row.getLong("stdId"));
                }
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":DiffAllocService_doFinalTailDiff:" + (endTime1 - startTime1) + "ms");
            }
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISDO_STANDCOSTADJUST, (String)paramEntry.getCalOrgId().toString()).booleanValue()) {
                startTime1 = System.currentTimeMillis();
                diffAllocDims = DiffAllocHelper.mergDiffAllocDims((String)param.getAllocDims(), (String)param.getEquationSetDims());
                if (!diffAllocDims.contains("material")) {
                    diffAllocDims = diffAllocDims + ",material";
                }
                JobSession session4 = AlgoX.createSession((String)("DiffAllocService_doStdCostTailDiff\uff1a" + param.getBatchInfo()));
                matIds = new HashSet(1000);
                qtyZeroDimsDx = session4.fromInput(dataFactory.getBalQtyIsZero(paramEntry, matIds));
                qtyZeroDimsDx = qtyZeroDimsDx.filter((FilterFunction)new FilterByAllocDimValsFunctionNew(qtyZeroDimsDx.getRowMeta(), param, paramEntry));
                String selectField = diffAllocDims + ",costelement,costsubelement,periodstandardcost,standardcost,sub_adjustamt";
                DataSet periodStandCost = dataFactory.getBalStandCost(paramEntry, matIds);
                periodStandCost = periodStandCost.addField("0.00", "standardcost").addField("0.00", "sub_adjustamt");
                periodStandCost = periodStandCost.select(selectField);
                DataSet recordStandCost = dataFactory.getCostRecordStdCost(paramEntry, matIds);
                recordStandCost = recordStandCost.addField("0.00", "periodstandardcost").addField("0.00", "sub_adjustamt");
                recordStandCost = recordStandCost.select(selectField);
                DataSet diffStandCost = dataFactory.getStandDiff(paramEntry, matIds);
                diffStandCost = diffStandCost.addField("0.00", "periodstandardcost").addField("0.00", "standardcost");
                diffStandCost = diffStandCost.select(selectField);
                DataSet allDataSet = periodStandCost.union(recordStandCost).union(diffStandCost).select(selectField);
                String groupDims = diffAllocDims + ",costelement,costsubelement";
                allDataSet = allDataSet.groupBy(groupDims.split(",")).sum("periodstandardcost").sum("standardcost").sum("sub_adjustamt").finish();
                ArrayList<DataSetInput> inputList = new ArrayList<DataSetInput>();
                inputList.add(new DataSetInput(allDataSet, allDataSet.getRowMeta()));
                DataSetX dataSetX = session4.fromInput(inputList.toArray(new Input[0]));
                JoinDataSetX dimsJoin = dataSetX.join(qtyZeroDimsDx);
                for (String field : diffAllocDims.split(",")) {
                    dimsJoin.on(field, field);
                }
                dataSetX = dimsJoin.select(dataSetX.getRowMeta().getFieldNames());
                Map billHeadData = dataFactory.buildStdHeadData(paramEntry, matIds);
                DynamicObject billType = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)paramEntry.getCalOrgId(), (Long)0L, (String)"costsumbilltype");
                if (billType == null) {
                    QFilter q = new QFilter("number", "=", (Object)"im_SalOutBill_STD_BT_S");
                    billType = QueryServiceHelper.queryOne((String)"bos_billtype", (String)"id", (QFilter[])q.toArray());
                }
                DealStandCostDiffFunction standCostDiffFunction = new DealStandCostDiffFunction(dataSetX.getRowMeta(), paramEntry.getEndDate(), paramEntry.getPeriodId(), billHeadData, diffAllocDims, Long.valueOf(billType.getLong("id")));
                dataSetX = dataSetX.groupBy(diffAllocDims.split(",")).reduceGroup((GroupReduceFunction)standCostDiffFunction);
                DataSetOutput resultSet4 = new DataSetOutput(DealStandCostDiffFunction.targetRowMeta);
                dataSetX.output((Output)resultSet4);
                String stdId = resultSet4.getId();
                session4.commit(60, TimeUnit.MINUTES);
                DataSet dataSet = session4.readDataSet(stdId);
                for (Row row : dataSet) {
                    param.getStdBillIds().add(row.getLong("stdId"));
                }
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":DiffAllocService_doStdCostTailDiff:" + (endTime1 - startTime1) + "ms");
            }
            if (!param.isCircle().booleanValue() && !param.isRework().booleanValue() && CalDbParamServiceHelper.getBoolean((String)"isdo_negative_unit_price", (String)paramEntry.getCalOrgId().toString()).booleanValue() && !param.getNegativeCalc().booleanValue()) {
                startTime1 = System.currentTimeMillis();
                Iterator negativeUnitPriceProcess = new NegativeUnitPriceProcess();
                paramEntry.setNegativeAllocDimKeyCols(paramEntry.getAllocDimKeyCols());
                negativeUnitPriceProcess.negativeUnitPriceDeal(param, paramEntry, "in");
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":DiffAllocService_doInNegativeUnitPrice:" + (endTime1 - startTime1) + "ms");
                if (param.isExeOutNegative()) {
                    startTime1 = System.currentTimeMillis();
                    negativeUnitPriceProcess.negativeUnitPriceDeal(param, paramEntry, "out");
                    endTime1 = System.currentTimeMillis();
                    logger.info("task's-currBatch:" + param.getBatchInfo() + ":DiffAllocService_doOutNegativeUnitPrice:" + (endTime1 - startTime1) + "ms");
                }
                param.setNegativeCalc(Boolean.valueOf(false));
            }
            if (CalDbParamServiceHelper.getBoolean((String)"isdo_negative_unit_price").booleanValue() && param.getNegativeCalc().booleanValue()) {
                for (Row row : calResultDataSet) {
                    Object stdcostDiffBillIdsStr = row.getString("stdcostdiffbillids");
                    if (stdcostDiffBillIdsStr == null || ((String)stdcostDiffBillIdsStr).isEmpty()) continue;
                    if (((String)stdcostDiffBillIdsStr).startsWith(",")) {
                        stdcostDiffBillIdsStr = ((String)stdcostDiffBillIdsStr).substring(1, ((String)stdcostDiffBillIdsStr).length());
                    }
                    for (DataSetX id : ((String)stdcostDiffBillIdsStr).split(",")) {
                        param.getStdBillIds().add(Long.valueOf((String)id));
                    }
                    String costAdjustBillIdsStr = row.getString("costadjustbillids");
                    if (costAdjustBillIdsStr == null || costAdjustBillIdsStr.isEmpty()) continue;
                    if (costAdjustBillIdsStr.startsWith(",")) {
                        costAdjustBillIdsStr = costAdjustBillIdsStr.substring(1, costAdjustBillIdsStr.length());
                    }
                    for (String id : costAdjustBillIdsStr.split(",")) {
                        param.getAdjBillIds().add(Long.valueOf(id));
                    }
                }
                return;
            }
            if (param.isNewBalance()) {
                HashSet<Long> stdcostDiffBillIds = new HashSet<Long>(16);
                HashSet<Long> costAdjustBillIds = new HashSet<Long>(16);
                stdcostDiffBillIds.addAll(param.getStdBillIds());
                costAdjustBillIds.addAll(param.getAdjBillIds());
                for (Row row : calResultDataSet) {
                    String stdcostDiffBillIdsStr = row.getString("stdcostdiffbillids");
                    if (stdcostDiffBillIdsStr == null || stdcostDiffBillIdsStr.isEmpty()) continue;
                    if (stdcostDiffBillIdsStr.startsWith(",")) {
                        stdcostDiffBillIdsStr = stdcostDiffBillIdsStr.substring(1, stdcostDiffBillIdsStr.length());
                    }
                    for (DataSet id : stdcostDiffBillIdsStr.split(",")) {
                        stdcostDiffBillIds.add(Long.valueOf((String)id));
                    }
                    String costAdjustBillIdsStr = row.getString("costadjustbillids");
                    if (costAdjustBillIdsStr == null || costAdjustBillIdsStr.isEmpty()) continue;
                    if (costAdjustBillIdsStr.startsWith(",")) {
                        costAdjustBillIdsStr = costAdjustBillIdsStr.substring(1, costAdjustBillIdsStr.length());
                    }
                    for (String id : costAdjustBillIdsStr.split(",")) {
                        costAdjustBillIds.add(Long.valueOf(id));
                    }
                }
                startTime1 = System.currentTimeMillis();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("createtype", "W");
                String isGroupDiffBill = CalDbParamServiceHelper.getString((String)"isgroupdiffbill", null);
                Lists.partition((List)Lists.newArrayList(stdcostDiffBillIds), (int)1000).forEach(list -> {
                    OperationServiceHelper.executeOperate((String)"updatebal", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)operateOption);
                    if ("false".equals(isGroupDiffBill)) {
                        WhiteListHelper.writeWhiteList((String)"cal_stdcostdiffbill", (List)list);
                    }
                });
                Lists.partition((List)Lists.newArrayList(costAdjustBillIds), (int)1000).forEach(list -> OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (Object[])list.toArray(), (OperateOption)operateOption));
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":updatebal_time:" + (endTime1 - startTime1) + "ms");
                startTime1 = System.currentTimeMillis();
                if ("true".equals(isGroupDiffBill)) {
                    HashMap<String, HashSet<Long>> diffBillEntryIdMap = new HashMap<String, HashSet<Long>>(16);
                    diffBillEntryIdMap.put("diffbillid", stdcostDiffBillIds);
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupDiffBillService", (String)"createDiffGroupBill", (Object[])new Object[]{diffBillEntryIdMap});
                }
                endTime1 = System.currentTimeMillis();
                logger.info("task's-currBatch:" + param.getBatchInfo() + ":CalGroupDiffBillService_time:" + (endTime1 - startTime1) + "ms");
            }
        }
        DiffAllocHelper.writeLogEnd((Log)logger, (String)"deal_doAlloc_end", (Long)startTime);
    }

    private RowMeta buildOutputMeta() {
        Field[] resultFields = new Field[]{new Field("stdcostdiffbillids", (DataType)DataType.StringType), new Field("costadjustbillids", (DataType)DataType.StringType), new Field("materialid", (DataType)DataType.LongType)};
        return new RowMeta(resultFields);
    }

    private void repairStdCost(DiffAllocParamter param) {
        try {
            logger.info("repairStdCost_start");
            String allDims = DiffAllocHelper.mergDiffAllocDims((String)param.getEquationSetDims(), (String)param.getAllocDims());
            for (Map.Entry entityEntry : param.getEntityEntry().entrySet()) {
                DiffAllocParamterEntry diffAllocParamEntry = (DiffAllocParamterEntry)entityEntry.getValue();
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"RepairStandardCostService", (String)"repairStandardCostCreateDiffBill", (Object[])new Object[]{diffAllocParamEntry.getCalOrgId(), diffAllocParamEntry.getCostAccountId(), diffAllocParamEntry.getPeriodId(), null, diffAllocParamEntry.getMatIdSet(), diffAllocParamEntry.getAllocDimKeyCols(), allDims});
            }
            logger.info("repairStdCost_end");
        }
        catch (Exception var2) {
            logger.error("repairStdCost_fail", (Throwable)var2);
            throw new KDBizException("RepairStandardCostService.repairStandardCostCreateDiffBill_fail");
        }
    }

    public void dealAdjustDiff(DiffAllocParamter param) {
        for (Map.Entry entityEntry : param.getEntityEntry().entrySet()) {
            if (entityEntry.getValue() == null) continue;
            if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ISDO_REWORK_CIRCLE_ADJUSTDIFF, (String)((DiffAllocParamterEntry)entityEntry.getValue()).getCalOrgId().toString()).booleanValue()) {
                return;
            }
            logger.info("\u8fdb\u5165\u7ec8\u6781\u8c03\u5dee\u5904\u7406");
            param.setEquationSetDims(CalDbParamServiceHelper.getString((String)CalDbParamConstant.EQUATION_DIMS, (String)((DiffAllocParamterEntry)entityEntry.getValue()).getCalOrgId().toString()));
            DiffAllocParamterEntry paramEntry = (DiffAllocParamterEntry)entityEntry.getValue();
            logger.info("DiffAllocServiceNew.dealAdjustDiff material set==>{}", (Object)paramEntry.getMatIdSet());
            DiffAllocDataFactory dataFactory = new DiffAllocDataFactory(param, paramEntry);
            String diffAllocDims = DiffAllocHelper.mergDiffAllocDims((String)param.getAllocDims(), (String)param.getEquationSetDims());
            if (!diffAllocDims.contains("material")) {
                diffAllocDims = diffAllocDims + ",material";
            }
            HashSet<Long> stdBillIds = new HashSet<Long>(16);
            JobSession session3 = AlgoX.createSession((String)("DiffAllocService_OnlyDoTail\uff1a" + param.getBatchInfo()));
            HashSet matIds = new HashSet(1000);
            DataSetX qtyZeroDimsDx = session3.fromInput(dataFactory.getBalQtyIsZero(paramEntry, matIds));
            qtyZeroDimsDx = qtyZeroDimsDx.filter((FilterFunction)new FilterByAllocDimValsFunctionNew(qtyZeroDimsDx.getRowMeta(), param, paramEntry));
            DataSetX totalDiffDataSetX = session3.fromInput(dataFactory.getTotalDiffData(paramEntry, matIds));
            JoinDataSetX join = totalDiffDataSetX.join(qtyZeroDimsDx);
            for (String string : diffAllocDims.split(",")) {
                join.on(string, string);
            }
            totalDiffDataSetX = join.select(totalDiffDataSetX.getRowMeta().getFieldNames());
            DataSetX outputDiffDataSetX = session3.fromInput(dataFactory.getOutputDiffData(paramEntry, matIds));
            String groupfields = diffAllocDims + ",costelement,costsubelement";
            JoinDataSetX allDataJoinSetX = totalDiffDataSetX.leftJoin(outputDiffDataSetX);
            for (String field3 : groupfields.split(",")) {
                allDataJoinSetX.on(field3, field3);
            }
            JoinDataSetX joinDataSetX = allDataJoinSetX.select(totalDiffDataSetX.getRowMeta().getFieldNames(), new String[]{"bizdate", "invbillentryid", "entryid", "createtype", "outddiff_g", "outddiff_h", "outddiff_k", "outddiff_p", "outddiff_q", "outddiff_r", "outddiff_m", "outddiff_s", "outddiff_t", "outddiff_w", "outddiff_x", "outddiff_y", "outddiff_c", "outddiff", "outdiff_g", "outdiff_h", "outdiff_k", "outdiff_p", "outdiff_q", "outdiff_r", "outdiff_m", "outdiff_s", "outdiff_t", "outdiff_w", "outdiff_x", "outdiff_y", "outdiff_c", "outdiff", "subentryentity", "gcostrecordentryid"});
            DataSetX dataSetx = joinDataSetX.filter("balqty == 0");
            Map billHeadData = dataFactory.buildStdHeadData(paramEntry, matIds);
            Date endDate = dataFactory.getEndDateByAccount(paramEntry);
            DealFinalStdBillCreateFunction dealFinalStdBillCreateFunction = new DealFinalStdBillCreateFunction(dataSetx.getRowMeta(), endDate, paramEntry.getPeriodId(), billHeadData, diffAllocDims);
            dataSetx = dataSetx.groupBy(diffAllocDims.split(",")).reduceGroup((GroupReduceFunction)dealFinalStdBillCreateFunction);
            DataSetOutput resultSet3 = new DataSetOutput(DealFinalStdBillCreateFunction.targetRowMeta);
            dataSetx.output((Output)resultSet3);
            String stdId = resultSet3.getId();
            session3.commit(60, TimeUnit.MINUTES);
            DataSet dataSet = session3.readDataSet(stdId);
            for (Row row : dataSet) {
                stdBillIds.add(row.getLong("stdId"));
            }
            if (stdBillIds.isEmpty()) continue;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("createtype", "W");
            Lists.partition((List)Lists.newArrayList(stdBillIds), (int)1000).forEach(list -> OperationServiceHelper.executeOperate((String)"updatebal", (String)"cal_stdcostdiffbill", (Object[])list.toArray(), (OperateOption)operateOption));
            String isGroupDiffBill = CalDbParamServiceHelper.getString((String)"isgroupdiffbill", null);
            if (!"true".equals(isGroupDiffBill)) continue;
            HashMap<String, HashSet<Long>> diffBillEntryIdMap = new HashMap<String, HashSet<Long>>(16);
            diffBillEntryIdMap.put("diffbillid", stdBillIds);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalGroupDiffBillService", (String)"createDiffGroupBill", (Object[])new Object[]{diffBillEntryIdMap});
        }
    }

    private DataSetX test(DataSetX testX) {
        TestFunction test = new TestFunction(testX.getRowMeta());
        return testX.reduceGroup((GroupReduceFunction)test);
    }

    private DataSetX printDataSetX(DataSetX dataSetX, String logDesc) {
        if (!CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DIFFALLOC_IS_DEBUG).booleanValue()) {
            return dataSetX;
        }
        DiffAllocDebugFunction debugFunction = new DiffAllocDebugFunction(dataSetX.getRowMeta(), logDesc);
        dataSetX = dataSetX.reduceGroup((GroupReduceFunction)debugFunction);
        return dataSetX;
    }
}

