/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.algox.costcalc.function;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.aca.algox.costcalc.action.DebugInfoMsgHandler;
import kd.macc.aca.algox.costcalc.common.ActCostCalcArgs;
import kd.macc.aca.algox.costcalc.common.ActSubItemRow;
import kd.macc.aca.algox.costcalc.function.ActCalcFunctionHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class ActCalcSubItemReviseDataFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private ActCostCalcArgs args = null;
    private DebugInfoMsgHandler msgHander = null;

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public ActCalcSubItemReviseDataFunction(ActCostCalcArgs args, DebugInfoMsgHandler msgHander) {
        this.args = args;
        this.msgHander = msgHander;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList allRows = Lists.newArrayList();
        Long mainCostObjectId = 0L;
        Long subElementId = 0L;
        Long subMatId = 0L;
        RowX mainRow = null;
        for (RowX row : iterable) {
            String productType;
            allRows.add(row);
            if (mainCostObjectId == 0L) {
                mainCostObjectId = row.getLong(this.sourceRowMeta.getFieldIndex("mainCostObjectId"));
                subElementId = row.getLong(this.sourceRowMeta.getFieldIndex("subElementId"));
                subMatId = row.getLong(this.sourceRowMeta.getFieldIndex("subMatId"));
            }
            if (!"C".equals(productType = row.getString(this.sourceRowMeta.getFieldIndex("productType")))) continue;
            mainRow = row;
        }
        if (allRows.isEmpty()) {
            return;
        }
        if (mainRow == null) {
            DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)mainCostObjectId, (String)"cad_costobject", (String)"costcenter,name");
            DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"number,name");
            DynamicObject subMatDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)subMatId, (String)"bd_material", (String)"number,name");
            String errStr = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5206\u9879\u660e\u7ec6\u65f6\uff0c\u4e3b\u4ea7\u54c1\u65e0\u6295\u5165\u660e\u7ec6\uff0c\u6210\u672c\u5bf9\u8c61\u3010%1$s\u3011\uff0c\u5b50\u8981\u7d20\u3010%2$s\u3011\uff0c\u7269\u6599\u3010%3$s\u3011\u3002", (String)"ActCalcSubItemReviseDataFunction_0", (String)"macc-aca-algox", (Object[])new Object[0]), costObjectDyo != null ? costObjectDyo.getString("name") : "", subElementDyo != null ? subElementDyo.getString("number") + subElementDyo.getString("name") : "", subMatDyo != null ? subMatDyo.getString("number") + subMatDyo.getString("name") : "");
            ActCalcFunctionHelper.insertCalcErrorInfo((Long)this.args.getLevelEntryId(), (Long)(costObjectDyo != null ? costObjectDyo.getLong("costcenter.id") : 0L), (String)errStr);
            return;
        }
        StringBuilder debugMsg = null;
        boolean isCostobjectDebug = ActCalcFunctionHelper.isCostobjectDebug((ActCostCalcArgs)this.args, (Long)mainCostObjectId);
        if (isCostobjectDebug) {
            debugMsg = new StringBuilder();
            debugMsg.append(String.format("%s-costobjectId %s,subelementId %s,matId %s:%n", ResManager.loadKDString((String)"\u8ba1\u7b97\u5206\u9879\u6570\u636e\uff1a", (String)"ActCalcSubItemReviseDataFunction_1", (String)"macc-aca-algox", (Object[])new Object[0]), mainCostObjectId, subElementId, subMatId));
        }
        if (!CadEmptyUtils.isEmpty((Long)mainRow.getLong(this.sourceRowMeta.getFieldIndex("subMatId")))) {
            this.reviseAndCalcSubDealV2(allRows, mainRow, debugMsg);
        }
        if (debugMsg != null) {
            this.msgHander.dealInfoMsg(debugMsg.toString());
        }
        for (RowX row : allRows) {
            collector.collect(row);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reviseAndCalcSubDealV2(List<RowX> allRows, RowX mainRow, StringBuilder debugMsg) {
        boolean isHasSideFactRow = false;
        boolean isHasMainFactRow = false;
        boolean isHasJoinRow = false;
        boolean isHasJoinFactRow = false;
        for (RowX row : allRows) {
            boolean isFact;
            String productType = row.getString(this.sourceRowMeta.getFieldIndex("productType"));
            BigDecimal finAmt = BigDecimalUtil.getOrZero((Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
            boolean bl = isFact = BigDecimal.ZERO.compareTo(finAmt) != 0;
            if ("B".equals(productType)) {
                isHasSideFactRow = true;
                continue;
            }
            if ("A".equals(productType)) {
                isHasJoinRow = true;
                if (!isFact) continue;
                isHasJoinFactRow = true;
                continue;
            }
            if (!"C".equals(productType) || !isFact) continue;
            isHasMainFactRow = true;
        }
        boolean isHasFact = isHasSideFactRow || isHasMainFactRow || isHasJoinFactRow;
        boolean isOnlySideFact = isHasSideFactRow && !isHasMainFactRow && !isHasJoinFactRow;
        List<ActSubItemRow> mainSubitemRows = this.reviseRow(mainRow, null);
        if (debugMsg != null) {
            debugMsg.append(String.format("main row ravise data:%s %n", JSON.toJSONString(mainSubitemRows)));
        }
        Map<String, BigDecimal> subItemRadioMap = this.getSubItemRadio(mainSubitemRows);
        if (!isOnlySideFact && isHasFact) {
            this.calcMainJoinSideFactAmt(mainRow, mainSubitemRows);
        }
        for (RowX row : allRows) {
            String productType = row.getString(this.sourceRowMeta.getFieldIndex("productType"));
            if (!"B".equals(productType)) continue;
            List<ActSubItemRow> list = this.reviseSideRow(row);
            String string = JSON.toJSONString(list);
            if (debugMsg != null) {
                debugMsg.append(String.format("ProductType %s row ravise data:%s %n", productType, string));
            }
            row.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)string);
            BigDecimal finAmt = BigDecimalUtil.getOrZero((Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
            if (BigDecimal.ZERO.compareTo(finAmt) == 0) continue;
            boolean isFind = false;
            ActSubItemRow actSubItemRow = list.get(0);
            for (ActSubItemRow actSubItemRow2 : mainSubitemRows) {
                if (!actSubItemRow2.getSsubelement().equals(actSubItemRow.getSsubelement())) continue;
                isFind = true;
                if (isOnlySideFact) {
                    actSubItemRow2.setTotalcomamt(actSubItemRow.getSpdcomamt());
                    actSubItemRow2.setTotalcomInAmt(BigDecimal.ZERO);
                    break;
                }
                actSubItemRow2.setTotalcomInAmt(actSubItemRow2.getTotalcomInAmt().subtract(actSubItemRow.getSpdcomamt()));
                break;
            }
            if (isFind) continue;
            actSubItemRow.setSpdyearcomamt(BigDecimal.ZERO);
            if (isOnlySideFact) {
                actSubItemRow.setTotalcomamt(actSubItemRow.getSpdcomamt());
            } else {
                actSubItemRow.setTotalcomamt(actSubItemRow.getSpdcomamt());
                actSubItemRow.setTotalcomInAmt(actSubItemRow.getSpdcomamt().negate());
            }
            actSubItemRow.setSpdcomamt(BigDecimal.ZERO);
            actSubItemRow.setSpdsumcomamt(BigDecimal.ZERO);
            mainSubitemRows.add(actSubItemRow);
        }
        HashMap mainJoinItemRowMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap mainItemMap = Maps.newHashMapWithExpectedSize((int)10);
        for (ActSubItemRow actSubItemRow : mainSubitemRows) {
            mainItemMap.put(actSubItemRow.getSsubelement(), actSubItemRow);
            actSubItemRow.setSpdendamt(actSubItemRow.getSpdstartamt().add(actSubItemRow.getSpdstartadjamt()).add(actSubItemRow.getSpdcurramt()).subtract(actSubItemRow.getTotalcomamt()));
            actSubItemRow.setTotalcomamt(actSubItemRow.getTotalcomInAmt());
        }
        if (debugMsg != null) {
            debugMsg.append(String.format("ProductType C row ravise data:json:%s %n", JSON.toJSONString(mainSubitemRows)));
        }
        for (RowX rowX : allRows) {
            String string = rowX.getString(this.sourceRowMeta.getFieldIndex("productType"));
            if (!"A".equals(string)) continue;
            List<ActSubItemRow> rowSubitemRows = this.reviseRow(rowX, subItemRadioMap);
            if (!isHasFact) {
                rowX.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)JSON.toJSONString(rowSubitemRows));
                continue;
            }
            HashMap itemMap = Maps.newHashMapWithExpectedSize((int)10);
            for (ActSubItemRow itemrow : rowSubitemRows) {
                itemMap.put(itemrow.getSsubelement(), itemrow);
            }
            mainJoinItemRowMap.put(rowX, itemMap);
        }
        if (!isHasFact) {
            mainRow.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)JSON.toJSONString(mainSubitemRows));
            return;
        }
        if (!isHasJoinRow) {
            if (isHasMainFactRow) {
                for (Map.Entry entry : mainItemMap.entrySet()) {
                    ((ActSubItemRow)entry.getValue()).setSpdcomamt(((ActSubItemRow)entry.getValue()).getTotalcomamt());
                }
            }
            this.setSumAmt(mainItemMap.values(), true);
            String json = JSON.toJSONString(mainItemMap.values());
            mainRow.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)json);
            if (debugMsg != null) {
                debugMsg.append(String.format("ProductType C row ravise data:json:%s %n", json));
            }
            return;
        }
        Map<RowX, BigDecimal> mainJoinRadioMap = this.getMainJoinRadioMap(allRows);
        for (RowX rowX : allRows) {
            BigDecimal radio = mainJoinRadioMap.get(rowX);
            if (radio == null || radio.compareTo(BigDecimal.ZERO) == 0) continue;
            if (rowX == mainRow) {
                for (Map.Entry entry : mainItemMap.entrySet()) {
                    ActSubItemRow itemrow;
                    itemrow = (ActSubItemRow)entry.getValue();
                    itemrow.setSpdcomamt(itemrow.getTotalcomamt().multiply(radio).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP));
                    itemrow.setTotalcomInAmt(itemrow.getTotalcomInAmt().subtract(itemrow.getSpdcomamt()));
                }
                continue;
            }
            Map itemMap = (Map)mainJoinItemRowMap.get(rowX);
            for (Map.Entry entry3 : mainItemMap.entrySet()) {
                ActSubItemRow actSubItemRow = (ActSubItemRow)entry3.getValue();
                ActSubItemRow joinRow = (ActSubItemRow)itemMap.get(entry3.getKey());
                if (joinRow == null) {
                    joinRow = new ActSubItemRow();
                    joinRow.setSelement(actSubItemRow.getSelement());
                    joinRow.setSsubelement(actSubItemRow.getSsubelement());
                    itemMap.put(entry3.getKey(), joinRow);
                }
                joinRow.setSpdcomamt(actSubItemRow.getTotalcomamt().multiply(radio).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP));
                actSubItemRow.setTotalcomInAmt(actSubItemRow.getTotalcomInAmt().subtract(joinRow.getSpdcomamt()));
            }
        }
        for (Map.Entry entry : mainItemMap.entrySet()) {
            if (((ActSubItemRow)entry.getValue()).getTotalcomInAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            Object maxItemRow = null;
            for (RowX rowX : allRows) {
                void var21_65;
                String productType = rowX.getString(this.sourceRowMeta.getFieldIndex("productType"));
                if ("B".equals(productType)) continue;
                Object var21_62 = null;
                if (rowX == mainRow) {
                    ActSubItemRow actSubItemRow = (ActSubItemRow)entry.getValue();
                } else {
                    Map itemMap = (Map)mainJoinItemRowMap.get(rowX);
                    ActSubItemRow actSubItemRow = (ActSubItemRow)itemMap.get(entry.getKey());
                }
                if (var21_65 == null || maxItemRow != null && maxItemRow.getSpdcomamt().compareTo(var21_65.getSpdcomamt()) >= 0) continue;
                maxItemRow = var21_65;
            }
            if (maxItemRow == null) continue;
            maxItemRow.setSpdcomamt(maxItemRow.getSpdcomamt().add(((ActSubItemRow)entry.getValue()).getTotalcomInAmt()));
        }
        for (RowX rowX : allRows) {
            void var19_56;
            String productType = rowX.getString(this.sourceRowMeta.getFieldIndex("productType"));
            if ("B".equals(productType)) continue;
            BigDecimal totalAmt = BigDecimal.ZERO;
            Object var19_53 = null;
            if (rowX == mainRow) {
                for (Map.Entry entry : mainItemMap.entrySet()) {
                    totalAmt = totalAmt.add(((ActSubItemRow)entry.getValue()).getSpdcomamt());
                }
                this.setSumAmt(mainItemMap.values(), true);
                String string = JSON.toJSONString(mainItemMap.values());
            } else {
                Map itemMap = (Map)mainJoinItemRowMap.get(rowX);
                if (itemMap == null) continue;
                for (Map.Entry entry : itemMap.entrySet()) {
                    totalAmt = totalAmt.add(((ActSubItemRow)entry.getValue()).getSpdcomamt());
                }
                this.setSumAmt(itemMap.values(), true);
                String string = JSON.toJSONString(itemMap.values());
            }
            if (debugMsg != null) {
                BigDecimal finAmt = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt"));
                debugMsg.append(String.format("ProductType %s row ravise data:%s-%s,json:%s %n", productType, finAmt, totalAmt, var19_56));
            }
            rowX.set(this.sourceRowMeta.getFieldIndex("finAmt"), (Object)totalAmt);
            rowX.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)var19_56);
        }
    }

    private void calcMainJoinSideFactAmt(RowX mainRow, List<ActSubItemRow> mainSubitemRows) {
        BigDecimal curAmt = BigDecimalUtil.getOrZero((Object)mainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdStartAmt")));
        curAmt = curAmt.add(BigDecimalUtil.getOrZero((Object)mainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("startadjamt"))));
        curAmt = curAmt.add(BigDecimalUtil.getOrZero((Object)mainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount"))));
        BigDecimal inAmt = BigDecimalUtil.getOrZero((Object)mainRow.getBigDecimal(this.sourceRowMeta.getFieldIndex("inAmt")));
        BigDecimal comAmt = curAmt.subtract(inAmt);
        BigDecimal comRadio = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(curAmt) != 0) {
            comRadio = comAmt.divide(curAmt, 10, RoundingMode.HALF_UP);
        }
        if (comRadio.compareTo(BigDecimal.ZERO) != 0) {
            ActSubItemRow maxRow = null;
            BigDecimal comDiffAmt = comAmt;
            for (ActSubItemRow row : mainSubitemRows) {
                BigDecimal subCurAmt = row.getSpdstartamt().add(row.getSpdstartadjamt()).add(row.getSpdcurramt());
                row.setTotalcomamt(subCurAmt.multiply(comRadio).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP));
                comDiffAmt = comDiffAmt.subtract(row.getTotalcomamt());
                if (maxRow != null && maxRow.getTotalcomamt().compareTo(row.getTotalcomamt()) >= 0) continue;
                maxRow = row;
            }
            if (maxRow != null && comDiffAmt.compareTo(BigDecimal.ZERO) != 0) {
                maxRow.setTotalcomamt(maxRow.getTotalcomamt().add(comDiffAmt));
            }
        }
        for (ActSubItemRow itemrow : mainSubitemRows) {
            itemrow.setTotalcomInAmt(itemrow.getTotalcomamt());
        }
    }

    private void setSumAmt(Collection<ActSubItemRow> itemRows, boolean isSumInput) {
        for (ActSubItemRow row : itemRows) {
            row.setSpdsumcomamt(row.getSpdcomamt().add(row.getSpdsumcomamt()));
            if (isSumInput) {
                row.setSpdsumamt(row.getSpdsumamt().add(row.getSpdcurramt()));
            }
            if (this.args.isFirstPeriod()) {
                row.setSpdyearcomamt(row.getSpdcomamt());
                if (!isSumInput) continue;
                row.setSpdyearsumamt(row.getSpdcurramt());
                continue;
            }
            row.setSpdyearcomamt(row.getSpdcomamt().add(row.getSpdyearcomamt()));
            if (!isSumInput) continue;
            row.setSpdyearsumamt(row.getSpdcurramt().add(row.getSpdyearsumamt()));
        }
    }

    private Map<RowX, BigDecimal> getMainJoinRadioMap(List<RowX> allRows) {
        HashMap<RowX, BigDecimal> mainJoinRadioMap = new HashMap<RowX, BigDecimal>(10);
        if (allRows.size() == 1) {
            mainJoinRadioMap.put(allRows.get(0), BigDecimal.ONE);
        } else {
            BigDecimal finAmt;
            String productType;
            BigDecimal totalFinAmt = BigDecimal.ZERO;
            int size = 0;
            for (RowX rowX : allRows) {
                productType = rowX.getString(this.sourceRowMeta.getFieldIndex("productType"));
                if ("B".equals(productType)) continue;
                finAmt = BigDecimalUtil.getOrZero((Object)rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
                if (BigDecimal.ZERO.compareTo(finAmt) != 0) {
                    ++size;
                }
                totalFinAmt = totalFinAmt.add(finAmt);
            }
            if (totalFinAmt.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal mainJoinRadio = BigDecimal.ZERO;
                if (size != 0) {
                    mainJoinRadio = BigDecimal.ONE.divide(new BigDecimal(size), 10, RoundingMode.HALF_UP);
                }
                for (RowX row : allRows) {
                    String productType2 = row.getString(this.sourceRowMeta.getFieldIndex("productType"));
                    if ("B".equals(productType2)) continue;
                    mainJoinRadioMap.put(row, mainJoinRadio);
                }
            } else {
                for (RowX rowX : allRows) {
                    productType = rowX.getString(this.sourceRowMeta.getFieldIndex("productType"));
                    if ("B".equals(productType)) continue;
                    finAmt = BigDecimalUtil.getOrZero((Object)rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
                    BigDecimal mainJoinRadio = finAmt.divide(totalFinAmt, 10, RoundingMode.HALF_UP);
                    mainJoinRadioMap.put(rowX, mainJoinRadio);
                }
            }
        }
        return mainJoinRadioMap;
    }

    private void reviseAndCalcSubDeal(List<RowX> allRows, RowX mainRow, StringBuilder debugMsg) {
        List<ActSubItemRow> subitemRows = this.reviseRow(mainRow, null);
        if (debugMsg != null) {
            debugMsg.append(String.format("main row ravise data:%s %n", JSON.toJSONString(subitemRows)));
        }
        this.calcFactSubRow(mainRow, subitemRows);
        if (debugMsg != null) {
            debugMsg.append(String.format("main row calcfact data:%s %n", JSON.toJSONString(subitemRows)));
        }
        Map<String, BigDecimal> subItemRadioMap = this.getSubItemRadio(subitemRows);
        HashMap subItemFactMap = Maps.newHashMapWithExpectedSize((int)10);
        this.setSubItemFact(subitemRows, subItemFactMap);
        for (RowX row : allRows) {
            if (row == mainRow) continue;
            String productType = row.getString(this.sourceRowMeta.getFieldIndex("productType"));
            List<ActSubItemRow> rowSubitemRows = this.reviseRow(row, subItemRadioMap);
            if (debugMsg != null) {
                debugMsg.append(String.format("ProductType %s row ravise data:%s %n", productType, JSON.toJSONString(rowSubitemRows)));
            }
            this.setAllocRadio(rowSubitemRows, subItemRadioMap);
            if (debugMsg != null) {
                debugMsg.append(String.format("ProductType %s row setMainRadio data:%s %n", productType, JSON.toJSONString(rowSubitemRows)));
            }
            this.calcFactSubRow(row, rowSubitemRows);
            if (debugMsg != null) {
                debugMsg.append(String.format("ProductType %s row calcfact data:%s %n", productType, JSON.toJSONString(rowSubitemRows)));
            }
            this.setSubItemFact(rowSubitemRows, subItemFactMap);
            row.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)JSON.toJSONString(rowSubitemRows));
        }
        if (debugMsg != null) {
            debugMsg.append(String.format("SubElement TotalFact:%s %n", JSON.toJSONString((Object)subItemFactMap)));
        }
        this.calcInAmt(subitemRows, subItemFactMap);
        mainRow.set(this.sourceRowMeta.getFieldIndex("subjson"), (Object)JSON.toJSONString(subitemRows));
        if (debugMsg != null) {
            debugMsg.append(String.format("SubElement End:%s %n", JSON.toJSONString(subitemRows)));
        }
    }

    private void calcInAmt(List<ActSubItemRow> subitemRows, Map<String, BigDecimal> subItemFactMap) {
        for (ActSubItemRow actSubItemRow : subitemRows) {
            String key = String.format("%s@%s", actSubItemRow.getSelement(), actSubItemRow.getSsubelement());
            Object factAmt = subItemFactMap.get(key);
            if (factAmt == null) {
                factAmt = BigDecimal.ZERO;
            }
            actSubItemRow.setSpdendamt(actSubItemRow.getSpdstartamt().add(actSubItemRow.getSpdstartadjamt()).add(actSubItemRow.getSpdcurramt()).subtract((BigDecimal)factAmt));
        }
        for (Map.Entry entry : subItemFactMap.entrySet()) {
            boolean isContains = false;
            for (ActSubItemRow subitemRow2 : subitemRows) {
                String key = String.format("%s@%s", subitemRow2.getSelement(), subitemRow2.getSsubelement());
                if (!((String)entry.getKey()).equals(key)) continue;
                isContains = true;
                break;
            }
            if (isContains) continue;
            String[] arr = ((String)entry.getKey()).split("@");
            ActSubItemRow subitemRow = new ActSubItemRow();
            subitemRow.setSelement(Long.valueOf(arr[0]));
            subitemRow.setSsubelement(Long.valueOf(arr[1]));
            subitemRow.setSpdendamt(((BigDecimal)entry.getValue()).negate());
            subitemRows.add(subitemRow);
        }
    }

    private void setSubItemFact(List<ActSubItemRow> subitemRows, Map<String, BigDecimal> subItemFactMap) {
        for (ActSubItemRow subItemRow : subitemRows) {
            String key = String.format("%s@%s", subItemRow.getSelement(), subItemRow.getSsubelement());
            if (subItemRow.getSpdcomamt().compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal factAmt = subItemFactMap.get(key);
            if (factAmt == null) {
                factAmt = BigDecimal.ZERO;
            }
            factAmt = factAmt.add(subItemRow.getSpdcomamt());
            subItemFactMap.put(key, factAmt);
        }
    }

    private Map<String, BigDecimal> getSubItemRadio(List<ActSubItemRow> subitemRows) {
        HashMap subItemRadioMap = Maps.newHashMapWithExpectedSize((int)10);
        for (ActSubItemRow subItemRow : subitemRows) {
            subItemRadioMap.put(String.format("%s@%s", subItemRow.getSelement(), subItemRow.getSsubelement()), subItemRow.getRadio());
        }
        return subItemRadioMap;
    }

    private List<ActSubItemRow> calcFactSubRow(RowX row, List<ActSubItemRow> subitemRows) {
        BigDecimal finAmt;
        BigDecimal diffFinAmt = finAmt = BigDecimalUtil.getOrZero((Object)row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
        ActSubItemRow maxRow = null;
        for (ActSubItemRow subitemRow : subitemRows) {
            if (maxRow == null || maxRow.getRadio().compareTo(subitemRow.getRadio()) < 0) {
                maxRow = subitemRow;
            }
            subitemRow.setSpdcomamt(subitemRow.getRadio().multiply(finAmt).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP));
            diffFinAmt = diffFinAmt.subtract(subitemRow.getSpdcomamt());
        }
        if (maxRow != null && diffFinAmt.compareTo(BigDecimal.ZERO) != 0) {
            maxRow.setSpdcomamt(maxRow.getSpdcomamt().add(diffFinAmt));
        }
        for (ActSubItemRow subitemRow : subitemRows) {
            subitemRow.setSpdsumamt(subitemRow.getSpdsumamt().add(subitemRow.getSpdcurramt()));
            subitemRow.setSpdsumcomamt(subitemRow.getSpdsumcomamt().add(subitemRow.getSpdcomamt()));
            if (this.args.isFirstPeriod()) {
                subitemRow.setSpdyearsumamt(subitemRow.getSpdcurramt());
                subitemRow.setSpdyearcomamt(subitemRow.getSpdcomamt());
                continue;
            }
            subitemRow.setSpdyearsumamt(subitemRow.getSpdyearsumamt().add(subitemRow.getSpdcurramt()));
            subitemRow.setSpdyearcomamt(subitemRow.getSpdyearcomamt().add(subitemRow.getSpdcomamt()));
        }
        return subitemRows;
    }

    private List<ActSubItemRow> reviseSideRow(RowX row) {
        ArrayList<ActSubItemRow> subItemRows = new ArrayList<ActSubItemRow>();
        subItemRows.add(this.getCompRowItem(row));
        this.setSumAmt(subItemRows, false);
        return subItemRows;
    }

    private List<ActSubItemRow> reviseRow(RowX row, Map<String, BigDecimal> subItemRadioMap) {
        String productType = row.getString(this.sourceRowMeta.getFieldIndex("productType"));
        String json = row.getString(this.sourceRowMeta.getFieldIndex("subjson"));
        List subItemRows = null;
        subItemRows = StringUtils.isEmpty((CharSequence)json) ? new ArrayList() : JSON.parseArray((String)json, ActSubItemRow.class);
        if (subItemRows.isEmpty()) {
            if (CadEmptyUtils.isEmpty(subItemRadioMap)) {
                subItemRows.add((ActSubItemRow)this.getCompRowItem(row));
            } else {
                this.setAllocRadio(subItemRows, subItemRadioMap);
            }
        }
        if ("C".equals(productType)) {
            this.reviseFieldAmt(row, subItemRows, 0, subItemRadioMap);
            this.reviseFieldAmt(row, subItemRows, 1, subItemRadioMap);
            this.reviseFieldAmt(row, subItemRows, 2, subItemRadioMap);
            this.reviseFieldAmt(row, subItemRows, 4, subItemRadioMap);
            this.reviseFieldAmt(row, subItemRows, 5, subItemRadioMap);
            this.reviseFieldAmt(row, subItemRows, 6, subItemRadioMap);
        }
        this.reviseFieldAmt(row, subItemRows, 7, subItemRadioMap);
        this.reviseFieldAmt(row, subItemRows, 8, subItemRadioMap);
        if (subItemRows.size() == 1) {
            subItemRows.get(0).setRadio(BigDecimal.ONE);
        } else if ("C".equals(productType) && !this.calcRadio(subItemRows, 99)) {
            this.calcAvgRadio(subItemRows);
        }
        return subItemRows;
    }

    private ActSubItemRow getCompRowItem(RowX row) {
        ActSubItemRow subItemRow = new ActSubItemRow();
        subItemRow.setSelement(row.getLong(this.sourceRowMeta.getFieldIndex("elementId")));
        subItemRow.setSsubelement(row.getLong(this.sourceRowMeta.getFieldIndex("subElementId")));
        subItemRow.setSpdstartamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdStartAmt")));
        subItemRow.setSpdstartadjamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("startadjamt")));
        subItemRow.setSpdcurramt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount")));
        subItemRow.setSpdcomamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("finAmt")));
        subItemRow.setSpdendamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("inAmt")));
        subItemRow.setSpdendadjamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("endadjamt")));
        subItemRow.setSpdsumamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("pdSumAmt")));
        subItemRow.setSpdyearsumamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("yearSumInputAmt")));
        subItemRow.setSpdsumcomamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("sumComAmt")));
        subItemRow.setSpdyearcomamt(row.getBigDecimal(this.sourceRowMeta.getFieldIndex("yearSumFinishAmt")));
        return subItemRow;
    }

    private void reviseFieldAmt(RowX row, List<ActSubItemRow> subItemRows, int type, Map<String, BigDecimal> subItemRadioMap) {
        String field = this.getCalcCompField(type);
        BigDecimal compAmt = row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field));
        BigDecimal sumAmt = BigDecimal.ZERO;
        ActSubItemRow maxRow = null;
        for (ActSubItemRow actSubItemRow : subItemRows) {
            BigDecimal currAmt = this.getCalcRadioAmt(actSubItemRow, type);
            sumAmt = sumAmt.add(currAmt);
            if (maxRow != null && this.getCalcRadioAmt(maxRow, type).compareTo(currAmt) >= 0) continue;
            maxRow = actSubItemRow;
        }
        if (compAmt.compareTo(sumAmt) == 0) {
            return;
        }
        if (!this.calcRadio(subItemRows, type)) {
            if (subItemRadioMap != null) {
                this.setAllocRadio(subItemRows, subItemRadioMap);
            } else if (!this.calcRadio(subItemRows, 99)) {
                this.calcAvgRadio(subItemRows);
            }
        }
        BigDecimal diff = compAmt;
        for (ActSubItemRow subitemrow : subItemRows) {
            BigDecimal amt = subitemrow.getRadio().multiply(compAmt).setScale(this.args.getAmtScale(), RoundingMode.HALF_UP);
            this.setCalcRadioAmt(subitemrow, type, amt);
            diff = diff.subtract(amt);
        }
        if (diff.compareTo(BigDecimal.ZERO) != 0 && maxRow != null) {
            BigDecimal bigDecimal = this.getCalcRadioAmt(maxRow, type);
            this.setCalcRadioAmt(maxRow, type, bigDecimal.add(diff));
        }
    }

    private void setAllocRadio(List<ActSubItemRow> subItemRows, Map<String, BigDecimal> subItemRadioMap) {
        for (ActSubItemRow actSubItemRow : subItemRows) {
            actSubItemRow.setRadio(BigDecimal.ZERO);
        }
        for (Map.Entry entry : subItemRadioMap.entrySet()) {
            boolean isContains = false;
            for (ActSubItemRow subitemRow2 : subItemRows) {
                String key = String.format("%s@%s", subitemRow2.getSelement(), subitemRow2.getSsubelement());
                if (!((String)entry.getKey()).equals(key)) continue;
                isContains = true;
                subitemRow2.setRadio((BigDecimal)entry.getValue());
                break;
            }
            if (isContains) continue;
            String[] arr = ((String)entry.getKey()).split("@");
            ActSubItemRow subitemRow = new ActSubItemRow();
            subitemRow.setSelement(Long.valueOf(arr[0]));
            subitemRow.setSsubelement(Long.valueOf(arr[1]));
            subitemRow.setRadio((BigDecimal)entry.getValue());
            subItemRows.add(subitemRow);
        }
    }

    private boolean calcRadio(List<ActSubItemRow> subItemRows, int type) {
        BigDecimal currAmt;
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal maxAmt = null;
        for (ActSubItemRow subitemrow : subItemRows) {
            currAmt = this.getCalcRadioAmt(subitemrow, type);
            if (maxAmt == null || maxAmt.compareTo(currAmt) < 0) {
                maxAmt = currAmt;
            }
            totalAmt = totalAmt.add(currAmt);
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0 && maxAmt != null) {
            totalAmt = maxAmt;
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        for (ActSubItemRow subitemrow : subItemRows) {
            currAmt = this.getCalcRadioAmt(subitemrow, type);
            subitemrow.setRadio(currAmt.divide(totalAmt, 10, RoundingMode.HALF_UP));
        }
        return true;
    }

    private void setCalcRadioAmt(ActSubItemRow subitemrow, int type, BigDecimal amt) {
        switch (type) {
            case 0: {
                subitemrow.setSpdstartamt(amt);
                break;
            }
            case 1: {
                subitemrow.setSpdstartadjamt(amt);
                break;
            }
            case 2: {
                subitemrow.setSpdcurramt(amt);
                break;
            }
            case 3: {
                subitemrow.setSpdcomamt(amt);
                break;
            }
            case 4: {
                subitemrow.setSpdendadjamt(amt);
                break;
            }
            case 5: {
                subitemrow.setSpdsumamt(amt);
                break;
            }
            case 6: {
                subitemrow.setSpdyearsumamt(amt);
                break;
            }
            case 7: {
                subitemrow.setSpdsumcomamt(amt);
                break;
            }
            case 8: {
                subitemrow.setSpdyearcomamt(amt);
                break;
            }
        }
    }

    private BigDecimal getCalcRadioAmt(ActSubItemRow subitemrow, int type) {
        switch (type) {
            case 0: {
                return subitemrow.getSpdstartamt();
            }
            case 1: {
                return subitemrow.getSpdstartadjamt();
            }
            case 2: {
                return subitemrow.getSpdcurramt();
            }
            case 3: {
                return subitemrow.getSpdcomamt();
            }
            case 4: {
                return subitemrow.getSpdendadjamt();
            }
            case 5: {
                return subitemrow.getSpdsumamt();
            }
            case 6: {
                return subitemrow.getSpdyearsumamt();
            }
            case 7: {
                return subitemrow.getSpdsumcomamt();
            }
            case 8: {
                return subitemrow.getSpdyearcomamt();
            }
        }
        return subitemrow.getSpdstartamt().add(subitemrow.getSpdstartadjamt()).add(subitemrow.getSpdcurramt());
    }

    private String getCalcCompField(int type) {
        switch (type) {
            case 0: {
                return "pdStartAmt";
            }
            case 1: {
                return "startadjamt";
            }
            case 2: {
                return "amount";
            }
            case 3: {
                return "finAmt";
            }
            case 4: {
                return "endadjamt";
            }
            case 5: {
                return "pdSumAmt";
            }
            case 6: {
                return "yearSumInputAmt";
            }
            case 7: {
                return "sumComAmt";
            }
            case 8: {
                return "yearSumFinishAmt";
            }
        }
        throw new KDBizException("get field error!" + type);
    }

    private void calcAvgRadio(List<ActSubItemRow> subItemRows) {
        BigDecimal evRadio = BigDecimal.ONE.divide(new BigDecimal(subItemRows.size()), 10, RoundingMode.HALF_UP);
        for (ActSubItemRow subitemrow : subItemRows) {
            subitemrow.setRadio(evRadio);
        }
    }
}

