/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CostObjectProductGroupHelper {
    private static final Log logger = LogFactory.getLog(CostObjectProductGroupHelper.class);

    public static Map<String, DynamicObject> getProductGruopMainMatMap(String acctOrgId, Set<Object> mainMatIds, List<Long> mainProBillIds, boolean groupPOGen) {
        DynamicObject[] productGruops;
        Date now = new Date();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        HashMap<String, DynamicObject> productGruopMap = new HashMap<String, DynamicObject>(16);
        qfList.add(new QFilter("grouptype", "=", (Object)"1"));
        QFilter orgQF = new QFilter("calorg", "=", (Object)Long.valueOf(acctOrgId));
        qfList.add(orgQF);
        qfList.add(new QFilter("entryentity.material.masterid", "in", mainMatIds));
        qfList.add(new QFilter("probill", "in", mainProBillIds));
        qfList.add(new QFilter("status", "=", (Object)"C"));
        qfList.add(new QFilter("effectdate", "<=", (Object)now));
        qfList.add(new QFilter("expdate", ">", (Object)now));
        List pgIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_productintogroup", (QFilter[])qfList.toArray(new QFilter[0]), (String)"", (int)-1);
        if (CadEmptyUtils.isEmpty((List)pgIds)) {
            return productGruopMap;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cad_productintogroup");
        for (DynamicObject productGruop : productGruops = BusinessDataServiceHelper.load((Object[])pgIds.toArray(), (DynamicObjectType)dataEntityType)) {
            DynamicObjectCollection pgEntryEntity = productGruop.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyn : pgEntryEntity) {
                if (!"C".equals(entryDyn.getString("producttype"))) continue;
                long probill = productGruop.getLong("probill");
                String pgMatCompoKey = CostObjectProductGroupHelper.getPGMatCompoKey(entryDyn, probill, groupPOGen);
                productGruopMap.put(pgMatCompoKey, productGruop);
            }
        }
        return productGruopMap;
    }

    private static String getPGMatCompoKey(DynamicObject pg) {
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)pg.getLong("material.id"), (String)"bd_material");
        StringBuilder sb = new StringBuilder();
        long materialId = pg.getLong("material.id");
        if (CadEmptyUtils.isEmpty((Long)materialId)) {
            materialId = pg.getLong("material");
        }
        sb.append(pg.get("producttype")).append('@').append(materialId);
        if (BomRouterHelper.isEnableMatversion((DynamicObject)material) && pg.get("matversion") != null) {
            sb.append('@').append(pg.getLong("matversion.id"));
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
            sb.append('@').append(pg.getLong("auxpty.id"));
        }
        return sb.toString();
    }

    private static String getPGMatCompoKey(DynamicObject pg, Long probill, boolean groupPOGen) {
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)pg.getLong("material.id"), (String)"bd_material");
        StringBuilder sb = new StringBuilder();
        long materialId = pg.getLong("material.id");
        if (CadEmptyUtils.isEmpty((Long)materialId)) {
            materialId = pg.getLong("material");
        }
        sb.append(pg.get("producttype")).append('@').append(materialId);
        if (BomRouterHelper.isEnableMatversion((DynamicObject)material) && pg.get("matversion") != null) {
            sb.append('@').append(pg.getLong("matversion.id"));
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
            sb.append('@').append(pg.getLong("auxpty.id"));
        }
        if (groupPOGen) {
            sb.append('@').append(probill);
        }
        return sb.toString();
    }

    public static Map<String, BigDecimal> getProBillBomComp(List<DynamicObject> proBills) {
        HashMap<Long, List> proBillToBomIdMap = new HashMap<Long, List>(16);
        for (DynamicObject proBill : proBills) {
            String productType = proBill.getString("producttype");
            if (!"C".equals(productType)) continue;
            proBillToBomIdMap.computeIfAbsent(proBill.getLong("bomid"), s -> new ArrayList()).add(proBill.getLong("id"));
        }
        String fields = "id,copentry.copentrytype AS copentrytype, copentry.copentrymaterial.masterid AS copentrymaterial, copentry.copentryqty AS copentryqty";
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"pdm_mftbom", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", proBillToBomIdMap.keySet())});
        HashMap<String, String> bomTypeToMftType = new HashMap<String, String>(2);
        bomTypeToMftType.put("10720", "A");
        bomTypeToMftType.put("10730", "B");
        HashMap<String, BigDecimal> bomMatMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject bom : boms) {
            List proBillIds = (List)proBillToBomIdMap.get(bom.getLong("id"));
            for (Long proBillId : proBillIds) {
                StringBuilder matKey = new StringBuilder();
                matKey.append(proBillId).append('@').append((String)bomTypeToMftType.get(bom.get("copentrytype"))).append('@').append(bom.get("copentrymaterial"));
                bomMatMap.put(matKey.toString(), bom.getBigDecimal("copentryqty"));
            }
        }
        return bomMatMap;
    }

    public static Map<Long, List<DynamicObject>> getMatGroupMap(List<DynamicObject> proBillList) {
        HashMap<Long, List<DynamicObject>> matGroupMap = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject row : proBillList) {
            if (!CadEmptyUtils.isEmpty((Long)row.getLong("pnodeId"))) continue;
            matGroupMap.computeIfAbsent(row.getLong("nodeId"), r -> new ArrayList()).add(row);
        }
        for (DynamicObject row : proBillList) {
            if (CadEmptyUtils.isEmpty((Long)row.getLong("pnodeId"))) continue;
            List groupMap = (List)matGroupMap.get(row.getLong("pnodeId"));
            if (groupMap != null) {
                groupMap.add(row);
                continue;
            }
            logger.info("matGroupMap\u7684value\u503c\u4e3anull\u6240\u5bf9\u5e94\u7684key-\u7236\u8282\u70b9ID-pnodeId\uff1a" + row.getLong("pnodeId"));
        }
        return matGroupMap;
    }

    public static DynamicObject getOrCreatPg(Map<String, DynamicObject> pgMainMap, Map.Entry<Long, List<DynamicObject>> proMainMatGroup, Map<String, BigDecimal> proBillBomComp, String acctOrgId, Map<Long, BigDecimal> weightMap, boolean groupPOGen) {
        List<DynamicObject> proMainMatList = proMainMatGroup.getValue();
        DynamicObject productGroup = null;
        if (CollectionUtils.isNotEmpty(proMainMatList) && proMainMatList.size() > 1) {
            DynamicObject mainMatRow = proMainMatList.get(0);
            Long probillId = mainMatRow.getLong("entryid");
            String proMainMatIdKey = CostObjectProductGroupHelper.getProBillMatCompoKey(mainMatRow, probillId, groupPOGen);
            productGroup = pgMainMap.get(String.valueOf(probillId));
            if (productGroup == null) {
                productGroup = pgMainMap.get(proMainMatIdKey);
            }
            if (productGroup != null) {
                DynamicObjectCollection pgEntryEntity = productGroup.getDynamicObjectCollection("entryentity");
                HashSet<String> pgMatSet = new HashSet<String>();
                long probill = productGroup.getLong("probill");
                pgEntryEntity.forEach(pgRow -> pgMatSet.add(CostObjectProductGroupHelper.getPGMatCompoKey(pgRow, probill, groupPOGen)));
                HashMap<Long, BigDecimal> groupWeightMap = new HashMap<Long, BigDecimal>(proMainMatGroup.getValue().size());
                for (DynamicObject proMat : proMainMatGroup.getValue()) {
                    String proBillMatCompoKey = CostObjectProductGroupHelper.getProBillMatCompoKey(proMat, probill, groupPOGen);
                    BigDecimal weight = CostObjectProductGroupHelper.getWeight(proMainMatGroup.getValue(), proMat, proBillBomComp, groupWeightMap);
                    if (pgMatSet.contains(proBillMatCompoKey)) continue;
                    String proBillMatCompoKeyByZeroAuxpty = CostObjectProductGroupHelper.getProBillMatCompoKeyByZeroAuxpty(proMat);
                    if (pgMatSet.contains(proBillMatCompoKeyByZeroAuxpty)) {
                        CostObjectProductGroupHelper.updatePGEntryEntity(pgEntryEntity, proMat, proBillMatCompoKeyByZeroAuxpty, probill, groupPOGen);
                        continue;
                    }
                    CostObjectProductGroupHelper.fillPGEntryEntity(pgEntryEntity, proMat, weight);
                    pgMatSet.add(proBillMatCompoKey);
                }
                weightMap.putAll(groupWeightMap);
                groupWeightMap.clear();
            } else {
                DynamicObject newPG;
                productGroup = newPG = CostObjectProductGroupHelper.creatProductGroup(proMainMatGroup.getValue(), acctOrgId, new Date(), proBillBomComp, weightMap, groupPOGen);
                pgMainMap.put(proMainMatIdKey, newPG);
            }
        }
        return productGroup;
    }

    private static String getProBillMatCompoKey(DynamicObject proBill, Long probill, boolean groupPOGen) {
        StringBuilder sb = new StringBuilder();
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)proBill.get("material"), (String)"bd_material");
        sb.append(proBill.get("producttype")).append('@').append(proBill.get("material"));
        if (BomRouterHelper.isEnableMatversion((DynamicObject)material)) {
            sb.append('@').append(proBill.get("bomversion"));
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
            sb.append('@').append(proBill.get("auxpty"));
        }
        if (groupPOGen) {
            sb.append('@').append(probill);
        }
        return sb.toString();
    }

    private static String getProBillMatCompoKeyByZeroAuxpty(DynamicObject proBill) {
        StringBuilder sb = new StringBuilder();
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)proBill.get("material"), (String)"bd_material");
        sb.append(proBill.get("producttype")).append('@').append(proBill.get("material"));
        if (BomRouterHelper.isEnableMatversion((DynamicObject)material)) {
            sb.append('@').append(proBill.get("bomversion"));
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
            sb.append('@').append("0");
        }
        return sb.toString();
    }

    private static void fillPGEntryEntity(DynamicObjectCollection productGroupEntry, DynamicObject proBill, BigDecimal weight) {
        DynamicObject row = productGroupEntry.addNew();
        row.set("seq", (Object)(productGroupEntry.size() + 1));
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)proBill.get("material"), (String)"bd_material");
        if (BomRouterHelper.isEnableMatversion((DynamicObject)material)) {
            row.set("matversion".concat("_id"), (Object)proBill.getLong("bomversion"));
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)material)) {
            String billtype = proBill.getString("billtype");
            DynamicObject srcAuxpty = CostObjectProductGroupHelper.getAuxptyByManuBill(billtype, proBill.getLong("entryId"));
            long auxptyId = 0L;
            if (srcAuxpty != null && !CadEmptyUtils.isEmpty((DynamicObject)srcAuxpty)) {
                auxptyId = srcAuxpty.getLong("id");
            }
            row.set("auxpty".concat("_id"), (Object)auxptyId);
        }
        row.set("material".concat("_id"), (Object)(material == null ? 0L : material.getLong("id")));
        row.set("producttype", proBill.get("producttype"));
        if ("C".equals(proBill.getString("producttype")) || "A".equals(proBill.getString("producttype"))) {
            row.set("alloctype", (Object)"1");
        } else {
            row.set("alloctype", (Object)"3");
        }
        row.set("weight", (Object)weight);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{row}, (IDataEntityType)row.getDynamicObjectType());
    }

    private static void updatePGEntryEntity(DynamicObjectCollection productGroupEntry, DynamicObject proBill, String proBillMatCompoKeyByZeroAuxpty, Long probill, boolean groupPOGen) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)productGroupEntry)) {
            return;
        }
        for (DynamicObject productGroupRow : productGroupEntry) {
            DynamicObject material;
            String pgMatCompoKey = CostObjectProductGroupHelper.getPGMatCompoKey(productGroupRow, probill, groupPOGen);
            if (!pgMatCompoKey.equals(proBillMatCompoKeyByZeroAuxpty) || !BomRouterHelper.isEnableAuxprop((DynamicObject)(material = BusinessDataServiceHelper.loadSingleFromCache((Object)proBill.get("material"), (String)"bd_material")))) continue;
            String billtype = proBill.getString("billtype");
            DynamicObject srcAuxpty = CostObjectProductGroupHelper.getAuxptyByManuBill(billtype, proBill.getLong("entryId"));
            long auxptyId = 0L;
            if (srcAuxpty != null && !CadEmptyUtils.isEmpty((DynamicObject)srcAuxpty)) {
                auxptyId = srcAuxpty.getLong("id");
            }
            productGroupRow.set("auxpty", (Object)auxptyId);
            productGroupRow.set("auxpty", (Object)auxptyId);
            productGroupRow.set("auxpty".concat("_id"), (Object)auxptyId);
            BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{productGroupRow}, (IDataEntityType)productGroupRow.getDynamicObjectType());
        }
    }

    private static DynamicObject creatProductGroup(List<DynamicObject> proBills, String acctOrgId, Date currdDate, Map<String, BigDecimal> proBillBomComp, Map<Long, BigDecimal> weightMap, boolean groupPOGen) {
        DynamicObject productGroup = BusinessDataServiceHelper.newDynamicObject((String)"cad_productintogroup");
        DynamicObjectCollection productGroupEntry = productGroup.getDynamicObjectCollection("entryentity");
        Long id = DB.genLongId((String)"cad_productintogroup");
        Long orgId = Long.valueOf(acctOrgId);
        DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        productGroup.set("id", (Object)id);
        productGroup.set("masterid", (Object)id);
        productGroup.set("grouptype", (Object)"1");
        productGroup.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        productGroup.set("createtime", (Object)currdDate);
        productGroup.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        productGroup.set("modifytime", (Object)currdDate);
        productGroup.set("status", (Object)"C");
        productGroup.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
        productGroup.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        productGroup.set("enable", (Object)"1");
        productGroup.set("createorg", (Object)orgDy);
        productGroup.set("calorg", (Object)orgDy);
        productGroup.set("ctrlstrategy", (Object)BaseDataServiceHelper.getBdCtrlStrgy((String)"cad_productintogroup", (String)acctOrgId));
        HashSet<String> pgMatSet = new HashSet<String>(10);
        Long probillId = 0L;
        for (DynamicObject proBill : proBills) {
            if (!"C".equals(proBill.getString("producttype"))) continue;
            productGroup.set("name", (Object)proBill.getString("materialName"));
            probillId = proBill.getLong("entryid");
            if (groupPOGen) {
                productGroup.set("srcbillrow", (Object)proBill.getString("entryseq"));
                productGroup.set("srcbillnumber", (Object)proBill.getString("billno"));
                productGroup.set("probill", (Object)probillId);
            } else {
                productGroup.set("probill", (Object)0L);
            }
            BigDecimal weight = CostObjectProductGroupHelper.getWeight(proBills, proBill, proBillBomComp, weightMap);
            String proBillMatCompoKey = CostObjectProductGroupHelper.getProBillMatCompoKey(proBill, probillId, groupPOGen);
            pgMatSet.add(proBillMatCompoKey);
            CostObjectProductGroupHelper.fillPGEntryEntity(productGroupEntry, proBill, weight);
            break;
        }
        for (DynamicObject proBill : proBills) {
            String proBillMatCompoKey;
            if ("C".equals(proBill.getString("producttype")) || !pgMatSet.add(proBillMatCompoKey = CostObjectProductGroupHelper.getProBillMatCompoKey(proBill, probillId, groupPOGen))) continue;
            BigDecimal weight = CostObjectProductGroupHelper.getWeight(proBills, proBill, proBillBomComp, weightMap);
            CostObjectProductGroupHelper.fillPGEntryEntity(productGroupEntry, proBill, weight);
        }
        return productGroup;
    }

    private static BigDecimal getWeight(List<DynamicObject> proBills, DynamicObject proBill, Map<String, BigDecimal> proBillBomComp, Map<Long, BigDecimal> weightMap) {
        if (CadEmptyUtils.isEmpty(weightMap)) {
            BigDecimal total = BigDecimal.ZERO;
            for (DynamicObject bill : proBills) {
                if ("C".equals(bill.getString("producttype"))) {
                    weightMap.put(bill.getLong("entryId"), new BigDecimal("1"));
                    total = total.add(BigDecimal.ONE);
                    continue;
                }
                StringBuilder matKey = new StringBuilder();
                matKey.append(bill.get("id")).append('@').append(bill.get("producttype")).append('@').append(bill.get("material"));
                Object matBomQty = proBillBomComp.get(matKey.toString());
                if (matBomQty == null) {
                    weightMap.put(bill.getLong("entryId"), new BigDecimal("1"));
                    total = total.add(BigDecimal.ONE);
                    continue;
                }
                if (BigDecimal.ZERO.compareTo((BigDecimal)matBomQty) == 0) {
                    logger.info("\u83b7\u53d6\u5230BOM\u4e0a\u7684\u6570\u91cf\u4e3a0\uff0c\u4e0a\u6e38BOM\u914d\u7f6e\u9519\u8bef");
                    matBomQty = BigDecimal.ONE;
                }
                BigDecimal weight = BigDecimal.ONE.divide((BigDecimal)matBomQty, 10, RoundingMode.HALF_UP);
                weightMap.put(bill.getLong("entryId"), weight);
                total = total.add(weight);
            }
            if (BigDecimal.ZERO.compareTo(total) == 0) {
                logger.info("\u6240\u6709\u6743\u91cd\u5408\u4e3a0\uff0c\u7a0b\u5e8f\u9519\u8bef\uff01");
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u6743\u91cd\u548c\u4e3a0\uff0c\u7a0b\u5e8f\u9519\u8bef\u3002", (String)"CostObjectProductGroupHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            }
            Long biggerId = 0L;
            BigDecimal biggerWeight = BigDecimal.ZERO;
            BigDecimal subTotal = BigDecimal.ZERO;
            for (Map.Entry<Long, BigDecimal> weightEntry : weightMap.entrySet()) {
                BigDecimal qty = weightEntry.getValue();
                BigDecimal weight = qty.divide(total, 10, RoundingMode.HALF_UP);
                if (weight.compareTo(biggerWeight) > 0) {
                    biggerWeight = weight;
                    biggerId = weightEntry.getKey();
                }
                weightMap.put(weightEntry.getKey(), weight);
                subTotal = subTotal.add(weight);
            }
            if (subTotal.compareTo(BigDecimal.ONE) != 0) {
                BigDecimal diff = BigDecimal.ONE.subtract(subTotal).abs();
                BigDecimal adjustWeigth = weightMap.get(biggerId).add(diff);
                weightMap.put(biggerId, adjustWeigth);
            }
        }
        return weightMap.get(proBill.getLong("entryId"));
    }

    public static List<DynamicObject> dealProductGroup(Map<String, DynamicObject> pgMainMap) {
        ArrayList<DynamicObject> pgMainObjects = new ArrayList<DynamicObject>(100);
        if (pgMainMap.isEmpty()) {
            return pgMainObjects;
        }
        for (DynamicObject pg : pgMainMap.values()) {
            if (!StringUtils.isEmpty((String)pg.getString("number"))) continue;
            String number = CodeRuleServiceHelper.getNumber((String)"cad_productintogroup", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_productintogroup"), null);
            pg.set("number", (Object)number);
        }
        pgMainObjects.addAll(pgMainMap.values());
        return pgMainObjects;
    }

    public static DynamicObject getMaterialById(Long matId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)matId, (String)"bd_material");
    }

    public static DynamicObject getPropertyBySrcbill(String entity, String propertyField, QFilter qFilter) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)propertyField, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject getAuxptyByManuBill(String entity, Long entryId) {
        DynamicObjectCollection treeEntryEntity;
        QFilter filter = new QFilter("treeentryentity.id", "=", (Object)entryId);
        DynamicObject srcAuxpty = CostObjectProductGroupHelper.getPropertyBySrcbill(entity, "treeentryentity.auxproperty", filter);
        if (srcAuxpty != null && (treeEntryEntity = srcAuxpty.getDynamicObjectCollection("treeentryentity")) != null && !treeEntryEntity.isEmpty()) {
            for (DynamicObject dynamicObject : treeEntryEntity) {
                if (entryId.longValue() != dynamicObject.getLong("id")) continue;
                return dynamicObject.getDynamicObject("auxproperty");
            }
        }
        return null;
    }

    public static Map<String, Set<Long>> getExistCostObjectManuEntryIdsMap(Long org, List<Long> costCenters, List<Long> mftOrderEntryIds) {
        HashMap<String, Set<Long>> existCostObjectManuEntryIdsMap = new HashMap<String, Set<Long>>(16);
        QFilter filters = new QFilter("org", "=", (Object)org);
        filters.and(new QFilter("costcenter", "in", costCenters));
        filters.and(new QFilter("biztype", "in", (Object)"RO"));
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            filters.and("probill", "in", mftOrderEntryIds);
        }
        DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,probill", (QFilter[])new QFilter[]{filters});
        costObjects.forEach(costObject -> existCostObjectManuEntryIdsMap.computeIfAbsent(costObject.getString("org").concat(costObject.getString("costcenter")), p -> new HashSet()).add(costObject.getLong("probill")));
        return existCostObjectManuEntryIdsMap;
    }

    public static Map<Long, Long> getExistEntryIdMainObjMap(Long org, List<Long> costCenters, List<Object> entryIds) {
        HashMap<Long, Long> existEntryIdMainObjMap = new HashMap<Long, Long>(16);
        QFilter filters = new QFilter("org", "=", (Object)org);
        filters.and(new QFilter("biztype", "in", (Object)"RO"));
        filters.and(new QFilter("billstatus", "=", (Object)"C"));
        filters.and(new QFilter("producttype", "=", (Object)"C"));
        filters.and(InFilterHelper.getQFilterByBachSize((String)"probill", entryIds, (String)"in", (int)20000));
        DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"probill,mainproobj", (QFilter[])new QFilter[]{filters});
        costObjects.forEach(costObject -> existEntryIdMainObjMap.put(costObject.getLong("probill"), costObject.getLong("mainproobj")));
        return existEntryIdMainObjMap;
    }

    public static void save(List<DynamicObject> saveItems) {
        if (saveItems.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_costobject");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])saveItems.toArray(new DynamicObject[0]));
    }

    public static Map<String, List<String>> getExistCostObjectMaterialMap(Long acctOrgId, List<Long> costCenterIds, Boolean isUnSettle) {
        DynamicObjectCollection rows;
        HashMap<String, List<String>> matMap = new HashMap<String, List<String>>(200);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)acctOrgId));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        if (isUnSettle.booleanValue()) {
            filters.add(new QFilter("bizstatus", "=", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue()));
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(rows = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,material,bomversion,auxpty", (QFilter[])filters.toArray(new QFilter[0]))))) {
            return matMap;
        }
        for (DynamicObject row : rows) {
            matMap.computeIfAbsent(row.getString("org") + row.getString("costcenter"), p -> new ArrayList(1000)).add(row.getString("material").concat("@").concat(row.getString("bomversion")).concat("@").concat(row.getString("auxpty")));
        }
        return matMap;
    }

    public static Map<Long, DynamicObject> getExistCostObjectNoGroup(Long orgId, Set<Long> entryIds) {
        HashMap<Long, DynamicObject> returnMap = new HashMap<Long, DynamicObject>();
        if (CadEmptyUtils.isEmpty(entryIds)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61");
            return returnMap;
        }
        QFilter productTypeQf = new QFilter("org", "=", (Object)orgId);
        List partArrIds = Lists.partition(new ArrayList<Long>(entryIds), (int)10000);
        for (List list : partArrIds) {
            QFilter proBillIdQF = new QFilter("probill", "in", (Object)list);
            Object[] costObjects = BusinessDataServiceHelper.load((String)"cad_costobject", (String)"billno,entity.srcbillnumber,probill,srcbillrow,productgroup,producttype,weight,mainproobj", (QFilter[])new QFilter[]{proBillIdQF, productTypeQf});
            if (CadEmptyUtils.isEmpty((Object[])costObjects)) continue;
            for (Object costObject : costObjects) {
                long proBill = costObject.getLong("probill");
                if (CadEmptyUtils.isEmpty((Long)proBill)) {
                    logger.info("\u6210\u6838\u7b97\u5bf9\u8c61{}\u5de5\u5355\u5206\u5f55Id \u6216\u8005\u6e90\u5355\u7f16\u53f7\u4e3a\u7a7a", (Object)costObject.getString("billno"));
                    continue;
                }
                returnMap.put(proBill, (DynamicObject)costObject);
            }
        }
        return returnMap;
    }
}

