/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.base.CollectReportContext;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectProductGroupHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.AbstractCostObjectAction;

public class BaseImportDataAction
extends AbstractCostObjectAction {
    private static final Log logger = LogFactory.getLog(BaseImportDataAction.class);

    protected void doExecute() {
        try {
            MetadataServiceHelper.getDataEntityType((String)"pom_mftorder_f7");
        }
        catch (Exception e) {
            logger.error("\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u6743\u9650", (Throwable)e);
            this.getCostObjectContext().getResponseInfo().put("error", ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseImportDataAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        }
    }

    protected void generateObjAndGroup(String orgId, List<Long> reCostCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, List<DynamicObject> mftBills, DynamicObject config, Map<String, DynamicObject> objRules, List<DynamicObject> costObjects, List<DynamicObject> updateCostObjects, List<DynamicObject> productGroups, Map<String, DynamicObject> pgMainMap, Map<Long, Long> entryIdMainObjMap, Map<Long, Long> existEntryIdMainObjMap, Map<String, Set<Long>> existEntryIds, CollectReportContext context, Map<Long, Long> probillCostcenterMap) {
        if (CadEmptyUtils.isEmpty(mftBills) || costObjects == null || productGroups == null || config == null) {
            logger.info("\u53c2\u6570\u9519\u8bef\uff0c\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u53ca\u4ea7\u54c1\u7ec4\u5931\u8d25!");
            return;
        }
        boolean groupPOGen = "1".equals(CadBgParamUtils.getCadBgParamForString((Long)Long.valueOf(orgId), (String)"costobjectPOGen", (String)"1"));
        String selectFields = "id,billno,billtype.billformid AS billtype,treeentryentity.id AS nodeId, treeentryentity.pid AS pnodeId,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.producttype AS producttype,treeentryentity.material.masterid AS material,treeentryentity.material.masterid.number AS materialNumber,treeentryentity.material.masterid.name AS materialName,treeentryentity.material.masterid.modelnum AS materialModelnum,treeentryentity.material.masterid.isenablematerialversion AS isenablematerialversion,treeentryentity.bomid.version AS bomversion,treeentryentity.bomid AS bomid,treeentryentity.auxproperty AS auxpty";
        if (!CadEmptyUtils.isEmpty(mftBills)) {
            HashSet mainMatIds = Sets.newHashSetWithExpectedSize((int)64);
            HashMap unReadyMainMatMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap readyMainMatMap = Maps.newHashMapWithExpectedSize((int)32);
            DynamicObjectCollection mainMatRows = new DynamicObjectCollection();
            Iterator<DynamicObject> iterator = mftBills.iterator();
            while (iterator.hasNext()) {
                DynamicObject mftBill = iterator.next();
                if (!CadEmptyUtils.isEmpty((Long)mftBill.getLong("pnodeId")) || !"C".equals(mftBill.getString("producttype"))) continue;
                readyMainMatMap.computeIfAbsent(mftBill.getLong("nodeId"), dyn -> new ArrayList()).add(mftBill);
                mainMatRows.add((Object)mftBill);
                mainMatIds.add(mftBill.get("material"));
                iterator.remove();
            }
            Iterator<DynamicObject> lfIterator = mftBills.iterator();
            while (lfIterator.hasNext()) {
                DynamicObject lfDynamic = lfIterator.next();
                long entryId = lfDynamic.getLong("pnodeId");
                if (CadEmptyUtils.isEmpty((Long)entryId)) continue;
                if (!readyMainMatMap.containsKey(entryId)) {
                    logger.info("\u5355\u53f7:{},\u884c\u53f7\uff1a{}\uff0c\u5206\u5f55id\uff1a{}\u672a\u627e\u5230\u4e3b\u4ea7\u54c1\u3002\u7b49\u5f85\u67e5\u8be2\u3002", new Object[]{lfDynamic.getString("billno"), lfDynamic.getInt("entryseq"), lfDynamic.getLong("entryId")});
                    unReadyMainMatMap.computeIfAbsent(entryId, dyn -> new ArrayList()).add(lfDynamic);
                    continue;
                }
                readyMainMatMap.computeIfAbsent(entryId, dyn -> new ArrayList()).add(lfDynamic);
                lfIterator.remove();
            }
            HashSet costObjTrue = Sets.newHashSetWithExpectedSize((int)8);
            if (!CadEmptyUtils.isEmpty((Map)unReadyMainMatMap)) {
                Set mainMatEntryIds = unReadyMainMatMap.keySet();
                QFilter orgQf = new QFilter("org", "=", (Object)Long.valueOf(orgId));
                QFilter proBillQf = InFilterHelper.getQFilterByBachSize((String)"probill", new ArrayList(mainMatEntryIds), (String)"in", (int)20000);
                HashSet<Long> cbMainIds = new HashSet<Long>(10);
                DynamicObjectCollection costObjs = QueryServiceHelper.query((String)"cad_costobject", (String)"id,probill", (QFilter[])new QFilter[]{orgQf, proBillQf});
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costObjs)) {
                    for (DynamicObject costObj : costObjs) {
                        costObjTrue.add(costObj.getLong("probill"));
                        cbMainIds.add(costObj.getLong("id"));
                    }
                }
                QFilter entryIdQf = InFilterHelper.getQFilterByBachSize((String)"treeentryentity.id", new ArrayList(mainMatEntryIds), (String)"in", (int)20000);
                DynamicObjectCollection extraMainBills = QueryServiceHelper.query((String)"generateObjAndGroup_mft", (String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{entryIdQf}, (String)"treeentryentity.id asc");
                extraMainBills.addAll((Collection)QueryServiceHelper.query((String)"generateObjAndGroup_om", (String)"om_mftorder", (String)selectFields, (QFilter[])new QFilter[]{entryIdQf}, (String)"treeentryentity.id asc"));
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)extraMainBills)) {
                    for (DynamicObject extraMainBill : extraMainBills) {
                        long entryId = extraMainBill.getLong("entryId");
                        mainMatIds.add(extraMainBill.get("material"));
                        if (costObjTrue.contains(entryId)) {
                            readyMainMatMap.computeIfAbsent(entryId, dyn -> new ArrayList()).add(extraMainBill);
                            readyMainMatMap.computeIfAbsent(entryId, dyn -> new ArrayList()).addAll((Collection)unReadyMainMatMap.get(entryId));
                            mainMatRows.add((Object)extraMainBill);
                            continue;
                        }
                        List dynamicObjects = (List)unReadyMainMatMap.get(entryId);
                        for (DynamicObject dynamicObject : dynamicObjects) {
                            String billNo = dynamicObject.getString("billno");
                            String seq = dynamicObject.getString("entryseq");
                            context.logErrorMsg(billNo.concat("@").concat(seq).concat("@").concat(" "), ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u4e3b\u4ea7\u54c1\u5f00\u5de5\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u5f52\u96c6\u65f6\u95f4\u8303\u56f4\u4e14\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"BaseImportDataAction_48", (String)"macc-cad-mservice", (Object[])new Object[0]));
                            logger.info("\u6e90\u5355\u7f16\u53f7:{},\u884c\u53f7\uff1a{}\u5bf9\u5e94\u7684\u4e3b\u4ea7\u54c1\u5f00\u5de5\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u5f52\u96c6\u8303\u56f4\u4e14\u672a\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61,\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25!", (Object)billNo, (Object)seq);
                        }
                    }
                }
                proBillQf = InFilterHelper.getQFilterByBachSize((String)"mainproobj", new ArrayList(cbMainIds), (String)"in", (int)20000);
                DataSet joinObjs = QueryServiceHelper.queryDataSet((String)"cb", (String)"cad_costobject", (String)"probill", (QFilter[])new QFilter[]{orgQf, proBillQf}, null);
                HashSet<Long> joinObjEntryIds = new HashSet<Long>(10);
                for (Row row : joinObjs) {
                    joinObjEntryIds.add(row.getLong("probill"));
                }
                entryIdQf = InFilterHelper.getQFilterByBachSize((String)"treeentryentity.id", new ArrayList(joinObjEntryIds), (String)"in", (int)20000);
                extraMainBills = QueryServiceHelper.query((String)"generateObjAndGroup_mft", (String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{entryIdQf}, (String)"treeentryentity.id asc");
                extraMainBills.addAll((Collection)QueryServiceHelper.query((String)"generateObjAndGroup_om", (String)"om_mftorder", (String)selectFields, (QFilter[])new QFilter[]{entryIdQf}, (String)"treeentryentity.id asc"));
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)extraMainBills)) {
                    for (DynamicObject extraMainBill : extraMainBills) {
                        long entryId = extraMainBill.getLong("entryId");
                        long pnodeId = extraMainBill.getLong("pnodeId");
                        if (!readyMainMatMap.containsKey(pnodeId)) continue;
                        List dyns = (List)readyMainMatMap.get(pnodeId);
                        boolean contains = false;
                        for (DynamicObject dyn2 : dyns) {
                            if (dyn2.getLong("entryId") != entryId) continue;
                            contains = true;
                        }
                        if (contains) continue;
                        dyns.add(extraMainBill);
                    }
                }
            }
            if (!CadEmptyUtils.isEmpty((Set)mainMatIds)) {
                ArrayList<Long> mainProBillIds = new ArrayList<Long>();
                if (groupPOGen) {
                    for (DynamicObject proBill : mainMatRows) {
                        String productType = proBill.getString("producttype");
                        if (!"C".equals(productType)) continue;
                        mainProBillIds.add(proBill.getLong("entryId"));
                    }
                } else {
                    mainProBillIds.add(0L);
                }
                Map productGroupMainMatMap = CostObjectProductGroupHelper.getProductGruopMainMatMap((String)orgId, (Set)mainMatIds, mainProBillIds, (boolean)groupPOGen);
                pgMainMap.putAll(productGroupMainMatMap);
            }
            HashSet existCostObjIds = Sets.newHashSet();
            for (List values : readyMainMatMap.values()) {
                for (DynamicObject dyn3 : values) {
                    existCostObjIds.add(dyn3.getLong("entryId"));
                }
            }
            DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(orgId), (String)"bos_org");
            Map existCostObjectNoGroup = CostObjectProductGroupHelper.getExistCostObjectNoGroup((Long)Long.valueOf(orgId), (Set)existCostObjIds);
            this.dealExistProductGroup(existCostObjectNoGroup, pgMainMap);
            Map proBillBomComp = CostObjectProductGroupHelper.getProBillBomComp((List)mainMatRows);
            for (Map.Entry entryIdGroupMap : readyMainMatMap.entrySet()) {
                HashMap weightMap = new HashMap(8);
                DynamicObject productGroup = CostObjectProductGroupHelper.getOrCreatPg(pgMainMap, entryIdGroupMap, (Map)proBillBomComp, (String)orgId, weightMap, (boolean)groupPOGen);
                List groupMats = (List)entryIdGroupMap.getValue();
                for (DynamicObject proBill : groupMats) {
                    DynamicObject targetBill = srcAndTargetBillsMap.get(proBill);
                    if (targetBill == null) {
                        if (!CadEmptyUtils.isEmpty((Map)existCostObjectNoGroup) && existCostObjectNoGroup.containsKey(proBill.getLong("entryId"))) {
                            DynamicObject updateCostObject = (DynamicObject)existCostObjectNoGroup.get(proBill.getLong("entryId"));
                            if (updateCostObject == null || productGroup == null) continue;
                            logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61:{}\u8bbe\u7f6e\u4ea7\u54c1\u7ec4\uff1a{}", (Object)updateCostObject.getString("billno"), (Object)productGroup.getString("number"));
                            boolean needUpdate = false;
                            DynamicObject cbProductGroup = updateCostObject.getDynamicObject("productgroup");
                            BigDecimal cbWeight = updateCostObject.getBigDecimal("weight");
                            Long proObjId = updateCostObject.getLong("mainproobj");
                            if (cbProductGroup == null || cbProductGroup.getLong("id") != productGroup.getLong("id")) {
                                updateCostObject.set("productgroup", productGroup.get("id"));
                                needUpdate = true;
                            }
                            BigDecimal weight = null;
                            if ("C".equals(proBill.get("producttype"))) {
                                weight = BigDecimal.ONE;
                            }
                            if (weightMap.containsKey(proBill.getLong("entryId"))) {
                                weight = (BigDecimal)weightMap.get(proBill.getLong("entryId"));
                            }
                            if (weight != null && weight.compareTo(cbWeight) != 0) {
                                updateCostObject.set("weight", (Object)weight);
                                needUpdate = true;
                            }
                            if ("C".equals(updateCostObject.getString("producttype"))) {
                                entryIdMainObjMap.put(proBill.getLong("entryId"), updateCostObject.getLong("id"));
                                existEntryIdMainObjMap.put(proBill.getLong("entryId"), updateCostObject.getLong("id"));
                            } else if (!CadEmptyUtils.isEmpty(entryIdMainObjMap) && entryIdMainObjMap.containsKey(updateCostObject.getLong("id"))) {
                                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a{}\u8bbe\u7f6e\u4e3b\u4ea7\u54c1\u6210\u672c\u6838\u7b97\u5bf9\u8c61id", (Object)updateCostObject.getString("billno"));
                                if (CadEmptyUtils.isEmpty((Long)proObjId) || !entryIdMainObjMap.get(proBill.getLong("entryId")).equals(proObjId)) {
                                    updateCostObject.set("mainproobj", (Object)entryIdMainObjMap.get(proBill.getLong("entryId")));
                                    needUpdate = true;
                                }
                            }
                            if (!needUpdate) continue;
                            updateCostObjects.add(updateCostObject);
                            continue;
                        }
                        if (costObjTrue.contains(proBill.getLong("entryId"))) continue;
                        context.logErrorMsg(proBill.getString("billno").concat("@").concat(proBill.getString("entryseq")).concat("@").concat(proBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u3002", (String)"BaseImportDataAction_58", (String)"macc-cad-mservice", (Object[])new Object[0]), proBill.getString("billno"), proBill.getString("entryseq")));
                        continue;
                    }
                    Long costCenterId = targetBill.getLong("costcenter.id");
                    if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                        context.logErrorMsg(proBill.getString("billno").concat("@").concat(proBill.getString("entryseq")).concat("@").concat(proBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"BaseImportDataAction_59", (String)"macc-cad-mservice", (Object[])new Object[0]), proBill.getString("billno"), proBill.getString("entryseq")));
                        continue;
                    }
                    if (!reCostCenters.contains(costCenterId)) continue;
                    String key = orgId.concat("@").concat(String.valueOf(costCenterId)).concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                    DynamicObject rule = objRules.get(key);
                    if (rule == null) {
                        key = orgId.concat("@").concat(config.getString("calmethod")).concat("@").concat(config.getString("costcalcdimension.id"));
                        rule = objRules.get(key);
                    }
                    if (rule == null) {
                        context.logErrorMsg(proBill.getString("billno").concat("@").concat(proBill.getString("entryseq")).concat("@").concat(proBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"BaseImportDataAction_60", (String)"macc-cad-mservice", (Object[])new Object[0]), proBill.getString("billno"), proBill.getString("entryseq")));
                        continue;
                    }
                    Set<Long> existCostObjectManuEntryIds = existEntryIds.get(orgId);
                    if (!CadEmptyUtils.isEmpty(existCostObjectManuEntryIds) && existCostObjectManuEntryIds.contains(proBill.getLong("entryId"))) {
                        Long srcCostcenterId;
                        if (probillCostcenterMap != null && probillCostcenterMap.containsKey(proBill.getLong("entryId")) && !costCenterId.equals(srcCostcenterId = probillCostcenterMap.get(proBill.getLong("entryId")))) {
                            context.logErrorMsg(proBill.getString("billno").concat("@").concat(proBill.getString("entryseq")).concat("@").concat(proBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u4e0e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e00\u81f4\u3002", (String)"BaseImportDataAction_76", (String)"macc-cad-mservice", (Object[])new Object[0]), proBill.getString("billno"), proBill.getString("entryseq")));
                        }
                        if (!CadEmptyUtils.isEmpty(existEntryIdMainObjMap)) {
                            Long mainObjId = existEntryIdMainObjMap.get(proBill.getLong("entryId"));
                            if (!CadEmptyUtils.isEmpty((Long)mainObjId)) {
                                entryIdMainObjMap.put(proBill.getLong("entryId"), mainObjId);
                            } else {
                                DynamicObject updateCostObject;
                                if (CadEmptyUtils.isEmpty((Map)existCostObjectNoGroup) || (updateCostObject = (DynamicObject)existCostObjectNoGroup.get(proBill.getLong("entryId"))) == null || productGroup == null) continue;
                                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61:{}\u8bbe\u7f6e\u4ea7\u54c1\u7ec4\uff1a{}", (Object)updateCostObject.getString("billno"), (Object)productGroup.getString("number"));
                                boolean needUpdate = false;
                                DynamicObject cbProductGroup = updateCostObject.getDynamicObject("productgroup");
                                BigDecimal cbWeight = updateCostObject.getBigDecimal("weight");
                                Long proObjId = updateCostObject.getLong("mainproobj");
                                if (cbProductGroup == null || cbProductGroup.getLong("id") != productGroup.getLong("id")) {
                                    updateCostObject.set("productgroup", productGroup.get("id"));
                                    needUpdate = true;
                                }
                                BigDecimal weight = null;
                                if ("C".equals(proBill.get("producttype"))) {
                                    weight = BigDecimal.ONE;
                                }
                                if (weightMap.containsKey(proBill.getLong("entryId"))) {
                                    weight = (BigDecimal)weightMap.get(proBill.getLong("entryId"));
                                }
                                if (weight != null && weight.compareTo(cbWeight) != 0) {
                                    updateCostObject.set("weight", (Object)weight);
                                    needUpdate = true;
                                }
                                if ("C".equals(updateCostObject.getString("producttype"))) {
                                    entryIdMainObjMap.put(proBill.getLong("entryId"), updateCostObject.getLong("id"));
                                    existEntryIdMainObjMap.put(proBill.getLong("entryId"), updateCostObject.getLong("id"));
                                } else if (!CadEmptyUtils.isEmpty(entryIdMainObjMap) && entryIdMainObjMap.containsKey(proBill.getLong("entryId"))) {
                                    logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a{}\u8bbe\u7f6e\u4e3b\u4ea7\u54c1\u6210\u672c\u6838\u7b97\u5bf9\u8c61id", (Object)updateCostObject.getString("billno"));
                                    if (CadEmptyUtils.isEmpty((Long)proObjId) || !entryIdMainObjMap.get(proBill.getLong("entryId")).equals(proObjId)) {
                                        updateCostObject.set("mainproobj", (Object)entryIdMainObjMap.get(proBill.getLong("entryId")));
                                        needUpdate = true;
                                    }
                                }
                                if (!needUpdate) continue;
                                updateCostObjects.add(updateCostObject);
                                continue;
                            }
                        }
                        context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"BaseImportDataAction_61", (String)"macc-cad-mservice", (Object[])new Object[0]), proBill.getString("billno"), proBill.getString("entryseq")));
                        continue;
                    }
                    DynamicObject costObject = this.generateCostObjectBySrcBill(Long.valueOf(orgId), proBill, targetBill, rule);
                    if (costObject == null) {
                        context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\u3002", (String)"BaseImportDataAction_62", (String)"macc-cad-mservice", (Object[])new Object[0]), proBill.getString("billno"), proBill.getString("entryseq")));
                        continue;
                    }
                    if (productGroup != null && "C".equals(costObject.getString("producttype"))) {
                        entryIdMainObjMap.put((Long)entryIdGroupMap.getKey(), costObject.getLong("id"));
                    }
                    Long mainObjId = entryIdMainObjMap.get(entryIdGroupMap.getKey());
                    if (!"C".equals(costObject.getString("producttype")) && !CadEmptyUtils.isEmpty((Long)mainObjId)) {
                        entryIdMainObjMap.put(proBill.getLong("entryId"), mainObjId);
                    }
                    BigDecimal weight = null;
                    if ("C".equals(proBill.get("producttype"))) {
                        weight = BigDecimal.ONE;
                    }
                    if (weightMap.containsKey(costObject.getLong("probill"))) {
                        weight = (BigDecimal)weightMap.get(costObject.getLong("probill"));
                    }
                    costObject.set("weight", (Object)weight);
                    existEntryIds.computeIfAbsent(orgId, p -> new HashSet(10)).add(costObject.getLong("probill"));
                    this.updateInfo(productGroup, costObject, mainObjId, orgDy);
                    costObjects.add(costObject);
                }
            }
        }
        productGroups.addAll(CostObjectProductGroupHelper.dealProductGroup(pgMainMap));
    }

    private void dealExistProductGroup(Map<Long, DynamicObject> existCostObjectNoGroup, Map<String, DynamicObject> productGroupMainMatMap) {
        Long groupId;
        ArrayList<Long> groupIds = new ArrayList<Long>(10);
        HashMap<Long, List> groupToProbillMap = new HashMap<Long, List>(10);
        for (DynamicObject dynamicObject : existCostObjectNoGroup.values()) {
            DynamicObject cbProductGroup;
            String producttype = dynamicObject.getString("producttype");
            if (!"C".equals(producttype) || (cbProductGroup = dynamicObject.getDynamicObject("productgroup")) == null) continue;
            groupId = cbProductGroup.getLong("id");
            groupIds.add(groupId);
            Long probill = dynamicObject.getLong("probill");
            if (CadEmptyUtils.isEmpty((Long)probill)) continue;
            groupToProbillMap.computeIfAbsent(groupId, t -> new ArrayList(10)).add(probill);
        }
        if (groupIds.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> groupDynMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject pgp : productGroupMainMatMap.values()) {
            Long groupId2 = pgp.getLong("id");
            groupDynMap.put(groupId2, pgp);
        }
        groupIds.removeAll(groupDynMap.keySet());
        ArrayList arrayList = new ArrayList(10);
        arrayList.addAll(groupDynMap.values());
        if (!groupIds.isEmpty()) {
            DynamicObject[] productGruops = BusinessDataServiceHelper.load((Object[])groupIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_productintogroup"));
            Collections.addAll(arrayList, productGruops);
        }
        for (DynamicObject pgp : arrayList) {
            groupId = pgp.getLong("id");
            List probillIds = (List)groupToProbillMap.get(groupId);
            if (probillIds == null) continue;
            for (Long probill : probillIds) {
                productGroupMainMatMap.put(String.valueOf(probill), pgp);
            }
        }
    }

    protected DynamicObject generateCostObjectBySrcBill(Long acctOrgId, DynamicObject proBill, DynamicObject costObject, DynamicObject rule) {
        if (costObject == null || rule == null) {
            return null;
        }
        DynamicObject costCenter = costObject.getDynamicObject("costcenter");
        String ruleAss = rule.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = rule.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        String[] ruleNumberExt = rule.getString("rulenumberext").split(",");
        String[] ruleNameExt = rule.getString("rulenameext").split(",");
        String srcNum = proBill.getString("billno");
        String srcRow = proBill.getString("entryseq");
        DynamicObject material = costObject.getDynamicObject("material");
        costObject.set("material", (Object)material.getLong("id"));
        String materialNumber = material.getString("number");
        String materialName = material.getString("name");
        String materialModelnum = material.getString("modelnum");
        String billNo = ruleAss + srcNum + "-" + srcRow;
        if (Arrays.asList(ruleNumberExt).contains("CR_CPBM") && !CadEmptyUtils.isEmpty((String)materialNumber)) {
            billNo = billNo + "-" + materialNumber;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty((String)materialModelnum)) {
            billNo = billNo + "-" + materialModelnum;
        }
        costObject.set("id", (Object)DB.genLongId((String)"cad_costobject"));
        costObject.set("costobjectrule", rule.get("id"));
        costObject.set("org", (Object)acctOrgId);
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)rule.getString("sotype"));
        costObject.set("rule", (Object)rule.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_CONFIG.getValue());
        costObject.set("biztype", (Object)rule.getString("biztype"));
        if (StringUtils.isEmpty((String)costObject.getString("producttype"))) {
            costObject.set("producttype", proBill.get("producttype"));
        }
        costObject.set("weight", (Object)1);
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String billName = ruleNameAss + srcNum + "-" + srcRow;
        if (Arrays.asList(ruleNameExt).contains("CRN_CPMC") && !CadEmptyUtils.isEmpty((String)materialName)) {
            billName = billName + "-" + materialName;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty((String)materialModelnum)) {
            billName = billName + "-" + materialModelnum;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)new LocaleString(billName));
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if ("C".equals(costObject.getString("billstatus"))) {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    protected DynamicObject generateMeterialCostObjectBySrcBill(Long acctOrgId, DynamicObject costObject, DynamicObject ruleItem) {
        if (costObject == null || ruleItem == null) {
            return null;
        }
        DynamicObject costCenter = costObject.getDynamicObject("costcenter");
        String srcNo = costObject.getString("producenum");
        String ruleAss = ruleItem.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = ruleItem.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        DynamicObject material = costObject.getDynamicObject("material");
        costObject.set("material", (Object)material.getLong("id"));
        String matNumber = material.getString("number");
        String matName = material.getString("name");
        String modelnum = material.getString("modelnum");
        String[] ruleNumberExt = ruleItem.getString("rulenumberext").split(",");
        String[] ruleNameExt = ruleItem.getString("rulenameext").split(",");
        String billNo = ruleAss + matNumber;
        String bizType = ruleItem.getString("biztype");
        if (!CadEmptyUtils.isEmpty((String)srcNo) && CostObjectEnum.BIZTYPE_SO.getValue().equals(bizType)) {
            billNo = billNo + "-" + srcNo;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty((String)modelnum)) {
            billNo = billNo + "-" + modelnum;
        }
        costObject.set("costobjectrule", ruleItem.get("id"));
        costObject.set("org", (Object)acctOrgId);
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)ruleItem.getString("sotype"));
        costObject.set("rule", (Object)ruleItem.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_CONFIG.getValue());
        costObject.set("biztype", (Object)bizType);
        long auxpty = costObject.getLong("auxpty");
        String auxptyIdStr = "";
        if (!CadEmptyUtils.isEmpty((Long)auxpty) && !CostObjectEnum.BIZTYPE_RO.getValue().equals(ruleItem.getString("biztype")) && (auxptyIdStr = String.valueOf(auxpty)).length() > 5) {
            auxptyIdStr = auxptyIdStr.substring(auxptyIdStr.length() - 5);
        }
        if (!CadEmptyUtils.isEmpty((String)auxptyIdStr)) {
            billNo = billNo + "-" + auxptyIdStr;
        }
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String billName = ruleNameAss + matName;
        if (!CadEmptyUtils.isEmpty((String)srcNo) && CostObjectEnum.BIZTYPE_SO.getValue().equals(bizType)) {
            billName = billName + "-" + srcNo;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty((String)modelnum)) {
            billName = billName + "-" + modelnum;
        }
        if (!CadEmptyUtils.isEmpty((String)auxptyIdStr)) {
            billName = billName + "-" + auxptyIdStr;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)new LocaleString(billName));
        costObject.set("producttype", (Object)"C");
        costObject.set("weight", (Object)1);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if (CostObjectEnum.BIZTYPE_FL.getValue().equals(ruleItem.getString("biztype")) || CostObjectEnum.BIZTYPE_SO.getValue().equals(ruleItem.getString("biztype")) && CadEmptyUtils.isEmpty((String)srcNo)) {
            costObject.set("billstatus", (Object)"A");
        }
        if ("C".equals(costObject.getString("billstatus"))) {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    protected DynamicObject generateDimensionCostObjectBySrcBill(Long acctOrgId, DynamicObject srcBill, DynamicObject costObject, DynamicObject ruleItem, Map<String, Map<String, String>> baseDataInfoMap) {
        if (costObject == null || ruleItem == null) {
            return null;
        }
        DynamicObject costCenter = costObject.getDynamicObject("costcenter");
        String ccNumber = costCenter.getString("number");
        String ccName = costCenter.getLocaleString("name").getLocaleValue();
        String ruleNumberExt = ruleItem.getString("rulenumberext");
        String ruleNameExt = ruleItem.getString("rulenameext");
        String billNo = this.getCostObjectNumber(srcBill, costObject, ruleNumberExt, ccNumber, baseDataInfoMap);
        String billName = this.getCostObjectName(srcBill, costObject, ruleNameExt, ccName, baseDataInfoMap);
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)new LocaleString(billName));
        DynamicObject material = costObject.getDynamicObject("material");
        if (material != null) {
            costObject.set("material", (Object)material.getLong("id"));
        }
        costObject.set("costobjectrule", ruleItem.get("id"));
        costObject.set("org", (Object)acctOrgId);
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)ruleItem.getString("sotype"));
        costObject.set("rule", (Object)ruleItem.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_CONFIG.getValue());
        costObject.set("biztype", (Object)ruleItem.getString("biztype"));
        costObject.set("producttype", (Object)"C");
        costObject.set("weight", (Object)1);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if ("C".equals(costObject.getString("billstatus"))) {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    protected DynamicObject generateCostObjectBySrcBill(Long acctOrgId, DynamicObject srcBill, DynamicObject costObject, DynamicObject ruleItem, Map<String, Map<String, String>> baseDataInfoMap) {
        String objRule;
        if (costObject == null || ruleItem == null) {
            return null;
        }
        DynamicObject costCenter = costObject.getDynamicObject("costcenter");
        String ccNumber = costCenter.getString("number");
        String ccName = costCenter.getLocaleString("name").getLocaleValue();
        switch (objRule = ruleItem.getString("objrule")) {
            case "CR_SRC": {
                ccNumber = ccNumber.concat("-") + (srcBill.get("billno") == null ? "null" : srcBill.getString("billno"));
                ccNumber = ccNumber.concat("-") + (srcBill.get("entryseq") == null ? "0" : srcBill.getString("entryseq"));
                ccName = ccName.concat("-") + (srcBill.get("billno") == null ? "null" : srcBill.getString("billno"));
                ccName = ccName.concat("-") + (srcBill.get("entryseq") == null ? "0" : srcBill.getString("entryseq"));
                break;
            }
            case "CR_COP": {
                Map<String, String> projectnumber = baseDataInfoMap.get("projectnumber@" + costObject.getString("projectnumber"));
                if (CadEmptyUtils.isEmpty(projectnumber)) break;
                ccNumber = ccNumber.concat("-") + projectnumber.keySet().iterator().next();
                ccName = ccName.concat("-") + projectnumber.keySet().iterator().next();
                break;
            }
        }
        String ruleNumberExt = ruleItem.getString("rulenumberext");
        String ruleNameExt = ruleItem.getString("rulenameext");
        String billNo = this.getCostObjectNumber(srcBill, costObject, ruleNumberExt, ccNumber, baseDataInfoMap);
        String billName = this.getCostObjectName(srcBill, costObject, ruleNameExt, ccName, baseDataInfoMap);
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)new LocaleString(billName));
        costObject.set("costobjectrule", ruleItem.get("id"));
        costObject.set("org", (Object)acctOrgId);
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)ruleItem.getString("sotype"));
        costObject.set("rule", (Object)ruleItem.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_CONFIG.getValue());
        costObject.set("biztype", (Object)ruleItem.getString("biztype"));
        costObject.set("producttype", (Object)"C");
        costObject.set("weight", (Object)1);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if ("C".equals(costObject.getString("billstatus"))) {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    protected Map<String, Map<String, String>> getBaseDataInfoMap(List<DynamicObject> targetBillColls, Set<String> objectFields) {
        HashMap<String, Map<String, String>> dataInfoMap = new HashMap<String, Map<String, String>>(16);
        if (CadEmptyUtils.isEmpty(targetBillColls)) {
            return dataInfoMap;
        }
        HashSet<Long> matIds = new HashSet<Long>(10);
        HashSet<Long> pzIds = new HashSet<Long>(10);
        HashSet<Long> gzIds = new HashSet<Long>(10);
        HashSet<Long> xmIds = new HashSet<Long>(10);
        for (DynamicObject targetBillColl : targetBillColls) {
            for (String objectField : objectFields) {
                if (objectField.contains("material")) {
                    matIds.add(targetBillColl.getLong(objectField + ".id"));
                }
                if (objectField.contains("configuredcode")) {
                    pzIds.add(targetBillColl.getLong(objectField));
                }
                if (objectField.contains("tracknumber")) {
                    gzIds.add(targetBillColl.getLong(objectField));
                }
                if (!objectField.contains("projectnumber")) continue;
                xmIds.add(targetBillColl.getLong(objectField));
            }
        }
        DataSet matDataSet = QueryServiceHelper.queryDataSet((String)"getBaseDataInfoMap", (String)"bd_material", (String)"masterid as id,number,name,'material' as type", (QFilter[])new QFilter[]{new QFilter("masterid", "in", matIds)}, null);
        DataSet pzDataSet = QueryServiceHelper.queryDataSet((String)"getBaseDataInfoMap", (String)"bd_configuredcode", (String)"id,number,number as name,'configuredcode' as type", (QFilter[])new QFilter[]{new QFilter("id", "in", pzIds)}, null);
        DataSet gzDataSet = QueryServiceHelper.queryDataSet((String)"getBaseDataInfoMap", (String)"bd_tracknumber", (String)"id,number,number as name,'tracknumber' as type", (QFilter[])new QFilter[]{new QFilter("id", "in", gzIds)}, null);
        DataSet xmDataSet = QueryServiceHelper.queryDataSet((String)"getBaseDataInfoMap", (String)"bd_project", (String)"id,number,number as name,'projectnumber' as type", (QFilter[])new QFilter[]{new QFilter("id", "in", xmIds)}, null);
        DataSet dataSet = matDataSet.union(new DataSet[]{pzDataSet, gzDataSet, xmDataSet});
        if (dataSet.isEmpty()) {
            return dataInfoMap;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            HashMap<String, String> info = new HashMap<String, String>(2);
            info.put(row.getString("number"), row.getString("name"));
            dataInfoMap.put(row.getString("type") + "@" + row.getString("id"), info);
        }
        return dataInfoMap;
    }

    protected Map<String, Map<String, String>> getBaseDataInfoMap(Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, String> configMappingMap, String sourceBillEntry) {
        IDataEntityProperty property;
        HashMap<String, Map<String, String>> dataInfoMap = new HashMap<String, Map<String, String>>(16);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap) || CadEmptyUtils.isEmpty(configMappingMap)) {
            return dataInfoMap;
        }
        HashSet<Long> srcIds = new HashSet<Long>(10);
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
            DynamicObject source = srcAndTargetBills.getKey();
            srcIds.add(source.getLong("id"));
        }
        HashSet<String> costSelectFieldSet = new HashSet<String>(10);
        HashSet<String> selectFieldSet = new HashSet<String>(10);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntry);
        for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
            String targetField = configMapping.getKey();
            if ("costcenter".equals(targetField)) continue;
            String srcField = configMapping.getValue();
            if (srcField.contains(".")) {
                String[] split = srcField.split("\\.");
                String entryEntity = split[0];
                String field = split[1];
                property = mainEntityType.findProperty(field);
                if (property == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u627e\u6e90\u5355\u5b57\u6bb5\u7c7b\u578b\u5931\u8d25\uff0c\u6e90\u5355\u5b57\u6bb5\u6807\u8bc6\u201c%s\u201d\u3002", (String)"BaseImportDataAction_53", (String)"macc-cad-mservice", (Object[])new Object[0]), srcField));
                }
                if (FlexProp.class.isAssignableFrom(property.getClass()) || split.length > 2 && !"material".equals(field) || !(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) continue;
                selectFieldSet.add(srcField);
                selectFieldSet.add(srcField + ".number");
                selectFieldSet.add(srcField + ".name");
                costSelectFieldSet.add(targetField);
                continue;
            }
            IDataEntityProperty property2 = mainEntityType.findProperty(srcField);
            if (FlexProp.class.isAssignableFrom(property2.getClass()) || !(property2 instanceof BasedataProp) && !(property2 instanceof MulBasedataProp)) continue;
            selectFieldSet.add(srcField);
            selectFieldSet.add(srcField + ".number");
            selectFieldSet.add(srcField + ".name");
            costSelectFieldSet.add(targetField);
        }
        String selectFields = String.join((CharSequence)",", selectFieldSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getBaseDataInfoMap", (String)sourceBillEntry, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)}, null);
        if (dataSet.isEmpty()) {
            return dataInfoMap;
        }
        MainEntityType costObjectMainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costobject");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            for (String targetField : costSelectFieldSet) {
                String srcField = configMappingMap.get(targetField);
                if (dataInfoMap.get(targetField + "@" + row.getString(srcField)) != null || !((property = costObjectMainEntityType.findProperty(targetField)) instanceof BasedataProp) && !(property instanceof MulBasedataProp) || CadEmptyUtils.isEmpty((String)row.getString(srcField))) continue;
                HashMap<String, String> info = new HashMap<String, String>(2);
                info.put(row.getString(srcField + ".number"), CadEmptyUtils.isEmpty((String)row.getString(srcField + ".name")) ? row.getString(srcField + ".number") : row.getString(srcField + ".name"));
                dataInfoMap.put(targetField + "@" + row.getString(srcField), info);
            }
        }
        return dataInfoMap;
    }

    protected String getCostObjectNumber(DynamicObject srcBill, DynamicObject costObject, String dimension, String targetStr, Map<String, Map<String, String>> baseDataInfoMap) {
        String[] dimensionStr;
        if (CadEmptyUtils.isEmpty((String)dimension)) {
            return targetStr;
        }
        String[] stringArray = dimensionStr = dimension.split(",");
        int n = stringArray.length;
        block21: for (int i = 0; i < n; ++i) {
            String dim;
            switch (dim = stringArray[i]) {
                case "YDDH": {
                    targetStr = targetStr.concat("-") + (srcBill.get("billno") == null ? "null" : srcBill.getString("billno"));
                    continue block21;
                }
                case "YDHH": {
                    targetStr = targetStr.concat("-") + (srcBill.get("entryseq") == null ? "0" : srcBill.getString("entryseq"));
                    continue block21;
                }
                case "CP": {
                    Map<String, String> material = baseDataInfoMap.get("material@" + costObject.getString("material.id"));
                    if (material == null) continue block21;
                    targetStr = targetStr.concat("-") + material.keySet().iterator().next();
                    continue block21;
                }
                case "CR_XMH": 
                case "XMH": {
                    Map<String, String> projectnumber = baseDataInfoMap.get("projectnumber@" + costObject.getString("projectnumber"));
                    if (projectnumber == null) continue block21;
                    targetStr = targetStr.concat("-") + projectnumber.keySet().iterator().next();
                    continue block21;
                }
                case "GZH": {
                    Map<String, String> tracknumber = baseDataInfoMap.get("tracknumber@" + costObject.getString("tracknumber"));
                    if (tracknumber == null) continue block21;
                    targetStr = targetStr.concat("-") + tracknumber.keySet().iterator().next();
                    continue block21;
                }
                case "PZH": {
                    Map<String, String> configuredcode = baseDataInfoMap.get("configuredcode@" + costObject.getString("configuredcode"));
                    if (configuredcode == null) continue block21;
                    targetStr = targetStr.concat("-") + configuredcode.keySet().iterator().next();
                    continue block21;
                }
                case "SCBH": {
                    targetStr = targetStr.concat("-") + costObject.getString("producenum");
                    continue block21;
                }
                case "PH": {
                    targetStr = targetStr.concat("-") + costObject.getString("lot");
                    continue block21;
                }
                default: {
                    if (CadEmptyUtils.isEmpty((String)dim)) continue block21;
                    String dimValue = costObject.getString(dim);
                    Map<String, String> baseDataInfo = baseDataInfoMap.get(dim + "@" + dimValue);
                    targetStr = !CadEmptyUtils.isEmpty(baseDataInfo) ? targetStr.concat("-") + baseDataInfo.keySet().iterator().next() : targetStr.concat("-") + costObject.getString(dim);
                }
            }
        }
        return targetStr;
    }

    protected String getCostObjectName(DynamicObject srcBill, DynamicObject costObject, String dimension, String targetStr, Map<String, Map<String, String>> baseDataInfoMap) {
        String[] dimensionStr;
        if (CadEmptyUtils.isEmpty((String)dimension)) {
            return targetStr;
        }
        String[] stringArray = dimensionStr = dimension.split(",");
        int n = stringArray.length;
        block21: for (int i = 0; i < n; ++i) {
            String dim;
            switch (dim = stringArray[i]) {
                case "YDDH": {
                    targetStr = targetStr.concat("-") + (srcBill.get("billno") == null ? "null" : srcBill.getString("billno"));
                    continue block21;
                }
                case "YDHH": {
                    targetStr = targetStr.concat("-") + (srcBill.get("entryseq") == null ? "0" : srcBill.getString("entryseq"));
                    continue block21;
                }
                case "CP": {
                    Map<String, String> material = baseDataInfoMap.get("material@" + costObject.getString("material.id"));
                    if (material == null) continue block21;
                    targetStr = targetStr.concat("-") + material.values().iterator().next();
                    continue block21;
                }
                case "CRN_XMH": 
                case "XMH": {
                    Map<String, String> projectnumber = baseDataInfoMap.get("projectnumber@" + costObject.getString("projectnumber"));
                    if (projectnumber == null) continue block21;
                    targetStr = targetStr.concat("-") + projectnumber.values().iterator().next();
                    continue block21;
                }
                case "GZH": {
                    Map<String, String> tracknumber = baseDataInfoMap.get("tracknumber@" + costObject.getString("tracknumber"));
                    if (tracknumber == null) continue block21;
                    targetStr = targetStr.concat("-") + tracknumber.values().iterator().next();
                    continue block21;
                }
                case "PZH": {
                    Map<String, String> configuredcode = baseDataInfoMap.get("configuredcode@" + costObject.getString("configuredcode"));
                    if (configuredcode == null) continue block21;
                    targetStr = targetStr.concat("-") + configuredcode.values().iterator().next();
                    continue block21;
                }
                case "SCBH": {
                    targetStr = targetStr.concat("-") + costObject.getString("producenum");
                    continue block21;
                }
                case "PH": {
                    targetStr = targetStr.concat("-") + costObject.getString("lot");
                    continue block21;
                }
                default: {
                    if (CadEmptyUtils.isEmpty((String)dim)) continue block21;
                    String dimValue = costObject.getString(dim);
                    Map<String, String> baseDataInfo = baseDataInfoMap.get(dim + "@" + dimValue);
                    targetStr = !CadEmptyUtils.isEmpty(baseDataInfo) ? targetStr.concat("-") + baseDataInfo.keySet().iterator().next() : targetStr.concat("-") + costObject.getString(dim);
                }
            }
        }
        return targetStr;
    }

    protected void updateInfo(DynamicObject productGroup, DynamicObject costObject, Long mainObjId, DynamicObject orgDy) {
        if (productGroup != null) {
            productGroup.set("org", costObject.get("org"));
            productGroup.set("createorg", (Object)orgDy);
            costObject.set("productgroup", productGroup.get("id"));
            if (costObject.get("producttype") == null) {
                costObject.set("producttype", (Object)"C");
            } else if (!"C".equals(costObject.get("producttype")) && !CadEmptyUtils.isEmpty((Long)mainObjId)) {
                costObject.set("mainproobj", (Object)mainObjId);
            }
            String number = productGroup.getString("number");
            if (StringUtils.isEmpty((String)number)) {
                productGroup.set("createtime", costObject.get("createtime"));
            }
            productGroup.set("modifytime", costObject.get("createtime"));
            productGroup.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        }
    }

    protected void save(List<DynamicObject> saveItems) {
        if (saveItems.isEmpty()) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_costobject");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])saveItems.toArray(new DynamicObject[0]));
        this.getCostObjectContext().getResponseInfo().put("type", "success");
        this.getCostObjectContext().setAddNum(this.getCostObjectContext().getAddNum() + saveItems.size());
    }
}

