/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.costobject;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.costobject.BaseImportDataAction;

public class CompletionSaveAction
extends BaseImportDataAction {
    private static final Log logger = LogFactory.getLog(CompletionSaveAction.class);

    @Override
    protected void doExecute() {
        this.getCostObjectContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f52\u96c6\u4fdd\u5b58\u3002", (String)"CompletionSaveAction_18", (String)"macc-cad-mservice", (Object[])new Object[0]));
        String progressId = this.getCostObjectContext().getCostObjectArgs().getProgressId();
        List costObjectBills = this.getCostObjectContext().getCostObjectBills();
        List productGroups = this.getCostObjectContext().getProductGroups();
        List updateCostObjectBills = this.getCostObjectContext().getUpdateCostObjectBills();
        List updateGroupObjBills = this.getCostObjectContext().getUpdateGroupObjBills();
        if (!CadEmptyUtils.isEmpty((List)productGroups)) {
            this.productGroupDistinct(productGroups);
            productGroups.sort(Comparator.comparingLong(o -> o.getLong("id")));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cad_productintogroup", (DynamicObject[])productGroups.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                List successPkIds = result.getSuccessPkIds();
                Map idBillNoMap = result.getBillNos();
                for (Object successPkId : successPkIds) {
                    idBillNoMap.remove(successPkId.toString());
                }
                Set idSet = idBillNoMap.keySet();
                HashSet pks = Sets.newHashSetWithExpectedSize((int)idSet.size());
                for (Object id : idSet) {
                    Long pk = Long.parseLong(id.toString());
                    pks.add(pk);
                }
                Set needDelCostObject = costObjectBills.stream().filter(costObject -> pks.contains(costObject.getLong("productgroup"))).collect(Collectors.toSet());
                costObjectBills.removeAll(needDelCostObject);
                Map configSrcAndTargetBillsMap = this.getCostObjectContext().getConfigSrcAndTargetBillsMap();
                HashMap probillAndSrcMap = new HashMap(16);
                for (Map.Entry dynamicObjectMapEntry : configSrcAndTargetBillsMap.entrySet()) {
                    Map value = (Map)dynamicObjectMapEntry.getValue();
                    Set srcObjects = value.keySet();
                    srcObjects.forEach(src -> probillAndSrcMap.put(src.getLong("entryId"), src.getString("billtype")));
                }
                for (DynamicObject costObject2 : needDelCostObject) {
                    String srcBillNumber = costObject2.getString("srcbillnumber");
                    int srcBillRow = costObject2.getInt("srcbillrow");
                    long probill = costObject2.getLong("probill");
                    String billtype = probillAndSrcMap.get(probill) == null ? "" : (String)probillAndSrcMap.get(probill);
                    this.getCostObjectContext().logErrorMsg(srcBillNumber.concat("@").concat(String.valueOf(srcBillRow)).concat("@").concat(billtype), CompletionSaveAction.generateValidateErrMessage(result));
                }
                this.getCostObjectContext().setAddNum(this.getCostObjectContext().getAddNum() - needDelCostObject.size());
            }
        }
        List billNos = costObjectBills.stream().map(dynamicObject -> dynamicObject.getString("billno")).collect(Collectors.toList());
        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6309\u89c4\u5219\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u7f16\u53f7\uff1a{}", billNos);
        int addObjNum = 0;
        int updateObjNum = 0;
        int proGroupNum = 0;
        String desc = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%1$s\u201d\u4e2a\uff1b\u4fdd\u5b58/\u66f4\u65b0\u6210\u529f\u4ea7\u54c1\u7ec4\u201c%2$s\u201d\u4e2a\uff1b\u66f4\u65b0\u6210\u529f\u201c%3$s\u201d\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CompletionSaveAction_24", (String)"macc-cad-mservice", (Object[])new Object[0]);
        String descEca = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u6210\u672c\u6838\u7b97\u5bf9\u8c61%1$s\u4e2a\uff0c\u66f4\u65b0\u6210\u529f%2$s\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CompletionSaveAction_25", (String)"macc-cad-mservice", (Object[])new Object[0]);
        try (TXHandle txHandle = TX.required();){
            int saveSize = costObjectBills.size();
            int batchSize = 300;
            if (saveSize <= batchSize * 3) {
                this.save(costObjectBills);
            } else {
                int batchCount = saveSize / batchSize + 1;
                for (int i = 0; i < batchCount; ++i) {
                    int startCount = i * batchSize;
                    int endCount = (i + 1) * batchSize;
                    if (i == batchCount - 1) {
                        endCount = saveSize;
                    }
                    List<DynamicObject> batchBillList = costObjectBills.subList(startCount, endCount);
                    this.save(batchBillList);
                }
            }
            addObjNum = saveSize;
            if (!CadEmptyUtils.isEmpty((List)updateCostObjectBills)) {
                Object[] upObjIds = SaveServiceHelper.save((DynamicObject[])updateCostObjectBills.toArray(new DynamicObject[0]));
                updateObjNum = upObjIds.length;
            }
            if (!CadEmptyUtils.isEmpty((List)updateGroupObjBills)) {
                Object[] upObjIds = SaveServiceHelper.save((DynamicObject[])updateGroupObjBills.toArray(new DynamicObject[0]));
                updateObjNum += upObjIds.length;
            }
            if (!CadEmptyUtils.isEmpty((Set)this.getCostObjectContext().getUpdateCenterObjs())) {
                CostObjectHelper.updateCostObject((Set)this.getCostObjectContext().getUpdateCenterObjs());
                updateObjNum += this.getCostObjectContext().getUpdateCenterObjs().size();
            }
        }
        if ("eca".equals(this.getCostObjectContext().getCostObjectArgs().getAppNum())) {
            this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(descEca, addObjNum, updateObjNum));
        } else {
            this.getCostObjectContext().getCollectReport().logCheckDesc(String.format(desc, addObjNum, proGroupNum, updateObjNum));
        }
    }

    private void productGroupDistinct(List<DynamicObject> groups) {
        HashMap<Long, DynamicObject> groupMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject dyn : groups) {
            groupMap.put(dyn.getLong("id"), dyn);
        }
        groups.clear();
        groups.addAll(groupMap.values());
    }

    private static String generateValidateErrMessage(OperationResult res) {
        List validateErrors = res.getValidateResult().getValidateErrors();
        StringBuilder tip = new StringBuilder();
        for (ValidateResult validateRes : validateErrors) {
            List allErrorInfo = validateRes.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                String message = errorInfo.getMessage();
                tip.append(message).append("\r\n");
            }
        }
        if (tip.length() > 0) {
            return tip.substring(0, tip.length() - 2);
        }
        return tip.toString();
    }
}

