/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.matuse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostChangeRecHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.matuse.AbstractMatUseAction;
import kd.macc.cad.mservice.matuse.MatUseContext;
import kd.macc.cad.mservice.matuse.MatUseResultArgs;

public class BaseImportDataAction
extends AbstractMatUseAction {
    private Log logger = LogFactory.getLog(BaseImportDataAction.class);
    private static final String PRODUCTRANGE = "productRange";
    private static final String INVRANGE = "invRange";
    private static final String OMVRANGE = "omRange";
    private static final Long PRO_FALLBACK_SHEMEID = 767253254882251776L;
    private static final Long PRO_OUTSTORAGE_FALLBACK_SHEMEID = 699737860114593792L;
    private static final Long PRO_FALLBACK_OMSHEMEID = 1234608103266191360L;
    private static final HashSet<Long> fallbackShemeList = new /* Unavailable Anonymous Inner Class!! */;

    protected void doExecute() {
    }

    protected String getEntityId(String appNum) {
        return "sca".equals(appNum) ? "sca_matusecollect" : "aca_matusecollect";
    }

    protected Map<String, QFilter> getQFilter(Long orgId, List<Long> costCenterIds, String appNum) {
        String[] ranges;
        DynamicObject sysParam;
        HashMap<String, QFilter> resultMap = new HashMap<String, QFilter>(16);
        HashSet<String> proBillFormNumSet = new HashSet<String>();
        HashSet<String> invBillFormNumSet = new HashSet<String>();
        HashSet<String> oMBillFormNumSet = new HashSet<String>();
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter costCenterFilter = null;
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)appNum);
        if (costCenterIds.size() > 0 && !StringUtils.isEmpty((Object)costCenterIds.get(0))) {
            costCenterFilter = new QFilter("costcenter", "in", costCenterIds);
        }
        if ((sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"matcollectrange", (QFilter[])new QFilter[]{orgFilter, costCenterFilter, appNumFilter})) == null) {
            costCenterFilter = new QFilter("costcenter", "=", (Object)0L);
            sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"matcollectrange", (QFilter[])new QFilter[]{orgFilter, costCenterFilter, appNumFilter});
        }
        if (sysParam == null) {
            return resultMap;
        }
        String matcollectrange = sysParam.getString("matcollectrange");
        String[] stringArray = ranges = matcollectrange.split(",");
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String range;
            switch (range = stringArray[i]) {
                case "PRO_GET": {
                    proBillFormNumSet.add("im_mdc_mftproorder");
                    proBillFormNumSet.add("im_mdc_mftreturnorder");
                    proBillFormNumSet.add("im_mdc_mftfeedorder");
                    continue block10;
                }
                case "GET_OUTSTORAGE": {
                    invBillFormNumSet.add("im_materialreqoutbill");
                    continue block10;
                }
                case "WLL": {
                    oMBillFormNumSet.add("im_mdc_omoutbill");
                    oMBillFormNumSet.add("im_mdc_omreturnbill");
                    oMBillFormNumSet.add("im_mdc_omfeedbill");
                    continue block10;
                }
            }
        }
        if (proBillFormNumSet.size() > 0) {
            QFilter invSchemeFiter_pro = new QFilter("invscheme.billform.number", "in", proBillFormNumSet);
            resultMap.put(PRODUCTRANGE, invSchemeFiter_pro);
        }
        if (invBillFormNumSet.size() > 0) {
            QFilter invShemeFilter_inv = new QFilter("invscheme.billform.number", "in", invBillFormNumSet);
            resultMap.put(INVRANGE, invShemeFilter_inv);
        }
        if (oMBillFormNumSet.size() > 0) {
            QFilter invShemeFilter_pro = new QFilter("invscheme.billform.number", "in", oMBillFormNumSet);
            resultMap.put(OMVRANGE, invShemeFilter_pro);
        }
        return resultMap;
    }

    protected Map<String, List<Long>> getRangeCostCenters(Long orgId, List<Long> costCenterIds, String appNum) {
        ArrayList costCentersCopy = Lists.newArrayList(costCenterIds);
        HashMap billCostCentersMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap ccRangeMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            filters.add(orgQf);
        }
        if (!CadEmptyUtils.isEmpty((List)costCentersCopy)) {
            filters.add(new QFilter("costcenter", "in", (Object)costCentersCopy));
        }
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter,matcollectrange", (QFilter[])filters.toArray(new QFilter[0]));
        filters.clear();
        filters.add(orgQf);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costcenter", "=", (Object)0L));
        DynamicObject orgSysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"costcenter,matcollectrange", (QFilter[])filters.toArray(new QFilter[0]));
        if (sysParams != null && sysParams.size() > 0) {
            for (DynamicObject sysParam : sysParams) {
                String[] matCollectRange = sysParam.getString("matcollectrange");
                long costCenter = sysParam.getLong("costcenter");
                if (kd.bos.login.utils.StringUtils.isNotBlank((String)matCollectRange)) {
                    String[] ranges;
                    ccRangeMap.put(costCenter, matCollectRange);
                    for (String range : ranges = matCollectRange.split(",")) {
                        billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).add(costCenter);
                    }
                    costCentersCopy.remove(costCenter);
                    continue;
                }
                ccRangeMap.put(costCenter, matCollectRange);
                billCostCentersMap.computeIfAbsent(matCollectRange, cc -> new ArrayList()).add(costCenter);
                costCentersCopy.remove(costCenter);
            }
            if (!costCentersCopy.isEmpty() && orgSysParam != null) {
                String matCollectRange = orgSysParam.getString("matcollectrange");
                if (kd.bos.login.utils.StringUtils.isNotBlank((String)matCollectRange)) {
                    String[] ranges = matCollectRange.split(",");
                    for (String range : ranges) {
                        billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).addAll(costCentersCopy);
                    }
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, matCollectRange);
                    }
                } else {
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, matCollectRange);
                    }
                }
            }
        } else if (!costCentersCopy.isEmpty() && orgSysParam != null) {
            String matCollectRange = orgSysParam.getString("matcollectrange");
            if (kd.bos.login.utils.StringUtils.isNotBlank((String)matCollectRange)) {
                String[] ranges = matCollectRange.split(",");
                for (String range : ranges) {
                    billCostCentersMap.computeIfAbsent(range, cc -> new ArrayList()).addAll(costCentersCopy);
                }
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, matCollectRange);
                }
            } else {
                billCostCentersMap.computeIfAbsent(matCollectRange, cc -> new ArrayList()).addAll(costCentersCopy);
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, matCollectRange);
                }
            }
        }
        this.getMatUseContext().getCollectReport().getCcRangeMap().putAll(ccRangeMap);
        return billCostCentersMap;
    }

    protected DynamicObjectCollection getExistCostObjectsByProduct(Long orgId, Set<Long> impCostCenters, Set<Long> productIds, List<Long> manuOrgIds) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        if (orgId != null) {
            qfList.add(new QFilter("org", "=", (Object)orgId));
        }
        if (impCostCenters != null) {
            qfList.add(new QFilter("costcenter", "in", impCostCenters));
        }
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            qfList.add(new QFilter("manuorg", "in", manuOrgIds));
        }
        qfList.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty(productIds)) {
            qfList.add(new QFilter("material", "in", productIds));
        }
        return QueryServiceHelper.query((String)"cad_costobject", (String)"id, org, manuorg, costcenter, material, biztype, producttype, productgroup, probill, srcbillnumber, srcbillrow, bomversion, auxpty", (QFilter[])qfList.toArray(new QFilter[0]));
    }

    protected Map<String, DynamicObject> wrapCostObjectMapByProduct(DynamicObjectCollection existCostObjects) {
        HashMap<String, DynamicObject> costObjectMap = new HashMap<String, DynamicObject>(16);
        existCostObjects.forEach(existCostObject -> {
            StringBuilder sb = new StringBuilder();
            sb.append(existCostObject.get("biztype")).append("@").append(existCostObject.get("org")).append("@").append(existCostObject.get("costcenter")).append("@").append(existCostObject.get("material"));
            costObjectMap.put(sb.toString(), (DynamicObject)existCostObject);
        });
        return costObjectMap;
    }

    protected Map<String, DynamicObject> wrapCostObjectMapByProductGroup(DynamicObjectCollection existCostObjects) {
        HashMap<String, DynamicObject> costObjectMap = new HashMap<String, DynamicObject>(16);
        existCostObjects.forEach(existCostObject -> {
            StringBuilder sb = new StringBuilder();
            sb.append(existCostObject.get("biztype")).append("@").append(existCostObject.get("org")).append("@").append(existCostObject.get("costcenter")).append("@").append(existCostObject.get("productgroup")).append("@").append(existCostObject.get("material"));
            costObjectMap.put(sb.toString(), (DynamicObject)existCostObject);
        });
        return costObjectMap;
    }

    protected Map<String, DynamicObject> wrapCostObjectMapByProductAndPno(DynamicObjectCollection existCostObjects) {
        HashMap<String, DynamicObject> costObjectMap = new HashMap<String, DynamicObject>(16);
        existCostObjects.forEach(existCostObject -> {
            StringBuilder sb = new StringBuilder();
            sb.append(existCostObject.get("biztype")).append("@").append(existCostObject.get("org")).append("@").append(existCostObject.get("costcenter")).append("@").append(existCostObject.get("material")).append("@").append(existCostObject.get("producenum"));
            costObjectMap.put(sb.toString(), (DynamicObject)existCostObject);
        });
        return costObjectMap;
    }

    protected Long srcBizOrgOrWorkCenterToCostCenterId(String entity, DynamicObject srcBill, Map<Long, Long> workCenterMap) {
        Long adminOrgId;
        Date bookDate;
        Long orgId = srcBill.getLong("bizorg");
        QFilter qfDataId = new QFilter("entryentity.sourcedata", "=", (Object)orgId);
        qfDataId.and("entryentity.sourcetype", "=", (Object)"bos_org");
        DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,effectdate,expdate", (QFilter[])new QFilter[]{qfDataId});
        Long costCenterId = null;
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)centerSourceMap)) {
            bookDate = srcBill.getDate("bookdate");
            if (bookDate == null) {
                bookDate = new Date();
            }
            for (DynamicObject costCenterSource : centerSourceMap) {
                if (costCenterSource.getDate("effectdate").getTime() > bookDate.getTime() || costCenterSource.getDate("expdate").getTime() <= bookDate.getTime()) continue;
                DynamicObject costCenterDy = costCenterSource.getDynamicObject("costcenter");
                if (costCenterDy == null) break;
                costCenterId = costCenterDy.getLong("id");
                break;
            }
        }
        if (("im_mdc_mftproorder".equals(entity) || "im_mdc_omoutbill".equals(entity)) && CadEmptyUtils.isEmpty(costCenterId)) {
            costCenterId = workCenterMap.get(this.getCostCenterBySource(srcBill));
        }
        bookDate = srcBill.getDate("bookdate");
        if (CadEmptyUtils.isEmpty(costCenterId) && !CadEmptyUtils.isEmpty((Long)(adminOrgId = Long.valueOf(srcBill.getLong("bizdept"))))) {
            costCenterId = this.getCostCenterByAdminOrgId(adminOrgId, bookDate);
        }
        return costCenterId;
    }

    private Long getCostCenterByAdminOrgId(Long adminOrgId, Date bizDate) {
        QFilter sourTypeAndDataIdQf = new QFilter("entryentity.sourcetype", "=", (Object)"bos_adminorg");
        sourTypeAndDataIdQf = sourTypeAndDataIdQf.and(new QFilter("entryentity.sourcedata", "=", (Object)adminOrgId));
        DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,effectdate,expdate", (QFilter[])new QFilter[]{sourTypeAndDataIdQf});
        ArrayList costCenterSourceList = new ArrayList(8);
        centerSourceMap.forEach(s -> costCenterSourceList.add(s));
        DynamicObject costCenterBySrcBillDate = CostObjectHelper.getCostCenterBySrcBillDate((Date)bizDate, costCenterSourceList);
        Long costCenterId = 0L;
        if (costCenterBySrcBillDate != null) {
            costCenterId = costCenterBySrcBillDate.getLong("costcenter");
        }
        return costCenterId;
    }

    private Long getCostCenterBySource(DynamicObject sourceBill) {
        return sourceBill.getLong("billentry.oprworkcenter");
    }

    private Long getCostCenterByBizUnit(Long bizOrgId, Map<Long, List<Long>> costCenterBizUnitMap) {
        for (Map.Entry<Long, List<Long>> entry : costCenterBizUnitMap.entrySet()) {
            List<Long> bizunits = entry.getValue();
            if (!bizunits.contains(bizOrgId)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void delMatUseAndAllocBillByCostCenter(String entity, Set<Long> impCostCenters, List<Long> mftOrderEntryIds, Map<String, Object> collectParamMap) {
        Long acctOrgId = this.getMatUseContext().getMatUseArgs().getAcctOrgId();
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        QFilter commonQf = new QFilter("org", "=", (Object)acctOrgId);
        commonQf.and(new QFilter("costcenter", "in", impCostCenters));
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            commonQf.and(new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds));
        }
        commonQf.and(new QFilter("sourcebillid", ">", (Object)0L));
        commonQf.and(SysParamHelper.getImportTimeScope((Long)acctOrgId, (String)"bizdate", (String)appNum));
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null) {
            QFilter collectTimeQFilter = new QFilter("bizdate", ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter("bizdate", "<=", collectParamMap.get("endDate")));
            commonQf.and(collectTimeQFilter);
        }
        DynamicObjectCollection coverMatUseBills = QueryServiceHelper.query((String)this.getEntity(appNum), (String)"id, sourcebillid, entryentity.id AS entryId", (QFilter[])new QFilter[]{commonQf});
        Set srcBillIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)coverMatUseBills, (String)"sourcebillid");
        this.delMatUseAndAllocBill(entity, srcBillIds);
    }

    protected void delMatUseAndAllocBill(String entity, Set<Long> srcBillIds) {
        Set matUseEntryIdSet;
        String appNum = this.getMatUseContext().getMatUseArgs().getAppNum();
        QFilter sourceBillQF = new QFilter("id", "in", srcBillIds);
        QFilter billStatusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter[] qf = new QFilter[]{sourceBillQF, billStatusQF};
        DynamicObjectCollection invSourceBills = QueryServiceHelper.query((String)"im_mdc_mftproorder", (String)"id", (QFilter[])qf);
        DynamicObjectCollection proSourceBills = QueryServiceHelper.query((String)"im_materialreqoutbill", (String)"id", (QFilter[])qf);
        DynamicObjectCollection omSourceBills = QueryServiceHelper.query((String)"im_mdc_omoutbill", (String)"id", (QFilter[])qf);
        Set existSrcBillIds_1 = DynamicObjectHelper.getIdSet((DynamicObjectCollection)invSourceBills, (String)"id");
        Set existSrcBillIds_2 = DynamicObjectHelper.getIdSet((DynamicObjectCollection)proSourceBills, (String)"id");
        Set existSrcBillIds_3 = DynamicObjectHelper.getIdSet((DynamicObjectCollection)omSourceBills, (String)"id");
        srcBillIds.removeAll(existSrcBillIds_1);
        srcBillIds.removeAll(existSrcBillIds_2);
        srcBillIds.removeAll(existSrcBillIds_3);
        if (srcBillIds.isEmpty()) {
            this.getMatUseContext().addDelNum(0);
            return;
        }
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter srcBillQf = new QFilter("sourcebillid", "in", srcBillIds);
        String fields = "id, billno, org, costcenter, bizdate, sourcebillid, entryentity.seq AS seq, entryentity.costobject AS costobject, entryentity.id AS entryId";
        DynamicObjectCollection matUseBills = QueryServiceHelper.query((String)this.getEntity(appNum), (String)fields, (QFilter[])new QFilter[]{srcBillQf, appnumFilter});
        int delNum = 0;
        if (!CadEmptyUtils.isEmpty(srcBillIds)) {
            delNum = DeleteServiceHelper.delete((String)this.getEntity(appNum), (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", srcBillIds)});
            this.getMatUseContext().addDelNum(delNum);
            this.delChangeRecord(srcBillIds);
        }
        if (!(matUseEntryIdSet = DynamicObjectHelper.getIdSet((DynamicObjectCollection)matUseBills, (String)"entryId")).isEmpty()) {
            QFilter subQFilter = new QFilter("matcollect", "in", (Object)matUseEntryIdSet);
            subQFilter.and(new QFilter("appnum", "=", (Object)appNum));
            if ("sca".equals(appNum)) {
                DynamicObjectCollection allocBills;
                if (!"im_materialreqoutbill".equals(entity) && (allocBills = QueryServiceHelper.query((String)"sca_matalloc", (String)"id", (QFilter[])new QFilter[]{subQFilter})) != null && allocBills.size() > 0) {
                    Set allocBillIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)allocBills, (String)"id");
                    CostChangeRecHelper.writeCostChangeRecForAllocDel((Set)allocBillIds);
                }
                DeleteServiceHelper.delete((String)"sca_matalloc", (QFilter[])new QFilter[]{subQFilter});
            } else {
                DeleteServiceHelper.delete((String)"aca_matalloc", (QFilter[])new QFilter[]{subQFilter});
            }
        }
        if ("sca".equals(appNum) && !"im_materialreqoutbill".equals(entity)) {
            this.writeCostChangeRecForDel(matUseBills);
        }
    }

    protected void delChangeRecord(Set<Long> srcBillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcBillIds);
        filter.and("bizstatus", "!=", (Object)"B");
        DeleteServiceHelper.delete((String)"sca_costchangerecord", (QFilter[])new QFilter[]{filter});
    }

    protected void writeCostChangeRecForDel(DynamicObjectCollection matUseBills) {
        DynamicObjectCollection costObjectAccounts = this.getCostObjectAccount(matUseBills, "costobject");
        HashMap costObjectAccountMap = new HashMap();
        costObjectAccounts.forEach(e -> costObjectAccountMap.computeIfAbsent(e.getLong("costobject"), s -> new HashSet()).add(e.getLong("costaccount")));
        ArrayList<Long> srcbillIds = new ArrayList<Long>(10);
        matUseBills.forEach(p -> srcbillIds.add(p.getLong("sourcebillid")));
        List<Long> settlChangeRecords = this.getChangeRecordBySettled(srcbillIds);
        ArrayList<DynamicObject> costUpdateResList = new ArrayList<DynamicObject>(10);
        for (DynamicObject matUseBill : matUseBills) {
            Set costAccounts;
            Long costobjectId = matUseBill.getLong("costobject");
            if (CadEmptyUtils.isEmpty((Long)costobjectId) || (costAccounts = (Set)costObjectAccountMap.get(costobjectId)) == null || !settlChangeRecords.contains(matUseBill.getLong("sourcebillid"))) continue;
            for (Long costAccountId : costAccounts) {
                DynamicObject costChangeObject = this.getCostChangeObject(matUseBill);
                costChangeObject.set("costobject", (Object)costobjectId);
                costChangeObject.set("costaccount", (Object)costAccountId);
                costUpdateResList.add(costChangeObject);
            }
        }
        if (!costUpdateResList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])costUpdateResList.toArray(new DynamicObject[0]));
        }
    }

    protected List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        sourceBills.forEach(p -> srcbillIds.add(p.getLong("sourcebill")));
        return srcbillIds;
    }

    protected DynamicObject getCostChangeObject(DynamicObject bill) {
        DynamicObject costChange = BusinessDataServiceHelper.newDynamicObject((String)"sca_costchangerecord");
        costChange.set("org", bill.get("org"));
        costChange.set("costcenter", bill.get("costcenter"));
        costChange.set("businessbill", (Object)"sca_matusecollect");
        costChange.set("sourcebill", (Object)bill.getLong("sourcebillid"));
        costChange.set("creator", (Object)RequestContext.get().getCurrUserId());
        costChange.set("createtime", (Object)TimeServiceHelper.now());
        costChange.set("sourcebiztime", (Object)bill.getDate("bookdate"));
        return costChange;
    }

    protected DynamicObjectCollection getCostObjectAccount(DynamicObjectCollection existCostObjects, String field) {
        Set costObjectIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)existCostObjects, (String)field);
        return this.getCostObjectAccount(costObjectIds);
    }

    protected DynamicObjectCollection getCostObjectAccount(Set<Long> costObjectIds) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("costobject", "in", costObjectIds));
        qfList.add(new QFilter("bizstatus", "=", (Object)"B"));
        DynamicObjectCollection costObjectAccounts = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"costobject, costaccount", (QFilter[])qfList.toArray(new QFilter[0]));
        return costObjectAccounts;
    }

    @Deprecated
    protected DynamicObject[] getCurrMatUseBills(Set<Long> aduitedSrcBillIds, String appId, Set<String> aduitedSrcBillnos) {
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appId);
        HashSet repeatIds = new HashSet(1024);
        List listIds = Lists.partition(new ArrayList<Long>(aduitedSrcBillIds), (int)(HugeInConfig.inMaxSize() - 1));
        for (List list : listIds) {
            QFilter srcBillQf = new QFilter("sourcebillid", "in", (Object)list);
            DynamicObjectCollection repeatIdCollec = QueryServiceHelper.query((String)this.getEntity(appId), (String)"id", (QFilter[])new QFilter[]{srcBillQf, appnumFilter});
            repeatIds.addAll(DynamicObjectHelper.getIdSet((DynamicObjectCollection)repeatIdCollec, (String)"id"));
        }
        if ("sca".equals(appId)) {
            List listbillNos = Lists.partition(new ArrayList<String>(aduitedSrcBillnos), (int)(HugeInConfig.inMaxSize() - 1));
            for (List list : listbillNos) {
                QFilter srcBillnoQf = new QFilter("billno", "in", (Object)list);
                DynamicObjectCollection repeatIdCollec = QueryServiceHelper.query((String)this.getEntity(appId), (String)"id", (QFilter[])new QFilter[]{srcBillnoQf, appnumFilter});
                repeatIds.addAll(DynamicObjectHelper.getIdSet((DynamicObjectCollection)repeatIdCollec, (String)"id"));
            }
        }
        DynamicObject[] matUseCollects = BusinessDataServiceHelper.load((Object[])repeatIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntity(appId)));
        return matUseCollects;
    }

    protected String getEntity(String appNum) {
        if ("sca".equals(appNum)) {
            return "sca_matusecollect";
        }
        if ("aca".equals(appNum)) {
            return "aca_matusecollect";
        }
        return "sca_matusecollect";
    }

    protected List<DynamicObject> getMatUseBillBySrcBill(Long orgId, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, String type, String appNum, String calMethod) {
        ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
        HashMap<String, DynamicObject> changeMatUseMap = new HashMap<String, DynamicObject>(16);
        ArrayList<DynamicObject> matUseBills = new ArrayList<DynamicObject>(10);
        ArrayList<String> existBillNos = new ArrayList<String>(10);
        Set<String> existsMatUse = this.dealExistMatUseBills(orgId, costCenters, srcAndTargetBillsMap, new HashSet<String>(configMappingMap.keySet()), changeMatUseMap, existBillNos, appNum);
        this.logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u6750\u6599\u8017\u7528\u5206\u914d\u5355:{}", existsMatUse);
        int updNum = 0;
        int addNum = 0;
        MatUseContext context = this.getMatUseContext();
        for (DynamicObject srcBill : srcBills) {
            DynamicObject targetBill = srcAndTargetBillsMap.get(srcBill);
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\uff0c\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_63", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            String idAndEntryId = srcBill.getString("id") + "-" + srcBill.getString("entryId");
            boolean isNeedChangeData = changeMatUseMap.containsKey(idAndEntryId);
            if (existsMatUse.contains(idAndEntryId) && !isNeedChangeData) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%1$s\u201d\u884c\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_64", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno"), srcBill.getString("entryseq")));
                this.logger.info("\u6e90\u5355{}\u884c\u53f7{}\u5df2\u5b58\u5728\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\u3002", (Object)srcBill.getString("billno"), (Object)srcBill.getString("entryseq"));
                continue;
            }
            String srcStr = this.getCostObjectHashCodeBySrcBill(srcBill, collConfigRuleMappingMap);
            this.logger.info("\u5339\u914d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5->{}\uff0c\u6210\u672c\u4e2d\u5fc3->{}", (Object)calMethod, (Object)costCenterId);
            Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(orgId).concat(String.valueOf(costCenterId)).concat(calMethod));
            if (CadEmptyUtils.isEmpty(matInfoList)) {
                matInfoList = existCostObjectMap.get(String.valueOf(orgId));
            }
            this.logger.info("matInfoList\u5927\u5c0f\uff1a{}", matInfoList == null ? "null" : Integer.valueOf(matInfoList.size()));
            if (matInfoList != null) {
                DynamicObject costObject = matInfoList.get(srcStr);
                this.setCostObject(targetBill, orgId, costCenterId, costObject);
            }
            if (!isNeedChangeData) {
                ++addNum;
                targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("createtime", (Object)TimeServiceHelper.now());
                targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
                targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            } else {
                DynamicObject matUseBill = (DynamicObject)changeMatUseMap.get(idAndEntryId);
                for (Map.Entry<String, String> configMapping : configMappingMap.entrySet()) {
                    String cost = configMapping.getKey();
                    matUseBill.set(cost, targetBill.get(cost));
                }
                targetBill = matUseBill;
                ++updNum;
            }
            targetBill.set("billstatus", (Object)"A");
            matUseBills.add(targetBill);
        }
        this.getMatUseContext().setAddNum(this.getMatUseContext().getAddNum() + addNum);
        this.getMatUseContext().setUpdateNum(this.getMatUseContext().getUpdateNum() + updNum);
        this.logger.info("\u65b0\u589e\u7684\u6750\u6599\u8017\u7528\u5206\u914d\u5355:{}", (Object)matUseBills.size());
        return matUseBills;
    }

    private DynamicObjectCollection getDimensions() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", (Object)new String[]{"CBHSWD005", "CBHSWD006"}), new QFilter("preset", "=", (Object)Boolean.TRUE)};
        return QueryServiceHelper.query((String)"cad_costcalcdimension", (String)"number,level", (QFilter[])filters);
    }

    public Map<Long, Map<Long, List<DynamicObject>>> getCalCostRecord(Long costAccountId, List<Long> sourceBillIds) {
        DynamicObjectCollection costRecords = this.getCalCostRecordData(costAccountId, sourceBillIds);
        HashMap<Long, Map<Long, List<DynamicObject>>> resultMap = new HashMap<Long, Map<Long, List<DynamicObject>>>();
        costRecords.forEach(e -> {
            Long bizbillid = e.getLong("id");
            long bizbillentryid = e.getLong("entryid");
            HashMap<Long, List> calCostRecEntryMap = (HashMap<Long, List>)resultMap.get(bizbillid);
            if (calCostRecEntryMap == null) {
                calCostRecEntryMap = new HashMap<Long, List>();
                resultMap.put(bizbillid, calCostRecEntryMap);
            }
            calCostRecEntryMap.computeIfAbsent(bizbillentryid, s -> new ArrayList()).add(e);
        });
        return resultMap;
    }

    private DynamicObjectCollection getCalCostRecordData(Long costAccountId, List<Long> sourceBillIds) {
        String fields = "id,entry.id entryid,entry.actualcost actualcost,entry.material material,entry.subentrycostelement.sub_actualcost subactualcost,entry.subentrycostelement.sub_unitactualcost subunitactualcost,entry.subentrycostelement.costelement costelement,entry.subentrycostelement.costsubelement costsubelement";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", sourceBillIds), new QFilter("costaccount", "=", (Object)costAccountId)};
        return QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])filters);
    }

    private boolean isGenMatBill(List<DynamicObject> existsBills, DynamicObjectCollection dimensions, String idAndEntryId) {
        if (existsBills.isEmpty()) {
            return Boolean.FALSE;
        }
        if (dimensions.isEmpty()) {
            return Boolean.TRUE;
        }
        HashMap<String, Integer> levels = new HashMap<String, Integer>(2);
        for (DynamicObject dimension : dimensions) {
            levels.put(dimension.getString("number"), dimension.getInt("level"));
        }
        Integer sw = (Integer)levels.get("CBHSWD005");
        Integer sp = (Integer)levels.get("CBHSWD006");
        if (sw == null || sp == null) {
            return Boolean.FALSE;
        }
        if (sp >= sw) {
            return Boolean.TRUE;
        }
        for (DynamicObject existsBill : existsBills) {
            if (!idAndEntryId.equals(existsBill.getString("matcollect") + "-" + existsBill.getString("matusesrcbillentryid"))) continue;
            this.getMatUseContext().getMatUseBills().remove((Object)existsBill);
            this.getMatUseContext().setAddNum(this.getMatUseContext().getAddNum() - 1);
            break;
        }
        return Boolean.FALSE;
    }

    private void setCostObject(DynamicObject targetBill, Long orgId, Long costCenterId, DynamicObject costObject) {
        if (costObject == null) {
            targetBill.set("costobject", (Object)0L);
            this.logger.info("costObject == null");
        } else {
            boolean isExistMulCostObjects = false;
            long mainProductId = costObject.getLong("material");
            DynamicObject product = BusinessDataServiceHelper.loadSingleFromCache((Object)mainProductId, (String)"bd_material");
            if (product != null && (BomRouterHelper.isEnableMatversion((DynamicObject)product) || BomRouterHelper.isEnableAuxprop((DynamicObject)product))) {
                QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                qFilter.and("costcenter", "=", (Object)costCenterId);
                qFilter.and("billstatus", "=", (Object)"C");
                qFilter.and("material", "=", (Object)mainProductId);
                qFilter.and("producttype", "=", (Object)"C");
                List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"cad_costobject", (QFilter[])qFilter.toArray(), null, (int)-1);
                if (!CadEmptyUtils.isEmpty((List)primaryKeys) && primaryKeys.size() > 1) {
                    this.logger.info("\u6838\u7b97\u7ec4\u7ec7:{},\u6210\u672c\u4e2d\u5fc3:{},\u4ea7\u54c1:{},\u627e\u5230\u591a\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61", new Object[]{orgId, costCenterId, mainProductId});
                    isExistMulCostObjects = true;
                }
            }
            if (isExistMulCostObjects) {
                targetBill.set("costobject", (Object)0L);
                this.logger.info("costObject \u8bbe\u7f6e\u4e3a0");
            } else {
                targetBill.set("costobject", (Object)costObject.getLong("id"));
                this.logger.info("costObject \u8bbe\u7f6e\u4e3a{}", (Object)costObject.getLong("id"));
            }
        }
    }

    private Set<String> dealExistMatUseBills(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Set<String> selectFields, Map<String, DynamicObject> changeMatUseMap, List<String> existBillNos, String appNum) {
        Map costAccountPeriodMap;
        HashSet<String> needReturnInfo = new HashSet<String>(16);
        HashSet<Long> srcIds = new HashSet<Long>(16);
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        HashSet<String> srcBillno = new HashSet<String>(16);
        HashMap<String, String> newManuInfo = new HashMap<String, String>(16);
        ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>(srcAndTargetBillsMap.keySet());
        HashSet<String> costAccountIds = new HashSet<String>(srcBills.size());
        for (DynamicObject srcBill : srcBills) {
            DynamicObject targetBill = srcAndTargetBillsMap.get(srcBill);
            srcIds.add(srcBill.getLong("id"));
            costAccountIds.add(srcBill.getString("costaccount"));
            srcEntryIds.add(srcBill.getLong("entryId"));
            newManuInfo.put(srcBill.getString("id") + "-" + srcBill.getString("entryId"), CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)targetBill, selectFields));
            srcBillno.add(srcBill.getString("billno") + "-" + srcBill.getString("entryseq"));
        }
        QFilter qfSourceBill = new QFilter("matcollect", "in", srcIds);
        qfSourceBill.and("matusesrcbillentryid", "in", srcEntryIds);
        QFilter qfBillNo = new QFilter("billno", "in", srcBillno);
        qfSourceBill = qfSourceBill.or(qfBillNo);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrgAndCostCenter = new QFilter("org", "=", (Object)acctOrg);
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            qfOrgAndCostCenter = qfOrgAndCostCenter.and(new QFilter("costcenter", "in", costCenters));
        }
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(costAccountIds) && !CadEmptyUtils.isEmpty((Map)(costAccountPeriodMap = this.getMatUseContext().getMatUseArgs().getCostAccountPeriodMap()))) {
            for (Map.Entry costAccountPeriod : costAccountPeriodMap.entrySet()) {
                if (!costAccountIds.contains(String.valueOf(costAccountPeriod.getKey()))) continue;
                QFilter tempFilter = new QFilter("costaccount", "=", costAccountPeriod.getKey());
                tempFilter.and("period", "=", costAccountPeriod.getValue());
                if (filter == null) {
                    filter = tempFilter;
                    continue;
                }
                filter.or(tempFilter);
            }
        }
        if (filter != null) {
            qfOrgAndCostCenter.and(filter);
        }
        QFilter qfbizTime = SysParamHelper.getImportTimeScope((Long)acctOrg, (String)"bizdate", (String)appNum);
        qfbizTime = qfbizTime.or(qfSourceBill);
        HashSet<String> costSelectFields = new HashSet<String>(selectFields);
        costSelectFields.add("id");
        costSelectFields.add("billno");
        costSelectFields.add("matcollect");
        costSelectFields.add("matusesrcbillentryid");
        costSelectFields.add("useamount");
        DynamicObjectCollection matUseBills = QueryServiceHelper.query((String)"aca_matalloc", (String)String.join((CharSequence)",", costSelectFields), (QFilter[])new QFilter[]{qfbizTime, qfOrgAndCostCenter, qfAppNum});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matUseBills)) {
            return needReturnInfo;
        }
        Map<Long, DynamicObject> matUseMap = this.getMatUseMap(matUseBills, selectFields);
        for (DynamicObject matUseBill : matUseBills) {
            existBillNos.add(matUseBill.getString("billno"));
            matUseMap.put(matUseBill.getLong("id"), matUseBill);
            needReturnInfo.add(matUseBill.getString("matcollect") + "-" + matUseBill.getString("matusesrcbillentryid"));
        }
        this.logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u5904\u7406\u6e90\u5355-\u5df2\u5b58\u5728\u7684\u6750\u6599\u8017\u7528\u5206\u914d\u5355\uff1a{}", existBillNos);
        ArrayList<Long> sourceBillIds = new ArrayList<Long>(srcIds.size());
        sourceBillIds.addAll(srcIds);
        HashSet<Long> needDeleteIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteSrcIds = new HashSet<Long>(16);
        Map<Long, Map<Long, List<DynamicObject>>> costRecords = this.getCalCostRecord(this.getMatUseContext().getMatUseArgs().getCostAccountId(), sourceBillIds);
        for (DynamicObject matUse : matUseBills) {
            Long sourceBillEntryId;
            List<DynamicObject> calCostRecList;
            String key = matUse.getString("matcollect") + "-" + matUse.getString("matusesrcbillentryid");
            String newVal = (String)newManuInfo.get(key);
            if (CadEmptyUtils.isEmpty((String)newVal)) {
                if (CadEmptyUtils.isEmpty((Long)matUse.getLong("matcollect"))) continue;
                needDeleteIds.add(matUse.getLong("id"));
                needDeleteSrcIds.add(matUse.getLong("matcollect"));
                needReturnInfo.remove(key);
                continue;
            }
            needReturnInfo.add(key);
            String oldVal = CommonCollConfigService.getBillInfoBySelectFields((DynamicObject)matUse, selectFields);
            if (!newVal.equals(oldVal)) {
                changeMatUseMap.put(key, matUseMap.get(matUse.getLong("id")));
                continue;
            }
            Long sourceBillId = matUse.getLong("matcollect");
            Map<Long, List<DynamicObject>> entryIdActualCostMap = costRecords.get(sourceBillId);
            if (CadEmptyUtils.isEmpty(entryIdActualCostMap) || CadEmptyUtils.isEmpty(calCostRecList = entryIdActualCostMap.get(sourceBillEntryId = Long.valueOf(matUse.getLong("matusesrcbillentryid"))))) continue;
            BigDecimal actualCost = calCostRecList.get(0).getBigDecimal("actualcost");
            BigDecimal useAmount = matUse.getBigDecimal("useamount");
            if (actualCost == null || useAmount == null || actualCost.compareTo(useAmount) == 0) continue;
            needDeleteIds.add(matUse.getLong("id"));
            needDeleteSrcIds.add(matUse.getLong("matcollect"));
            needReturnInfo.remove(key);
        }
        this.logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u5904\u7406\u6e90\u5355-\u9700\u8981\u5220\u9664\u7684\u6750\u6599\u8017\u7528\u5206\u914d\u5355:{}", needDeleteIds);
        if (!needDeleteIds.isEmpty() && !needDeleteSrcIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"aca_matalloc"), (Object[])needDeleteIds.toArray(new Long[0]));
            QFilter[] filters = new QFilter[]{new QFilter("billtype", "=", (Object)"aca_matalloc"), new QFilter("srcbillid", "in", needDeleteIds), new QFilter("vouchernum", "=", (Object)" ")};
            DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])filters);
            this.getMatUseContext().addDelNum(needDeleteIds.size());
        }
        return needReturnInfo;
    }

    private Map<Long, DynamicObject> getMatUseMap(DynamicObjectCollection matUseBills, Set<String> srcFields) {
        DynamicObject[] matAllocs;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(16);
        HashSet ids = new HashSet(16);
        matUseBills.forEach(p -> ids.add(p.getLong("id")));
        HashSet<String> selectFieldSet = new HashSet<String>(10);
        if (srcFields != null) {
            selectFieldSet.addAll(srcFields);
        }
        HashSet fields = Sets.newHashSet((Object[])new String[]{"id", "sourcebillentryid", "billstatus", "nsrcauditdate"});
        selectFieldSet.addAll(fields);
        String selectFields = String.join((CharSequence)",", selectFieldSet);
        for (DynamicObject matAlloc : matAllocs = BusinessDataServiceHelper.load((String)"aca_matalloc", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            resultMap.put(matAlloc.getLong("id"), matAlloc);
        }
        return resultMap;
    }

    protected void setSourceAndBiztype(DynamicObject matusecollect, DynamicObject sourceBill) {
        String srcBillEntityNum = sourceBill.getString("invscheme.billform.number");
        Long invschemeId = sourceBill.getLong("invscheme.id");
        if (fallbackShemeList.contains(invschemeId)) {
            matusecollect.set("biztype", (Object)"PRODUCTMATFALLBACK");
        } else {
            matusecollect.set("biztype", (Object)"PRODUCTMATGET");
        }
        matusecollect.set("srcbiztype", (Object)sourceBill.getLong("biztype"));
        switch (srcBillEntityNum) {
            case "im_mdc_mftproorder": {
                matusecollect.set("source", (Object)"SYSIMPORT_PROGET");
                break;
            }
            case "im_mdc_mftreturnorder": {
                matusecollect.set("source", (Object)"SYSIMPORT_PROBACK");
                break;
            }
            case "im_mdc_mftfeedorder": {
                matusecollect.set("source", (Object)"SYSIMPORT_PROADD");
                break;
            }
            case "im_materialreqoutbill": {
                matusecollect.set("source", (Object)"SYSIMPORT_OUT");
                break;
            }
            case "im_mdc_omoutbill": {
                matusecollect.set("source", (Object)"SYSIMPORT_IMMDCOMOUT");
                break;
            }
            case "im_mdc_omreturnbill": {
                matusecollect.set("source", (Object)"SYSIMPORT_IMMDCOMRETURN");
                break;
            }
            case "im_mdc_omfeedbill": {
                matusecollect.set("source", (Object)"SYSIMPORT_IMMDCOMFEED");
                break;
            }
        }
    }

    protected String getOrgName(Long orgId) {
        return QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)}).getString("name");
    }

    protected Map<Long, DynamicObject> getProBillEntryIdCostObjectMap(Long acctOrg, List<Long> costCenters, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, String> collConfigRuleMappingMap, String sourceBillEntity, String appNum, String calmethod) {
        HashMap proBillEntryIdCostObjectMap = Maps.newHashMap();
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return proBillEntryIdCostObjectMap;
        }
        HashSet<Long> proBillEntryIds = new HashSet<Long>(16);
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            String coField;
            DynamicObject srcBill = srcAndTargetBill.getKey();
            if (!"im_mdc_mftproorder".equals(sourceBillEntity) && !"im_mdc_mftreturnorder".equals(sourceBillEntity) && !"im_mdc_mftfeedorder".equals(sourceBillEntity) && !"im_mdc_omoutbill".equals(sourceBillEntity) && !"im_mdc_omreturnbill".equals(sourceBillEntity) && !"im_mdc_omfeedbill".equals(sourceBillEntity) || (coField = collConfigRuleMappingMap.get("material")) == null || !coField.contains("manuentryid")) continue;
            proBillEntryIds.add(srcBill.getLong(coField));
        }
        if (!CadEmptyUtils.isEmpty(proBillEntryIds)) {
            Map existCostObjectMaterialMap = CostObjectHelper.getExistCostObjectMapForMaterial((Long)acctOrg, costCenters, (String)appNum);
            QFilter filter = new QFilter("treeentryentity.id", "in", proBillEntryIds);
            String selectFields = "id,treeentryentity.id entryid,treeentryentity.material.masterid as material,treeentryentity.bomid.version as bomversion,treeentryentity.auxproperty as auxpty,treeentryentity.material.masterid.isenablematerialversion as isenablematerialversion,treeentryentity.material.masterid.isuseauxpty as isuseauxpty";
            DynamicObjectCollection manuBills = "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) ? QueryServiceHelper.query((String)"pom_mftorder", (String)selectFields, (QFilter[])filter.toArray()) : QueryServiceHelper.query((String)"om_mftorder", (String)selectFields, (QFilter[])filter.toArray());
            HashMap<Long, String> proBillEntryIdKeyMap = new HashMap<Long, String>(manuBills.size());
            HashSet<Long> materialIds = new HashSet<Long>(10);
            for (DynamicObject manuBill : manuBills) {
                if (!manuBill.getBoolean("isuseauxpty")) continue;
                materialIds.add(manuBill.getLong("material"));
            }
            Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)acctOrg);
            for (DynamicObject manuBill : manuBills) {
                String key = manuBill.getString("material");
                key = manuBill.getBoolean("isenablematerialversion") ? key.concat("@").concat(manuBill.getString("bomversion")) : key.concat("@").concat("0");
                if (manuBill.getBoolean("isuseauxpty")) {
                    Long material = manuBill.getLong("material");
                    Long auxpty = manuBill.getLong("auxpty");
                    Long effectCostAuxpty = this.getEffectCostAuxpty(material, auxpty, materialMap, calmethod);
                    key = key.concat("@").concat(String.valueOf(effectCostAuxpty));
                } else {
                    key = key.concat("@").concat("0");
                }
                proBillEntryIdKeyMap.put(manuBill.getLong("entryid"), key);
            }
            for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetEntry : srcAndTargetBillsMap.entrySet()) {
                DynamicObject costObject;
                Long entryId;
                String key;
                DynamicObject srcBill = srcAndTargetEntry.getKey();
                DynamicObject target = srcAndTargetEntry.getValue();
                String coField = collConfigRuleMappingMap.get("material");
                if (coField == null || !coField.contains("manuentryid") || CadEmptyUtils.isEmpty((String)(key = (String)proBillEntryIdKeyMap.get(entryId = Long.valueOf(srcBill.getLong(coField)))))) continue;
                String costCenterId = target.getString("costcenter.id");
                if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
                    key = costCenterId.concat("@").concat(key);
                }
                if ((costObject = (DynamicObject)existCostObjectMaterialMap.get(key)) == null) continue;
                proBillEntryIdCostObjectMap.put(srcBill.getLong("entryid"), costObject);
            }
        }
        return proBillEntryIdCostObjectMap;
    }

    /*
     * WARNING - void declaration
     */
    public List<DynamicObject> getMaterialUseBill(Long acctOrg, List<Long> costCenters, DynamicObject config, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Map<String, DynamicObject>> existCostObjectMap, TreeMap<String, String> collConfigRuleMappingMap, Map<String, String> configMappingMap, Map<String, DynamicObject> idEntryIdCompleteMap, Set<String> existBillNos, String sourceBillEntity, String appNum) {
        ArrayList<DynamicObject> materialBills = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return materialBills;
        }
        Map<Long, DynamicObject> entryIdCostObjectMap = this.getProBillEntryIdCostObjectMap(acctOrg, costCenters, srcAndTargetBillsMap, collConfigRuleMappingMap, sourceBillEntity, appNum, config.getString("calmethod"));
        HashMap<String, DynamicObject> changeMaterialMap = new HashMap<String, DynamicObject>(16);
        this.dealExitsData(idEntryIdCompleteMap, srcAndTargetBillsMap, changeMaterialMap, new HashSet<String>(configMappingMap.keySet()), appNum);
        Map<Long, DynamicObject> srcBillEntryIdAndSrcDataMap = this.getSrcBillEntryIdAndSrcDataMap(srcAndTargetBillsMap, sourceBillEntity, new HashSet<String>(collConfigRuleMappingMap.values()), new HashSet<String>(configMappingMap.values()));
        this.logger.info("\u5df2\u7ecf\u5b58\u5728\u7684\u6750\u6599\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", existBillNos);
        int updNum = 0;
        int addNum = 0;
        MatUseContext context = this.getMatUseContext();
        List planOutPutList = this.getMatUseContext().getNewBillList();
        Set willSaveBillNoSet = planOutPutList.stream().map(o -> o.getString("billno")).collect(Collectors.toSet());
        Set<String> existsIds = idEntryIdCompleteMap.keySet();
        HashMap<String, DynamicObject> existMaterialBills = new HashMap<String, DynamicObject>(idEntryIdCompleteMap);
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrg);
        Set sourceEntryIds = context.getSourceEntryIds();
        boolean checkStProductCbCheck = false;
        if ("1".equals(CadBgParamUtils.getCadBgParamForString((String)"stProductCbCheck", (String)"1"))) {
            checkStProductCbCheck = true;
        }
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBill : srcAndTargetBillsMap.entrySet()) {
            Object manuorgList;
            DynamicObjectCollection entryentity;
            DynamicObject srcBill = srcAndTargetBill.getKey();
            DynamicObject targetBill = srcAndTargetBill.getValue();
            if (!sourceBillEntity.equals(srcBill.getString("billtype"))) continue;
            if (targetBill == null) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8f6c\u6362\u7684\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u636e\u3002", (String)"BaseImportDataAction_29", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            String billnoAndSrcId = targetBill.getString("billno") + "-" + srcBill.getString("id");
            boolean isNeedChangeData = changeMaterialMap.containsKey(billnoAndSrcId);
            if (existsIds.contains(billnoAndSrcId) && !isNeedChangeData) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5df2\u5b58\u5728\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_30", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5df2\u5b58\u5728\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u636e\uff0c\u4e14\u6ca1\u6709\u6570\u636e\u53d8\u5316\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                idEntryIdCompleteMap.remove(billnoAndSrcId);
                continue;
            }
            if (!existsIds.contains(billnoAndSrcId) && existBillNos.contains(targetBill.getString("billno"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_31", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                continue;
            }
            if (sourceEntryIds != null && (entryentity = targetBill.getDynamicObjectCollection("entryentity")) != null && !entryentity.isEmpty() && sourceEntryIds.contains(((DynamicObject)entryentity.get(0)).getLong("sourcebillentryid"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5728\u5176\u5b83\u65b9\u6848\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_77", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5728\u5176\u5b83\u65b9\u6848\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                continue;
            }
            if (context.getLastSourceEntryIds() != null && (entryentity = targetBill.getDynamicObjectCollection("entryentity")) != null && !entryentity.isEmpty() && context.getLastSourceEntryIds().contains(((DynamicObject)entryentity.get(0)).getLong("sourcebillentryid"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5728\u4e0a\u6708\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_78", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                this.logger.info("\u6e90\u5355{}\u5728\u4e0a\u6708\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\uff0c\u8be5\u5355\u5f15\u5165\u7ed3\u675f\uff01", (Object)srcBill.getString("billno"));
                continue;
            }
            if (willSaveBillNoSet.contains(targetBill.getString("billno"))) {
                context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u5df2\u5bfc\u5165\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_32", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            Long costCenterId = targetBill.getLong("costcenter.id");
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"BaseImportDataAction_33", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            if (!costCenters.contains(costCenterId)) continue;
            if ("im_materialreqoutbill".equals(sourceBillEntity)) {
                long bizorg;
                String manuorgField = configMappingMap.get("manuorg");
                long l = bizorg = manuorgField == null ? 0L : srcBill.getLong(manuorgField);
                if (isEnableMultiFactory && CadEmptyUtils.isEmpty((List)(manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)bizorg, (String)this.getEntityId(appNum), (String)appNum)))) {
                    this.getMatUseContext().logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")), ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\uff0c\u6216\u65e0\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"BaseImportDataAction_12", (String)"macc-cad-mservice", (Object[])new Object[0]));
                    context.getCollectReport().logTip(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseImportDataAction_3", (String)"macc-cad-mservice", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u7684\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\uff0c\u6216\u65e0\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8be5\u5355\u5bfc\u5165\u7ed3\u675f\u3002", (String)"BaseImportDataAction_35", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                    this.logger.info("\u6e90\u5355:{}\u9700\u6c42\u7ec4\u7ec7\u65e0\u751f\u4ea7\u7ec4\u7ec7\u804c\u80fd\u6216\u6ca1\u6709\u59d4\u6258\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8df3\u8fc7\u6b64\u5355", (Object)bizorg);
                    continue;
                }
            }
            Map<String, DynamicObject> matInfoList = existCostObjectMap.get(String.valueOf(acctOrg).concat(String.valueOf(costCenterId)));
            if (!isNeedChangeData) {
                ++addNum;
            } else {
                DynamicObject materialUse = idEntryIdCompleteMap.remove(billnoAndSrcId);
                String entryField = "";
                manuorgList = configMappingMap.entrySet().iterator();
                while (manuorgList.hasNext()) {
                    Map.Entry configMapping = (Map.Entry)manuorgList.next();
                    String cost = (String)configMapping.getKey();
                    if (!cost.contains(".")) continue;
                    entryField = cost.split("\\.")[0];
                    break;
                }
                DynamicObjectCollection entry = materialUse.getDynamicObjectCollection(entryField);
                DynamicObjectCollection srcentry = targetBill.getDynamicObjectCollection(entryField);
                this.updateEntry(entry, srcentry);
                for (Map.Entry entry2 : configMappingMap.entrySet()) {
                    String cost = (String)entry2.getKey();
                    if (cost.contains(".")) {
                        String field = cost.split("\\.")[1];
                        for (DynamicObject row : entry) {
                            for (DynamicObject srcrow : srcentry) {
                                if (row.getLong("sourcebillentryid") != srcrow.getLong("sourcebillentryid")) continue;
                                row.set(field, srcrow.get(field));
                                row.set("isrework", srcrow.get("isrework"));
                            }
                        }
                        continue;
                    }
                    materialUse.set(cost, targetBill.get(cost));
                }
                materialUse.set("srcauditdate", targetBill.get("srcauditdate"));
                targetBill = materialUse;
                ++updNum;
            }
            DynamicObjectCollection entryentity2 = targetBill.getDynamicObjectCollection("entryentity");
            boolean isNoCostObject = false;
            for (DynamicObject entry : entryentity2) {
                void var39_49;
                DynamicObject srcBillData;
                DynamicObject costObject;
                if (entry.getDynamicObject("costobject") != null) {
                    costObject = entry.getDynamicObject("costobject");
                    if (isNeedChangeData) {
                        long l = entry.getLong("sourcebillentryid");
                        srcBillData = srcBillEntryIdAndSrcDataMap.get(l);
                        DynamicObject newCostObject = this.getCostObjectBySrcBillInfo(srcBillData, collConfigRuleMappingMap, sourceBillEntity, entryIdCostObjectMap, matInfoList);
                        if (newCostObject != null) {
                            if (newCostObject.getLong("id") != costObject.getLong("id")) {
                                costObject = newCostObject;
                            }
                        } else {
                            costObject = null;
                        }
                    }
                } else {
                    long l = entry.getLong("sourcebillentryid");
                    srcBillData = srcBillEntryIdAndSrcDataMap.get(l);
                    costObject = this.getCostObjectBySrcBillInfo(srcBillData, collConfigRuleMappingMap, sourceBillEntity, entryIdCostObjectMap, matInfoList);
                }
                if (costObject == null) {
                    if ("im_materialreqoutbill".equals(sourceBillEntity)) {
                        long l = entry.getLong("sourcebillentryid");
                        srcBillData = srcBillEntryIdAndSrcDataMap.get(l);
                        if (srcBillData != null) {
                            Long product = 0L;
                            if (srcBillData.containsProperty("billentry.product")) {
                                product = srcBillData.getLong("billentry.product");
                            }
                            if (!CadEmptyUtils.isEmpty((Long)product) && checkStProductCbCheck) {
                                if (CostObjectEnum.BIZTYPE_SO.getValue().equals(config.getString("calmethod"))) {
                                    String productnum = "";
                                    if (srcBillData.containsProperty("billentry.productnum")) {
                                        productnum = srcBillData.getString("billentry.productnum");
                                    }
                                    if (!CadEmptyUtils.isEmpty((String)productnum)) {
                                        isNoCostObject = true;
                                    }
                                }
                                if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(config.getString("calmethod")) || CostObjectEnum.BIZTYPE_FL.getValue().equals(config.getString("calmethod"))) {
                                    isNoCostObject = true;
                                }
                            }
                        }
                    } else if (!"cal_costadjust_subentity".equals(sourceBillEntity)) {
                        isNoCostObject = true;
                    }
                    if (isNoCostObject) continue;
                }
                if (CostObjectEnum.BIZTYPE_SO.getValue().equals(config.getString("calmethod")) && "im_materialreqoutbill".equals(sourceBillEntity) && (CadEmptyUtils.isEmpty((Long)entry.getLong("material")) || CadEmptyUtils.isEmpty((String)entry.getString("productnum")))) {
                    costObject = null;
                }
                entry.set("costobject", (Object)(costObject == null ? 0L : costObject.getLong("id")));
                entry.set("costobject_id", (Object)(costObject == null ? 0L : costObject.getLong("id")));
                if (costObject == null) continue;
                Long l = 0L;
                if (costObject.get("bomversion") instanceof DynamicObject) {
                    Long l2 = costObject.getLong("bomversion.id");
                } else if (costObject.get("bomversion") instanceof Long) {
                    Long l3 = costObject.getLong("bomversion");
                }
                entry.set("matversion", (Object)var39_49);
            }
            if (isNoCostObject) {
                if ("sca".equals(appNum)) {
                    context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u672a\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"BaseImportDataAction_54", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                    continue;
                }
                context.logErrorMsg(srcBill.getString("billno").concat("@").concat(srcBill.getString("entryseq")).concat("@").concat(srcBill.getString("billtype")), String.format(ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u6ca1\u6709\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"BaseImportDataAction_55", (String)"macc-cad-mservice", (Object[])new Object[0]), srcBill.getString("billno")));
                continue;
            }
            targetBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("createtime", (Object)TimeServiceHelper.now());
            targetBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("modifytime", (Object)TimeServiceHelper.now());
            targetBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            targetBill.set("auditdate", (Object)TimeServiceHelper.now());
            materialBills.add(targetBill);
        }
        this.getMatUseContext().setAddNum(this.getMatUseContext().getAddNum() + addNum);
        this.getMatUseContext().setUpdateNum(this.getMatUseContext().getUpdateNum() + updNum);
        this.getMatUseContext().getNewBillList().addAll(materialBills);
        this.setMatUseResultArgs(acctOrg, costCenters, config.getLong("id"), materialBills, existCostObjectMap, existMaterialBills);
        this.logger.info("\u65b0\u589e\u6216\u66f4\u65b0\u7684\u6750\u6599\u8017\u7528\u91cf\u5f52\u96c6\u5355:{}", (Object)materialBills.size());
        return materialBills;
    }

    protected void updateEntry(DynamicObjectCollection entry, DynamicObjectCollection srcentry) {
        if (entry == null || srcentry == null) {
            return;
        }
        Set curSrcEntryIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)entry, (String)"sourcebillentryid");
        Set tarSrcEntryIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)srcentry, (String)"sourcebillentryid");
        HashSet curEntryIds = new HashSet(curSrcEntryIds);
        curEntryIds.removeAll(tarSrcEntryIds);
        tarSrcEntryIds.removeAll(curSrcEntryIds);
        ArrayList<DynamicObject> needRemove = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needAdd = new ArrayList<DynamicObject>(10);
        for (DynamicObject row : entry) {
            if (!curEntryIds.contains(row.getLong("sourcebillentryid"))) continue;
            needRemove.add(row);
        }
        for (DynamicObject row : srcentry) {
            if (!tarSrcEntryIds.contains(row.getLong("sourcebillentryid"))) continue;
            needAdd.add(row);
        }
        entry.removeAll(needRemove);
        entry.addAll(needAdd);
    }

    protected DynamicObject getCostObjectBySrcBillInfo(DynamicObject srcBillData, TreeMap<String, String> collConfigRuleMappingMap, String sourceBillEntity, Map<Long, DynamicObject> entryIdCostObjectMap, Map<String, DynamicObject> existCostObjectMap) {
        if (srcBillData == null) {
            return null;
        }
        DynamicObject costObject = null;
        if ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
            String coField = collConfigRuleMappingMap.get("material");
            if (coField != null && coField.contains("manuentryid") && entryIdCostObjectMap != null) {
                costObject = entryIdCostObjectMap.get(srcBillData.getLong("billentry.id"));
            } else {
                String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBillData, collConfigRuleMappingMap);
                costObject = existCostObjectMap == null ? null : existCostObjectMap.get(srcStr);
            }
        } else {
            String srcStr = CostObjectHelper.getCostObjectHashCodeBySrcBill((DynamicObject)srcBillData, collConfigRuleMappingMap);
            costObject = existCostObjectMap == null ? null : existCostObjectMap.get(srcStr);
        }
        return costObject;
    }

    protected Map<Long, DynamicObject> getSrcBillEntryIdAndSrcDataMap(Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, String sourceBillEntity, Set<String> ruleMappings, Set<String> fieldMappings) {
        HashMap<Long, DynamicObject> SrcBillEntryIdAndSrcDataMap = new HashMap<Long, DynamicObject>(16);
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return SrcBillEntryIdAndSrcDataMap;
        }
        HashSet srcIds = new HashSet(16);
        srcAndTargetBillsMap.keySet().forEach(p -> srcIds.add(p.getLong("id")));
        HashSet<Object> selectFields = new HashSet<Object>(16);
        String entryEntity = "";
        if (!CadEmptyUtils.isEmpty(fieldMappings)) {
            for (String string : fieldMappings) {
                Object[] splitValue;
                if (CadEmptyUtils.isEmpty((String)string) || CadEmptyUtils.isEmpty((Object[])(splitValue = string.split(",")))) continue;
                selectFields.addAll(Arrays.asList(splitValue));
            }
        }
        for (String string : selectFields) {
            if (!CadEmptyUtils.isEmpty((String)entryEntity) || !string.contains(".")) continue;
            entryEntity = string.split("\\.")[0];
        }
        if (!CadEmptyUtils.isEmpty(ruleMappings)) {
            for (String string : ruleMappings) {
                if (CadEmptyUtils.isEmpty((String)string)) continue;
                selectFields.add(string);
            }
        }
        if (CadEmptyUtils.isEmpty(selectFields)) {
            return SrcBillEntryIdAndSrcDataMap;
        }
        String selectFieldStr = entryEntity + ".id," + String.join((CharSequence)",", selectFields);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFieldStr, (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)});
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            SrcBillEntryIdAndSrcDataMap.put(dynamicObject.getLong(entryEntity + ".id"), dynamicObject);
        }
        return SrcBillEntryIdAndSrcDataMap;
    }

    private Long getEffectCostAuxpty(Long material, Long auxpty, Map<Long, Boolean> materialMap, String calmethod) {
        if (CadEmptyUtils.isEmpty((Long)auxpty)) {
            return 0L;
        }
        DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)auxpty, (String)"bd_flexauxprop");
        return CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)CostObjectHelper.getMaterialById((Long)material), (DynamicObject)auxptyObj, materialMap, (String)calmethod);
    }

    protected List<Long> getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, String srcBillType, String appNum) {
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            orgQf.and(new QFilter("manuorg", "in", manuOrgs));
        }
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        QFilter createDateQf = new QFilter("createtime", "<", (Object)this.getMatUseContext().getCollectReport().getCollectDate());
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)this.getEntityId(appNum), (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, bookDateQf, AppnumQf, createDateQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected List<Long> getExistsCompletBill(Long org, List<Long> methodCostCenters, List<Long> manuOrgs, List<Long> mftOrderEntryIds, Map<String, String> configRuleMappingMap, String srcBillType, String appNum) {
        if (CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            return this.getExistsCompletBill(org, methodCostCenters, manuOrgs, srcBillType, appNum);
        }
        if (CadEmptyUtils.isEmpty((String)configRuleMappingMap.get("probill"))) {
            return null;
        }
        QFilter orgQf = new QFilter("org", "in", (Object)org);
        orgQf.and(new QFilter("srcbilltype", "=", (Object)srcBillType));
        QFilter costObjectQf = new QFilter("costcenter", "in", methodCostCenters);
        QFilter sourceBillQf = new QFilter("entryentity.costobject.probill", "in", mftOrderEntryIds);
        QFilter AppnumQf = new QFilter("appnum", "=", (Object)appNum);
        QFilter bookDateQf = SysParamHelper.getImportTimeScope((Long)org, (String)"bookdate", (String)appNum);
        QFilter createDateQf = new QFilter("createtime", "<", (Object)this.getMatUseContext().getCollectReport().getCollectDate());
        DynamicObjectCollection completionList = QueryServiceHelper.query((String)this.getEntityId(appNum), (String)"id", (QFilter[])new QFilter[]{orgQf, costObjectQf, sourceBillQf, bookDateQf, AppnumQf, createDateQf});
        if (CadEmptyUtils.isEmpty((List)completionList)) {
            return null;
        }
        return completionList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    protected void dealExitsData(Map<String, DynamicObject> idEntryIdCompleteMap, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, DynamicObject> changeMaterialMap, Set<String> selectFields, String appNum) {
        if (CadEmptyUtils.isEmpty(idEntryIdCompleteMap) || CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        for (Map.Entry<DynamicObject, DynamicObject> srcAndTartgetBill : srcAndTargetBillsMap.entrySet()) {
            DynamicObject newBill = srcAndTartgetBill.getValue();
            String key = newBill.getString("billno").concat("-").concat(newBill.getString("sourcebillid"));
            DynamicObject oldBill = idEntryIdCompleteMap.get(key);
            if (oldBill == null) continue;
            Date nsrcAuditDate = newBill.getDate("nsrcauditdate");
            Date oldNsrcAuditDate = oldBill.getDate("nsrcauditdate");
            if (nsrcAuditDate == null || oldNsrcAuditDate == null || nsrcAuditDate.compareTo(oldNsrcAuditDate) == 0) continue;
            changeMaterialMap.put(key, newBill);
        }
    }

    protected void setMatUseResultArgs(Long acctOrg, List<Long> costCenters, Long configId, List<DynamicObject> materialBills, Map<String, Map<String, DynamicObject>> existCostObjectMap, Map<String, DynamicObject> existMaterialBills) {
        MatUseResultArgs matUseResultArgs = new MatUseResultArgs();
        Map<String, DynamicObject> objectMap = existCostObjectMap.get(String.valueOf(acctOrg));
        DynamicObjectCollection existObjectList = new DynamicObjectCollection();
        if (!CadEmptyUtils.isEmpty(objectMap)) {
            existObjectList.addAll(objectMap.values());
        }
        matUseResultArgs.setExistCostObjects(existObjectList);
        matUseResultArgs.setNewBillList(materialBills);
        if (!CadEmptyUtils.isEmpty(existMaterialBills)) {
            matUseResultArgs.setOldMatUseCollects(existMaterialBills.values().toArray(new DynamicObject[0]));
        }
        matUseResultArgs.setImpCostCenters(new HashSet<Long>(costCenters));
        this.getMatUseContext().getMatUseResultMap().put(String.valueOf(configId), matUseResultArgs);
    }

    private String getCostObjectHashCodeBySrcBill(DynamicObject srcBill, Map<String, String> collConfigRuleMappingMap) {
        this.logger.info("collConfigRuleMappingMap:{}", collConfigRuleMappingMap);
        String str = "";
        if (CadEmptyUtils.isEmpty(collConfigRuleMappingMap)) {
            return str;
        }
        this.logger.info("\u8ba1\u7b97hashCode");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> configRule : collConfigRuleMappingMap.entrySet()) {
            String srcField = configRule.getValue();
            if (CadEmptyUtils.isEmpty((String)srcField)) {
                this.logger.info("srcField\u4e3a\u7a7a\uff0c{}", configRule);
                continue;
            }
            this.logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5339\u914d\u4fe1\u606f\u6e90\u5355\u5b57\u6bb5\uff1a{}", (Object)srcField);
            sb.append(srcBill.getString(srcField));
        }
        this.logger.info("\u8ba1\u7b97hashCode\u503c\uff1a{}", (Object)sb.toString());
        return sb.toString();
    }

    static /* synthetic */ Long access$000() {
        return PRO_FALLBACK_SHEMEID;
    }

    static /* synthetic */ Long access$100() {
        return PRO_OUTSTORAGE_FALLBACK_SHEMEID;
    }

    static /* synthetic */ Long access$200() {
        return PRO_FALLBACK_OMSHEMEID;
    }
}

