/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;

public class CostRecoveryDiffCalculateHelper {
    public static final int FINISH_TYPE = 1;
    public static final int TRANSIN_TYPE = 2;
    public static final int PURSIN_TYPE = 3;

    public static void diffCalculate(List<RowX> allRowX, int amtScale, RowMeta srcMeta, int calType) {
        CostRecoveryDiffCalculateHelper.diffCalculate(allRowX, amtScale, srcMeta, calType, true);
    }

    public static void diffCalculate(List<RowX> allRowX, int amtScale, RowMeta srcMeta, int calType, boolean sumRowAmt) {
        BigDecimal parentAmt;
        String keytreePath;
        HashMap subRoxMap = Maps.newHashMapWithExpectedSize((int)16);
        String actAmountKey = "actAmountForFinish";
        String actQtyKey = "actQtyForFinish";
        if (calType == 1) {
            actAmountKey = "actAmountForFinish";
            actQtyKey = "actQtyForFinish";
        } else if (calType == 2) {
            actAmountKey = "actAmountForTrans";
            actQtyKey = "actQtyForTrans";
        } else if (calType == 3) {
            actAmountKey = "actAmountForPurs";
            actQtyKey = "actQtyForPurs";
        }
        HashMap<String, BigDecimal> keyPathAmt = new HashMap<String, BigDecimal>(10);
        for (RowX row : allRowX) {
            keytreePath = row.getString(srcMeta.getFieldIndex("keytreePath"));
            if (sumRowAmt) {
                parentAmt = row.getBigDecimal(srcMeta.getFieldIndex(actAmountKey));
                if (keyPathAmt.containsKey(keytreePath)) {
                    parentAmt = parentAmt.add((BigDecimal)keyPathAmt.get(keytreePath));
                }
                keyPathAmt.put(keytreePath, parentAmt);
            }
            String tmpTree = keytreePath.substring(0, keytreePath.lastIndexOf("@"));
            List subList = (List)subRoxMap.get(tmpTree);
            if (subRoxMap.get(tmpTree) == null) {
                subList = Lists.newArrayList();
                subRoxMap.put(tmpTree, subList);
            }
            subList.add(row);
        }
        for (RowX row : allRowX) {
            BigDecimal calPraAmt;
            List subList;
            keytreePath = row.getString(srcMeta.getFieldIndex("keytreePath"));
            parentAmt = row.getBigDecimal(srcMeta.getFieldIndex(actAmountKey));
            BigDecimal sumAmt = (BigDecimal)keyPathAmt.get(keytreePath);
            if (sumAmt != null && parentAmt.compareTo(sumAmt) != 0) {
                parentAmt = sumAmt;
            }
            if ((subList = (List)subRoxMap.get(keytreePath)) == null) continue;
            BigDecimal subTotalAmt = BigDecimal.ZERO;
            for (RowX subRow : subList) {
                BigDecimal subAmount = subRow.getBigDecimal(srcMeta.getFieldIndex(actAmountKey));
                subTotalAmt = subTotalAmt.add(subAmount);
            }
            if (subTotalAmt.compareTo(BigDecimal.ZERO) == 0 || parentAmt.compareTo(subTotalAmt) == 0) continue;
            RowX tmpRowX = null;
            BigDecimal tmpCompare = BigDecimal.ZERO;
            BigDecimal diffAmt = calPraAmt = parentAmt.subtract(subTotalAmt);
            for (RowX subRow : subList) {
                BigDecimal subAmount = subRow.getBigDecimal(srcMeta.getFieldIndex(actAmountKey));
                BigDecimal radio = subAmount.divide(subTotalAmt, 10, RoundingMode.HALF_UP);
                BigDecimal subDiffAmt = calPraAmt.multiply(radio).setScale(amtScale, RoundingMode.HALF_UP);
                BigDecimal newSubAmount = subAmount.add(subDiffAmt);
                if (subAmount.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal subActQty = subRow.getBigDecimal(srcMeta.getFieldIndex(actQtyKey));
                    subActQty = subActQty.multiply(newSubAmount.divide(subAmount, 10, RoundingMode.HALF_UP)).setScale(10, RoundingMode.HALF_UP);
                    subRow.set(srcMeta.getFieldIndex(actQtyKey), (Object)subActQty);
                }
                subRow.set(srcMeta.getFieldIndex(actAmountKey), (Object)newSubAmount);
                if (tmpRowX == null || subDiffAmt.abs().compareTo(tmpCompare.abs()) > 0) {
                    tmpCompare = subDiffAmt;
                    tmpRowX = subRow;
                }
                diffAmt = diffAmt.subtract(subDiffAmt);
            }
            if (diffAmt.compareTo(BigDecimal.ZERO) == 0 || tmpRowX == null) continue;
            tmpRowX.set(srcMeta.getFieldIndex(actAmountKey), (Object)tmpRowX.getBigDecimal(srcMeta.getFieldIndex(actAmountKey)).add(diffAmt));
        }
    }
}

