/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ImLotHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.CommonUtils;
import kd.sdk.scmc.im.extpoint.IInvBatchFillExpand;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.BooleanUtils;

public class FillBatchHelper {
    private static final Log log = LogFactory.getLog(FillBatchHelper.class);
    private static final String[] needFillFields = new String[]{"taxrateid", "deliveryway", "receiveaddress", "deliveryaddress", "inorg", "outorg", "inproject", "project", "invstatus", "invtype", "ownertype", "keepertype", "outinvstatus", "outinvtype", "outownertype", "transitownertype"};
    private static final Set<String> notBatchFillFieldSet = Sets.newHashSet((Object[])new String[]{"linetype", "materialname", "model", "unit", "baseunit", "baseqty", "unit2nd", "ownertype", "keepertype", "outownertype", "outkeepertype", "keeper", "outkeeper", "projectname", "taxrate", "curamount", "curtaxamount", "curamountandtax", "phone", "isinspect", "curdeductibleamt", "rowstatus", "kitproducttype", "kitproduct", "pricemodel", "kittransfermodel", "conbillnumber", "conbillrownum", "logisticsbill", "subtype", "ystartqty"});
    private static final String CHECK_WAREHOUSE_INV_IN = "2";

    public static void batchFill(IFormView view) {
        FillBatchHelper.batchFill(view, "billentry", needFillFields);
    }

    public static void batchFill(IFormView view, String entryName, String[] needFillFields) {
        IDataModel model = view.getModel();
        int currentRow = model.getEntryCurrentRowIndex(entryName);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        String selKey = entryGrid.getEntryState().getFocusField();
        Object o = entryGrid.getEntryState().get(selKey);
        Control control = view.getControl(selKey);
        if (control instanceof BasedataPropEdit) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5b57\u6bb5\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"FillBatchHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
            return;
        }
        if (currentRow == -1 || CommonUtils.isNull((Object)selKey) || "0".equals(selKey) || "seq".equals(selKey)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"FillBatchHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
            return;
        }
        Set<String> extField = FillBatchHelper.getPluginExtFieldList(model.getDataEntity().getDataEntityType().getName());
        if (!extField.contains(selKey)) {
            return;
        }
        Object selValue = model.getValue(selKey, currentRow);
        if (CommonUtils.isNull((Object)selValue) || selValue instanceof ILocaleString && StringUtils.isBlank((CharSequence)selValue.toString())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u503c\u586b\u5145\u3002", (String)"FillBatchHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            return;
        }
        int rowCount = model.getEntryRowCount(entryName);
        ArrayList<String> needFillFieldList = new ArrayList<String>(Arrays.asList(needFillFields));
        needFillFieldList.addAll(extField);
        MultiKeyMap warehouseIdCache = new MultiKeyMap();
        for (int i = currentRow + 1; i < rowCount; ++i) {
            boolean needFill;
            boolean isFill;
            Object object = model.getValue(selKey, i);
            boolean bl = isFill = StringUtils.isBlank((Object)object) || object instanceof BigDecimal && ((BigDecimal)object).compareTo(BigDecimal.ZERO) == 0 || object instanceof Integer && "0".equals(String.valueOf(object)) || object instanceof ILocaleString && StringUtils.isBlank((CharSequence)object.toString());
            if (!isFill) continue;
            DynamicObject warehouse = null;
            if (needFillFieldList.contains(selKey)) {
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("location".equals(selKey)) {
                warehouse = (DynamicObject)model.getValue("warehouse", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i, selKey, (MultiKeyMap<Object, Boolean>)warehouseIdCache);
                continue;
            }
            if ("location1".equals(selKey)) {
                warehouse = (DynamicObject)model.getValue("warehouse1", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i, selKey, (MultiKeyMap<Object, Boolean>)warehouseIdCache);
                continue;
            }
            if ("inlocation".equals(selKey)) {
                warehouse = (DynamicObject)model.getValue("inwarehouse", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i, selKey, (MultiKeyMap<Object, Boolean>)warehouseIdCache);
                continue;
            }
            if ("outlocation".equals(selKey)) {
                warehouse = "im_locationtransfer".equals(view.getEntityId()) ? (DynamicObject)model.getValue("warehouse", i) : (DynamicObject)model.getValue("outwarehouse", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i, selKey, (MultiKeyMap<Object, Boolean>)warehouseIdCache);
                continue;
            }
            if ("qualifiedlocation".equals(selKey)) {
                warehouse = (DynamicObject)model.getValue("qualifiedwarehouse", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i, selKey, (MultiKeyMap<Object, Boolean>)warehouseIdCache);
                continue;
            }
            if ("unqualifiedlocation".equals(selKey)) {
                warehouse = (DynamicObject)model.getValue("unqualifiedwarehouse", i);
                FillBatchHelper.fillLocationCell(view, entryName, warehouse, selValue, i, selKey, (MultiKeyMap<Object, Boolean>)warehouseIdCache);
                continue;
            }
            if (selKey.contains("warehouse")) {
                FillBatchHelper.fillWarehouseCell(view, selKey, selValue, i);
                continue;
            }
            if ("owner".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "ownertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("keeper".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "keepertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("outowner".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "outownertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("outkeeper".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByType(model, "outkeepertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("transitowner".equals(selKey)) {
                needFill = FillBatchHelper.isNeedFillByOwner(model, "transitownertype", i, currentRow);
                if (!needFill) continue;
                model.setValue(selKey, selValue, i);
                continue;
            }
            String name = model.getProperty(selKey).getDisplayName().getLocaleValue();
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"FillBatchHelper_2", (String)"scmc-im-business", (Object[])new Object[0]), name));
            break;
        }
    }

    private static Set<String> getPluginExtFieldList(String entityTypeName) {
        HashSet<String> extField = new HashSet<String>(16);
        PluginProxy batchPluginProxy = PluginProxy.create(IInvBatchFillExpand.class, (String)"SCMC_IM_INV_FILLBATCH");
        List plugins = batchPluginProxy.getPlugins();
        for (IInvBatchFillExpand iPlugin : plugins) {
            List fieldKey = iPlugin.getFieldKey(entityTypeName);
            if (fieldKey == null || fieldKey.isEmpty()) continue;
            extField.addAll(fieldKey);
        }
        return extField;
    }

    private static boolean isNeedFillByOwner(IDataModel model, String ownerTypeField, int i, int currentRow) {
        Object ownerType = model.getValue(ownerTypeField, currentRow);
        Object curOwnerType = model.getValue(ownerTypeField, i);
        if (ownerType == null || curOwnerType == null) {
            return false;
        }
        return ownerType.equals(curOwnerType);
    }

    private static boolean isNeedFillByType(IDataModel model, String field, int fillRow, int curRow) {
        boolean needFill = false;
        Object ownerType = model.getValue(field, fillRow);
        Object curOwnerType = model.getValue(field, curRow);
        if (ownerType == null || curOwnerType == null) {
            return needFill;
        }
        if (ownerType.equals(curOwnerType)) {
            needFill = true;
        }
        return needFill;
    }

    private static void fillWarehouseCell(IFormView view, String selKey, Object selValue, int i) {
        String formId;
        IDataModel model = view.getModel();
        DynamicObject org = FillBatchHelper.entryOrgDeal(view, selKey, i, model, formId = model.getDataEntityType().getName());
        if (null == org) {
            model.setValue(selKey, selValue, i);
            return;
        }
        Long whPk = (Long)((DynamicObject)selValue).getPkValue();
        Long[] ids = WarehouseHelper.getAllWarehouseIDs((Long)((Long)org.getPkValue()));
        HashSet<Long> idSet = new HashSet<Long>(Arrays.asList(ids));
        if (idSet.contains(whPk)) {
            model.setValue(selKey, selValue, i);
        }
    }

    private static DynamicObject entryOrgDeal(IFormView view, String selKey, int i, IDataModel model, String formId) {
        DynamicObject org = null;
        if ("im_transapply".equals(formId) || "im_transdirbill".equals(formId)) {
            if ("inwarehouse".equals(selKey) && MetaDataHelper.isExistField((MainEntityType)view.getModel().getDataEntityType(), (String)"billentry", (String)"inorg")) {
                org = (DynamicObject)model.getValue("inorg", i);
            }
            String orgField = "outorg";
            if ("im_transdirbill".equals(formId)) {
                orgField = "org";
            }
            if ("warehouse".equals(selKey) && MetaDataHelper.isExistField((MainEntityType)view.getModel().getDataEntityType(), (String)"billentry", (String)orgField)) {
                org = (DynamicObject)model.getValue(orgField, i);
            }
        }
        return org;
    }

    private static void fillLocationCell(IFormView view, String entryName, DynamicObject warehouse, Object value, int index, String selKey, MultiKeyMap<Object, Boolean> warehouseIdCache) {
        Object locationId;
        if (CommonUtils.isNull((Object)warehouse)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        Object warehouseId = warehouse.getPkValue();
        Boolean exist = (Boolean)warehouseIdCache.get(warehouseId, locationId = ((DynamicObject)value).getPkValue());
        if (null == exist) {
            QFilter qFilter = new QFilter("id", "=", warehouseId);
            qFilter.and("entryentity.location", "=", locationId);
            exist = QueryServiceHelper.exists((String)"bd_warehouse", (QFilter[])qFilter.toArray());
            warehouseIdCache.put(warehouseId, locationId, (Object)exist);
        }
        if (BooleanUtils.isTrue((Boolean)((Boolean)warehouseIdCache.get(warehouseId, locationId)))) {
            DynamicObject outLocation;
            if (view.getModel().getDataEntityType().getName().equals("im_locationtransfer") && null != (outLocation = (DynamicObject)view.getModel().getValue("outlocation", index)) && outLocation.getPkValue().equals(locationId)) {
                return;
            }
            view.getModel().setValue(selKey, value, index);
        }
    }

    public static void batchSetPredicate(IFormView formView, BeforeBatchFillEntryArgs e) {
        boolean fillEntry = FillBatchHelper.checkBatchFillEntry(formView);
        String focusEntry = FillBatchHelper.getFocusEntry(formView);
        if (StringUtils.isEmpty((CharSequence)focusEntry)) {
            return;
        }
        HashSet whMatIdConcatSet = new HashSet(16);
        HashMap warehouseLocationMap = new HashMap(16);
        HashMap orgWarehouseMap = new HashMap(16);
        AtomicReference appParameter = new AtomicReference();
        IDataModel model = formView.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String bizTypeNum = FillBatchHelper.getBizTypeNum(dataEntity);
        EntryGrid entryGrid = (EntryGrid)formView.getControl(focusEntry);
        String selPropName = entryGrid.getEntryState().getFocusField();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        DynamicObjectCollection billEntry = FillBatchHelper.getFocusEntryColl(formView, focusEntry);
        if (billEntry.isEmpty() || focusRow == -1 || focusRow >= billEntry.size()) {
            return;
        }
        DynamicObject focusDyn = (DynamicObject)billEntry.get(focusRow);
        HashMap inspOrgMap = new HashMap(16);
        e.setPredicate(e.getPredicate().and(rowItem -> {
            try {
                String name = rowItem.getSelProp().getParent().getName();
                if (!"afterentity".equals(name) && !"billentry".equals(name)) {
                    return true;
                }
                int row = rowItem.getRow();
                DynamicObject rowDyn = (DynamicObject)billEntry.get(row);
                if (!FillBatchHelper.checkBill(fillEntry, rowDyn, selPropName)) {
                    return false;
                }
                switch (selPropName) {
                    case "yreceiveqty": 
                    case "yreceiveqtyunit2nd": 
                    case "ysendqty": 
                    case "ysendqtyunit2nd": 
                    case "qty": 
                    case "auditqty": 
                    case "qualifiedqty": 
                    case "qtyunit2nd": 
                    case "qty1": 
                    case "qtyunit2nd1": 
                    case "producedate": 
                    case "expirydate": 
                    case "producedate1": 
                    case "expirydate1": 
                    case "lotnumber": 
                    case "inlotnumber": 
                    case "lotnumber1": {
                        return false;
                    }
                    case "discountamount": {
                        return FillBatchHelper.checkDiscountAmount(row, focusRow, rowDyn, focusDyn, dataEntity);
                    }
                    case "actualprice": 
                    case "actualtaxprice": {
                        return FillBatchHelper.checkActualPrice(row, focusRow, rowDyn, dataEntity, selPropName);
                    }
                    case "taxamount": {
                        return FillBatchHelper.checkTaxAmount(row, focusRow, rowDyn, dataEntity);
                    }
                    case "taxrateid": {
                        return !rowDyn.getBoolean("ispresent");
                    }
                    case "price": 
                    case "priceandtax": 
                    case "amount": {
                        return FillBatchHelper.getPriceAmountEnable(model, row, selPropName);
                    }
                    case "material": {
                        return FillBatchHelper.checkMaterial(formView, row, focusRow, whMatIdConcatSet, selPropName, appParameter);
                    }
                    case "material1": {
                        return FillBatchHelper.checkAfterMaterial(formView, row, focusRow, whMatIdConcatSet, selPropName, bizTypeNum, appParameter);
                    }
                    case "invstatus1": {
                        return FillBatchHelper.checkBizTypeEdit(bizTypeNum, "510", "512");
                    }
                    case "warehouse": 
                    case "outwarehouse": 
                    case "warehouse1": 
                    case "inwarehouse": 
                    case "qualifiedwarehouse": 
                    case "unqualifiedwarehouse": {
                        return FillBatchHelper.checkWareHouse(dataEntity, rowDyn, focusDyn, whMatIdConcatSet, selPropName, appParameter, focusEntry, orgWarehouseMap);
                    }
                    case "inlocation": 
                    case "location": 
                    case "location1": 
                    case "outlocation": 
                    case "qualifiedlocation": 
                    case "unqualifiedlocation": {
                        return FillBatchHelper.checkLocation(dataEntity, rowDyn, focusDyn, selPropName, warehouseLocationMap);
                    }
                    case "configuredcode": 
                    case "configuredcode1": {
                        return FillBatchHelper.checkConfiguredCode(bizTypeNum, focusEntry, selPropName, rowDyn, focusDyn, dataEntity.getDataEntityType().getName());
                    }
                    case "invtype1": {
                        return FillBatchHelper.checkBizTypeEdit(bizTypeNum, "510");
                    }
                    case "tracknumber1": 
                    case "project1": {
                        return !"im_adjustbill".equals(dataEntity.getDataEntityType().getName()) || FillBatchHelper.checkBizTypeEdit(bizTypeNum, "510", "515");
                    }
                    case "amountandtax": 
                    case "discounttype": {
                        return !rowDyn.getBoolean("ispresent");
                    }
                    case "discountrate": {
                        return FillBatchHelper.checkDiscountRate(dataEntity, row, focusRow);
                    }
                    case "emrelease": {
                        return rowDyn.getBoolean("isinspect");
                    }
                    case "shortageratio": 
                    case "excessratio": {
                        return !rowDyn.getBoolean("uncontrolledqty");
                    }
                    case "inowner": {
                        return FillBatchHelper.isNeedFillByOwner(model, "inownertype", row, focusRow);
                    }
                    case "outowner": {
                        return FillBatchHelper.isNeedFillByOwner(model, "outownertype", row, focusRow);
                    }
                    case "owner": {
                        return FillBatchHelper.isNeedFillByOwner(model, "ownertype", row, focusRow);
                    }
                    case "insporg": {
                        return FillBatchHelper.checkInspOrg(inspOrgMap, rowDyn, focusDyn);
                    }
                    case "auxpty": 
                    case "auxpty1": {
                        return FillBatchHelper.checkAuxPty(focusEntry, rowDyn, focusDyn);
                    }
                }
                return true;
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
                throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u586b\u5145\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FillBatchHelper_4", (String)"scmc-im-business", (Object[])new Object[0]));
            }
        }));
    }

    private static String getBizTypeNum(DynamicObject dataEntity) {
        DynamicObject bizType = dataEntity.getDynamicObject("biztype");
        String bizTypeNum = "";
        if (!"im_initbill".equals(dataEntity.getDataEntityType().getName())) {
            if (bizType == null) {
                throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getEMPTY_BIZTYPE()));
            }
            bizTypeNum = bizType.getString("number");
        }
        return bizTypeNum;
    }

    private static boolean checkAuxPty(String focusEntry, DynamicObject rowDyn, DynamicObject focusDyn) {
        String matFieldCode = FillBatchHelper.getNowMaterialField(focusEntry);
        DynamicObject material = rowDyn.getDynamicObject(matFieldCode);
        if (material == null || focusDyn == null || focusDyn.getDynamicObject(matFieldCode) == null) {
            return false;
        }
        return material.getPkValue().equals(focusDyn.getDynamicObject(matFieldCode).getPkValue());
    }

    private static boolean checkBill(boolean fillEntry, DynamicObject rowDyn, String selPropName) {
        if (!fillEntry) {
            return false;
        }
        if (rowDyn == null) {
            return false;
        }
        Object nowLineValue = rowDyn.get(selPropName);
        boolean haveValue = FillBatchHelper.checkCellHaveValue(nowLineValue);
        return !haveValue;
    }

    private static boolean checkAuditQty(DynamicObject rowDyn, DynamicObject focusDyn) {
        BigDecimal auditQty;
        BigDecimal qty = rowDyn.getBigDecimal("qty");
        return qty.compareTo(auditQty = focusDyn.getBigDecimal("auditqty")) >= 0;
    }

    private static boolean checkConfiguredCode(String bizTypeNum, String focusEntry, String selPropName, DynamicObject rowDyn, DynamicObject focusDyn, String entityName) {
        if ("im_adjustbill".equals(entityName) && "configuredcode1".equals(selPropName) && !FillBatchHelper.checkBizTypeEdit(bizTypeNum, "510", "515")) {
            return false;
        }
        String matFieldCode = FillBatchHelper.getNowMaterialField(focusEntry);
        DynamicObject material = rowDyn.getDynamicObject(matFieldCode);
        if (material == null) {
            return false;
        }
        DynamicObject materialFocus = focusDyn.getDynamicObject(matFieldCode);
        return material.getLong("masterid.id") == materialFocus.getLong("masterid.id");
    }

    private static boolean checkAfterLotNumber(DynamicObject rowDyn, String bizTypeNum, String entityName) {
        if (FillBatchHelper.getMaterialInvEnable(rowDyn.getDynamicObject("material1"), "enablelot")) {
            if ("im_adjustbill".equals(entityName)) {
                return FillBatchHelper.checkBizTypeEdit(bizTypeNum, "510", "511");
            }
            return true;
        }
        return false;
    }

    private static boolean checkAfterMaterial(IFormView formView, int row, int focusRow, Set<String> whMatIdConcatSet, String selPropName, String bizTypeNum, AtomicReference<Object> appParameter) {
        if ("im_adjustbill".equals(formView.getModel().getDataEntity().getDataEntityType().getName()) && !FillBatchHelper.checkBizTypeEdit(bizTypeNum, "510")) {
            return false;
        }
        return FillBatchHelper.checkMaterial(formView, row, focusRow, whMatIdConcatSet, selPropName, appParameter);
    }

    private static boolean checkTaxAmount(int row, int focusRow, DynamicObject rowDyn, DynamicObject dataEntity) {
        Boolean taxIsPresent = rowDyn.getBoolean("ispresent");
        if (taxIsPresent.booleanValue()) {
            return false;
        }
        return FillBatchHelper.checkPriceOrAmount(dataEntity, row, focusRow, "amountandtax", "taxamount");
    }

    private static boolean checkActualPrice(int row, int focusRow, DynamicObject rowDyn, DynamicObject dataEntity, String selPropName) {
        Boolean priceIsPresent = rowDyn.getBoolean("ispresent");
        if (priceIsPresent.booleanValue()) {
            return false;
        }
        return FillBatchHelper.checkPriceOrAmount(dataEntity, row, focusRow, "price", selPropName);
    }

    private static boolean checkDiscountAmount(int row, int focusRow, DynamicObject rowDyn, DynamicObject focusDyn, DynamicObject dataEntity) {
        String focusDiscountType = focusDyn.getString("discounttype");
        String discountType = rowDyn.getString("discounttype");
        if (StringUtils.isEmpty((CharSequence)focusDiscountType) || StringUtils.isEmpty((CharSequence)discountType) || !discountType.equals(focusDiscountType)) {
            return false;
        }
        return FillBatchHelper.checkPriceOrAmount(dataEntity, row, focusRow, "amountandtax", "discountamount");
    }

    private static boolean checkQtyUnit2nd(String focusEntry, DynamicObject rowDyn) {
        String matField = FillBatchHelper.getNowMaterialField(focusEntry);
        DynamicObject materialInv = rowDyn.getDynamicObject(matField);
        if (materialInv == null) {
            return false;
        }
        DynamicObject masterId = materialInv.getDynamicObject("masterid");
        DynamicObject auxptyUnit = masterId.getDynamicObject("auxptyunit");
        return auxptyUnit != null;
    }

    private static boolean checkInspOrg(Map<Object, List<Long>> inspOrgMap, DynamicObject rowDyn, DynamicObject focusDyn) {
        DynamicObject focusReqOrg = focusDyn.getDynamicObject("entryreqorg");
        DynamicObject focusInspOrg = focusDyn.getDynamicObject("insporg");
        if (focusReqOrg == null) {
            return true;
        }
        DynamicObject reqOrg = rowDyn.getDynamicObject("entryreqorg");
        if (reqOrg == null) {
            return true;
        }
        if (focusReqOrg.getPkValue().equals(reqOrg.getPkValue())) {
            return true;
        }
        List<Long> allToOrg = FillBatchHelper.getInspOrgList(inspOrgMap, reqOrg);
        return allToOrg.contains((Long)focusInspOrg.getPkValue());
    }

    private static List<Long> getInspOrgList(Map<Object, List<Long>> inspOrgMap, DynamicObject reqOrg) {
        List<Long> allToOrg = null;
        if (reqOrg == null) {
            return FillBatchHelper.getAllInspOrgListByOrg(inspOrgMap);
        }
        Object reqOrgPkId = reqOrg.getPkValue();
        if (inspOrgMap.containsKey(reqOrgPkId)) {
            allToOrg = inspOrgMap.get(reqOrgPkId);
            if (CollectionUtils.isEmpty(allToOrg)) {
                allToOrg = FillBatchHelper.getAllInspOrgListByOrg(inspOrgMap);
            }
            return allToOrg;
        }
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType(OrgViewTypeEnum.IS_QC.getViewType());
        param.setOrgId(((Long)reqOrgPkId).longValue());
        param.setDirectViewType("toorg");
        allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        inspOrgMap.put(reqOrgPkId, allToOrg);
        if (CollectionUtils.isEmpty((Collection)allToOrg)) {
            allToOrg = FillBatchHelper.getAllInspOrgListByOrg(inspOrgMap);
        }
        return allToOrg;
    }

    private static List<Long> getAllInspOrgListByOrg(Map<Object, List<Long>> inspOrgMap) {
        List<Long> allToOrg = null;
        if (inspOrgMap.containsKey(0L)) {
            allToOrg = inspOrgMap.get(0L);
        } else {
            allToOrg = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"06", (boolean)true);
            inspOrgMap.put(0L, allToOrg);
        }
        return allToOrg;
    }

    private static boolean checkBizTypeEdit(String defaultBizType, String ... bizTypes) {
        for (String bizType : bizTypes) {
            if (!defaultBizType.equals(bizType)) continue;
            return true;
        }
        return false;
    }

    private static String getNowMaterialField(String entryName) {
        String materialField = "material";
        if ("afterentity".equals(entryName)) {
            materialField = "material1";
        }
        return materialField;
    }

    private static String getNowBaseQtyField(String entryName) {
        String qtyField = "baseqty";
        if ("afterentity".equals(entryName)) {
            qtyField = "baseqty1";
        }
        return qtyField;
    }

    private static String getFocusEntry(IFormView formView) {
        String focusEntry = "";
        IPageCache pageCache = formView.getPageCache();
        String batchBtn = pageCache.get("batchBtn");
        if ("fillbatch".equals(batchBtn)) {
            focusEntry = "billentry";
        } else if ("afterfillbatch".equals(batchBtn)) {
            focusEntry = "afterentity";
        }
        return focusEntry;
    }

    private static DynamicObjectCollection getFocusEntryColl(IFormView formView, String focusEntry) {
        DynamicObjectCollection billEntry = new DynamicObjectCollection();
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        if ("billentry".equals(focusEntry)) {
            billEntry = dataEntity.getDynamicObjectCollection(focusEntry);
        } else if ("afterentity".equals(focusEntry)) {
            EntryGrid entryGrid = (EntryGrid)formView.getControl(focusEntry);
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            billEntry.addAll(Arrays.asList(dataEntitys));
        }
        return billEntry;
    }

    private static boolean checkQualifiedQty(DynamicObject dataEntity, int row) {
        DynamicObject bizType = dataEntity.getDynamicObject("biztype");
        String number = bizType.getString("number");
        boolean salOrInspect = "210".equals(number) || "430".equals(number);
        boolean enableImQmc = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        if (enableImQmc || !salOrInspect) {
            return false;
        }
        DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
        BigDecimal qualifiedQty = ((DynamicObject)billEntry.get(row)).getBigDecimal("qualifiedqty");
        BigDecimal qty = ((DynamicObject)billEntry.get(row)).getBigDecimal("qty");
        return BigDecimal.ZERO.compareTo(qty) != 0 && qualifiedQty.compareTo(qty) <= 0;
    }

    private static boolean checkPriceOrAmount(DynamicObject dataEntity, int row, int focusRow, String priceKey, String actualPriceKey) {
        BigDecimal price;
        DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
        BigDecimal focusActualPrice = ((DynamicObject)billEntry.get(focusRow)).getBigDecimal(actualPriceKey);
        return focusActualPrice.compareTo(price = ((DynamicObject)billEntry.get(row)).getBigDecimal(priceKey)) <= 0;
    }

    private static boolean checkDiscountRate(DynamicObject dataEntity, int row, int focusRow) {
        DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
        DynamicObject rowDyn = (DynamicObject)billEntry.get(row);
        DynamicObject focusRowDyn = (DynamicObject)billEntry.get(focusRow);
        String discountType = rowDyn.getString("discounttype");
        BigDecimal focusDiscountRate = focusRowDyn.getBigDecimal("discountrate");
        String focusDiscountType = focusRowDyn.getString("discounttype");
        if (StringUtils.isEmpty((CharSequence)focusDiscountType) || StringUtils.isEmpty((CharSequence)discountType)) {
            return false;
        }
        if (focusDiscountType.equals(discountType)) {
            BigDecimal price;
            BigDecimal priceAndTax;
            boolean isTax;
            boolean haveIsTax;
            return DiscountTypeEnum.UNITDIS.getValue().equals(discountType) ? (haveIsTax = dataEntity.getDataEntityType().getProperties().containsKey((Object)"istax")) && ((isTax = dataEntity.getBoolean("istax")) ? focusDiscountRate.compareTo(priceAndTax = rowDyn.getBigDecimal("priceandtax")) <= 0 : focusDiscountRate.compareTo(price = rowDyn.getBigDecimal("price")) <= 0) : DiscountTypeEnum.DISRATE.getValue().equals(discountType) || DiscountTypeEnum.DISAMT.getValue().equals(discountType);
        }
        return false;
    }

    private static boolean getPriceAmountEnable(IDataModel model, int row, String selPropName) {
        Boolean haveIsPresent;
        String typeName = model.getDataEntityType().getName();
        if ("im_initbill".equals(typeName) || "im_materialreqoutbill".equals(typeName) || "im_otherinbill".equals(typeName)) {
            Boolean haveIsPresent2 = model.getEntryEntity("billentry").getDynamicObjectType().getProperties().containsKey((Object)"ispresent");
            if (haveIsPresent2.booleanValue()) {
                Boolean isPresent = (Boolean)model.getValue("ispresent", row);
                return isPresent == false;
            }
        } else if ("im_transoutbill".equals(typeName) || "im_transdirbill".equals(typeName) || "im_locationtransfer".equals(typeName)) {
            Boolean haveIsFreeGift = model.getEntryEntity("billentry").getDynamicObjectType().getProperties().containsKey((Object)"isfreegift");
            if (haveIsFreeGift.booleanValue()) {
                Boolean isFreeGift = (Boolean)model.getValue("isfreegift", row);
                return isFreeGift == false;
            }
        } else if (("im_purinbill".equals(typeName) || "im_purreceivebill".equals(typeName) || "im_saloutbill".equals(typeName)) && (haveIsPresent = Boolean.valueOf(model.getEntryEntity("billentry").getDynamicObjectType().getProperties().containsKey((Object)"ispresent"))).booleanValue()) {
            Boolean isPresent = (Boolean)model.getValue("ispresent", row);
            if ("amount".equals(selPropName)) {
                return isPresent == false;
            }
            if (isPresent.booleanValue()) {
                Boolean isTax = (Boolean)model.getValue("istax");
                if ("priceandtax".equals(selPropName)) {
                    return isTax;
                }
                if ("price".equals(selPropName)) {
                    return isTax == false;
                }
            } else if (!"im_purreceivebill".equals(typeName)) {
                Boolean inputAmount = (Boolean)model.getValue("inputamount");
                if ("priceandtax".equals(selPropName) || "price".equals(selPropName)) {
                    return inputAmount == false;
                }
            }
        }
        return true;
    }

    private static boolean checkLocation(DynamicObject dataEntity, DynamicObject rowDyn, DynamicObject focusDyn, String selPropName, Map<Object, Set<Long>> warehouseLocationMap) {
        String warehouseFieldKey = "warehouse";
        switch (selPropName) {
            case "outlocation": {
                warehouseFieldKey = "outwarehouse";
                if (!"im_locationtransfer".equals(dataEntity.getDataEntityType().getName())) break;
                warehouseFieldKey = "warehouse";
                break;
            }
            case "qualifiedlocation": {
                warehouseFieldKey = "qualifiedwarehouse";
                break;
            }
            case "unqualifiedlocation": {
                warehouseFieldKey = "unqualifiedwarehouse";
                break;
            }
            case "inlocation": {
                warehouseFieldKey = "inwarehouse";
                break;
            }
            case "location1": {
                warehouseFieldKey = "warehouse1";
                break;
            }
        }
        DynamicObject warehouse = rowDyn.getDynamicObject(warehouseFieldKey);
        if (warehouse != null && warehouse.getBoolean("isopenlocation")) {
            DynamicObject location = focusDyn.getDynamicObject(selPropName);
            Set<Long> warehouseIds = null;
            if (warehouseLocationMap.containsKey(location.getPkValue())) {
                warehouseIds = warehouseLocationMap.get(location.getPkValue());
            } else {
                warehouseIds = WarehouseHelper.getWarehouseIds((Object)location.getPkValue());
                warehouseLocationMap.put(location.getPkValue(), warehouseIds);
            }
            if (warehouseIds.contains(warehouse.getLong("id"))) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkWareHouseInvIn(DynamicObject dataEntity, AtomicReference<Object> appParameter) {
        if (appParameter.get() == null) {
            DynamicObject invOrg = dataEntity.getDynamicObject("org");
            if (invOrg == null) {
                return false;
            }
            appParameter.set(AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)invOrg.getPkValue()), (String)"fmeterialscope"));
        }
        return CHECK_WAREHOUSE_INV_IN.equals(appParameter.get());
    }

    private static boolean checkWareHouse(DynamicObject dataEntity, DynamicObject rowDyn, DynamicObject focusRowDyn, Set<String> whMatIdConcatSet, String selPropName, AtomicReference<Object> appParameter, String focusEntry, Map<Object, Set<Long>> orgWarehouseMap) {
        String entityName = dataEntity.getDataEntityType().getName();
        DynamicObject wareHouseFocus = focusRowDyn.getDynamicObject(selPropName);
        if ("im_transdirbill".equals(entityName) && "outwarehouse".equals(selPropName) || "im_transapply".equals(entityName) || "im_materialreqbill".equals(entityName)) {
            if (!"im_transapply".equals(entityName) || !"warehouse".equals(selPropName)) {
                return true;
            }
            DynamicObject org = rowDyn.getDynamicObject("outorg");
            if (org == null) {
                return true;
            }
            if (orgWarehouseMap.containsKey(org.getPkValue())) {
                Set<Long> idSet = orgWarehouseMap.get(org.getPkValue());
                return idSet.contains((Long)wareHouseFocus.getPkValue());
            }
            Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId((String)entityName, (Long)((Long)org.getPkValue()), (String)"fwarehouseisolate");
            if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
                HashSet<Long> idSet = new HashSet<Long>(Arrays.asList(allWhs));
                orgWarehouseMap.put(org.getPkValue(), idSet);
                return idSet.contains((Long)wareHouseFocus.getPkValue());
            }
            long currUserId = RequestContext.get().getCurrUserId();
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            orgIdList.add((Long)org.getPkValue());
            List warehouseList = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)currUserId, orgIdList);
            if (CollectionUtils.isEmpty((Collection)warehouseList)) {
                return false;
            }
            HashSet<Long> idSet = new HashSet<Long>(warehouseList.size());
            for (DynamicObject wareHose : warehouseList) {
                Long wareHosePkValue = (Long)wareHose.getPkValue();
                idSet.add(wareHosePkValue);
            }
            orgWarehouseMap.put(org.getPkValue(), idSet);
            return idSet.contains((Long)wareHouseFocus.getPkValue());
        }
        if (!FillBatchHelper.checkWareHouseInvIn(dataEntity, appParameter)) {
            return true;
        }
        String nowMaterialField = FillBatchHelper.getNowMaterialField(focusEntry);
        DynamicObject material = rowDyn.getDynamicObject(nowMaterialField);
        DynamicObject materialFocus = focusRowDyn.getDynamicObject(nowMaterialField);
        if (material == null) {
            return true;
        }
        if (materialFocus != null && material.getPkValue().equals(materialFocus.getPkValue())) {
            return true;
        }
        String whMatId = wareHouseFocus.getPkValue() + String.valueOf(material.getPkValue());
        QFilter qFilter = new QFilter("warehouse", "=", wareHouseFocus.getPkValue());
        DynamicObject whSetupDy = BusinessDataServiceHelper.loadSingleFromCache((String)"im_warehousesetup", (String)"materialentity.materialnumber, materialentity.materialgrpnumber", (QFilter[])qFilter.toArray());
        if (whSetupDy == null) {
            return false;
        }
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> materialGrpIds = new HashSet<Long>(16);
        DynamicObjectCollection materialEntry = whSetupDy.getDynamicObjectCollection("materialentity");
        for (DynamicObject entry : materialEntry) {
            DynamicObject materialGroup;
            DynamicObject materialNum = entry.getDynamicObject("materialnumber");
            if (materialNum != null) {
                Long materialId = materialNum.getLong("id");
                materialIds.add(materialId);
            }
            if ((materialGroup = entry.getDynamicObject("materialgrpnumber")) == null) continue;
            Long grpId = materialGroup.getLong("id");
            materialGrpIds.add(grpId);
        }
        if (materialIds.contains(material.getLong("id"))) {
            whMatIdConcatSet.add(whMatId);
            return true;
        }
        QFilter qFilterMgd = new QFilter("material.id", "=", material.getPkValue());
        qFilterMgd.and(new QFilter("group.id", "in", materialGrpIds));
        boolean existsMgd = QueryServiceHelper.exists((String)"bd_materialgroupdetail", (QFilter[])qFilterMgd.toArray());
        if (existsMgd) {
            whMatIdConcatSet.add(whMatId);
            return true;
        }
        return false;
    }

    private static boolean checkMaterial(IFormView formView, Integer row, Integer focusRow, Set<String> whMatIdConcatSet, String selPropName, AtomicReference<Object> appParameter) {
        boolean isTransBill;
        IDataModel model = formView.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String entityTypeName = dataEntity.getDataEntityType().getName();
        boolean bl = isTransBill = "im_adjustbill".equals(entityTypeName) || "im_assembbill".equals(entityTypeName) || "im_disassemblebill".equals(entityTypeName);
        if (!isTransBill && !"im_initbill".equals(entityTypeName)) {
            DynamicObject lineType = (DynamicObject)model.getValue("linetype", row.intValue());
            DynamicObject lineTypeFocus = (DynamicObject)model.getValue("linetype", focusRow.intValue());
            if (lineType == null || !lineType.getPkValue().equals(lineTypeFocus.getPkValue())) {
                return false;
            }
        }
        if ("im_transapply".equals(entityTypeName) || "im_materialreqbill".equals(entityTypeName)) {
            return true;
        }
        if (!FillBatchHelper.checkWareHouseInvIn(dataEntity, appParameter)) {
            return true;
        }
        String wareHouseField = "warehouse";
        if ("material1".equals(selPropName)) {
            wareHouseField = "warehouse1";
        }
        DynamicObject wareHouse = (DynamicObject)model.getValue(wareHouseField, row.intValue());
        DynamicObject wareHouseFocus = (DynamicObject)model.getValue(wareHouseField, focusRow.intValue());
        if (wareHouse == null || wareHouseFocus != null && wareHouse.getPkValue().equals(wareHouseFocus.getPkValue())) {
            return true;
        }
        DynamicObject materialInvFocus = (DynamicObject)formView.getModel().getValue(selPropName, focusRow.intValue());
        String whMatId = wareHouse.getPkValue() + String.valueOf(materialInvFocus.getPkValue());
        if (whMatIdConcatSet.contains(whMatId)) {
            return true;
        }
        QFilter qFilter = new QFilter("warehouse", "=", wareHouse.getPkValue());
        DynamicObject whSetupDy = BusinessDataServiceHelper.loadSingleFromCache((String)"im_warehousesetup", (String)"materialentity.materialnumber, materialentity.materialgrpnumber", (QFilter[])qFilter.toArray());
        if (whSetupDy == null) {
            return false;
        }
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> materialGrpIds = new HashSet<Long>(16);
        DynamicObjectCollection materialEntry = whSetupDy.getDynamicObjectCollection("materialentity");
        for (DynamicObject entry : materialEntry) {
            DynamicObject materialGroup;
            DynamicObject materialNum = entry.getDynamicObject("materialnumber");
            if (materialNum != null) {
                Long materialId = materialNum.getLong("id");
                materialIds.add(materialId);
            }
            if ((materialGroup = entry.getDynamicObject("materialgrpnumber")) == null) continue;
            Long grpId = materialGroup.getLong("id");
            materialGrpIds.add(grpId);
        }
        Long materialId = materialInvFocus.getDynamicObject("masterid").getLong("id");
        if (materialIds.contains(materialId)) {
            whMatIdConcatSet.add(whMatId);
            return true;
        }
        if (!materialGrpIds.isEmpty()) {
            QFilter qFilterMgd = new QFilter("material.id", "=", (Object)materialId);
            qFilterMgd.and(new QFilter("group.id", "in", materialGrpIds));
            boolean existsMgd = QueryServiceHelper.exists((String)"bd_materialgroupdetail", (QFilter[])qFilterMgd.toArray());
            if (existsMgd) {
                whMatIdConcatSet.add(whMatId);
                return true;
            }
        }
        return false;
    }

    private static boolean getMaterialInvEnable(DynamicObject invMaterial, String value) {
        if (invMaterial == null) {
            return false;
        }
        return invMaterial.getBoolean(value);
    }

    public static void checkCancelBeforeBatchFill(IFormView view, BeforeItemClickEvent evt) {
        String entityName = view.getModel().getDataEntity().getDataEntityType().getName();
        boolean fillEntry = FillBatchHelper.checkBatchFillEntry(view);
        if (!fillEntry) {
            evt.setCancel(true);
            return;
        }
        String focusEntry = FillBatchHelper.getFocusEntry(view);
        if (StringUtils.isEmpty((CharSequence)focusEntry)) {
            evt.setCancel(true);
            return;
        }
        FillBatchHelper.batchFill(view, focusEntry, needFillFields);
        Set<String> extField = FillBatchHelper.getPluginExtFieldList(entityName);
        EntryGrid entryGrid = (EntryGrid)view.getControl(focusEntry);
        String selKey = entryGrid.getEntryState().getFocusField();
        if (extField.contains(selKey)) {
            evt.setCancel(true);
        }
    }

    public static boolean checkBatchFillEntry(IFormView formView) {
        String focusEntry = FillBatchHelper.getFocusEntry(formView);
        if (StringUtils.isEmpty((CharSequence)focusEntry)) {
            return false;
        }
        EntryGrid entryGrid = (EntryGrid)formView.getControl(focusEntry);
        String selKey = entryGrid.getEntryState().getFocusField();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow == -1 || StringUtils.isEmpty((CharSequence)selKey) || "0".equals(selKey)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectOneEntryToHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return false;
        }
        IDataModel model = formView.getModel();
        DynamicObject focusDyn = ((BillModel)model).getEntryCurrentRow(focusEntry);
        if (focusDyn == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SelectOneEntryToHandleSerialNumber", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean existKey = focusDyn.containsProperty(selKey);
        if (!existKey) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5b57\u6bb5\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"FillBatchHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
            return false;
        }
        if (notBatchFillFieldSet.contains(selKey)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5b57\u6bb5\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"FillBatchHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
            return false;
        }
        Object value = model.getValue(selKey, focusRow);
        boolean isFill = FillBatchHelper.checkCellHaveValue(value);
        if (!isFill) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u503c\u586b\u5145\u3002", (String)"FillBatchHelper_1", (String)"scmc-im-business", (Object[])new Object[0]));
            return false;
        }
        String entityTypeName = model.getDataEntityType().getName();
        if ("im_saloutbill".equals(entityTypeName) || "im_purinbill".equals(entityTypeName) || "im_initbill".equals(entityTypeName) || "im_purreceivebill".equals(entityTypeName)) {
            Boolean isPresent;
            boolean fillAmountAndTax;
            Boolean isTax = Boolean.TRUE;
            Boolean inputAmount = Boolean.TRUE;
            if (!"im_purreceivebill".equals(entityTypeName)) {
                inputAmount = (Boolean)model.getValue("inputamount");
            }
            if (!"im_initbill".equals(entityTypeName)) {
                isTax = (Boolean)model.getValue("istax");
            }
            boolean bothFalse = isTax == false && inputAmount == false;
            boolean bothTrue = isTax != false && inputAmount != false;
            boolean taxTrue = isTax != false && inputAmount == false;
            boolean amountTrue = isTax == false && inputAmount != false;
            boolean fillPrice = "price".equals(selKey) && !bothFalse;
            boolean fillPriceAndTax = "priceandtax".equals(selKey) && !taxTrue;
            boolean fillActualPrice = "actualprice".equals(selKey) && isTax != false;
            boolean fillActualTaxPrice = "actualtaxprice".equals(selKey) && isTax == false;
            boolean fillAmount = "amount".equals(selKey) && !amountTrue;
            boolean fillTaxAmount = "taxamount".equals(selKey) && isTax == false;
            boolean bl = fillAmountAndTax = "amountandtax".equals(selKey) && !bothTrue;
            if ("im_purreceivebill".equals(entityTypeName)) {
                fillPrice = "price".equals(selKey) && isTax != false;
                fillActualPrice = "actualprice".equals(selKey) && isTax != false;
                fillAmount = "amount".equals(selKey) && isTax != false;
                fillPriceAndTax = "priceandtax".equals(selKey) && isTax == false;
                fillActualTaxPrice = "actualtaxprice".equals(selKey) && isTax == false;
                fillTaxAmount = "taxamount".equals(selKey) && isTax == false;
                boolean bl2 = fillAmountAndTax = "amountandtax".equals(selKey) && isTax == false;
            }
            if ("im_initbill".equals(entityTypeName)) {
                fillPrice = "price".equals(selKey) && inputAmount != false;
                boolean bl3 = fillAmount = "amount".equals(selKey) && inputAmount == false;
            }
            if (("im_saloutbill".equals(entityTypeName) || "im_purinbill".equals(entityTypeName) || "im_purreceivebill".equals(entityTypeName)) && (isPresent = (Boolean)model.getValue("ispresent", focusRow)).booleanValue()) {
                if ("price".equals(selKey)) {
                    fillPrice = isTax;
                } else if ("priceandtax".equals(selKey)) {
                    boolean bl4 = fillPriceAndTax = isTax == false;
                }
            }
            if (fillPrice || fillPriceAndTax || fillActualPrice || fillActualTaxPrice || fillAmount || fillTaxAmount || fillAmountAndTax) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5b57\u6bb5\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"FillBatchHelper_3", (String)"scmc-im-business", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private static boolean checkCellHaveValue(Object value) {
        boolean isEmpty;
        boolean isFalse = value instanceof Boolean && (Boolean)value == false;
        boolean bl = isEmpty = StringUtils.isBlank((Object)value) || value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0 || value instanceof Integer && "0".equals(String.valueOf(value)) || value instanceof ILocaleString && StringUtils.isBlank((CharSequence)value.toString());
        return !isFalse && !isEmpty;
    }

    private static void changeProduceDate(IFormView formView, Date date, int rowIndex, Map<Integer, String> msgMap, List<Map<String, Object>> alertMsgList, String produceDateField, String expiryDateField) {
        String calculationForEndDate;
        int shelflife;
        if (date == null) {
            return;
        }
        IDataModel model = formView.getModel();
        Date produceDate = (Date)model.getValue(produceDateField, rowIndex);
        if (produceDate != null) {
            return;
        }
        String materialField = "producedate1".equals(produceDateField) ? "material1" : "material";
        DynamicObject materialInvInfo = (DynamicObject)model.getValue(materialField, rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        Date oldExpiryDate = (Date)model.getValue(expiryDateField, rowIndex);
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)true)) {
            String msg = FillBatchHelper.checkShelflifeDate(formView, date, oldExpiryDate, rowIndex, produceDateField, materialInvInfo);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                msgMap.put(rowIndex, msg);
            } else {
                DataChangeHelper.setValue((IDataModel)formView.getModel(), (String)produceDateField, (Object)date, (int)rowIndex, (boolean)false);
            }
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife = materialInvInfo.getInt("shelflife")), (Date)date, (String)(calculationForEndDate = materialInvInfo.getString("calculationforenddate")));
        if (expirydate.before(date)) {
            String newExpirydateStr = FillBatchHelper.getDateStr(expirydate);
            String newProduceDateStr = FillBatchHelper.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            msgMap.put(rowIndex, msg);
            DataChangeHelper.setValue((IDataModel)model, (String)produceDateField, null, (int)rowIndex, (boolean)false);
            return;
        }
        String msg = FillBatchHelper.showExpiryDateConfirm(formView, rowIndex, materialInvInfo, expiryDateField, expirydate, produceDateField, date);
        FillBatchHelper.expiryDatePutMsgToCollection(msg, msgMap, alertMsgList, rowIndex, expirydate, oldExpiryDate, date, null, produceDateField);
    }

    private static void changeExpiryDate(IFormView view, Date newExpiryDate, int rowIndex, Map<Integer, String> msgMap, List<Map<String, Object>> alertMsgList, String produceDateField, String expiryDateField) {
        if (newExpiryDate == null) {
            return;
        }
        IDataModel model = view.getModel();
        Date oldExpiryDate = (Date)model.getValue(expiryDateField, rowIndex);
        if (oldExpiryDate != null) {
            return;
        }
        Date oldProduceDate = (Date)model.getValue(produceDateField, rowIndex);
        String materialField = "producedate1".equals(produceDateField) ? "material1" : "material";
        DynamicObject materialInvInfo = (DynamicObject)model.getValue(materialField, rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)false)) {
            if (oldProduceDate == null) {
                boolean isTransFormBill;
                String entityName = model.getDataEntity().getDataEntityType().getName();
                boolean bl = isTransFormBill = "im_adjustbill".equals(entityName) || "im_assembbill".equals(entityName) || "im_disassemblebill".equals(entityName);
                if (!isTransFormBill) {
                    String msg = FillBatchHelper.showExpiryDateConfirm(view, rowIndex, materialInvInfo, expiryDateField, newExpiryDate, produceDateField, oldProduceDate);
                    FillBatchHelper.expiryDatePutMsgToCollection(msg, msgMap, alertMsgList, rowIndex, newExpiryDate, null, null, null, produceDateField);
                } else {
                    DataChangeHelper.setValue((IDataModel)model, (String)expiryDateField, (Object)newExpiryDate, (int)rowIndex, (boolean)false);
                }
            } else {
                String msg = FillBatchHelper.checkShelflifeDate(view, oldProduceDate, newExpiryDate, rowIndex, expiryDateField, materialInvInfo);
                if (StringUtils.isEmpty((CharSequence)msg)) {
                    msg = FillBatchHelper.showExpiryDateConfirm(view, rowIndex, materialInvInfo, expiryDateField, newExpiryDate, produceDateField, oldProduceDate);
                    FillBatchHelper.expiryDatePutMsgToCollection(msg, msgMap, alertMsgList, rowIndex, newExpiryDate, null, oldProduceDate, oldProduceDate, produceDateField);
                }
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    msgMap.put(rowIndex, msg);
                } else {
                    DataChangeHelper.setValue((IDataModel)model, (String)expiryDateField, (Object)newExpiryDate, (int)rowIndex, (boolean)false);
                }
            }
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date produceDate = oldProduceDate;
        if (!CHECK_WAREHOUSE_INV_IN.equals(calculationForEndDate)) {
            produceDate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)newExpiryDate, (String)calculationForEndDate);
        } else if (produceDate != null && newExpiryDate.before(produceDate)) {
            String newExpiryDateStr = FillBatchHelper.getDateStr(newExpiryDate);
            String newProduceDateStr = FillBatchHelper.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImBillPropChanged_99", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpiryDateStr, newProduceDateStr);
            msgMap.put(rowIndex, msg);
            DataChangeHelper.setValue((IDataModel)model, (String)expiryDateField, null, (int)rowIndex, (boolean)false);
            return;
        }
        String msg = FillBatchHelper.showExpiryDateConfirm(view, rowIndex, materialInvInfo, expiryDateField, newExpiryDate, produceDateField, produceDate);
        FillBatchHelper.expiryDatePutMsgToCollection(msg, msgMap, alertMsgList, rowIndex, newExpiryDate, null, produceDate, oldProduceDate, produceDateField);
    }

    private static void expiryDatePutMsgToCollection(String msg, Map<Integer, String> msgMap, List<Map<String, Object>> alertMsgList, int rowIndex, Date newExpiryDate, Date oldExpiryDate, Date newProduceDate, Date oldProduceDate, String produceDateField) {
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String newExpirydateStr = FillBatchHelper.getDateStr(newExpiryDate);
            String oldExpirydateStr = FillBatchHelper.getDateStr(oldExpiryDate);
            String newProducedateStr = FillBatchHelper.getDateStr(newProduceDate);
            String oldProducedateStr = FillBatchHelper.getDateStr(oldProduceDate);
            params.put("newProduceDate", newProducedateStr);
            params.put("oldProduceDate", oldProducedateStr);
            params.put("newExpirydate", newExpirydateStr);
            params.put("newExpiryDate", newExpirydateStr);
            params.put("oldExpirydate", oldExpirydateStr);
            params.put("index", rowIndex);
            params.put("isAfter", "producedate1".equals(produceDateField));
            alertMsgList.add(params);
            msgMap.put(rowIndex, msg);
        }
    }

    private static String checkShelflifeDate(IFormView formView, Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = FillBatchHelper.getDateStr(expirydate);
            String newProduceDateStr = FillBatchHelper.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            DataChangeHelper.setValue((IDataModel)formView.getModel(), (String)key, null, (int)rowIndex, (boolean)false);
            return msg;
        }
        return "";
    }

    private static String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    private static String showExpiryDateConfirm(IFormView formView, int rowIndex, DynamicObject materialInvInfo, String expiryDateField, Date newExpiryDate, String produceDateField, Date newProducedate) {
        String billName = formView.getModel().getDataEntityType().getName();
        String entryName = FillBatchHelper.getFocusEntry(formView);
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return "";
        }
        boolean isOutBill = InvBillHelper.isOutEntry((String)billName, (String)entryName);
        boolean isInBill = InvBillHelper.isInEntry((String)billName, (String)entryName);
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        int dateOfOverdue = 0;
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        boolean dateOver = false;
        if (!"im_materialreqbill".equals(billName) && !"im_transapply".equals(billName)) {
            Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
            Date nowDate = new Date();
            dateOver = nowDate.after(overdueDate);
        }
        if (dateOver) {
            String newExpirydateStr = FillBatchHelper.getDateStr(newExpiryDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImBillPropChanged_7", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr);
            return msg;
        }
        DataChangeHelper.setValue((IDataModel)formView.getModel(), (String)produceDateField, (Object)newProducedate, (int)rowIndex, (boolean)false);
        DataChangeHelper.setValue((IDataModel)formView.getModel(), (String)expiryDateField, (Object)newExpiryDate, (int)rowIndex, (boolean)false);
        return "";
    }

    public static void afterBatchFillEntry(IFormView view, IFormPlugin plugin) {
        String focusEntryField = FillBatchHelper.getFocusEntry(view);
        if (StringUtils.isEmpty((CharSequence)focusEntryField)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl(focusEntryField);
        String selKey = entryGrid.getEntryState().getFocusField();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        DynamicObjectCollection focusEntry = view.getModel().getEntryEntity(focusEntryField);
        int endIndex = focusEntry.size();
        switch (selKey) {
            case "producedate": 
            case "expirydate": 
            case "producedate1": 
            case "expirydate1": {
                FillBatchHelper.afterBatchFillEntryProduceDate(view, plugin, selKey, focusEntryField, focusRow, endIndex);
                break;
            }
            case "lotnumber": 
            case "inlotnumber": 
            case "lotnumber1": {
                FillBatchHelper.afterBillFillEntryLotNumber(view, plugin, selKey, focusEntryField, focusRow, endIndex);
                break;
            }
            case "actualprice": 
            case "actualtaxprice": 
            case "discountamount": 
            case "discountrate": 
            case "taxamount": {
                FillBatchHelper.afterBatchFillEntryPriceAndAmount(view, selKey, focusRow, endIndex);
                break;
            }
            case "qty": 
            case "auditqty": 
            case "qtyunit2nd": 
            case "qualifiedqty": 
            case "qtyunit2nd1": 
            case "qty1": 
            case "yreceiveqty": 
            case "yreceiveqtyunit2nd": 
            case "ysendqty": 
            case "ysendqtyunit2nd": {
                String msg = FillBatchHelper.afterBatchFillEntryQty(view, focusRow, endIndex, selKey);
                if (!StringUtils.isNotEmpty((CharSequence)msg)) break;
                view.showConfirm(null, msg, MessageBoxOptions.OK, ConfirmTypes.Default, null);
                break;
            }
        }
    }

    private static void afterBillFillEntryLotNumber(IFormView view, IFormPlugin plugin, String selKey, String focusEntryField, int focusRow, int endIndex) {
        int i;
        DynamicObjectCollection focusEntry = FillBatchHelper.getFocusEntryColl(view, focusEntryField);
        if (focusEntry.isEmpty()) {
            return;
        }
        DynamicObject focusDyn = (DynamicObject)focusEntry.get(focusRow);
        String lotNumber = focusDyn.getString(selKey);
        boolean isTransEntity = selKey.contains("1");
        IDataModel model = view.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject dataEntity = model.getDataEntity();
        String bizTypeNum = FillBatchHelper.getBizTypeNum(dataEntity);
        String nowMaterialField = FillBatchHelper.getNowMaterialField(focusEntryField);
        String produceDateField = isTransEntity ? "producedate1" : "producedate";
        String expiryDateField = isTransEntity ? "expirydate1" : "expirydate";
        LinkedHashMap<Integer, String> msgMap = new LinkedHashMap<Integer, String>(16);
        HashSet<Object> materialIdSet = new HashSet<Object>(16);
        for (int i2 = focusRow + 1; i2 < endIndex; ++i2) {
            DynamicObject rowDyn = (DynamicObject)focusEntry.get(i2);
            DynamicObject materialInvInfo = rowDyn.getDynamicObject(nowMaterialField);
            if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) continue;
            materialIdSet.add(materialInvInfo.getPkValue());
        }
        ArrayList<Map<String, Object>> alertMsgList = new ArrayList<Map<String, Object>>();
        ArrayList<Object> orgIds = new ArrayList<Object>(1);
        ArrayList<String> lotNumbers = new ArrayList<String>(1);
        orgIds.add(org.getPkValue());
        lotNumbers.add(lotNumber);
        Map lotIntrackMap = ImLotHelper.getLotIntrackMap(orgIds, materialIdSet, lotNumbers);
        String entityName = model.getDataEntity().getDataEntityType().getName();
        ArrayList<Integer> fillNumList = new ArrayList<Integer>();
        model.beginInit();
        for (i = focusRow + 1; i < endIndex; ++i) {
            String key;
            DynamicObject lotinTrack;
            DynamicObject materialInvInfo;
            DynamicObject rowDyn = (DynamicObject)focusEntry.get(i);
            String nowLotNumber = rowDyn.getString(selKey);
            if (StringUtils.isNotEmpty((CharSequence)nowLotNumber) || (materialInvInfo = rowDyn.getDynamicObject(nowMaterialField)) == null) continue;
            if ("lotnumber".equals(selKey) || "inlotnumber".equals(selKey)) {
                if (!FillBatchHelper.getMaterialInvEnable(rowDyn.getDynamicObject("material"), "enablelot")) continue;
                DataChangeHelper.setValue((IDataModel)model, (String)selKey, (Object)lotNumber, (int)i, (boolean)false);
                fillNumList.add(i);
            } else if ("lotnumber1".equals(selKey)) {
                if (!FillBatchHelper.checkAfterLotNumber(rowDyn, bizTypeNum, entityName)) continue;
                DataChangeHelper.setValue((IDataModel)model, (String)selKey, (Object)lotNumber, (int)i, (boolean)false);
                fillNumList.add(i);
            }
            if (!materialInvInfo.getBoolean("enableshelflifemgr") || (lotinTrack = (DynamicObject)lotIntrackMap.get(key = org.getPkValue() + "_" + materialInvInfo.getPkValue() + "_" + lotNumber)) == null) continue;
            Date produceDate = lotinTrack.getDate("producedate");
            Date expiryDate = lotinTrack.getDate("expirydate");
            Date oldExpiryDate = rowDyn.getDate(expiryDateField);
            if (expiryDate == null) {
                DataChangeHelper.setValue((IDataModel)model, (String)produceDateField, (Object)produceDate, (int)i, (boolean)false);
                DataChangeHelper.setValue((IDataModel)model, (String)expiryDateField, (Object)expiryDate, (int)i, (boolean)false);
                continue;
            }
            if (oldExpiryDate != null && expiryDate.compareTo(oldExpiryDate) == 0) continue;
            String msg = FillBatchHelper.showExpiryDateConfirm(view, i, materialInvInfo, expiryDateField, expiryDate, produceDateField, produceDate);
            FillBatchHelper.expiryDatePutMsgToCollection(msg, msgMap, alertMsgList, i, expiryDate, oldExpiryDate, produceDate, null, produceDateField);
        }
        model.endInit();
        if (!msgMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String msg : msgMap.values()) {
                if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
                sb.append(msg).append("\r\n");
            }
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", plugin);
            view.showConfirm(null, sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
        for (i = 0; i < fillNumList.size(); ++i) {
            Integer num = (Integer)fillNumList.get(i);
            if ("im_transdirbill".equals(entityName)) {
                DataChangeHelper.setValue((IDataModel)model, (String)"inlotnumber", (Object)lotNumber, (int)num, (boolean)true);
                BillViewHelper.updateViewField((IFormView)view, (int)num, (String)"inlotnumber", (String[])new String[0]);
            }
            BillViewHelper.updateViewField((IFormView)view, (int)num, (String)focusEntryField, (String[])new String[]{produceDateField, expiryDateField, selKey});
        }
    }

    private static String afterBatchFillEntryQty(IFormView view, int focusRow, int endIndex, String nowQtyField) {
        String focusEntryField = FillBatchHelper.getFocusEntry(view);
        if (StringUtils.isEmpty((CharSequence)focusEntryField)) {
            return "";
        }
        String nowMaterialField = FillBatchHelper.getNowMaterialField(focusEntryField);
        String qtyBaseField = FillBatchHelper.getNowBaseQtyField(focusEntryField);
        String nowUnitField = ((QtyProp)view.getModel().getProperty(nowQtyField)).getRelatedUnit();
        String nowBaseUnitField = ((QtyProp)view.getModel().getProperty(qtyBaseField)).getRelatedUnit();
        DynamicObjectCollection focusEntry = FillBatchHelper.getFocusEntryColl(view, focusEntryField);
        StringBuilder sb = new StringBuilder();
        if (focusEntry.isEmpty()) {
            return sb.toString();
        }
        DynamicObject focusDyn = (DynamicObject)focusEntry.get(focusRow);
        for (int i = focusRow + 1; i < endIndex; ++i) {
            boolean isQualifiedQtyFill;
            boolean isQtyUnit2ndFill;
            boolean isAuditQtyFill;
            boolean isQtyFill;
            DynamicObject rowDyn = (DynamicObject)focusEntry.get(i);
            BigDecimal qty = rowDyn.getBigDecimal(nowQtyField);
            DynamicObject matInv = rowDyn.getDynamicObject(nowMaterialField);
            boolean bl = isQtyFill = rowDyn.getDynamicObject(nowMaterialField) == null || rowDyn.getDynamicObject(nowUnitField) == null || BigDecimal.ZERO.compareTo(qty) != 0;
            if (isQtyFill) continue;
            boolean bl2 = isAuditQtyFill = "auditqty".equals(nowQtyField) && !FillBatchHelper.checkAuditQty(rowDyn, focusDyn);
            if (isAuditQtyFill) continue;
            boolean bl3 = isQtyUnit2ndFill = ("qtyunit2nd".equals(nowQtyField) || "qtyunit2nd1".equals(nowQtyField)) && !FillBatchHelper.checkQtyUnit2nd(focusEntryField, rowDyn);
            if (isQtyUnit2ndFill) continue;
            boolean bl4 = isQualifiedQtyFill = "qualifiedqty".equals(nowQtyField) && !FillBatchHelper.checkQualifiedQty(view.getModel().getDataEntity(), i);
            if (isQualifiedQtyFill) continue;
            BigDecimal focusQty = focusDyn.getBigDecimal(nowQtyField);
            qty = FillBatchHelper.dealQtyPrecision(rowDyn.getDynamicObject(nowUnitField), rowDyn.getDynamicObject(nowBaseUnitField), matInv.getDynamicObject("masterid").getLong("id"), focusQty);
            try {
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)nowQtyField, (Object)qty, (int)i, (boolean)true);
                continue;
            }
            catch (KDBizException e) {
                DataChangeHelper.setValue((IDataModel)view.getModel(), (String)nowQtyField, (Object)BigDecimal.ZERO, (int)i, (boolean)true);
                String msg = e.getErrorCode().getMessage();
                if (!msg.contains("9999999999999")) continue;
                String rowMsg = ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"ImBillEditPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[]{i + 1});
                sb.append(rowMsg).append(msg).append("\r\n");
            }
        }
        if ("qualifiedqty".equals(nowQtyField) || "auditqty".equals(nowQtyField)) {
            FillBatchHelper.afterBatchFillEntryQtyConfirm(view, nowQtyField, focusRow, endIndex);
        }
        return sb.toString();
    }

    private static BigDecimal dealQtyPrecision(DynamicObject targetUnit, DynamicObject srcUnit, Long materialId, BigDecimal qty) {
        int precision = targetUnit.getInt("precision");
        if (FmtInfoUtils.applyMaterialPrecision()) {
            QFilter materialFilter = new QFilter("materialid", "=", (Object)materialId);
            materialFilter.and("measureunitid", "=", (Object)targetUnit.getLong("id"));
            DynamicObject measureUnit = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_multimeasureunit", (String)"precision", (QFilter[])materialFilter.toArray());
            if (null != measureUnit) {
                precision = measureUnit.getInt("precision");
            }
        }
        return qty.setScale(precision, PrecisionAccountEnum.getEnumByVal((int)targetUnit.getInt("precisionaccount")));
    }

    private static void afterBatchFillEntryProduceDate(IFormView view, IFormPlugin plugin, String selKey, String focusEntry, int focusRow, int endIndex) {
        int i;
        boolean isTransEntity = selKey.contains("1");
        String produceDateField = isTransEntity ? "producedate1" : "producedate";
        String expiryDateField = isTransEntity ? "expirydate1" : "expirydate";
        Date newProduceDate = (Date)view.getModel().getValue(produceDateField, focusRow);
        Date newExpiryDate = (Date)view.getModel().getValue(expiryDateField, focusRow);
        ArrayList<Map<String, Object>> alertMsgList = new ArrayList<Map<String, Object>>();
        LinkedHashMap<Integer, String> msgMap = new LinkedHashMap<Integer, String>(16);
        view.getModel().beginInit();
        for (i = focusRow + 1; i < endIndex; ++i) {
            if ("producedate1".contains(selKey)) {
                FillBatchHelper.changeProduceDate(view, newProduceDate, i, msgMap, alertMsgList, produceDateField, expiryDateField);
            }
            if (!"expirydate1".contains(selKey)) continue;
            FillBatchHelper.changeExpiryDate(view, newExpiryDate, i, msgMap, alertMsgList, produceDateField, expiryDateField);
        }
        view.getModel().endInit();
        if (!msgMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String msg : msgMap.values()) {
                if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
                sb.append(msg).append("\r\n");
            }
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", plugin);
            view.showConfirm(null, sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        }
        for (i = focusRow + 1; i < endIndex; ++i) {
            BillViewHelper.updateViewField((IFormView)view, (int)i, (String)focusEntry, (String[])new String[]{produceDateField, expiryDateField});
        }
    }

    private static void afterBatchFillEntryPriceAndAmount(IFormView view, String selKey, int focusRow, int endIndex) {
        StringBuilder sb = new StringBuilder();
        IDataModel model = view.getModel();
        for (int i = focusRow + 1; i < endIndex; ++i) {
            Boolean isPresent;
            BigDecimal selKeyPrice = (BigDecimal)model.getValue(selKey, i);
            if ("discountamount".equals(selKey) || "discountrate".equals(selKey)) {
                String focusDiscountType = (String)model.getValue("discounttype", focusRow);
                String discountType = (String)model.getValue("discounttype", i);
                if (StringUtils.isEmpty((CharSequence)focusDiscountType) || StringUtils.isEmpty((CharSequence)discountType) || !discountType.equals(focusDiscountType)) continue;
            }
            if (selKeyPrice != null && BigDecimal.ZERO.compareTo(selKeyPrice) != 0 || ("taxamount".equals(selKey) || "actualtaxprice".equals(selKey) || "actualprice".equals(selKey)) && (isPresent = (Boolean)model.getValue("ispresent", i)).booleanValue()) continue;
            sb.append(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"ImBillEditPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[]{i + 1}));
            if ("actualprice".equals(selKey)) {
                sb.append(ResManager.loadKDString((String)"\u5b9e\u9645\u5355\u4ef7\u4e0d\u5f97\u9ad8\u4e8e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_9", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else if ("actualtaxprice".equals(selKey)) {
                sb.append(ResManager.loadKDString((String)"\u5b9e\u9645\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else if ("discountamount".equals(selKey)) {
                sb.append(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_UNITDISAMOUNT()));
            } else if ("taxamount".equals(selKey)) {
                sb.append(ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u4e14\u4e0d\u80fd\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PurInBillEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else if ("discountrate".equals(selKey)) {
                boolean isTax;
                boolean haveIsTax = model.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"istax");
                String rateMsgErr = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                if (haveIsTax && (isTax = ((Boolean)model.getValue("istax")).booleanValue())) {
                    rateMsgErr = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurInBillEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                }
                sb.append(rateMsgErr);
            }
            sb.append("\r\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)sb)) {
            view.showConfirm(null, sb.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
        }
    }

    private static void afterBatchFillEntryQtyConfirm(IFormView view, String selKey, int focusRow, int endIndex) {
        StringBuilder qtySb = new StringBuilder();
        IDataModel model = view.getModel();
        for (int i = focusRow + 1; i < endIndex; ++i) {
            BigDecimal qualifiedQty = (BigDecimal)model.getValue(selKey, i);
            if (qualifiedQty != null && BigDecimal.ZERO.compareTo(qualifiedQty) != 0) continue;
            String msg = "";
            if ("auditqty".equals(selKey)) {
                msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u6838\u51c6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u6570\u91cf\u3002", (String)"FillBatchHelper_5", (String)"scmc-im-business", (Object[])new Object[]{i + 1});
            } else if ("qualifiedqty".equals(selKey)) {
                msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u5408\u683c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"InvInspectBillEditPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[]{i + 1});
            }
            qtySb.append(msg);
            qtySb.append("\r\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)qtySb)) {
            view.showConfirm(null, qtySb.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
        }
    }
}

