/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.algorithm.SimpleAlgorithmForBotp;
import kd.scmc.im.business.algorithm.TaxAlgorithmForBotp;
import kd.scmc.im.business.helper.BillTypeHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.InvBillCalcHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.InvSchemeServiceFactory;
import kd.scmc.im.consts.InvSchemeConst;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class ImBillBotpHelp {
    private static final String QUOTETYPE = "quoteType";
    private static final String EXCHANGERATE = "exchangeRate";
    private static final String SCHEME_ENABLE = "110";

    public static List<DynamicObject> afterConcerts(String tgtMainType, List<DynamicObject> bills) {
        if (bills == null || bills.isEmpty()) {
            return bills;
        }
        ArrayList<DynamicObject> convertBills = new ArrayList<DynamicObject>(bills.size());
        for (DynamicObject bill : bills) {
            DynamicObject afterConvertBill = ImBillBotpHelp.afterConvert(tgtMainType, bill);
            convertBills.add(afterConvertBill);
        }
        return convertBills;
    }

    public static DynamicObject afterConvert(String tgtMainType, DynamicObject bill) {
        if (bill == null) {
            return bill;
        }
        DynamicObjectCollection entrycols = bill.getDynamicObjectCollection("billentry");
        int size = entrycols.size();
        if (size > 0) {
            ImBillBotpHelp.setDefultVaule(tgtMainType, bill);
            ImBillBotpHelp.reCalFields(bill, tgtMainType);
            DynamicObject invScheme = bill.getDynamicObject("invscheme");
            ImBillBotpHelp.dealEntryScheme(bill, entrycols, invScheme);
            HashMap cacheMap = new HashMap(size);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                DynamicObject entry = (DynamicObject)entrycols.get(rowIndex);
                ImBillBotpHelp.setEntryAuxptyUnit(entry);
                InvBillCalcHelper.entryAuxptyQtyCalc((DynamicObject)entry, (String)tgtMainType, cacheMap);
            }
        }
        return bill;
    }

    public static void setDefultVaule(String tgtMainType, DynamicObject obj) {
        DynamicObject invScheme;
        String bizTypeName;
        DynamicObject bizType;
        Long billTypeId;
        Long l = billTypeId = (DynamicObject)obj.get("billtype") == null ? null : Long.valueOf(((DynamicObject)obj.get("billtype")).getLong("id"));
        if (billTypeId == null) {
            Map desBillType = BillTypeHelper.getBillTypesByEntity((String)tgtMainType);
            billTypeId = ((DynamicObject)desBillType.entrySet().iterator().next().getValue()).getLong("id");
            obj.set("billtype", (Object)billTypeId);
        }
        Long bizTypeId = (bizType = (DynamicObject)obj.get("biztype")) == null ? null : Long.valueOf(bizType.getLong("id"));
        String string = bizTypeName = bizType == null ? null : bizType.getString("name");
        if (bizType == null) {
            bizType = BizTypeHelper.getBizTypeByBillType((String)tgtMainType, (DynamicObject)obj.getDynamicObject("billtype"));
            if (bizType != null) {
                bizTypeId = bizType.getLong("id");
                bizTypeName = bizType.getString("name");
                obj.set("biztype", (Object)bizType);
            }
            if (bizTypeId == null) {
                throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getEMPTY_BIZTYPE()));
            }
        }
        if ((invScheme = obj.getDynamicObject("invscheme")) == null) {
            invScheme = InvSchemeHelper.getInvSchemeByEntityAndBizType((String)tgtMainType, (Long)bizTypeId);
            if (invScheme == null) {
                throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_INVSCHEME(), (Object[])new Object[]{tgtMainType, bizTypeName}));
            }
            obj.set("invscheme", (Object)invScheme);
        }
        if ("im_purinbill".equals(tgtMainType) || "im_purreceivebill".equals(tgtMainType) || "im_saloutbill".equals(tgtMainType)) {
            ImBillBotpHelp.handleExRateAndQuotation(obj);
        }
    }

    private static void handleExRateAndQuotation(DynamicObject obj) {
        boolean exRateNotNull;
        DynamicObject currency = obj.getDynamicObject("currency");
        DynamicObject settleCurrency = obj.getDynamicObject("settlecurrency");
        Date exrateDate = obj.getDate("exratedate");
        DynamicObject exrateTable = obj.getDynamicObject("exratetable");
        Object quotation = obj.get("quotation");
        Object exRate = obj.get("exchangerate");
        boolean quotationNotNull = quotation != null;
        boolean bl = exRateNotNull = exRate != null && BigDecimal.ZERO.compareTo((BigDecimal)exRate) < 0;
        if (quotationNotNull && exRateNotNull) {
            return;
        }
        if (currency == null || settleCurrency == null || exrateDate == null || exrateTable == null) {
            return;
        }
        Long currencyId = (Long)currency.getPkValue();
        Long settleCurrencyId = (Long)settleCurrency.getPkValue();
        Long exrateTableId = (Long)exrateTable.getPkValue();
        if (quotationNotNull) {
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)settleCurrencyId, (Long)currencyId, (Long)exrateTableId, (Date)exrateDate, (boolean)"1".equals(quotation));
            obj.set("exchangerate", (Object)exchangeRate);
            return;
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)settleCurrencyId, (Long)currencyId, (Long)exrateTableId, (Date)exrateDate);
        if (exchangeRateMap.size() == 0) {
            return;
        }
        Object quoteType = exchangeRateMap.get(QUOTETYPE);
        Object exchangeRate = exchangeRateMap.get(EXCHANGERATE);
        if (quoteType != null) {
            obj.set("quotation", (Object)((Boolean)quoteType != false ? "1" : "0"));
        }
        if (!exRateNotNull) {
            obj.set("exchangerate", exchangeRate);
        }
    }

    public static void dealEntryScheme(DynamicObject obj, DynamicObjectCollection entrycoll, DynamicObject invScheme) {
        InvSchemeService service = ImBillBotpHelp.getInvSchemeService(obj);
        if (service == null) {
            return;
        }
        invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invScheme.getPkValue(), (String)"im_invscheme", (String)InvSchemeConst.getAllSelector());
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject defaltInvType = null;
        HashMap invTypeMap = new HashMap(16);
        if (isInUpdate) {
            ownerType = InvSchemeHelper.getDefaultOwnerType((DynamicObject)invScheme);
            keeperType = InvSchemeHelper.getDefaultKeeperType((DynamicObject)invScheme);
            invStatus = InvSchemeHelper.getDefaultInvStatus((DynamicObject)invScheme);
            defaltInvType = InvSchemeHelper.getDefaltInvtype((DynamicObject)invScheme);
            invTypeMap.putAll(InvSchemeHelper.getInvTypeMap((DynamicObject)invScheme));
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvStatus = null;
        DynamicObject defaultOutInvType = null;
        HashMap outInvTypeMap = new HashMap(16);
        if (isOutUpdate) {
            outOwnerType = InvSchemeHelper.getDefaultOutOwnerType((DynamicObject)invScheme);
            outKeeperType = InvSchemeHelper.getDefaultOutKeeperType((DynamicObject)invScheme);
            outInvStatus = InvSchemeHelper.getDefaultOutInvStatus((DynamicObject)invScheme);
            defaultOutInvType = InvSchemeHelper.getDefaltOutInvtype((DynamicObject)invScheme);
            outInvTypeMap.putAll(InvSchemeHelper.getOutInvType((DynamicObject)invScheme));
        }
        int size = entrycoll.size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            DynamicObject keeper;
            DynamicObject owner;
            DynamicObject entry = (DynamicObject)entrycoll.get(rowIndex);
            if (isOutUpdate) {
                ImBillBotpHelp.setValueIfNull(entry, "outinvstatus", outInvStatus);
                DynamicObject outInvType = entry.getDynamicObject("outinvtype");
                if (outInvType != null) {
                    long outInvTypeId = outInvType.getLong("id");
                    List outOwnerKeeperTypeList = (List)outInvTypeMap.get(outInvTypeId);
                    if (outOwnerKeeperTypeList != null) {
                        outOwnerType = (String)outOwnerKeeperTypeList.get(0);
                        outKeeperType = (String)outOwnerKeeperTypeList.get(1);
                    } else {
                        outOwnerType = null;
                        outKeeperType = null;
                    }
                    defaultOutInvType = outInvType;
                }
                entry.set("outinvtype", (Object)defaultOutInvType);
                entry.set("outownertype", (Object)outOwnerType);
                entry.set("outkeepertype", (Object)outKeeperType);
                owner = entry.getDynamicObject("outowner");
                owner = ImBillBotpHelp.checkKeeperAndOwnerEqType(owner, outOwnerType);
                if (owner == null) {
                    Object defalutOutOwnerId = service.getDefalutOutOwner(outOwnerType, rowIndex);
                    entry.set("outowner_id", defalutOutOwnerId);
                }
                keeper = entry.getDynamicObject("outkeeper");
                if ((keeper = ImBillBotpHelp.checkKeeperAndOwnerEqType(keeper, outKeeperType)) == null) {
                    Object defalutOutKeeperId = service.getDefalutOutKeeper(outKeeperType, rowIndex);
                    entry.set("outkeeper_id", defalutOutKeeperId);
                }
            }
            if (!isInUpdate) continue;
            ImBillBotpHelp.setValueIfNull(entry, "invstatus", invStatus);
            ImBillBotpHelp.setInvSchemeStatusIfNull(entry, "invstatus", invStatus);
            DynamicObject invType = entry.getDynamicObject("invtype");
            if (invType != null) {
                long invTypeId = invType.getLong("id");
                List ownerKeeperTypeList = (List)invTypeMap.get(invTypeId);
                if (ownerKeeperTypeList != null) {
                    ownerType = (String)ownerKeeperTypeList.get(0);
                    keeperType = (String)ownerKeeperTypeList.get(1);
                } else {
                    ownerType = null;
                    keeperType = null;
                }
                defaltInvType = invType;
            }
            entry.set("invtype", (Object)defaltInvType);
            entry.set("ownertype", (Object)ownerType);
            entry.set("keepertype", (Object)keeperType);
            owner = entry.getDynamicObject("owner");
            owner = ImBillBotpHelp.checkKeeperAndOwnerEqType(owner, ownerType);
            if (owner == null) {
                Object defalutOwnerId = service.getDefalutOwner(ownerType, rowIndex);
                entry.set("owner_id", defalutOwnerId);
            }
            keeper = entry.getDynamicObject("keeper");
            if ((keeper = ImBillBotpHelp.checkKeeperAndOwnerEqType(keeper, keeperType)) != null) continue;
            Object defalutKeeperId = service.getDefalutKeeper(keeperType, rowIndex);
            entry.set("keeper_id", defalutKeeperId);
        }
    }

    private static DynamicObject checkKeeperAndOwnerEqType(DynamicObject owner, String ownerType) {
        if (owner != null && !owner.getDataEntityType().getName().equals(ownerType)) {
            owner = null;
        }
        return owner;
    }

    protected static InvSchemeService getInvSchemeService(DynamicObject obj) {
        InvSchemeService service = InvSchemeServiceFactory.getService((DynamicObject)obj);
        return service;
    }

    private static void setValueIfNull(DynamicObject obj, String key, Object defaultValue) {
        Object value = obj.get(key);
        if (value == null) {
            obj.set(key, defaultValue);
            return;
        }
        if (value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
            obj.set(key, defaultValue);
        }
    }

    private static void setInvSchemeStatusIfNull(DynamicObject obj, String key, DynamicObject defaultValue) {
        DynamicObject value = obj.getDynamicObject(key);
        if (value == null) {
            obj.set(key, (Object)defaultValue);
            return;
        }
        String number = value.getString("number");
        if (SCHEME_ENABLE.equals(number) && defaultValue != null) {
            obj.set(key, (Object)defaultValue);
        }
    }

    public static void reCalFields(DynamicObject obj, String name) {
        DynamicObjectCollection entrycols = obj.getDynamicObjectCollection("billentry");
        if (entrycols.size() > 0) {
            switch (name) {
                case "im_mdc_ominbill": 
                case "im_saloutbill": 
                case "im_purinbill": 
                case "im_purreceivebill": 
                case "im_mdc_omcmplinbill": 
                case "im_ospurinbill": {
                    TaxAlgorithmForBotp algo = new TaxAlgorithmForBotp(obj);
                    algo.reCalFields();
                    break;
                }
                case "im_otherinbill": 
                case "im_otheroutbill": 
                case "im_productinbill": 
                case "im_materialreqoutbill": 
                case "im_osmaterialreqoutbill": {
                    SimpleAlgorithmForBotp simpleAlgo = new SimpleAlgorithmForBotp(obj);
                    simpleAlgo.reCalFields();
                    break;
                }
                case "im_transdirbill": 
                case "im_transinbill": 
                case "im_transoutbill": {
                    SimpleAlgorithmForBotp transAlgo = new SimpleAlgorithmForBotp(obj, "settlescurrency");
                    transAlgo.reCalFields();
                    break;
                }
            }
        }
    }

    @Deprecated
    public static void setAuxptyUnit(DynamicObjectCollection entrycoll) {
        for (DynamicObject entry : entrycoll) {
            ImBillBotpHelp.setEntryAuxptyUnit(entry);
        }
    }

    public static void setEntryAuxptyUnit(DynamicObject entry) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_INV()));
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        DynamicObject billUnit2nd = entry.getDynamicObject("unit2nd");
        if (billUnit2nd == null) {
            entry.set("unit2nd", (Object)auxptyUnit);
        }
    }
}

