/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class InspectionHelper {
    protected static final Log log = LogFactory.getLog(InspectionHelper.class);
    private static String[] INSPECT_BILL_TYPES = new String[]{"sm_delivernotice", "sm_returnapply", "im_purreceivebill"};
    private static String[] INSPECT_BILL_QTY_ENABLE_TYPES = new String[]{"im_otheroutbill", "im_purinbill", "im_ospurinbill"};
    private static final String UNION_PUSH = "unionpush";
    private static final String BIZTYPE_NUMBER_QCP1 = "qcp-001";
    private static final String BIZTYPE_NUMBER_QCP2 = "qcp-002";
    private static final String BIZTYPE_NUMBER_QCNP = "qcnp-001";
    private static final String BIZTYPE_NUMBER_QCAS1 = "qcas-001";
    private static final String BIZTYPE_NUMBER_QCAS2 = "qcas-002";
    private static final Set<String> BIZTYPE_NUMBER_TO_QCAS1_SET = new HashSet<String>(Arrays.asList("210", "230", "240"));
    private static final Set<String> BIZTYPE_NUMBER_TO_QCAS2_SET = new HashSet<String>(Arrays.asList("2101", "2401"));
    private static final Set<String> BIZTYPE_NUMBER_TO_QCP1_SET = new HashSet<String>(Arrays.asList("110", "115", "130", "WX110", "4011"));
    private static final Set<String> BIZTYPE_NUMBER_TO_QCP2_SET = new HashSet<String>(Arrays.asList("4011", "WX100"));

    public static Set<Integer> getNeedInspectByIndex(DynamicObject purRecBill, Collection<Integer> checkIndex) {
        Map<String, JSONObject> params = InspectionHelper.buildInspectionParams(purRecBill, checkIndex);
        Set<String> calInspectResult = InspectionHelper.calInspect(params);
        HashSet<Integer> result = new HashSet<Integer>(calInspectResult.size());
        for (String resultKey : calInspectResult) {
            result.add(Integer.valueOf(resultKey));
        }
        return result;
    }

    public static Map<String, JSONObject> buildInspectionParams(DynamicObject purRecBill, Collection<Integer> checkIndex) {
        DynamicObject supplier = purRecBill.getDynamicObject("supplier");
        if (supplier == null) {
            return new HashMap<String, JSONObject>();
        }
        HashMap<String, JSONObject> params = new HashMap<String, JSONObject>(checkIndex.size());
        DynamicObjectCollection entries = purRecBill.getDynamicObjectCollection("billentry");
        for (int index : checkIndex) {
            DynamicObject entry = (DynamicObject)entries.get(index);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject inspectOrg = entry.getDynamicObject("insporg");
            if (material == null || inspectOrg == null) continue;
            JSONObject objs = InspectionHelper.buildInspectionParam(supplier, material, inspectOrg);
            params.put("" + index, objs);
        }
        return params;
    }

    public static JSONObject buildInspectionParam(DynamicObject supplier, DynamicObject material, DynamicObject inspectOrg) {
        if (supplier == null || material == null || inspectOrg == null) {
            return null;
        }
        JSONObject objs = new JSONObject();
        objs.put("supplierId", supplier.getPkValue());
        objs.put("materialId", material.getDynamicObject("masterid").getPkValue());
        objs.put("inspectOrgId", inspectOrg.getPkValue());
        objs.put("bizType", (Object)BIZTYPE_NUMBER_QCP1);
        return objs;
    }

    public static Set<String> calInspect(Map<String, JSONObject> params) {
        if (!MetaDataHelper.isBizAppExistQcbd()) {
            return new HashSet<String>(0);
        }
        if (params.isEmpty() || !SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003")) {
            return new HashSet<String>(0);
        }
        HashSet<String> needInsp = new HashSet<String>(params.size());
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"MaterialInspectService", (String)"isNeedInspectBat", (Object[])new Object[]{params});
            for (Map.Entry entry : result.entrySet()) {
                JSONObject value = (JSONObject)entry.getValue();
                Boolean isNeed = value.getBoolean("isNeedInspect");
                if (!Boolean.TRUE.equals(isNeed)) continue;
                needInsp.add((String)entry.getKey());
            }
        }
        catch (Exception e) {
            log.info("\u8c03\u7528 \u8d28\u68c0isNeedInspectBat\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return new HashSet<String>(0);
        }
        return needInsp;
    }

    public static void checkNeedInspect(DynamicObject[] bills) {
        boolean enableImQmc = SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0003");
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
            Set<String> needInspect = InspectionHelper.checkNeedInspect(entryList, bill.getDynamicObject("supplier"), enableImQmc);
            for (int i = 0; i < entryList.size(); ++i) {
                boolean newIsInspect;
                DynamicObject entry = (DynamicObject)entryList.get(i);
                boolean oldIsInspect = entry.getBoolean("isinspect");
                if (enableImQmc) {
                    String index = String.valueOf(i);
                    newIsInspect = needInspect.contains(index);
                    InspectionHelper.inspectNotEqAndUpdate(entry, oldIsInspect, newIsInspect);
                    continue;
                }
                DynamicObject mat = entry.getDynamicObject("material");
                newIsInspect = mat.getBoolean("ispurchaseinspect");
                InspectionHelper.inspectNotEqAndUpdate(entry, oldIsInspect, newIsInspect);
            }
        }
    }

    private static Set<String> checkNeedInspect(DynamicObjectCollection billEntryList, DynamicObject supplier, boolean enableImQmc) {
        Set<String> needInspect = new HashSet<String>();
        if (enableImQmc) {
            HashSet<String> sendParamsSet = new HashSet<String>();
            HashMap<String, LinkedHashSet<String>> map = new HashMap<String, LinkedHashSet<String>>(16);
            HashMap<String, JSONObject> inspParams = new HashMap<String, JSONObject>(16);
            if (supplier == null) {
                return needInspect;
            }
            for (int i = 0; i < billEntryList.size(); ++i) {
                LinkedHashSet<String> indexSet;
                DynamicObject entry = (DynamicObject)billEntryList.get(i);
                if (entry.getDynamicObject("insporg") == null || entry.getDynamicObject("material") == null) continue;
                JSONObject inspParam = InspectionHelper.buildInspectionParam(supplier, entry.getDynamicObject("material"), entry.getDynamicObject("insporg"));
                StringBuilder sendParamBuilder = new StringBuilder(supplier.getPkValue().toString());
                Object masterId = entry.getDynamicObject("material").getDynamicObject("masterid").getPkValue();
                Object inspOrgId = entry.getDynamicObject("insporg").getPkValue();
                sendParamBuilder.append(masterId.toString());
                sendParamBuilder.append(inspOrgId.toString());
                String sendParam = sendParamBuilder.toString();
                String index = String.valueOf(i);
                if (sendParamsSet.contains(sendParam)) {
                    indexSet = (LinkedHashSet<String>)map.get(sendParam);
                    indexSet.add(index);
                    continue;
                }
                sendParamsSet.add(sendParam);
                indexSet = (Set)map.get(sendParam);
                if (CollectionUtils.isEmpty((Collection)indexSet)) {
                    indexSet = new LinkedHashSet<String>();
                    indexSet.add(index);
                    map.put(sendParam, indexSet);
                }
                inspParams.put(index, inspParam);
            }
            needInspect = InspectionHelper.calInspect(inspParams);
            if (CollectionUtils.isEmpty(needInspect)) {
                return needInspect;
            }
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                if (!needInspect.contains(((Set)entry.getValue()).iterator().next())) continue;
                needInspect.addAll((Collection)entry.getValue());
            }
        }
        return needInspect;
    }

    private static void inspectNotEqAndUpdate(DynamicObject entry, boolean oldIsInspect, boolean newIsInspect) {
        if (oldIsInspect != newIsInspect) {
            entry.set("isinspect", (Object)newIsInspect);
            BigDecimal leftInspQty = BigDecimal.ZERO;
            BigDecimal leftInspBaseQty = BigDecimal.ZERO;
            if (newIsInspect) {
                leftInspQty = entry.getBigDecimal("qty");
                leftInspBaseQty = entry.getBigDecimal("baseqty");
            }
            entry.set("leftinspqty", (Object)leftInspQty);
            entry.set("leftinspbaseqty", (Object)leftInspBaseQty);
            if (!newIsInspect) {
                entry.set("emrelease", (Object)false);
            }
        }
    }

    public static DynamicObject getInspOrg(DynamicObject requireOrg) {
        if (requireOrg == null) {
            return null;
        }
        Long requiredOrgId = requireOrg.getLong("id");
        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)requiredOrgId);
        if (allToOrg == null || allToOrg.isEmpty()) {
            return null;
        }
        if (allToOrg.contains(requiredOrgId)) {
            return requireOrg;
        }
        return BusinessDataServiceHelper.loadSingle(allToOrg.get(0), (String)"bos_org");
    }

    public static DynamicObjectCollection getIncomingInspectInfo(QFilter[] filters) {
        String billentity = "qcp_incominginspct";
        String selectFields = "id as billid,billno,'qcp_incominginspct' as inspsrcbillentity,matintoentity.id as entryid, matintoentity.materialid as materialid,matintoentity.baseunit as unit,matintoentity.basequaliqty as qty,'0' as inspectionresult";
        return QueryServiceHelper.query((String)billentity, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObjectCollection getBadDealInfo(QFilter[] filters) {
        String billentity = "qcp_baddeal";
        String selectFields = "id as billid,billno,'qcp_baddeal' as inspsrcbillentity,materialentry.id as entryid, materialentry.materielid as materialid,materialentry.baseunit as unit,materialentry.baseqty as qty,materialentry.handmethed as inspectionresult";
        return QueryServiceHelper.query((String)billentity, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObjectCollection getUrgentpassInfo(QFilter[] filters) {
        String billentity = "qcp_urgentpass";
        String selectFields = "id as billid,billno,'qcp_urgentpass' as inspsrcbillentity,materialentry.id as entryid, materialentry.materialid as materialid,materialentry.baseunit as unit,materialentry.baseqty as qty,'' as inspectionresult";
        return QueryServiceHelper.query((String)billentity, (String)selectFields, (QFilter[])filters);
    }

    public static void enableQtyEdit(IDataModel model, IFormView view, Long billId) {
        if (!"A".equals(model.getValue("billstatus"))) {
            return;
        }
        String entityType = model.getDataEntityType().getName();
        Set<Long> inspectEntryIdSet = InspectionHelper.isInspectBill(entityType, new Long[]{billId});
        if (ObjectUtils.isNotEmpty(inspectEntryIdSet)) {
            DynamicObjectCollection rows = model.getEntryEntity("billentry");
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                DynamicObjectCollection lkRows = row.getDynamicObjectCollection("billentry_lk");
                for (DynamicObject lkRow : lkRows) {
                    Long sentryid = lkRow.getLong("billentry_lk_sid");
                    if (!inspectEntryIdSet.contains(sentryid)) continue;
                    view.setEnable(Boolean.valueOf(false), i, new String[]{"qty"});
                }
            }
        }
    }

    public static Set<Long> isInspectBill(String entityType, Long[] billIds) {
        HashSet<Long> inspectEntryIdSet = new HashSet<Long>(4);
        Map map = BFTrackerServiceHelper.findDirtSourceBills((String)entityType, (Long[])billIds);
        if (MapUtils.isEmpty((Map)map)) {
            return Collections.emptySet();
        }
        Long tableId = null;
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(billIds.length);
        HashMap<Long, HashMap<Long, Long>> idMap = new HashMap<Long, HashMap<Long, Long>>();
        for (Map.Entry entry : map.entrySet()) {
            for (BFRow bfRow : (List)entry.getValue()) {
                tableId = bfRow.getSId().getTableId();
                Long srcEntryId = bfRow.getSId().getEntryId();
                srcEntryIdSet.add(srcEntryId);
                Long tgtBillId = bfRow.getId().getBillId();
                Long tgEntryId = bfRow.getId().getEntryId();
                HashMap<Long, Long> tgtMap = (HashMap<Long, Long>)idMap.get(srcEntryId);
                if (null == tgtMap) {
                    tgtMap = new HashMap<Long, Long>(2);
                    idMap.put(srcEntryId, tgtMap);
                }
                tgtMap.put(tgEntryId, tgtBillId);
            }
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine(tableId);
        String srcEntityType = tableDefine.getEntityNumber();
        if (!ArrayUtils.contains((Object[])INSPECT_BILL_TYPES, (Object)srcEntityType)) {
            return Collections.emptySet();
        }
        QFilter qFilter = new QFilter("billentry.id", "in", srcEntryIdSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvBillHelper.class.getName(), (String)srcEntityType, (String)"id,billentry.id as entryid,billentry.isinspect as isinspect", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long srcEntryId = row.getLong("entryId");
                Boolean isinspect = row.getBoolean("isinspect");
                if (!BooleanUtils.isTrue((Boolean)isinspect)) continue;
                inspectEntryIdSet.add(srcEntryId);
            }
        }
        return inspectEntryIdSet;
    }

    public static Set<Object> calInspectForApi(List<Map<String, Object>> params) {
        HashSet<Object> needInsp = new HashSet<Object>(params.size());
        try {
            log.info("[InspectionHelper.calInspectForApi]\u8c03\u7528\u8d28\u68c0isNeedInspectForApi\u63a5\u53e3\u53c2\u6570\uff1a" + params);
            List result = (List)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"MaterialInspectService", (String)"isNeedInspectForApi", (Object[])new Object[]{params});
            log.info("[InspectionHelper.calInspectForApi]\u8c03\u7528\u8d28\u68c0isNeedInspectForApi\u63a5\u53e3\u7ed3\u679c\uff1a" + result);
            for (Map map : result) {
                Object isNeedInspect = map.get("isNeedInspect");
                if (isNeedInspect == null || !"true".equalsIgnoreCase(isNeedInspect.toString())) continue;
                needInsp.add(map.get("id"));
            }
        }
        catch (Exception e) {
            log.info("[InspectionHelper.calInspectForApi]\u8c03\u7528\u8d28\u68c0isNeedInspectForApi\u63a5\u53e3\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return new HashSet<Object>(0);
        }
        return needInsp;
    }

    public static Long getBizTypeId(String bizTypeNo) {
        String number = BIZTYPE_NUMBER_QCP1;
        if ("430".equals(bizTypeNo)) {
            number = BIZTYPE_NUMBER_QCNP;
        } else if (BIZTYPE_NUMBER_TO_QCAS1_SET.contains(bizTypeNo)) {
            number = BIZTYPE_NUMBER_QCAS1;
        } else if (BIZTYPE_NUMBER_TO_QCAS2_SET.contains(bizTypeNo)) {
            number = BIZTYPE_NUMBER_QCAS2;
        } else if (BIZTYPE_NUMBER_TO_QCP1_SET.contains(bizTypeNo)) {
            number = BIZTYPE_NUMBER_QCP1;
        } else if (BIZTYPE_NUMBER_TO_QCP2_SET.contains(bizTypeNo)) {
            number = BIZTYPE_NUMBER_QCP2;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (String)"id,number", (QFilter[])qFilter.toArray());
        return bizType.getLong("id");
    }

    public static void handleQtyEnable(IDataModel model, IFormView formView, Long billId) {
        String entityType = model.getDataEntityType().getName();
        String bizNum = model.getDataEntity().getString("biztype.number");
        if (ArrayUtils.contains((Object[])INSPECT_BILL_QTY_ENABLE_TYPES, (Object)entityType) || "im_saloutbill".equals(entityType) && !"210".equals(bizNum)) {
            if ("im_purinbill".equals(entityType) || "im_ospurinbill".equals(entityType)) {
                DynamicObjectCollection entryList = model.getDataEntity().getDynamicObjectCollection("billentry");
                if (entryList == null || entryList.isEmpty()) {
                    return;
                }
                String srcSystem = ((DynamicObject)entryList.get(0)).getString("srcsystem");
                if (!UNION_PUSH.equals(srcSystem)) {
                    return;
                }
            }
            InspectionHelper.enableQtyEdit(model, formView, billId);
        }
    }
}

