/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ErrorCodeHelper;
import kd.scmc.im.business.helper.FillBatchHelper;
import kd.scmc.im.business.helper.InvAvbQtyQueryHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutNewHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutPageCache;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImApplyBillPropChanged;
import kd.scmc.im.formplugin.transbill.ApplyBillBeforeF7SelectListener;
import kd.scmc.im.formplugin.transbill.TransBillCommonBeforeF7SelectListener;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ImApplyBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(ImApplyBillEditPlugin.class);
    private DynamicObject bizType;
    protected DynamicObject bill;
    private Long lineType;
    private Map<String, DynamicObject> materialCacheMap = new HashMap<String, DynamicObject>(16);
    private static final String BARITEM_ENTER_SNNUMBER = "entersnnumber";
    private static final String BARITEM_IMPORT_SNNUMBER = "importsnnumber";
    private static final String BARITEM_CHECK_SNNUMBER = "checksnnumber";
    private static final String SCMCAVBINVQUERY = "scmcavbinvquery";
    private static final String INSCMCAVBINVQUERY = "inscmcavbinvquery";
    private static final String DRAW = "tbldraw";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"linetype", "unit", "material", "applyuser", "lot", "biztype", "org", "mversion", "configuredcode", "tracknumber"});
        this.addClickListeners(new String[]{"lotnumber"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        FlexEdit auxpty = (FlexEdit)this.getView().getControl("auxpty");
        if (null != auxpty) {
            auxpty.registerBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "matchingruleout": {
                IFormView view = this.getView();
                String formid = this.getModel().getDataEntityType().getName();
                log.info("matchingruleout new");
                try {
                    this.matchingRuleOutNew(view, formid, "billentry", opKey);
                    break;
                }
                finally {
                    view.hideLoading();
                }
            }
            case "unaudit": 
            case "modify": {
                this.closeStatusValidate(args, opKey);
                break;
            }
        }
    }

    private void matchingRuleOutNew(IFormView view, String formid, String entry, String operateKey) {
        EntryGrid control = (EntryGrid)this.getControl(entry);
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImBillEditPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Integer> selectRowList = new ArrayList<Integer>(selectRows.length);
        for (int i = 0; i < selectRows.length; ++i) {
            selectRowList.add(selectRows[i]);
        }
        MatchingRuleOutNewHelper.execMatchingFromView((IFormPlugin)this, (String)formid, (String)entry, (String)operateKey, (IFormView)view, selectRowList);
    }

    private void closeStatusValidate(BeforeDoOperationEventArgs args, String opKey) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        if ("D".equals(billStatus)) {
            String billNo = (String)this.getModel().getValue("billno");
            String msg = "";
            msg = "unaudit".equals(opKey) ? String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u65f6\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MaterialReqBillPlugin_21", (String)"scmc-im-formplugin", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"MaterialReqBillPlugin_20", (String)"scmc-im-formplugin", (Object[])new Object[0]), billNo);
            ErrorCodeHelper.showErrorCode((String)msg, (String)"n", (String)"tip", null, null, (int)3, null, null, null, (AbstractFormPlugin)this);
            args.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        this.initBizType();
        this.initCurrency();
        this.initApplyUser();
        this.afterCreateNewDetailData(model);
    }

    protected void initApplyUser() {
        DynamicObject applyDept = (DynamicObject)this.getModel().getValue("applydept");
        if (applyDept == null) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        QFilter qFilter1 = new QFilter("entryentity.dpt", "=", applyDept.getPkValue());
        QFilter qFilter2 = new QFilter("id", "=", (Object)Long.valueOf(userId));
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        this.getModel().setValue("applyuser", (Object)user);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        try (TraceSpan span = Tracer.create((String)"ImBillEditPlugin", (String)"entryGridBindData");){
            List entities = e.getRows();
            entities.forEach(entry -> this.setEntryRowEnable(entry.getDataEntity(), entry.getRowIndex(), this.getView()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleEnable();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initMaterialName();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initMaterialName();
    }

    private void initMaterialName() {
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject materialInvInfo = entry.getDynamicObject("material");
            String materialname = entry.getString("materialname");
            if (materialInvInfo == null || !materialname.equals("")) continue;
            DynamicObject material = materialInvInfo.getDynamicObject("masterid");
            if (material == null) {
                return;
            }
            boolean isdisposable = material.getBoolean("isdisposable");
            this.getModel().setValue("materialname", (Object)material.getString("name"), i);
            this.getView().setEnable(Boolean.valueOf(isdisposable), i, new String[]{"materialname"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        String callBackId = e.getCallBackId();
        String formId = this.getModel().getDataEntityType().getName();
        switch (callBackId) {
            case "cb_matchruleout_new": {
                MatchingRuleOutNewHelper.confirmCallBack((IFormView)this.getView(), (MessageBoxClosedEvent)e);
                break;
            }
            case "clearSupplierOrEntry": {
                String customValue = e.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customValue)) {
                    return;
                }
                Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    this.dealWithSupplier(confirmInfo);
                    this.dealWithMaterial(confirmInfo);
                    this.dealWithOwnerType(confirmInfo, formId);
                    break;
                }
                Object oldBizTypeId = confirmInfo.get("oldBizTypeId");
                this.setValue("biztype", oldBizTypeId, false);
                break;
            }
            case "clearMaterial": {
                String customValue2 = e.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customValue2)) {
                    return;
                }
                Map confirmInfo2 = (Map)SerializationUtils.fromJsonString((String)customValue2, Map.class);
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    int rowIndex = (Integer)confirmInfo2.get("rowIndex");
                    this.setValue("material", null, rowIndex, true);
                    this.setValue("materialname", null, rowIndex, false);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
                    break;
                }
                Object oldLineTypeId = confirmInfo2.get("oldLineTypeId");
                this.setValue("linetype", oldLineTypeId, false);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode", "materialname"});
                this.initNewEntryLineType(rowIndex);
                this.getView().updateView("linetype", rowIndex);
            }
        }
    }

    private void afterCreateNewDetailData(IDataModel bill) {
        DynamicObjectCollection InvBillEntryList = (DynamicObjectCollection)bill.getValue("billentry");
        int entrySize = InvBillEntryList.size();
        for (int i = 0; i < entrySize; ++i) {
            this.initNewEntryLineType(i);
        }
    }

    private void initBizType() {
        IDataModel bill = this.getModel();
        DynamicObject bizType = this.getBizTypeByBillType();
        if (bizType != null) {
            bill.setValue("biztype", (Object)bizType.getLong("id"));
        }
    }

    private void initNewEntryLineType(int rowIndex) {
        this.bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (this.bizType == null) {
            return;
        }
        if (this.lineType == null) {
            Long bizTypeId = this.bizType.getLong("id");
            this.lineType = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
        }
        this.getModel().beginInit();
        this.getModel().setValue("linetype", (Object)this.lineType, rowIndex);
        this.getModel().endInit();
    }

    private DynamicObject getBizType() {
        List bizTypes;
        String formId = this.getModel().getDataEntityType().getName();
        if (this.bizType == null && !(bizTypes = BizTypeHelper.getBizTypeByEntityID((String)formId)).isEmpty()) {
            Object value = this.getModel().getValue("billtype");
            DynamicObject type = value == null ? null : BizTypeHelper.getBillType((String)formId, (List)bizTypes, (DynamicObject)((DynamicObject)value));
            this.bizType = type == null ? (DynamicObject)bizTypes.get(0) : type;
        }
        return this.bizType;
    }

    private DynamicObject getBizTypeByBillType() {
        String formId = this.getModel().getDataEntityType().getName();
        if (this.bizType == null) {
            Object value = this.getModel().getValue("billtype");
            this.bizType = value == null ? null : BizTypeHelper.getBizTypeByBillType((String)formId, (DynamicObject)((DynamicObject)value));
        }
        return this.bizType;
    }

    private void dealWithMaterial(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        List clearEntryIndexList = (List)confirmInfo.get("clearEntryIndexList");
        if (clearEntryIndexList.size() != 0) {
            int[] clearEntryIndex = new int[clearEntryIndexList.size()];
            for (int i = 0; i < clearEntryIndexList.size(); ++i) {
                clearEntryIndex[i] = (Integer)clearEntryIndexList.get(i);
            }
            model.deleteEntryRows("billentry", clearEntryIndex);
            int rowCount = model.getEntryRowCount("billentry");
            if (rowCount == 0) {
                model.createNewEntryRow("billentry");
            }
        }
    }

    private void dealWithOwnerType(Map<Object, Object> confirmInfo, String formId) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        Object domain = confirmInfo.get("newBizDomain");
        if ("im_transapply".equals(formId) && "6".equals(domain)) {
            DynamicObject VMIInvType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invtype", (String)"number", (QFilter[])new QFilter("number", "=", (Object)"113").toArray());
            this.getModel().setValue("ownertype", (Object)"bd_supplier", 0);
            this.getModel().setValue("inownertype", (Object)"bos_org", 0);
            this.getModel().setValue("invtype", (Object)VMIInvType, 0);
        } else if ("im_materialreqbill".equals(formId) && "6".equals(domain)) {
            this.getModel().setValue("supplyownertype", (Object)"bd_supplier");
        }
    }

    private void dealWithSupplier(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        boolean clearSupplier = false;
        Object clear = confirmInfo.get("clearSupplier");
        if (null != clear) {
            clearSupplier = (Boolean)clear;
        }
        if (clearSupplier) {
            this.getModel().setValue("supplyowner", null);
        }
    }

    protected void handleEnable() {
        if ("D".equals(this.getBill().getString("billstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"splitrow"});
            this.handleEnableAndVisible(false);
        } else {
            if ("A".equals(this.getBill().getString("billstatus"))) {
                this.setHeadEnable();
                this.setEntryEnable();
                this.getView().setVisible(Boolean.TRUE, new String[]{"splitrow"});
            }
            this.handleEnableAndVisible(true);
        }
    }

    protected void setHeadEnable() {
        this.setEnable4IsDraw(this.isDraw());
    }

    protected void setEntryEnable() {
        DynamicObject localBill = this.getBill(true);
        DynamicObjectCollection billEntrys = localBill.getDynamicObjectCollection("billentry");
        IFormView view = this.getView();
        if (billEntrys == null || billEntrys.size() == 0) {
            return;
        }
        for (int i = 0; i < billEntrys.size(); ++i) {
            this.setEntryRowEnable((DynamicObject)billEntrys.get(i), i, view);
        }
    }

    private void handleEnableAndVisible(Boolean enableAndVisible) {
        this.getView().setVisible(enableAndVisible, new String[]{"bar_del", "bar_save", "bar_submit", "bar_submitandnew", "bar_more"});
        this.getView().setEnable(enableAndVisible, new String[]{"bar_audit"});
    }

    private void setEntryRowEnable(DynamicObject entry, int rowIndex, IFormView view) {
        DynamicObject materialInvInfo = entry.getDynamicObject("material");
        this.getView().setEnable(Boolean.valueOf(materialInvInfo != null), rowIndex, new String[]{"configuredcode", "materialname"});
        if (materialInvInfo != null) {
            DynamicObject material = materialInvInfo.getDynamicObject("masterid");
            if (material == null) {
                String materialErrorMsg = CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_INV());
                throw new KDBizException(materialErrorMsg);
            }
            this.getView().setEnable(Boolean.valueOf("2".equals(material.get("configproperties"))), rowIndex, new String[]{"configuredcode"});
            boolean isdisposable = material.getBoolean("isdisposable");
            if (!isdisposable) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname"});
            }
            Boolean enablelot = materialInvInfo.getBoolean("enablelot");
            view.setEnable(enablelot, rowIndex, new String[]{"lotnumber"});
            view.setEnable(enablelot, rowIndex, new String[]{"lot"});
            DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
            Boolean isUseAuxptyUnit = auxptyUnit != null;
            view.setEnable(isUseAuxptyUnit, rowIndex, new String[]{"qtyunit2nd"});
            boolean isUseAuxpty = material.getBoolean("isuseauxpty");
            view.setEnable(Boolean.valueOf(isUseAuxpty), rowIndex, new String[]{"auxpty"});
            boolean isEnableShelfLife = materialInvInfo.getBoolean("enableshelflifemgr");
            view.setEnable(Boolean.valueOf(isEnableShelfLife), rowIndex, new String[]{"producedate"});
            view.setEnable(Boolean.valueOf(isEnableShelfLife), rowIndex, new String[]{"expirydate"});
            boolean enableSerialNum = SerialNumberHelper.isEnableSerial((DynamicObject)materialInvInfo);
            view.setEnable(Boolean.valueOf(enableSerialNum), rowIndex, new String[]{"serialnumber"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
        }
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        if (warehouse != null) {
            boolean isOpenLocation = warehouse.getBoolean("isopenlocation");
            view.setEnable(Boolean.valueOf(isOpenLocation), rowIndex, new String[]{"location"});
        } else {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
        }
        this.setEntryOtherEnable(entry, rowIndex);
        this.setEntryRowEnable4IsDraw(rowIndex, this.isDraw());
    }

    protected void setEnable4IsDraw(boolean isDraw) {
        if (isDraw) {
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, new String[]{"addrow"});
        }
    }

    protected void setEntryRowEnable4IsDraw(int index, boolean isDraw) {
        if (isDraw) {
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, index, new String[]{"unit", "linetype", "materialname", "configuredcode", "tracknumber"});
        }
    }

    protected void setEntryOtherEnable(DynamicObject billEntry, int rowIndex) {
    }

    protected DynamicObject getBill() {
        return this.getBill(false);
    }

    protected DynamicObject getBill(boolean hasEntry) {
        if (this.bill == null) {
            this.bill = this.getModel().getDataEntity(hasEntry);
        }
        return this.bill;
    }

    private void initCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getModel().setValue("settlecurrency", null);
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"));
        if (map == null) {
            this.getModel().setValue("settlecurrency", null);
            return;
        }
        this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        ImApplyBillPropChanged changer = new ImApplyBillPropChanged(this.getView(), (AbstractFormPlugin)this);
        changer.propertyChanged(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String formId = this.getModel().getDataEntityType().getName();
        Object selector = null;
        String key = e.getProperty().getName();
        selector = "im_transapply".equals(formId) && !"applyuser".equals(key) ? new TransBillCommonBeforeF7SelectListener(this.getView()) : new ApplyBillBeforeF7SelectListener(this.getView());
        selector.beforeF7Select(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "unaudit": 
            case "unsubmit": {
                this.handleEnable();
                break;
            }
            case "scmcavbinvquery": 
            case "inscmcavbinvquery": {
                InvAvbQtyQueryHelper.setAvbQtyInfo((IFormView)this.getView());
                break;
            }
            case "batchfillentry": {
                FillBatchHelper.afterBatchFillEntry((IFormView)this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "fillbatch": {
                FillBatchHelper.batchFill((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        FillBatchHelper.batchSetPredicate((IFormView)this.getView(), (BeforeBatchFillEntryArgs)e);
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (boolean)isTriggerChangeEvent);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    protected final boolean isDraw() {
        DynamicObject bill = this.getBill(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryName());
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        DynamicObjectCollection linkColl = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection(this.getEntryLinkName());
        return linkColl != null && linkColl.size() > 0;
    }

    protected String getEntryLinkName() {
        return "billentry_lk";
    }

    protected String getEntryName() {
        return "billentry";
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        boolean isFromWebApi = billModel.isFromWebApi();
        if (!isFromWebApi) {
            return;
        }
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if (org == null) {
            return;
        }
        this.initCurrency();
        String createType = (String)this.getModel().getValue("billcretype");
        if ("0".equals(createType)) {
            this.getModel().setValue("billcretype", (Object)"3");
        }
        InvBillHelper.handleDefaultValueAfterImport((IDataModel)bill, (Map)e.getSourceData(), this.materialCacheMap);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": {
                this.openPageSelectLotMainfile(key);
                break;
            }
        }
    }

    private void openPageSelectLotMainfile(String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = model.getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotnumField = "billentry." + fieldKey;
        LotMainFileHelper.showPageLotMainfileList((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotnumField);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "msmod_selectlot": {
                this.closedSelectedLot(e);
                break;
            }
        }
    }

    private void closedSelectedLot(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("billentry");
            Map lotAttr = (Map)returnData;
            String lotidfield = (String)lotAttr.get("lotidfield");
            String lotnumfield = (String)lotAttr.get("lotnumfield");
            model.setValue(lotnumfield, lotAttr.get("lotnumber"), rowIndex);
            model.setValue(lotidfield, lotAttr.get("lotid"), rowIndex);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (DRAW.equals(key)) {
            Object org = this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"ImApplyBillEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("fillbatch".equals(key)) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("batchBtn", key);
            FillBatchHelper.checkCancelBeforeBatchFill((IFormView)this.getView(), (BeforeItemClickEvent)evt);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        super.beforeDeleteRow(e);
        for (int index : rowIndexs = e.getRowIndexs()) {
            MatchingRuleOutPageCache.deleteMatchInfoPageCache((int)index, (IFormView)this.getView(), (String)"billentry");
        }
    }

    protected void applyUserInit() {
        DynamicObject applyOrg = (DynamicObject)this.getModel().getValue("org");
        if (applyOrg == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
        List<Long> union = this.getUserDeptAndOrgDeptUnion(user, applyOrg);
        this.getModel().setValue("applyuser", (Object)user);
        if (CollectionUtils.isNotEmpty(union)) {
            this.getModel().setValue("applydept", (Object)union.get(0));
        } else {
            this.getModel().setValue("applydept", null);
        }
    }

    private List<Long> getUserDeptAndOrgDeptUnion(DynamicObject applyUser, DynamicObject applyOrg) {
        List orgDepts = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList((Long)applyOrg.getPkValue()), (boolean)true);
        DynamicObjectCollection deptList = applyUser.getDynamicObjectCollection("entryentity");
        ArrayList<Long> deptId = new ArrayList<Long>();
        for (DynamicObject dept : deptList) {
            Boolean isPartJob = dept.getBoolean("ispartjob");
            DynamicObject dpt = dept.getDynamicObject("dpt");
            if (dpt == null) continue;
            Long id = dpt.getLong("id");
            if (!CollectionUtils.isEmpty((Collection)orgDepts) && !orgDepts.contains(id)) continue;
            if (isPartJob.booleanValue()) {
                deptId.add(id);
                continue;
            }
            deptId.add(0, id);
        }
        return deptId;
    }
}

