/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.balance.recal.BalReCalCache;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ErrorCodeHelper;
import kd.scmc.im.business.helper.FillBatchHelper;
import kd.scmc.im.business.helper.ImBillBotpHelp;
import kd.scmc.im.business.helper.InspectionHelper;
import kd.scmc.im.business.helper.InvAvbQtyQueryHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.InverseBillHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MatchingRuleOutHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.directTran.InvDirectTranHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillModel;
import kd.scmc.im.business.helper.matchout.MatchingRuleOutOldFormHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutHandler;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutNewHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutPageCache;
import kd.scmc.im.business.service.AbstractSchemeService;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.InvSchemeServiceFactory;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.consts.Constants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.enums.NegativeEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillBeforeF7Select;
import kd.scmc.im.formplugin.ImBillPropChanged;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.F7Utils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ImBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log log = LogFactory.getLog(ImBillEditPlugin.class);
    private DynamicObject bill;
    private DynamicObject bizType;
    private DynamicObject invScheme;
    private Long lineType;
    private Map<String, DynamicObject> materialCacheMap = new HashMap<String, DynamicObject>(16);
    private static final String BARITEM_ENTER_SNNUMBER = "entersnnumber";
    private static final String BARITEM_IMPORT_SNNUMBER = "importsnnumber";
    private static final String BARITEM_CHECK_SNNUMBER = "checksnnumber";
    private static final String BARITEM_GENERATE_LOT = "generatelot";
    private static final String SCMCAVBINVQUERY = "scmcavbinvquery";
    private static final String INSCMCAVBINVQUERY = "inscmcavbinvquery";
    private String redBill = null;
    private InvSchemeService invSchemeService = null;
    private static final String DRAW = "tbldraw";
    protected static final String QUOTETYPE = "quoteType";
    protected static final String EXCHANGERATE = "exchangeRate";
    protected static final String DIRECT = "0";
    protected static final String INDIRECT = "1";
    public static final List<String> manufactureList = Arrays.asList("im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omproorder", "im_mdc_omfeedorder", "im_mdc_omreturnorder", "im_mdc_omoutbill", "im_mdc_omfeedbill", "im_mdc_omreturnbill");
    public static final List<String> relatedList = Arrays.asList("mainbillid", "mainbillentryid", "mainbillnumber", "mainbillentity", "srcbillid", "srcbillentryid", "srcbillnumber", "srcbillentity", "mainbillentryseq", "srcbillentryseq", "srcsysbillentryid", "srcsystem", "srcsysbillno", "srcsysbillid", "conbillentity", "conbillid", "conbillnumber", "conbillrownum", "conbillentryid");
    private ImBillPropChanged changer;

    protected InvSchemeService getInvSchemeService() {
        if (this.invSchemeService == null) {
            this.invSchemeService = InvSchemeServiceFactory.getService((IFormView)this.getView());
        }
        if (this.invSchemeService != null) {
            ((AbstractSchemeService)this.invSchemeService).setBill(this.getView().getModel().getDataEntity());
        }
        return this.invSchemeService;
    }

    private boolean noInvScheme() {
        String formId = this.getModel().getDataEntityType().getName();
        return "im_initbill".equalsIgnoreCase(formId) || "im_locationtransfer".equalsIgnoreCase(formId);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"linetype", "biztype", "invscheme", "invstatus", "invtype", "outinvstatus", "outinvtype", "org", "bizuser", "warehouse", "location", "outwarehouse", "outlocation", "material", "unit", "lot", "operatorgroup", "operator", "dept", "owner", "outowner", "keeper", "outkeeper", "outoperator", "outoperatorgroup", "mversion", "configuredcode", "tracknumber", "outwarehouse"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"seradvcontoolbarap"});
        this.addItemClickListeners(new String[]{BARITEM_GENERATE_LOT});
        this.addClickListeners(new String[]{"lotnumber"});
        this.addClickListeners(new String[]{"lot"});
        FlexEdit auxpty = (FlexEdit)this.getView().getControl("auxpty");
        if (null != auxpty) {
            auxpty.registerBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        if (this.changer == null) {
            this.changer = new ImBillPropChanged(this.getView(), (IFormPlugin)this);
        }
        this.changer.propertyChanged(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        try (TraceSpan span = Tracer.create((String)"ImBillEditPlugin", (String)("beforeF7Select: " + e.getProperty().getName()));){
            ImBillBeforeF7Select selector = new ImBillBeforeF7Select(this.getView());
            selector.beforeF7Select(e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try (TraceSpan span = Tracer.create((String)"ImBillEditPlugin", (String)"afterCreateNewData");){
            IDataModel bill = this.getModel();
            BillModel billModel = (BillModel)bill;
            boolean isFromWebApi = billModel.isFromWebApi();
            IFormView view = this.getView();
            this.initMainOrg();
            if (!isFromWebApi) {
                this.initBizDataByOrg();
            }
            this.initBizType();
            this.initInvSchemeData();
            this.afterCreateNewDetailData(view, bill);
            if (!this.isDrawByBOTP()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"addrow"});
            }
            if (isFromWebApi) {
                return;
            }
            CloseDateHelper.initBookDate((String)this.getView().getEntityId(), (DynamicObject)this.getModel().getDataEntity(true));
        }
    }

    private void initMainOrg() {
        String formId = this.getModel().getDataEntityType().getName();
        String orgKey = null;
        orgKey = "im_transdirbill".equals(formId) ? "outorg" : "org";
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgKey);
        if (org == null) {
            return;
        }
        boolean hasOrg = NewInvOrgHelper.checkHasPermissionByOrgId((String)formId, (String)this.getView().getFormShowParameter().getAppId(), (Object)org.getPkValue());
        if (!hasOrg) {
            this.getModel().setValue(orgKey, null);
        }
    }

    private void initBizType() {
        IDataModel bill = this.getModel();
        DynamicObject bizType = this.getBizTypeByBillType();
        if (bizType != null) {
            bill.setValue("biztype", (Object)bizType.getLong("id"));
        }
    }

    private DynamicObject getBizTypeByBillType() {
        String formId = this.getModel().getDataEntityType().getName();
        if (this.bizType == null) {
            Object value = this.getModel().getValue("billtype");
            this.bizType = value == null ? null : BizTypeHelper.getBizTypeByBillType((String)formId, (DynamicObject)((DynamicObject)value));
        }
        return this.bizType;
    }

    private void initNewEntryLineType(int rowIndex) {
        this.bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (this.bizType == null) {
            return;
        }
        if (this.lineType == null) {
            Long bizTypeId = this.bizType.getLong("id");
            this.lineType = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
        }
        this.getModel().beginInit();
        this.getModel().setValue("linetype", (Object)this.lineType, rowIndex);
        this.getModel().endInit();
    }

    private void initBizDataByOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Long orgId = (Long)org.getPkValue();
        String formId = this.getModel().getDataEntityType().getName();
        String cacheKeyPrefix = formId + "_" + orgId + "_" + userId;
        IAppCache imAppCache = BalReCalCache.getImAppCache();
        String cachedDpt = (String)imAppCache.get(cacheKeyPrefix + "_" + "dept", String.class);
        String cachedOperator = (String)imAppCache.get(cacheKeyPrefix + "_" + "operator", String.class);
        String cachedOperatorGrp = (String)imAppCache.get(cacheKeyPrefix + "_" + "operatorgroup", String.class);
        if (cachedDpt != null && cachedOperator != null && cachedOperatorGrp != null) {
            this.getModel().setValue("dept", (Object)cachedDpt);
            this.getModel().setValue("operator", (Object)("null".equals(cachedOperator) ? null : cachedOperator));
            this.getModel().setValue("operatorgroup", (Object)("null".equals(cachedOperatorGrp) ? null : cachedOperatorGrp));
        } else {
            Map<Object, DynamicObject> operatorGroupMap = this.getOperatorGroupMap(orgId);
            this.initDept(userId, orgId, operatorGroupMap, imAppCache, cacheKeyPrefix);
            this.initOperatorAndGroup(userId, operatorGroupMap, imAppCache, cacheKeyPrefix);
        }
    }

    private Map<Object, DynamicObject> getOperatorGroupMap(Long orgId) {
        String operatorGrpType = this.getOperatorGroupType();
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        qFilter02.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
        return map;
    }

    private void initDept(long userId, Long orgId, Map<Object, DynamicObject> operatorGroupMap, IAppCache imAppCache, String cacheKeyPrefix) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            if (null == operator) {
                this.initDeptByOrg(orgId, imAppCache, cacheKeyPrefix);
            } else {
                this.initDeptByOperator(operator, orgId, imAppCache, cacheKeyPrefix);
            }
        }
    }

    private void initDeptByOperator(DynamicObject operator, Long orgId, IAppCache imAppCache, String cacheKeyPrefix) {
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)false);
        if (deptids != null && deptids.size() > 0) {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                for (Long deptId : userdeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    this.getModel().setValue("dept", (Object)deptId);
                    this.setOutDept4TransBill(deptId);
                    imAppCache.put(cacheKeyPrefix + "_" + "dept", (Object)deptId);
                    break;
                }
            }
        } else {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                Long deptId = (Long)userdeptIds.get(0);
                this.getModel().setValue("dept", (Object)deptId);
                this.setOutDept4TransBill(deptId);
                imAppCache.put(cacheKeyPrefix + "_" + "dept", (Object)deptId);
            }
        }
    }

    private void setOutDept4TransBill(Long deptId) {
        String formId = this.getModel().getDataEntityType().getName();
        if ("im_transdirbill".equals(formId)) {
            this.getModel().setValue("outdept", (Object)deptId);
        }
    }

    private void initDeptByOrg(Long orgId, IAppCache imAppCache, String cacheKeyPrefix) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            Long deptId = (Long)deptIds.get(0);
            this.getModel().setValue("dept", (Object)deptId);
            this.setOutDept4TransBill(deptId);
            imAppCache.put(cacheKeyPrefix + "_" + "dept", (Object)deptId);
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            this.getModel().setValue("dept", (Object)orgId);
            this.setOutDept4TransBill(orgId);
            imAppCache.put(cacheKeyPrefix + "_" + "dept", (Object)orgId);
        }
    }

    private void initOperatorAndGroup(long userId, Map<Object, DynamicObject> operatorGroupMap, IAppCache imAppCache, String cacheKeyPrefix) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            String formId = this.getModel().getDataEntityType().getName();
            if (operator != null && !"im_initbill".equals(formId)) {
                this.getModel().setValue("operator", operator.getPkValue());
                this.getModel().setValue("operatorgroup", (Object)operator.getLong("operatorgrpid"));
                imAppCache.put(cacheKeyPrefix + "operator", operator.getPkValue());
                imAppCache.put(cacheKeyPrefix + "operatorgroup", (Object)operator.getLong("operatorgrpid"));
            } else {
                this.getModel().setValue("operator", null);
                this.getModel().setValue("operatorgroup", null);
                imAppCache.put(cacheKeyPrefix + "operator", (Object)"null");
                imAppCache.put(cacheKeyPrefix + "operatorgroup", (Object)"null");
            }
        }
    }

    public void initInvSchemeData() {
        if (this.noInvScheme()) {
            return;
        }
        IFormView view = this.getView();
        IDataModel bill = view.getModel();
        DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
        if (bizType == null) {
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        DynamicObject invScheme = InvSchemeHelper.getInvSchemeByEntityAndBizType((String)formId, (Long)bizType.getLong("id"));
        Object invSchemeId = null;
        if (invScheme != null) {
            invSchemeId = invScheme.getPkValue();
        }
        this.getModel().setValue("invscheme", invSchemeId);
        InverseBillHelper.setNegativeColumnColor((IFormView)this.getView(), (String[])this.getNeedInverseColumns());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        CloseDateHelper.initBookDate((String)this.getView().getEntityId(), (DynamicObject)this.getModel().getDataEntity(true));
        if (this.noInvScheme()) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"ImBillEditPlugin", (String)"afterCopyData");){
            this.setInvSchemeView(this.getView());
            boolean negativeBill = InverseBillHelper.isNegativeBill((IDataModel)this.getModel());
            if (negativeBill) {
                InverseBillHelper.setInverseValues((IDataModel)this.getModel(), (String[])this.getNeedInverseColumns());
            }
            IDataModel model = this.getModel();
            model.setValue("ischargeoff", (Object)Boolean.FALSE);
            model.setValue("ischargeoffed", (Object)Boolean.FALSE);
            if (!this.isDrawByBOTP()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"addrow"});
            }
            this.initMaterialName();
        }
    }

    private void initMaterialName() {
        String formId = this.getModel().getDataEntityType().getName();
        if (!formId.equals("im_initbill")) {
            DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject materialInvInfo = entry.getDynamicObject("material");
                String materialname = entry.getString("materialname");
                if (materialInvInfo == null || !materialname.equals("")) continue;
                DynamicObject material = materialInvInfo.getDynamicObject("masterid");
                if (material == null) {
                    return;
                }
                boolean isdisposable = material.getBoolean("isdisposable");
                this.getModel().setValue("materialname", (Object)material.getString("name"), i);
                this.getView().setEnable(Boolean.valueOf(isdisposable), i, new String[]{"materialname"});
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        super.afterAddRow(e);
        String formId = this.getModel().getDataEntityType().getName();
        if (!this.noInvScheme() && "billentry".equals(entryName = e.getEntryProp().getName())) {
            RowDataEntity[] rows = e.getRowDataEntities();
            IFormView view = this.getView();
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                this.initNewDataEntry(view, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location", "materialname"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
                if ("im_initbill".equals(formId)) continue;
                this.initNewEntryLineType(rowIndex);
                this.getView().updateView("linetype", rowIndex);
            }
        }
        LogisticsBillModel logisticsBillModel = LogisticsBillModel.getInstance();
        logisticsBillModel.matchLogisticsBill(this.getModel());
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        super.beforeDeleteRow(e);
        for (int index : rowIndexs = e.getRowIndexs()) {
            MatchingRuleOutPageCache.deleteMatchInfoPageCache((int)index, (IFormView)this.getView(), (String)"billentry");
        }
    }

    protected void initNewDataEntry(IFormView view, int rowIndex) {
        Object matchingrule = view.getFormShowParameter().getCustomParam("matchingrule");
        if (null != matchingrule) {
            return;
        }
        this.initNewEntryScheme(rowIndex);
    }

    private void initNewEntryScheme(int rowIndex) {
        if (this.noInvScheme()) {
            return;
        }
        DynamicObject invScheme = this.getInvScheme();
        InvSchemeHelper.initEntrysValue((IFormView)this.getView(), (DynamicObject)invScheme, (int[])new int[]{rowIndex});
        InvSchemeHelper.setEntrySchemeEnable((InvSchemeService)this.getInvSchemeService(), (IFormView)this.getView(), (int)rowIndex);
        InvSchemeHelper.setDefalutOwnerAndKeeeper((InvSchemeService)this.getInvSchemeService(), (IFormView)this.getView(), (int)rowIndex);
    }

    private DynamicObject getInvScheme() {
        IDataModel bill;
        DynamicObject scheme;
        if (this.invScheme == null && (scheme = (DynamicObject)(bill = this.getModel()).getValue("invscheme")) != null && scheme.getPkValue() != null) {
            this.invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        }
        return this.invScheme;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean aBoolean;
        int[] curRows;
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("sn_addrow".equals(key) && (curRows = BillViewHelper.getCurrentRowIndexs((IFormView)this.getView(), (String)"billentry")).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u5f55\u884c\u3002", (String)"ImBillEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if ("bar_copy".equals(key) && (aBoolean = this.getModel().getDataEntity().getBoolean("ischargeoff"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ImBillEditPlugin_33", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (DRAW.equals(key)) {
            String formId = this.getModel().getDataEntityType().getName();
            String orgKey = null;
            orgKey = "im_transdirbill".equals(formId) ? "outorg" : "org";
            Object org = this.getModel().getValue(orgKey);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ImBillEditPlugin_38", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
        if ("fillbatch".equals(key)) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("batchBtn", key);
            FillBatchHelper.checkCancelBeforeBatchFill((IFormView)this.getView(), (BeforeItemClickEvent)evt);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try (TraceSpan span = Tracer.create((String)"ImBillEditPlugin", (String)"afterBindData");){
            this.handleVisible();
            this.handleHeadEnable();
        }
    }

    private void setInvSchemeView(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        DynamicObject invScheme = (DynamicObject)model.getValue("invscheme");
        if (invScheme == null || bizType == null) {
            return;
        }
        DynamicObjectCollection bizTypeCollection = invScheme.getDynamicObjectCollection("bitypeentry");
        for (DynamicObject entity : bizTypeCollection) {
            Object bizTypeId = entity.get("biztype_id");
            if (!bizTypeId.equals(bizType.getPkValue()) || !entity.getBoolean("allowmanualadd")) continue;
            return;
        }
        view.getModel().setValue("invscheme", null);
    }

    private void handleEntryInvScheme(RowDataEntity entry) {
        String entityTypeId = this.getModel().getDataEntityType().getName();
        InvSchemeService service = InvSchemeServiceFactory.getService((String)entityTypeId);
        if (service != null) {
            service.setView(this.getView());
        }
        InvSchemeHelper.setEntrySchemeEnable((InvSchemeService)service, (String)entityTypeId, (RowDataEntity)entry);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "fillbatch": {
                FillBatchHelper.batchFill((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        FillBatchHelper.batchSetPredicate((IFormView)this.getView(), (BeforeBatchFillEntryArgs)e);
    }

    public void handleLotMainFileNumber(AbstractBillPlugIn plugin, String itemKey) {
        IDataModel model = plugin.getView().getModel();
        DynamicObject bill = model.getDataEntity();
        String billtype = bill.getDataEntityType().getName();
        String lotID = "lot";
        String lotnumber = "lotnumber";
        if ("im_transdirbill".equals(billtype)) {
            lotID = "inlot";
            lotnumber = "inlotnumber";
        }
        String lotidField = "billentry." + lotID;
        IFormView view = plugin.getView();
        DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
        LotMainFileHelper.handleLotMainFileNumber((IFormView)view, (DynamicObject)bill, (DynamicObjectCollection)entryEntity, (String)itemKey, (String)lotidField, (String)lotnumber);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        block30: {
            MessageBoxResult result;
            String callBackId;
            block31: {
                List entryInfoList;
                block32: {
                    block29: {
                        super.confirmCallBack(e);
                        callBackId = e.getCallBackId();
                        result = e.getResult();
                        if (!"MaterialLifeDate".equals(callBackId)) break block29;
                        String customVaule = e.getCustomVaule();
                        List alertMsgList = (List)SerializationUtils.fromJsonString((String)customVaule, List.class);
                        int[] needDeleteRows = new int[alertMsgList.size()];
                        boolean deleteEntry = false;
                        for (int i = 0; i < alertMsgList.size(); ++i) {
                            Map params = (Map)alertMsgList.get(i);
                            Date newExpirydate = this.parseDate((String)params.get("newExpiryDate"));
                            Date newProducedate = this.parseDate((String)params.get("newProduceDate"));
                            int rowIndex = (Integer)params.get("index");
                            if (null != params.get("deleteEntry")) {
                                deleteEntry = (Boolean)params.get("deleteEntry");
                            }
                            if (MessageBoxResult.Yes.equals((Object)result)) {
                                this.setValue("expirydate", newExpirydate, rowIndex, false);
                                this.setValue("producedate", newProducedate, rowIndex, false);
                                continue;
                            }
                            if (deleteEntry) {
                                needDeleteRows[i] = rowIndex;
                                continue;
                            }
                            this.setValue("producedate", null, rowIndex, false);
                            this.setValue("expirydate", null, rowIndex, false);
                        }
                        if (MessageBoxResult.Cancel.equals((Object)result) && deleteEntry) {
                            this.getModel().deleteEntryRows("billentry", needDeleteRows);
                        }
                        break block30;
                    }
                    if (!"bar_matchingrule".equals(callBackId)) break block31;
                    String customValue = e.getCustomVaule();
                    entryInfoList = null;
                    if (StringUtils.isNotBlank((CharSequence)customValue)) {
                        entryInfoList = (List)SerializationUtils.fromJsonString((String)customValue, ArrayList.class);
                    }
                    if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break block32;
                    if (CollectionUtils.isNotEmpty((Collection)entryInfoList)) {
                        new MatchingRuleOutOldFormHelper((AbstractBillPlugIn)this, this.isDrawByBOTP()).insertEntry(entryInfoList);
                    }
                    break block30;
                }
                if (!CollectionUtils.isNotEmpty((Collection)entryInfoList)) break block30;
                MatchingRuleOutHelper.resetMatchInfoPageCache((IFormView)this.getView());
                break block30;
            }
            if ("cb_matchruleout_new".equals(callBackId)) {
                MatchingRuleOutNewHelper.confirmCallBack((IFormView)this.getView(), (MessageBoxClosedEvent)e);
            } else if ("clearSupplierOrEntry".equals(callBackId)) {
                String customValue = e.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customValue)) {
                    return;
                }
                Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
                String formId = this.getModel().getDataEntityType().getName();
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    if (!"im_locationtransfer".equals(formId)) {
                        this.dealWithInvScheme(confirmInfo);
                    }
                    this.dealWithSupplier(confirmInfo);
                    if ("im_saloutbill".equals(formId)) {
                        this.getPageCache().put("completeDeleteKitRows", "false");
                    }
                    this.dealWithMaterialAndOwner(confirmInfo);
                } else {
                    Object oldBizTypeId = confirmInfo.get("oldBizTypeId");
                    this.setValue("biztype", oldBizTypeId, false);
                }
            } else if ("checkWipeQty".equals(callBackId)) {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("afterconfirm", "true");
                    this.getView().invokeOperation("unaudit", operateOption);
                }
            } else if ("clearMaterial".equals(callBackId)) {
                String customValue = e.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customValue)) {
                    return;
                }
                Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    int rowIndex = (Integer)confirmInfo.get("rowIndex");
                    this.setValue("material", null, rowIndex, true);
                    this.setValue("materialname", null, rowIndex, false);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
                } else {
                    Object oldLineTypeId = confirmInfo.get("oldLineTypeId");
                    this.setValue("linetype", oldLineTypeId, false);
                }
            } else if ("clearsettlecurrency".equals(callBackId)) {
                if (MessageBoxResult.Cancel.equals((Object)result)) {
                    String customValue = e.getCustomVaule();
                    if (StringUtils.isBlank((CharSequence)customValue)) {
                        return;
                    }
                    Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
                    Object oldCurrency = confirmInfo.get("oldVal");
                    this.setValue("settlecurrency", oldCurrency, false);
                    return;
                }
                int entryRowCount = this.getModel().getEntryRowCount("billentry");
                List<String> fields = Arrays.asList("discountrate", "price");
                for (int i = 0; i < entryRowCount; ++i) {
                    for (String field : fields) {
                        this.getModel().setValue(field, null, i);
                    }
                }
            }
        }
    }

    private void dealWithInvScheme(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        if (confirmInfo.get("newBizTypeId") == null) {
            this.getModel().setValue("invscheme", null);
            return;
        }
        Object invSchemeId = null;
        Long newBizTypeId = (Long)confirmInfo.get("newBizTypeId");
        DynamicObject invScheme = InvSchemeHelper.getInvSchemeByEntityAndBizType((String)formId, (Long)newBizTypeId);
        if (invScheme != null) {
            invSchemeId = invScheme.getPkValue();
        }
        this.getModel().setValue("invscheme", invSchemeId);
    }

    private void dealWithMaterialAndOwner(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        List clearEntryIndexList = (List)confirmInfo.get("clearEntryIndexList");
        if (clearEntryIndexList.size() != 0) {
            int[] clearEntryIndex = new int[clearEntryIndexList.size()];
            for (int i = 0; i < clearEntryIndexList.size(); ++i) {
                clearEntryIndex[i] = (Integer)clearEntryIndexList.get(i);
            }
            model.deleteEntryRows("billentry", clearEntryIndex);
            int rowCount = model.getEntryRowCount("billentry");
            if (rowCount == 0) {
                model.createNewEntryRow("billentry");
            }
        }
    }

    private void dealWithSupplier(Map<Object, Object> confirmInfo) {
        if (confirmInfo.isEmpty()) {
            return;
        }
        boolean clearSupplier = false;
        Object clear = confirmInfo.get("clearSupplier");
        if (null != clear) {
            clearSupplier = (Boolean)clear;
        }
        if (clearSupplier) {
            String formId = this.getModel().getDataEntityType().getName();
            if (formId.equals("im_materialreqoutbill")) {
                this.getModel().setValue("supplyowner", null);
            } else if (formId.equals("im_purinbill") || formId.equals("im_purreceivebill")) {
                this.getModel().setValue("supplier", null);
            }
        }
    }

    private Date parseDate(String dateStr) {
        Date date;
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImBillEditPlugin_10", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        return date;
    }

    /*
     * Unable to fully structure code
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        operateKey = e.getOperateKey();
        operationResult = e.getOperationResult();
        var4_4 = operateKey;
        var5_5 = -1;
        switch (var4_4.hashCode()) {
            case -5031951: {
                if (!var4_4.equals("unsubmit")) break;
                var5_5 = 0;
                break;
            }
            case -293878558: {
                if (!var4_4.equals("unaudit")) break;
                var5_5 = 1;
                break;
            }
            case 714774942: {
                if (!var4_4.equals("scmcavbinvquery")) break;
                var5_5 = 2;
                break;
            }
            case 754187737: {
                if (!var4_4.equals("inscmcavbinvquery")) break;
                var5_5 = 3;
                break;
            }
            case 3522941: {
                if (!var4_4.equals("save")) break;
                var5_5 = 4;
                break;
            }
            case -891535336: {
                if (!var4_4.equals("submit")) break;
                var5_5 = 5;
                break;
            }
            case 93166555: {
                if (!var4_4.equals("audit")) break;
                var5_5 = 6;
                break;
            }
            case -484329771: {
                if (!var4_4.equals("batchfillentry")) break;
                var5_5 = 7;
            }
        }
        switch (var5_5) {
            case 0: 
            case 1: {
                span = Tracer.create((String)"ImBillEditPlugin", (String)("afterDoOperation: " + operateKey));
                var7_7 = null;
                this.handleHeadEnable();
                this.handleEntryEnable();
                if (operationResult.isSuccess()) {
                    this.handInverseBill();
                }
                if (span == null) break;
                if (var7_7 == null) ** GOTO lbl55
                try {
                    span.close();
                }
                catch (Throwable var8_8) {
                    var7_7.addSuppressed(var8_8);
                }
                break;
lbl55:
                // 1 sources

                span.close();
                break;
                catch (Throwable var8_9) {
                    try {
                        var7_7 = var8_9;
                        throw var8_9;
                    }
                    catch (Throwable var9_10) {
                        if (span != null) {
                            if (var7_7 != null) {
                                try {
                                    span.close();
                                }
                                catch (Throwable var10_11) {
                                    var7_7.addSuppressed(var10_11);
                                }
                            } else {
                                span.close();
                            }
                        }
                        throw var9_10;
                    }
                }
            }
            case 2: 
            case 3: {
                InvAvbQtyQueryHelper.setAvbQtyInfo((IFormView)this.getView());
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                if (!operationResult.isSuccess()) break;
                this.handInverseBill();
                break;
            }
            case 7: {
                FillBatchHelper.afterBatchFillEntry((IFormView)this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    private void handInverseBill() {
        if (InverseBillHelper.isNegativeBill((IDataModel)this.getModel())) {
            String[] needInverseColumns = this.getNeedInverseColumns();
            InverseBillHelper.setInverseValues((IDataModel)this.getModel(), (String[])needInverseColumns);
            InverseBillHelper.setRedColumn((IFormView)this.getView(), (String[])needInverseColumns);
            EntryGrid control = (EntryGrid)this.getControl("billentry");
            control.summary();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (InverseBillHelper.isNegativeBill((IDataModel)this.getModel())) {
            IPageCache pageCache = this.getView().getPageCache();
            String checkDataChange = pageCache.get("CheckDataChange");
            boolean noDataChange = StringUtils.isNotEmpty((CharSequence)checkDataChange) && "false".equalsIgnoreCase(checkDataChange);
            String billStatus = (String)this.getModel().getValue("billstatus");
            String billStatusKeySave = "A";
            if (noDataChange || !billStatusKeySave.equals(billStatus)) {
                e.setCheckDataChange(false);
            }
        }
    }

    private String getOperatorGroupType() {
        return OperatorGrpTypeEnum.INVENTORYGRP.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "matchingruleout": {
                IFormView view = this.getView();
                String formid = this.getModel().getDataEntityType().getName();
                Map cfgs = MatchingRuleOutHandler.getInvQueryCfgs((String)formid, (String)"billentry", (String)opKey);
                if (cfgs == null || cfgs.isEmpty()) {
                    log.info("matchingruleout old");
                    try {
                        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5339\u914d\u5e93\u5b58\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ImBillEditPlugin_35", (String)"scmc-im-formplugin", (Object[])new Object[0]);
                        LocaleString info = new LocaleString(msg);
                        view.showLoading(info);
                        new MatchingRuleOutOldFormHelper((AbstractBillPlugIn)this, this.isDrawByBOTP()).matchingRuleOut(args);
                        break;
                    }
                    catch (Exception e) {
                        log.info("matchingruleout:" + e.getMessage());
                        throw new KDBizException(e.getMessage());
                    }
                    finally {
                        view.hideLoading();
                    }
                }
                log.info("matchingruleout new");
                try {
                    this.matchingRuleOutNew(view, formid, "billentry", opKey);
                    break;
                }
                finally {
                    view.hideLoading();
                }
            }
            case "submit": {
                String formId = this.getModel().getDataEntityType().getName();
                Object value = this.getModel().getValue("biztype");
                if (value == null) break;
                String number = ((DynamicObject)value).getString("number");
                FormOperate operate = (FormOperate)args.getSource();
                log.info("begin\uff1a formId:" + formId + " number:" + number);
                if ((!"im_otherinbill".equals(formId) || !"350".equals(number) && !"370".equals(number)) && (!"im_otheroutbill".equals(formId) || !"351".equals(number) && !"380".equals(number))) break;
                operate.getOption().setVariableValue("notcheck_GZ001", "");
                log.info("doIf\uff1aformId:" + formId + " number:" + number);
                break;
            }
        }
    }

    private void matchingRuleOutNew(IFormView view, String formid, String entry, String operateKey) {
        EntryGrid control = (EntryGrid)this.getControl(entry);
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ImBillEditPlugin_11", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Integer> selectRowList = new ArrayList<Integer>(selectRows.length);
        String entityName = view.getModel().getDataEntityType().getName();
        for (int i = 0; i < selectRows.length; ++i) {
            Object productType;
            if ("im_saloutbill".equals(entityName) && "kitparent".equals(productType = view.getModel().getValue("kitproducttype", selectRows[i]))) continue;
            selectRowList.add(selectRows[i]);
        }
        MatchingRuleOutNewHelper.execMatchingFromView((IFormPlugin)this, (String)formid, (String)entry, (String)operateKey, (IFormView)view, selectRowList);
    }

    @Deprecated
    public void dealWithEntry(List<Map<String, Object>> insertEntryInfo, List<String> ruleList) {
        new MatchingRuleOutOldFormHelper((AbstractBillPlugIn)this, this.isDrawByBOTP()).dealWithEntry(insertEntryInfo, ruleList);
    }

    @Deprecated
    public void insertEntry(List<Map<String, Object>> insertEntryInfo) {
        new MatchingRuleOutOldFormHelper((AbstractBillPlugIn)this, this.isDrawByBOTP()).insertEntry(insertEntryInfo);
    }

    protected boolean isDrawByBOTP() {
        if (this.noInvScheme()) {
            return false;
        }
        DynamicObject bill = this.getBill(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryName());
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        DynamicObjectCollection linkColl = ((DynamicObject)entrys.get(0)).getDynamicObjectCollection(this.getEntryLinkName());
        return linkColl != null && linkColl.size() > 0;
    }

    protected String getEntryLinkName() {
        return "billentry_lk";
    }

    protected String getEntryName() {
        return "billentry";
    }

    private String[] getNeedInverseColumns() {
        String name = this.getModel().getDataEntity().getDataEntityType().getName();
        return InverseBillHelper.getNeedInverseColumns((String)name);
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (boolean)isTriggerChangeEvent);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        if (value instanceof BigDecimal) {
            BigDecimalUtils.showBigDecimalErrorTip((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)value), (String)key);
        }
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    protected void calAmonutByPriceChange(int rowIndex, String pricef, String qtyf, String amountf, String currencyf) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyf, rowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue(pricef, rowIndex);
        if (null == qty || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_QTY_NOT_NULL()));
        } else {
            int precision = this.getPrecision(currencyf, "amtprecision");
            BigDecimal amount_all = qty.multiply(price);
            ImBillEditPlugin.showAmountErrorTip(amount_all);
            this.setValue(amountf, amount_all.setScale(precision, 4), rowIndex, false);
        }
    }

    protected void calPriceByAmountChange(int rowIndex, String pricef, String qtyf, String amountf, String currencyf) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue(amountf, rowIndex);
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyf, rowIndex);
        if (null == qty || qty.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_QTY_NOT_NULL()));
        } else {
            int pricePrecision = this.getPrecision(currencyf, "priceprecision");
            BigDecimal price = amount.divide(qty, pricePrecision, 4);
            this.setValue(pricef, price, rowIndex, false);
        }
    }

    private static void showAmountErrorTip(BigDecimal amount_all) {
        if (amount_all.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_AMOUNT()));
        }
    }

    protected void calAmonutByQtyChange(int rowIndex, String pricef, String qtyf, String amountf, String currencyf) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyf, rowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue(pricef, rowIndex);
        int precision = this.getPrecision(currencyf, "amtprecision");
        BigDecimal amount_all = qty.multiply(price);
        ImBillEditPlugin.showAmountErrorTip(amount_all);
        BigDecimal amount = amount_all.setScale(precision, 4);
        this.setValue(amountf, amount, rowIndex, false);
    }

    protected int getPrecision(String currencyf, String pref) {
        int precision = 2;
        if ("priceprecision".equals(pref)) {
            return 10;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue(currencyf);
        if (currency != null) {
            precision = currency.getInt(pref);
        }
        return precision;
    }

    protected boolean isPushOrDraw(int rowIndex) {
        Object srcBillId = this.getModel().getValue("srcbillid", rowIndex);
        return srcBillId != null && !srcBillId.equals(0L);
    }

    protected void setOwnerFilter(BeforeF7SelectEvent e, String ownerType) {
        Object domain;
        Object type = this.getModel().getValue(ownerType, this.getModel().getEntryCurrentRowIndex("billentry"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject bizType = this.getModel().getDataEntity().getDynamicObject("biztype");
        if ("bd_supplier".equals(type) && bizType != null && "6".equals(domain = bizType.get("domain"))) {
            QFilter f = new QFilter("enablevmi", "=", (Object)Boolean.TRUE);
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)f);
        }
        if (!"bos_org".equals(type) || org == null) {
            return;
        }
        ArrayList array = OwnerHelper.getOwners((Long)((Long)org.getPkValue()));
        Long settleOrgId = this.getCompanyByOrg((Long)org.getPkValue());
        array.add(settleOrgId == null ? Long.valueOf(0L) : settleOrgId);
        this.setF7IdFilter(e, array.toArray());
    }

    protected void setF7IdFilter(BeforeF7SelectEvent e, Object[] ids) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        showParameter.getListFilterParameter().setFilter(filter);
    }

    protected Long getCompanyByOrg(Long bizOrgId) {
        Long settleOrgId = null;
        if (bizOrgId != null) {
            String nullStr = "empty";
            String cacheKey = "settleOrgIdcache_" + bizOrgId;
            IPageCache pageCache = this.getPageCache();
            String settleOrgIdStr = pageCache.get(cacheKey);
            if (settleOrgIdStr == null) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (map != null) {
                    settleOrgId = (Long)map.get("id");
                    if (settleOrgId != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
                        pageCache.put(cacheKey, settleOrgId.toString());
                    }
                } else {
                    pageCache.put(cacheKey, nullStr);
                }
            } else if (!nullStr.equals(settleOrgIdStr)) {
                settleOrgId = Long.valueOf(settleOrgIdStr);
            }
        }
        return settleOrgId;
    }

    private void afterCreateNewDetailData(IFormView view, IDataModel bill) {
        DynamicObjectCollection InvBillEntryList = (DynamicObjectCollection)bill.getValue("billentry");
        String formId = this.getModel().getDataEntityType().getName();
        int entrySize = InvBillEntryList.size();
        for (int i = 0; i < entrySize; ++i) {
            if (!"im_initbill".equals(formId)) {
                this.initNewEntryLineType(i);
            }
            this.setEntryRow(view, i);
        }
    }

    protected void setEntryRow(IFormView view, int rowIndex) {
        if (this.noInvScheme()) {
            return;
        }
        this.initNewDataEntry(view, rowIndex);
    }

    protected void setEntryEnable(IFormView view, int rowIndex, boolean enable, String ... fieldName) {
        view.setEnable(Boolean.valueOf(enable), rowIndex, fieldName);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (this.isNegativeBill()) {
            InverseBillHelper.setInverseValues((IDataModel)this.getModel(), (String[])this.getNeedInverseColumns());
        }
        this.initMaterialName();
    }

    protected DynamicObject getBill() {
        return this.getBill(false);
    }

    protected DynamicObject getBill(boolean hasEntry) {
        if (this.bill == null) {
            this.bill = this.getModel().getDataEntity(hasEntry);
        }
        return this.bill;
    }

    protected void handleVisible() {
        this.handleInverse();
        this.handleIvnScheme();
        this.handleSupplyTrans();
    }

    protected void handleSupplyTrans() {
        if (InvDirectTranHelper.isSupplyTrans((DynamicObject)this.getModel().getDataEntity())) {
            InvDirectTranHelper.setEntryButtonEnable((IFormView)this.getView(), (boolean)true);
        }
    }

    protected void handleIvnScheme() {
        if (this.noInvScheme()) {
            return;
        }
        DynamicObject invScheme = this.getInvScheme();
        boolean isInUpdate = false;
        boolean isOutUpdate = false;
        if (invScheme != null) {
            isInUpdate = invScheme.getBoolean("isinupdate");
            isOutUpdate = invScheme.getBoolean("isoutupdate");
        }
        InvSchemeHelper.setViewByUpdate((IFormView)this.getView(), (boolean)isInUpdate, (boolean)isOutUpdate);
        InvSchemeHelper.setSpecialEnable((IFormView)this.getView(), (DynamicObject)invScheme);
    }

    private void handleInverse() {
        boolean isRedBill = this.isNegativeBill();
        if (!isRedBill) {
            return;
        }
        InverseBillHelper.setRedColumn((IFormView)this.getView(), (String[])this.getNeedInverseColumns());
    }

    private boolean isNegativeBill() {
        this.initRedBillflag();
        return !NegativeEnum.BlueBill.getValue().equals(this.redBill);
    }

    private void initRedBillflag() {
        if (this.redBill != null) {
            return;
        }
        if (this.noInvScheme()) {
            this.redBill = NegativeEnum.BlueBill.getValue();
            return;
        }
        boolean negativeBill = InverseBillHelper.isNegativeBill((IDataModel)this.getModel());
        this.redBill = negativeBill ? NegativeEnum.RedBill.getValue() : NegativeEnum.BlueBill.getValue();
    }

    protected void handleHeadEnable() {
        if ("A".equals(this.getBill().getString("billstatus"))) {
            this.setHeadEnable();
            this.setEnable4IsDraw(this.isDrawByBOTP());
            this.handleMatchingRuleEnable();
        }
    }

    protected void setHeadEnable() {
        IFormView view = this.getView();
        view.setEnable(Boolean.FALSE, new String[]{"operatorgroup"});
        view.setEnable(Boolean.FALSE, new String[]{"bizoperatorgroup"});
        boolean bookdateEnable = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004");
        view.setEnable(Boolean.valueOf(!bookdateEnable), new String[]{"bookdate"});
        if (!bookdateEnable) {
            DateEdit bookdateDateEdit = (DateEdit)view.getControl("bookdate");
            bookdateDateEdit.hideTips();
        }
    }

    protected void handleEntryEnable() {
        String formId = this.getModel().getDataEntityType().getName();
        if (!"im_initbill".equals(formId)) {
            DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject material;
                boolean isdisposable;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject materialInvInfo = entry.getDynamicObject("material");
                if (materialInvInfo == null || (isdisposable = (material = materialInvInfo.getDynamicObject("masterid")).getBoolean("isdisposable"))) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"materialname"});
            }
        }
    }

    private void handleMatchingRuleEnable() {
        boolean enable = true;
        if (this.isNegativeBill()) {
            enable = false;
        }
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"matchingruleout"});
    }

    private void setEntryEnable(RowDataEntity entry, DynamicObject localBill, boolean isDraw, boolean isInitBill) {
        this.handleEntryEnable(localBill, entry, isDraw);
        if (!isInitBill) {
            this.handleEntryInvScheme(entry);
        }
    }

    protected void setEnable4IsDraw(boolean isDraw) {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(!isDraw), new String[]{"org", "bizorg", "biztype", "billtype", "bizdept", "bizoperator", "bizoperatorgroup", "addrow"});
        String formId = this.getModel().getDataEntityType().getName();
        boolean isPurIn = "im_purinbill".equals(formId);
        boolean isSalOut = "im_saloutbill".equals(formId);
        boolean isPurReceive = "im_purreceivebill".equals(formId);
        if (isPurIn || isSalOut || isPurReceive) {
            view.setEnable(Boolean.valueOf(!isDraw), new String[]{"paymode"});
        }
        if (isSalOut) {
            view.setEnable(Boolean.valueOf(!isDraw), new String[]{"customer", "settlecurrency"});
        }
    }

    protected void handleEntryEnable(DynamicObject bill, RowDataEntity row, boolean isDraw) {
        if ("A".equals(bill.getString("billstatus"))) {
            this.setBillEntryEnable(row);
            this.setBillEntryEnable4IsDraw(row, isDraw);
        }
    }

    protected void setBillEntryEnable(RowDataEntity row) {
        DynamicObject entry = row.getDataEntity();
        int rowIndex = row.getRowIndex();
        IFormView view = this.getView();
        this.setEnableByMaterial(entry, rowIndex, view);
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        boolean isOpenLocation = warehouse != null && warehouse.getBoolean("isopenlocation");
        view.setEnable(Boolean.valueOf(isOpenLocation), rowIndex, new String[]{"location"});
    }

    protected void setPriceEnable(boolean isPresent, boolean isTax, int index) {
        if (isPresent) {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{isTax ? "priceandtax" : "price"});
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{!isTax ? "priceandtax" : "price"});
        } else {
            this.getView().setEnable(Boolean.valueOf(!isTax), index, new String[]{"price"});
            this.getView().setEnable(Boolean.valueOf(isTax), index, new String[]{"priceandtax"});
        }
    }

    protected void setByIspresent(Object price, boolean ispresent, int rowIndex) {
        if (!ispresent) {
            return;
        }
        if (BigDecimal.ZERO.compareTo((BigDecimal)price) == 0) {
            this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            this.getModel().setValue("discountrate", (Object)Constants.ZERO, rowIndex);
        } else {
            this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
            this.getModel().setValue("discountrate", (Object)Constants.ONE_HUNDRED, rowIndex);
        }
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate", "discounttype", "discountamount"});
    }

    protected void presentChange(Object price, boolean ispresent, int rowIndex) {
        if (!ispresent) {
            this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            this.getModel().setValue("discountrate", (Object)Constants.ZERO, rowIndex);
        } else {
            if (BigDecimal.ZERO.compareTo((BigDecimal)price) == 0) {
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                this.getModel().setValue("discountrate", (Object)Constants.ZERO, rowIndex);
            } else {
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                this.getModel().setValue("discountrate", (Object)Constants.ONE_HUNDRED, rowIndex);
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate", "discounttype", "discountamount"});
        }
    }

    private void setEnableByMaterial(DynamicObject entry, int index, IFormView view) {
        boolean isdisposable;
        DynamicObject stockMaterial = entry.getDynamicObject("material");
        if (stockMaterial == null) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"configuredcode", "materialname"});
            return;
        }
        this.getView().setEnable(Boolean.valueOf("2".equals(stockMaterial.get("masterid.configproperties"))), index, new String[]{"configuredcode"});
        DynamicObject material = null;
        if (!"bd_material".equals(stockMaterial.getDataEntityType().getName())) {
            material = stockMaterial.getDynamicObject("masterid");
        }
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u914d\u7f6e\u6709\u8bef\uff1a\u7269\u6599\u7b56\u7565\u9700\u5f15\u7528\u7269\u6599\u201c\u542f\u7528\u8f85\u52a9\u5c5e\u6027 /isuseauxpty\u201d\u5c5e\u6027\u3002", (String)"ImBillEditPlugin_32", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        String formId = this.getModel().getDataEntityType().getName();
        if (!"im_initbill".equals(formId) && !(isdisposable = material.getBoolean("isdisposable"))) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"materialname"});
        }
        boolean isUseAuxpty = material.getBoolean("isuseauxpty");
        view.setEnable(Boolean.valueOf(isUseAuxpty), index, new String[]{"auxpty"});
        DynamicObject unit2nd = material.getDynamicObject("auxptyunit");
        view.setEnable(Boolean.valueOf(unit2nd != null), index, new String[]{"qtyunit2nd"});
        boolean enableLot = stockMaterial.getBoolean("enablelot");
        view.setEnable(Boolean.valueOf(enableLot), index, new String[]{"lotnumber"});
        view.setEnable(Boolean.valueOf(enableLot), index, new String[]{"lot"});
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        boolean isopenlocation = warehouse != null && warehouse.getBoolean("isopenlocation");
        view.setEnable(Boolean.valueOf(isopenlocation), index, new String[]{"location"});
        boolean isEnableShelfLife = stockMaterial.getBoolean("enableshelflifemgr");
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"producedate"});
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"expirydate"});
        long srcbillid = 0L;
        if (!formId.equals("im_locationtransfer")) {
            srcbillid = entry.getLong("srcbillid");
        }
        boolean enableSerialNum = SerialNumberHelper.isEnableSerial((DynamicObject)stockMaterial) && srcbillid == 0L;
        view.setEnable(Boolean.valueOf(enableSerialNum), index, new String[]{"serialnumber"});
    }

    protected void setBillEntryEnable4IsDraw(RowDataEntity row, boolean isDraw) {
        if (isDraw) {
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"material", "model", "unit", "linetype", "materialname", "tracknumber", "configuredcode"});
            if (MetaDataHelper.isExistField((IDataModel)this.getModel(), (String)"ecostcenter")) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(i);
                    DynamicObject costCenter = entry.getDynamicObject("ecostcenter");
                    if (costCenter != null) {
                        view.setEnable(Boolean.FALSE, i, new String[]{"ecostcenter"});
                        continue;
                    }
                    view.setEnable(Boolean.TRUE, i, new String[]{"ecostcenter"});
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "msmod_selectlot": {
                this.closedSelectedLot(e);
                break;
            }
        }
    }

    public static void setControlMustInput(IFormView view, boolean isMustInput, String ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            FieldEdit control = (FieldEdit)view.getControl(keys[i]);
            if (control == null) continue;
            control.setMustInput(isMustInput);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        try (TraceSpan span = Tracer.create((String)"ImBillEditPlugin", (String)"entryGridBindData");){
            String isInvQueryCallBack;
            this.handleInverse();
            DynamicObject localBill = this.getBill(true);
            boolean isDraw = this.isDrawByBOTP();
            boolean initBill = this.noInvScheme();
            List entities = e.getRows();
            entities.forEach(entry -> this.setEntryEnable((RowDataEntity)entry, localBill, isDraw, initBill));
            if (isDraw) {
                InspectionHelper.handleQtyEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)((Long)this.getBill().getPkValue()));
            }
            if (StringUtils.isNotBlank((CharSequence)(isInvQueryCallBack = this.getView().getPageCache().get("isinvquerycallback")))) {
                LogisticsBillModel logisticsBillModel = LogisticsBillModel.getInstance();
                logisticsBillModel.matchLogisticsBill(this.getModel());
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String createType;
        IDataModel bill = this.getModel();
        BillModel billModel = (BillModel)bill;
        String formId = this.getModel().getDataEntityType().getName();
        CloseDateHelper.initBookDate((String)formId, (DynamicObject)bill.getDataEntity(true));
        boolean isFromWebApi = billModel.isFromWebApi();
        boolean isFromImport = billModel.isFromImport();
        if (!isFromWebApi && !isFromImport) {
            return;
        }
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if (org == null) {
            return;
        }
        if (!("im_purreceivebill".equals(formId) || "im_purinbill".equals(formId) || "im_saloutbill".equals(formId) || "im_ospurinbill".equals(formId))) {
            this.setCurrency((Long)org.getPkValue());
        }
        if (DIRECT.equals(createType = (String)this.getModel().getValue("billcretype"))) {
            this.getModel().setValue("billcretype", (Object)"3");
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Long orgId = (Long)org.getPkValue();
        Map sourceData = e.getSourceData();
        Map dept = (Map)sourceData.get("dept");
        Map operator = (Map)sourceData.get("operator");
        this.dealDptAndOperator(formId, orgId, userId, dept, operator);
        this.dealQuotationAndExRate(org, formId);
        if (!this.noInvScheme()) {
            DynamicObject obj = bill.getDataEntity();
            DynamicObjectCollection billEntry = obj.getDynamicObjectCollection("billentry");
            DynamicObject invScheme = obj.getDynamicObject("invscheme");
            if (invScheme == null) {
                return;
            }
            ImBillBotpHelp.dealEntryScheme((DynamicObject)obj, (DynamicObjectCollection)billEntry, (DynamicObject)invScheme);
        }
        if (!"im_initbill".equals(formId)) {
            InvBillHelper.handleDefaultValueAfterImport((IDataModel)bill, (Map)sourceData, this.materialCacheMap);
        }
    }

    public String getCurrencyKey() {
        return "settlecurrency";
    }

    private void dealQuotationAndExRate(DynamicObject org, String formId) {
        String cacheKey;
        if (org == null) {
            return;
        }
        if (!("im_purreceivebill".equals(formId) || "im_purinbill".equals(formId) || "im_saloutbill".equals(formId) || "im_ospurinbill".equals(formId))) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject settleCurrency = dataEntity.getDynamicObject("settlecurrency");
        DynamicObject exchangeTab = dataEntity.getDynamicObject("exratetable");
        Date exchangeDate = dataEntity.getDate("exratedate");
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"));
        if (map == null) {
            return;
        }
        Long baseCurrencyID = (Long)map.get("baseCurrencyID");
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id, amountPrecision", (QFilter[])new QFilter("id", "=", (Object)baseCurrencyID).toArray());
        this.getModel().setValue("currency", (Object)currency);
        if (exchangeTab == null) {
            exchangeTab = BusinessDataServiceHelper.newDynamicObject((String)"bd_exratetable");
            exchangeTab.set("id", map.get("exchangeRateTableID"));
            this.getModel().setValue("exratetable", (Object)exchangeTab);
        }
        if (settleCurrency == null) {
            IDataEntityProperty supplierProp = this.getModel().getProperty("supplier");
            if (supplierProp != null && dataEntity.getDynamicObject("supplier") != null) {
                DynamicObject supplier = dataEntity.getDynamicObject("supplier");
                DynamicObject settleCur = supplier.getDynamicObject("settlementcyid");
                if (settleCur == null) {
                    dataEntity.set("settlecurrency", (Object)currency);
                } else {
                    dataEntity.set("settlecurrency", (Object)settleCur);
                }
            } else {
                return;
            }
        }
        settleCurrency = dataEntity.getDynamicObject("settlecurrency");
        if (currency == null || exchangeTab == null || settleCurrency == null || exchangeDate == null) {
            return;
        }
        long settleCurrencyId = settleCurrency.getLong("id");
        long currencyId = currency.getLong("id");
        long exRateTabId = exchangeTab.getLong("id");
        IAppCache imAppCache = BalReCalCache.getImAppCache();
        Map exchangeRateMap = (Map)imAppCache.get(cacheKey = settleCurrencyId + "_" + currencyId + "_" + exRateTabId + "_" + exchangeDate.toString().trim(), Map.class);
        if (exchangeRateMap == null) {
            exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)settleCurrency.getLong("id"), (Long)currency.getLong("id"), (Long)exchangeTab.getLong("id"), (Date)exchangeDate);
        }
        Object quoteType = exchangeRateMap.get(QUOTETYPE);
        Object exchangeRate = exchangeRateMap.get(EXCHANGERATE);
        if (quoteType != null && exchangeRate != null) {
            imAppCache.put(cacheKey, (Object)exchangeRateMap, 60);
        }
        if (currencyId == settleCurrencyId) {
            dataEntity.set("quotation", (Object)DIRECT);
        } else if (quoteType != null) {
            dataEntity.set("quotation", (Object)((Boolean)quoteType != false ? INDIRECT : DIRECT));
        }
        IDataEntityProperty exRateProp = this.getModel().getProperty("exchangerate");
        if (exRateProp != null) {
            BigDecimal exRate = dataEntity.getBigDecimal("exchangerate");
            if (exRate == null || BigDecimal.ZERO.compareTo(exRate) == 0) {
                dataEntity.set("exchangerate", exchangeRate);
            }
        } else {
            dataEntity.set("exchangerate", exchangeRate);
        }
    }

    private void dealDptAndOperator(String formId, Long orgId, long userId, Map<String, Object> dept, Map<String, Object> operator) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject operatorDy = null;
        DynamicObject deptDy = null;
        String cacheKeyPrefix = formId + "_" + orgId + "_" + userId;
        IAppCache imAppCache = BalReCalCache.getImAppCache();
        String cachedDpt = (String)imAppCache.get(cacheKeyPrefix + "_" + "dept", String.class);
        String cachedOperator = (String)imAppCache.get(cacheKeyPrefix + "_" + "operator", String.class);
        String cachedOperatorGrp = (String)imAppCache.get(cacheKeyPrefix + "_" + "operatorgroup", String.class);
        if (dataEntity != null) {
            operatorDy = dataEntity.getDynamicObject("operator");
            deptDy = dataEntity.getDynamicObject("dept");
        }
        boolean isDptEmpty = deptDy == null && (dept == null || StringUtils.isBlank((CharSequence)((String)dept.get("number"))) && (dept.get("id") == null || dept.get("id").equals(0L)));
        boolean isOperatorEmpty = operatorDy == null && (operator == null || StringUtils.isBlank((CharSequence)((String)operator.get(operator.getOrDefault("importprop", "number")))) && (operator.get("id") == null || operator.get("id").equals(0L)));
        boolean dptFlag = false;
        boolean operatorFlag = false;
        if (isDptEmpty || isOperatorEmpty) {
            if (isDptEmpty && cachedDpt != null) {
                this.getModel().setValue("dept", (Object)cachedDpt);
                dptFlag = true;
            }
            if (isOperatorEmpty && cachedOperator != null && cachedOperatorGrp != null) {
                this.getModel().setValue("operator", (Object)("null".equals(cachedOperator) ? null : cachedOperator));
                this.getModel().setValue("operatorgroup", (Object)("null".equals(cachedOperatorGrp) ? null : cachedOperatorGrp));
                if (dptFlag) {
                    return;
                }
                operatorFlag = true;
            }
            Map<Object, DynamicObject> operatorGroupMap = this.getOperatorGroupMap(orgId);
            if (isDptEmpty && !dptFlag) {
                this.initDept(userId, orgId, operatorGroupMap, imAppCache, cacheKeyPrefix);
            }
            if (isOperatorEmpty && !operatorFlag) {
                this.initOperatorAndGroup(userId, operatorGroupMap, imAppCache, cacheKeyPrefix);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": 
            case "inlotnumber": {
                this.openPageSelectLotMainfile(key);
                break;
            }
        }
    }

    private void openPageSelectLotMainfile(String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = model.getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotnumField = "billentry." + fieldKey;
        LotMainFileHelper.showPageLotMainfileList((IFormPlugin)this, (IFormView)this.getView(), (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotnumField);
    }

    private void closedSelectedLot(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("billentry");
            Map lotAttr = (Map)returnData;
            String lotidfield = (String)lotAttr.get("lotidfield");
            String lotnumfield = (String)lotAttr.get("lotnumfield");
            model.setValue(lotnumfield, lotAttr.get("lotnumber"), rowIndex);
            model.setValue(lotidfield, lotAttr.get("lotid"), rowIndex);
        }
    }

    protected void checkExchangeRate(boolean isCopy, Object exRate) {
        IDataModel model = this.getModel();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        Date exrateDate = (Date)model.getValue("exratedate");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        Long exrateTableId = exratetable == null ? null : Long.valueOf(exratetable.getLong("id"));
        boolean calByChange = true;
        String msg = null;
        if (currency != null && settleCurrency != null && exrateTableId != null && !currency.getPkValue().equals(settleCurrency.getPkValue())) {
            if (isCopy && exRate == null) {
                msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u672c\u4f4d\u5e01\u76f8\u5173\u7684\u4ef7\u7a0e\u4fe1\u606f\u672a\u66f4\u65b0\u3002", (String)"PurInBillEditPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), currency.get("name"), settleCurrency.get("name"));
            } else {
                BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)settleCurrency.getLong("id"), (Long)currency.getLong("id"), (Date)exrateDate);
                if (exchangeRate == null) {
                    msg = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u672c\u4f4d\u5e01\u76f8\u5173\u7684\u4ef7\u7a0e\u4fe1\u606f\u672a\u66f4\u65b0\u3002", (String)"PurInBillEditPlugin_12", (String)"scmc-im-formplugin", (Object[])new Object[0]), currency.get("name"), settleCurrency.get("name"));
                }
            }
            if (msg != null) {
                calByChange = false;
                ErrorCodeHelper.showErrorCode((String)msg, (String)"n", (String)"tip", null, null, (int)3, null, null, null, (AbstractFormPlugin)this);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("calByChange", (Object)calByChange);
    }

    protected void addBizFunctionFilter(BeforeF7SelectEvent e, String propName) {
        QFilter bizFunctionFilter = null;
        switch (propName) {
            case "supplier": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"4");
                break;
            }
            case "providersupplier": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)INDIRECT);
                break;
            }
            case "invoicesupplier": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"2");
                break;
            }
            case "receivesupplier": {
                bizFunctionFilter = new QFilter("bizfunction", "match", (Object)"3");
                break;
            }
        }
        if (bizFunctionFilter != null) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, bizFunctionFilter);
        }
    }

    protected void clearWarehouse(String wareHouseField, String locationField) {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("invscheme");
        if (scheme == null) {
            return;
        }
        DynamicObject invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        if (invScheme == null) {
            return;
        }
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        boolean isInUpdate = invScheme.getBoolean("isoutupdate");
        if (isInUpdate && isOutUpdate) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue(wareHouseField, null, i);
                this.getModel().setValue(locationField, null, i);
            }
        }
    }

    protected void changeOutWarehouse(ChangeData[] valueSet, String locationField) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) continue;
            int rowIndex = valueSet[i].getRowIndex();
            this.setValue(locationField, null, rowIndex, false);
            if (newValue != null) {
                boolean isOpenLocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
                if (isOpenLocation) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{locationField});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{locationField});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{locationField});
        }
    }

    protected void changeSettleCurrency(Object oldVal, Object newVal) {
        if (newVal == null && oldVal != null) {
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
            confirmInfo.put("oldVal", ((DynamicObject)oldVal).getPkValue());
            ConfirmCallBackListener cb = new ConfirmCallBackListener("clearsettlecurrency", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u7ed3\u7b97\u5e01\u79cd\u540e\uff0c\u5c06\u540c\u65f6\u6e05\u7a7a\u91d1\u989d\u76f8\u5173\u5b57\u6bb5\uff0c\u662f\u5426\u6267\u884c\u6b64\u64cd\u4f5c?", (String)"ImBillEditPlugin_40", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
            return;
        }
        if (newVal == null) {
            return;
        }
        this.setDiscountRateScale((DynamicObject)newVal);
    }

    protected void setClientViewScale() {
        Object settleCurrency = this.getModel().getValue("settlecurrency");
        if (settleCurrency == null) {
            return;
        }
        this.setDiscountRateScale((DynamicObject)settleCurrency);
    }

    private void setDiscountRateScale(DynamicObject settleCurrency) {
        int pricePrecision = settleCurrency.getInt("priceprecision");
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("billentry", "setColEditorProp", new Object[]{"discountrate", "sc", pricePrecision});
    }

    protected void checkSettleCurrencyNotNull(BeforeFieldPostBackEvent e) {
        String key = e.getKey();
        int rowIndex = e.getRowIndex();
        Object settleCurrency = this.getModel().getValue("settlecurrency");
        if ("discountrate".equals(key)) {
            Object discountType = this.getModel().getValue("discounttype", rowIndex);
            if (!DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                return;
            }
        }
        if (settleCurrency == null) {
            e.setCancel(true);
            this.getView().updateView(key, rowIndex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u5e01\u3002", (String)"ImBillEditPlugin_39", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    protected void checkAndSetDiscountRate(boolean isTax, IDataModel model, int discountRateScale, int i) {
        String discountType = (String)model.getValue("discounttype", i);
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", i);
            if (discountRate == null) {
                discountRate = BigDecimal.ZERO;
            }
            discountRate = discountRate.setScale(discountRateScale, 4);
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", i);
                if (discountRate.compareTo(priceAndTax) > 0) {
                    model.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", i);
                if (discountRate.compareTo(price) > 0) {
                    model.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                }
            }
        }
    }

    protected int getDiscountRateScale() {
        IDataModel model = this.getModel();
        int discountRateScale = 4;
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        if (settleCurrency != null) {
            discountRateScale = settleCurrency.getInt("priceprecision");
        }
        return discountRateScale;
    }

    private void setCurrency(Long orgId) {
        String currencyKey = this.getCurrencyKey();
        IDataEntityProperty prop = this.getModel().getDataEntityType().findProperty(currencyKey);
        if (prop == null) {
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            return;
        }
        Long baseCurrencyID = (Long)map.get("baseCurrencyID");
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id, amountPrecision", (QFilter[])new QFilter("id", "=", (Object)baseCurrencyID).toArray());
        if (StringUtils.isNotBlank((CharSequence)currencyKey)) {
            this.getModel().setValue(currencyKey, (Object)currency);
        }
    }
}

