/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.report.algox.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.report.IReportListModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.scmc.im.utils.FormUtils;

public class RptUtil {
    public static final long ONE_DAY = 86400000L;
    public static final String INV_REAL_BAL = "im_inv_realbalance";
    public static final String INV_PER_BAL = "im_inv_periodbalance";
    public static final String SUFFIX_INIT = "";
    public static final String SUFFIX_IN = "_in";
    public static final String SUFFIX_OUT = "_out";
    public static final String SUFFIX_BAL = "_bal";
    public static final String DATA_TYPE_IN = "0";
    public static final String DATA_TYPE_OUT = "1";
    public static final String DATA_TYPE_INIT = "2";
    public static final String DATA_TYPE_INIT_BILL = "3";
    public static final String DETAIL\uff3fAGE = "detailage";
    public static final String F_BASEDATAID = "fbasedataid";
    public static final Set<String> DATA_CTRL_FIELD = new HashSet<String>(Arrays.asList("org", "user", "operator", "operatorgroup", "dept"));

    public static boolean isNull(IReportView view, String colName) {
        boolean isNull;
        IDataModel model = view.getModel();
        boolean bl = isNull = model.getValue(colName) == null;
        if (isNull) {
            String collName = FormUtils.getColDisplayName((IDataModel)model, (String)colName);
            String msg = ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1\u4e0d\u80fd\u4e3a\u7a7a", (String)"RptUtil_2", (String)"scmc-im-report", (Object[])new Object[0]), (String)"ReportUtil_0", (String)"scmc-im-report", (Object[])new Object[]{collName});
            view.showTipNotification(msg);
        }
        return isNull;
    }

    public static DynamicObject getRptRowData(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        return reportModel.getRowData(e.getRowIndex());
    }

    private static <T> List<T> getBaseDataIds(IReportView view, String col) {
        DynamicObjectCollection dys = view.getModel().getDataEntity().getDynamicObjectCollection(col);
        return RptUtil.getBaseDataIds(dys);
    }

    public static <T> List<T> getBaseDataIds(DynamicObjectCollection dys) {
        ArrayList<Object> ids = new ArrayList<Object>(20);
        if (dys != null) {
            for (DynamicObject dy : dys) {
                ids.add(dy.getDynamicObject(F_BASEDATAID).getPkValue());
            }
        }
        return ids;
    }

    public static List<Long> getBaseDataLongIds(IReportView view, String col) {
        return RptUtil.getBaseDataIds(view, col);
    }

    public static List<Object> getBaseDataObjIds(IReportView view, String col) {
        return RptUtil.getBaseDataIds(view, col);
    }

    public static Date getShortDate(Date date) {
        return RptUtil.shortDate(date).getTime();
    }

    private static Calendar shortDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Date shortDate(Calendar calendar, Date date) {
        calendar.setTime(date);
        return RptUtil.shortDate(calendar).getTime();
    }

    private static Calendar shortDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Date getShortDate(Date date, int addDays) {
        return RptUtil.getShortDate(date, 5, addDays);
    }

    public static Date getShortDate(Date date, int addType, int addDays) {
        Calendar calendar = RptUtil.shortDate(date);
        calendar.add(addType, addDays);
        return calendar.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static int getPeriod(Date date, int addPeriod) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, addPeriod);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return year * 100 + month;
    }

    public static void buildQtyCols(Collection<String> colCollector, Collection<String> sumNumCols, Collection<Object> receiverIds) {
        ArrayList<Object> suffixs = new ArrayList<Object>(receiverIds);
        suffixs.add(SUFFIX_INIT);
        suffixs.add(SUFFIX_IN);
        suffixs.add(SUFFIX_OUT);
        suffixs.add(SUFFIX_BAL);
        RptUtil.appendSuffixs(colCollector, sumNumCols, suffixs);
    }

    public static void appendSuffixs(Collection<String> colCollector, Collection<String> cols, Collection<Object> suffixs) {
        for (String sumNumCol : cols) {
            for (Object sufixs : suffixs) {
                colCollector.add(sumNumCol + sufixs);
            }
        }
    }

    public static QFilter buildStatusFs(String statusCol, boolean includeSubmit) {
        return includeSubmit ? new QFilter(statusCol, "in", (Object)new String[]{"B", "C"}) : new QFilter(statusCol, "=", (Object)"C");
    }

    public static QFilter buildBizTimeFs(String bizTimeCol, Date from, Date to) {
        return new QFilter(bizTimeCol, ">=", (Object)from).and("biztime", "<", (Object)to);
    }

    public static int calBetweenDays(Date from, Date to) {
        long dTime = to.getTime() - from.getTime();
        return (int)(dTime / 86400000L);
    }

    public static String getDisplayProp(String type) {
        switch (type = type == null ? DATA_TYPE_OUT : type) {
            case "1": {
                return "name";
            }
            case "2": {
                return "number";
            }
            case "3": {
                return "name,number";
            }
            case "4": {
                return "number,name";
            }
        }
        return "name";
    }

    public static void rebuildCondition(FilterCondition condition, String formId) {
        DynamicObject rptConf = RptUtil.loadRptConf(formId);
        DynamicObjectCollection colEntry = rptConf.getDynamicObjectCollection("colsentry");
        HashSet<String> repoColSet = new HashSet<String>(colEntry.size());
        for (DynamicObject entry : colEntry) {
            String repoCol = entry.getString("repo_col");
            String calType = entry.getString("caltype");
            if ("D".equals(calType)) continue;
            repoColSet.add(repoCol);
        }
        if (repoColSet.isEmpty()) {
            return;
        }
        List filterRow = condition.getFilterRow();
        Iterator iterator = filterRow.iterator();
        while (iterator.hasNext()) {
            String fieldName;
            SimpleFilterRow next = (SimpleFilterRow)iterator.next();
            String key = fieldName = next.getFieldName();
            if (fieldName.contains(".")) {
                key = fieldName.substring(0, fieldName.indexOf("."));
            }
            if (repoColSet.contains(key)) continue;
            iterator.remove();
        }
    }

    private static DynamicObject loadRptConf(String formId) {
        QFilter fs = new QFilter("report", "=", (Object)formId).and("status", "=", (Object)DATA_TYPE_OUT);
        Map confInfo = BusinessDataReader.loadFromCache((String)"scmc_report_conf", (QFilter[])fs.toArray());
        if (!confInfo.isEmpty()) {
            DynamicObject[] cfs = confInfo.values().toArray(new DynamicObject[0]);
            return cfs[0];
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bfb\u53d6\u5230\u542f\u7528\u7684\u62a5\u8868\u914d\u7f6e\u3002", (String)"RptUtil_1", (String)"scmc-im-report", (Object[])new Object[0]));
    }
}

