/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.opplugin.mdc.mftmanuinbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.common.mdc.consts.XMftOrderChangeLogConsts;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import kd.scmc.im.common.mdc.utils.AutoBackFlushUtils;
import kd.scmc.im.common.mdc.utils.MDCDyObjUtil;
import kd.scmc.im.common.mdc.utils.MftReqOutBillUtil;
import kd.scmc.im.common.mdc.utils.MftRowLinkUtils;
import kd.scmc.im.opplugin.mdc.MFTReqOutWarehouseValidator;
import kd.scmc.im.opplugin.mdc.OmInBillAuditOrUnauditOpValidator;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.CompletePickValidator;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.ManuFactureorderInwarehsBillValidator;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.ManuFactureorderInwarehsBillXMFTValidator;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.ManuFactureorderInwarehsBizDateValidator;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.ManuFactureorderInwarehsJoinProductValidator;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.MftManuInBillAuditUtils;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.MftOrderCalWriteUtils;
import kd.scmc.im.opplugin.mdc.mftmanuinbill.MftOrderChargeAgainstUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MftManuInBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MftManuInBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("ischargeoff");
        e.getFieldKeys().add("ischargeoffed");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("invscheme");
        e.getFieldKeys().add("bookdate");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("isvirtualbill");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billentry.manubill");
        e.getFieldKeys().add("billentry.manubillid");
        e.getFieldKeys().add("billentry.manuentry");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.producttype");
        e.getFieldKeys().add("billentry.qualitystatus");
        e.getFieldKeys().add("billentry.material");
        e.getFieldKeys().add("billentry.receivalqty");
        e.getFieldKeys().add("billentry.receivedqty");
        e.getFieldKeys().add("billentry.qty");
        e.getFieldKeys().add("billentry.baseqty");
        e.getFieldKeys().add("billentry.location");
        e.getFieldKeys().add("billentry.srcbillnumber");
        e.getFieldKeys().add("billentry.srcbillentity");
        e.getFieldKeys().add("billentry.srcbillid");
        e.getFieldKeys().add("billentry.srcbillentryseq");
        e.getFieldKeys().add("billentry.srcbillentryid");
        e.getFieldKeys().add("billentry.mainbillnumber");
        e.getFieldKeys().add("billentry.mainbillentity");
        e.getFieldKeys().add("billentry.mainbillid");
        e.getFieldKeys().add("billentry.mainbillentryseq");
        e.getFieldKeys().add("billentry.mainbillentryid");
        e.getFieldKeys().add("productionorg");
        e.getFieldKeys().add("billentry.id");
        e.getFieldKeys().add("billentry.manuentryid");
        e.getFieldKeys().add("billentry.manubillid");
        e.getFieldKeys().add("billentry.backflushstatus");
        e.getFieldKeys().add("billentry.isadd");
        e.getFieldKeys().add("billentry.materialmasterid");
        e.getFieldKeys().add("billentry.baseunit");
        e.getFieldKeys().add("billentry.workshopid");
        e.getFieldKeys().add("billentry.auxpty");
        e.getFieldKeys().add("billentry.lotnumber");
        e.getFieldKeys().add("billentry.unit2nd");
        e.getFieldKeys().add("billentry.tracknumber");
        e.getFieldKeys().add("billentry.configuredcode");
        e.getFieldKeys().add("billentry.qtyunit2nd");
        e.getFieldKeys().add("billentry.pid");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.billentry_lk");
        e.getFieldKeys().add("billentry.materialname");
        e.getFieldKeys().add("billentry.producedept");
        e.getFieldKeys().add("billentry.ecostcenter");
        e.getFieldKeys().add("billentry.vin");
        e.getFieldKeys().add("zhny_innercatnum");
        e.getFieldKeys().add("productiondomain");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ManuFactureorderInwarehsBillValidator());
        e.addValidator((AbstractValidator)new OmInBillAuditOrUnauditOpValidator());
        e.addValidator((AbstractValidator)new ManuFactureorderInwarehsBillXMFTValidator());
        e.addValidator((AbstractValidator)new CompletePickValidator());
        e.addValidator((AbstractValidator)new ManuFactureorderInwarehsBizDateValidator());
        e.addValidator((AbstractValidator)new ManuFactureorderInwarehsJoinProductValidator());
        e.addValidator((AbstractValidator)new MFTReqOutWarehouseValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        String productiondomain = "A";
        if (dataArray != null && dataArray.length > 0) {
            productiondomain = dataArray[0].getString("productiondomain");
        }
        if ("audit".equals(e.getOperationKey())) {
            ArrayList<DynamicObject> writeBackList = new ArrayList<DynamicObject>();
            HashMap<Long, DynamicObject> inbillMap = new HashMap<Long, DynamicObject>(16);
            DynamicObject productionorg = null;
            for (DynamicObject manuInBill : dataArray) {
                if (!"im_mdc_mftmanuinbill".equals(manuInBill.getDataEntityType().getName())) continue;
                productionorg = manuInBill.getDynamicObject("productionorg");
                DynamicObjectCollection entryCol = manuInBill.getDynamicObjectCollection("billentry");
                for (DynamicObject eColRow : entryCol) {
                    Boolean isadd = eColRow.getBoolean("isadd");
                    String manuentry = eColRow.getString("manuentry");
                    String producttype = eColRow.getString("producttype");
                    if (!isadd.booleanValue() || "C".equals(producttype) || !StringUtils.isEmpty((String)manuentry)) continue;
                    writeBackList.add(eColRow);
                    inbillMap.put(eColRow.getLong("id"), manuInBill);
                }
            }
            if (!writeBackList.isEmpty()) {
                this.writeBackMftOrder(writeBackList, inbillMap, productionorg, productiondomain);
            }
        } else if ("unaudit".equals(e.getOperationKey())) {
            for (DynamicObject dataEntity : dataArray) {
                DynamicObjectCollection coll = dataEntity.getDynamicObjectCollection("billentry");
                coll.forEach(a -> a.set("backflushstatus", (Object)"D"));
            }
        }
    }

    public static BigDecimal getQualityQTY(String operationKey, Map<String, Object> manuEntryObj, String qtyFirstFieldName, DynamicObject entryObj, String qtySecondFieldName) {
        BigDecimal result = BigDecimal.ZERO;
        logger.info((Object)("\u64cd\u4f5c\u4e2d\u5f53\u524d\u5b8c\u5de5\u5165\u5e93/\u9000\u5e93\u5355\u6570\u91cf\u4e3a:" + entryObj.getBigDecimal(qtySecondFieldName)));
        switch (operationKey) {
            case "audit": {
                result = ((BigDecimal)manuEntryObj.get(qtyFirstFieldName)).add(entryObj.getBigDecimal(qtySecondFieldName));
                break;
            }
            case "unaudit": {
                result = ((BigDecimal)manuEntryObj.get(qtyFirstFieldName)).subtract(entryObj.getBigDecimal(qtySecondFieldName));
                break;
            }
            case "save": {
                result = ((BigDecimal)manuEntryObj.get(qtyFirstFieldName)).add(entryObj.getBigDecimal(qtySecondFieldName));
                break;
            }
            case "delete": {
                result = ((BigDecimal)manuEntryObj.get(qtyFirstFieldName)).subtract(entryObj.getBigDecimal(qtySecondFieldName));
                break;
            }
        }
        return result;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        List selectedRows = e.getSelectedRows();
        if (!"audit".equals(operationKey) && !"unaudit".equals(operationKey)) {
            return;
        }
        String name = ((ExtendedDataEntity)selectedRows.get(0)).getDataEntity().getDataEntityType().getName();
        DynamicObject[] dataEntities2 = e.getDataEntities();
        String productiondomain = "A";
        if (dataEntities2 != null && dataEntities2.length > 0) {
            productiondomain = dataEntities2[0].getString("productiondomain");
        }
        if ("audit".equals(operationKey) && "im_mdc_mftmanuinbill".equals(name)) {
            this.updateFixLink(dataEntities2, productiondomain);
        }
        if ("audit".equals(operationKey)) {
            this.updateBFStatus(dataEntities2);
        }
        MftOrderChargeAgainstUtils.calMftChargeAgainst((String)operationKey, (List)selectedRows, (String)productiondomain);
        logger.info((Object)"\u8ba1\u7b97\u5b8c\u5de5\u65f6\u95f4------start------");
        HashSet<Long> orderidSet = new HashSet<Long>(16);
        if (dataEntities2 == null) {
            return;
        }
        for (DynamicObject obj : dataEntities2) {
            DynamicObjectCollection billentry = obj.getDynamicObjectCollection("billentry");
            for (int j = 0; j < billentry.size(); ++j) {
                orderidSet.add(((DynamicObject)billentry.get(j)).getLong("mainbillid"));
            }
        }
        MftOrderCalWriteUtils.updateMftEndworktime(orderidSet, (String)GetEntityNameHelper.getOrderEntityName((String)productiondomain));
        logger.info((Object)"\u8ba1\u7b97\u5b8c\u5de5\u65f6\u95f4------end------");
        if ("unaudit".equals(operationKey) && "im_mdc_mftmanuinbill".equals(name) && "A".equals(productiondomain)) {
            logger.info((Object)"\u8054\u526f\u4ea7\u54c1\u5220\u9664\u5de5\u5355------start------");
            MftManuInBillAuditUtils.dealManuInbillData((DynamicObject[])dataEntities2);
            logger.info((Object)"\u8054\u526f\u4ea7\u54c1\u5220\u9664\u5de5\u5355------end------");
        }
    }

    private void updateFixLink(DynamicObject[] dataEntities2, String productiondomain) {
        for (DynamicObject dataEntity : dataEntities2) {
            Object billPkId = dataEntity.getPkValue();
            Boolean ischargeoff = dataEntity.getBoolean("ischargeoff");
            if (ischargeoff.booleanValue()) continue;
            DynamicObjectCollection billentryCollection = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billentryCollection) {
                Boolean isadd = row.getBoolean("isadd");
                DynamicObjectCollection linkRows = row.getDynamicObjectCollection("billentry_lk");
                if (!isadd.booleanValue() || !linkRows.isEmpty()) continue;
                this.fixRowLink(row, billPkId, productiondomain);
                if (!"A".equalsIgnoreCase(productiondomain)) continue;
                this.insertXmftOrderLog(row, dataEntity);
            }
        }
    }

    private void updateBFStatus(DynamicObject[] dataEntities2) {
        ArrayList orderReportBillEntryIds = new ArrayList(16);
        for (DynamicObject manuInBill : dataEntities2) {
            DynamicObjectCollection coll = manuInBill.getDynamicObjectCollection("billentry");
            coll.forEach(a -> orderReportBillEntryIds.add(a.getLong("id")));
        }
        if (!orderReportBillEntryIds.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(orderReportBillEntryIds, (String)this.billEntityType.getName());
        }
    }

    private void fixRowLink(DynamicObject xBillNew, Object billPkId, String productiondomain) {
        String targetEntityNumber = "im_mdc_mftmanuinbill";
        String targetEntryKey = "billentry";
        String manubill = xBillNew.getString("manubill");
        Object targetBillId = billPkId;
        String srcRowSeqFld = "manuentry";
        String srcBillNo = manubill;
        String srcBillTypeFld = GetEntityNameHelper.getOrderEntityName((String)productiondomain);
        String srcEntryFld = "treeentryentity";
        MftRowLinkUtils.fixRowLink((String)targetEntityNumber, (String)targetEntryKey, (String)srcBillTypeFld, (String)srcEntryFld, (String)srcRowSeqFld, (Object)targetBillId, (String)srcBillNo);
    }

    public void writeBackMftOrder(List<DynamicObject> wBackList, Map<Long, DynamicObject> inbillMap, DynamicObject productionorg, String productiondomain) {
        HashMap mftEntryMap = new HashMap(20);
        HashSet<Long> manuentryidSet = new HashSet<Long>(16);
        HashSet<Long> orderidSet = new HashSet<Long>(16);
        HashSet<Long> materailSet = new HashSet<Long>(16);
        for (DynamicObject dym : wBackList) {
            ArrayList<DynamicObject> list;
            Long manuentryid = dym.getLong("manuentryid");
            if (mftEntryMap.containsKey(manuentryid)) {
                list = (ArrayList<DynamicObject>)mftEntryMap.get(manuentryid);
                list.add(dym);
                mftEntryMap.put(manuentryid, list);
            } else {
                list = new ArrayList<DynamicObject>(8);
                list.add(dym);
                mftEntryMap.put(manuentryid, list);
            }
            manuentryidSet.add(dym.getLong("manuentryid"));
            orderidSet.add(dym.getLong("manubillid"));
            materailSet.add(MDCDyObjUtil.getDyObjId((Object)dym.get("materialmasterid")));
        }
        if (!manuentryidSet.isEmpty()) {
            Map<Long, DynamicObject> materialMap = this.getMaterialInfo(materailSet, productionorg);
            long[] mftentryIds = this.getmftOrderIds(productiondomain);
            int eindex = 0;
            ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(10);
            String orderEntityName = GetEntityNameHelper.getOrderEntityName((String)productiondomain);
            for (Long next : orderidSet) {
                DynamicObject mftdym = BusinessDataServiceHelper.loadSingle((Object)next, (String)orderEntityName);
                if (mftdym == null) continue;
                DynamicObjectCollection mentryCol = mftdym.getDynamicObjectCollection("treeentryentity");
                int index = mentryCol.size();
                int index2 = mentryCol.size();
                for (int i = 0; i < index2; ++i) {
                    Long entryRowid;
                    DynamicObject mentryColRow = (DynamicObject)mentryCol.get(i);
                    if (!"C".equals(mentryColRow.getString("producttype")) || !mftEntryMap.containsKey(entryRowid = (Long)mentryColRow.getPkValue())) continue;
                    List list = (List)mftEntryMap.get(entryRowid);
                    for (DynamicObject mbillRow : list) {
                        DynamicObject billEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)mentryColRow, (boolean)false, (boolean)true);
                        billEntry.set("id", (Object)mftentryIds[eindex]);
                        billEntry.set("seq", (Object)(++index));
                        billEntry.set("pid", (Object)entryRowid);
                        DynamicObject inbill = inbillMap.get(mbillRow.getLong("id"));
                        billEntry.set("beginbookdate", (Object)inbill.getDate("bookdate"));
                        this.insertEntryData(mentryColRow, billEntry, mbillRow, materialMap, orderEntityName);
                        mbillRow.set("srcbillentryid", (Object)mftentryIds[eindex]);
                        mbillRow.set("srcbillentryseq", (Object)index);
                        mbillRow.set("mainbillentryid", (Object)mftentryIds[eindex]);
                        mbillRow.set("mainbillentryseq", (Object)index);
                        mbillRow.set("manuentryid", (Object)mftentryIds[eindex]);
                        mbillRow.set("manuentry", (Object)index);
                        mbillRow.set("pid", (Object)entryRowid);
                        if (++eindex >= 1000) {
                            eindex = 0;
                            mftentryIds = this.getmftOrderIds(productiondomain);
                        }
                        mentryCol.add((Object)billEntry);
                    }
                }
                orderList.add(mftdym);
            }
            if (!orderList.isEmpty()) {
                OperationResult saveOperate;
                OperateOption operateOption = OperateOption.create();
                if ("E".equals(productiondomain)) {
                    operateOption.setVariableValue("appId", "prop");
                }
                if (!(saveOperate = SaveServiceHelper.saveOperate((String)orderEntityName, (DynamicObject[])orderList.toArray(new DynamicObject[0]), (OperateOption)operateOption)).isSuccess()) {
                    List allErrorOrValidateInfo = saveOperate.getAllErrorOrValidateInfo();
                    StringBuilder builder = new StringBuilder();
                    for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                        builder.append(iOperateInfo.getMessage());
                    }
                    throw new KDBizException(builder.toString());
                }
            }
        }
    }

    public static Set<String> getAllMftOrderHeadFields(String orderName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)orderName);
        Set<String> keySet = mainType.getFields().keySet();
        return keySet;
    }

    public static Set<String> getAllMftOrderEentryFields(String orderName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)orderName);
        EntityType subEntryType = (EntityType)mainType.getAllEntities().get("treeentryentity");
        Set<String> keySet = subEntryType.getFields().keySet();
        return keySet;
    }

    private void insertEntryData(DynamicObject mentryColRow, DynamicObject billEntry, DynamicObject mbillRow, Map<Long, DynamicObject> materialMap, String orderEntityName) {
        Long materialmasterid = MDCDyObjUtil.getDyObjId((Object)mbillRow.get("materialmasterid"));
        BigDecimal baseqty = mbillRow.getBigDecimal("baseqty");
        DynamicObject baseunit = mbillRow.getDynamicObject("baseunit");
        DynamicObject unit2nd = mbillRow.getDynamicObject("unit2nd");
        BigDecimal qtyunit2nd = BigDecimal.ZERO;
        if (unit2nd != null) {
            StringBuilder errMsg2 = new StringBuilder();
            qtyunit2nd = UnitConvertHelper.calculateNewQty((BigDecimal)baseqty, (Long)((Long)unit2nd.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)materialmasterid, (StringBuilder)errMsg2);
        }
        DynamicObject auxpty = mbillRow.getDynamicObject("auxpty");
        String lotnumber = mbillRow.getString("lotnumber");
        DynamicObject warehouse = mbillRow.getDynamicObject("warehouse");
        DynamicObject location = mbillRow.getDynamicObject("location");
        DynamicObject configuredcode = mbillRow.getDynamicObject("configuredcode");
        DynamicObject tracknumber = mbillRow.getDynamicObject("tracknumber");
        DynamicObject producedept = mbillRow.getDynamicObject("producedept");
        DynamicObject mftMaterial = materialMap.get(materialmasterid);
        if (mftMaterial == null) {
            DynamicObject material = mbillRow.getDynamicObject("material");
            DynamicObject masterid = material.getDynamicObject("masterid");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7269\u6599\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u751f\u4ea7\u4fe1\u606f\u3002", (String)"MftManuInBillAuditOp_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), masterid.getString("number")));
        }
        DynamicObject mftunit = mftMaterial.getDynamicObject("mftunit");
        DynamicObject masterid = mftMaterial.getDynamicObject("masterid");
        StringBuilder errMsg = new StringBuilder();
        BigDecimal qty = UnitConvertHelper.calculateNewQty((BigDecimal)baseqty, (Long)((Long)mftunit.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)materialmasterid, (StringBuilder)errMsg);
        BigDecimal quainwaqty = BigDecimal.ZERO;
        BigDecimal waitcheckqty = BigDecimal.ZERO;
        BigDecimal unquainwaqty = BigDecimal.ZERO;
        BigDecimal scrinwaqty = BigDecimal.ZERO;
        billEntry.set("producedept", (Object)producedept);
        billEntry.set("producttype", (Object)mbillRow.getString("producttype"));
        billEntry.set("materielmasterid", (Object)masterid);
        billEntry.set("material", (Object)mftMaterial);
        billEntry.set("quainwaqty", (Object)quainwaqty);
        billEntry.set("unquainwaqty", (Object)unquainwaqty);
        billEntry.set("waitcheckqty", (Object)waitcheckqty);
        billEntry.set("scrinwaqty", (Object)scrinwaqty);
        billEntry.set("stockqty", (Object)BigDecimal.ZERO);
        billEntry.set("qty", (Object)qty);
        billEntry.set("unit", (Object)mftunit);
        billEntry.set("iscontrolqty", (Object)Boolean.FALSE);
        billEntry.set("yieldrate", (Object)1);
        billEntry.set("rcvinhighlimit", (Object)0);
        billEntry.set("rcvinlowlimit", (Object)0);
        billEntry.set("repmaxrate", (Object)0);
        billEntry.set("repminrate", (Object)0);
        billEntry.set("repminqty", (Object)baseqty);
        billEntry.set("repmaxqty", (Object)baseqty);
        billEntry.set("planbaseqty", (Object)baseqty);
        billEntry.set("planqty", (Object)qty);
        billEntry.set("estscrapqty", (Object)BigDecimal.ZERO);
        billEntry.set("baseunit", (Object)baseunit);
        billEntry.set("baseqty", (Object)baseqty);
        billEntry.set("inwarmax", (Object)baseqty);
        billEntry.set("inwarmin", (Object)baseqty);
        billEntry.set("auxptyunit", (Object)unit2nd);
        billEntry.set("auxptyqty", (Object)qtyunit2nd);
        billEntry.set("batchno", (Object)lotnumber);
        billEntry.set("auxproperty", (Object)auxpty);
        billEntry.set("warehouse", (Object)warehouse);
        billEntry.set("location", (Object)location);
        billEntry.set("tracknumber", (Object)tracknumber);
        billEntry.set("configuredcode", (Object)configuredcode);
        billEntry.set("isconreportqty", (Object)Boolean.FALSE);
        billEntry.set("isinspection", (Object)Boolean.FALSE);
        billEntry.set("manuversion", null);
        billEntry.set("bomid", null);
        if (!"prop_mftorder".equalsIgnoreCase(orderEntityName)) {
            billEntry.set("ecnversion", null);
            billEntry.set("isinbill", (Object)Boolean.TRUE);
        }
        billEntry.set("processroute", null);
        billEntry.set("routereplace", null);
        billEntry.set("pickingpairs", (Object)0);
        billEntry.set("rptqty", (Object)0);
        billEntry.set("reportqty", (Object)0);
        billEntry.set("repairqty", (Object)0);
        billEntry.set("qualifiedqty", (Object)0);
        billEntry.set("unqualifiedqty", (Object)0);
        billEntry.set("acceptqty", (Object)0);
        billEntry.set("workwasteqty", (Object)0);
        billEntry.set("reworkqty", (Object)0);
        billEntry.set("mtlcostqty", (Object)0);
        billEntry.set("scrapqty", (Object)0);
        billEntry.set("sourcebilltype", null);
        billEntry.set("sourcebillnumber", null);
        billEntry.set("sourceentryseq", null);
    }

    private long[] getmftOrderIds(String productiondomain) {
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds(GetEntityNameHelper.getOrderEntityName((String)productiondomain), 1000);
        return ids;
    }

    private Map<Long, DynamicObject> getMaterialInfo(Set<Long> materailSet, DynamicObject productionorg) {
        DynamicObject[] mftinfo;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(20);
        QFilter qFilter2 = new QFilter("masterid.id", "in", materailSet);
        qFilter2.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)productionorg.getLong("id")));
        qFilter2.and(new QFilter("enable", "=", (Object)"1"));
        qFilter2.and(new QFilter("status", "=", (Object)"C"));
        String qmftsql = "id,masterid,mftunit";
        for (DynamicObject infodym : mftinfo = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)qmftsql, (QFilter[])new QFilter[]{qFilter2})) {
            DynamicObject masterid = infodym.getDynamicObject("masterid");
            resultMap.put((Long)masterid.getPkValue(), infodym);
        }
        return resultMap;
    }

    private DynamicObject insertXmftOrderLog(DynamicObject row, DynamicObject manuBill) {
        DynamicObject xmftOrderlog = BusinessDataServiceHelper.newDynamicObject((String)"pom_xmftorderlog");
        this.dealXMftOrderChangeLog(xmftOrderlog, manuBill, row);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{xmftOrderlog});
        return xmftOrderlog;
    }

    private void dealXMftOrderChangeLog(DynamicObject xmftOrderlog, DynamicObject manubill, DynamicObject row) {
        xmftOrderlog.set("changestatus", (Object)"B");
        xmftOrderlog.set("changetype", (Object)"A");
        xmftOrderlog.set("xbillid", manubill.getPkValue());
        xmftOrderlog.set("xbillno", manubill.get("billno"));
        xmftOrderlog.set("biztime", manubill.get("bookdate"));
        xmftOrderlog.set("beginbookdate", manubill.get("bookdate"));
        xmftOrderlog.set("xreason", (Object)ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u624b\u5de5\u65b0\u589e\u201c\u8054\u526f\u4ea7\u54c1\u201d\u884c\u3002", (String)"MftManuInBillAuditOp_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        xmftOrderlog.set("org", manubill.get("productionorg"));
        xmftOrderlog.set("srcbillid", row.get("manubillid"));
        xmftOrderlog.set("srcbillno", row.get("manubill"));
        xmftOrderlog.set("srcbillentryid", row.get("manuentryid"));
        xmftOrderlog.set("srcbillentryseq", row.get("manuentry"));
        xmftOrderlog.set("xbillentryid", row.getPkValue());
        xmftOrderlog.set("xbillentryseq", row.get("seq"));
        xmftOrderlog.set("creator", manubill.get("auditor"));
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.iscontrolqty,treeentryentity.baseqty,treeentryentity.inwarmin,treeentryentity.planendtime,treeentryentity.rcvinhighlimit,treeentryentity.rcvinlowlimit,treeentryentity.transmittime,transactiontype,treeentryentity.qty,treeentryentity.planpreparetime,treeentryentity.planbegintime,treeentryentity.batchno,treeentryentity.inwardept.name,treeentryentity.warehouse.name,treeentryentity.location.name,treeentryentity.unit unitid,treeentryentity.baseunit baseunitid";
        QFilter qFilter = new QFilter("treeentryentity.id", "=", (Object)((Long)row.get("manuentryid")));
        HashMap<String, Object> map1 = new HashMap<String, Object>(64);
        String nullName = ResManager.loadKDString((String)"\u65e0", (String)"MftManuInBillAuditOp_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        String isControl = ResManager.loadKDString((String)"\u662f", (String)"MftManuInBillAuditOp_2", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryOrderEntry", (String)"pom_mftorder", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row mftRow = dataSet.next();
                Long unitID = mftRow.getLong("unitid");
                Long baseunitid = mftRow.getLong("baseunitid");
                DynamicObject unit = this.getUnit(unitID);
                DynamicObject baseUnit = this.getUnit(baseunitid);
                int basePrecision = baseUnit.getInt("precision");
                int precision = unit.getInt("precision");
                String basePrecisionaccount = baseUnit.getString("precisionaccount");
                String precisionaccount = unit.getString("precisionaccount");
                map1.put("id", mftRow.getLong("id"));
                map1.put("billno", mftRow.getString("billno"));
                map1.put("billstatus", mftRow.getString("billstatus"));
                map1.put("treeentryentity.id", mftRow.getLong("treeentryentity.id"));
                map1.put("treeentryentity.seq", mftRow.getString("treeentryentity.seq"));
                map1.put("treeentryentity.producttype", mftRow.getString("treeentryentity.producttype"));
                map1.put("treeentryentity.material", mftRow.getLong("treeentryentity.material"));
                map1.put("treeentryentity.baseqty", BigDecimal.ZERO.compareTo(mftRow.getBigDecimal("treeentryentity.baseqty")) == 0 ? Integer.valueOf(0) : mftRow.getBigDecimal("treeentryentity.baseqty").setScale(basePrecision, MftReqOutBillUtil.getPrecisionaccount((String)basePrecisionaccount)).toPlainString());
                map1.put("treeentryentity.qty", BigDecimal.ZERO.compareTo(mftRow.getBigDecimal("treeentryentity.qty")) == 0 ? Integer.valueOf(0) : mftRow.getBigDecimal("treeentryentity.qty").setScale(precision, MftReqOutBillUtil.getPrecisionaccount((String)precisionaccount)).toPlainString());
                map1.put("treeentryentity.planpreparetime", mftRow.getDate("treeentryentity.planpreparetime"));
                map1.put("treeentryentity.planbegintime", mftRow.getDate("treeentryentity.planbegintime"));
                map1.put("treeentryentity.planendtime", mftRow.getDate("treeentryentity.planendtime"));
                map1.put("treeentryentity.inwardept.name", mftRow.getString("treeentryentity.inwardept.name") == null ? nullName : mftRow.getString("treeentryentity.inwardept.name"));
                map1.put("treeentryentity.warehouse.name", mftRow.getString("treeentryentity.warehouse.name") == null ? nullName : mftRow.getString("treeentryentity.warehouse.name"));
                map1.put("treeentryentity.location.name", mftRow.getString("treeentryentity.location.name") == null ? nullName : mftRow.getString("treeentryentity.location.name"));
                if (!mftRow.getBoolean("treeentryentity.iscontrolqty").booleanValue()) {
                    isControl = ResManager.loadKDString((String)"\u5426", (String)"MftManuInBillAuditOp_3", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                }
                map1.put("treeentryentity.iscontrolqty", isControl);
                map1.put("treeentryentity.rcvinhighlimit", BigDecimal.ZERO.compareTo(mftRow.getBigDecimal("treeentryentity.rcvinhighlimit")) == 0 ? Integer.valueOf(0) : mftRow.getBigDecimal("treeentryentity.rcvinhighlimit").toPlainString());
                map1.put("treeentryentity.rcvinlowlimit", BigDecimal.ZERO.compareTo(mftRow.getBigDecimal("treeentryentity.rcvinlowlimit")) == 0 ? Integer.valueOf(0) : mftRow.getBigDecimal("treeentryentity.rcvinlowlimit").toPlainString());
                String bacthno = nullName;
                if (!StringUtils.isBlank((String)mftRow.getString("treeentryentity.batchno"))) {
                    bacthno = mftRow.getString("treeentryentity.batchno");
                }
                map1.put("treeentryentity.batchno", bacthno);
            }
        }
        if (!map1.isEmpty()) {
            DynamicObjectCollection entryentity = xmftOrderlog.getDynamicObjectCollection("entryentity");
            DynamicObject addNew = entryentity.addNew();
            Map xmftLogAndOrderCorrespodingMap = XMftOrderChangeLogConsts.getXMFTLogMap();
            for (Map.Entry m : xmftLogAndOrderCorrespodingMap.entrySet()) {
                String xMftOrderChangeLogColName = (String)m.getKey();
                String orderName = (String)m.getValue();
                addNew.set(xMftOrderChangeLogColName, map1.get(orderName));
            }
        }
    }

    private DynamicObject getUnit(Long unitID) {
        String selectProperties = "id,number,name,precisionaccount,precision";
        QFilter qFilter1 = new QFilter("id", "=", (Object)unitID);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (String)selectProperties, (QFilter[])new QFilter[]{qFilter1});
    }
}

