/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ConmBillHelper {
    public static void showConmBillF7(String BillType, IFormView view, String pluginName, int currrow) {
        DynamicObject org;
        Date biztime;
        DynamicObject material;
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)BillType, (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
        lfp.setFilter(new QFilter("validstatus", "=", (Object)"B"));
        lfp.setFilter(new QFilter("changestatus", "<>", (Object)"B"));
        DynamicObject supplier = (DynamicObject)view.getModel().getValue("supplier");
        if (supplier != null) {
            lfp.setFilter(new QFilter("supplier", "=", supplier.getPkValue()));
        }
        if ((material = (DynamicObject)view.getModel().getValue("material", currrow)) != null) {
            lfp.setFilter(new QFilter("entryentity.material", "=", material.getPkValue()).or("entryentity.material", "=", null));
        }
        if ((biztime = (Date)view.getModel().getValue("biztime")) != null) {
            lfp.setFilter(new QFilter("biztimebegin", "<=", (Object)biztime));
            lfp.setFilter(new QFilter("biztimeend", ">=", (Object)biztime));
        }
        if ((org = (DynamicObject)view.getModel().getValue("org")) != null) {
            QFilter qf1 = new QFilter("suitscope", "=", (Object)"A").and("org", "=", org.getPkValue());
            QFilter qf2 = new QFilter("suitscope", "=", (Object)"B").and(new QFilter("org", "=", org.getPkValue()));
            QFilter qf3 = new QFilter("suitscope", "=", (Object)"C");
            QFilter finQF = qf1.or(qf2).or(qf3);
            lfp.setFilter(finQF);
        }
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setListFilterParameter(lfp);
        CloseCallBack closeCallBack = new CloseCallBack(pluginName, "conmBill");
        lsp.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)lsp);
    }

    public static String closeConmBillF7(IDataModel model, String entryKey, Object returnData) {
        HashMap<Object, Object> infoMap;
        ListSelectedRowCollection coreBillCollection = (ListSelectedRowCollection)returnData;
        if (ObjectUtils.isEmpty((Object)coreBillCollection)) {
            return null;
        }
        List<Object> objects = Arrays.asList(coreBillCollection.getEntryPrimaryKeyValues());
        ArrayList<Object> entryPrimaryKeylist = new ArrayList<Object>(objects);
        int entryRowCount = model.getEntryRowCount(entryKey);
        int currentRowIndex = model.getEntryCurrentRowIndex(entryKey);
        int followingRowCount = entryRowCount - (currentRowIndex + 1);
        DynamicObject object = (DynamicObject)model.getEntryEntity("billentry").get(currentRowIndex);
        DynamicObject material = object.getDynamicObject("material");
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (material != null) {
            qFilter.and(new QFilter("billentry.material", "=", material.getPkValue()).or("billentry.material", "=", null));
        }
        if (entryPrimaryKeylist.size() > 0 && entryPrimaryKeylist.get(0) != null && ((Long)entryPrimaryKeylist.get(0)).compareTo(0L) != 0) {
            qFilter.and(new QFilter("billentry.id", "in", entryPrimaryKeylist));
        }
        if ((infoMap = ConmBillHelper.getInfo(coreBillCollection, qFilter)).size() > 1) {
            return "error";
        }
        if (infoMap.size() - 1 > followingRowCount) {
            model.appendEntryRow(entryKey, entryRowCount - 1, infoMap.size() - 1 - followingRowCount);
        }
        int i = 0;
        for (Map.Entry<Object, Object> obj : infoMap.entrySet()) {
            DynamicObject o = (DynamicObject)obj.getValue();
            Boolean istax = (Boolean)model.getValue("istax");
            if (Boolean.TRUE.equals(istax)) {
                model.setValue("priceandtax", o.get("billentry.priceandtax"), currentRowIndex + i);
            } else {
                model.setValue("price", o.get("billentry.price"), currentRowIndex + i);
            }
            model.setValue("taxrateid", o.get("billentry.taxrateid"), currentRowIndex + i);
            model.setValue("conbillid", o.get("id"), currentRowIndex + i);
            model.setValue("conbillnumber", o.get("billno"), currentRowIndex + i);
            model.setValue("conbillentryid", o.get("billentry.id"), currentRowIndex + i);
            model.setValue("conbillrownum", o.get("billentry.lineno"), currentRowIndex + i);
            model.setValue("conbillentryseq", o.get("billentry.seq"), currentRowIndex + i);
            model.setValue("conbillentity", (Object)"conm_purcontract", currentRowIndex + i);
            ++i;
        }
        return "success";
    }

    private static HashMap<Object, Object> getInfo(ListSelectedRowCollection selectedRow, QFilter qFilter) {
        HashSet<Long> idset = new HashSet<Long>(selectedRow.size());
        for (ListSelectedRow row : selectedRow) {
            Object primaryKeyValue = row.getPrimaryKeyValue();
            idset.add((Long)primaryKeyValue);
        }
        QFilter entryqFilter = new QFilter("id", "in", idset);
        if (qFilter != null) {
            entryqFilter.and(qFilter);
        }
        String selectFields = "id,billentry.id,billentry.material,billentry.materialmasterid,billentry.materialmasterid.number,billno,billentry.lineno,billentry.priceandtax,billentry.price,billentry.taxrateid,billentry.seq";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"conm_purcontract", (String)selectFields, (QFilter[])entryqFilter.toArray());
        HashMap<Object, Object> map = new HashMap<Object, Object>(selectedRow.size());
        for (DynamicObject row : rows) {
            Long entryid = row.getLong("billentry.id");
            map.put(entryid, row);
        }
        return map;
    }
}

