/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.common.utils.DateUtils;
import kd.scmc.pm.mservice.PurOrderFiValidateService;
import kd.scmc.pm.mservice.PurOrderServiceImpl;

public class PurOrderFiValidateService {
    private static final Log log = LogFactory.getLog(PurOrderFiValidateService.class);
    private static final TrackLogService trackLog = new TrackLogService(PurOrderServiceImpl.class, "pm");

    public Map<String, String> verifyPayPrePayAmount(List<Map<String, Object>> paramList) {
        trackLog.startInfo(SerializationUtils.toJsonString(paramList));
        HashMap<String, String> result = new HashMap<String, String>(3);
        result.put("code", "0");
        result.put("errorInfo", "");
        if (paramList == null || paramList.isEmpty()) {
            return result;
        }
        log.info("\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u4e1a\u52a1\u6821\u9a8c\u5fae\u670d\u52a1 \u5f00\u59cb,\u5165\u53c2\u5927\u5c0f\u4e3a\uff1a" + paramList.size());
        HashSet<Long> payEntryIdSet = new HashSet<Long>(10);
        HashMap<Long, BigDecimal> refundPoAndAmount = new HashMap<Long, BigDecimal>(10);
        for (Map<String, Object> param : paramList) {
            Object coreBillType;
            Object paymentBizType;
            Object sourceBillType;
            if (param == null || param.isEmpty() || (sourceBillType = param.get("sourceBillType")) == null || !"pm_purorderbill".equals(sourceBillType) || (paymentBizType = param.get("paymentBizType")) == null || !"202".equals(paymentBizType) || (coreBillType = param.get("coreBillType")) == null || !"pm_purorderbill".equals(coreBillType)) continue;
            Object coreBillId = param.get("coreBillId");
            Object coreBillEntryId = param.get("coreBillEntryId");
            Object refundAmt = param.get("refundAmt");
            if (coreBillId == null || coreBillEntryId == null || refundAmt == null) continue;
            BigDecimal billSumrefundAmt = refundPoAndAmount.get(coreBillId) == null ? BigDecimal.ZERO : (BigDecimal)refundPoAndAmount.get(coreBillId);
            BigDecimal refundAmtDecimal = refundAmt instanceof BigDecimal ? (BigDecimal)refundAmt : new BigDecimal(refundAmt.toString());
            billSumrefundAmt = billSumrefundAmt.add(refundAmtDecimal.negate());
            refundPoAndAmount.put((Long)coreBillId, billSumrefundAmt);
            payEntryIdSet.add((Long)coreBillEntryId);
        }
        if (payEntryIdSet.isEmpty() || refundPoAndAmount.isEmpty()) {
            return result;
        }
        Map<Long, Map<String, Object>> poInfoMap = this.queryPo(payEntryIdSet, "pm_purorderbill");
        if (poInfoMap.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurOrderFiValidateService_4", (String)"scmc-pm-mservice", (Object[])new Object[0]);
            result.put("code", "1");
            result.put("errorInfo", msg);
            return result;
        }
        String errormsg = this.compareAmount(refundPoAndAmount, poInfoMap);
        if (StringUtils.isNotBlank((CharSequence)errormsg)) {
            result.put("code", "1");
            result.put("errorInfo", errormsg);
        }
        return result;
    }

    private Map<Long, Map<String, Object>> queryPo(Set<Long> payEntryIdSet, String entityPurorderbill) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(10);
        QFilter poPayEntryIdFilter = new QFilter("purbillentry_pay.id", "in", payEntryIdSet);
        QFilter isPrePayFilter = new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityPurorderbill, (String)"id,isallowoverpay,purbillentry_pay.id as payentryid , purbillentry_pay.payamount as prepayamount, purbillentry_pay.joinpayamount as joinpayamount", (QFilter[])new QFilter[]{isPrePayFilter, poPayEntryIdFilter}, null);){
            for (Row row : dataSet) {
                HashMap<Long, HashMap<String, BigDecimal>> payEntryInfos;
                Long id = row.getLong("id");
                HashMap<String, Serializable> poInfo = (HashMap<String, Serializable>)result.get(id);
                if (poInfo == null) {
                    poInfo = new HashMap<String, Serializable>(6);
                    poInfo.put("isallowoverpay", row.getBoolean("isallowoverpay"));
                    payEntryInfos = new HashMap<Long, HashMap<String, BigDecimal>>();
                } else {
                    payEntryInfos = (HashMap<Long, HashMap<String, BigDecimal>>)poInfo.get("payentryinfo");
                }
                HashMap<String, BigDecimal> payEntryInfo = new HashMap<String, BigDecimal>(3);
                payEntryInfo.put("prepayamount", row.getBigDecimal("prepayamount"));
                payEntryInfo.put("joinpayamount", row.getBigDecimal("joinpayamount"));
                payEntryInfos.put(row.getLong("payentryid"), payEntryInfo);
                poInfo.put("payentryinfo", payEntryInfos);
                result.put(id, poInfo);
            }
        }
        return result;
    }

    private String compareAmount(Map<Long, BigDecimal> refundPoAndAmount, Map<Long, Map<String, Object>> poInfoMap) {
        for (Map.Entry<Long, Map<String, Object>> poInfoEntry : poInfoMap.entrySet()) {
            BigDecimal sumRefundAmt;
            BigDecimal result;
            Long poId = poInfoEntry.getKey();
            Map<String, Object> poInfo = poInfoEntry.getValue();
            Object isallowoverpay = poInfo.get("isallowoverpay");
            if (isallowoverpay instanceof Boolean && ((Boolean)isallowoverpay).booleanValue()) continue;
            BigDecimal sumJoinPayAmount = BigDecimal.ZERO;
            BigDecimal sumPayAmount = BigDecimal.ZERO;
            Map payentryinfo = (Map)poInfo.get("payentryinfo");
            if (payentryinfo != null && !payentryinfo.isEmpty()) {
                for (Map.Entry entry : payentryinfo.entrySet()) {
                    Map onePayEntry = (Map)entry.getValue();
                    BigDecimal prepayamount = (BigDecimal)onePayEntry.get("prepayamount");
                    BigDecimal joinpayamount = (BigDecimal)onePayEntry.get("joinpayamount");
                    if (joinpayamount.compareTo(BigDecimal.ZERO) < 0) {
                        String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e\u96f6\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"PurOrderFiValidateService_3", (String)"scmc-pm-mservice", (Object[])new Object[0]);
                        return msg;
                    }
                    if (prepayamount.compareTo(joinpayamount) < 0) {
                        String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"PurOrderFiValidateService_5", (String)"scmc-pm-mservice", (Object[])new Object[0]);
                        return msg;
                    }
                    sumJoinPayAmount = sumJoinPayAmount.add(joinpayamount);
                    sumPayAmount = sumPayAmount.add(prepayamount);
                }
            }
            if ((result = (sumRefundAmt = refundPoAndAmount.get(poId) == null ? BigDecimal.ZERO : refundPoAndAmount.get(poId)).add(sumJoinPayAmount)).compareTo(sumPayAmount) <= 0) continue;
            String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u53cd\u5199\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"PurOrderFiValidateService_5", (String)"scmc-pm-mservice", (Object[])new Object[0]);
            return msg;
        }
        return null;
    }

    public Map<Long, String> payBillOverPayValService(List<Map<String, Object>> params) {
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        if (params == null || params.isEmpty()) {
            return null;
        }
        List<Map<String, Object>> payBills = this.getValidPayBills(params);
        if (payBills.isEmpty()) {
            return null;
        }
        HashMap<Long, Set<Long>> queryPoIds = new HashMap<Long, Set<Long>>(10);
        Map<String, POBillInfo> poInfoMap = this.getPOBillInfo(payBills, queryPoIds);
        HashMap<Long, Set<Long>> queryConmIds = new HashMap<Long, Set<Long>>(10);
        Map<Long, ConmBillInfo> conmInfoMap = this.getConmBillInfo(payBills, queryConmIds);
        payBills = null;
        if (!queryPoIds.isEmpty()) {
            PurOrderServiceImpl purOrderService = new PurOrderServiceImpl();
            List queryPoInfo = purOrderService.queryOverPayParamAndAmount(queryPoIds);
            poInfoMap = this.addPoInfo(poInfoMap, queryPoInfo, conmInfoMap);
        }
        if (!conmInfoMap.isEmpty()) {
            QFilter conidFilter = new QFilter("id", "in", conmInfoMap.keySet());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"conm_purcontract", (String)"id,settlecurrency,createtime,isallowoverpay,billno,billentry.amountandtax,receivesupplier", (QFilter[])new QFilter[]{conidFilter}, null);){
                DataSet select = dataSet.groupBy(new String[]{"id", "settlecurrency", "createtime", "isallowoverpay", "billno", "receivesupplier"}).sum("billentry.amountandtax").finish().select("id,settlecurrency,createtime,isallowoverpay,billno,billentry.amountandtax,receivesupplier");
                conmInfoMap = this.addConmInfo(conmInfoMap, select);
            }
        }
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return result;
        }
        this.filterByPoAndConmRelation(poInfoMap, conmInfoMap);
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return result;
        }
        this.addConmCurrentAmount(poInfoMap, conmInfoMap);
        this.filterByIsOverPayFlag(poInfoMap, conmInfoMap);
        this.addPaidAmount(poInfoMap, conmInfoMap);
        HashMap<Long, Long> supplierMasterIdMap = new HashMap<Long, Long>(10);
        HashMap<Long, Integer> currencyPrecisionMap = new HashMap<Long, Integer>(10);
        this.addSupplierMasterIdAndCurrencyPrecision(poInfoMap, conmInfoMap, supplierMasterIdMap, currencyPrecisionMap);
        result.putAll(this.validPO(poInfoMap, conmInfoMap, supplierMasterIdMap, currencyPrecisionMap));
        Map<Long, String> errorMsg = this.validConm(conmInfoMap, supplierMasterIdMap, currencyPrecisionMap);
        if (!errorMsg.isEmpty()) {
            errorMsg.keySet().forEach(payBillId -> {
                if (!result.containsKey(payBillId)) {
                    result.put((Long)payBillId, (String)errorMsg.get(payBillId));
                }
            });
        }
        return result;
    }

    private void addConmCurrentAmount(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (conmInfoMap.isEmpty() || poInfoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, POBillInfo> poInfoEntry : poInfoMap.entrySet()) {
            Set poIds;
            ConmBillInfo conmBillInfo;
            POBillInfo poInfo = poInfoEntry.getValue();
            Long conmId = poInfo.getConmId();
            if (conmId == null || (conmBillInfo = conmInfoMap.get(conmId)) == null || (poIds = conmBillInfo.getPoIds()) == null || poIds.isEmpty() || !poIds.contains(poInfo.getCoreBillId())) continue;
            BigDecimal poCurrentAmount = poInfo.getCurrentAmount() == null ? BigDecimal.ZERO : poInfo.getCurrentAmount();
            BigDecimal conmCurrentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
            conmBillInfo.setCurrentAmount(poCurrentAmount.add(conmCurrentAmount));
        }
    }

    private void addSupplierMasterIdAndCurrencyPrecision(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        HashSet supplierIds = new HashSet(10);
        HashSet currencyIds = new HashSet(10);
        poInfoMap.values().forEach(coreBillInfo -> {
            supplierIds.add(coreBillInfo.getCoreBillReceiveSupplierId());
            currencyIds.add(coreBillInfo.getCoreBillSettleCurrency());
        });
        conmInfoMap.values().forEach(conmBillInfo -> {
            supplierIds.add(conmBillInfo.getConmReceiveSupplierId());
            currencyIds.add(conmBillInfo.getConmSettleCurrencyId());
        });
        Map supplierDB = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        Map currencyDB = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        if (supplierDB != null && !supplierDB.isEmpty()) {
            supplierDB.values().forEach(supplier -> supplierMasterIdMap.put(supplier.getLong("id"), supplier.getLong("masterid")));
        }
        if (currencyDB != null && !currencyDB.isEmpty()) {
            currencyDB.values().forEach(currency -> currencyPrecisionMap.put(currency.getLong("id"), currency.getInt("amtprecision")));
        }
    }

    private void filterByPoAndConmRelation(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        HashMap<Long, HashSet<Long>> conmIdAndPoIdsMap = new HashMap<Long, HashSet<Long>>(10);
        HashSet<Long> poIds = new HashSet<Long>(10);
        poInfoMap.values().forEach(poInfo -> poIds.add(poInfo.getCoreBillId()));
        if (!conmInfoMap.isEmpty()) {
            Set<Long> conmIds = conmInfoMap.keySet();
            DynamicObjectCollection purOrderEntrys = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("billentry.conbillid", "in", conmIds)});
            for (DynamicObject dynamicObject : purOrderEntrys) {
                poIds.add(dynamicObject.getLong("id"));
                Long conmBillId = dynamicObject.getLong("billentry.conbillid");
                if (conmBillId == null || conmBillId == 0L) continue;
                HashSet<Long> conmToOrderIds = (HashSet<Long>)conmIdAndPoIdsMap.get(conmBillId);
                if (conmToOrderIds == null) {
                    conmToOrderIds = new HashSet<Long>(16);
                    conmToOrderIds.add(dynamicObject.getLong("id"));
                    conmIdAndPoIdsMap.put(conmBillId, conmToOrderIds);
                    continue;
                }
                conmToOrderIds.add(dynamicObject.getLong("id"));
            }
            purOrderEntrys.clear();
        }
        HashMap<Long, HashSet<Long>> orderIdToConmIdsMap = new HashMap<Long, HashSet<Long>>(16);
        if (!poIds.isEmpty()) {
            DynamicObjectCollection purOrderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", poIds)});
            for (DynamicObject dynamicObject : purOrderBills) {
                Long orderId = dynamicObject.getLong("id");
                Long conmBillId = dynamicObject.getLong("billentry.conbillid");
                if (conmBillId == null || conmBillId == 0L) continue;
                Set<Long> conmIdSet = (Set)orderIdToConmIdsMap.get(orderId);
                if (conmIdSet == null) {
                    conmIdSet = new HashSet<Long>(16);
                    conmIdSet.add(conmBillId);
                    orderIdToConmIdsMap.put(orderId, (HashSet<Long>)conmIdSet);
                    continue;
                }
                conmIdSet.add(conmBillId);
            }
            purOrderBills.clear();
        }
        HashSet hadMultiConmsOrderId = new HashSet(16);
        if (!orderIdToConmIdsMap.isEmpty()) {
            for (Map.Entry entry : orderIdToConmIdsMap.entrySet()) {
                Set conIdSet;
                Long poId = (Long)entry.getKey();
                if (poId == null || poId == 0L || (conIdSet = (Set)entry.getValue()) == null || conIdSet.size() <= 1) continue;
                hadMultiConmsOrderId.add(entry.getKey());
            }
        }
        Iterator iterator = conmIdAndPoIdsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Set oneConmPoIds = (Set)entry.getValue();
            Long conmId = (Long)entry.getKey();
            if (oneConmPoIds == null || oneConmPoIds.isEmpty()) continue;
            for (Long orderId : hadMultiConmsOrderId) {
                if (!oneConmPoIds.contains(orderId)) continue;
                conmInfoMap.remove(conmId);
                iterator.remove();
            }
        }
        HashSet hashSet = new HashSet(10);
        conmIdAndPoIdsMap.values().forEach(poids -> ids.addAll(poids));
        Set allConmIds = conmIdAndPoIdsMap.keySet();
        Iterator<Map.Entry<String, POBillInfo>> poIt = poInfoMap.entrySet().iterator();
        while (poIt.hasNext()) {
            POBillInfo poBillInfo = poIt.next().getValue();
            if (poBillInfo == null) {
                poIt.remove();
                continue;
            }
            if (poBillInfo.getCoreBillSettleOrgId() != null && poBillInfo.getCoreBillReceiveSupplierId() != null && (hashSet.isEmpty() || hashSet.contains(poBillInfo.getCoreBillId()))) continue;
            poIt.remove();
        }
        Iterator<Map.Entry<Long, ConmBillInfo>> conmIt = conmInfoMap.entrySet().iterator();
        while (conmIt.hasNext()) {
            ConmBillInfo conmBillInfo = conmIt.next().getValue();
            if (conmBillInfo == null) {
                conmIt.remove();
                continue;
            }
            if (conmBillInfo.getConmReceiveSupplierId() != null && (allConmIds.isEmpty() || allConmIds.contains(conmBillInfo.getConmId()))) continue;
            conmIt.remove();
        }
        for (Map.Entry entry : conmIdAndPoIdsMap.entrySet()) {
            Long conmBillId = (Long)entry.getKey();
            Set poIdSet = (Set)entry.getValue();
            ConmBillInfo conmBillInfo = conmInfoMap.get(conmBillId);
            if (conmBillInfo != null) {
                conmBillInfo.setPoIds(poIdSet);
            }
            for (Map.Entry<String, POBillInfo> poBillInfoEntry : poInfoMap.entrySet()) {
                POBillInfo poBillInfo = poBillInfoEntry.getValue();
                if (poBillInfo == null) continue;
                Long poId = poBillInfo.getCoreBillId();
                if (poIdSet == null || !poIdSet.contains(poId)) continue;
                poBillInfo.setConmId(conmBillId);
            }
        }
    }

    private Map<Long, String> validConm(Map<Long, ConmBillInfo> conmInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashMap<Long, String> errorMsg = new HashMap<Long, String>(10);
        if (conmInfoMap.isEmpty()) {
            return errorMsg;
        }
        Iterator<Map.Entry<Long, ConmBillInfo>> iterator = conmInfoMap.entrySet().iterator();
        HashMap<Long, ConmBillInfo> checkTolerance = new HashMap<Long, ConmBillInfo>(10);
        while (iterator.hasNext()) {
            BigDecimal paidAmount;
            Map.Entry<Long, ConmBillInfo> next = iterator.next();
            ConmBillInfo conmBillInfo = next.getValue();
            Long conmId = next.getKey();
            Long conmReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            Long payBillPayeeId = conmBillInfo.getPayBillPayeeId();
            if (conmReceiveSupplierId == null || payBillPayeeId == null || conmReceiveSupplierId.compareTo(payBillPayeeId) != 0) continue;
            BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
            BigDecimal conmAmount = conmBillInfo.getConmAmount() == null ? BigDecimal.ZERO : conmBillInfo.getConmAmount();
            BigDecimal bigDecimal = paidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
            if (conmAmount.compareTo(currentAmount.add(paidAmount)) >= 0) {
                conmBillInfo.setSuccess(Boolean.TRUE);
                continue;
            }
            checkTolerance.put(next.getKey(), conmBillInfo);
        }
        if (checkTolerance.isEmpty()) {
            return errorMsg;
        }
        Set<Long> overToleranceIds = this.conmProcessTolerance(checkTolerance, supplierMasterIdMap, currencyPrecisionMap);
        if (!overToleranceIds.isEmpty()) {
            for (Long overToleranceId : overToleranceIds) {
                ConmBillInfo conmBillInfo = (ConmBillInfo)checkTolerance.get(overToleranceId);
                errorMsg.put(conmBillInfo.getPayBillId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff0c\u6309\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c%2$s\u7684\u4ef7\u7a0e\u5408\u8ba1\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurOrderFiValidateService_6", (String)"scmc-pm-mservice", (Object[])new Object[0]), conmBillInfo.getPayBillNo(), conmBillInfo.getConmBillNo()));
            }
        }
        return errorMsg;
    }

    private Set<Long> conmProcessTolerance(Map<Long, ConmBillInfo> checkTolerance, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashSet<Long> overToleranceId = new HashSet<Long>(16);
        ArrayList params = new ArrayList(16);
        for (Map.Entry<Long, ConmBillInfo> next : checkTolerance.entrySet()) {
            ConmBillInfo conmBillInfo = next.getValue();
            Long conmId = next.getKey();
            Long conmReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            BigDecimal paidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
            BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = conmBillInfo.getConmAmount() == null ? BigDecimal.ZERO : conmBillInfo.getConmAmount();
            Long conmSettleCurrency = conmBillInfo.getConmSettleCurrencyId() == null ? Long.valueOf(0L) : conmBillInfo.getConmSettleCurrencyId();
            Integer currencyPrecision = currencyPrecisionMap.get(conmBillInfo.getConmSettleCurrencyId()) == null ? Integer.valueOf(10) : currencyPrecisionMap.get(conmBillInfo.getConmSettleCurrencyId());
            HashMap<String, Number> param = new HashMap<String, Number>(10);
            param.put("pk", conmId);
            param.put("bd_supplier", supplierMasterIdMap.get(conmReceiveSupplierId));
            param.put("controlvalue", paidAmount.add(currentAmount));
            param.put("contrastvalue", coreTotalAllAmount);
            param.put("bd_currency", conmSettleCurrency);
            param.put("precision", currencyPrecision);
            params.add(param);
        }
        if (!params.isEmpty()) {
            Map results = null;
            results = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ToleranceMatchService", (String)"getAllResult", (Object[])new Object[]{"cas_paybill", "conm_purcontract", "e_payableamt", "totalallamount", params});
            List overpks = (List)results.get("overpks");
            List failtomatchIds = (List)results.get("failtomatch");
            if (overpks != null && !overpks.isEmpty()) {
                overToleranceId.addAll(overpks);
            }
            if (failtomatchIds != null && !failtomatchIds.isEmpty()) {
                for (Long conmIdfailToMatch : failtomatchIds) {
                    BigDecimal conmTotalAllAmount;
                    ConmBillInfo conmBillInfo = checkTolerance.get(conmIdfailToMatch);
                    BigDecimal paidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
                    BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
                    BigDecimal bigDecimal = conmTotalAllAmount = conmBillInfo.getConmAmount() == null ? BigDecimal.ZERO : conmBillInfo.getConmAmount();
                    if (paidAmount.add(currentAmount).compareTo(conmTotalAllAmount) <= 0) continue;
                    overToleranceId.add(conmIdfailToMatch);
                }
            }
        }
        return overToleranceId;
    }

    private Map<Long, String> validPO(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashMap<Long, String> errorMsg = new HashMap<Long, String>(10);
        if (poInfoMap.isEmpty()) {
            return errorMsg;
        }
        Iterator<Map.Entry<String, POBillInfo>> iterator = poInfoMap.entrySet().iterator();
        HashMap<String, POBillInfo> checkTolerance = new HashMap<String, POBillInfo>(10);
        while (iterator.hasNext()) {
            BigDecimal currentPaidAmount;
            Map.Entry<String, POBillInfo> next = iterator.next();
            POBillInfo poBillInfo = next.getValue();
            BigDecimal paidAmount = poBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : poBillInfo.getPaidAmount();
            BigDecimal currentAmount = poBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : poBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = poBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : poBillInfo.getCoreTotalAllAmount();
            if (coreTotalAllAmount.compareTo(currentPaidAmount = paidAmount.add(currentAmount)) >= 0) {
                poBillInfo.setSuccess(Boolean.TRUE);
                continue;
            }
            checkTolerance.put(next.getKey(), poBillInfo);
        }
        if (checkTolerance.isEmpty()) {
            return errorMsg;
        }
        Set<String> overToleranceId = this.processTolerance(checkTolerance, supplierMasterIdMap, currencyPrecisionMap);
        if (!overToleranceId.isEmpty()) {
            for (Map.Entry<String, POBillInfo> poBillInfoEntry : poInfoMap.entrySet()) {
                if (poBillInfoEntry == null) continue;
                String demKey = poBillInfoEntry.getKey();
                POBillInfo poBillInfo = poBillInfoEntry.getValue();
                if (overToleranceId.contains(demKey)) {
                    poBillInfo.setSuccess(Boolean.FALSE);
                    errorMsg.put(poBillInfo.getPayBillId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff0c\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355%2$s\u7684\u4ef7\u7a0e\u5408\u8ba1\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurOrderFiValidateService_7", (String)"scmc-pm-mservice", (Object[])new Object[0]), poBillInfo.getPayBillNo(), poBillInfo.getCoreBillNo()));
                    continue;
                }
                poBillInfo.setSuccess(Boolean.TRUE);
            }
        }
        return errorMsg;
    }

    private void filterByIsOverPayFlag(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, POBillInfo>> poIt = poInfoMap.entrySet().iterator();
        while (poIt.hasNext()) {
            POBillInfo poBillInfo = poIt.next().getValue();
            Boolean coreBillIsAllowOverPay = poBillInfo.getCoreBillIsAllowOverPay();
            if (!coreBillIsAllowOverPay.booleanValue()) continue;
            poIt.remove();
        }
        Iterator<Map.Entry<Long, ConmBillInfo>> conmIt = conmInfoMap.entrySet().iterator();
        while (conmIt.hasNext()) {
            ConmBillInfo conmBillInfo = conmIt.next().getValue();
            if (!conmBillInfo.getConmIsAllowOverPay().booleanValue()) continue;
            conmIt.remove();
        }
    }

    private void addPaidAmount(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        if (poInfoMap.isEmpty() && conmInfoMap.isEmpty()) {
            return;
        }
        Map<String, Long> allConmDemKeyAndConmId = this.getAllConmDemKey(conmInfoMap);
        List<QFilter> filters = this.getQueryPayBillFilter(poInfoMap, conmInfoMap);
        try (DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_paybill", (String)String.join((CharSequence)",", this.getQueryPayBillField()), (QFilter[])filters.toArray(new QFilter[0]), null);){
            DataSet sumPaidAmount = payBillDataSet.groupBy(new String[]{"corebillid", "settleorg", "payee"}).sum("e_payableamt-e_refundamt", "paidamount").finish().select("corebillid,settleorg,payee,paidamount");
            for (Row row : sumPaidAmount) {
                ConmBillInfo conmBillInfo;
                String conmValidDemKey;
                Long conmId;
                POBillInfo poBillInfo;
                Long coreBillId = row.getLong("corebillid");
                Long settleOrgId = row.getLong("settleorg");
                Long payee = row.getLong("payee");
                BigDecimal payBillPaidamount = row.getBigDecimal("paidamount") == null ? BigDecimal.ZERO : row.getBigDecimal("paidamount");
                String validDemKey = this.getValidDemKey(settleOrgId, coreBillId, payee);
                if (validDemKey != null && (poBillInfo = poInfoMap.get(validDemKey)) != null) {
                    BigDecimal paidAmount = poBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : poBillInfo.getPaidAmount();
                    poBillInfo.setPaidAmount(paidAmount.add(payBillPaidamount));
                }
                if ((conmId = allConmDemKeyAndConmId.get(conmValidDemKey = this.getConmValidDemKey(coreBillId, payee))) == null || (conmBillInfo = conmInfoMap.get(conmId)) == null) continue;
                BigDecimal conmPaidAmount = conmBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : conmBillInfo.getPaidAmount();
                conmBillInfo.setPaidAmount(conmPaidAmount.add(payBillPaidamount));
            }
        }
    }

    private Map<String, Long> getAllConmDemKey(Map<Long, ConmBillInfo> conmInfoMap) {
        if (conmInfoMap.isEmpty()) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> conmDemKey = new HashMap<String, Long>(conmInfoMap.size());
        for (ConmBillInfo conmBillInfo : conmInfoMap.values()) {
            Long conmId = conmBillInfo.getConmId();
            Long conmReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            conmDemKey.put(this.getConmValidDemKey(conmId, conmReceiveSupplierId), conmId);
            Set poIds = conmBillInfo.getPoIds();
            if (poIds == null || poIds.isEmpty()) continue;
            for (Long poId : poIds) {
                conmDemKey.put(this.getConmValidDemKey(poId, conmReceiveSupplierId), conmId);
            }
        }
        return conmDemKey;
    }

    private List<QFilter> getQueryPayBillFilter(Map<String, POBillInfo> poInfoMap, Map<Long, ConmBillInfo> conmInfoMap) {
        Date earliestTime = this.getEarliestCreateTime(poInfoMap, conmInfoMap);
        HashSet<Long> allCoreBillIds = new HashSet<Long>(10);
        HashSet<Long> allReciSupplierIds = new HashSet<Long>(10);
        for (Map.Entry<String, POBillInfo> entry : poInfoMap.entrySet()) {
            POBillInfo poBillInfo = entry.getValue();
            allCoreBillIds.add(poBillInfo.getCoreBillId());
            allReciSupplierIds.add(poBillInfo.getCoreBillReceiveSupplierId());
        }
        for (ConmBillInfo conmBillInfo : conmInfoMap.values()) {
            allCoreBillIds.add(conmBillInfo.getConmId());
            Set poIds = conmBillInfo.getPoIds();
            if (poIds != null && !poIds.isEmpty()) {
                allCoreBillIds.addAll(poIds);
            }
            Long conmBillReceiveSupplierId = conmBillInfo.getConmReceiveSupplierId();
            allReciSupplierIds.add(conmBillInfo.getConmReceiveSupplierId());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("entry.e_corebillid", "in", allCoreBillIds));
        filters.add(new QFilter("billstatus", "not in", (Object)new String[]{"F", "G", "H", "A"}));
        if (earliestTime != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getStartOfDay((Date)earliestTime)));
        }
        filters.add(new QFilter("payee", "in", allReciSupplierIds));
        return filters;
    }

    private Map<Long, ConmBillInfo> addConmInfo(Map<Long, ConmBillInfo> conmInfoMap, DataSet dataSet) {
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            ConmBillInfo conmBillInfo = conmInfoMap.get(id);
            if (conmBillInfo == null) continue;
            conmBillInfo.setConmBillNo(row.getString("billno"));
            conmBillInfo.setConmId(id);
            conmBillInfo.setConmAmount(row.getBigDecimal("billentry.amountandtax"));
            conmBillInfo.setConmCreateTime(row.getDate("createtime"));
            conmBillInfo.setConmIsAllowOverPay(row.getBoolean("isallowoverpay"));
            conmBillInfo.setConmSettleCurrencyId(row.getLong("settlecurrency"));
            conmBillInfo.setConmReceiveSupplierId(row.getLong("receivesupplier"));
        }
        return conmInfoMap;
    }

    private Map<String, POBillInfo> addPoInfo(Map<String, POBillInfo> poInfoMap, List<Map<String, Object>> queryPoInfo, Map<Long, ConmBillInfo> conmBillInfoMap) {
        for (Map<String, Object> poInfo : queryPoInfo) {
            Long poId = (Long)poInfo.get("billid");
            Boolean isallowoverpay = (Boolean)poInfo.get("isallowoverpay");
            Long settleCurrency = (Long)poInfo.get("settlecurrency");
            Long poReceivesupplier = poInfo.get("receivesupplier") == null ? Long.valueOf(0L) : (Long)poInfo.get("receivesupplier");
            Date createtime = (Date)poInfo.get("createtime");
            String coreBillNo = (String)poInfo.get("billno");
            List entryinfoList = (List)poInfo.get("entryinfo");
            if (entryinfoList == null || entryinfoList.isEmpty()) continue;
            for (Map poEntryInfo : entryinfoList) {
                Object conbillid;
                BigDecimal amountandtax;
                Long settleOrg = poEntryInfo.get("settleorg") == null ? Long.valueOf(0L) : (Long)poEntryInfo.get("settleorg");
                String validDemKey = this.getValidDemKey(settleOrg, poId, poReceivesupplier);
                BigDecimal bigDecimal = amountandtax = poEntryInfo.get("amountandtax") == null ? BigDecimal.ZERO : (BigDecimal)poEntryInfo.get("amountandtax");
                POBillInfo poBillInfo = poInfoMap.get(validDemKey);
                if (poBillInfo == null) continue;
                BigDecimal coreTotalAllAmount = poBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : poBillInfo.getCoreTotalAllAmount();
                poBillInfo.setCoreTotalAllAmount(coreTotalAllAmount.add(amountandtax));
                if (poBillInfo.getCoreBillNo() == null) {
                    poBillInfo.setCoreBillNo(coreBillNo);
                }
                if (poBillInfo.getCoreBillCreateTime() == null) {
                    poBillInfo.setCoreBillCreateTime(createtime);
                }
                if (poBillInfo.getCoreBillSettleCurrency() == null) {
                    poBillInfo.setCoreBillSettleCurrency(settleCurrency);
                }
                if (poBillInfo.getCoreBillReceiveSupplierId() == null) {
                    poBillInfo.setCoreBillReceiveSupplierId(poReceivesupplier);
                }
                if (poBillInfo.getCoreBillSettleOrgId() == null) {
                    poBillInfo.setCoreBillSettleOrgId(settleOrg);
                }
                if (poBillInfo.getCoreBillIsAllowOverPay() == null) {
                    poBillInfo.setCoreBillIsAllowOverPay(isallowoverpay);
                }
                if ((conbillid = poEntryInfo.get("conbillid")) == null) continue;
                ConmBillInfo conmBillInfo = new ConmBillInfo(poBillInfo.getPayBillId(), poBillInfo.getPayBillNo());
                conmBillInfoMap.put((Long)conbillid, conmBillInfo);
                conmBillInfo.setPayBillPayeeId(poBillInfo.getPayBillPayeeId());
            }
        }
        return poInfoMap;
    }

    private Map<Long, ConmBillInfo> getConmBillInfo(List<Map<String, Object>> payBills, Map<Long, Set<Long>> queryConmIds) {
        HashMap<Long, ConmBillInfo> conmInfoMap = new HashMap<Long, ConmBillInfo>(10);
        for (Map<String, Object> payBill : payBills) {
            if (payBill == null) continue;
            Long payBillId = (Long)payBill.get("id");
            String payBillNo = (String)payBill.get("billno");
            Long payee = (Long)payBill.get("payee");
            List payBillEntry = (List)payBill.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"conm_purcontract".equals(coreBillEntity)) continue;
                Long coreBillId = (Long)payBillRow.get("e_corebillid");
                BigDecimal payableAmt = (BigDecimal)payBillRow.get("e_payableamt");
                BigDecimal refundAmt = (BigDecimal)payBillRow.get("e_refundamt");
                Long settleOrgId = 0L;
                Object settleorg = payBillRow.get("settleorg");
                if (settleorg != null) {
                    Long l = settleOrgId = settleorg instanceof DynamicObject ? (Long)((DynamicObject)settleorg).getPkValue() : (Long)settleorg;
                }
                if (coreBillId == 0L || payableAmt == null || refundAmt == null || settleOrgId == 0L) continue;
                String conmvalidDemKey = this.getConmValidDemKey(coreBillId, payee);
                ConmBillInfo conmBillInfo = (ConmBillInfo)conmInfoMap.get(coreBillId);
                if (conmBillInfo == null) {
                    conmBillInfo = new ConmBillInfo(payBillId, payBillNo);
                }
                BigDecimal currentAmount = conmBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : conmBillInfo.getCurrentAmount();
                conmBillInfo.setCurrentAmount(currentAmount.add(payableAmt.subtract(refundAmt)));
                if (conmBillInfo.getPayBillPayeeId() == null) {
                    conmBillInfo.setPayBillPayeeId(payee);
                }
                if (conmBillInfo.getPayBillSettleOrgId() == null) {
                    conmBillInfo.setPayBillSettleOrgId(settleOrgId);
                }
                conmInfoMap.put(coreBillId, conmBillInfo);
                queryConmIds.put(coreBillId, new HashSet(1));
            }
        }
        return conmInfoMap;
    }

    private Map<String, POBillInfo> getPOBillInfo(List<Map<String, Object>> payBills, Map<Long, Set<Long>> queryPoIds) {
        HashMap<String, POBillInfo> coreBillDemAndPayAmountMap = new HashMap<String, POBillInfo>(10);
        for (Map<String, Object> payBill : payBills) {
            if (payBill == null) continue;
            Long payBillId = (Long)payBill.get("id");
            String payBillNo = (String)payBill.get("billno");
            Long payee = (Long)payBill.get("payee");
            List payBillEntry = (List)payBill.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"pm_purorderbill".equals(coreBillEntity)) continue;
                Long coreBillId = (Long)payBillRow.get("e_corebillid");
                BigDecimal payableAmt = (BigDecimal)payBillRow.get("e_payableamt");
                BigDecimal refundAmt = (BigDecimal)payBillRow.get("e_refundamt");
                Long settleOrgId = 0L;
                Object settleorg = payBillRow.get("settleorg");
                if (settleorg != null) {
                    Long l = settleOrgId = settleorg instanceof DynamicObject ? (Long)((DynamicObject)settleorg).getPkValue() : (Long)settleorg;
                }
                if (coreBillId == 0L || payableAmt == null || refundAmt == null || settleOrgId == 0L) continue;
                String validDemKey = this.getValidDemKey(settleOrgId, coreBillId, payee);
                POBillInfo coreBillInfo = (POBillInfo)coreBillDemAndPayAmountMap.get(validDemKey);
                if (coreBillInfo == null) {
                    coreBillInfo = new POBillInfo(payBillId, payBillNo);
                }
                BigDecimal currentAmount = coreBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCurrentAmount();
                coreBillInfo.setCurrentAmount(currentAmount.add(payableAmt.subtract(refundAmt)));
                if (coreBillInfo.getPayBillId() == null) {
                    coreBillInfo.setPayBillId(payBillId);
                }
                if (coreBillInfo.getPayBillNo() == null) {
                    coreBillInfo.setPayBillNo(payBillNo);
                }
                if (coreBillInfo.getCoreBillId() == null) {
                    coreBillInfo.setCoreBillId(coreBillId);
                }
                if (coreBillInfo.getPayBillNo() == null) {
                    coreBillInfo.setPayBillNo(payBillNo);
                }
                if (coreBillInfo.getPayBillPayeeId() == null) {
                    coreBillInfo.setPayBillPayeeId(payee);
                }
                if (coreBillInfo.getPayBillSettleOrgId() == null) {
                    coreBillInfo.setPayBillSettleOrgId(settleOrgId);
                }
                coreBillDemAndPayAmountMap.put(validDemKey, coreBillInfo);
                queryPoIds.put(coreBillId, new HashSet(1));
            }
        }
        return coreBillDemAndPayAmountMap;
    }

    private Map<String, BigDecimal> queryPayBillPaidAMount(Set<Long> coreBillIds, Date earliestCreateTime, Set<Long> receiveSupplierId) {
        HashMap<String, BigDecimal> coreBillDemKeyPaidAmount = new HashMap<String, BigDecimal>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("entry.e_corebillid", "in", coreBillIds));
        filters.add(new QFilter("billstatus", "not in", (Object)new String[]{"F", "G", "H", "A"}));
        if (earliestCreateTime != null) {
            filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getStartOfDay((Date)earliestCreateTime)));
        }
        filters.add(new QFilter("payee", "in", receiveSupplierId));
        List<String> queryFields = this.getQueryPayBillField();
        String selectStr = String.join((CharSequence)",", queryFields);
        try (DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_paybill", (String)selectStr, (QFilter[])filters.toArray(new QFilter[0]), null);){
            DataSet sumPaidAmount = payBillDataSet.groupBy(new String[]{"corebillid", "settleorg", "payee"}).sum("e_payableamt-e_refundamt", "paidamount").finish().select("corebillid,settleorg,payee,paidamount");
            for (Row row : sumPaidAmount) {
                Long coreBillId = row.getLong("corebillid");
                Long settleOrgId = row.getLong("settleorg");
                Long payee = row.getLong("payee");
                BigDecimal paidamount = row.getBigDecimal("paidamount");
                coreBillDemKeyPaidAmount.put(this.getValidDemKey(settleOrgId, coreBillId, payee), paidamount);
            }
        }
        return coreBillDemKeyPaidAmount;
    }

    private Date getEarliestCreateTime(Map<String, POBillInfo> poBillInfoMap, Map<Long, ConmBillInfo> conmBillInfoMap) {
        Date earliestCreateTime = null;
        for (POBillInfo coreBillInfo : poBillInfoMap.values()) {
            Long coreBillId = coreBillInfo.getCoreBillId();
            Long conmId = coreBillInfo.getConmId();
            Date coreBillCreateTime = coreBillInfo.getCoreBillCreateTime();
            if (coreBillCreateTime == null) continue;
            if (earliestCreateTime == null) {
                earliestCreateTime = coreBillCreateTime;
            }
            if (!coreBillCreateTime.before(earliestCreateTime)) continue;
            earliestCreateTime = coreBillCreateTime;
        }
        for (ConmBillInfo conmBillInfo : conmBillInfoMap.values()) {
            Date conmCreateTime = conmBillInfo.getConmCreateTime();
            if (conmCreateTime == null || earliestCreateTime == null || !conmCreateTime.before(earliestCreateTime)) continue;
            earliestCreateTime = conmCreateTime;
        }
        return earliestCreateTime;
    }

    private Set<String> processTolerance(Map<String, POBillInfo> poBillInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashSet<String> overToleranceId = new HashSet<String>(16);
        ArrayList params = new ArrayList(16);
        for (Map.Entry<String, POBillInfo> next : poBillInfoMap.entrySet()) {
            POBillInfo coreBillInfo = next.getValue();
            String key = next.getKey();
            BigDecimal paidAmount = coreBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : coreBillInfo.getPaidAmount();
            BigDecimal currentAmount = coreBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount();
            HashMap<String, Object> param = new HashMap<String, Object>(10);
            param.put("pk", key);
            param.put("bd_supplier", supplierMasterIdMap.get(coreBillInfo.getCoreBillReceiveSupplierId()));
            param.put("controlvalue", paidAmount.add(currentAmount));
            param.put("contrastvalue", coreTotalAllAmount);
            param.put("bd_currency", coreBillInfo.getCoreBillSettleCurrency());
            param.put("precision", currencyPrecisionMap.get(coreBillInfo.getCoreBillSettleCurrency()));
            param.put("bos_org", coreBillInfo.getCoreBillSettleOrgId());
            params.add(param);
        }
        if (!params.isEmpty()) {
            Map results = null;
            results = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ToleranceMatchService", (String)"getAllResult", (Object[])new Object[]{"cas_paybill", "pm_purorderbill", "e_payableamt", "totalallamount", params});
            List overpks = (List)results.get("overpks");
            List failtomatch = (List)results.get("failtomatch");
            if (overpks != null && !overpks.isEmpty()) {
                overToleranceId.addAll(overpks);
            }
            if (failtomatch != null && !failtomatch.isEmpty()) {
                for (String failMatch : failtomatch) {
                    BigDecimal coreTotalAllAmount;
                    POBillInfo coreBillInfo = poBillInfoMap.get(failMatch);
                    BigDecimal paidAmount = coreBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : coreBillInfo.getPaidAmount();
                    BigDecimal currentAmount = coreBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCurrentAmount();
                    BigDecimal bigDecimal = coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCoreTotalAllAmount();
                    if (paidAmount.add(currentAmount).compareTo(coreTotalAllAmount) <= 0) continue;
                    overToleranceId.add(failMatch);
                }
            }
        }
        return overToleranceId;
    }

    private void addSupplierMasterIdAndCurrencyPrecision(Map<String, POBillInfo> coreBillIdInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashSet supplierIds = new HashSet(10);
        HashSet currencyIds = new HashSet(10);
        coreBillIdInfoMap.values().forEach(coreBillInfo -> {
            supplierIds.add(coreBillInfo.getCoreBillReceiveSupplierId());
            currencyIds.add(coreBillInfo.getCoreBillSettleCurrency());
        });
        Map supplierDB = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        Map currencyDB = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        if (supplierDB != null && !supplierDB.isEmpty()) {
            supplierDB.values().forEach(supplier -> supplierMasterIdMap.put(supplier.getLong("id"), supplier.getLong("masterid")));
        }
        if (currencyDB != null && !currencyDB.isEmpty()) {
            currencyDB.values().forEach(currency -> currencyPrecisionMap.put(currency.getLong("id"), currency.getInt("amtprecision")));
        }
    }

    private List<String> getQueryPayBillField() {
        ArrayList<String> keys = new ArrayList<String>(10);
        keys.add("entry.e_corebillid as corebillid");
        keys.add("entry.settleorg as settleorg");
        keys.add("entry.e_payableamt as e_payableamt");
        keys.add("entry.e_refundamt as e_refundamt");
        keys.add("payee");
        return keys;
    }

    private List<Map<String, Object>> getValidPayBills(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> payBills = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> param : params) {
            Long payee;
            if (param == null || param.isEmpty() || (payee = (Long)param.get("payee")) == null || payee == 0L) continue;
            boolean hasCoreBillInfo = false;
            List payBillEntry = (List)param.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                Long coreBillId;
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"pm_purorderbill".equals(coreBillEntity) && !"conm_purcontract".equals(coreBillEntity) || (coreBillId = (Long)payBillRow.get("e_corebillid")) == null || coreBillId == 0L) continue;
                hasCoreBillInfo = true;
                break;
            }
            if (!hasCoreBillInfo) continue;
            payBills.add(param);
        }
        return payBills;
    }

    private String getValidDemKey(Long settleOrgId, Long billId, Long recSupplierId) {
        if (settleOrgId == null || billId == null || recSupplierId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(settleOrgId).append('_').append(billId).append('_').append(recSupplierId);
        return sb.toString();
    }

    private String getConmValidDemKey(Long billId, Long recSupplierId) {
        if (billId == null || recSupplierId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(billId).append('_').append(recSupplierId);
        return sb.toString();
    }
}

