/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sbs.business.sn.biz;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.util.BalQuery;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sbs.business.sn.SNBillConfigHelper;
import kd.scmc.sbs.business.sn.biz.SerialNumberOldOperator;
import kd.scmc.sbs.business.sn.mainfile.SNMainFileStatusCalHelper;
import kd.scmc.sbs.business.sn.mainfile.SNMainFileStatusValidateHelper;
import kd.scmc.sbs.common.model.sn.InvCounterEntity;

public class SerialNumberOperator
implements Serializable {
    private static final Log logger = LogFactory.getLog(SerialNumberOperator.class);
    private static String DIM_PRE = "dim";
    private static List<String> balCols = Arrays.asList("id", "baseqty");
    private DynamicObject cfg;
    private List<Long> billIds;
    private String operate;
    private Map<String, Set<Long>> hasHandleBillMap;
    private Set<Long> hasHandleBillIds;
    private Set<Long> handleBillIds;
    private Object[] handleBillIdsArray;
    private Long masterfiletypeid;
    private String billtype;
    private String entrytype;
    private String entrypath;
    private String entrypathId;
    private boolean allowsplit;
    private String seqcol;
    private String materialcol;
    private String materialmastercol;
    private String invorgcol;
    private String lotnumcol;
    private String snbaseqtycol;
    private int allbaseqty = 0;
    private Map<String, Object> opeAttrMap;
    private LinkedHashMap<String, String> snmainfMaps;
    private LinkedHashMap<String, String> trackMaps;
    private List<DynamicObject> snEnterLists = new ArrayList<DynamicObject>();
    private List<DynamicObject> mainFileUpdate = new ArrayList<DynamicObject>();
    private List<DynamicObject> trackUpdate = new ArrayList<DynamicObject>();
    private Set<String> snUnqctrl;
    private Map<Integer, Map<String, Object>> dims;
    private LinkedHashMap<String, String> snmainfExtRelMaps = new LinkedHashMap();
    private LinkedHashMap<String, String> trackExtRelMaps = new LinkedHashMap();
    private boolean isreqbill;
    private Map<Long, DynamicObject> billentriesMap;
    private Map<Long, Map<String, Object>> reqbillMap;
    private static final String TRACK_TAG = "t_";
    private static final String MAINFILE_TAG = "m_";
    private static String layoutType;
    private Map<String, IDataEntityProperty> billRelationProperties;
    private LinkedHashMap<String, String> snMainFileNoConditionMap;

    public static SerialNumberOperator build(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        return new SerialNumberOperator(cfg, billIds, operate, hasHandleBillMap);
    }

    private SerialNumberOperator(DynamicObject cfg, List<Long> billIds, String operate, Map<String, Set<Long>> hasHandleBillMap) {
        this.cfg = cfg;
        this.billIds = billIds;
        this.operate = operate;
        this.hasHandleBillMap = hasHandleBillMap;
        this.buildOperator();
    }

    private void buildOperator() {
        this.masterfiletypeid = this.cfg.getDynamicObject("masterfiletype").getLong("id");
        this.billtype = this.cfg.getDynamicObject("srcbillobj").getString("number");
        this.entrytype = this.cfg.getString("srcbillentry");
        this.entrypath = SNBillConfigHelper.getEntryPath(this.billtype, this.entrytype);
        this.entrypathId = this.entrypath + ".id";
        this.allowsplit = this.cfg.getBoolean("allowsplit");
        this.opeAttrMap = SNBillConfigHelper.getCfgOpeAttrMap(this.cfg, this.operate);
        this.isreqbill = (Boolean)this.opeAttrMap.get("snreqbill");
        this.seqcol = this.entrypath + ".seq";
        this.materialcol = SNBillConfigHelper.getMaterialCol(this.cfg);
        this.materialmastercol = SNBillConfigHelper.getMaterialMasterCol(this.cfg);
        if (StringUtils.isNotEmpty((String)this.materialcol) && StringUtils.isEmpty((String)this.materialmastercol)) {
            this.materialmastercol = this.materialcol + ".masterid";
        }
        this.invorgcol = SNBillConfigHelper.getInvOrgSrcCol(this.cfg);
        this.lotnumcol = SNBillConfigHelper.getLotNumSrcCol(this.cfg);
        this.snbaseqtycol = SNBillConfigHelper.getSnBaseqtyCol(this.cfg);
        this.hasHandleBillIds = this.hasHandleBillMap.getOrDefault(this.entrytype, new HashSet(this.billIds.size()));
        this.handleBillIds = new HashSet<Long>(this.billIds);
        this.handleBillIds.removeAll(this.hasHandleBillIds);
        if (this.handleBillIds.isEmpty()) {
            this.billentriesMap = Collections.emptyMap();
            return;
        }
        this.snUnqctrl = SNBillConfigHelper.getSnUnqctrl();
        this.dims = SNBillConfigHelper.getSndims();
        this.snEnterLists = SNBillConfigHelper.getSnEnterMaps(this.cfg);
        this.getSnMainfAndTrackMaps();
        this.billRelationProperties = SNBillConfigHelper.getBillRelationProperties(this.cfg);
        layoutType = SNBillConfigHelper.getLayoutType(this.cfg);
        QFilter filter = this.buildBillFilter();
        String billSelectProps = this.buildBillSelectProps();
        DynamicObjectCollection billentries = QueryServiceHelper.query((String)this.billtype, (String)billSelectProps, (QFilter[])filter.toArray());
        this.billentriesMap = new HashMap<Long, DynamicObject>(billentries.size());
        if (billentries != null && billentries.size() > 0) {
            this.handleBillIds.clear();
            for (DynamicObject billentry : billentries) {
                Long billId = billentry.getLong("id");
                Long entryId = billentry.getLong(this.entrypathId);
                this.allbaseqty += Math.abs(billentry.getInt(this.snbaseqtycol));
                boolean enableSerial = false;
                if (StringUtils.isNotEmpty((String)this.materialcol)) {
                    Long materialInvId = billentry.getLong(this.materialcol);
                    QFilter invInfoFilter = new QFilter("id", "=", (Object)materialInvId).and("enableserial", "=", (Object)true);
                    enableSerial = QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])invInfoFilter.toArray());
                } else {
                    long invOrgId;
                    Long materialMasterId = billentry.getLong(this.materialmastercol);
                    DynamicObject materialInvInfo = SNBillConfigHelper.getMaterialInvInfo(materialMasterId, invOrgId = billentry.getLong(this.invorgcol));
                    if (materialInvInfo != null) {
                        enableSerial = materialInvInfo.getBoolean("enableserial");
                    }
                }
                if (!enableSerial) continue;
                this.hasHandleBillIds.add(billId);
                this.handleBillIds.add(billId);
                this.billentriesMap.put(entryId, billentry);
            }
            if (!this.hasHandleBillMap.containsKey(this.entrytype)) {
                this.hasHandleBillMap.put(this.entrytype, this.hasHandleBillIds);
            }
            this.handleBillIdsArray = this.handleBillIds.toArray();
        }
    }

    private QFilter buildBillFilter() {
        QFilter cfgFilter;
        QFilter filter = new QFilter("id", "in", this.handleBillIds);
        if (StringUtils.isNotEmpty((String)this.materialcol)) {
            filter.and(this.materialcol + ".enableserial", "=", (Object)Boolean.TRUE);
        }
        if ((cfgFilter = SNBillConfigHelper.parseBillFilter(this.cfg.getString("billfilter"), this.billtype)) != null) {
            filter.and(cfgFilter);
        }
        return filter;
    }

    private String buildBillSelectProps() {
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        selectPropsBuilder.append(',').append(this.entrypathId);
        HashSet<String> selectSourceCols = new HashSet<String>(this.snmainfMaps.size() + this.trackMaps.size() + 6);
        selectSourceCols.add(this.seqcol);
        selectSourceCols.add("billno");
        if (StringUtils.isNotEmpty((String)this.materialcol)) {
            selectSourceCols.add(this.materialcol);
        }
        if (StringUtils.isNotEmpty((String)this.materialmastercol)) {
            selectSourceCols.add(this.materialmastercol);
        }
        selectSourceCols.add(this.invorgcol);
        if (!this.lotnumcol.isEmpty()) {
            selectSourceCols.add(this.lotnumcol);
        }
        selectSourceCols.add(this.snbaseqtycol);
        if (this.snmainfMaps.size() > 0) {
            selectSourceCols.addAll(this.snmainfMaps.values());
        }
        if (this.trackMaps.size() > 0) {
            selectSourceCols.addAll(this.trackMaps.values());
        }
        selectPropsBuilder.append(',').append(String.join((CharSequence)",", selectSourceCols));
        return selectPropsBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operateExec() {
        DataSet serialNumberDataSet;
        Object mutexIds;
        if (this.billentriesMap.isEmpty()) {
            return;
        }
        List snServicesList = (List)this.opeAttrMap.get("snservices");
        if (snServicesList.contains("2") || snServicesList.contains("4")) {
            this.reqbillMap = new HashMap<Long, Map<String, Object>>();
            this.getReqBillMap(this.billentriesMap.keySet(), this.reqbillMap);
        }
        if (snServicesList.contains("1")) {
            SerialNumberOldOperator.clearOldmovetrack(this.handleBillIds);
            Map<Long, Long> entryTrackMap = this.refreshSnmoveTrack();
            try (DataSet serialNumberDataSet2 = this.getBillSNDataSet();){
                mutexIds = this.checkMutex(serialNumberDataSet2);
            }
            try {
                serialNumberDataSet2 = this.getBillSNDataSet();
                var5_8 = null;
                try (DataSet dataSet = serialNumberDataSet2.copy();){
                    this.checkOccupy(dataSet);
                    this.operateSNDataSubmit(serialNumberDataSet2, entryTrackMap);
                }
                catch (Throwable throwable) {
                    var5_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (serialNumberDataSet2 != null) {
                        if (var5_8 != null) {
                            try {
                                serialNumberDataSet2.close();
                            }
                            catch (Throwable throwable) {
                                var5_8.addSuppressed(throwable);
                            }
                        } else {
                            serialNumberDataSet2.close();
                        }
                    }
                }
                this.removeMutex((Set<Long>)mutexIds);
            }
            catch (Throwable throwable) {
                this.removeMutex((Set<Long>)mutexIds);
                throw throwable;
            }
        }
        if (snServicesList.contains("2")) {
            new SerialNumberOldOperator(this.billtype, this.entrytype, this.entrypath, this.handleBillIds, this.billentriesMap, this.materialmastercol, "2", this.opeAttrMap).handleOldmovetrack();
            serialNumberDataSet = this.getSNTrackAndMainfDataSet("B", false, true);
            mutexIds = null;
            try {
                this.operateSNDataUnHandle(serialNumberDataSet, "2");
            }
            catch (Throwable serialNumberDataSet3) {
                mutexIds = serialNumberDataSet3;
                throw serialNumberDataSet3;
            }
            finally {
                if (serialNumberDataSet != null) {
                    if (mutexIds != null) {
                        try {
                            serialNumberDataSet.close();
                        }
                        catch (Throwable serialNumberDataSet3) {
                            ((Throwable)mutexIds).addSuppressed(serialNumberDataSet3);
                        }
                    } else {
                        serialNumberDataSet.close();
                    }
                }
            }
        }
        if (snServicesList.contains("3")) {
            new SerialNumberOldOperator(this.billtype, this.entrytype, this.entrypath, this.handleBillIds, this.billentriesMap, this.materialmastercol, "3", this.opeAttrMap).handleOldmovetrack();
            Map<String, Object> balanceinfo = SNBillConfigHelper.getBalanceInfo(this.cfg);
            String balancetype = " ";
            if (balanceinfo != null) {
                balancetype = (String)balanceinfo.get("balancetype");
            }
            Map<Long, Long> invaccMap = this.getInvaccMap(balanceinfo);
            try (DataSet serialNumberDataSet4 = this.getSNTrackAndMainfDataSet("B", false, false);){
                this.operateSNDataAudit(serialNumberDataSet4, invaccMap, balancetype);
            }
        }
        if (snServicesList.contains("4")) {
            new SerialNumberOldOperator(this.billtype, this.entrytype, this.entrypath, this.handleBillIds, this.billentriesMap, this.materialmastercol, "4", this.opeAttrMap).handleOldmovetrack();
            serialNumberDataSet = this.getSNTrackAndMainfDataSet("C", true, true);
            Throwable throwable = null;
            try {
                this.operateSNDataUnHandle(serialNumberDataSet, "4");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (serialNumberDataSet != null) {
                    if (throwable != null) {
                        try {
                            serialNumberDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        serialNumberDataSet.close();
                    }
                }
            }
        }
    }

    public void updateBillSnRelStatus() {
        if (this.billentriesMap.isEmpty()) {
            return;
        }
        List snServicesList = (List)this.opeAttrMap.get("snservices");
        if (snServicesList.contains("1")) {
            this.updBillSnRelTo("B");
        }
        if (snServicesList.contains("2") || snServicesList.contains("4")) {
            this.updBillSnRelTo("A");
        }
    }

    private void checkOccupy(DataSet dataSet) {
        StringBuilder msgBuilder = new StringBuilder();
        for (Row row : dataSet) {
            Long billId = row.getLong("billid");
            Long entryId = row.getLong("entryid");
            Long occupyBillId = row.getLong("occupybillid");
            Long occupyBillEntryId = row.getLong("occupybillentryid");
            if (occupyBillId == null || occupyBillId.equals(0L) || occupyBillEntryId == null || occupyBillEntryId.equals(0L) || billId.equals(occupyBillId) || !SNMainFileStatusValidateHelper.checkOccupyMove((Long)billId, (String)this.billtype, (Long)entryId, (String)this.entrytype, (Long)occupyBillId, (Long)occupyBillEntryId)) continue;
            String billNo = row.getString("billno");
            Integer seq = row.getInteger("entrylineseq");
            String snNumber = row.getString("snnumber");
            msgBuilder.append(this.getOccupyMsg(billNo, seq, snNumber));
        }
        if (msgBuilder.length() > 0) {
            throw new KDBizException(msgBuilder.toString());
        }
    }

    private Set<Long> checkMutex(DataSet serialNumberDataSet) {
        DynamicObjectCollection mutexInfos;
        Object[] bills;
        Serializable invorgid;
        this.removeTimeOutMutex();
        ArrayList<DynamicObject> mutexList = new ArrayList<DynamicObject>();
        HashSet<String> keyMap = new HashSet<String>();
        HashSet<String> snNumbers = new HashSet<String>();
        HashSet<Serializable> invOrgIds = new HashSet<Serializable>();
        HashSet<Long> materialIds = new HashSet<Long>();
        HashSet<String> curBillNos = new HashSet<String>();
        ORM orm = ORM.create();
        for (Row row : serialNumberDataSet) {
            invorgid = row.getLong("mfinvorg");
            if (SerialNumberOperator.isEmpty((Long)invorgid)) {
                invorgid = row.getLong("sninvorg");
            }
            if (SerialNumberOperator.isEmpty((Long)invorgid)) {
                invorgid = row.getLong("invorgid");
            }
            String snNumber = row.getString("snnumber");
            Long materialMasterId = row.getLong("materialmasterid");
            String string = row.getString("billno");
            curBillNos.add(string);
            boolean notExist = keyMap.add(invorgid + snNumber + materialMasterId);
            if (notExist) {
                DynamicObject mutexInfo = orm.newDynamicObject("bd_snmutex");
                mutexInfo.set("invorg", (Object)invorgid);
                mutexInfo.set("snnumber", (Object)snNumber);
                mutexInfo.set("material", (Object)materialMasterId);
                mutexInfo.set("billno", (Object)string);
                mutexInfo.set("entryseq", (Object)row.getInteger("entrylineseq"));
                mutexList.add(mutexInfo);
            }
            snNumbers.add(snNumber);
            invOrgIds.add(invorgid);
            materialIds.add(materialMasterId);
        }
        TXHandle txHandle = TX.requiresNew();
        invorgid = null;
        try {
            bills = SaveServiceHelper.save((DynamicObject[])mutexList.toArray(new DynamicObject[0]));
        }
        catch (Throwable snNumber) {
            invorgid = snNumber;
            throw snNumber;
        }
        finally {
            if (txHandle != null) {
                if (invorgid != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable snNumber) {
                        ((Throwable)invorgid).addSuppressed(snNumber);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        HashSet<Long> addedMutexIds = new HashSet<Long>(bills.length);
        for (Serializable serializable : bills) {
            long billId = ((DynamicObject)serializable).getLong("id");
            addedMutexIds.add(billId);
        }
        QFilter filter = new QFilter("invorg", "in", invOrgIds).and("material", "in", materialIds).and("snnumber", "in", snNumbers);
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)"bd_snmutex");){
            lock.lock();
            mutexInfos = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bd_snmutex", (String)"billno,entryseq,invorg,snnumber,material", (QFilter[])filter.toArray(), (String)"");
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        StringBuilder msgBuilder = new StringBuilder();
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        for (DynamicObject mutexInfo : mutexInfos) {
            String snNumber = mutexInfo.getString("snnumber");
            Long invOrgId = mutexInfo.getLong("invorg");
            Long materialId = mutexInfo.getLong("material");
            String key = invOrgId + snNumber + materialId;
            if (!keyMap.contains(key)) continue;
            hashMap.computeIfAbsent(key, k -> new HashSet()).add(mutexInfo);
        }
        for (Set mutexs : hashMap.values()) {
            if (mutexs.size() <= 1) continue;
            for (DynamicObject mutex : mutexs) {
                String billno = mutex.getString("billno");
                if (!curBillNos.contains(billno)) continue;
                int entrySeq = mutex.getInt("entryseq");
                String snNumber = mutex.getString("snnumber");
                msgBuilder.append(this.getOccupyMsg(billno, entrySeq, snNumber));
            }
        }
        if (msgBuilder.length() > 0) {
            this.removeMutex(addedMutexIds);
            throw new KDBizException(msgBuilder.toString());
        }
        return addedMutexIds;
    }

    private String getOccupyMsg(String billno, int entrySeq, String snNumber) {
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append(billno).append(":");
        msgBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c", (String)"SupplyRelationSaveValidator_3", (String)"scmc-sbs-form", (Object[])new Object[0]), entrySeq));
        String msg = ResManager.loadKDString((String)"\u5f15\u7528\u4e86\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\u7684\u5e8f\u5217\u53f7\uff1a%1$s-%2$s\u3002", (String)"SNMainFileStatusValidateHelper_5", (String)"scmc-sbs-form", (Object[])new Object[0]);
        msg = msg.replace("-", "");
        msg = String.format(msg, snNumber, "");
        msgBuilder.append(msg).append("\n");
        return msgBuilder.toString();
    }

    private void removeMutex(Set<Long> mutexIds) {
        if (mutexIds == null || mutexIds.isEmpty()) {
            return;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bd_snmutex");
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])mutexIds.toArray());
        }
    }

    private void removeTimeOutMutex() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        Date time = calendar.getTime();
        QFilter qFilter = new QFilter("createtime", "<=", (Object)time);
        try (TXHandle txHandle = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"bd_snmutex", (QFilter[])qFilter.toArray());
        }
    }

    private Map<Long, Long> refreshSnmoveTrack() {
        Throwable throwable;
        if (this.isreqbill) {
            return Collections.emptyMap();
        }
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billid", (DataType)DataType.LongType), new Field("billentryid", (DataType)DataType.LongType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        for (DynamicObject billentry : this.billentriesMap.values()) {
            Long billid = billentry.getLong("id");
            Long billentryid = billentry.getLong(this.entrypathId);
            billentryDsBuilder.append(new Object[]{billid, billentryid});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        DataSet snmoveTrackPubDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_snmovetrack", (String)"id as trackid,billid as pub_billid,billentryid as pub_billentryid", (QFilter[])new QFilter("billid", "in", this.handleBillIds).and("billentryid", "in", this.billentriesMap.keySet()).and("snmainfile", "=", (Object)0).toArray(), (String)"");
        if (this.trackUpdate.size() > 0) {
            StringBuilder relSelectCol = new StringBuilder();
            relSelectCol.append("billid as r_billid, entryid as r_entryid");
            throwable = null;
            try (DataSet billRelationDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)layoutType, (String)relSelectCol.toString(), (QFilter[])new QFilter[]{new QFilter("billid", "in", this.handleBillIds).and("entryid", "in", this.billentriesMap.keySet())}, (String)"");){
                if (billRelationDataSet.hasNext()) {
                    billentryDataSet = billentryDataSet.join(billRelationDataSet).on("billid", "r_billid").on("billentryid", "r_entryid").select(billentryDataSet.getRowMeta().getFieldNames(), billRelationDataSet.getRowMeta().getFieldNames()).finish();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        HashMap<Long, Long> entryTrackMap = new HashMap<Long, Long>(this.billentriesMap.size());
        throwable = null;
        try (DataSet resultDataSet = billentryDataSet.leftJoin(snmoveTrackPubDataSet).on("billid", "pub_billid").on("billentryid", "pub_billentryid").select(billentryDataSet.getRowMeta().getFieldNames(), new String[]{"trackid"}).finish();){
            String sntrackInsertSql = this.buildSNTrackInsertSql();
            ArrayList<Object[]> sntrackInsertParams = new ArrayList<Object[]>(1000);
            String sntrackUpdateSql = this.buildSNTrackUpdateSql();
            ArrayList<Object[]> sntrackUpdateParams = new ArrayList<Object[]>(1000);
            long[] trackIds = null;
            int trackIndex = 0;
            for (Row row : resultDataSet) {
                Long billid = row.getLong("billid");
                Long entryid = row.getLong("billentryid");
                Long trackid = row.getLong("trackid");
                if (SerialNumberOperator.isEmpty(trackid)) {
                    if (trackIds == null) {
                        trackIds = SNBillConfigHelper.batchGenId("t_bd_snmovetrack", this.allbaseqty);
                    }
                    trackid = trackIndex < trackIds.length ? Long.valueOf(trackIds[trackIndex++]) : Long.valueOf(SNBillConfigHelper.genId("t_bd_snmovetrack"));
                    Object[] sntrackInsertParam = this.genSNTrackInsertParam(billid, entryid, trackid, row);
                    trackid = (Long)sntrackInsertParam[0];
                    sntrackInsertParams.add(sntrackInsertParam);
                    if (sntrackInsertParams.size() == 1000) {
                        SerialNumberOperator.executeBatchSql(sntrackInsertParams, sntrackInsertSql);
                    }
                } else {
                    Object[] sntrackUpdateParam = this.genSNTrackUpdateParam(trackid, entryid, row);
                    sntrackUpdateParams.add(sntrackUpdateParam);
                    if (sntrackUpdateParams.size() == 1000) {
                        SerialNumberOperator.executeBatchSql(sntrackUpdateParams, sntrackUpdateSql);
                    }
                }
                entryTrackMap.put(entryid, trackid);
            }
            if (sntrackInsertParams.size() > 0) {
                SerialNumberOperator.executeBatchSql(sntrackInsertParams, sntrackInsertSql);
            }
            if (sntrackUpdateParams.size() > 0) {
                SerialNumberOperator.executeBatchSql(sntrackUpdateParams, sntrackUpdateSql);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        return entryTrackMap;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet getBillSNDataSet() {
        void var11_36;
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("billentryid", (DataType)DataType.LongType), new Field("materialmasterid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType), new Field("invorgid", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType), new Field("entrylineseq", (DataType)DataType.IntegerType), new Field("billno", (DataType)DataType.StringType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        HashSet<Long> materialmasterids = new HashSet<Long>(this.billentriesMap.size());
        for (DynamicObject billentry : this.billentriesMap.values()) {
            void var11_21;
            void var11_25;
            Long billentryid = billentry.getLong(this.entrypathId);
            Long invorgid = billentry.getLong(this.invorgcol);
            Long materialmasterid = null;
            Object materialid = null;
            if (StringUtils.isNotEmpty((String)this.materialmastercol)) {
                materialmasterid = billentry.getLong(this.materialmastercol);
                materialid = StringUtils.isEmpty((String)this.materialcol) ? SNBillConfigHelper.getMaterialInvInfoId(materialmasterid, invorgid) : Long.valueOf(billentry.getLong(this.materialcol));
            } else {
                materialid = billentry.getLong(this.materialcol);
                materialmasterid = SNBillConfigHelper.getMaterialMasterId((Long)materialid);
            }
            Integer n = billentry.getInt(this.seqcol);
            Object var11_22 = null;
            if (!this.lotnumcol.isEmpty()) {
                String string = billentry.getString(this.lotnumcol);
            } else {
                Object var11_24 = null;
            }
            if (var11_25 == null || var11_25.isEmpty()) {
                String string = " ";
            }
            materialmasterids.add(materialmasterid);
            String billno = billentry.getString("billno");
            billentryDsBuilder.append(new Object[]{billentryid, materialmasterid, materialid, invorgid, var11_21, n, billno});
        }
        DataSet billentryDataSet = billentryDsBuilder.build();
        List<String> billSnRelationFixCols = Arrays.asList("billtype", "billid", "entrykey", "entryid", "srcbilltype", "srcbillid", "srcentrykey", "srcentryid", "srcisreq", "snnumber", "handlestatus");
        StringBuilder selectsBuilder = new StringBuilder("billtype, billid, entrykey, entryid, srcbilltype, srcbillid, srcentrykey, srcentryid, srcisreq, entryentity.snnumber as snnumber, entryentity.invorg as sninvorg,entryentity.handlestatus as handlestatus");
        StringBuilder mainFileCols = new StringBuilder("id as mainfileid,number as mfsnnumber, material as mfmaterialid,invorg as mfinvorg,lotnumber as mflotnumber,occupybillid,occupybilltype,occupybillentryid,occupybillentrytype");
        HashSet<String> billSnRelationExtCols = new HashSet<String>(this.snmainfExtRelMaps.size() + this.trackExtRelMaps.size());
        for (String string : this.snmainfExtRelMaps.values()) {
            billSnRelationExtCols.add(string);
        }
        for (String string : this.trackExtRelMaps.values()) {
            billSnRelationExtCols.add(string);
        }
        ArrayList<String> billSnRelationCols = new ArrayList<String>(billSnRelationFixCols.size() + billSnRelationExtCols.size() + this.mainFileUpdate.size() + this.dims.size());
        if (this.snEnterLists.size() > 0) {
            for (DynamicObject dynamicObject : this.snEnterLists) {
                String relationCol = dynamicObject.getString("billsnrelationcol");
                String moveTrackCol = dynamicObject.getString("snmovetrackrelcol");
                if (billSnRelationCols.contains(moveTrackCol)) continue;
                billSnRelationCols.add(moveTrackCol);
                selectsBuilder.append(",").append(relationCol).append(" as ").append(moveTrackCol);
            }
        }
        for (String string : billSnRelationExtCols) {
            selectsBuilder.append(",entryentity.").append(string).append(" as ").append(string);
        }
        billSnRelationCols.addAll(billSnRelationFixCols);
        billSnRelationCols.addAll(billSnRelationExtCols);
        if (!this.dims.isEmpty()) {
            for (Map.Entry<Integer, Map<String, Object>> entry : this.dims.entrySet()) {
                Integer dimseq = entry.getKey();
                String dimkey = DIM_PRE + dimseq;
                Map<String, Object> dimval = entry.getValue();
                String relcolumn = (String)dimval.get("relcolumn");
                billSnRelationCols.add(dimkey);
                selectsBuilder.append(",entryentity.").append(relcolumn).append(" as ").append(dimkey);
            }
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)layoutType, (String)selectsBuilder.toString(), (QFilter[])new QFilter("billid", "in", this.handleBillIds).and("billtype", "=", (Object)this.billtype).and("entrykey", "=", (Object)this.entrytype).toArray(), (String)"");
        DataSet dataSet2 = dataSet.join(billentryDataSet).on("entryid", "billentryid").select(billSnRelationCols.toArray(new String[billSnRelationCols.size()]), new String[]{"materialmasterid", "materialid", "invorgid", "lotnum", "entrylineseq", "case when sninvorg is null or sninvorg = 0 then invorgid else sninvorg end sninvorg", "billno"}).finish().filter("entrylineseq is not null");
        DataSet snMainFileDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_snmainfile", (String)mainFileCols.toString(), (QFilter[])new QFilter("material", "in", materialmasterids).and("masterfiletype", "=", (Object)this.masterfiletypeid).toArray(), (String)"");
        JoinDataSet tempDataSet = dataSet2.leftJoin(snMainFileDataSet).on("snnumber", "mfsnnumber").on("materialmasterid", "mfmaterialid");
        for (String unqctrl : this.snUnqctrl) {
            if (unqctrl.equals("1")) {
                tempDataSet = tempDataSet.on("sninvorg", "mfinvorg");
            }
            if (!unqctrl.equals("3")) continue;
            tempDataSet = tempDataSet.on("lotnum", "mflotnumber");
        }
        DataSet dataSet3 = tempDataSet.select(dataSet2.getRowMeta().getFieldNames(), snMainFileDataSet.getRowMeta().getFieldNames()).finish().filter("snnumber is not null");
        if (!this.isreqbill) {
            SqlBuilder snmoveTrackSqlBuilder = new SqlBuilder();
            snmoveTrackSqlBuilder.append("select r.fid as relid,r.fsnmainfileid as his_snmainfile,t.fbillid as his_billid,t.fbillentryid as his_billentryid", new Object[0]).append(" from t_bd_snmovetrack t join t_bd_snmovetrack_rel r on t.fid = r.ftrackid where ", new Object[0]).appendIn("t.fbillid", this.handleBillIdsArray).append(" and t.fsnmainfileid = 0", new Object[0]);
            DataSet snmoveTrackDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)snmoveTrackSqlBuilder);
            DataSet dataSet4 = dataSet3.leftJoin(snmoveTrackDataSet).on("mainfileid", "his_snmainfile").on("billid", "his_billid").on("entryid", "his_billentryid").select(dataSet3.getRowMeta().getFieldNames(), new String[]{"relid"}).finish();
        }
        return var11_36;
    }

    private DataSet getSNTrackAndMainfDataSet(String billstatus, Boolean isunaudit, Boolean needtrackercounter) {
        Map mainFileFieldTypes;
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (this.isreqbill) {
            sqlBuilder.append("select ts.fid as mainfileid,ts.fnumber as snnumber, ts.fmaterialid as materialmasterid,ts.finvorgid as invorgid,ts.flotnumber as lotnum", new Object[0]).append(",null as relid,ts.foccupybillid as billid,ts.foccupybilltype as billtype,ts.foccupybillentryid as entryid,ts.ffinalaudittrailid as finalaudittrailid", new Object[0]).append(",ts.fsbillinvfluctuation as sbillinvfluctuation,ts.fbillid as sourcebillid,ts.fsourcebillentryid as sourcebillentryid", new Object[0]).append(",ts.fsourcebilltype as sourcebilltype,ts.fsourcebillentrytype as sourcebillentrytype,ts.fisimport as isimport", new Object[0]).append(",ts.fincreaseinvcounter as increaseinvcounter,ts.fsubstractinvcounter as substractinvcounter,ts.ftraincreaseinvcounter as traincreaseinvcounter,ts.ftrasubstractinvcounter as trasubstractinvcounter", new Object[0]);
            if (this.snEnterLists.size() > 0) {
                mainFileFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
                for (DynamicObject obj : this.snEnterLists) {
                    String mainFileCol = obj.getString("snmainfilecol");
                    if (!obj.getBoolean("updatemainfile")) continue;
                    sqlBuilder.append(", ", new Object[0]).append("ts.", new Object[0]).append(((IDataEntityProperty)mainFileFieldTypes.get(mainFileCol)).getAlias(), new Object[0]).append(" as m_" + mainFileCol, new Object[0]);
                }
            }
            if (isunaudit.booleanValue()) {
                sqlBuilder.append(",ts.ffinalaudittrailid as maxrelid", new Object[0]);
            }
            if (needtrackercounter.booleanValue()) {
                sqlBuilder.append(",(select count(1) from t_bd_snmovetrack_rel tsr1 where tsr1.fsnmainfileid = ts.fid) as trackercounter", new Object[0]);
            }
            sqlBuilder.append(" from t_bd_snmainfile ts where ", new Object[0]).appendIn("ts.foccupybillid", this.handleBillIdsArray).append(" and ts.foccupybilltype = ? and ts.foccupybillentrytype = ?", new Object[]{this.billtype, this.entrytype});
        } else {
            sqlBuilder.append("select ts.fid as mainfileid,ts.fnumber as snnumber, ts.fmaterialid as materialmasterid,ts.finvorgid as invorgid,ts.flotnumber as lotnum", new Object[0]).append(",tsr.fid as relid,tsm.fbillid as billid,tsm.fbillentryid as entryid,ts.ffinalaudittrailid as finalaudittrailid", new Object[0]).append(",ts.fsbillinvfluctuation as sbillinvfluctuation,ts.fbillid as sourcebillid,ts.fsourcebillentryid as sourcebillentryid", new Object[0]).append(",ts.fsourcebilltype as sourcebilltype,ts.fsourcebillentrytype as sourcebillentrytype,ts.fisimport as isimport", new Object[0]).append(",ts.fincreaseinvcounter as increaseinvcounter,ts.fsubstractinvcounter as substractinvcounter,ts.ftraincreaseinvcounter as traincreaseinvcounter,ts.ftrasubstractinvcounter as trasubstractinvcounter", new Object[0]).append(",tsr.fmainfile_old as mainfileold", new Object[0]);
            if (this.snEnterLists.size() > 0) {
                Map moveTrackFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack_rel").getAllFields();
                Map mainFileFieldTypes2 = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
                HashSet<String> moveTrackCols = new HashSet<String>(this.snEnterLists.size());
                for (DynamicObject obj : this.snEnterLists) {
                    String moveTrackCol = obj.getString("snmovetrackrelcol");
                    if (!moveTrackCols.contains(moveTrackCol)) {
                        sqlBuilder.append(", ", new Object[0]).append("tsr." + ((IDataEntityProperty)moveTrackFieldTypes.get(moveTrackCol)).getAlias(), new Object[0]).append(" as t_" + moveTrackCol, new Object[0]);
                    }
                    moveTrackCols.add(moveTrackCol);
                    if (!obj.getBoolean("updatemainfile")) continue;
                    String mainFileCol = obj.getString("snmainfilecol");
                    sqlBuilder.append(", ", new Object[0]).append("ts." + ((IDataEntityProperty)mainFileFieldTypes2.get(mainFileCol)).getAlias(), new Object[0]).append(" as m_" + mainFileCol, new Object[0]);
                }
            }
            if (!this.snMainFileNoConditionMap.isEmpty()) {
                mainFileFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
                for (String mainFileCol : this.snMainFileNoConditionMap.keySet()) {
                    sqlBuilder.append(", ", new Object[0]).append("ts." + ((IDataEntityProperty)mainFileFieldTypes.get(mainFileCol)).getAlias(), new Object[0]).append(" as m_" + mainFileCol, new Object[0]);
                }
            }
            if (isunaudit.booleanValue()) {
                sqlBuilder.append(",(select max(tsr0.fid) from t_bd_snmovetrack_rel tsr0 join t_bd_snmovetrack tsm0 on tsr0.ftrackid = tsm0.fid where tsr0.fsnmainfileid = ts.fid and tsr0.ftrackid <> tsm.fid and tsm0.fbillstatus = 'C' and tsm0.fsnmainfileid = 0) as maxrelid", new Object[0]);
            }
            if (needtrackercounter.booleanValue()) {
                sqlBuilder.append(",(select count(1) from t_bd_snmovetrack_rel tsr1 where tsr1.fsnmainfileid = ts.fid) as trackercounter", new Object[0]);
            }
            sqlBuilder.append(" from t_bd_snmovetrack tsm join t_bd_snmovetrack_rel tsr on tsm.fid = tsr.ftrackid join t_bd_snmainfile ts on tsr.fsnmainfileid = ts.fid where ", new Object[0]).appendIn("tsm.fbillid", this.handleBillIdsArray).append(" and tsm.fbllentityid = ? and tsm.fbillentrytype = ? and tsm.fbillstatus = ?", new Object[]{this.billtype, this.entrytype, billstatus});
        }
        DataSet snTrackAndMainfDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);
        return snTrackAndMainfDataSet;
    }

    private void getSnMainfAndTrackMaps() {
        this.snmainfMaps = SNBillConfigHelper.getSNMainfMaps(this.cfg);
        this.trackMaps = SNBillConfigHelper.getSNTrackMaps(this.cfg);
        this.snMainFileNoConditionMap = SNBillConfigHelper.getSNMainFileNoConditionMaps(this.cfg);
        if (this.snEnterLists.size() > 0) {
            Map snTrackFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack").getAllFields();
            for (DynamicObject mapping : this.snEnterLists) {
                if (mapping.getBoolean("updatemainfile")) {
                    String snMainFileCol = mapping.getString("snmainfilecol");
                    if (this.snMainFileNoConditionMap == null || !this.snMainFileNoConditionMap.containsKey(snMainFileCol)) {
                        this.mainFileUpdate.add(mapping);
                    }
                }
                if (!snTrackFieldTypes.containsKey(mapping.getString("snmovetrackrelcol"))) continue;
                this.trackUpdate.add(mapping);
            }
        }
        Collection<DynamicObject> relextCfgs = SNBillConfigHelper.getSNRelExtConfigs(this.cfg);
        for (DynamicObject relextCfg : relextCfgs) {
            String desttable = relextCfg.getString("desttable");
            String destcol = relextCfg.getString("destcol");
            String billsncol = relextCfg.getString("billsncol").replaceFirst("entryentity.", "");
            if ("bd_snmainfile".equals(desttable)) {
                this.snmainfExtRelMaps.put(destcol, billsncol);
                this.snmainfMaps.remove(destcol);
                continue;
            }
            if (!"bd_snmovetrack_rel".equals(desttable)) continue;
            this.trackExtRelMaps.put(destcol, billsncol);
        }
    }

    private Map<Long, Long> getInvaccMap(Map<String, Object> balanceinfo) {
        if (balanceinfo == null) {
            return Collections.emptyMap();
        }
        String balancetype = (String)balanceinfo.get("balancetype");
        HashMap<Long, Long> invaccMap = new HashMap<Long, Long>(this.billentriesMap.size());
        try (DataSet balDataSet = BalQuery.getBalUpdatedInfo4SerialNo((String)balancetype, (String)this.billtype, Arrays.asList(this.handleBillIdsArray), balCols).filter("baseqty > 0");){
            for (Row row : balDataSet) {
                Long entryid = row.getLong("entryid");
                if (!this.billentriesMap.containsKey(entryid)) continue;
                invaccMap.put(entryid, row.getLong("id"));
            }
        }
        return invaccMap;
    }

    private Map<Long, Map<String, Object>> getReqbillMap() {
        DynamicObjectCollection reqbillrels = QueryServiceHelper.query((String)layoutType, (String)"entryid, srcbilltype, srcbillid, srcentrykey, srcentryid", (QFilter[])new QFilter("entryid", "in", this.billentriesMap.keySet()).and("srcisreq", "=", (Object)Boolean.TRUE).toArray());
        if (reqbillrels == null || reqbillrels.size() <= 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> reqbillmap = new HashMap<Long, Map<String, Object>>(reqbillrels.size());
        for (DynamicObject reqbillrel : reqbillrels) {
            HashMap<String, Object> reqbill = new HashMap<String, Object>(4);
            reqbill.put("srcbilltype", reqbillrel.get("srcbilltype"));
            reqbill.put("srcbillid", reqbillrel.get("srcbillid"));
            reqbill.put("srcentrykey", reqbillrel.get("srcentrykey"));
            reqbill.put("srcentryid", reqbillrel.get("srcentryid"));
            reqbillmap.put(reqbillrel.getLong("entryid"), reqbill);
        }
        return reqbillmap;
    }

    private void getReqBillMap(Set<Long> ids, Map<Long, Map<String, Object>> reqbillMap) {
        DynamicObjectCollection reqbillrels = QueryServiceHelper.query((String)layoutType, (String)"entryid, srcbilltype, srcbillid, srcentrykey, srcentryid,srcisoccupymove,srcinvflu", (QFilter[])new QFilter("entryid", "in", ids).and("srcisreq", "=", (Object)Boolean.TRUE).toArray());
        if (reqbillrels == null || reqbillrels.isEmpty()) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>();
        for (DynamicObject reqbillrel : reqbillrels) {
            HashMap<String, Object> reqbill = new HashMap<String, Object>(6);
            reqbill.put("srcbilltype", reqbillrel.get("srcbilltype"));
            reqbill.put("srcbillid", reqbillrel.get("srcbillid"));
            reqbill.put("srcentrykey", reqbillrel.get("srcentrykey"));
            reqbill.put("srcentryid", reqbillrel.get("srcentryid"));
            reqbill.put("srcisoccupymove", reqbillrel.get("srcisoccupymove"));
            reqbill.put("srcinvflu", reqbillrel.get("srcinvflu"));
            srcBillIds.add((Long)reqbillrel.get("srcentryid"));
            reqbillMap.put((Long)reqbillrel.get("entryid"), reqbill);
        }
        if (!srcBillIds.isEmpty()) {
            this.getReqBillMap(srcBillIds, reqbillMap);
        }
    }

    private void operateSNDataSubmit(DataSet serialNumberDataSet, Map<Long, Long> entryTrackMap) {
        String snstatus = SNBillConfigHelper.getSnStatusBySubmit(this.opeAttrMap);
        Boolean occupymove = (Boolean)this.opeAttrMap.get("occupymove");
        String snmainfInsertSql = this.buildSNmainfInsertSql();
        ArrayList<Object[]> snmainfInsertParams = new ArrayList<Object[]>(1000);
        String dimInsertSql = this.buildDimInsertSql();
        ArrayList<Object[]> dimInsertParams = new ArrayList<Object[]>(1000);
        String snmainfUpdateSql = this.buildSNmainfUpdateSqlSubmit();
        ArrayList<Object[]> snmainfUpdateParams = new ArrayList<Object[]>(1000);
        String sntrackrelInsertSql = this.getSNTrackrelInsertSql();
        ArrayList<Object[]> sntrackrelInsertParams = new ArrayList<Object[]>(1000);
        String sntrackrelUpdateSql = this.getSNTrackrelUpdateSql();
        ArrayList<Object[]> sntrackrelUpdateParams = new ArrayList<Object[]>(1000);
        long[] snmainfids = null;
        int snmainfidsIdx = 0;
        long[] sntrackrelids = null;
        int sntrackrelidsIdx = 0;
        for (Row row : serialNumberDataSet) {
            Long mainfileid = row.getLong("mainfileid");
            String handlestatus = row.getString("handlestatus");
            if (this.allowsplit && "B".equals(handlestatus)) continue;
            if (SerialNumberOperator.isEmpty(mainfileid)) {
                if (snmainfids == null) {
                    snmainfids = SNBillConfigHelper.batchGenId("t_bd_snmainfile", this.allbaseqty);
                }
                mainfileid = snmainfidsIdx < snmainfids.length ? Long.valueOf(snmainfids[snmainfidsIdx]) : Long.valueOf(SNBillConfigHelper.genId("t_bd_snmainfile"));
                ++snmainfidsIdx;
                Object[] snmainfInsertParam = this.genSNmainfInsertParam(row, snstatus, mainfileid);
                snmainfInsertParams.add(snmainfInsertParam);
                if (snmainfInsertParams.size() == 1000) {
                    SerialNumberOperator.executeBatchSql(snmainfInsertParams, snmainfInsertSql);
                }
                if (!this.dims.isEmpty()) {
                    Integer index = 0;
                    for (Map.Entry<Integer, Map<String, Object>> dim : this.dims.entrySet()) {
                        Integer seq = dim.getKey();
                        String dimkey = DIM_PRE + seq;
                        String dimnum = row.getString(dimkey);
                        if (dimnum == null || dimnum.isEmpty()) continue;
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                        Map<String, Object> dimval = dim.getValue();
                        Long dimid = (Long)dimval.get("id");
                        Long dimentryid = SNBillConfigHelper.genId("t_bd_sndimensionentry");
                        Object[] dimInsertParam = this.genDimInsertParam(mainfileid, dimentryid, index, dimid, dimnum);
                        dimInsertParams.add(dimInsertParam);
                        if (dimInsertParams.size() != 1000) continue;
                        SerialNumberOperator.executeBatchSql(dimInsertParams, dimInsertSql);
                    }
                }
            } else {
                Object[] snmainfUpdateParam = this.genSNmainfUpdateParamSubmit(mainfileid, row, snstatus, occupymove);
                snmainfUpdateParams.add(snmainfUpdateParam);
                if (snmainfUpdateParams.size() == 1000) {
                    SerialNumberOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
                }
            }
            if (this.isreqbill) continue;
            Long entryid = row.getLong("entryid");
            Long relid = row.getLong("relid");
            if (SerialNumberOperator.isEmpty(relid)) {
                if (sntrackrelids == null) {
                    sntrackrelids = SNBillConfigHelper.batchGenId("t_bd_snmovetrack_rel", this.allbaseqty);
                }
                relid = sntrackrelidsIdx < sntrackrelids.length ? Long.valueOf(sntrackrelids[sntrackrelidsIdx]) : Long.valueOf(SNBillConfigHelper.genId("t_bd_snmovetrack_rel"));
                ++sntrackrelidsIdx;
                Long trackid = entryTrackMap.get(entryid);
                Object[] sntrackrelInsertParam = this.genSNTrackrelInsertParam(mainfileid, trackid, relid, row);
                sntrackrelInsertParams.add(sntrackrelInsertParam);
                if (sntrackrelInsertParams.size() != 1000) continue;
                SerialNumberOperator.executeBatchSql(sntrackrelInsertParams, sntrackrelInsertSql);
                continue;
            }
            if (this.trackExtRelMaps.isEmpty() && this.snEnterLists.isEmpty() || sntrackrelUpdateSql == null) continue;
            Object[] sntrackrelUpdateParam = this.genSNTrackrelUpdateParam(relid, row);
            sntrackrelUpdateParams.add(sntrackrelUpdateParam);
            if (sntrackrelUpdateParams.size() != 1000) continue;
            SerialNumberOperator.executeBatchSql(sntrackrelUpdateParams, sntrackrelUpdateSql);
        }
        if (snmainfInsertParams.size() > 0) {
            SerialNumberOperator.executeBatchSql(snmainfInsertParams, snmainfInsertSql);
        }
        if (dimInsertParams.size() > 0) {
            SerialNumberOperator.executeBatchSql(dimInsertParams, dimInsertSql);
        }
        if (snmainfUpdateParams.size() > 0) {
            SerialNumberOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
        }
        if (sntrackrelInsertParams.size() > 0) {
            SerialNumberOperator.executeBatchSql(sntrackrelInsertParams, sntrackrelInsertSql);
        }
        if (sntrackrelUpdateParams.size() > 0 && sntrackrelUpdateSql != null) {
            SerialNumberOperator.executeBatchSql(sntrackrelUpdateParams, sntrackrelUpdateSql);
        }
    }

    private void operateSNDataUnHandle(DataSet serialNumberDataSet, String seqoperate) {
        InvCounterEntity invCounter = SNBillConfigHelper.getNegInvCounterEntity(this.opeAttrMap);
        SNMainFileStatusCalHelper statusCalHelper = new SNMainFileStatusCalHelper();
        ArrayList<Long> snmainfDeleteIds = new ArrayList<Long>(1024);
        String snmainfUpdateSql = null;
        ArrayList<Object[]> snmainfUpdateParams = new ArrayList<Object[]>(1000);
        Map<Long, DynamicObject> mainFileMoveTrackExtColInfo = null;
        switch (seqoperate) {
            case "2": {
                snmainfUpdateSql = this.buildSNmainfUpdateSqlUnsubmit();
                break;
            }
            case "4": {
                snmainfUpdateSql = this.buildSNMainFileUpdateSqlUnAudit();
                if (this.isreqbill || this.mainFileUpdate.size() <= 0) break;
                mainFileMoveTrackExtColInfo = this.getMainFileMoveTrackExtCol(serialNumberDataSet.copy());
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<Long> sntrackrelDeleteIds = new ArrayList<Long>(1000);
        HashMap<String, List> updateParamMap = new HashMap<String, List>(16);
        Map allFields = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
        for (Row row2 : serialNumberDataSet) {
            Long billid = row2.getLong("billid");
            Long entryid = row2.getLong("entryid");
            Long mainfileid = row2.getLong("mainfileid");
            Long relid = row2.getLong("relid");
            Long finalaudittrailid = row2.getLong("finalaudittrailid");
            Integer counter = row2.getInteger("trackercounter");
            Boolean isimport = row2.getBoolean("isimport");
            Long sourcebillid = row2.getLong("sourcebillid");
            Long sourcebillentryid = row2.getLong("sourcebillentryid");
            boolean delMainfFlag = false;
            boolean delTrackrelFlag = false;
            if (SerialNumberOperator.isEmpty(mainfileid)) continue;
            if (!isimport.booleanValue() && billid.equals(sourcebillid) && entryid.equals(sourcebillentryid)) {
                int delCtrlVal = 0;
                if (!this.isreqbill) {
                    ++delCtrlVal;
                }
                if (counter == null || counter <= delCtrlVal) {
                    delMainfFlag = true;
                    delTrackrelFlag = true;
                }
            }
            if (delMainfFlag) {
                snmainfDeleteIds.add(mainfileid);
            } else {
                Map<String, Object> rollbackInfo = this.getRollBackReqBillMap(entryid, new HashMap<String, Object>());
                Object[] snmainfUpdateParam = null;
                switch (seqoperate) {
                    case "2": {
                        snmainfUpdateParam = this.genSNmainfUpdateParamUnSubmit(mainfileid, row2, statusCalHelper, rollbackInfo);
                        break;
                    }
                    case "4": {
                        DynamicObject snMaxMoveTrackInfo = mainFileMoveTrackExtColInfo == null ? null : mainFileMoveTrackExtColInfo.get(mainfileid);
                        Long maxrelid = row2.getLong("maxrelid");
                        if (SerialNumberOperator.isEmpty(maxrelid)) {
                            maxrelid = 0L;
                        }
                        snmainfUpdateParam = this.genSNmainfUpdateParamAudit(mainfileid, row2, statusCalHelper, invCounter, maxrelid, rollbackInfo, snMaxMoveTrackInfo, false);
                        if (this.isreqbill) break;
                        try {
                            String mainFileOld = row2.getString("mainfileold");
                            if (!StringUtils.isNotEmpty((String)mainFileOld)) break;
                            Map oldValueMap = (Map)SerializationUtils.fromJsonString((String)mainFileOld, Map.class);
                            ArrayList<Object> param = new ArrayList<Object>(oldValueMap.size());
                            StringBuilder updateFieldsBuilder = new StringBuilder();
                            for (Map.Entry oldValueEntry : oldValueMap.entrySet()) {
                                String updateField = (String)oldValueEntry.getKey();
                                Object value = oldValueEntry.getValue();
                                if (updateFieldsBuilder.length() > 0) {
                                    updateFieldsBuilder.append(",");
                                }
                                updateFieldsBuilder.append(updateField);
                                if (!allFields.containsKey(updateField)) continue;
                                IDataEntityProperty dp = (IDataEntityProperty)allFields.get(updateField);
                                Class propertyType = dp.getPropertyType();
                                if (propertyType == ILocaleString.class) {
                                    param.add(value);
                                    continue;
                                }
                                param.add(ObjectConverter.convert(value, (Class)propertyType, (boolean)dp.isEnableNull()));
                            }
                            param.add(mainfileid);
                            List paramList = updateParamMap.computeIfAbsent(updateFieldsBuilder.toString(), k -> new ArrayList());
                            paramList.add(param.toArray());
                            if (paramList.size() != 1000) break;
                            this.updateMainFileNoConditionFields(updateFieldsBuilder.toString(), paramList);
                            paramList.clear();
                        }
                        catch (Exception e) {
                            logger.error("\u6279\u53f7\u4e3b\u6863\u53cd\u5199\u6709\u8bef", (Throwable)e);
                        }
                        break;
                    }
                }
                snmainfUpdateParams.add(snmainfUpdateParam);
                if (snmainfUpdateParams.size() == 1000) {
                    SerialNumberOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
                }
            }
            if (this.isreqbill || SerialNumberOperator.isEmpty(relid)) continue;
            if (!delTrackrelFlag && (SerialNumberOperator.isEmpty(finalaudittrailid) || finalaudittrailid <= relid)) {
                delTrackrelFlag = true;
            }
            if (!delTrackrelFlag) continue;
            sntrackrelDeleteIds.add(relid);
        }
        if (snmainfDeleteIds.size() > 0) {
            DeleteServiceHelper.delete((String)"bd_snmainfile", (QFilter[])new QFilter("id", "in", snmainfDeleteIds).toArray());
        }
        if (snmainfUpdateParams.size() > 0) {
            SerialNumberOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
        }
        try {
            for (Map.Entry updateParamEntry : updateParamMap.entrySet()) {
                this.updateMainFileNoConditionFields((String)updateParamEntry.getKey(), (List)updateParamEntry.getValue());
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u53f7\u4e3b\u6863\u53cd\u5199\u6709\u8bef", (Throwable)e);
        }
        if (!this.isreqbill) {
            SqlBuilder sntrackUpdateSqlBuilder = new SqlBuilder();
            sntrackUpdateSqlBuilder.append("update t_bd_snmovetrack set fbillstatus = ?,fauditdate = null where ", new Object[]{"A"}).appendIn("fbillid", this.handleBillIdsArray).append(" and ", new Object[0]).appendIn("fbillentryid", this.billentriesMap.keySet().toArray());
            DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sntrackUpdateSqlBuilder);
            if (seqoperate.equals("4")) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("select r2.fid as relid from t_bd_snmovetrack t", new Object[0]).append(" join t_bd_snmovetrack_rel r on t.fid = r.ftrackid", new Object[0]).append(" join t_bd_snmainfile m on m.fid = r.fsnmainfileid", new Object[0]).append(" join t_bd_snmovetrack_rel r2 on m.fid = r2.fsnmainfileid and m.ffinalaudittrailid < r2.fid", new Object[0]).append(" join t_bd_snmovetrack t2 on r2.ftrackid = t2.fid and t2.fbillid <> t.fbillid and t2.fbillstatus = ?", new Object[]{"A"}).append(" where ", new Object[0]).appendIn("t.fbillid", this.handleBillIdsArray).append(" and t.fbillentrytype = ?", new Object[]{this.entrytype}).append(" and t.fsnmainfileid = 0 and t.fbillstatus = ?", new Object[]{"A"});
                try (DataSet otherrels = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlBuilder);){
                    otherrels.forEach(row -> sntrackrelDeleteIds.add(row.getLong("relid")));
                }
            }
        }
        if (sntrackrelDeleteIds.size() > 0) {
            DeleteServiceHelper.delete((String)"bd_snmovetrack_rel", (QFilter[])new QFilter("id", "in", sntrackrelDeleteIds).toArray());
        }
    }

    private void updateMainFileNoConditionFields(String updateFields, List<Object[]> paramList) {
        if (paramList == null || paramList.isEmpty() || StringUtils.isEmpty((String)updateFields)) {
            return;
        }
        Map allFields = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
        StringBuilder sql = new StringBuilder("update t_bd_snmainfile set ");
        String[] updateFieldArr = updateFields.split(",");
        for (int i = 0; i < updateFieldArr.length; ++i) {
            String updateField = updateFieldArr[i];
            if (i > 0) {
                sql.append(",");
            }
            if (!allFields.containsKey(updateField)) continue;
            sql.append(((IDataEntityProperty)allFields.get(updateField)).getAlias()).append(" = ? ");
        }
        sql.append(" where fid = ? ");
        SerialNumberOperator.executeBatchSql(paramList, sql.toString());
    }

    private Map<Long, DynamicObject> getMainFileMoveTrackExtCol(DataSet snDataSet) {
        ArrayList<Long> maxTrackFids = new ArrayList<Long>();
        for (Row row : snDataSet) {
            Long maxTrackId = row.getLong("maxrelid");
            if (SerialNumberOperator.isEmpty(maxTrackId)) continue;
            maxTrackFids.add(maxTrackId);
        }
        if (maxTrackFids.size() > 0) {
            StringBuilder queryCols = new StringBuilder();
            HashSet<String> moveTrackCols = new HashSet<String>(this.mainFileUpdate.size());
            for (DynamicObject object : this.mainFileUpdate) {
                String moveTrackCol = object.getString("snmovetrackrelcol");
                if (moveTrackCols.contains(moveTrackCol)) continue;
                moveTrackCols.add(moveTrackCol);
                queryCols.append(moveTrackCol).append(",");
            }
            queryCols.append("snmainfileid,id,trackid");
            DynamicObjectCollection moveTracks = QueryServiceHelper.query((String)"bd_snmovetrack_rel", (String)queryCols.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", maxTrackFids)});
            HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
            if (moveTracks != null && moveTracks.size() > 0) {
                moveTracks.forEach(i -> result.put(i.getLong("snmainfileid"), (DynamicObject)i));
                return result;
            }
        }
        return null;
    }

    private Map<String, Object> getRollBackReqBillMap(Long entryId, Map<String, Object> reqAttr) {
        Map<String, Object> map = this.reqbillMap.get(entryId);
        if (map == null || map.isEmpty()) {
            return reqAttr;
        }
        Boolean srcIsOccupyMove = (Boolean)map.get("srcisoccupymove");
        if (srcIsOccupyMove.booleanValue()) {
            return map;
        }
        Long srcEntryId = (Long)map.get("srcentryid");
        if (srcEntryId == null) {
            return reqAttr;
        }
        return this.getRollBackReqBillMap(srcEntryId, map);
    }

    private void operateSNDataAudit(DataSet serialNumberDataSet, Map<Long, Long> invaccMap, String balancetype) {
        InvCounterEntity invCounter = SNBillConfigHelper.getInvCounterEntity(this.opeAttrMap);
        SNMainFileStatusCalHelper statusCalHelper = new SNMainFileStatusCalHelper();
        ArrayList<Object[]> snmainfUpdateParams = new ArrayList<Object[]>(1000);
        if (!this.isreqbill) {
            String snmainfUpdateSql = this.buildSNmainfUpdateSqlAudit();
            String updateSNTrackRelSql = "update t_bd_snmovetrack_rel set fmainfile_old = ? where fid = ?";
            ArrayList<Object[]> updateSNTrackRelParams = new ArrayList<Object[]>(1000);
            for (Row row : serialNumberDataSet) {
                Long mainfileid = row.getLong("mainfileid");
                Long relid = row.getLong("relid");
                Long finalaudittrailid = row.getLong("finalaudittrailid");
                if (SerialNumberOperator.isEmpty(finalaudittrailid) || finalaudittrailid < relid) {
                    finalaudittrailid = relid;
                }
                Object[] snmainfUpdateParam = this.genSNmainfUpdateParamAudit(mainfileid, row, statusCalHelper, invCounter, finalaudittrailid, null, null, true);
                snmainfUpdateParams.add(snmainfUpdateParam);
                if (snmainfUpdateParams.size() == 1000) {
                    SerialNumberOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
                }
                if (this.snMainFileNoConditionMap.isEmpty()) continue;
                HashMap<String, Object> mainFileMap = new HashMap<String, Object>(this.snMainFileNoConditionMap.size());
                for (String mainFileCol : this.snMainFileNoConditionMap.keySet()) {
                    mainFileMap.put(mainFileCol, row.get(MAINFILE_TAG + mainFileCol));
                }
                updateSNTrackRelParams.add(new Object[]{SerializationUtils.toJsonString(mainFileMap), finalaudittrailid});
                if (updateSNTrackRelParams.size() != 1000) continue;
                SerialNumberOperator.executeBatchSql(updateSNTrackRelParams, updateSNTrackRelSql);
            }
            if (snmainfUpdateParams.size() > 0) {
                SerialNumberOperator.executeBatchSql(snmainfUpdateParams, snmainfUpdateSql);
            }
            if (updateSNTrackRelParams.size() > 0) {
                SerialNumberOperator.executeBatchSql(updateSNTrackRelParams, updateSNTrackRelSql);
            }
        }
        if (!this.isreqbill) {
            String sntrackUpdateSql = this.getSNTrackUpdateSqlAudit();
            ArrayList<Object[]> sntrackUpdateParams = new ArrayList<Object[]>(1000);
            for (Map.Entry<Long, DynamicObject> billentries : this.billentriesMap.entrySet()) {
                Long entryid = billentries.getKey();
                Long billid = billentries.getValue().getLong("id");
                Long invaccid = invaccMap.getOrDefault(entryid, 0L);
                Object[] sntrackUpdateParam = this.getSNTrackUpdateParamAudit(invCounter, billid, entryid, balancetype, invaccid, new Date());
                sntrackUpdateParams.add(sntrackUpdateParam);
                if (sntrackUpdateParams.size() != 1000) continue;
                SerialNumberOperator.executeBatchSql(sntrackUpdateParams, sntrackUpdateSql);
            }
            if (sntrackUpdateParams.size() > 0) {
                SerialNumberOperator.executeBatchSql(sntrackUpdateParams, sntrackUpdateSql);
            }
        }
    }

    private String buildSNmainfUpdateFinalAuditTrailIdSqlAudit() {
        return "update t_bd_snmainfile set ffinalaudittrailid = ? where fid = ?";
    }

    private void updBillSnRelTo(String targetStatus) {
        DBRoute route = DBRoute.of((String)"scm");
        ArrayList updEntryids = new ArrayList(1000);
        SqlBuilder selectBuilder = new SqlBuilder();
        selectBuilder.append("select e.fentryid as entryid", new Object[0]).append(" from t_sbs_billsqnrelation b join t_sbs_billsqnrelation_e e on b.fid = e.fid", new Object[0]).append(" where ", new Object[0]).appendIn("b.fbillid", this.handleBillIdsArray).append(" and b.fbilltype = ?", new Object[]{this.billtype}).append(" and b.fentrykey = ?", new Object[]{this.entrytype}).append(" and e.fhandlestatus <> ?", new Object[]{targetStatus});
        try (DataSet rels = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)route, (SqlBuilder)selectBuilder);){
            rels.forEach(row -> updEntryids.add(row.getLong("entryid")));
        }
        if (!updEntryids.isEmpty()) {
            SqlBuilder updateBuilder = new SqlBuilder();
            updateBuilder.append("update t_sbs_billsqnrelation_e set fhandlestatus = ? where ", new Object[]{targetStatus}).appendIn("fentryid", updEntryids.toArray());
            DB.execute((DBRoute)route, (SqlBuilder)updateBuilder);
        }
    }

    private String buildSNmainfInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into t_bd_snmainfile(").append("fid,fnumber,fmaterialid,finvorgid,flotnumber,fsnstatus,fisimport,fsbillinvfluctuation,").append("fbillid,fsourcebillentryid,fsourcebilltype,fsourcebillentrytype,foccupybillid,foccupybillentryid,foccupybilltype,foccupybillentrytype,fenable,fstatus,fmasterfiletypeid,fmasterid");
        Map mainFileFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
        if (this.snmainfExtRelMaps.size() > 0) {
            for (String tarcol : this.snmainfExtRelMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)mainFileFieldTypes.get(tarcol)).getAlias());
            }
        }
        if (this.snmainfMaps.size() > 0) {
            for (String tarcol : this.snmainfMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)mainFileFieldTypes.get(tarcol)).getAlias());
            }
        }
        builder.append(") values(").append(String.join((CharSequence)",", Collections.nCopies(20 + this.snmainfExtRelMaps.size() + this.snmainfMaps.size(), "?"))).append(')');
        return builder.toString();
    }

    private Object[] genSNmainfInsertParam(Row row, String snstatus, Long mainfileid) {
        Long billid = row.getLong("billid");
        Long entryid = row.getLong("entryid");
        Long invorgid = row.getLong("sninvorg");
        if (SerialNumberOperator.isEmpty(invorgid)) {
            invorgid = row.getLong("invorgid");
        }
        DynamicObject billentry = this.billentriesMap.get(entryid);
        Object[] snmainfInsertParam = new Object[20 + this.snmainfExtRelMaps.size() + this.snmainfMaps.size()];
        snmainfInsertParam[0] = mainfileid;
        snmainfInsertParam[1] = row.getString("snnumber");
        snmainfInsertParam[2] = row.getLong("materialmasterid");
        snmainfInsertParam[3] = invorgid;
        snmainfInsertParam[4] = row.getString("lotnum");
        snmainfInsertParam[5] = snstatus;
        snmainfInsertParam[6] = Boolean.FALSE;
        snmainfInsertParam[7] = this.opeAttrMap.get("invflu");
        snmainfInsertParam[8] = billid;
        snmainfInsertParam[9] = entryid;
        snmainfInsertParam[10] = this.billtype;
        snmainfInsertParam[11] = this.entrytype;
        snmainfInsertParam[12] = billid;
        snmainfInsertParam[13] = entryid;
        snmainfInsertParam[14] = this.billtype;
        snmainfInsertParam[15] = this.entrytype;
        snmainfInsertParam[16] = "1";
        snmainfInsertParam[17] = "C";
        snmainfInsertParam[18] = this.masterfiletypeid;
        snmainfInsertParam[19] = mainfileid;
        int i = 20;
        for (String billsncol : this.snmainfExtRelMaps.values()) {
            snmainfInsertParam[i] = row.get(billsncol);
            ++i;
        }
        for (String srccol : this.snmainfMaps.values()) {
            snmainfInsertParam[i] = billentry.get(srccol);
            ++i;
        }
        return snmainfInsertParam;
    }

    private String buildSNmainfUpdateSqlSubmit() {
        return "update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ?,finvorgid = ? where fid = ?";
    }

    private String buildSNmainfUpdateSqlUnsubmit() {
        return "update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ? where fid = ?";
    }

    private String buildSNMainFileUpdateSqlUnAudit() {
        StringBuilder builder = new StringBuilder();
        builder.append("update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ?, fincreaseinvcounter = ?, fsubstractinvcounter = ?, ftraincreaseinvcounter = ?, ftrasubstractinvcounter = ?,ffinalaudittrailid = ?");
        if (!this.isreqbill && this.mainFileUpdate != null && this.mainFileUpdate.size() > 0) {
            Map mainFileFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
            for (DynamicObject object : this.mainFileUpdate) {
                builder.append(", ").append(((IDataEntityProperty)mainFileFieldTypes.get(object.getString("snmainfilecol"))).getAlias()).append(" = ? ");
            }
        }
        builder.append(" where fid = ?");
        return builder.toString();
    }

    private String buildSNmainfUpdateSqlAudit() {
        Map mainFileFieldTypes;
        StringBuilder sql = new StringBuilder();
        sql.append("update t_bd_snmainfile set fsnstatus = ?,foccupybillid = ?,foccupybillentryid = ?,foccupybilltype = ?,foccupybillentrytype = ?,fincreaseinvcounter = ?, fsubstractinvcounter = ?, ftraincreaseinvcounter = ?, ftrasubstractinvcounter = ?,ffinalaudittrailid = ? ");
        if (this.mainFileUpdate.size() > 0) {
            mainFileFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
            for (DynamicObject object : this.mainFileUpdate) {
                String mainFileCol = object.getString("snmainfilecol");
                sql.append(", ").append(((IDataEntityProperty)mainFileFieldTypes.get(mainFileCol)).getAlias()).append(" = ?");
            }
        }
        if (!this.snMainFileNoConditionMap.isEmpty()) {
            mainFileFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile").getAllFields();
            for (String mainFileCol : this.snMainFileNoConditionMap.keySet()) {
                sql.append(", ").append(((IDataEntityProperty)mainFileFieldTypes.get(mainFileCol)).getAlias()).append(" = ?");
            }
        }
        sql.append(" where fid = ?");
        return sql.toString();
    }

    private Object[] genSNmainfUpdateParamSubmit(Long mainfileid, Row row, String snstatus, Boolean occupymove) {
        Long billid = row.getLong("billid");
        Long entryid = row.getLong("entryid");
        Long invorg = row.getLong("mfinvorg");
        Long occupyBillId = row.getLong("occupybillid");
        Long occupyBillEntryId = row.getLong("occupybillentryid");
        String occupyBillType = row.getString("occupybilltype");
        String occupyBillEntryType = row.getString("occupybillentrytype");
        if (SerialNumberOperator.isEmpty(invorg)) {
            invorg = row.getLong("sninvorg");
        }
        Object[] snmainfUpdateParam = null;
        snmainfUpdateParam = SerialNumberOperator.isEmpty(occupyBillId) || SerialNumberOperator.isEmpty(occupyBillEntryId) || occupymove != false ? new Object[]{snstatus, billid, entryid, this.billtype, this.entrytype, invorg, mainfileid} : new Object[]{snstatus, occupyBillId, occupyBillEntryId, occupyBillType, occupyBillEntryType, invorg, mainfileid};
        return snmainfUpdateParam;
    }

    private Object[] genSNmainfUpdateParamUnSubmit(Long mainfileid, Row row, SNMainFileStatusCalHelper statusCalHelper, Map<String, Object> reqattr) {
        String sbInvFlu = row.getString("sbillinvfluctuation");
        Integer incInvCounter = row.getInteger("increaseinvcounter");
        Integer subInvCounter = row.getInteger("substractinvcounter");
        Integer incTransCounter = row.getInteger("traincreaseinvcounter");
        Integer subTransCounter = row.getInteger("trasubstractinvcounter");
        String snstatus = statusCalHelper.calMainFileStatusWithCache(sbInvFlu, incInvCounter.intValue(), subInvCounter.intValue(), incTransCounter.intValue(), subTransCounter.intValue());
        Long occupybillid = 0L;
        Long occupybillentryid = 0L;
        String occupybilltype = " ";
        String occupybillentrytype = " ";
        if (reqattr != null && !reqattr.isEmpty()) {
            occupybillid = (Long)reqattr.get("srcbillid");
            occupybillentryid = (Long)reqattr.get("srcentryid");
            occupybilltype = (String)reqattr.get("srcbilltype");
            occupybillentrytype = (String)reqattr.get("srcentrykey");
            String srcInvFlu = (String)reqattr.get("srcinvflu");
            String reStatus = this.resetStatus(srcInvFlu);
            if (reStatus != null) {
                snstatus = reStatus;
            }
        }
        Object[] snmainfUpdateParam = new Object[]{snstatus, occupybillid, occupybillentryid, occupybilltype, occupybillentrytype, mainfileid};
        return snmainfUpdateParam;
    }

    private Object[] genSNmainfUpdateParamAudit(Long mainfileid, Row row, SNMainFileStatusCalHelper statusCalHelper, InvCounterEntity invCounter, Long finalaudittrailid, Map<String, Object> reqattr, DynamicObject snMoveTrackInfo, boolean isAudit) {
        String sbInvFlu = row.getString("sbillinvfluctuation");
        Integer incInvCounter = row.getInteger("increaseinvcounter") + invCounter.getInvIncrease();
        Integer subInvCounter = row.getInteger("substractinvcounter") + invCounter.getInvSubstract();
        Integer incTransCounter = row.getInteger("traincreaseinvcounter") + invCounter.getTransInvIncrease();
        Integer subTransCounter = row.getInteger("trasubstractinvcounter") + invCounter.getTransInvSubstract();
        String snstatus = statusCalHelper.calMainFileStatusWithCache(sbInvFlu, incInvCounter.intValue(), subInvCounter.intValue(), incTransCounter.intValue(), subTransCounter.intValue());
        Long occupybillid = 0L;
        Long occupybillentryid = 0L;
        String occupybilltype = " ";
        String occupybillentrytype = " ";
        if (reqattr != null && !reqattr.isEmpty()) {
            occupybillid = (Long)reqattr.get("srcbillid");
            occupybillentryid = (Long)reqattr.get("srcentryid");
            occupybilltype = (String)reqattr.get("srcbilltype");
            occupybillentrytype = (String)reqattr.get("srcentrykey");
            String srcInvFlu = (String)reqattr.get("srcinvflu");
            String reStatus = this.resetStatus(srcInvFlu);
            if (reStatus != null) {
                snstatus = reStatus;
            }
        }
        ArrayList<Object> snmainfUpdateParam = new ArrayList<Object>();
        snmainfUpdateParam.add(snstatus);
        snmainfUpdateParam.add(occupybillid);
        snmainfUpdateParam.add(occupybillentryid);
        snmainfUpdateParam.add(occupybilltype);
        snmainfUpdateParam.add(occupybillentrytype);
        snmainfUpdateParam.add(incInvCounter);
        snmainfUpdateParam.add(subInvCounter);
        snmainfUpdateParam.add(incTransCounter);
        snmainfUpdateParam.add(subTransCounter);
        snmainfUpdateParam.add(finalaudittrailid);
        if (!this.isreqbill && this.mainFileUpdate.size() > 0) {
            for (DynamicObject object : this.mainFileUpdate) {
                if (isAudit) {
                    snmainfUpdateParam.add(this.getAuditExtColValue(object, row));
                    continue;
                }
                snmainfUpdateParam.add(this.getUnAuditExtColValue(object, row, snMoveTrackInfo));
            }
        }
        if (isAudit && !this.snMainFileNoConditionMap.isEmpty()) {
            Long entryid = row.getLong("entryid");
            DynamicObject billEntry = this.billentriesMap.get(entryid);
            for (String billCol : this.snMainFileNoConditionMap.values()) {
                snmainfUpdateParam.add(billEntry.get(billCol));
            }
        }
        snmainfUpdateParam.add(mainfileid);
        return snmainfUpdateParam.toArray();
    }

    private Object getUnAuditExtColValue(DynamicObject object, Row row, DynamicObject snMoveTrackInfo) {
        String updateWay = object.getString("updateway");
        String moveTrackCol = object.getString("snmovetrackrelcol");
        String mainFileCol = object.getString("snmainfilecol");
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile");
        DynamicProperty prop = mainType.getProperty(mainFileCol);
        boolean isText = false;
        if (prop instanceof TextProp || prop instanceof MuliLangTextProp) {
            isText = true;
        }
        if (StringUtils.isEmpty((String)updateWay) || "1".equals(updateWay)) {
            if (snMoveTrackInfo == null) {
                if (isText) {
                    return " ";
                }
                return null;
            }
            Object oldTextVal = snMoveTrackInfo.get(moveTrackCol);
            if (isText && oldTextVal == null) {
                return " ";
            }
            return oldTextVal;
        }
        int scale = this.getColScale(object.getString("billsnrelationcol"));
        BigDecimal trackValue = row.getBigDecimal(TRACK_TAG + moveTrackCol) == null ? BigDecimal.ZERO : row.getBigDecimal(TRACK_TAG + moveTrackCol);
        BigDecimal mainFileValue = row.getBigDecimal(MAINFILE_TAG + mainFileCol) == null ? BigDecimal.ZERO : row.getBigDecimal(MAINFILE_TAG + mainFileCol);
        return mainFileValue.subtract(trackValue).setScale(scale, RoundingMode.HALF_UP);
    }

    private Object getAuditExtColValue(DynamicObject object, Row row) {
        String updateWay = object.getString("updateway");
        String moveTrackCol = TRACK_TAG + object.getString("snmovetrackrelcol");
        String mainFileCol = object.getString("snmainfilecol");
        if (StringUtils.isEmpty((String)updateWay) || "1".equals(updateWay)) {
            return row.get(moveTrackCol);
        }
        int scale = this.getColScale(object.getString("billsnrelationcol"));
        BigDecimal trackValue = row.getBigDecimal(moveTrackCol) == null ? BigDecimal.ZERO : row.getBigDecimal(moveTrackCol);
        BigDecimal mainFileValue = row.getBigDecimal(MAINFILE_TAG + mainFileCol) == null ? BigDecimal.ZERO : row.getBigDecimal(MAINFILE_TAG + mainFileCol);
        return mainFileValue.add(trackValue).setScale(scale, RoundingMode.HALF_UP);
    }

    private int getColScale(String relationCol) {
        String[] split = relationCol.split("\\.");
        if (split.length > 1) {
            DecimalProp iDataEntityProperty = (DecimalProp)this.billRelationProperties.get(split[split.length - 1]);
            return iDataEntityProperty.getScale();
        }
        return 10;
    }

    private String resetStatus(String invFlu) {
        if (invFlu.equals("1")) {
            return "A";
        }
        if (invFlu.equals("2")) {
            return "C";
        }
        return "C";
    }

    private String buildSNTrackInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into t_bd_snmovetrack(fid,fsnmainfileid,fbillstatus,fbillid,fbillentryid,fbllentityid,fbillentrytype");
        if (this.trackMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack").getAllFields();
            for (String tarcol : this.trackMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias());
            }
        }
        builder.append(") values(").append(String.join((CharSequence)",", Collections.nCopies(7 + this.trackMaps.size(), "?"))).append(')');
        return builder.toString();
    }

    private Object[] genSNTrackInsertParam(Long billid, Long entryid, Long trackId, Row row) {
        DynamicObject billentry = this.billentriesMap.get(entryid);
        Object[] sntrackInsertParam = new Object[7 + this.trackMaps.size()];
        sntrackInsertParam[0] = trackId;
        sntrackInsertParam[1] = 0;
        sntrackInsertParam[2] = "B";
        sntrackInsertParam[3] = billid;
        sntrackInsertParam[4] = entryid;
        sntrackInsertParam[5] = this.billtype;
        sntrackInsertParam[6] = this.entrytype;
        int i = 7;
        for (String srccol : this.trackMaps.values()) {
            sntrackInsertParam[i] = billentry.get(srccol);
            ++i;
        }
        return sntrackInsertParam;
    }

    private String buildSNTrackUpdateSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("update t_bd_snmovetrack set fbillstatus = ?");
        if (this.trackMaps.size() > 0) {
            Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack").getAllFields();
            for (String tarcol : this.trackMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)fieldTypes.get(tarcol)).getAlias()).append(" = ?");
            }
        }
        builder.append(" where fid = ?");
        return builder.toString();
    }

    private Object[] genSNTrackUpdateParam(Long trackid, Long entryid, Row row) {
        DynamicObject billentry = this.billentriesMap.get(entryid);
        Object[] sntrackUpdateParam = new Object[2 + this.trackMaps.size()];
        sntrackUpdateParam[0] = "B";
        int i = 1;
        for (String srccol : this.trackMaps.values()) {
            sntrackUpdateParam[i] = billentry.get(srccol);
            ++i;
        }
        sntrackUpdateParam[i] = trackid;
        return sntrackUpdateParam;
    }

    private String getSNTrackUpdateSqlAudit() {
        return "update t_bd_snmovetrack set fbillstatus = ?,fincreaseinvcounter = ?,fsubstractinvcounter = ?,ftraincreaseinvcounter = ?,ftrasubstractinvcounter = ?,fnowinvaccid = ?,fbalancetype = ?,fauditdate = ? where fbillid = ? and fbillentryid = ? and fbillstatus = ?";
    }

    private Object[] getSNTrackUpdateParamAudit(InvCounterEntity invCounter, Long billid, Long entryid, String balancetype, Long invaccid, Date auditDate) {
        Object[] sntrackUpdateParam = new Object[]{"C", invCounter.getInvIncrease(), invCounter.getInvSubstract(), invCounter.getTransInvIncrease(), invCounter.getTransInvSubstract(), invaccid, balancetype, auditDate, billid, entryid, "B"};
        return sntrackUpdateParam;
    }

    private String getSNTrackrelInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into t_bd_snmovetrack_rel(fid,fsnmainfileid,ftrackid");
        Map moveTrackFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack_rel").getAllFields();
        if (this.trackExtRelMaps.size() > 0) {
            for (String tarcol : this.trackExtRelMaps.keySet()) {
                builder.append(',').append(((IDataEntityProperty)moveTrackFieldTypes.get(tarcol)).getAlias());
            }
        }
        if (this.snEnterLists.size() > 0) {
            HashSet<String> moveTrackCols = new HashSet<String>(this.snEnterLists.size());
            for (DynamicObject obj : this.snEnterLists) {
                String moveTrackCol = obj.getString("snmovetrackrelcol");
                if (moveTrackCols.contains(moveTrackCol)) continue;
                moveTrackCols.add(moveTrackCol);
                if (!moveTrackFieldTypes.containsKey(moveTrackCol)) continue;
                builder.append(",").append(((IDataEntityProperty)moveTrackFieldTypes.get(moveTrackCol)).getAlias());
            }
        }
        builder.append(") values(").append(String.join((CharSequence)",", Collections.nCopies(3 + this.trackExtRelMaps.size() + this.getUpdateCount(), "?"))).append(')');
        return builder.toString();
    }

    private int getUpdateCount() {
        HashSet<String> moveTrackCols = new HashSet<String>(this.snEnterLists.size());
        int count = 0;
        for (DynamicObject obj : this.snEnterLists) {
            String moveTrackCol = obj.getString("snmovetrackrelcol");
            if (moveTrackCols.contains(moveTrackCol)) continue;
            moveTrackCols.add(moveTrackCol);
            ++count;
        }
        return count;
    }

    private Object[] genSNTrackrelInsertParam(Long mainfileid, Long trackid, Long relid, Row row) {
        Object[] sntrackrelInsertParam = new Object[3 + this.trackExtRelMaps.size() + this.getUpdateCount()];
        sntrackrelInsertParam[0] = relid;
        sntrackrelInsertParam[1] = mainfileid;
        sntrackrelInsertParam[2] = trackid;
        int i = 3;
        for (String billsncol : this.trackExtRelMaps.values()) {
            sntrackrelInsertParam[i] = row.get(billsncol);
            ++i;
        }
        Map moveTrackFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack_rel").getAllFields();
        HashSet<String> moveTrackCols = new HashSet<String>(this.snEnterLists.size());
        for (DynamicObject object : this.snEnterLists) {
            String moveTrackCol = object.getString("snmovetrackrelcol");
            if (moveTrackCols.contains(moveTrackCol)) continue;
            moveTrackCols.add(moveTrackCol);
            if (!moveTrackFieldTypes.containsKey(moveTrackCol)) continue;
            sntrackrelInsertParam[i] = this.getMoveTrackColValue(object, row);
            ++i;
        }
        return sntrackrelInsertParam;
    }

    private Object getMoveTrackColValue(DynamicObject object, Row row) {
        BigDecimal value;
        String moveTrackCol = object.getString("snmovetrackrelcol");
        String updateWay = object.getString("updateway");
        String billRelationCol = object.getString("billsnrelationcol");
        if (StringUtils.isEmpty((String)updateWay) || "1".equals(updateWay)) {
            return row.get(moveTrackCol);
        }
        int scale = this.getColScale(billRelationCol);
        BigDecimal qty = row.getBigDecimal(moveTrackCol);
        BigDecimal bigDecimal = value = qty == null ? BigDecimal.ZERO : qty.setScale(scale, RoundingMode.HALF_UP);
        if ("3".equals(updateWay)) {
            value = value.negate();
        }
        return value;
    }

    private String getSNTrackrelUpdateSql() {
        if (this.trackExtRelMaps.isEmpty() && this.snEnterLists.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("update t_bd_snmovetrack_rel set ");
        Map moveTrackFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack_rel").getAllFields();
        int i = 0;
        for (String tarcol : this.trackExtRelMaps.keySet()) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(((IDataEntityProperty)moveTrackFieldTypes.get(tarcol)).getAlias()).append(" = ?");
            ++i;
        }
        if (this.snEnterLists.size() > 0) {
            HashSet<String> moveTrackCols = new HashSet<String>(this.snEnterLists.size());
            for (DynamicObject entry : this.snEnterLists) {
                String moveTrackCol = entry.getString("snmovetrackrelcol");
                if (moveTrackCols.contains(moveTrackCol)) continue;
                moveTrackCols.add(moveTrackCol);
                if (!moveTrackFieldTypes.containsKey(moveTrackCol)) continue;
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(((IDataEntityProperty)moveTrackFieldTypes.get(moveTrackCol)).getAlias()).append(" = ?");
                ++i;
            }
        }
        builder.append(" where fid = ?");
        return builder.toString();
    }

    private Object[] genSNTrackrelUpdateParam(Long relid, Row row) {
        Object[] sntrackrelUpdateParam = new Object[1 + this.trackExtRelMaps.size() + this.getUpdateCount()];
        int i = 0;
        for (String billsncol : this.trackExtRelMaps.values()) {
            sntrackrelUpdateParam[i] = row.get(billsncol);
            ++i;
        }
        if (this.snEnterLists.size() > 0) {
            Map moveTrackFieldTypes = MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack_rel").getAllFields();
            HashSet<String> moveTrackCols = new HashSet<String>(this.snEnterLists.size());
            for (DynamicObject entry : this.snEnterLists) {
                String moveTrackCol = entry.getString("snmovetrackrelcol");
                if (moveTrackCols.contains(moveTrackCol)) continue;
                moveTrackCols.add(moveTrackCol);
                if (!moveTrackFieldTypes.containsKey(moveTrackCol)) continue;
                sntrackrelUpdateParam[i] = this.getMoveTrackColValue(entry, row);
                ++i;
            }
        }
        sntrackrelUpdateParam[i] = relid;
        return sntrackrelUpdateParam;
    }

    private String buildDimInsertSql() {
        return "insert into t_bd_sndimensionentry(fid,fentryid,fseq,fsndimitem,fsndimnumber) values(?,?,?,?,?)";
    }

    private Object[] genDimInsertParam(Long id, Long entryid, Integer seq, Long sndimitem, String sndimnumber) {
        Object[] dimInsertParam = new Object[]{id, entryid, seq, sndimitem, sndimnumber};
        return dimInsertParam;
    }

    private static void executeBatchSql(List<Object[]> params, String sql) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
        params.clear();
    }

    private static boolean isEmpty(Long id) {
        return id == null || id.equals(0L);
    }
}

