/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.common.report;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

public class RptFilterUtil {
    public static String ROW_ORG = "org";
    public static String FLAG_MULTIPLE = "multiple";
    public static String FLAG_FILTER = "filter";
    public static String FLAG_STARTDATE = "_startdate";
    public static String FLAG_ENDDATE = "_enddate";

    public static void addBasicDataEqualsFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        DynamicObject dynamicObject = filterInfo.getDynamicObject(filterName);
        if (dynamicObject != null) {
            QFilter filter = new QFilter(rowName, "=", dynamicObject.getPkValue());
            filters.add(filter);
        }
    }

    public static void addMultipleBasicDataEqualsFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        DynamicObjectCollection multiplefilter = filterInfo.getDynamicObjectCollection(filterName);
        if (multiplefilter != null) {
            Object[] ids = RptFilterUtil.getBaseDataPkIds(multiplefilter);
            filters.add(new QFilter(rowName, "in", (Object)ids));
        }
    }

    public static void addComboEqualsFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        String comboValue = filterInfo.getString(filterName);
        if (StringUtils.isNotEmpty((CharSequence)comboValue)) {
            QFilter comboFilter = new QFilter(rowName, "=", (Object)comboValue);
            filters.add(comboFilter);
        }
    }

    public static void addDateRangFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        Date enddate;
        Date startdate = filterInfo.getDate(filterName + FLAG_STARTDATE);
        if (startdate != null) {
            QFilter dateFilter = new QFilter(rowName, ">=", (Object)startdate);
            filters.add(dateFilter);
        }
        if ((enddate = filterInfo.getDate(filterName + FLAG_ENDDATE)) != null) {
            QFilter dateFilter = new QFilter(rowName, "<=", (Object)enddate);
            filters.add(dateFilter);
        }
    }

    public static void addTimeRangFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        Date enddate;
        Date startdate = filterInfo.getDate(filterName + FLAG_STARTDATE);
        if (startdate != null) {
            QFilter dateFilter = new QFilter(rowName, ">=", (Object)startdate);
            filters.add(dateFilter);
        }
        if ((enddate = filterInfo.getDate(filterName + FLAG_ENDDATE)) != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(enddate);
            c.add(5, 1);
            enddate = c.getTime();
            QFilter dateFilter = new QFilter(rowName, "<=", (Object)enddate);
            filters.add(dateFilter);
        }
    }

    public static String getNotNullDateFilter(FilterInfo filterInfo, String filterName, String rowName) {
        Date date = filterInfo.getDate(filterName);
        if (date == null) {
            return null;
        }
        QFilter dateFilter = QFilter.isNotNull((String)rowName);
        return dateFilter.toString();
    }

    public static void addTextFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        String textValue = filterInfo.getString(filterName);
        if (StringUtils.isNotEmpty((CharSequence)textValue)) {
            textValue = "%" + textValue + "%";
            QFilter textFilter = new QFilter(rowName, "ftlike", (Object)textValue);
            filters.add(textFilter);
        }
    }

    public static void addOrgMultipleFilter(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        DynamicObjectCollection orgmultiplefilter = filterInfo.getDynamicObjectCollection(filterName);
        if (orgmultiplefilter != null && orgmultiplefilter.size() > 0) {
            Object[] orgIds = RptFilterUtil.getBaseDataPkIds(orgmultiplefilter);
            filters.add(new QFilter(rowName, "in", (Object)orgIds));
        } else {
            List<Long> orgList = RptFilterUtil.getHasPermOrgs();
            filters.add(new QFilter(rowName, "in", orgList));
        }
    }

    public static void addOrgMultipleFilterEx(FilterInfo filterInfo, String filterName, String rowName, List<QFilter> filters) {
        DynamicObjectCollection orgmultiplefilter = filterInfo.getDynamicObjectCollection(filterName);
        if (orgmultiplefilter != null && orgmultiplefilter.size() > 0) {
            Object[] orgIds = RptFilterUtil.getBaseDataPkIds(orgmultiplefilter);
            filters.add(new QFilter(rowName, "in", (Object)orgIds));
        } else {
            List<Long> orgList = RptFilterUtil.getAllPermOrgs();
            if (rowName.equals("org") && orgList.isEmpty()) {
                filters.add(new QFilter(rowName, "!=", (Object)0L));
            } else {
                filters.add(new QFilter(rowName, "in", orgList));
            }
        }
    }

    @SdkDeprecated
    public static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public static List<Long> getHasPermOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)"bid_detailqueryrpt", (String)"47150e89000000ac");
        return hasPermOrgs;
    }

    public static List<Long> getAllPermOrgs() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)"rebm", (String)"bid_detailqueryrpt", (String)"47156aff000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List hasPermOrgList = hasAllOrgPerm ? OrgUnitServiceHelper.getAllOrgByViewNumber((String)"02", (boolean)false) : hasPermOrgResult.getHasPermOrgs();
        return hasPermOrgList;
    }
}

