/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.BizLog;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidDecisionSectionStatusEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.sdk.annotation.SdkDeprecated;

public class BidDecisionServiceImpl
extends BidServiceImpl
implements IBidDecisionService {
    private static final String selectSectionString = "bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.invitationstatus";
    public static String[] BID_ENTITY = new String[]{"bid_bidopen", "bid_bidpublish", "bid_biddocument_edit"};
    public static String[] REBM_ENTITY = new String[]{"rebm_bidopen", "rebm_bidpublish", "rebm_biddocument_edit"};
    public static String[] BID_ENTITY_1 = new String[]{"bid_bidopen", "bid_bidpublish", "bid_supplierinvitation", "bid_project"};
    public static String[] REBM_ENTITY_1 = new String[]{"rebm_bidopen", "rebm_bidpublish", "rebm_supplierinvitation", "rebm_project"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        Object supbackdetailType;
        Long id;
        DynamicObject evaluation;
        DynamicObject bidPro;
        DynamicObject decisionObj;
        MainEntityType type;
        String appId;
        block61: {
            Iterator iterator;
            DynamicObjectCollection bidProjectSection;
            EntityType supfinaldetailType;
            block62: {
                DynamicObjectCollection purBidOpenSections;
                EntityType supFinalDetailType;
                EntityType supBackDetailType;
                Object name;
                block60: {
                    block59: {
                        DynamicObject lastDynamicData;
                        boolean isBidOpen;
                        BigDecimal ctrlAmtExceptVat;
                        BigDecimal ctrlAmt;
                        block57: {
                            DynamicObject decide;
                            DynamicObjectCollection section4Decision;
                            block58: {
                                Objects.requireNonNull(bidProject);
                                appId = this.getAppId(bidProject);
                                ORM orm = ORM.create();
                                type = EntityMetadataCache.getDataEntityType((String)this.getFormIdByDecision(appId));
                                EntityType secType = (EntityType)type.getAllEntities().get("bidsection");
                                EntityType supType = (EntityType)type.getAllEntities().get("supplierentry");
                                decisionObj = new DynamicObject((DynamicObjectType)type);
                                decisionObj.set("bidproject", (Object)bidProject);
                                bidPro = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)this.getFormIdByProject(appId));
                                decisionObj.set("currency", bidPro.get("currency"));
                                QFilter filter = new QFilter("bidproject", "=", bidProject.getPkValue());
                                QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal());
                                DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)this.getFormIdBySupplierinvitation(appId), (String)"id,bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.invitationstatus", (QFilter[])new QFilter[]{filter, billstatusFilter});
                                ctrlAmt = BigDecimal.ZERO;
                                ctrlAmtExceptVat = BigDecimal.ZERO;
                                DynamicObjectCollection purDetails = bidPro.getDynamicObjectCollection("bidsection").stream().flatMap(section -> section.getDynamicObjectCollection("projectentry").stream()).collect(Collectors.toCollection(DynamicObjectCollection::new));
                                for (DynamicObject purDetail : purDetails) {
                                    BigDecimal caev;
                                    BigDecimal ca = purDetail.getBigDecimal("controlamount");
                                    if (ca != null) {
                                        ctrlAmt = ctrlAmt.add(ca);
                                    }
                                    if ((caev = purDetail.getBigDecimal("ctrlamtexceptvat")) == null) continue;
                                    ctrlAmtExceptVat = ctrlAmtExceptVat.add(caev);
                                }
                                decisionObj.set("xkpurregbillno", bidPro.get("xkpurregbillno"));
                                decisionObj.set("xkpurreqid", bidPro.get("xkpurreqid"));
                                decisionObj.set("datasource", bidPro.get("datasource"));
                                isBidOpen = bidPro.getBoolean("bidopen");
                                boolean isBidEvaluation = bidPro.getBoolean("bidevaluation");
                                boolean isSupplierInvitation = bidPro.getBoolean("supplierinvitation");
                                boolean isBidPublish = bidPro.getBoolean("bidpublish");
                                evaluation = null;
                                Map<String, BigDecimal> evaluationScores = null;
                                Map<String, Map<String, BigDecimal>> clarifyPrices = null;
                                lastDynamicData = this.getLastStepDynamicObject(bidPro);
                                if (lastDynamicData == null) {
                                    return;
                                }
                                DynamicObjectCollection sections = null;
                                sections = !isBidOpen && !isBidEvaluation && !isSupplierInvitation && !isBidPublish ? lastDynamicData.getDynamicObjectCollection("bidrollsection") : lastDynamicData.getDynamicObjectCollection("bidsection");
                                DynamicObject way = this.getEvaluateDecideWay(bidPro);
                                if (way != null) {
                                    decisionObj.set("evaluatedecideway", (Object)way);
                                }
                                if (sections == null) break block57;
                                if (isBidEvaluation) {
                                    String bidOpenType = bidPro.getString("bidopentype");
                                    QFilter[] evaluationFilterArray = null;
                                    if ("UNIONOPEN".equals(bidOpenType)) {
                                        evaluationFilterArray = new QFilter[]{new QFilter("bidProject", "=", bidPro.getPkValue()).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()))};
                                        evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])evaluationFilterArray);
                                    } else {
                                        evaluationFilterArray = new QFilter[]{new QFilter("bidProject", "=", bidPro.getPkValue()).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal())).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()))};
                                        evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])evaluationFilterArray);
                                    }
                                    if (evaluation != null) {
                                        evaluationScores = this.getEvaluationScores(bidPro);
                                        clarifyPrices = this.getEvaluationClarifyPrice(evaluation);
                                    }
                                }
                                Map<String, BigDecimal> es = evaluationScores;
                                Map<String, Map<String, BigDecimal>> cp = clarifyPrices;
                                boolean needFlagNewSupplier = false;
                                section4Decision = sections.stream().map(section -> {
                                    String sectionname = "";
                                    DynamicObject sec = new DynamicObject((DynamicObjectType)secType);
                                    sectionname = !isBidOpen && !isBidEvaluation && !isSupplierInvitation && !isBidPublish ? section.getString("rollsectionname") : section.getString("sectionname");
                                    sec.set("sectionname", (Object)sectionname);
                                    Object sectionId = section.getPkValue();
                                    DynamicObjectCollection supplierEntries4Decision = section.getDynamicObjectCollection("supplierentry").stream().filter(supEntry -> {
                                        if (!isBidOpen) {
                                            return true;
                                        }
                                        return !supEntry.getBoolean("supplier_isinvalid") && supEntry.getBoolean("supplier_istender") && !supEntry.getBoolean("untenderflag");
                                    }).map(this.generateSupplierDetail(supType, isBidOpen, sectionId, orm, es, sectionname, isBidEvaluation, cp, appId)).collect(Collectors.toCollection(DynamicObjectCollection::new));
                                    DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
                                    if (bidMode != null) {
                                        if (!BidModeHelper.isPublicBidding((DynamicObject)bidProject) && supplierInvitation != null) {
                                            if (supplierEntries4Decision != null && supplierEntries4Decision.size() > 0) {
                                                DynamicObjectCollection supplierInvitationSection = supplierInvitation.getDynamicObjectCollection("bidsection");
                                                for (int i = 0; i < supplierInvitationSection.size(); ++i) {
                                                    DynamicObjectCollection supplierEntryColl;
                                                    DynamicObject thisSection = (DynamicObject)supplierInvitationSection.get(i);
                                                    if (!thisSection.getPkValue().equals(sectionId) || (supplierEntryColl = thisSection.getDynamicObjectCollection("supplierentry")) == null || supplierEntryColl.size() <= 0) continue;
                                                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                                                        DynamicObject thisSupplierEntry = (DynamicObject)supplierEntryColl.get(j);
                                                        if (!"UNCONFIRM".equals(thisSupplierEntry.get("invitationstatus")) && !"REJECTED".equals(thisSupplierEntry.get("invitationstatus"))) continue;
                                                        DynamicObject thisSupplier = thisSupplierEntry.getDynamicObject("supplier");
                                                        Iterator iterator = supplierEntries4Decision.iterator();
                                                        while (iterator.hasNext()) {
                                                            DynamicObject iteratorSupplier = ((DynamicObject)iterator.next()).getDynamicObject("supplier");
                                                            if (!iteratorSupplier.getPkValue().equals(thisSupplier.getPkValue())) continue;
                                                            iterator.remove();
                                                        }
                                                    }
                                                }
                                            }
                                        } else if (supplierEntries4Decision != null && supplierEntries4Decision.size() > 0) {
                                            Iterator iterator = supplierEntries4Decision.iterator();
                                            while (iterator.hasNext()) {
                                                DynamicObject iteratorSupplier = ((DynamicObject)iterator.next()).getDynamicObject("supplier");
                                                if (iteratorSupplier != null) continue;
                                                iterator.remove();
                                            }
                                        }
                                    }
                                    sec.set("supplierentry", (Object)supplierEntries4Decision);
                                    sec.set("seq", section.get("seq"));
                                    return sec;
                                }).collect(Collectors.toCollection(DynamicObjectCollection::new));
                                this.setRound(section4Decision, bidProject);
                                long supplierCount = section4Decision.stream().flatMap(section -> section.getDynamicObjectCollection("supplierentry").stream()).count();
                                if (supplierCount > 0L) {
                                    needFlagNewSupplier = true;
                                }
                                decisionObj.set("needflagnewsupplier", (Object)needFlagNewSupplier);
                                decisionObj.set("bidsection", (Object)section4Decision);
                                decide = decisionObj.getDynamicObject("evaluatedecideway");
                                this.rangeSupplierDetailByScore(section4Decision, decide);
                                if (decide == null) break block57;
                                Long decideId = decide.getLong("id");
                                DynamicObject decideAll = BusinessDataServiceHelper.loadSingle((Object)decideId, (String)"bid_evaluatedecideway");
                                name = decideAll.getLocaleString("name");
                                Lang lang = RequestContext.get().getLang();
                                if (Lang.zh_CN.equals((Object)lang)) break block58;
                                if (Lang.zh_TW.equals((Object)lang)) break block58;
                                if (StringUtils.equals((CharSequence)name.getLocaleValue_en(), (CharSequence)"Comprehensive scoring method")) {
                                    this.rangeSupplierDetailByScore(section4Decision, decide);
                                    break block57;
                                } else if (StringUtils.equals((CharSequence)name.getLocaleValue_en(), (CharSequence)"Reasonably Low Price")) {
                                    this.rangeSupplierDetailByScore(section4Decision, decide);
                                }
                                break block57;
                            }
                            if (StringUtils.equals((CharSequence)name.getLocaleValue_zh_CN(), (CharSequence)ResManager.loadKDString((String)"\u7efc\u5408\u8bc4\u5206\u6cd5", (String)"BidDecisionServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]))) {
                                this.rangeSupplierDetailByScore(section4Decision, decide);
                            } else if (StringUtils.equals((CharSequence)name.getLocaleValue_zh_CN(), (CharSequence)ResManager.loadKDString((String)"\u5408\u7406\u4f4e\u4ef7\u6cd5", (String)"BidDecisionServiceImpl_9", (String)"scm-bid-business", (Object[])new Object[0]))) {
                                this.rangeSupplierDetailByScore(section4Decision, decide);
                            }
                        }
                        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
                        DynamicObject creator = creatorMap.get("08");
                        decisionObj.set("creator", (Object)creator);
                        decisionObj.set("createtime", (Object)new Date());
                        decisionObj.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
                        decisionObj.set("org", bidPro.get("org"));
                        decisionObj.set("billno", bidPro.get("billno"));
                        id = ORM.create().genLongId((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_decision"));
                        decisionObj.set("id", (Object)id);
                        decisionObj.set("controlamount", (Object)ctrlAmt);
                        decisionObj.set("exctaxcontrolamount", (Object)ctrlAmtExceptVat);
                        decisionObj.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
                        supBackDetailType = (EntityType)type.getAllEntities().get("supbackdetail");
                        supFinalDetailType = (EntityType)type.getAllEntities().get("supfinaldetail");
                        MainEntityType bidOpenType = null;
                        bidOpenType = appId.equals("rebm") ? EntityMetadataCache.getDataEntityType((String)"rebm_bidopen") : EntityMetadataCache.getDataEntityType((String)"bid_bidopen");
                        if (!isBidOpen) break block59;
                        DynamicObject purBidOpen = BusinessDataServiceHelper.loadSingle((Object)lastDynamicData.getLong("id"), (DynamicObjectType)bidOpenType);
                        purBidOpenSections = purBidOpen.getDynamicObjectCollection("bidsection");
                        DynamicObjectCollection purDecisionSections = decisionObj.getDynamicObjectCollection("bidsection");
                        name = purDecisionSections.iterator();
                        break block60;
                    }
                    MainEntityType bidDecisionType = EntityMetadataCache.getDataEntityType((String)(appId + "_decision"));
                    supbackdetailType = (EntityType)bidDecisionType.getAllEntities().get("supbackdetail");
                    supfinaldetailType = (EntityType)bidDecisionType.getAllEntities().get("supfinaldetail");
                    DynamicObject bidProjectAll = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_project"));
                    bidProjectSection = bidProjectAll.getDynamicObjectCollection("bidsection");
                    DynamicObjectCollection deSectionColl = decisionObj.getDynamicObjectCollection("bidsection");
                    DynamicObjectCollection tempPurDetails = ((DynamicObject)deSectionColl.get(0)).getDynamicObjectCollection("supbackdetail");
                    if (tempPurDetails != null && tempPurDetails.size() != 0) break block61;
                    iterator = deSectionColl.iterator();
                    break block62;
                }
                while (name.hasNext()) {
                    DynamicObject purDecisionSection = (DynamicObject)name.next();
                    String purDecisionSectionName = purDecisionSection.getString("sectionname");
                    DynamicObjectCollection purDecisionBackDetails = new DynamicObjectCollection((DynamicObjectType)supBackDetailType, (Object)purDecisionSection);
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection((DynamicObjectType)supFinalDetailType, (Object)purDecisionSection);
                    for (DynamicObject purBidOpenSection : purBidOpenSections) {
                        if (!StringUtils.equals((CharSequence)purBidOpenSection.getString("sectionname"), (CharSequence)purDecisionSectionName)) continue;
                        DynamicObjectCollection bidOpenSupDetails = purBidOpenSection.getDynamicObjectCollection("supplierdetail");
                        int k = 0;
                        for (DynamicObject bidOpenSupDetail : bidOpenSupDetails) {
                            DynamicObject purDecisionBackDetail = new DynamicObject((DynamicObjectType)supBackDetailType);
                            purDecisionBackDetail.set("seq", (Object)k);
                            purDecisionBackDetail.set("pursupplier", bidOpenSupDetail.get("pursupplier"));
                            purDecisionBackDetail.set("purentrycontent", bidOpenSupDetail.get("purentrycontent"));
                            purDecisionBackDetail.set("purentryproject", bidOpenSupDetail.get("purentryproject"));
                            purDecisionBackDetail.set("materialid", bidOpenSupDetail.get("materialid"));
                            purDecisionBackDetail.set("baseunit", bidOpenSupDetail.get("baseunit"));
                            purDecisionBackDetail.set("materialdes", bidOpenSupDetail.get("materialdes"));
                            purDecisionBackDetail.set("qty", bidOpenSupDetail.get("qty"));
                            purDecisionBackDetail.set("inclutaxprice", bidOpenSupDetail.get("inclutaxprice"));
                            purDecisionBackDetail.set("inclutaxamount", bidOpenSupDetail.get("inclutaxamount"));
                            purDecisionBackDetail.set("bd_taxrate", bidOpenSupDetail.get("bd_taxrate"));
                            purDecisionBackDetail.set("taxrate", bidOpenSupDetail.get("taxrate"));
                            purDecisionBackDetail.set("taxamount", bidOpenSupDetail.get("taxamount"));
                            purDecisionBackDetail.set("excepttaxamount", bidOpenSupDetail.get("excepttaxamount"));
                            purDecisionBackDetail.set("costrate", bidOpenSupDetail.get("costrate"));
                            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                                purDecisionBackDetail.set("listnumber", bidOpenSupDetail.get("listnumber"));
                                purDecisionBackDetail.set("listname", bidOpenSupDetail.get("listname"));
                                purDecisionBackDetail.set("resourceitem", bidOpenSupDetail.get("resourceitem"));
                            }
                            purDecisionBackDetails.add((Object)purDecisionBackDetail);
                            DynamicObject purDecisionFinalDetail = new DynamicObject((DynamicObjectType)supFinalDetailType);
                            purDecisionFinalDetail.set("seq", (Object)k);
                            purDecisionFinalDetail.set("lpursupplier", bidOpenSupDetail.get("pursupplier"));
                            purDecisionFinalDetail.set("lpurentrycontent", bidOpenSupDetail.get("purentrycontent"));
                            purDecisionFinalDetail.set("lpurentryproject", bidOpenSupDetail.get("purentryproject"));
                            purDecisionFinalDetail.set("lmaterialid", bidOpenSupDetail.get("materialid"));
                            purDecisionFinalDetail.set("lbaseunit", bidOpenSupDetail.get("baseunit"));
                            purDecisionFinalDetail.set("lmaterialdes", bidOpenSupDetail.get("materialdes"));
                            purDecisionFinalDetail.set("lqty", bidOpenSupDetail.get("qty"));
                            purDecisionFinalDetail.set("linclutaxprice", bidOpenSupDetail.get("inclutaxprice"));
                            purDecisionFinalDetail.set("linclutaxamount", bidOpenSupDetail.get("inclutaxamount"));
                            purDecisionFinalDetail.set("lbd_taxrate", bidOpenSupDetail.get("bd_taxrate"));
                            purDecisionFinalDetail.set("ltaxrate", bidOpenSupDetail.get("taxrate"));
                            purDecisionFinalDetail.set("ltaxamount", bidOpenSupDetail.get("taxamount"));
                            purDecisionFinalDetail.set("lexcepttaxamount", bidOpenSupDetail.get("excepttaxamount"));
                            purDecisionFinalDetail.set("lcostrate", bidOpenSupDetail.get("costrate"));
                            purDecisionFinalDetail.set("detailsignflag", (Object)Boolean.FALSE);
                            purDecisionFinalDetail.set("recommendedflag", (Object)Boolean.FALSE);
                            if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                                purDecisionFinalDetail.set("llistnumber", bidOpenSupDetail.get("listnumber"));
                                purDecisionFinalDetail.set("llistname", bidOpenSupDetail.get("listname"));
                                purDecisionFinalDetail.set("lresourceitem", bidOpenSupDetail.get("resourceitem"));
                                purDecisionFinalDetail.set("lresourceitem", bidOpenSupDetail.get("resourceitem"));
                            }
                            dynamicObjectCollection.add((Object)purDecisionFinalDetail);
                            ++k;
                        }
                    }
                    purDecisionSection.set("supbackdetail", (Object)purDecisionBackDetails);
                    purDecisionSection.set("supfinaldetail", (Object)dynamicObjectCollection);
                }
                break block61;
            }
            block15: while (iterator.hasNext()) {
                DynamicObject decisionSection = (DynamicObject)iterator.next();
                DynamicObjectCollection newBackDetails = new DynamicObjectCollection((DynamicObjectType)supbackdetailType, (Object)decisionSection);
                DynamicObjectCollection newFinalDetails = new DynamicObjectCollection((DynamicObjectType)supfinaldetailType, (Object)decisionSection);
                String deSectionName = decisionSection.getString("sectionname");
                int i = 0;
                while (true) {
                    block64: {
                        Iterator iterator2;
                        DynamicObjectCollection supbackdetailColl;
                        DynamicObject projectSection;
                        block65: {
                            block63: {
                                if (i >= bidProjectSection.size()) break block63;
                                projectSection = (DynamicObject)bidProjectSection.get(i);
                                if (!StringUtils.equals((CharSequence)deSectionName, (CharSequence)projectSection.getString("sectionname"))) break block64;
                                DynamicObjectCollection supplierEntryColl = decisionSection.getDynamicObjectCollection("supplierentry");
                                supbackdetailColl = decisionSection.getDynamicObjectCollection("supbackdetail");
                                iterator2 = supplierEntryColl.iterator();
                                break block65;
                            }
                            decisionSection.set("supbackdetail", (Object)newBackDetails);
                            decisionSection.set("supfinaldetail", (Object)newFinalDetails);
                            continue block15;
                        }
                        while (iterator2.hasNext()) {
                            DynamicObject supplierEntry = (DynamicObject)iterator2.next();
                            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            int result = 0;
                            for (DynamicObject supbackdetail : supbackdetailColl) {
                                Object supBackDetailPkValue = supbackdetail.getDynamicObject("pursupplier").getPkValue();
                                if (!supBackDetailPkValue.equals(supplier.getPkValue())) continue;
                                ++result;
                            }
                            if (result != 0) continue;
                            DynamicObjectCollection projectEntryColl = projectSection.getDynamicObjectCollection("projectentry");
                            int k = 0;
                            for (DynamicObject projectEntry : projectEntryColl) {
                                DynamicObject newBackDetail = new DynamicObject((DynamicObjectType)supbackdetailType);
                                DynamicObject newFinalDetail = new DynamicObject((DynamicObjectType)supfinaldetailType);
                                newBackDetail.set("seq", (Object)k);
                                newBackDetail.set("pursupplier", (Object)supplier);
                                newBackDetail.set("purentrycontent", projectEntry.get("purentrycontent"));
                                newBackDetail.set("purentryproject", projectEntry.get("purentryproject"));
                                newBackDetail.set("materialid", projectEntry.get("materialid"));
                                newBackDetail.set("baseunit", projectEntry.get("baseunit"));
                                newBackDetail.set("materialdes", projectEntry.get("materialdes"));
                                newBackDetail.set("qty", projectEntry.get("qty"));
                                if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                                    newBackDetail.set("listnumber", projectEntry.get("listnumber"));
                                    newBackDetail.set("listname", projectEntry.get("listname"));
                                    newBackDetail.set("resourceitem", projectEntry.get("resourceitem"));
                                }
                                newBackDetails.add((Object)newBackDetail);
                                newFinalDetail.set("seq", (Object)k);
                                newFinalDetail.set("lpursupplier", (Object)supplier);
                                newFinalDetail.set("seq", (Object)k);
                                newFinalDetail.set("lpurentrycontent", projectEntry.get("purentrycontent"));
                                newFinalDetail.set("lpurentryproject", projectEntry.get("purentryproject"));
                                newFinalDetail.set("lmaterialid", projectEntry.get("materialid"));
                                newFinalDetail.set("lbaseunit", projectEntry.get("baseunit"));
                                newFinalDetail.set("lmaterialdes", projectEntry.get("materialdes"));
                                newFinalDetail.set("lqty", projectEntry.get("qty"));
                                newFinalDetail.set("detailsignflag", (Object)Boolean.FALSE);
                                newFinalDetail.set("recommendedflag", (Object)Boolean.FALSE);
                                if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                                    newFinalDetail.set("llistnumber", projectEntry.get("listnumber"));
                                    newFinalDetail.set("llistname", projectEntry.get("listname"));
                                    newFinalDetail.set("lresourceitem", projectEntry.get("resourceitem"));
                                }
                                newFinalDetails.add((Object)newFinalDetail);
                                ++k;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        EntityTypeHelper.setEntityType(decisionObj, "bid_decision", "bidProject");
        SaveServiceHelper.save((IDataEntityType)type, (Object[])new DynamicObject[]{decisionObj});
        if (evaluation != null) {
            TXHandle h = TX.requiresNew();
            supbackdetailType = null;
            try {
                try {
                    BidFileHelper.copyFileFromAToB(appId + "_bidevaluation", evaluation.getPkValue(), "attachmentpanel", appId + "_decision", id, "attachmentpanel");
                }
                catch (Throwable ex) {
                    h.markRollback();
                    throw ex;
                }
            }
            catch (Throwable ex) {
                supbackdetailType = ex;
                throw ex;
            }
            finally {
                if (h != null) {
                    if (supbackdetailType != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable ex) {
                            ((Throwable)supbackdetailType).addSuppressed(ex);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (lastStep != null && BidStepEnum.BidBustalk.getIndex() != lastStep.getIndex()) {
            ThreadPools.executeOnce((String)"ThreadForTest", () -> {
                try {
                    Thread.sleep(3000L);
                    this.sendMessage(bidProject);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        String bidappid = this.getAppId(bidProject);
        ArrayList<DynamicObject> saveToShow = new ArrayList<DynamicObject>();
        boolean enable = SystemParamHelper.getSystemParameter((String)bidappid, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            this.createTenToDeciPurDetailShow(bidPro, saveToShow);
        } else {
            this.createOpenToDeciPurDetailShow(bidPro, saveToShow);
        }
        this.createQueToDeciPurDetailShow(bidPro, saveToShow);
        DynamicObject[] bustalkShow = BusinessDataServiceHelper.load((String)(bidappid + "_decipurdetailshow"), (String)"supplier,datetimefield,inclutaxamount,decline_dec,sectionname", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("quotesource", "=", (Object)"bustalk")});
        ArrayList updateToShow = new ArrayList();
        Arrays.stream(bustalkShow).forEach(o -> updateToShow.add(o));
        saveToShow.forEach(o -> updateToShow.add(o));
        Map<String, List<DynamicObject>> supDataMap = updateToShow.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject("supplier").getString("id") + o.getString("sectionname")));
        for (Map.Entry entry : supDataMap.entrySet()) {
            List value = (List)entry.getValue();
            value.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o2.getDate("datetimefield").compareTo(o1.getDate("datetimefield"));
                }
            });
        }
        int amtPrecision = 0;
        DynamicObject dynamicObject = bidPro.getDynamicObject("currency");
        if (dynamicObject != null) {
            amtPrecision = dynamicObject.getInt("amtprecision");
        }
        Iterator<Map.Entry<String, List<DynamicObject>>> iterator = supDataMap.entrySet().iterator();
        while (true) {
            List<DynamicObject> value;
            if (iterator.hasNext()) {
                Map.Entry<String, List<DynamicObject>> entry = iterator.next();
                value = entry.getValue();
            } else {
                if (saveToShow.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveToShow.toArray(new DynamicObject[0]));
                }
                if (bustalkShow.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])bustalkShow);
                }
                return;
            }
            for (int i = 0; i < value.size() - 1; ++i) {
                DynamicObject dynamicObject2 = value.get(i);
                DynamicObject nextdynamicObject = value.get(i + 1);
                if (nextdynamicObject.getBigDecimal("inclutaxamount").compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal decline = dynamicObject2.getBigDecimal("inclutaxamount").subtract(nextdynamicObject.getBigDecimal("inclutaxamount")).divide(nextdynamicObject.getBigDecimal("inclutaxamount"), amtPrecision, 4);
                    DecimalFormat df = new DecimalFormat("0.00");
                    String declineStr = df.format(decline.multiply(new BigDecimal("100")));
                    declineStr = declineStr.replaceAll("-", "");
                    if (decline.compareTo(BigDecimal.ZERO) > 0) {
                        dynamicObject2.set("decline_dec", (Object)(declineStr + "% \u2191"));
                        continue;
                    }
                    if (decline.compareTo(BigDecimal.ZERO) < 0) {
                        dynamicObject2.set("decline_dec", (Object)(declineStr + "% \u2193"));
                        continue;
                    }
                    dynamicObject2.set("decline_dec", (Object)"0.00%");
                    continue;
                }
                dynamicObject2.set("decline_dec", (Object)"0.00%");
            }
            if (value.size() <= 0) continue;
            DynamicObject dynamicObject3 = value.get(value.size() - 1);
            dynamicObject3.set("decline_dec", (Object)"0.00%");
        }
    }

    public void setRound(DynamicObjectCollection section4Decision, DynamicObject bidProject) {
        String bidappid = this.getAppId(bidProject);
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter secqfilter = new QFilter("tenderstatus", "=", (Object)"TENDERED");
        DynamicObject[] online_bids = BusinessDataServiceHelper.load((String)(tenappid + "_online_bid"), (String)"supplier,rounds,listrounds,sectionentry,sectionname,currentroundflag,fromrebackflag,backbidtype", (QFilter[])new QFilter[]{bidqfilter, secqfilter}, (String)"rounds asc");
        HashMap supRounds = new HashMap();
        for (DynamicObject online_bid : online_bids) {
            DynamicObjectCollection sectionentrys = online_bid.getDynamicObjectCollection("sectionentry");
            String backbidtype = online_bid.getString("backbidtype");
            for (DynamicObject sectionentry : sectionentrys) {
                String sectionname = sectionentry.getString("sectionname");
                boolean currentroundflag = sectionentry.getBoolean("currentroundflag");
                if (!currentroundflag) continue;
                String suppliersectionname = online_bid.getDynamicObject("supplier").getString("id") + sectionname;
                HashMap<String, String> roundsMap = (HashMap<String, String>)supRounds.get(suppliersectionname);
                if (roundsMap == null) {
                    roundsMap = new HashMap<String, String>();
                }
                if ("TECHNICAL".equals(backbidtype)) {
                    roundsMap.put("TECHNICAL", online_bid.getString("listrounds"));
                } else if ("BUSSINESS".equals(backbidtype)) {
                    roundsMap.put("BUSSINESS", online_bid.getString("listrounds"));
                } else if ("TECHANDBUSS".equals(backbidtype)) {
                    roundsMap.put("TECHNICAL", online_bid.getString("listrounds"));
                    roundsMap.put("BUSSINESS", online_bid.getString("listrounds"));
                }
                supRounds.put(suppliersectionname, roundsMap);
            }
        }
        for (DynamicObject section : section4Decision) {
            String sectionname = section.getString("sectionname");
            DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : supplierentrys) {
                String supplierid = supplierentry.getDynamicObject("supplier").getString("id");
                String suppliersection = supplierid + sectionname;
                Map roundsmap = (Map)supRounds.get(suppliersection);
                if (roundsmap == null) continue;
                supplierentry.set("techrounds", roundsmap.get("TECHNICAL"));
                supplierentry.set("bussrounds", roundsmap.get("BUSSINESS"));
            }
        }
    }

    public void createTenToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        String bidappid = this.getAppId(bidProject);
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter quotesourcefilter = new QFilter("quotesource", "=", (Object)"tenonline");
        QFilter backtypeqfilter = new QFilter("backbidtype", "!=", (Object)"TECHNICAL");
        QFilter secqfilter = new QFilter("sectionstatus", "=", (Object)"TENDERED");
        DeleteServiceHelper.delete((String)(bidappid + "_decipurdetailshow"), (QFilter[])new QFilter[]{bidqfilter, quotesourcefilter});
        DynamicObject[] online_bid_details = BusinessDataServiceHelper.load((String)(tenappid + "_online_bid_detail"), (String)"onlinebidid,tenderprice,pricevat,tax,notaxtenderprice,sectionname", (QFilter[])new QFilter[]{bidqfilter, backtypeqfilter, secqfilter});
        DynamicObject[] online_bids = BusinessDataServiceHelper.load((String)(tenappid + "_online_bid"), (String)"biddate,supplier,rounds,listrounds,sectionentry,sectionname,currentroundflag,fromrebackflag,modifytime", (QFilter[])bidqfilter.toArray());
        HashMap iddetailmap = new HashMap(online_bid_details.length);
        Arrays.stream(online_bid_details).forEach(o -> iddetailmap.put((Long)o.getPkValue(), o.getLong("onlinebidid")));
        HashMap idbidsup = new HashMap(online_bids.length);
        Arrays.stream(online_bids).forEach(o -> idbidsup.put((Long)o.getPkValue(), o));
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(bidappid + "_decipurdetailshow"));
        for (int i = 0; i < online_bid_details.length; ++i) {
            DynamicObject online_bid_detail = online_bid_details[i];
            Long onlineId = (Long)iddetailmap.get(online_bid_detail.getPkValue());
            DynamicObject online_bid = (DynamicObject)idbidsup.get(onlineId);
            if (online_bid == null) continue;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
            dynamicObject.set("currency", bidProject.get("currency"));
            dynamicObject.set("inclutaxamount", online_bid_detail.get("tenderprice"));
            dynamicObject.set("taxrate", (Object)online_bid_detail.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
            dynamicObject.set("taxamount", online_bid_detail.get("tax"));
            dynamicObject.set("excepttaxamount", online_bid_detail.get("notaxtenderprice"));
            dynamicObject.set("quotesource", (Object)"tenonline");
            String sectionname = online_bid_detail.getString("sectionname");
            DynamicObjectCollection sectionentrys = online_bid.getDynamicObjectCollection("sectionentry");
            for (DynamicObject sectionentry : sectionentrys) {
                String sectionnametry = sectionentry.getString("sectionname");
                boolean currentroundflag = sectionentry.getBoolean("currentroundflag");
                if (!currentroundflag || !sectionname.equals(sectionnametry)) continue;
                dynamicObject.set("datetimefield", online_bid.get("biddate"));
                if (online_bid.get("biddate") == null) {
                    dynamicObject.set("datetimefield", online_bid.get("modifytime"));
                }
                dynamicObject.set("supplier", online_bid.get("supplier"));
                dynamicObject.set("sectionname", online_bid_detail.get("sectionname"));
                dynamicObject.set("bidproject", (Object)bidProject);
                dynamicObject.set("sourceid", (Object)online_bid_detail.getPkValue().toString());
                dynamicObject.set("entitytype", (Object)tenappid);
                dynamicObject.set("rounds", online_bid.get("rounds"));
                dynamicObject.set("listrounds", online_bid.get("listrounds"));
                saveToShow.add(dynamicObject);
            }
        }
    }

    public void createQueToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        String bidappid = this.getAppId(bidProject);
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter quotesourcefilter = new QFilter("quotesource", "=", (Object)"questionclarify");
        QFilter resubmisstenders = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter replystatus = new QFilter("replystatus", "=", (Object)"C");
        QFilter clarifytype = new QFilter("clarifytype", "!=", (Object)"TECHNICAL");
        DeleteServiceHelper.delete((String)(bidappid + "_decipurdetailshow"), (QFilter[])new QFilter[]{bidqfilter, quotesourcefilter});
        DynamicObject[] questionclarifys = BusinessDataServiceHelper.load((String)(tenappid + "_questionclarify"), (String)"tenderprice,pricevat,tax,notaxtenderprice,submitdate,bidsection,sectionname,supplierdetail,pursupplier,modifytime", (QFilter[])new QFilter[]{bidqfilter, resubmisstenders, replystatus, clarifytype});
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(bidappid + "_decipurdetailshow"));
        for (int i = 0; i < questionclarifys.length; ++i) {
            DynamicObject bidsection;
            DynamicObjectCollection supplierdetail;
            DynamicObject questionclarify = questionclarifys[i];
            DynamicObjectCollection bidsections = questionclarify.getDynamicObjectCollection("bidsection");
            if (bidsections.size() <= 0) continue;
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
            dynamicObject.set("currency", bidProject.get("currency"));
            dynamicObject.set("inclutaxamount", questionclarify.get("tenderprice"));
            dynamicObject.set("taxrate", (Object)questionclarify.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
            dynamicObject.set("taxamount", questionclarify.get("tax"));
            dynamicObject.set("excepttaxamount", questionclarify.get("notaxtenderprice"));
            dynamicObject.set("quotesource", (Object)"questionclarify");
            dynamicObject.set("datetimefield", questionclarify.get("submitdate"));
            if (questionclarify.get("submitdate") == null) {
                dynamicObject.set("datetimefield", questionclarify.get("modifytime"));
            }
            if ((supplierdetail = (bidsection = (DynamicObject)bidsections.get(0)).getDynamicObjectCollection("supplierdetail")).size() > 0) {
                dynamicObject.set("supplier", ((DynamicObject)supplierdetail.get(0)).get("pursupplier"));
            }
            dynamicObject.set("sectionname", bidsection.get("sectionname"));
            dynamicObject.set("bidproject", (Object)bidProject);
            dynamicObject.set("sourceid", (Object)questionclarify.getPkValue().toString());
            dynamicObject.set("entitytype", (Object)tenappid);
            saveToShow.add(dynamicObject);
        }
    }

    public void createOpenToDeciPurDetailShow(DynamicObject bidProject, List<DynamicObject> saveToShow) {
        String bidappid = this.getAppId(bidProject);
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter quotesourcefilter = new QFilter("quotesource", "=", (Object)"tenonline");
        DeleteServiceHelper.delete((String)(bidappid + "_decipurdetailshow"), (QFilter[])new QFilter[]{bidqfilter, quotesourcefilter});
        DynamicObject bidPro = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)this.getFormIdByProject(bidappid));
        boolean isBidOpen = bidPro.getBoolean("bidopen");
        boolean isEvaluation = bidPro.getBoolean("bidevaluation");
        Object id = bidPro.getPkValue();
        QFilter[] fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal()))};
        if (isBidOpen) {
            if (isEvaluation) {
                if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidPro.getString("bidopentype"))) {
                    fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal())).and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()))};
                } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidPro.getString("bidopentype"))) {
                    fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal())).and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()))};
                }
            } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidPro.getString("bidopentype"))) {
                fs = new QFilter[]{new QFilter("bidProject", "=", id), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()), new QFilter("billstatus", "=", (Object)"O")};
            } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidPro.getString("bidopentype"))) {
                fs = new QFilter[]{new QFilter("bidProject", "=", id), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()), new QFilter("billstatus", "=", (Object)"O")};
            }
            DynamicObject d = BusinessDataServiceHelper.loadSingle((String)(bidappid + "_bidopen"), (String)"id", (QFilter[])fs);
            Object oid = d.getPkValue();
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)oid, (String)(bidappid + "_bidopen"));
            DynamicObjectCollection bidsections = dObj.getDynamicObjectCollection("bidsection");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(bidappid + "_decipurdetailshow"));
            for (DynamicObject bidsection : bidsections) {
                String bidsectionName = bidsection.getString("sectionname");
                DynamicObjectCollection supplierentrys = bidsection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierentry : supplierentrys) {
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
                    dynamicObject.set("currency", bidProject.get("currency"));
                    dynamicObject.set("inclutaxamount", supplierentry.get("supplier_tenderprice"));
                    dynamicObject.set("taxrate", (Object)supplierentry.getBigDecimal("supplier_taxrate").multiply(new BigDecimal("100")));
                    dynamicObject.set("taxamount", supplierentry.get("supplier_pricevat"));
                    dynamicObject.set("excepttaxamount", supplierentry.get("supplier_exceptvat"));
                    dynamicObject.set("quotesource", (Object)"open");
                    dynamicObject.set("datetimefield", dObj.get("auditdate"));
                    dynamicObject.set("supplier", supplierentry.get("supplier"));
                    dynamicObject.set("sectionname", (Object)bidsectionName);
                    dynamicObject.set("bidproject", (Object)bidProject);
                    dynamicObject.set("sourceid", (Object)oid.toString());
                    dynamicObject.set("entitytype", (Object)bidappid);
                    saveToShow.add(dynamicObject);
                }
            }
        }
    }

    public String getAppId(DynamicObject bidProject) {
        String appId = "bid";
        if (!bidProject.getDataEntityType().getProperties().containsKey((Object)"entitytypeid")) {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        }
        String typeId = bidProject.getString("entitytypeid");
        int index = -1;
        int s = 95;
        if (typeId != null && (index = typeId.indexOf(s)) != -1) {
            appId = typeId.substring(0, index);
        }
        return appId;
    }

    public String getFormIdByProject(String appId) {
        return "bid".equals(appId) ? "bid_project" : "rebm_project";
    }

    public String getFormIdBySupplierinvitation(String appId) {
        return "bid".equals(appId) ? "bid_supplierinvitation" : "rebm_supplierinvitation";
    }

    public String getFormIdByBidpublish(String appId) {
        return "bid".equals(appId) ? "bid_bidpublish" : "rebm_bidpublish";
    }

    public String getFormIdByBidopen(String appId) {
        return "bid".equals(appId) ? "bid_bidopen" : "rebm_bidopen";
    }

    public String getFormIdByDecision(String appId) {
        return "bid".equals(appId) ? "bid_decision" : "rebm_decision";
    }

    public void rangeSupplierDetail(DynamicObjectCollection section4Decision) {
        if (section4Decision == null) {
            return;
        }
        for (DynamicObject section : section4Decision) {
            DynamicObjectCollection supDetails = section.getDynamicObjectCollection("supplierentry");
            if (supDetails == null) continue;
            List finalPriceSet = supDetails.stream().map(se -> se.getBigDecimal("finalexceptvat")).filter(fp -> fp.compareTo(BigDecimal.ZERO) != 0).map(BigDecimal::doubleValue).distinct().sorted((p1, p2) -> p1.compareTo((Double)p2)).collect(Collectors.toList());
            int size = supDetails.size();
            int seq = 0;
            for (int i = 0; i < size; ++i) {
                int index;
                DynamicObject supDetail = (DynamicObject)supDetails.get(i);
                BigDecimal p = supDetail.getBigDecimal("finalexceptvat");
                if (p == null) {
                    p = BigDecimal.ZERO;
                }
                if ((index = finalPriceSet.indexOf(p.doubleValue())) != -1) {
                    supDetail.set("range", (Object)(index + 1));
                } else {
                    supDetail.set("range", (Object)(finalPriceSet.size() + 1));
                }
                supDetail.set("seq", (Object)seq);
                ++seq;
            }
        }
    }

    private void rangeSupplierDetailByScore(DynamicObjectCollection section4Decision, DynamicObject decide) {
        if (section4Decision == null) {
            return;
        }
        for (DynamicObject section : section4Decision) {
            DynamicObject entry;
            Integer value;
            String key;
            DynamicObject supDetail;
            String id1;
            DynamicObject supplier1;
            DynamicObject se;
            int i;
            HashMap<String, Integer> sortMap;
            DynamicObjectCollection supDetails = section.getDynamicObjectCollection("supplierentry");
            if (supDetails == null) continue;
            List scoreList = supDetails.stream().collect(Collectors.toList());
            Long typeId = decide.getLong("id");
            if (typeId.equals(500440734785081344L) || typeId.equals(493255229064684544L)) {
                scoreList.sort(new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        BigDecimal aver4;
                        BigDecimal aver3 = o1.getBigDecimal("finalprice");
                        if (aver3.compareTo(aver4 = o2.getBigDecimal("finalprice")) == 0) {
                            String id2;
                            DynamicObject supplier1 = (DynamicObject)o1.get("supplier");
                            DynamicObject supplier2 = (DynamicObject)o2.get("supplier");
                            String id1 = supplier1.getString("id");
                            return id1.compareTo(id2 = supplier2.getString("id")) > 0 ? 1 : -1;
                        }
                        return aver3.compareTo(aver4) > 0 ? 1 : -1;
                    }
                });
                sortMap = new HashMap<String, Integer>(16);
                for (i = 0; i < scoreList.size(); ++i) {
                    se = (DynamicObject)scoreList.get(i);
                    supplier1 = (DynamicObject)se.get("supplier");
                    id1 = supplier1.getString("id");
                    sortMap.put(se.getString("finalprice") + id1, i + 1);
                }
                for (i = 0; i < supDetails.size(); ++i) {
                    supDetail = (DynamicObject)supDetails.get(i);
                    supplier1 = (DynamicObject)supDetail.get("supplier");
                    id1 = supplier1.getString("id");
                    key = supDetail.getString("finalprice") + id1;
                    value = (Integer)sortMap.get(key);
                    if (value == null) continue;
                    supDetail.set("range", (Object)value);
                }
                scoreList = supDetails.stream().collect(Collectors.toList());
                scoreList.sort(new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        int aver2;
                        int aver1 = o1.getInt("range");
                        return aver1 - (aver2 = o2.getInt("range")) > 0 ? 1 : -1;
                    }
                });
                supDetails.clear();
                for (i = 0; i < scoreList.size(); ++i) {
                    entry = supDetails.addNew();
                    this.copy((DynamicObject)scoreList.get(i), entry, i);
                }
                for (i = 0; i < supDetails.size(); ++i) {
                    supDetail = (DynamicObject)supDetails.get(i);
                    supDetail.set("range", (Object)0);
                    supplier1 = (DynamicObject)supDetail.get("supplier");
                    id1 = supplier1.getString("id");
                    key = supDetail.getString("finalprice") + id1;
                    value = (Integer)sortMap.get(key);
                    if (value == null) continue;
                    supDetail.set("range", (Object)value);
                }
                continue;
            }
            scoreList.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    BigDecimal aver2;
                    BigDecimal aver1 = o1.getBigDecimal("score");
                    return aver1.compareTo(aver2 = o2.getBigDecimal("score")) < 0 ? 1 : -1;
                }
            });
            scoreList.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    BigDecimal aver2;
                    BigDecimal aver1 = o1.getBigDecimal("score");
                    if (aver1.compareTo(aver2 = o2.getBigDecimal("score")) == 0) {
                        BigDecimal aver4;
                        BigDecimal aver3 = o1.getBigDecimal("finalprice");
                        if (aver3.compareTo(aver4 = o2.getBigDecimal("finalprice")) == 0) {
                            String id2;
                            DynamicObject supplier1 = (DynamicObject)o1.get("supplier");
                            DynamicObject supplier2 = (DynamicObject)o2.get("supplier");
                            String id1 = supplier1.getString("id");
                            return id1.compareTo(id2 = supplier2.getString("id")) > 0 ? 1 : -1;
                        }
                        return aver3.compareTo(aver4) > 0 ? 1 : -1;
                    }
                    return 0;
                }
            });
            sortMap = new HashMap(16);
            for (i = 0; i < scoreList.size(); ++i) {
                se = (DynamicObject)scoreList.get(i);
                StringBuilder builder = new StringBuilder();
                DynamicObject supplier12 = (DynamicObject)se.get("supplier");
                String id12 = supplier12.getString("id");
                builder.append(se.getString("score")).append(se.getString("finalprice")).append(id12);
                sortMap.put(builder.toString(), i + 1);
            }
            for (i = 0; i < supDetails.size(); ++i) {
                supDetail = (DynamicObject)supDetails.get(i);
                supplier1 = (DynamicObject)supDetail.get("supplier");
                id1 = supplier1.getString("id");
                key = supDetail.getString("score") + supDetail.getString("finalprice") + id1;
                value = (Integer)sortMap.get(key);
                if (value == null) continue;
                supDetail.set("range", (Object)value);
            }
            scoreList = supDetails.stream().collect(Collectors.toList());
            scoreList.sort(new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int aver2;
                    int aver1 = o1.getInt("range");
                    return aver1 - (aver2 = o2.getInt("range")) > 0 ? 1 : -1;
                }
            });
            supDetails.clear();
            for (i = 0; i < scoreList.size(); ++i) {
                entry = supDetails.addNew();
                this.copy((DynamicObject)scoreList.get(i), entry, i);
            }
            for (i = 0; i < supDetails.size(); ++i) {
                supDetail = (DynamicObject)supDetails.get(i);
                supDetail.set("range", (Object)0);
                supplier1 = (DynamicObject)supDetail.get("supplier");
                id1 = supplier1.getString("id");
                key = supDetail.getString("score") + supDetail.getString("finalprice") + id1;
                value = (Integer)sortMap.get(key);
                if (value == null) continue;
                supDetail.set("range", (Object)value);
            }
        }
    }

    protected void copy(DynamicObject item, DynamicObject entry, int i) {
        entry.set("seq", (Object)(i + 1));
        entry.set("id", item.get("id"));
        entry.set("supplier", item.get("supplier"));
        entry.set("score", item.get("score"));
        entry.set("range", item.get("range"));
        entry.set("winorder", item.get("winorder"));
        entry.set("isrecommended", item.get("isrecommended"));
        entry.set("finalprice", item.get("finalprice"));
        entry.set("finaltaxrate", item.get("finaltaxrate"));
        entry.set("finalvat", item.get("finalvat"));
        entry.set("finalexceptvat", item.get("finalexceptvat"));
        entry.set("tenderprice", item.get("tenderprice"));
        entry.set("tendertaxrate", item.get("tendertaxrate"));
        entry.set("tendervat", item.get("tendervat"));
        entry.set("tenderexceptvat", item.get("tenderexceptvat"));
        entry.set("finalrate", item.get("finalrate"));
        entry.set("rate", item.get("rate"));
        DynamicObjectCollection techfile_new = item.getDynamicObjectCollection("techfile_new");
        DynamicObjectCollection commfile_new = item.getDynamicObjectCollection("commfile_new");
        DynamicObjectCollection techfile_new_entry = entry.getDynamicObjectCollection("techfile_new");
        DynamicObjectCollection commfile_new_entry = entry.getDynamicObjectCollection("commfile_new");
        techfile_new.forEach(attachment -> techfile_new_entry.addNew().set("fbasedataid", attachment.get("fbasedataid")));
        commfile_new.forEach(attachment -> commfile_new_entry.addNew().set("fbasedataid", attachment.get("fbasedataid")));
        entry.set("commentdetail", item.get("commentdetail"));
        entry.set("comment", item.get("comment"));
        entry.set("techrounds", item.get("techrounds"));
        entry.set("bussrounds", item.get("bussrounds"));
    }

    private void sumFinalPrice(DynamicObject obj) {
        DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
        if (sections == null) {
            return;
        }
        BigDecimal sumPrice = sections.stream().flatMap(section -> section.getDynamicObjectCollection("supplierentry").stream()).filter(supEntry -> supEntry.getBoolean("isrecommended")).map(supEntry -> {
            BigDecimal price = supEntry.getBigDecimal("finalprice");
            if (price == null) {
                price = BigDecimal.ZERO;
            }
            return price;
        }).reduce(BigDecimal.ZERO, (b1, b2) -> b1.add((BigDecimal)b2));
        if (sumPrice != null) {
            obj.set("amount", (Object)sumPrice);
        }
    }

    private Map<String, BigDecimal> getEvaluationScores(DynamicObject bidProject) {
        Map<String, BigDecimal> evaluationScores = null;
        DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id,auditdate", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"C")}, (String)"auditdate desc");
        String selectProperties = "id,bidevaluation,supplier.id,section.sectionname,score";
        QFilter[] filters = new QFilter[]{new QFilter("bidevaluation", "=", bidEvaluations[0].getPkValue())};
        String bidProjectEntityTypeId = bidProject.getString("entitytypeid");
        String bidevaluationentry = "";
        bidevaluationentry = "bid_project".equals(bidProjectEntityTypeId) ? "bid_bidevaluationentry" : "rebm_bidevaluationentry";
        DynamicObject[] bidEvaluationEntries = BusinessDataServiceHelper.load((String)bidevaluationentry, (String)selectProperties, (QFilter[])filters);
        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5b9a\u6807\u5355\u5206\u6570\u751f\u6210\uff1a%1$s\uff0c%2$s\u3002", (String)"BidDecisionServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getPkValue(), bidProjectEntityTypeId));
        if (bidEvaluationEntries != null) {
            DynamicObject bidEvaluationEntry = bidEvaluationEntries[0];
            evaluationScores = Arrays.stream(bidEvaluationEntries).collect(Collectors.toMap(entry1 -> entry1.getString("supplier.id") + entry1.getString("section.sectionname"), entry2 -> entry2.getBigDecimal("score"), (value1, value2) -> value1.compareTo((BigDecimal)value2) > 0 ? value1 : value2));
        }
        return evaluationScores;
    }

    private Map<String, Map<String, BigDecimal>> getEvaluationClarifyPrice(DynamicObject evaluation) {
        HashMap<String, Map<String, BigDecimal>> ClarifyPrice = new HashMap<String, Map<String, BigDecimal>>();
        String selectProperties = "id,bidevaluation";
        QFilter[] filters = new QFilter[]{new QFilter("bidevaluation", "=", evaluation.getPkValue())};
        DynamicObject bidClarify = QueryServiceHelper.queryOne((String)"bid_priceclarify", (String)selectProperties, (QFilter[])filters);
        if (bidClarify != null) {
            DynamicObjectCollection sections = (bidClarify = BusinessDataServiceHelper.loadSingle((Object)bidClarify.getString("id"), (String)"bid_priceclarify")).getDynamicObjectCollection("bidsection");
            if (sections == null) {
                return null;
            }
            for (DynamicObject section : sections) {
                String secName = section.getString("sectionname");
                DynamicObjectCollection priceDetails = section.getDynamicObjectCollection("bid_pricclarsuppdetail");
                if (priceDetails == null) continue;
                for (DynamicObject priceDetail : priceDetails) {
                    DynamicObject supplier;
                    if (!priceDetail.getBoolean("isclarify") || (supplier = priceDetail.getDynamicObject("supplier")) == null) continue;
                    String supplierId = supplier.getString("id");
                    HashMap<String, BigDecimal> prices = new HashMap<String, BigDecimal>();
                    prices.put("clarifyprice", priceDetail.getBigDecimal("clarifyprice"));
                    prices.put("clarifypricevat", priceDetail.getBigDecimal("clarifypricevat"));
                    prices.put("exctaxclarifyprice", priceDetail.getBigDecimal("exctaxclarifyprice"));
                    prices.put("rate", priceDetail.getBigDecimal("rate"));
                    ClarifyPrice.put(supplierId + secName, prices);
                }
            }
        }
        return ClarifyPrice;
    }

    private Function<? super DynamicObject, ? extends DynamicObject> generateSupplierDetail(EntityType supType, boolean isBidOpen, Object sectionId, ORM orm, Map<String, BigDecimal> evaluationScores, String sectionname, boolean isBidEvaluation, Map<String, Map<String, BigDecimal>> clarifyPrices, String appId) {
        return supplier -> {
            DynamicObject sup = new DynamicObject((DynamicObjectType)supType);
            DynamicObject s = supplier.getDynamicObject("supplier");
            sup.set("supplier", (Object)s);
            Long id = orm.genLongId((IDataEntityType)supType);
            sup.set("id", (Object)id);
            if (isBidOpen) {
                sup.set("tenderprice", supplier.get("supplier_tenderprice"));
                sup.set("tendervat", supplier.get("supplier_pricevat"));
                sup.set("tenderexceptvat", supplier.get("supplier_exceptvat"));
                sup.set("tendertaxrate", supplier.get("supplier_taxrate"));
                sup.set("rate", supplier.get("supplier_rate"));
                sup.set("comment", supplier.get("supplier_illustration"));
                sup.set("finalprice", supplier.get("supplier_tenderprice"));
                sup.set("finalexceptvat", supplier.get("supplier_exceptvat"));
                sup.set("finalvat", supplier.get("supplier_pricevat"));
                sup.set("finaltaxrate", supplier.get("supplier_taxrate"));
                sup.set("finalrate", supplier.get("supplier_rate"));
                sup.set("isfromproject", (Object)"1");
                DynamicObjectCollection supplier_techattach = supplier.getDynamicObjectCollection("supplier_techattach");
                DynamicObjectCollection supplier_comattach = supplier.getDynamicObjectCollection("supplier_comattach");
                DynamicObjectCollection techfile = sup.getDynamicObjectCollection("techfile_new");
                DynamicObjectCollection commfile = sup.getDynamicObjectCollection("commfile_new");
                if (supplier_techattach.size() > 0) {
                    supplier_techattach.forEach(attachment -> techfile.addNew().set("fbasedataid", attachment.get("fbasedataid")));
                }
                if (supplier_comattach.size() > 0) {
                    supplier_comattach.forEach(attachment -> commfile.addNew().set("fbasedataid", attachment.get("fbasedataid")));
                }
            }
            if (isBidEvaluation && s != null) {
                Map cp;
                String key = s.getString("id") + sectionname;
                if (evaluationScores != null) {
                    BigDecimal score = (BigDecimal)evaluationScores.get(key);
                    if (score == null) {
                        score = BigDecimal.ZERO;
                    }
                    sup.set("score", (Object)score);
                }
                if (clarifyPrices != null && (cp = (Map)clarifyPrices.get(key)) != null) {
                    sup.set("finalrate", cp.get("rate"));
                    sup.set("finalprice", cp.get("clarifyprice"));
                    sup.set("finalexceptvat", cp.get("exctaxclarifyprice"));
                    sup.set("finalvat", cp.get("clarifypricevat"));
                }
            }
            return sup;
        };
    }

    private DynamicObject getEvaluateDecideWay(DynamicObject bidPro) {
        boolean isBidDocument = bidPro.getBoolean("biddocument");
        boolean isBidPublish = bidPro.getBoolean("bidpublish");
        boolean isBidOpen = bidPro.getBoolean("bidopen");
        String selectors = "id,evaluatedecideway";
        boolean[] statusArr = new boolean[]{isBidOpen, isBidPublish, isBidDocument};
        BillStatusEnum[] status = new BillStatusEnum[]{BillStatusEnum.OPEN, BillStatusEnum.PUBLISHED, BillStatusEnum.AUDITED};
        DynamicObject dObj = null;
        String[] entitys = BID_ENTITY;
        if ("rebm".equals(bidPro.getString("entitytypeid").split("_")[0])) {
            entitys = REBM_ENTITY;
        }
        for (int i = 0; i < statusArr.length; ++i) {
            if (!statusArr[i]) continue;
            QFilter[] fs = new QFilter[]{new QFilter("bidProject", "=", bidPro.getPkValue()).and(new QFilter("billstatus", "=", (Object)status[i].getVal()))};
            dObj = BusinessDataServiceHelper.loadSingle((String)entitys[i], (String)selectors, (QFilter[])fs);
            break;
        }
        DynamicObject way = null;
        if (dObj != null) {
            way = dObj.getDynamicObject("evaluatedecideway");
        }
        if (way == null) {
            DynamicObject bidProjectLoadData = BusinessDataServiceHelper.loadSingle((Object)bidPro.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()), (String)"evaluatedecideway");
            way = bidProjectLoadData.getDynamicObject("evaluatedecideway");
        }
        return way;
    }

    private DynamicObject getLastStepDynamicObject(DynamicObject bidPro) {
        boolean isBidProject = bidPro.getBoolean("bidproject");
        boolean isSupplierInvitation = bidPro.getBoolean("supplierinvitation");
        boolean isBidPublish = bidPro.getBoolean("bidpublish");
        boolean isBidOpen = bidPro.getBoolean("bidopen");
        boolean isEvaluation = bidPro.getBoolean("bidevaluation");
        Object id = bidPro.getPkValue();
        DynamicObject dObj = null;
        boolean[] statusArr = new boolean[]{isBidOpen, isBidPublish, isSupplierInvitation, isBidProject};
        String[] entityTypes = BID_ENTITY_1;
        if ("rebm".equals(bidPro.getString("entitytypeid").split("_")[0])) {
            entityTypes = REBM_ENTITY_1;
        }
        String[] billStatus = new String[]{BillStatusEnum.OPEN.getVal(), BillStatusEnum.PUBLISHED.getVal(), BillStatusEnum.AUDITED.getVal(), BillStatusEnum.AUDITED.getVal()};
        Object oid = null;
        for (int i = 0; i < statusArr.length; ++i) {
            if (!statusArr[i]) continue;
            if (i != 3) {
                QFilter[] fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)billStatus[i]))};
                if (i == 0) {
                    if (isEvaluation) {
                        if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidPro.getString("bidopentype"))) {
                            fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)billStatus[i])).and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()))};
                        } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidPro.getString("bidopentype"))) {
                            fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)billStatus[i])).and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()))};
                        }
                    } else if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidPro.getString("bidopentype"))) {
                        fs = new QFilter[]{new QFilter("bidProject", "=", id), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()), new QFilter("billstatus", "=", (Object)"O")};
                    } else if (BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidPro.getString("bidopentype"))) {
                        fs = new QFilter[]{new QFilter("bidProject", "=", id), new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()), new QFilter("billstatus", "=", (Object)"O")};
                    }
                }
                DynamicObject d = BusinessDataServiceHelper.loadSingle((String)entityTypes[i], (String)"id", (QFilter[])fs);
                if (i == 1 && d == null) {
                    fs = new QFilter[]{new QFilter("bidProject", "=", id).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.ADJUSTING.getVal()))};
                    d = BusinessDataServiceHelper.loadSingle((String)entityTypes[i], (String)"id", (QFilter[])fs);
                }
                if (d == null) continue;
                oid = d.getPkValue();
                dObj = BusinessDataServiceHelper.loadSingle((Object)oid, (String)entityTypes[i]);
                break;
            }
            oid = id;
            dObj = BusinessDataServiceHelper.loadSingle((Object)oid, (String)entityTypes[i]);
        }
        return dObj;
    }

    @Override
    public DynamicObject getAttachmentFileObject(Object detailId) {
        return BusinessDataServiceHelper.loadSingle((String)"bid_decisionentryfile", (String)"id", (QFilter[])new QFilter[]{new QFilter("detailid", "=", detailId)});
    }

    @Override
    public Object getBidProjectId(Object id) {
        DynamicObject bidPro;
        DynamicObject decisionObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_decision", (String)"id,bidproject");
        if (decisionObj != null && (bidPro = decisionObj.getDynamicObject("bidproject")) != null) {
            return bidPro.getPkValue();
        }
        return null;
    }

    @Override
    public Object getBidEvaluationId(Object proId) {
        DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", proId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()))});
        if (bidEvaluation != null) {
            return bidEvaluation.getPkValue();
        }
        return null;
    }

    @Override
    public boolean checkBidDocFinished(Object id) {
        Object proId;
        DynamicObject pro;
        boolean isbiddocument;
        DynamicObject bidPro;
        boolean flag = true;
        boolean exists = ORM.create().exists("bid_decision", new QFilter[]{new QFilter("id", "=", id)});
        if (!exists) {
            return flag;
        }
        DynamicObject decisionObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_decision", (String)"id,bidproject");
        if (decisionObj != null && (bidPro = decisionObj.getDynamicObject("bidproject")) != null && (isbiddocument = (pro = BusinessDataServiceHelper.loadSingle((Object)(proId = bidPro.getPkValue()), (String)"bid_project", (String)"id,biddocument")).getBoolean("biddocument"))) {
            DynamicObject[] bidDocArr;
            for (DynamicObject bidDoc : bidDocArr = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", proId)})) {
                if (BillStatusEnum.AUDITED.getVal().equals(bidDoc.getString("billstatus")) || BillStatusEnum.INVALID.getVal().equals(bidDoc.getString("billstatus")) || BillStatusEnum.INVALIDXX.getVal().equals(bidDoc.getString("billstatus"))) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    @Override
    @SdkDeprecated
    public DynamicObject getBidDecisionByProjectId(Long projectId, String selectedFields) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        return BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)selectedFields, (QFilter[])new QFilter[]{qFilter, statusFilter});
    }

    @Override
    public String getFormId() {
        return "bid_decision";
    }

    @Override
    public void saveBillStatus(Object id, BillStatusEnum status) {
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_decision", (String)"id,billstatus");
        bidDecision.set("billstatus", (Object)status.getVal());
        BusinessDataServiceHelper.save((IDataEntityType)bidDecision.getDataEntityType(), (Object[])new DynamicObject[]{bidDecision});
    }

    @Override
    public DynamicObject getBidDecisionSingle(Long id) {
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_decision", (String)"id,entitytypeid");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getFormId());
        if (tempObj != null && "rebm".equals(tempObj.getString("entitytypeid").split("_")[0])) {
            type = EntityMetadataCache.getDataEntityType((String)"rebm_decision");
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public void insertRecommendStatisticaddOne(Map<Long, Integer> dataMap, String formId) {
        SupplierStatisticServiceImpl statisticService = new SupplierStatisticServiceImpl();
        statisticService.insertSupplierWonQty(dataMap, formId);
    }

    @Override
    public void insertRecommendStatisticSubOne(Map<Long, Integer> dataMap, String formId) {
        SupplierStatisticServiceImpl statisticService = new SupplierStatisticServiceImpl();
        statisticService.insertSupplierWonQty(dataMap, formId);
    }

    @Override
    public void invalidBidDecision(Long projectId, String formId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId).and(new QFilter("billstatus", "!=", (Object)"X")).and(new QFilter("billstatus", "in", (Object)BillStatusEnum.AUDITED.getVal()));
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj == null) {
            return;
        }
        obj = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"bid_decision");
        HashMap<Long, Integer> dataMap = new HashMap<Long, Integer>();
        DynamicObjectCollection sections = obj.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
            for (int i = 0; i < supplierEntrys.size(); ++i) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntrys.get(i);
                Boolean isRecommended = supplierEntry.getBoolean("isrecommended");
                if (!isRecommended.booleanValue()) continue;
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                Long supplierId = supplier.getLong("id");
                Integer num = -1;
                Integer temp = (Integer)dataMap.get(supplierId);
                if (temp != null) {
                    num = num + (Integer)dataMap.get(supplierId);
                }
                dataMap.put(supplierId, num);
            }
        }
        this.insertRecommendStatisticSubOne(dataMap, formId);
    }

    @Override
    public void saveIsSignagreementStatus(Object id) {
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_decision");
        if (bidDecision == null) {
            return;
        }
        DynamicObjectCollection sections = bidDecision.getDynamicObjectCollection("bidsection");
        if (sections != null) {
            for (DynamicObject section : sections) {
                section.set("signstatus", (Object)BidDecisionSectionStatusEnum.SIGNED.getVal());
                DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
                if (supplierEntrys == null) continue;
                for (DynamicObject supplierEntry : supplierEntrys) {
                    boolean isrecommended = supplierEntry.getBoolean("isrecommended");
                    if (!isrecommended) continue;
                    supplierEntry.set("issignagreement", (Object)"1");
                }
            }
            BusinessDataServiceHelper.save((IDataEntityType)bidDecision.getDataEntityType(), (Object[])new DynamicObject[]{bidDecision});
        }
    }

    @Override
    public DynamicObject getBidDecisionById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_decision");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    public void sendMessage(DynamicObject bidProjectF7) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((String)this.getFormIdByDecision(appid), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX"), new QFilter("billstatus", "!=", (Object)"X")});
        if (bidDecision != null) {
            String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidDecisionServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("tplScene", "createbiddeci");
            if ("bid".equals(appid)) {
                msgParam.put("formId", "bid_decision");
            } else {
                msgParam.put("formId", "rebm_decision");
            }
            msgParam.put("appId", appid);
            msgParam.put("id", bidDecision.getPkValue());
            msgParam.put("pkId", bidDecision.getPkValue());
            msgParam.put("title", null);
            msgParam.put("operation", "save");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
            DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
            HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            for (DynamicObject member : memberColl) {
                String[] values;
                if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
                for (int m = 0; m < values.length; ++m) {
                    if (!"08".equals(values[m])) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!memberSet.isEmpty()) {
                for (DynamicObject set : memberSet) {
                    receiveUserIds.add(set.getLong("id"));
                }
            }
            msgParam.put("msgentity", "bid_decision");
            String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u5b9a\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidDecisionServiceImpl_8", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            msgParam.put("content", null);
            String notifyType = MessageChannelUtil.getNotifyType((String)"createbiddeci", (String)"bid_decision");
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
        }
    }
}

