/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidPublishService;
import kd.scm.bid.business.bill.other.PublicAndPartnerDeal;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidPubStrategyEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.sdk.annotation.SdkDeprecated;

public class BidPublishServiceImpl
extends BidServiceImpl
implements IBidPublishService {
    private static final String LISTENTRY_ATTCHMENT = "fbasedataid";
    private static final String EVALUATE_DECIDE_WAY = "evaluatedecideway";
    private static final String APPROACH_DATE = "approachdate";
    private static final String BILL_STATUS = "billstatus";
    private static final String selectSectionString = "bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.tenderstatus,supplierentry.invitationstatus,supplierentry.invalidflag,supplierentry.isnew,supplierentry.projectpartner,supplierentry.suppliersecdeposit,supplierentry.isrecommend";

    public DynamicObjectType getEntryType(String entryName) {
        MainEntityType mainType = this.createBidPublishType();
        EntityType type = (EntityType)mainType.getAllEntities().get(entryName);
        return type;
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        this.createPublishBill(bidProject, null, lastStep);
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, Map<String, Object> params, BidStepEnum lastStep) {
        this.createPublishBill(bidProject, params, lastStep);
    }

    public void createPublishBill(DynamicObject bidProject, Map<String, Object> params, BidStepEnum lastStep) {
        Serializable serializable;
        Long sourcepublish;
        MainEntityType bidPublishObjectType = EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        String appId = project.getString("entitytypeid").split("_")[0];
        String bidProjectEntityName = "bid_project";
        if ("rebm".equals(appId)) {
            bidPublishObjectType = EntityMetadataCache.getDataEntityType((String)"rebm_bidpublish");
            bidProjectEntityName = "rebm_project";
        }
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)bidProjectEntityName, (String)"id,org,billno,bidopendeadline,biddecisiondate,bidevaluationdate,approachdate,bidpublishdate,answerquestiontime,busbackbidtime,isseparatedoc,bidrollsection,bidrollsection.rollsectionname,bidrollsection.seq,currency,evaluatedecideway,entitytypeid,bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.tenderstatus,supplierentry.invitationstatus,supplierentry.invalidflag,supplierentry.isnew,supplierentry.projectpartner,supplierentry.suppliersecdeposit,supplierentry.isrecommend");
        DynamicObject bidPublish = new DynamicObject((DynamicObjectType)bidPublishObjectType);
        if ("bid".equals(appId)) {
            bidPublish.set("entitytypeid", (Object)"bid_bidpublish");
        } else if ("rebm".equals(appId)) {
            bidPublish.set("entitytypeid", (Object)"rebm_bidpublish");
        }
        bidPublish.set("bidproject", bidProject.getPkValue());
        bidPublish.set("org", bidProject.get("org"));
        bidPublish.set("billno", bidProject.get("billno"));
        bidPublish.set("backbidway", project.get("backbidway"));
        bidPublish.set("bidopentype", project.get("bidopentype"));
        bidPublish.set("currency", bidProject.get("currency"));
        bidPublish.set("sourcepublish", (Object)0L);
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> paramsMap : params.entrySet()) {
                String key = paramsMap.getKey();
                if (key.equals("isAgain")) continue;
                bidPublish.set(key, paramsMap.getValue());
            }
        }
        if ((sourcepublish = Long.valueOf(bidPublish.getLong("sourcepublish"))) != null && sourcepublish.toString().equals("0")) {
            bidPublish.set("publishtimes", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u53d1\u6807", (String)"BidPublishServiceImpl_22", (String)"scm-bid-business", (Object[])new Object[0]), BidPublishServiceImpl.toChinese("1")));
        } else {
            QFilter bidFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            DynamicObject[] historyBidpubs = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"id", (QFilter[])bidFilter.toArray());
            int publishtimes = 0;
            if (historyBidpubs != null) {
                publishtimes = historyBidpubs.length;
            }
            bidPublish.set("publishtimes", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u53d1\u6807", (String)"BidPublishServiceImpl_22", (String)"scm-bid-business", (Object[])new Object[0]), BidPublishServiceImpl.toChinese(publishtimes + 1 + "")));
        }
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
        DynamicObject creator = creatorMap.get("05");
        bidPublish.set("creator", (Object)creator);
        bidPublish.set("createtime", (Object)new Date());
        bidPublish.set(BILL_STATUS, (Object)BillStatusEnum.DISBEGIN.getVal());
        QFilter filter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter billStatusFilter = new QFilter(BILL_STATUS, "=", (Object)BillStatusEnum.AUDITED.getVal());
        DynamicObject bidDocumentEdit = null;
        bidDocumentEdit = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((String)"rebm_biddocument_edit", (String)String.join((CharSequence)",", EVALUATE_DECIDE_WAY, "listentry", "listentry_sectionname", "listentry_listbill", "listentry_resume", "listentry_description"), (QFilter[])new QFilter[]{filter, billStatusFilter}) : BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)EVALUATE_DECIDE_WAY, (QFilter[])new QFilter[]{filter, billStatusFilter});
        DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{filter, billStatusFilter});
        if (supplierInvitation != null) {
            supplierInvitation = "rebm".equals(supplierInvitation.getString("entitytypeid").split("_")[0]) ? BusinessDataServiceHelper.loadSingle((String)"rebm_supplierinvitation", (String)"id,sourcebillid,bidstep,bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.tenderstatus,supplierentry.invitationstatus,supplierentry.invalidflag,supplierentry.isnew,supplierentry.projectpartner,supplierentry.suppliersecdeposit,supplierentry.isrecommend", (QFilter[])new QFilter[]{filter, billStatusFilter}) : BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id,sourcebillid,bidstep,bidmode,bidsection,bidsection.seq,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.suppliercomment,supplierentry.supplierstatistic,supplierentry.tenderstatus,supplierentry.invitationstatus,supplierentry.invalidflag,supplierentry.isnew,supplierentry.projectpartner,supplierentry.suppliersecdeposit,supplierentry.isrecommend", (QFilter[])new QFilter[]{filter, billStatusFilter});
        }
        if (bidDocumentEdit != null) {
            DynamicObject evaluateDecideWay = bidDocumentEdit.getDynamicObject(EVALUATE_DECIDE_WAY);
            if (evaluateDecideWay != null) {
                bidPublish.set(EVALUATE_DECIDE_WAY, (Object)evaluateDecideWay);
            }
        } else {
            DynamicObject eva = bidProject.getDynamicObject(EVALUATE_DECIDE_WAY);
            if (eva != null) {
                bidPublish.set(EVALUATE_DECIDE_WAY, (Object)eva);
            }
        }
        bidPublish.set("source", (Object)"new");
        if (supplierInvitation != null) {
            bidPublish.set("supplierinvitationid", supplierInvitation.getPkValue());
            bidPublish.set("rounds", (Object)0);
            if (this.isAgainSupplierInvitation(supplierInvitation)) {
                DynamicObject hisBidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,billstatus,rounds,isnewbill", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("isnewbill", "=", (Object)Boolean.TRUE)});
                if (hisBidPublish != null) {
                    bidPublish.set("sourcepublish", hisBidPublish.getPkValue());
                    bidPublish.set("sourcebillstatus", (Object)hisBidPublish.getString(BILL_STATUS));
                    bidPublish.set("rounds", (Object)(hisBidPublish.getInt("rounds") + 1));
                    hisBidPublish.set("isnewbill", (Object)Boolean.FALSE);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisBidPublish});
                    Long sourcepublish_new = (Long)bidPublish.get("sourcepublish");
                    String publishtimesStr = ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u53d1\u6807", (String)"BidPublishServiceImpl_22", (String)"scm-bid-business", (Object[])new Object[0]);
                    Integer publishtimes = 0;
                    if (sourcepublish_new != null && sourcepublish_new.toString().equals("0")) {
                        publishtimes = 1;
                    } else {
                        QFilter bidFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
                        DynamicObject[] historyBidpubs = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"id", (QFilter[])bidFilter.toArray());
                        if (historyBidpubs != null) {
                            publishtimes = historyBidpubs.length;
                        }
                        Integer n = publishtimes;
                        publishtimes = publishtimes + 1;
                        serializable = publishtimes;
                    }
                    bidPublish.set("publishtimes", (Object)String.format(publishtimesStr, BidPublishServiceImpl.toChinese(publishtimes + "")));
                }
                bidPublish.set("bidstep", (Object)supplierInvitation.getString("bidstep"));
                bidPublish.set("source", (Object)"resupplierInvitation");
            }
        }
        bidPublish.set("projecttime", (Object)(bidProject.getPkValue().toString() + "" + new Date().getTime()));
        bidPublish.set("isnewbill", (Object)Boolean.TRUE);
        bidPublish.set("bidopendeadline", bidProject.get("bidopendeadline"));
        bidPublish.set("bidevaluationdate", bidProject.get("bidevaluationdate"));
        bidPublish.set("biddecisiondate", bidProject.get("biddecisiondate"));
        bidPublish.set(APPROACH_DATE, bidProject.get(APPROACH_DATE));
        bidPublish.set("planbidpublishdate", bidProject.get("bidpublishdate"));
        bidPublish.set("answerquestiondeadline", bidProject.get("answerquestiontime"));
        bidPublish.set("planbidpublishdate1", bidProject.get("bidpublishdate"));
        bidPublish.set("plananswerquestiontime", bidProject.get("answerquestiontime"));
        bidPublish.set("planbidopendeadline", bidProject.get("bidopendeadline"));
        bidPublish.set("busbackbidtime", bidProject.get("busbackbidtime"));
        bidPublish.set("planbidevaluationdate", bidProject.get("bidevaluationdate"));
        bidPublish.set("planbiddecisiondate", bidProject.get("biddecisiondate"));
        DynamicObjectCollection sections = null;
        DynamicObject bidMode = bidProject.getDynamicObject("bidmode");
        boolean publicBiddingFlag = BidModeHelper.isPublicBiddingByModel((DynamicObject)bidMode);
        boolean supplierInvitationFlag = true;
        if (supplierInvitation != null) {
            sections = supplierInvitation.getDynamicObjectCollection("bidsection");
        } else {
            sections = publicBiddingFlag ? bidProject.getDynamicObjectCollection("bidsection") : bidProject.getDynamicObjectCollection("bidrollsection");
            supplierInvitationFlag = false;
        }
        PublicAndPartnerDeal partnerDeal = new PublicAndPartnerDeal();
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            DynamicObject supplierSection = supplierSectionCol.addNew();
            DynamicObjectCollection projSuppliers = null;
            if (supplierInvitation != null && bidMode != null) {
                supplierSection.set("sectionname", section.get("sectionname"));
                supplierSection.set("seq", section.get("seq"));
                projSuppliers = section.getDynamicObjectCollection("supplierentry");
            } else if (publicBiddingFlag) {
                supplierSection.set("sectionname", section.get("sectionname"));
                supplierSection.set("seq", section.get("seq"));
            } else {
                supplierSection.set("sectionname", section.get("rollsectionname"));
                supplierSection.set("seq", section.get("seq"));
                projSuppliers = section.getDynamicObjectCollection("supplierentry");
            }
            DynamicObjectCollection supplierEntryCol = supplierSection.getDynamicObjectCollection("supplierentry");
            if (projSuppliers != null && projSuppliers.size() > 0) {
                bidPublish.set("needflagnewsupplier", (Object)1);
                int i = 0;
                for (DynamicObject supplier : projSuppliers) {
                    Iterator supplierEntry;
                    DynamicObject sup = supplier.getDynamicObject("supplier");
                    if (bidMode == null || sup == null) continue;
                    if (!publicBiddingFlag && supplierInvitation != null) {
                        if (!supplier.getBoolean("isrecommend")) continue;
                        supplierEntry = supplierEntryCol.addNew();
                        supplierEntry.set("seq", ++i);
                        this.setSupplierEntry(publicBiddingFlag, supplierInvitationFlag, (DynamicObject)supplierEntry, supplier);
                        partnerDeal.dealPartner((DynamicObject)supplierEntry, bidProject, supplier, appId);
                        continue;
                    }
                    supplierEntry = supplierEntryCol.addNew();
                    supplierEntry.set("seq", ++i);
                    this.setSupplierEntry(publicBiddingFlag, supplierInvitationFlag, (DynamicObject)supplierEntry, supplier);
                    partnerDeal.dealPartner((DynamicObject)supplierEntry, bidProject, supplier, appId);
                }
            }
            MainEntityType projectType = EntityMetadataCache.getDataEntityType((String)(appId + "_project"));
            DynamicObject bidProjectData = BusinessDataServiceHelper.loadSingle((Object)bidProject.getString("id"), (DynamicObjectType)projectType);
            DynamicObjectCollection bidSections = bidProjectData.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection projentrys = null;
            for (DynamicObject bidSection : bidSections) {
                if (supplierInvitation != null) {
                    if (!StringUtils.equals((CharSequence)section.getString("sectionname"), (CharSequence)bidSection.getString("sectionname"))) continue;
                    projentrys = bidSection.getDynamicObjectCollection("projectentry");
                    continue;
                }
                if (publicBiddingFlag) {
                    if (!StringUtils.equals((CharSequence)section.getString("sectionname"), (CharSequence)bidSection.getString("sectionname"))) continue;
                    projentrys = bidSection.getDynamicObjectCollection("projectentry");
                    continue;
                }
                if (!StringUtils.equals((CharSequence)section.getString("rollsectionname"), (CharSequence)bidSection.getString("sectionname"))) continue;
                projentrys = bidSection.getDynamicObjectCollection("projectentry");
            }
            DynamicObjectCollection purDetails = supplierSection.getDynamicObjectCollection("projectdetail");
            if (projentrys == null) continue;
            for (DynamicObject projentry : projentrys) {
                DynamicObject plPurDetail = purDetails.addNew();
                plPurDetail.set("seq", projentry.get("seq"));
                plPurDetail.set("materialid", projentry.get("materialid"));
                plPurDetail.set("materialdes", (Object)projentry.getString("materialdes"));
                plPurDetail.set("baseunit", (Object)projentry.getDynamicObject("baseunit"));
                plPurDetail.set("qty", (Object)projentry.getString("qty"));
                plPurDetail.set("purentrycontent", projentry.get("purentrycontent"));
                plPurDetail.set("purentryproject", projentry.get("purentryproject"));
                plPurDetail.set("controlamount", projentry.get("controlamount"));
                plPurDetail.set("planamount", projentry.get("planamount"));
                plPurDetail.set("nottaxplanamount", projentry.get("nottaxplanamount"));
                plPurDetail.set("importtext2", (Object)"importtext2");
                if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) continue;
                plPurDetail.set("listnumber", projentry.get("listnumber"));
                plPurDetail.set("listname", projentry.get("listname"));
                plPurDetail.set("resourceitem", projentry.get("resourceitem"));
            }
        }
        Long id = ID.genLongId();
        bidPublish.set("id", (Object)id);
        if ("rebm".equals(appId)) {
            this.createBidListEntrys(bidDocumentEdit, bidPublish);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
        TXHandle h = TX.requiresNew();
        serializable = null;
        try {
            try {
                DynamicObject biddocument;
                Object isAgain = null;
                if (params != null && !params.isEmpty()) {
                    isAgain = params.get("isAgain");
                }
                if ((biddocument = params != null && !params.isEmpty() && isAgain != null && "1".equals(isAgain.toString()) ? BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)"id,entitytypeid", (QFilter[])new QFilter[]{filter, billStatusFilter}) : BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)"id,entitytypeid", (QFilter[])new QFilter[]{filter})) != null) {
                    String entitytypeId = (String)biddocument.get("entitytypeid");
                    boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
                    if (isseparatedoc) {
                        BidFileHelper.copyBidDocumentFileToBillExpComAndTech(BidUtils.getAppID(entitytypeId), biddocument.get("id"), "all", BidUtils.getAppID(entitytypeId) + "_" + "bidpublish", id);
                    } else {
                        BidFileHelper.copyBidDocumentFileToBill(BidUtils.getAppID(entitytypeId), biddocument.get("id"), "all", BidUtils.getAppID(entitytypeId) + "_" + "bidpublish", id);
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (serializable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    public void setSupplierEntry(boolean publicBiddingFlag, boolean supplierInvitationFlag, DynamicObject supplierEntry, DynamicObject supplier) {
        String tenderStatus;
        supplierEntry.set("supplier", supplier.get("supplier"));
        supplierEntry.set("suppliercontact", supplier.get("suppliercontact"));
        supplierEntry.set("contactphone", supplier.get("contactphone"));
        supplierEntry.set("suppliercomment", supplier.get("suppliercomment"));
        supplierEntry.set("supplierstatistic", supplier.get("supplierstatistic"));
        supplierEntry.set("suppliersecdeposit", supplier.get("suppliersecdeposit"));
        if (supplierInvitationFlag && supplier.get("invalidflag") != null) {
            int inValidFlag = 0;
            if (supplier.getBoolean("invalidflag")) {
                inValidFlag = 1;
            }
            supplierEntry.set("invalidflag", (Object)inValidFlag);
        }
        if (supplierInvitationFlag && !StringUtils.isEmpty((CharSequence)(tenderStatus = supplier.getString("tenderstatus"))) && !tenderStatus.contains("-")) {
            supplierEntry.set("tenderstatus", (Object)supplier.getString("tenderstatus"));
        }
        supplierEntry.set("pubstrategy", (Object)BidPubStrategyEnum.KEEP.getValue());
        if (supplierInvitationFlag) {
            supplierEntry.set("isfromproject", (Object)Boolean.FALSE);
        } else if (publicBiddingFlag) {
            supplierEntry.set("isfromproject", (Object)Boolean.FALSE);
        } else {
            supplierEntry.set("isfromproject", (Object)Boolean.TRUE);
        }
        supplierEntry.set("isdowndoc", (Object)"NOTDOWN");
    }

    @Override
    public EntityType createSectionType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
        EntityType type = (EntityType)mainType.getAllEntities().get("bidsection");
        return type;
    }

    @Override
    public MainEntityType createBidPublishType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
        return mainType;
    }

    @Override
    public EntityType createSupplierEntryType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
        EntityType type = (EntityType)mainType.getAllEntities().get("supplierentry");
        return type;
    }

    @Override
    public void generatorNextStepBill(Object billId) {
        boolean isBidEvaluation;
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_project");
        boolean isBidOpen = mainObj.getBoolean("bidopen");
        if (isBidOpen) {
            BidOpenServiceImpl bidOpenService = new BidOpenServiceImpl();
            bidOpenService.createNextStep(mainObj, BidStepEnum.BidPublish);
        }
        if (isBidEvaluation = mainObj.getBoolean("bidevaluation")) {
            BidEvaluationServiceImpl bidEvaluationService = new BidEvaluationServiceImpl();
            bidEvaluationService.createNextStep(mainObj, BidStepEnum.BidPublish);
        }
    }

    @Override
    public void saveBidPublishInvalidStatus(String billId) {
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_bidpublish", (String)"id,billstatus,bidproject.id");
        bidPublish.set(BILL_STATUS, (Object)BillStatusEnum.INVALID.getVal());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
    }

    @Override
    public void saveBidPublishPublishStatus(String billId) {
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_bidpublish", (String)"id,billstatus,realbidpublishdate");
        Date realpublishbiddate = new Date();
        bidPublish.set(BILL_STATUS, (Object)BillStatusEnum.PUBLISHED.getVal());
        bidPublish.set("realbidpublishdate", (Object)realpublishbiddate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
    }

    @Override
    public boolean checkRePublish(Object bidProjectId) {
        QFilter filter = new QFilter("bidproject", "=", bidProjectId);
        DynamicObject[] bidOpenCol = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billno.bidproject,billstatus", (QFilter[])new QFilter[]{filter});
        DynamicObject[] bidDocumentEditCol = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"billno.bidproject,billstatus", (QFilter[])new QFilter[]{filter});
        String editStatus = BillStatusEnum.AUDITED.getVal();
        if (bidDocumentEditCol != null && bidDocumentEditCol.length > 0) {
            editStatus = bidDocumentEditCol[0].getString(BILL_STATUS);
        }
        if (bidOpenCol.length != 0) {
            String billStatus = bidOpenCol[0].getString(BILL_STATUS);
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus)) {
                return StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)editStatus);
            }
            return !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)billStatus);
        }
        DynamicObject[] biddecisionCol = BusinessDataServiceHelper.load((String)"bid_decision", (String)"billno.bidproject,billstatus", (QFilter[])new QFilter[]{filter});
        if (biddecisionCol.length != 0) {
            String billStatus = biddecisionCol[0].getString(BILL_STATUS);
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus)) {
                return StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)editStatus);
            }
            return false;
        }
        return true;
    }

    @Override
    @SdkDeprecated
    public DynamicObject getBidPublishByProjectId(Long projectId, String selectedFields) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        QFilter qFilterOne = new QFilter(BILL_STATUS, "!=", (Object)"X").and(new QFilter(BILL_STATUS, "!=", (Object)"J"));
        if (StringUtils.isNotEmpty((CharSequence)selectedFields)) {
            return QueryServiceHelper.queryOne((String)"bid_bidpublish", (String)selectedFields, (QFilter[])new QFilter[]{qFilter, qFilterOne});
        }
        return BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (QFilter[])new QFilter[]{qFilter, qFilterOne});
    }

    @Override
    public void updateBidPublishStatusById(Object billId, String status) {
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_bidpublish", (String)"id,billstatus,sourcebillstatus,realbidpublishdate,isnewbill,bidproject.id,bidproject.currentstep,bidproject.billstatus,rounds,listrounds,bidstep");
        if (!status.equals(BillStatusEnum.ADJUSTING.getVal())) {
            DynamicObject[] publishs = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter(BILL_STATUS, "=", (Object)"X"), new QFilter("bidproject.id", "in", bidPublish.getDynamicObject("bidproject").getPkValue()), new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()), new QFilter("id", "!=", bidPublish.getPkValue())});
            int length = publishs.length + 1;
            bidPublish.set("rounds", (Object)length);
            bidPublish.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u53d1\u6807", (String)"BidPublishServiceImpl_22", (String)"scm-bid-business", (Object[])new Object[0]), BidPublishServiceImpl.toChinese(length + "")));
            if (!bidPublish.getString(BILL_STATUS).equals(BillStatusEnum.INVALID.getVal())) {
                bidPublish.set("sourcebillstatus", (Object)bidPublish.getString(BILL_STATUS));
            }
        }
        bidPublish.set(BILL_STATUS, (Object)status);
        bidPublish.set("isnewbill", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
    }

    @Override
    public boolean checkUnStarted(Object bidProjectPK) {
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPK);
        QFilter qFilterOne = new QFilter(BILL_STATUS, "!=", (Object)"X").and(new QFilter(BILL_STATUS, "!=", (Object)"J"));
        DynamicObject object = QueryServiceHelper.queryOne((String)this.getFormId(), (String)BILL_STATUS, (QFilter[])new QFilter[]{qFilter, qFilterOne});
        return object == null || BillStatusEnum.DISBEGIN.getVal().equals(object.get(BILL_STATUS));
    }

    @Override
    public String getFormId() {
        return "bid_bidpublish";
    }

    @Override
    public void saveAnswerDeadline(Object bidProjectId, Date date, String field) {
        Long bidIdLong = Long.parseLong(bidProjectId.toString());
        QFilter bidProjectFilter = new QFilter("bidproject", "=", (Object)bidIdLong);
        QFilter billstatusFilter = new QFilter(BILL_STATUS, "not in", Arrays.asList(BillStatusEnum.INVALID.getVal(), BillStatusEnum.ADJUSTING.getVal()));
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)("id," + field), (QFilter[])new QFilter[]{bidProjectFilter, billstatusFilter});
        if (bidPublish != null) {
            bidPublish.set(field, (Object)date);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
        }
    }

    @Override
    public DynamicObject getBidPublishById(Long id, String field) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)this.getFormId(), (String)field, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject getBidPublishUnique(Long parentId, Long id, String billName) {
        QFilter qFilter = new QFilter("id", "!=", (Object)id);
        qFilter.and(new QFilter("sourcepublish", "=", (Object)parentId));
        qFilter.and(new QFilter(BILL_STATUS, "!=", (Object)BillStatusEnum.INVALID.getVal()));
        return QueryServiceHelper.queryOne((String)billName, (String)"id", (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject getBidPublishById(Long id) {
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_bidpublish", (String)"id,entitytypeid");
        String entitytypeid = tempObj.getString("entitytypeid");
        if ("bid_bidpublish".equals(entitytypeid)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
            return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
        }
        if ("rebm_bidpublish".equals(entitytypeid)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"rebm_bidpublish");
            return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bidpublish");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    public void sendMessage(DynamicObject bidProjectF7) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        boolean enable = SystemParamHelper.getSystemParameter((String)appid, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidpublish", this.getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter(BILL_STATUS, "!=", (Object)"X")});
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidPublishServiceImpl_23", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("tplScene", "createbidpublish");
        if ("bid".equals(appid)) {
            msgParam.put("formId", "bid_bidpublish");
        } else {
            msgParam.put("formId", "rebm_bidpublish");
        }
        msgParam.put("appId", appid);
        msgParam.put("id", bidPublish.getPkValue());
        msgParam.put("pkId", bidPublish.getPkValue());
        msgParam.put("title", null);
        msgParam.put("operation", "save");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values;
            if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
            for (int m = 0; m < values.length; ++m) {
                if (!"05".equals(values[m])) continue;
                memberSet.add(member.getDynamicObject("user"));
            }
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("msgentity", "bid_bidpublish");
        String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u53d1\u6807\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidPublishServiceImpl_24", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
        msgParam.put("content", null);
        String notifyTypes = MessageChannelUtil.getNotifyType((String)"createbidpublish", (String)"bid_bidpublish");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyTypes);
    }

    private static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"BidPublishServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"BidPublishServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"BidPublishServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"BidPublishServiceImpl_4", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"BidPublishServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"BidPublishServiceImpl_6", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"BidPublishServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"BidPublishServiceImpl_8", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"BidPublishServiceImpl_9", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"BidPublishServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"BidPublishServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"BidPublishServiceImpl_14", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidPublishServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"BidPublishServiceImpl_15", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidPublishServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0])};
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                sb.append(s1[num]).append(s2[n - 2 - i]);
                continue;
            }
            sb.append(s1[num]);
        }
        return sb.toString();
    }

    protected void createBidListEntrys(DynamicObject bidDocumentBil, DynamicObject bidPublish) {
        if (null == bidDocumentBil) {
            return;
        }
        DynamicObjectCollection docListEntryColl = bidDocumentBil.getDynamicObjectCollection("listentry");
        if (docListEntryColl.size() == 0) {
            return;
        }
        DynamicObjectCollection pubListEntryColl = bidPublish.getDynamicObjectCollection("listentry");
        int index = 1;
        for (DynamicObject docListEntry : docListEntryColl) {
            DynamicObject listBill = docListEntry.getDynamicObject("listentry_listbill");
            if (null == listBill) continue;
            DynamicObject newListEntry = pubListEntryColl.addNew();
            newListEntry.set("seq", (Object)index);
            newListEntry.set("listentry_sectionname", docListEntry.get("listentry_sectionname"));
            newListEntry.set("listentry_listbill", docListEntry.get("listentry_listbill"));
            newListEntry.set("listentry_resume", docListEntry.get("listentry_resume"));
            DynamicObjectCollection newListDesColl = newListEntry.getDynamicObjectCollection("listentry_description");
            DynamicObjectCollection decriptionColl = docListEntry.getDynamicObjectCollection("listentry_description");
            for (DynamicObject listDesObj : decriptionColl) {
                DynamicObject newListDesObj = newListDesColl.addNew();
                newListDesObj.set(LISTENTRY_ATTCHMENT, listDesObj.get(LISTENTRY_ATTCHMENT));
            }
            ++index;
        }
    }

    public boolean isAgainSupplierInvitation(DynamicObject supplierInvitation) {
        if (supplierInvitation == null) {
            return false;
        }
        String sourceBillId = supplierInvitation.getString("sourcebillid");
        return !StringUtils.isEmpty((CharSequence)sourceBillId) && !"0".equals(sourceBillId);
    }
}

