/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.helper;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.BidAnswerQuestionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidClarificaitonServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPublishServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveServiceHelper;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.sdk.annotation.SdkDeprecated;

public class BidStepInteractiveHelper {
    private static final Integer index0 = 0;

    @SdkDeprecated
    public static BidStepEnum[] getNextStep(DynamicObject bidProject, BidStepEnum currentStep) {
        String strs = "id,bidproject,clarificaiton,supplierinvitation,biddocument,bidpublish,bidanswerquestion,bidopen,bidevaluation,bidbustalk,biddecision,bidopentype";
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)BidStepInteractiveHelper.getBidStepService(BidStepEnum.BidProject).getFormId(), (String)strs);
        EnumMap<BidStepEnum, Boolean> containsStep = new EnumMap<BidStepEnum, Boolean>(BidStepEnum.class);
        containsStep.put(BidStepEnum.Clarificaiton, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.Clarificaiton));
        containsStep.put(BidStepEnum.SupplierInvitation, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.SupplierInvitation));
        containsStep.put(BidStepEnum.BidDocument, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidDocument));
        containsStep.put(BidStepEnum.BidPublish, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidPublish));
        containsStep.put(BidStepEnum.BidAnswerQuestion, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidAnswerQuestion));
        containsStep.put(BidStepEnum.BidOpen, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidOpen));
        containsStep.put(BidStepEnum.BidEvaluation, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidEvaluation));
        containsStep.put(BidStepEnum.BidBustalk, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidBustalk));
        containsStep.put(BidStepEnum.BidDecision, BidStepInteractiveHelper.checkContainStep(bidProject, BidStepEnum.BidDecision));
        BidStepEnum[][] allSteps = BidStepEnum.getAllSteps();
        int currentStepIndex = currentStep.getIndex() - 1;
        if (BidStepEnum.BidEvaluation == currentStep) {
            if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidProject.getString("bidopentype"))) {
                return BidStepInteractiveHelper.getNextStepByCurIndex(containsStep, allSteps, currentStepIndex);
            }
            if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidProject.getString("bidopentype")) || BidOpenSelectTypeEnum.BUSSINESSTECH.getValue().equals(bidProject.getString("bidopentype"))) {
                QFilter qFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
                DynamicObject[] bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billstatus,opentype", (QFilter[])new QFilter[]{qFilter = qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal()))});
                if (bidOpenArr != null && bidOpenArr.length == 1) {
                    return BidStepInteractiveHelper.getNextStepByCurIndex(containsStep, allSteps, currentStepIndex - 2);
                }
                return BidStepInteractiveHelper.getNextStepByCurIndex(containsStep, allSteps, currentStepIndex);
            }
        }
        return BidStepInteractiveHelper.getNextStepByCurIndex(containsStep, allSteps, currentStepIndex);
    }

    protected static BidStepEnum[] getNextStepByCurIndex(Map<BidStepEnum, Boolean> containsStep, BidStepEnum[][] allSteps, int currentStepIndex) {
        for (int i = currentStepIndex + 1; i < allSteps.length; ++i) {
            ArrayList<BidStepEnum> nextStepList;
            BidStepEnum[] nextStep = allSteps[i];
            if (nextStep.length == 1) {
                if (!containsStep.get(nextStep[index0]).booleanValue()) continue;
                nextStepList = new ArrayList(8);
                nextStepList.add(nextStep[index0]);
                boolean equals = nextStep[index0].getAlias().equals(BidStepEnum.BidAnswerQuestion.getAlias());
                if (equals && containsStep.get(BidStepEnum.BidDecision).booleanValue() && !containsStep.get(BidStepEnum.BidOpen).booleanValue() && !containsStep.get(BidStepEnum.BidEvaluation).booleanValue()) {
                    nextStepList.add(BidStepEnum.BidDecision);
                }
                BidStepEnum[] nextSteps = new BidStepEnum[nextStepList.size()];
                nextStepList.toArray(nextSteps);
                return nextSteps;
            }
            nextStepList = new ArrayList<BidStepEnum>(50);
            for (BidStepEnum nextStepOne : nextStep) {
                if (!containsStep.get(nextStepOne).booleanValue()) continue;
                nextStepList.add(nextStepOne);
            }
            int nextStepSize = nextStepList.size();
            if (nextStepSize <= 0) continue;
            BidStepEnum[] nextSteps = new BidStepEnum[nextStepSize];
            if (nextStepSize == 1 && nextStepList.get(0) == BidStepEnum.Clarificaiton && containsStep.get(BidStepEnum.BidPublish).booleanValue()) {
                nextStepList.add(BidStepEnum.BidPublish);
                nextSteps = new BidStepEnum[2];
            }
            nextStepList.toArray(nextSteps);
            return nextSteps;
        }
        return new BidStepEnum[0];
    }

    public static BidStepInteractiveServiceHelper[] getNextStepService(DynamicObject bidProject, BidStepEnum currentStep) {
        BidStepEnum[] nextSteps = BidStepInteractiveHelper.getNextStep(bidProject, currentStep);
        BidStepInteractiveServiceHelper[] nextStepServices = new BidStepInteractiveServiceHelper[nextSteps.length];
        int i = 0;
        for (BidStepEnum nextStep : nextSteps) {
            nextStepServices[i++] = BidStepInteractiveHelper.getBidStepService(nextStep);
        }
        return nextStepServices;
    }

    @SdkDeprecated
    public static BidStepInteractiveServiceHelper getBidStepService(BidStepEnum step) {
        EnumMap<BidStepEnum, Object> stepServiceMap = null;
        if (stepServiceMap == null) {
            stepServiceMap = new EnumMap<BidStepEnum, Object>(BidStepEnum.class);
            stepServiceMap.put(BidStepEnum.BidProject, (Object)new BidProjectServiceImpl());
            stepServiceMap.put(BidStepEnum.Clarificaiton, (Object)new BidClarificaitonServiceImpl());
            stepServiceMap.put(BidStepEnum.SupplierInvitation, (Object)new SupplierInvitationServiceImpl());
            stepServiceMap.put(BidStepEnum.BidDocument, (Object)new BidDocumentServiceImpl());
            stepServiceMap.put(BidStepEnum.BidPublish, (Object)new BidPublishServiceImpl());
            stepServiceMap.put(BidStepEnum.BidAnswerQuestion, (Object)new BidAnswerQuestionServiceImpl());
            stepServiceMap.put(BidStepEnum.BidOpen, (Object)new BidOpenServiceImpl());
            stepServiceMap.put(BidStepEnum.BidEvaluation, (Object)new BidEvaluationServiceImpl());
            stepServiceMap.put(BidStepEnum.BidBustalk, (Object)new BidBustalkServiceImpl());
            stepServiceMap.put(BidStepEnum.BidDecision, (Object)new BidDecisionServiceImpl());
        }
        return (BidStepInteractiveServiceHelper)stepServiceMap.get(step);
    }

    @SdkDeprecated
    public static boolean checkStepComplete(Long bidProjectId, BidStepEnum checkStep) {
        if (BidStepInteractiveHelper.checkContainStep(bidProjectId, checkStep)) {
            String formId = BidStepInteractiveHelper.getBidStepService(checkStep).getFormId();
            QFilter qFilterId = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            QFilter qFilterStatus = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal());
            return QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{qFilterId, qFilterStatus});
        }
        return true;
    }

    public static boolean checkContainStep(Long bidProjectId, BidStepEnum checkStep) {
        String strs = "id,bidproject,clarificaiton,supplierinvitation,biddocument,bidpublish,bidopen,bidevaluation,bidbustalk,biddecision";
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)BidStepInteractiveHelper.getBidStepService(BidStepEnum.BidProject).getFormId(), (String)strs);
        return BidStepInteractiveHelper.checkContainStep(bidProject, checkStep);
    }

    public static boolean checkContainStep(DynamicObject bidProject, BidStepEnum checkStep) {
        if (bidProject != null) {
            return bidProject.getBoolean(checkStep.name().toLowerCase());
        }
        return false;
    }
}

