/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.PurProjectServiceImpl;
import kd.scm.bid.common.enums.BillStatusEnum;

public class HlbBidHistoryDataTask
extends AbstractTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Class<HlbBidHistoryDataTask> clazz = HlbBidHistoryDataTask.class;
        synchronized (HlbBidHistoryDataTask.class) {
            try {
                this.dealBidDocument();
                this.dealBidSupplierInvitation();
                this.dealInvitation();
                this.dealBidPublish();
                this.dealBidOpen();
                this.dealBidBusTalk();
                this.dealOnlineEval();
                this.dealBidEval();
                this.dealBidQuestClarify();
                this.dealBidDing();
                this.dealPurProject();
            }
            catch (Exception e) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u5347\u7ea7\u51fa\u9519\uff1a%s\u3002", (String)"HlbBidHistoryDataTask_0", (String)"scm-bid-business", (Object[])new Object[0]), e));
            }
            return;
        }
    }

    public void dealPurProject() {
        PurProjectServiceImpl purProjectService = new PurProjectServiceImpl();
        purProjectService.bidPurProjectHistoricalDataUpgrade();
    }

    public void dealBidProject() {
    }

    public void dealBidDocument() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u6807\u4e66\u7f16\u5236\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_1", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id,bidproject,bidproject.id, bidproject.createtime, sortfield, createtime";
        DynamicObject[] documentArray = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("sortfield", "is null", null).or(new QFilter("sortfield", "=", (Object)Character.valueOf(' ')))});
        if (documentArray != null && documentArray.length > 0) {
            for (DynamicObject document : documentArray) {
                DynamicObject bidProject = document.getDynamicObject("bidproject");
                if (bidProject == null) continue;
                String id = bidProject.getString("id");
                Date createTime = document.getDate("createtime");
                document.set("sortfield", (Object)(id + createTime.getTime()));
            }
            SaveServiceHelper.update((DynamicObject[])documentArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_2", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealBidSupplierInvitation() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_3", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id,bidproject,bidproject.id,rounds,listrounds,bidstep,sourcebillid,listcurrentstep,listprojectname,sourcebillstatus,sortfield,createtime";
        DynamicObject[] supplierInvitationArray = BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("sortfield", "is null", null).or(new QFilter("sortfield", "=", (Object)Character.valueOf(' ')))});
        if (supplierInvitationArray != null && supplierInvitationArray.length > 0) {
            for (DynamicObject supplierInvitation : supplierInvitationArray) {
                DynamicObject bidProject = supplierInvitation.getDynamicObject("bidproject");
                if (bidProject == null) continue;
                String id = bidProject.getString("id");
                Date createTime = supplierInvitation.getDate("createtime");
                supplierInvitation.set("sortfield", (Object)(id + createTime.getTime()));
            }
            SaveServiceHelper.update((DynamicObject[])supplierInvitationArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_4", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealBidPublish() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u53d1\u6807\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_5", (String)"scm-bid-business", (Object[])new Object[0]));
        HashSet<Long> setBillIsFalseIds = new HashSet<Long>();
        String selectProperties = "id,billstatus,listrounds,isdocchange,isnewbill,sourcebillstatus,biddocument,source,bidstep,bidproject,bidproject.id,bidproject.bidpublishdate,bidproject.answerquestiontime,bidproject.bidopendeadline,bidproject.bidevaluationdate,bidproject.biddecisiondate, bidproject.supplierinvitation, probidpublishdate,planbidpublishdate1,proanswerquestiontime,probidopendeadline,probidevaluationdate,probiddecisiondate,projecttime,createtime,sourcepublish, plananswerquestiontime, planbidopendeadline, planbidevaluationdate, planbiddecisiondate, bidproject.currentstep,bidsection,bidsection.sectionname,supplierentry,supplierentry.tenderstrategy,supplierentry.tenderstatus,supplierentry.invalidflag,supplierentry.supplier,supplierentry.tenderstatus,supplierinvitationid,rounds";
        DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("supplierinvitationid", "=", (Object)0).or(new QFilter("supplierinvitationid", "is null", null))});
        if (bidPublishArray != null && bidPublishArray.length > 0) {
            for (DynamicObject bidPublish : bidPublishArray) {
                String status;
                DynamicObject tempPublish;
                DynamicObject supplierInvitation;
                DynamicObject bidProject = bidPublish.getDynamicObject("bidproject");
                if (bidProject == null) continue;
                bidPublish.set("probidpublishdate", (Object)bidProject.getDate("bidpublishdate"));
                bidPublish.set("proanswerquestiontime", (Object)bidProject.getDate("answerquestiontime"));
                bidPublish.set("probidopendeadline", (Object)bidProject.getDate("bidopendeadline"));
                bidPublish.set("probidevaluationdate", (Object)bidProject.getDate("bidevaluationdate"));
                bidPublish.set("probiddecisiondate", (Object)bidProject.getDate("biddecisiondate"));
                bidPublish.set("planbidpublishdate1", (Object)bidProject.getDate("bidpublishdate"));
                bidPublish.set("plananswerquestiontime", (Object)bidProject.getDate("answerquestiontime"));
                bidPublish.set("planbidopendeadline", (Object)bidProject.getDate("bidopendeadline"));
                bidPublish.set("planbidevaluationdate", (Object)bidProject.getDate("bidevaluationdate"));
                bidPublish.set("planbiddecisiondate", (Object)bidProject.getDate("biddecisiondate"));
                bidPublish.set("isdocchange", (Object)Boolean.FALSE);
                boolean existSupplierInvitation = bidProject.getBoolean("supplierinvitation");
                if (existSupplierInvitation && (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidPublish.set("supplierinvitationid", supplierInvitation.getPkValue());
                }
                bidPublish.set("projecttime", (Object)(bidProject.getPkValue().toString() + bidPublish.getDate("createtime").getTime()));
                Object sourcepublish = bidPublish.get("sourcepublish");
                String billStatus = bidPublish.getString("billstatus");
                if (billStatus.equals("J") || billStatus.equals("X")) {
                    bidPublish.set("isnewbill", (Object)Boolean.TRUE);
                    setBillIsFalseIds.add(bidPublish.getLong("id"));
                } else {
                    bidPublish.set("isnewbill", (Object)Boolean.TRUE);
                }
                if (billStatus.equals("J") && (tempPublish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("sourcepublish", "=", (Object)bidPublish.getLong("id"))})) != null) {
                    String tempBillStatus = tempPublish.getString("billstatus");
                    if (tempBillStatus.equals("C")) {
                        bidPublish.set("billstatus", (Object)"X");
                    } else {
                        bidPublish.set("billstatus", (Object)"P");
                    }
                }
                if ((status = bidPublish.getString("billstatus")).equals("X")) {
                    if (sourcepublish.equals("0")) {
                        bidPublish.set("rounds", (Object)1);
                    } else {
                        int rounds = this.getPublishRounds(bidPublishArray, sourcepublish.toString(), 1);
                        bidPublish.set("rounds", (Object)rounds);
                    }
                }
                if (!sourcepublish.equals("0")) {
                    bidPublish.set("sourcebillstatus", (Object)"P");
                    bidPublish.set("source", (Object)"republish");
                    DynamicObject biddocument = BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal())});
                    if (biddocument != null) {
                        bidPublish.set("biddocument", biddocument.getPkValue());
                    }
                } else {
                    bidPublish.set("source", (Object)"new");
                }
                HashMap<Long, String> supplierAndStatus = new HashMap<Long, String>(100);
                DynamicObject[] mytenders = BusinessDataServiceHelper.load((String)"ten_mytender", (String)"id,tenderstatus,supplier", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())});
                if (mytenders == null || mytenders.length <= 0) continue;
                boolean isTen = true;
                for (int i = 0; i < mytenders.length; ++i) {
                    if (mytenders[i].getDynamicObject("supplier") == null) {
                        isTen = false;
                        break;
                    }
                    Long supplierId = (Long)mytenders[i].getDynamicObject("supplier").getPkValue();
                    String tenderStatus = mytenders[i].getString("tenderstatus");
                    supplierAndStatus.put(supplierId, tenderStatus);
                }
                if (!isTen) {
                    try {
                        DynamicObject[] mytenderColl = BusinessDataServiceHelper.load((String)"resp_mytender", (String)"id,tenderstatus,supplier", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())});
                        for (int i = 0; i < mytenderColl.length; ++i) {
                            if (mytenders[i].getDynamicObject("supplier") == null) continue;
                            Long supplierId = (Long)mytenderColl[i].getDynamicObject("supplier").getPkValue();
                            String tenderStatus = mytenderColl[i].getString("tenderstatus");
                            supplierAndStatus.put(supplierId, tenderStatus);
                        }
                    }
                    catch (Exception e) {
                        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u53d1\u6807\u66f4\u65b0\u810f\u6570\u636e\u5f02\u5e38\u62db\u6807\u7acb\u9879Id\uff1a%s", (String)"HlbBidHistoryDataTask_6", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getPkValue()));
                    }
                }
                String currentStep = bidProject.getString("currentstep");
                bidPublish.set("bidstep", (Object)currentStep);
                if (supplierAndStatus.isEmpty() || sourcepublish.equals("0")) continue;
                if (!isTen) {
                    DynamicObject bidPublishTemp = BusinessDataServiceHelper.loadSingle((Object)bidPublish.getPkValue(), (String)"rebm_bidpublish");
                    DynamicObjectCollection sectionColl = bidPublishTemp.getDynamicObjectCollection("bidsection");
                    for (int i = 0; i < sectionColl.size(); ++i) {
                        DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                        for (int j = 0; j < supplierEntryColl.size(); ++j) {
                            DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                            if (supplier == null) continue;
                            Object tenderStatus = supplierAndStatus.get(supplier.getLong("id"));
                            DynamicObjectCollection sectionCollTemp = bidPublish.getDynamicObjectCollection("bidsection");
                            for (int k = 0; k < sectionCollTemp.size(); ++k) {
                                DynamicObjectCollection supplierEntryCollTemp = ((DynamicObject)sectionCollTemp.get(k)).getDynamicObjectCollection("supplierentry");
                                for (int m = 0; m < supplierEntryCollTemp.size(); ++m) {
                                    DynamicObject supplierEntryTemp = (DynamicObject)supplierEntryCollTemp.get(m);
                                    if (!supplierEntry.getPkValue().toString().equals(supplierEntryTemp.getPkValue().toString())) continue;
                                    if (tenderStatus != null && ("TENDERED".equals(tenderStatus) || "UNTENDERED".equals(tenderStatus) || "PRETENDERED".equals(tenderStatus))) {
                                        supplierEntryTemp.set("tenderstatus", tenderStatus);
                                        if ("UNTENDERED".equals(tenderStatus) || "PRETENDERED".equals(tenderStatus)) {
                                            supplierEntryTemp.set("tenderstrategy", (Object)"");
                                        } else {
                                            supplierEntryTemp.set("tenderstrategy", (Object)"UNNEEDBID");
                                        }
                                    } else {
                                        supplierEntryTemp.set("tenderstrategy", (Object)"");
                                    }
                                    supplierEntryTemp.set("invalidflag", (Object)"0");
                                }
                            }
                        }
                    }
                    continue;
                }
                DynamicObjectCollection sectionColl = bidPublish.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < sectionColl.size(); ++i) {
                    DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null) continue;
                        Object tenderStatus = supplierAndStatus.get(supplier.getLong("id"));
                        if (tenderStatus != null && ("TENDERED".equals(tenderStatus) || "UNTENDERED".equals(tenderStatus) || "PRETENDERED".equals(tenderStatus))) {
                            supplierEntry.set("tenderstatus", tenderStatus);
                            if ("UNTENDERED".equals(tenderStatus) || "PRETENDERED".equals(tenderStatus)) {
                                supplierEntry.set("tenderstrategy", (Object)"");
                            } else {
                                supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
                            }
                        } else {
                            supplierEntry.set("tenderstrategy", (Object)"");
                        }
                        supplierEntry.set("invalidflag", (Object)"0");
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])bidPublishArray);
            if (!setBillIsFalseIds.isEmpty()) {
                DynamicObject[] bidPublishArrays;
                for (DynamicObject bidPublishTemp : bidPublishArrays = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id,isnewbill", (QFilter[])new QFilter[]{new QFilter("id", "in", setBillIsFalseIds)})) {
                    bidPublishTemp.set("isnewbill", (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])bidPublishArrays);
            }
            BizLog.log((String)ResManager.loadKDString((String)"\u53d1\u6807\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_7", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public int getPublishRounds(DynamicObject[] bidPublishArray, String sourcepublish, int rounds) {
        for (DynamicObject bidPublish : bidPublishArray) {
            String pk = bidPublish.getPkValue().toString();
            if (!sourcepublish.equals(pk)) continue;
            String sourcepublishId = bidPublish.get("sourcepublish").toString();
            ++rounds;
            if (sourcepublish.equals("0")) continue;
            this.getPublishRounds(bidPublishArray, sourcepublishId, rounds);
        }
        return rounds;
    }

    public void dealBidOpen() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u5f00\u6807\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_8", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id, bidproject, bidproject.id, bidproject.supplierinvitation, bidproject.bidpublish, bidpublishid, supplierinvitationid";
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidpublishid", "=", (Object)0).or(new QFilter("bidpublishid", "is null", null))});
        if (bidOpenArray != null && bidOpenArray.length > 0) {
            for (DynamicObject bidOpen : bidOpenArray) {
                DynamicObject supplierInvitation;
                boolean existSupplierInvitation;
                DynamicObject publish;
                DynamicObject bidProject = bidOpen.getDynamicObject("bidproject");
                if (bidProject == null) continue;
                boolean existPublish = bidProject.getBoolean("bidpublish");
                if (existPublish && (publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidOpen.set("bidpublishid", publish.getPkValue());
                }
                if (!(existSupplierInvitation = bidProject.getBoolean("supplierinvitation")) || (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                bidOpen.set("supplierinvitationid", supplierInvitation.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])bidOpenArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u6807\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_9", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealBidEval() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u8bc4\u6807\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_10", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id, bidproject, bidproject.id, bidproject.supplierinvitation, bidproject.bidpublish, bidproject.bidopen, supplierinvitationid, bidopenid, bidpublishid";
        DynamicObject[] bidEvalArray = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidopenid", "=", (Object)0).or(new QFilter("bidopenid", "is null", null))});
        if (bidEvalArray != null && bidEvalArray.length > 0) {
            for (DynamicObject bidEval : bidEvalArray) {
                DynamicObject supplierInvitation;
                boolean existSupplierInvitation;
                DynamicObject publish;
                boolean existPublish;
                DynamicObject bidOpen;
                DynamicObject bidProjectJ = bidEval.getDynamicObject("bidproject");
                if (bidProjectJ == null) continue;
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectJ.getPkValue(), (String)"bid_project");
                boolean existOpen = bidProject.getBoolean("bidopen");
                if (existOpen && (bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidEval.set("bidopenid", bidOpen.getPkValue());
                }
                if ((existPublish = bidProject.getBoolean("bidpublish")) && (publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidEval.set("bidpublishid", publish.getPkValue());
                }
                if (!(existSupplierInvitation = bidProject.getBoolean("supplierinvitation")) || (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                bidEval.set("supplierinvitationid", supplierInvitation.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])bidEvalArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u8bc4\u6807\u5386\u53f2\u6570\u636e\u5904\u7406\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_11", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealOnlineEval() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_12", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id, bidproject, bidproject.id, bidproject.supplierinvitation, bidproject.bidpublish, bidproject.bidopen, supplierinvitationid, bidopenid, bidpublishid";
        DynamicObject[] bidOnlineEvalArray = BusinessDataServiceHelper.load((String)"bid_onlinebideval", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidopenid", "=", (Object)0).or(new QFilter("bidopenid", "is null", null))});
        if (bidOnlineEvalArray != null && bidOnlineEvalArray.length > 0) {
            for (DynamicObject onlineEval : bidOnlineEvalArray) {
                DynamicObject supplierInvitation;
                boolean existSupplierInvitation;
                DynamicObject publish;
                boolean existPublish;
                DynamicObject bidOpen;
                Object bidProjectPk;
                DynamicObject bidProjectJ = onlineEval.getDynamicObject("bidproject");
                if (bidProjectJ == null || (bidProjectPk = bidProjectJ.getPkValue()) == null) continue;
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)"bid_project");
                boolean existOpen = bidProject.getBoolean("bidopen");
                if (existOpen && (bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    onlineEval.set("bidopenid", bidOpen.getPkValue());
                }
                if ((existPublish = bidProject.getBoolean("bidpublish")) && (publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    onlineEval.set("bidpublishid", publish.getPkValue());
                }
                if (!(existSupplierInvitation = bidProject.getBoolean("supplierinvitation")) || (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                onlineEval.set("supplierinvitationid", supplierInvitation.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])bidOnlineEvalArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u5728\u7ebf\u8bc4\u6807\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_13", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealBidBusTalk() {
    }

    public void dealBidQuestClarify() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u8d28\u7591\u3001\u6f84\u6e05\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_14", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id, bidproject, bidproject.id, bidproject.supplierinvitation, bidproject.bidpublish, bidproject.bidopen, bidproject.bidevaluation,supplierinvitationid, bidopenid, bidpublishid,bidevaluationid";
        DynamicObject[] bidQuestionClarifyArray = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidopenid", "=", (Object)0).or(new QFilter("bidopenid", "is null", null))});
        if (bidQuestionClarifyArray != null && bidQuestionClarifyArray.length > 0) {
            for (DynamicObject bidQuestionClarify : bidQuestionClarifyArray) {
                DynamicObject supplierInvitation;
                boolean existSupplierInvitation;
                DynamicObject publish;
                boolean existPublish;
                DynamicObject bidOpen;
                boolean existOpen;
                DynamicObject bidEvaluation;
                Object bidProjectPk;
                DynamicObject bidProjectJ = bidQuestionClarify.getDynamicObject("bidproject");
                if (bidProjectJ == null || (bidProjectPk = bidProjectJ.getPkValue()) == null) continue;
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)"bid_project");
                boolean existBidEvaluation = bidProject.getBoolean("bidevaluation");
                if (existBidEvaluation && (bidEvaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidQuestionClarify.set("bidevaluationid", bidEvaluation.getPkValue());
                }
                if ((existOpen = bidProject.getBoolean("bidopen")) && (bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidQuestionClarify.set("bidopenid", bidOpen.getPkValue());
                }
                if ((existPublish = bidProject.getBoolean("bidpublish")) && (publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                    bidQuestionClarify.set("bidpublishid", publish.getPkValue());
                }
                if (!(existSupplierInvitation = bidProject.getBoolean("supplierinvitation")) || (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                bidQuestionClarify.set("supplierinvitationid", supplierInvitation.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])bidQuestionClarifyArray);
            DynamicObject[] bidMultiQuestionClarifyArray = BusinessDataServiceHelper.load((String)"bid_multiquestclarify", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidopenid", "=", (Object)0).or(new QFilter("bidopenid", "is null", null))});
            if (bidMultiQuestionClarifyArray != null && bidMultiQuestionClarifyArray.length > 0) {
                for (DynamicObject bidQuestionClarify : bidMultiQuestionClarifyArray) {
                    DynamicObject supplierInvitation;
                    boolean existSupplierInvitation;
                    DynamicObject publish;
                    boolean existPublish;
                    DynamicObject bidOpen;
                    boolean existOpen;
                    DynamicObject bidEvaluation;
                    Object bidProjectPk;
                    DynamicObject bidProjectJ = bidQuestionClarify.getDynamicObject("bidproject");
                    if (bidProjectJ == null || (bidProjectPk = bidProjectJ.getPkValue()) == null) continue;
                    DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)"bid_project");
                    boolean existBidEvaluation = bidProject.getBoolean("bidevaluation");
                    if (existBidEvaluation && (bidEvaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                        bidQuestionClarify.set("bidevaluationid", bidEvaluation.getPkValue());
                    }
                    if ((existOpen = bidProject.getBoolean("bidopen")) && (bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                        bidQuestionClarify.set("bidopenid", bidOpen.getPkValue());
                    }
                    if ((existPublish = bidProject.getBoolean("bidpublish")) && (publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) != null) {
                        bidQuestionClarify.set("bidpublishid", publish.getPkValue());
                    }
                    if (!(existSupplierInvitation = bidProject.getBoolean("supplierinvitation")) || (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                    bidQuestionClarify.set("supplierinvitationid", supplierInvitation.getPkValue());
                }
            }
            SaveServiceHelper.update((DynamicObject[])bidMultiQuestionClarifyArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u5904\u7406\u8d28\u7591\u3001\u6f84\u6e05\u5386\u53f2\u6570\u636e\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_15", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealBidDing() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u5728\u7ebf\u6295\u6807\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_16", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id, bidproject, bidproject.id, bidproject.bidpublish, bidpublishid";
        DynamicObject[] bidDingArray = BusinessDataServiceHelper.load((String)"ten_bidding", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bidpublishid", "=", (Object)0).or(new QFilter("bidpublishid", "is null", null))});
        if (bidDingArray != null && bidDingArray.length > 0) {
            for (DynamicObject bidDing : bidDingArray) {
                DynamicObject publish;
                DynamicObject bidProject;
                boolean existPublish;
                DynamicObject bidProjectF7 = bidDing.getDynamicObject("bidproject");
                if (bidProjectF7 == null || !(existPublish = (bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)"bid_project")).getBoolean("bidpublish")) || (publish = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                bidDing.set("bidpublishid", publish.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])bidDingArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u5904\u7406\u5728\u7ebf\u6295\u6807\u5386\u53f2\u6570\u636e\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_17", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }

    public void dealInvitation() {
        BizLog.log((String)ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\u9080\u8bf7\u51fd\u5386\u53f2\u6570\u636e", (String)"HlbBidHistoryDataTask_18", (String)"scm-bid-business", (Object[])new Object[0]));
        String selectProperties = "id, bidproject, bidproject.id, bidproject.bidpublish, supplierinvitation";
        DynamicObject[] bidInvitationArray = BusinessDataServiceHelper.load((String)"bid_invitation", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("supplierinvitation", "=", (Object)0).or(new QFilter("supplierinvitation", "is null", null))});
        if (bidInvitationArray != null && bidInvitationArray.length > 0) {
            for (DynamicObject bidInvitation : bidInvitationArray) {
                DynamicObject supplierInvitation;
                DynamicObject bidProject = bidInvitation.getDynamicObject("bidproject");
                if (bidProject == null || (supplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProject.getLong("id"))})) == null) continue;
                bidInvitation.set("supplierinvitation", supplierInvitation.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])bidInvitationArray);
            BizLog.log((String)ResManager.loadKDString((String)"\u5904\u7406\u5904\u7406\u9080\u8bf7\u51fd\u5386\u53f2\u6570\u636e\u5b8c\u6bd5", (String)"HlbBidHistoryDataTask_19", (String)"scm-bid-business", (Object[])new Object[0]));
        }
    }
}

