/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.SendMessageUtil;
import kd.scm.bid.opplugin.bill.BidInvitationOperateServicePlugIn;

public class BidInvitationOperateServicePlugIn
extends AbstractOperationServicePlugIn {
    private static final String SEND = "send";
    private static final String UN_SEND = "unsend";
    private static final String SUBMIT_AUDIT = "submitaudit";
    protected IBidProjectService projectService = new BidProjectServiceImpl();
    protected ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("supplierentry");
        e.getFieldKeys().add("supplierentry.supplier");
        e.getFieldKeys().add("supplierentry.invitationstatus");
        e.getFieldKeys().add("supplierentry.projectpartner");
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("supplierinvitation");
        e.getFieldKeys().add("deadlinedate");
        e.getFieldKeys().add("releaseuser");
        e.getFieldKeys().add("releasestatus");
        e.getFieldKeys().add("publishdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        String key = e.getOperationKey();
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            if ("save".equals(key)) {
                data.set("enable", (Object)1L);
                continue;
            }
            if ("unaudit".equals(key)) {
                data.set("status", (Object)"A");
                data.set("releasestatus", null);
                continue;
            }
            if ("audit".equals(key)) {
                data.set("releasestatus", (Object)"U");
                continue;
            }
            if (SUBMIT_AUDIT.equals(key)) {
                data.set("releasestatus", (Object)"U");
                continue;
            }
            if (SEND.equals(key)) {
                this.send(data);
                continue;
            }
            if (!UN_SEND.equals(key)) continue;
            this.unSend(data);
        }
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        String key = e.getOperationKey();
        for (DynamicObject object : dataEntities = e.getDataEntities()) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u8c03\u8bd5@%1$s@%2$s@%3$s\u3002", (String)"BidInvitationOperateServicePlugIn_20", (String)"scm-bid-opplugin", (Object[])new Object[0]), key, object.getString("number"), object.getDynamicObjectCollection("supplierentry").size()));
        }
    }

    public void send(DynamicObject invitationData) {
        DynamicObject supplierInvitation;
        invitationData.set("releasestatus", (Object)"P");
        invitationData.set("releaseuser", (Object)RequestContext.get().getUserId());
        invitationData.set("publishdate", (Object)new Date());
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
        }
        DynamicObject invitationSupplierInvitation = invitationData.getDynamicObject("supplierInvitation");
        Object supplierInvitationId = null;
        if (invitationSupplierInvitation != null) {
            supplierInvitationId = invitationSupplierInvitation.getPkValue();
        }
        Object bidProjectId = invitationData.getDynamicObject("bidproject").getPkValue();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"entitytypeid");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        boolean isFromSupInv = true;
        if (null == supplierInvitationId) {
            supplierInvitation = BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (String)"id,bidsection,supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation,supplierentry.isrecommend,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
            isFromSupInv = false;
        } else {
            supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)(appId + "_supplierinvitation"), (String)"id,bidsection,supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation,supplierentry.isrecommend,supplierentry.projectpartner");
        }
        this.updatePartUser(supplierInvitation, invitationData);
        this.updateSupplierInvitation(appId, SEND, supplierInvitation, invitationData, isFromSupInv);
        this.updateBidProject(appId, SEND, invitationData, bidProjectId, isFromSupInv);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invitationData});
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public void updatePartUser(DynamicObject supplierInvitation, DynamicObject invitationData) {
        HashMap<String, DynamicObject> partUser = new HashMap<String, DynamicObject>();
        DynamicObjectCollection bidrollsection = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : bidrollsection) {
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject parter = row.getDynamicObject("projectpartner");
                DynamicObject supplier = row.getDynamicObject("supplier");
                if (supplier == null || parter == null) continue;
                partUser.put(supplier.getPkValue().toString(), parter);
            }
        }
        if (partUser.size() > 0) {
            DynamicObjectCollection supplierentry = invitationData.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                String supplerPk = row.getDynamicObject("supplier").getPkValue().toString();
                DynamicObject dynamicObject = (DynamicObject)partUser.get(supplerPk);
                row.set("projectpartner", (Object)dynamicObject);
            }
        }
    }

    public void unSend(DynamicObject invitationData) {
        invitationData.set("releasestatus", (Object)"U");
        invitationData.set("releaseuser", (Object)0);
        invitationData.set("publishdate", null);
        ArrayList<String> unSendSupplierIdList = new ArrayList<String>();
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            unSendSupplierIdList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
        }
        DynamicObject invitationSupplierInvitation = invitationData.getDynamicObject("supplierInvitation");
        Object supplierInvitationId = null;
        if (invitationSupplierInvitation != null) {
            supplierInvitationId = invitationSupplierInvitation.getPkValue();
        }
        Object bidProjectId = invitationData.getDynamicObject("bidproject").getPkValue();
        DynamicObject tempBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"entitytypeid");
        String appId = tempBidProject.getString("entitytypeid").split("_")[0];
        DynamicObject supplierInvitation = null == supplierInvitationId ? BusinessDataServiceHelper.loadSingle((String)(appId + "_supplierinvitation"), (String)"id,bidsection,bidsection.supplierentry,supplierentry.supplier,supplierentry.invitationstatus,supplierentry.invitation,supplierentry.isrecommend", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)}) : BusinessDataServiceHelper.loadSingle((Object)supplierInvitationId, (String)(appId + "_supplierinvitation"));
        DynamicObjectCollection bidSectionCollection = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCollection) {
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                if (!unSendSupplierIdList.contains(supplierId)) continue;
                supplierEntry.set("invitationstatus", (Object)"UNSEND");
                supplierEntry.set("invitation", (Object)0);
                supplierEntry.set("isrecommend", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.update((DynamicObject)supplierInvitation);
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(appId + "_project"));
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : bidSectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null || !unSendSupplierIdList.contains(supplier.getString("id"))) continue;
                supplierEntry.set("invitationstatus", (Object)"UNSEND");
            }
        }
        SaveServiceHelper.update((DynamicObject)bidProject);
        SaveServiceHelper.update((DynamicObject)invitationData);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4BidEvaluation(null));
    }

    protected void updateSupplierInvitation(String appId, String operateKey, DynamicObject supplierInvitation, DynamicObject invitationData, boolean isFromSupInv) {
        ArrayList<String> unSendSupplierIdList = new ArrayList<String>();
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (Object supplierEntry : supplierEntryCol) {
            unSendSupplierIdList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
        }
        DynamicObjectCollection bidSectionCol = supplierInvitation.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionCol) {
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                if (!unSendSupplierIdList.contains(supplierId)) continue;
                supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
                supplierEntry.set("invitation", invitationData.getPkValue());
                supplierEntry.set("isrecommend", (Object)Boolean.FALSE);
            }
        }
        SaveServiceHelper.update((DynamicObject)supplierInvitation);
        if (isFromSupInv) {
            boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
            if (!enable) {
                return;
            }
            new SendMessageUtil().sentInvitedMsg(appId, operateKey, invitationData.getPkValue(), supplierInvitation);
        }
    }

    protected void updateBidProject(String appId, String operateKey, DynamicObject invitationData, Object bidProjectId, boolean isFromSupInv) {
        ArrayList<String> unSendSupplierEntryList = new ArrayList<String>();
        DynamicObjectCollection supplierEntryCol = invitationData.getDynamicObjectCollection("supplierentry");
        for (DynamicObject supplierEntry : supplierEntryCol) {
            unSendSupplierEntryList.add(supplierEntry.getDynamicObject("supplier").getString("id"));
        }
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(appId + "_project"));
        DynamicObjectCollection bidSectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        for (DynamicObject sectionEntry : bidSectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (supplier == null || !unSendSupplierEntryList.contains(supplier.getString("id"))) continue;
                supplierEntry.set("invitationstatus", (Object)"UNCONFIRM");
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidProject});
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
        if (!isFromSupInv) {
            new SendMessageUtil().sendInvitationByBidProject(appId, operateKey, bidProjectId, invitationData.getPkValue());
        }
    }
}

