/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.opplugin.bill.OnlineBidEvalOperationServicePlugIn;

public class OnlineBidEvalOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("bidevaluationdate");
        e.getFieldKeys().add("evaltype");
        e.getFieldKeys().add("bidproject.bidopentype");
        e.getFieldKeys().add("bidproject.doctype");
        e.getFieldKeys().add("bidproject.entitytypeid");
        e.getFieldKeys().add("supplierinvitationid");
        e.getFieldKeys().add("evaluatedmethod");
        e.getFieldKeys().add("bidopenid");
        e.getFieldKeys().add("bidevaluator");
        e.getFieldKeys().add("bidopenid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new Validator4OnlineBidEval(this, null));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block3: {
            String key;
            block4: {
                block2: {
                    super.beginOperationTransaction(e);
                    key = e.getOperationKey();
                    if (!"save".equals(key)) break block2;
                    DynamicObject[] dynamicObjectArray = e.getDataEntities();
                    break block3;
                }
                if (!"submit".equals(key)) break block4;
                DynamicObject[] dataEntities = e.getDataEntities();
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntitie = dataEntities[i];
                    dataEntitie.set("bidevaluationdate", (Object)new Date());
                }
                break block3;
            }
            if (!"delete".equals(key)) break block3;
            for (DynamicObject dataEntity : e.getDataEntities()) {
                long bidOpenId = dataEntity.getLong("bidopenid");
                long onlineBidEvalId = dataEntity.getLong("id");
                DeleteServiceHelper.delete((String)"bid_onlinescoredetail", (QFilter[])new QFilter("onlinebideval", "=", (Object)onlineBidEvalId).toArray());
                DeleteServiceHelper.delete((String)"bid_onlinesupplierdetail", (QFilter[])new QFilter("onlinebideval", "=", (Object)onlineBidEvalId).toArray());
                DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                DynamicObject bidProjectLoad = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)bidProject.getDynamicObjectType().getName(), (String)"id,org");
                DynamicObject bidEvaluator = dataEntity.getDynamicObject("bidevaluator");
                this.onlineBidEvalService.createByLastStepWhenDelete(bidProjectLoad, bidEvaluator.getLong("id"), bidOpenId, "delete");
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block3: {
            DynamicObject[] dataEntities;
            String key;
            block2: {
                super.endOperationTransaction(e);
                key = e.getOperationKey();
                dataEntities = e.getDataEntities();
                if (!"audit".equals(key)) break block2;
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntitie = dataEntities[i];
                    DynamicObject bidProject = dataEntitie.getDynamicObject("bidproject");
                    String docType = bidProject.getString("doctype");
                    String evalType = dataEntitie.getString("evaltype");
                    String bidOpenSelectType = bidProject.getString("bidopentype");
                    evalType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType) ? BidOpenTypeEnum.BUSSINESS.getValue() : BidOpenTypeEnum.MULTI.getValue()) : dataEntitie.getString("evaltype");
                    this.onlineBidEvalService.updateBidEvaluationSupplierScore(bidProject, Long.valueOf(dataEntitie.getLong("id")), evalType);
                }
                break block3;
            }
            if (!"unaudit".equals(key)) break block3;
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
                Long onlineBidEvalId = dataEntity.getLong("id");
                String evalType = dataEntity.getString("evaltype");
                this.onlineBidEvalService.deleteBidEvaluationSupplierScore(bidProject, onlineBidEvalId, evalType);
            }
        }
    }
}

