/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.opplugin.bill;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyReplyStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidMessageUtil;
import kd.scm.bid.opplugin.bill.QuestionClarifyOP;

public class QuestionClarifyOP
extends AbstractOperationServicePlugIn {
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    private static final String KEY_ADJUSTDEADLINE = "tbl_adjustdeadline";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("clarifysupplier");
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("supplierdetail");
        e.getFieldKeys().add("clarifydeadline");
        e.getFieldKeys().add("clarifytheme");
        e.getFieldKeys().add("rate");
        e.getFieldKeys().add("opentype");
        e.getFieldKeys().add("workday");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("resubmisstenders");
        e.getFieldKeys().add("clarifytype");
        e.getFieldKeys().add("multiquestclarifyid");
        e.getFieldKeys().add("is_again_bidding");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorQuestionClarify(this, null));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block8: {
            String supplierName;
            DynamicObject data;
            String key;
            block7: {
                super.beginOperationTransaction(e);
                key = e.getOperationKey();
                DynamicObject[] datas = e.getDataEntities();
                data = datas[0];
                String clarifysupplier = data.getString("clarifysupplier");
                String[] values = clarifysupplier.split("&&");
                supplierName = values[1];
                if (!StringUtils.equals((CharSequence)"send", (CharSequence)key)) break block7;
                this.addBidSectionSupplierDetail(data);
                Date now = new Date();
                data.set("senddate", (Object)now);
                data.set("supplier", (Object)supplierName);
                data.set("is_again_bidding", (Object)"0");
                BigDecimal pricevat = data.getBigDecimal("pricevat");
                BigDecimal rate = data.getBigDecimal("rate");
                data.set("pricevat", (Object)pricevat.divide(new BigDecimal("100")));
                data.set("rate", (Object)rate.divide(new BigDecimal("100")));
                DynamicObjectCollection bidSectionColl = data.getDynamicObjectCollection("bidsection");
                if (bidSectionColl == null || bidSectionColl.size() <= 0) break block8;
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObjectCollection supplierdetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                    if (supplierdetail == null || supplierdetail.size() <= 0) continue;
                    for (int j = 0; j < supplierdetail.size(); ++j) {
                        ((DynamicObject)supplierdetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                        ((DynamicObject)supplierdetail.get(j)).set("costrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                    }
                }
                break block8;
            }
            if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
                String billstatus = data.getString("billstatus");
                data.set("supplier", (Object)supplierName);
                if (ClarifyStatusEnum.SUBMITTED.getValue().equals(billstatus) || ClarifyStatusEnum.UNSENT.getValue().equals(billstatus)) {
                    data.set("billstatus", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
                    data.set("replystatus", (Object)ClarifyReplyStatusEnum.B.getValue());
                }
                Date now = new Date();
                data.set("submitdate", (Object)now);
                data.set("is_again_bidding", (Object)"0");
                BigDecimal pricevat = data.getBigDecimal("pricevat");
                BigDecimal rate = data.getBigDecimal("rate");
                data.set("pricevat", (Object)pricevat.divide(new BigDecimal("100")));
                data.set("rate", (Object)rate.divide(new BigDecimal("100")));
                DynamicObjectCollection bidSectionColl = data.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (int i = 0; i < bidSectionColl.size(); ++i) {
                        DynamicObjectCollection supplierdetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                        if (supplierdetail == null || supplierdetail.size() <= 0) continue;
                        for (int j = 0; j < supplierdetail.size(); ++j) {
                            ((DynamicObject)supplierdetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                            ((DynamicObject)supplierdetail.get(j)).set("costrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                        }
                    }
                }
            }
        }
    }

    private void addBidSectionSupplierDetail(DynamicObject data) {
        DynamicObject bidProject = data.getDynamicObject("bidproject");
        try (TXHandle h = TX.requiresNew();){
            try {
                if ("rebm".equals(this.getAppId())) {
                    BidFileHelper.synFileFromAToB((String)"rebm_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel", (String)"resp_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel");
                } else {
                    BidFileHelper.synFileFromAToB((String)"bid_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel", (String)"ten_questionclarify", (Object)data.getPkValue(), (String)"clarifyattachpanel");
                }
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
        String opentype = data.getString("opentype");
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)opentype);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,bidsection,bidsection.sectionname,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidProjectFilter, openTypeFilter, statusFilter});
        String clarifysupplier = data.getString("clarifysupplier");
        String[] values = clarifysupplier.split("&&");
        Long supplierId = Long.parseLong(values[0]);
        String clarifySectionName = "";
        if (values.length == 3) {
            clarifySectionName = values[2];
        }
        Boolean reloadDetail = Boolean.TRUE;
        DynamicObjectCollection clarifybidsections = data.getDynamicObjectCollection("bidsection");
        if (clarifybidsections.size() > 0) {
            DynamicObject supplierdetail;
            long currentSupplierId;
            DynamicObject clarifybidsection = (DynamicObject)clarifybidsections.get(0);
            String currentSection = clarifybidsection.getString("sectionname");
            if ((StringUtils.isEmpty((CharSequence)clarifySectionName) || clarifySectionName.equals(currentSection)) && supplierId.equals(currentSupplierId = ((Long)(supplierdetail = (DynamicObject)clarifybidsection.getDynamicObjectCollection("supplierdetail").get(0)).getDynamicObject("pursupplier").getPkValue()).longValue())) {
                reloadDetail = Boolean.FALSE;
            }
        }
        if (reloadDetail.booleanValue()) {
            data.getDynamicObjectCollection("bidsection").clear();
            DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
            boolean enablemultisection = bidProject.getBoolean("enablemultisection");
            for (int i = 0; i < bidsectioncoll.size(); ++i) {
                DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
                String sectionName = bidsection.getString("sectionname");
                int k = 1;
                if (enablemultisection && !clarifySectionName.equals(sectionName)) continue;
                DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
                DynamicObject clarifyBidsection = data.getDynamicObjectCollection("bidsection").addNew();
                clarifyBidsection.set("seq", (Object)k++);
                clarifyBidsection.set("sectionname", (Object)sectionName);
                DynamicObjectCollection clarifySupplierDetailColl = clarifyBidsection.getDynamicObjectCollection("supplierdetail");
                int index = 1;
                for (int j = 0; j < supplierDetail.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                    DynamicObject pursupplier = supplierentry.getDynamicObject("pursupplier");
                    if (!supplierId.equals(pursupplier.getPkValue())) continue;
                    DynamicObject newSupplierDetail = clarifySupplierDetailColl.addNew();
                    newSupplierDetail.set("pursupplier", supplierentry.get("pursupplier"));
                    newSupplierDetail.set("seq", (Object)index++);
                    newSupplierDetail.set("purentrycontent", supplierentry.get("purentrycontent"));
                    newSupplierDetail.set("purentryproject", supplierentry.get("purentryproject"));
                    newSupplierDetail.set("materialid", supplierentry.get("materialid"));
                    newSupplierDetail.set("materialdes", supplierentry.get("materialdes"));
                    newSupplierDetail.set("qty", supplierentry.get("qty"));
                }
            }
        }
        this.sendMessage(data, bidProject, supplierId);
    }

    public void sendMessage(DynamicObject data, DynamicObject bidProject, Long supplierId) {
        BidMessageUtil.sendMsgByQuestionClarify((DynamicObject)data, (DynamicObject)bidProject, (Long)supplierId, (String)this.getAppId());
    }

    public String getAppId() {
        String appName = this.billEntityType.getAppId();
        return appName;
    }
}

