/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.basedata.specialperm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.scm.bid.common.util.BidDynamicObjectUtil;

public class BidSpecialPermListPlugin
extends AbstractListPlugin {
    private static final String IMPORT_ROLE = "importrole";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        String entityName = this.getAppId() + "_special_perm";
        qFilterList.add(new QFilter("entitytypeid", "=", (Object)entityName));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                List roleIdList;
                DynamicObject[] permRoleArray;
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (!rows.isEmpty() && (permRoleArray = BusinessDataServiceHelper.load((String)"perm_role", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIdList = rows.stream().map(item -> item.getString("permroleid")).collect(Collectors.toList()))})) != null && permRoleArray.length > 0) {
                    Map<String, String> enableMap = Arrays.stream(permRoleArray).collect(Collectors.toMap(item -> item.getString("id"), item -> item.getString("enable")));
                    for (DynamicObject row : rows) {
                        String permRoleId = row.getString("permroleid");
                        String enable = enableMap.getOrDefault(permRoleId, "0");
                        row.set("enable", (Object)enable);
                        row.set("remark", (Object)ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u53ef\u67e5\u770b\u62db\u6807\u7ba1\u7406\u6388\u6743\u7ec4\u7ec7\u4e0b\u6240\u6709\u62db\u6807\u4e1a\u52a1\u3002", (String)"BidSpecialPermListPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
                return rows;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (IMPORT_ROLE.equals(operateKey)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(IMPORT_ROLE, (IFormPlugin)this);
            String tip = ResManager.loadKDString((String)"\u62db\u6807\u7ba1\u7406\u5458\u53ea\u548c\u4eba\u5458\u5173\u8054\uff0c\u5f15\u5165\u540e\uff0c\u53ea\u8981\u4eba\u5458\u7ed1\u5b9a\u4e86\u8be5\u89d2\u8272\uff0c\u5176\u6388\u6743\u7ec4\u7ec7\u4e0b\u80fd\u67e5\u770b\u6240\u6709\u62db\u6807\u4e1a\u52a1\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"BidSpecialPermListPlugin_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(null, tip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)id, (CharSequence)IMPORT_ROLE) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"perm_role", (boolean)true);
            listShowParameter.setHasRight(true);
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            List qFilterList = listFilterParameter.getQFilters();
            qFilterList.add(new QFilter("id", "not in", (Object)new String[]{"/V6OAY0JH+8R", "/IUL4BYKHET4"}));
            qFilterList.add(new QFilter("group", "=", (Object)"0M4H737GQUEF"));
            listShowParameter.setListFilterParameter(listFilterParameter);
            TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
            List treeQFilterList = treeFilterParameter.getQFilters();
            treeQFilterList.add(new QFilter("id", "=", (Object)"0M4H737GQUEF"));
            listShowParameter.setTreeFilterParameter(treeFilterParameter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_ROLE));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (IMPORT_ROLE.equals(actionId)) {
            String appId = this.getAppId();
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
            if (selectedRows == null || selectedRows.size() == 0) {
                return;
            }
            if (selectedRows.size() > 200) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6027\u5f15\u5165\u4e0d\u80fd\u8d85\u8fc7200\u6761\u6570\u636e\u3002", (String)"BidSpecialPermListPlugin_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows != null && selectedRows.size() > 0) {
                ArrayList<Object> pkValueList = new ArrayList<Object>();
                for (ListSelectedRow listSelectedRow : selectedRows) {
                    pkValueList.add(listSelectedRow.getPrimaryKeyValue());
                }
                this.saveOrUpdateData(appId, pkValueList);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f\u3002", (String)"BidSpecialPermListPlugin_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void saveOrUpdateData(String appId, List<Object> pkValueList) {
        String entityName = appId + "_special_perm";
        DynamicObject[] bidSpecialPermArray = BusinessDataServiceHelper.load((String)entityName, (String)BidDynamicObjectUtil.getSelectProperties((String)entityName), (QFilter[])new QFilter[]{new QFilter("permroleid", "in", pkValueList)});
        Map<Object, Object> bidSpecialPermMap = new HashMap();
        if (bidSpecialPermArray != null && bidSpecialPermArray.length > 0) {
            bidSpecialPermMap = Arrays.stream(bidSpecialPermArray).collect(Collectors.toMap(item -> item.getString("permroleid"), item -> item));
        }
        DynamicObject[] permRoleArray = BusinessDataServiceHelper.load((String)"perm_role", (String)BidDynamicObjectUtil.getSelectProperties((String)"perm_role"), (QFilter[])new QFilter[]{new QFilter("id", "in", pkValueList)});
        DynamicObject bidSpecialPerm = null;
        ArrayList<DynamicObject> saveBidSpecialPermList = new ArrayList<DynamicObject>(16);
        for (DynamicObject permRole : permRoleArray) {
            String permRoleId = permRole.getString("id");
            bidSpecialPerm = bidSpecialPermMap.getOrDefault(permRoleId, BusinessDataServiceHelper.newDynamicObject((String)entityName));
            bidSpecialPerm.set("permroleid", permRole.get("id"));
            bidSpecialPerm.set("number", (Object)permRole.getString("number"));
            bidSpecialPerm.set("name", (Object)permRole.getString("name"));
            bidSpecialPerm.set("group", permRole.get("group"));
            bidSpecialPerm.set("bizdomain", permRole.get("bizdomain"));
            bidSpecialPerm.set("enable", permRole.get("enable"));
            bidSpecialPerm.set("entitytypeid", (Object)entityName);
            bidSpecialPerm.set("remark", (Object)ResManager.loadKDString((String)"\u8be5\u89d2\u8272\u53ef\u67e5\u770b\u62db\u6807\u7ba1\u7406\u6388\u6743\u7ec4\u7ec7\u4e0b\u6240\u6709\u62db\u6807\u4e1a\u52a1\u3002", (String)"BidSpecialPermListPlugin_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            saveBidSpecialPermList.add(bidSpecialPerm);
        }
        SaveServiceHelper.save((DynamicObject[])saveBidSpecialPermList.toArray(new DynamicObject[0]));
    }

    protected String getAppId() {
        return this.getView().getFormShowParameter().getServiceAppId();
    }
}

