/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidPubStrategyEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.sdk.annotation.SdkDeprecated;

public class BidBillEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    protected String BID_PROJECT = "bidproject";
    protected String ENABLE_MULTI_SECTION = "enablemultisection";
    protected String SUPPLIER_TOOLBAR = "suppliertoolbarap";
    protected String DEL_SUPPLIER_BTN = "delsupplier";
    protected String ADD_SUPPLIER_BTN = "addsupplier";
    protected String SECTION_ENTRY_ENTITY = "bidsection";
    protected String SUPPLIER_ENTRY_ENTITY = "supplierentry";
    protected String SUPPLIERENROLLENTRY = "supplierenrollentry";
    protected String ADD_SUPPLIER_ACTION_ID = "addsupplier";
    protected static final String NEW_SUPPLIER_BACKGROUND_COLOUR = "#ffffdd";
    protected static final Map<String, String> savePartnerMap = new HashMap<String, String>();

    public void initialize() {
        super.initialize();
    }

    protected boolean needHandleSection() {
        return true;
    }

    protected boolean isSingleSection() {
        DynamicObject bidProject = this.getModel().getDataEntity().getDynamicObject(this.BID_PROJECT);
        if (bidProject != null) {
            return !bidProject.getBoolean(this.ENABLE_MULTI_SECTION);
        }
        return false;
    }

    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        if (this.needHandleSection()) {
            this.setEnableMultiSection(!this.isSingleSection());
        }
        if (this.needFlagNewSupplier()) {
            this.updateBackCroundColour();
        }
    }

    protected String getSectionSplitContainer() {
        return "sectionsplitcontainer";
    }

    protected void setEnableMultiSection(boolean enableMultiSec) {
        SplitContainer splitContainer = (SplitContainer)this.getControl(this.getSectionSplitContainer());
        if (splitContainer != null) {
            if (enableMultiSec) {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
            this.setSingleSectionStatus();
        }
    }

    protected void setSingleSectionStatus() {
        this.seleteFirstSection();
    }

    protected void seleteFirstSection() {
        EntryGrid section = (EntryGrid)this.getControl(this.SECTION_ENTRY_ENTITY);
        DynamicObjectCollection sectionCols = this.getModel().getEntryEntity(this.SECTION_ENTRY_ENTITY);
        if (sectionCols.size() > 0) {
            section.selectRows(0);
        }
    }

    protected DynamicObject getSingleSection() {
        DynamicObjectCollection sectionCols = this.getModel().getEntryEntity(this.SECTION_ENTRY_ENTITY);
        if (sectionCols.size() > 0) {
            return (DynamicObject)sectionCols.get(0);
        }
        return null;
    }

    public void registerListener(EventObject eventObject) {
        SubEntryGrid supplierenrollentry;
        SubEntryGrid subEntryGrid;
        BasedataEdit supplierCtrl;
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.SECTION_ENTRY_ENTITY);
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((supplierCtrl = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplierCtrl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((subEntryGrid = (SubEntryGrid)this.getView().getControl(this.SUPPLIER_ENTRY_ENTITY)) != null) {
            subEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((supplierenrollentry = (SubEntryGrid)this.getView().getControl(this.SUPPLIERENROLLENTRY)) != null) {
            supplierenrollentry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    @SdkDeprecated
    public void entryRowClick(RowClickEvent rowclickevent) {
        super.entryRowClick(rowclickevent);
        EntryGrid entryGrid = (EntryGrid)rowclickevent.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (this.SECTION_ENTRY_ENTITY.equals(entryKey) && this.needFlagNewSupplier()) {
            this.updateBackCroundColour();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("newsupplierentry".equals(key)) {
            this.showBDSupplierForm();
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        IDataModel dataModel = this.getModel();
        String billName = dataModel.getDataEntityType().getName();
        String bustalkBillName = FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass());
        String bidOpenBillName = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
        String bidDecisionBillName = FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass());
        String bidPublishBillName = FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass());
        if ((StringUtils.equals((CharSequence)bidOpenBillName, (CharSequence)billName) || StringUtils.equals((CharSequence)bidDecisionBillName, (CharSequence)billName) || StringUtils.equals((CharSequence)bustalkBillName, (CharSequence)billName) || StringUtils.equals((CharSequence)bidPublishBillName, (CharSequence)billName)) && StringUtils.equals((CharSequence)this.SUPPLIER_ENTRY_ENTITY, (CharSequence)e.getEntryProp().getName())) {
            DynamicObject dataEntity = dataModel.getDataEntity(true);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.SECTION_ENTRY_ENTITY);
            AbstractGrid.GridState entryState = entryGrid.getEntryState();
            int focusRow = entryState.getFocusRow();
            DynamicObjectCollection sectionEntryCollection = dataEntity.getDynamicObjectCollection(this.SECTION_ENTRY_ENTITY);
            String selectSectionName = ((DynamicObject)sectionEntryCollection.get(focusRow)).getString("sectionname");
            DynamicObjectCollection thisBidSection = dataEntity.getDynamicObjectCollection("bidsection");
            String supplierId = "";
            if (supplierId != null) {
                for (DynamicObject bidSection : thisBidSection) {
                    boolean enable;
                    DynamicObject purSupplier;
                    Iterator it;
                    if (!StringUtils.equals((CharSequence)selectSectionName, (CharSequence)bidSection.getString("sectionname"))) continue;
                    int[] rowIndexs = e.getRowIndexs();
                    int rowIndex = rowIndexs[0];
                    DynamicObjectCollection supplierEntryS = bidSection.getDynamicObjectCollection(this.SUPPLIER_ENTRY_ENTITY);
                    DynamicObject supplierRow = ((DynamicObject)supplierEntryS.get(rowIndex)).getDynamicObject("supplier");
                    if (supplierRow == null || (supplierId = supplierRow.getPkValue().toString()).equals("")) continue;
                    if (StringUtils.equals((CharSequence)bidOpenBillName, (CharSequence)billName) || StringUtils.equals((CharSequence)bustalkBillName, (CharSequence)billName)) {
                        DynamicObjectCollection supplierDetailColl = bidSection.getDynamicObjectCollection("supplierdetail");
                        it = supplierDetailColl.iterator();
                        while (it.hasNext()) {
                            purSupplier = ((DynamicObject)it.next()).getDynamicObject("pursupplier");
                            if (!StringUtils.equals((CharSequence)supplierId, (CharSequence)purSupplier.getPkValue().toString())) continue;
                            it.remove();
                        }
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)bidDecisionBillName, (CharSequence)billName)) {
                        DynamicObjectCollection supfinaldetailColl = bidSection.getDynamicObjectCollection("supfinaldetail");
                        it = supfinaldetailColl.iterator();
                        while (it.hasNext()) {
                            purSupplier = ((DynamicObject)it.next()).getDynamicObject("lpursupplier");
                            if (!StringUtils.equals((CharSequence)supplierId, (CharSequence)purSupplier.getPkValue().toString())) continue;
                            it.remove();
                        }
                        DynamicObjectCollection supbackdetailColl = bidSection.getDynamicObjectCollection("supbackdetail");
                        Iterator ite = supbackdetailColl.iterator();
                        while (ite.hasNext()) {
                            DynamicObject purSupplier2 = ((DynamicObject)ite.next()).getDynamicObject("pursupplier");
                            if (!StringUtils.equals((CharSequence)supplierId, (CharSequence)purSupplier2.getPkValue().toString())) continue;
                            ite.remove();
                        }
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)bidPublishBillName, (CharSequence)billName) || !(enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable")) && enable || !((DynamicObject)supplierEntryS.get(rowIndex)).getBoolean("isfromhistory")) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u4f9b\u5e94\u5546\u662f\u7531\u5386\u53f2\u53d1\u6807\u6570\u636e\u5e26\u5165\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidBillEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && this.ADD_SUPPLIER_ACTION_ID.equals(actionId)) {
            this.addSupplier(closedCallBackEvent);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        if ("rebm".equals(this.getAppId())) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            showParameter.setCustomParam("selectorgId", org.getPkValue());
        }
    }

    public DynamicObjectType getEntryDynamicObjectType(String parentBillId, String entryId) {
        MainEntityType parentDT = EntityMetadataCache.getDataEntityType((String)parentBillId);
        DynamicObject parent = new DynamicObject((DynamicObjectType)parentDT);
        DynamicObjectCollection entryCol = null;
        entryCol = "bid_project".equals(parentBillId) ? parent.getDynamicObjectCollection("bidrollsection") : parent.getDynamicObjectCollection("bidsection");
        DynamicObjectType entryDT = entryCol.getDynamicObjectType();
        DynamicObject entry = new DynamicObject(entryDT);
        DynamicObjectType subDT = entry.getDynamicObjectCollection(entryId).getDynamicObjectType();
        return subDT;
    }

    public String getBillId() {
        return "";
    }

    protected boolean needHandleSupplier() {
        return false;
    }

    protected boolean needFlagNewSupplier() {
        return false;
    }

    protected boolean needContact() {
        return false;
    }

    protected boolean needSupplierStatisticInfo() {
        return false;
    }

    protected void showBDSupplierForm() {
        DynamicObjectCollection supplierCollection = this.getModel().getEntryEntity(this.SUPPLIER_ENTRY_ENTITY);
        int originSupplierQty = supplierCollection == null ? 0 : supplierCollection.size();
        ArrayList<Object> pkids = new ArrayList<Object>();
        for (int i = 0; i < originSupplierQty; ++i) {
            DynamicObject supplier;
            DynamicObject supplierEntry = (DynamicObject)supplierCollection.get(i);
            if (supplierEntry == null || (supplier = supplierEntry.getDynamicObject("supplier")) == null) continue;
            pkids.add(supplier.getPkValue());
        }
        ListShowParameter para = null;
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if ("rebm".equals(this.getAppId())) {
            para = ShowFormHelper.createShowListForm((String)"resm_official_supplier", (boolean)true);
            para.setCustomParam("selectorgId", org.getPkValue());
        } else {
            para = ShowFormHelper.createShowListForm((String)"bd_supplier", (boolean)true);
            para.setShowFrequent(true);
        }
        para.setShowUsed(true);
        para.setShowQuickFilter(true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (pkids != null && pkids.size() > 0) {
            qFilters.add(new QFilter("id", "not in", pkids));
        }
        if ("rebm".equals(this.getAppId())) {
            DynamicObject bidProject;
            DynamicObjectCollection supplierGroupCol;
            DynamicObject bidProjectF7 = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
            if (bidProjectF7 != null && !CollectionUtils.isEmpty((Collection)(supplierGroupCol = (bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)"rebm_project", (String)"suppliergroup")).getDynamicObjectCollection("suppliergroup")))) {
                ArrayList<Object> supplierGroupIdList = new ArrayList<Object>();
                for (DynamicObject supplierGroup : supplierGroupCol) {
                    DynamicObject groupBaseData = supplierGroup.getDynamicObject("fbasedataid");
                    if (groupBaseData == null) continue;
                    supplierGroupIdList.add(groupBaseData.getPkValue());
                }
                para.setCustomParam("selectGroupId", supplierGroupIdList);
            }
            para.setCustomParam("isIncludeBlack", (Object)Boolean.FALSE);
        } else {
            para.setCustomParam("groupStandard", (Object)716529547008326656L);
            para.setUseOrgId(org.getLong("id"));
        }
        qFilters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDITED.getVal()));
        qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        para.getListFilterParameter().setQFilters(qFilters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.ADD_SUPPLIER_ACTION_ID);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    protected void addSupplier(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection supplierList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        IDataModel dataModel = this.getModel();
        DynamicObject billObject = dataModel.getDataEntity(true);
        HashMap<String, DynamicObject> supplierMap = new HashMap<String, DynamicObject>();
        int supplierCount = dataModel.getEntryRowCount(this.SUPPLIER_ENTRY_ENTITY);
        for (int i = 0; i < supplierCount; ++i) {
            DynamicObject supplierEntry = dataModel.getEntryRowEntity(this.SUPPLIER_ENTRY_ENTITY, i);
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            if (supplier == null || supplier.getPkValue() == null) continue;
            supplierMap.put(String.valueOf(supplier.getPkValue()), supplierEntry);
        }
        MainEntityType objType = null;
        objType = "rebm".equals(this.getAppId()) ? EntityMetadataCache.getDataEntityType((String)"resm_official_supplier") : EntityMetadataCache.getDataEntityType((String)"bd_supplier");
        String entityId = this.getView().getEntityId();
        HashMap<String, DynamicObject> partnerMap = new HashMap<String, DynamicObject>();
        if (savePartnerMap.get(entityId) != null) {
            String[] pageflag = savePartnerMap.get(entityId).split(",");
            DynamicObjectCollection bidrollsection = billObject.getDynamicObjectCollection(pageflag[0]);
            for (DynamicObject bidsection : bidrollsection) {
                DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection(pageflag[1]);
                for (DynamicObject viewRow : supplierentry) {
                    String pkValue = viewRow.getDynamicObject(pageflag[2]).getPkValue().toString();
                    DynamicObject projectpartner = viewRow.getDynamicObject("projectpartner");
                    partnerMap.put(pkValue, projectpartner);
                }
            }
        }
        for (int i = 0; i < supplierList.size(); ++i) {
            Boolean needflagnewsupplier;
            DynamicObject partner;
            ListSelectedRow supplierInfo = supplierList.get(i);
            Long id = (Long)supplierInfo.getPrimaryKeyValue();
            if (supplierMap.get(id.toString()) != null) continue;
            int newEntryRow = dataModel.createNewEntryRow(this.SUPPLIER_ENTRY_ENTITY);
            DynamicObject supplierEntry = dataModel.getEntryRowEntity(this.SUPPLIER_ENTRY_ENTITY, newEntryRow);
            supplierMap.put(id.toString(), supplierEntry);
            DynamicObject supplier = new DynamicObject((DynamicObjectType)objType);
            supplier.set("id", (Object)id);
            supplier.set("name", (Object)supplierInfo.getName());
            supplierEntry.set("supplier", (Object)supplier);
            supplierEntry.setParent((Object)billObject);
            this.carryInfosBySupplier(dataModel, id, supplierMap.size() - 1, supplierEntry);
            if (partnerMap.size() >= 1 && partnerMap.containsKey(id.toString()) && (partner = (DynamicObject)partnerMap.get(id.toString())) != null) {
                supplierEntry.set("projectpartner", (Object)partner);
                supplierEntry.set("suppliercontact", (Object)new LocaleString(partner.getString("username")));
                supplierEntry.set("contactphone", (Object)partner.getString("phone"));
                supplierEntry.set("email", (Object)partner.getString("email"));
            }
            if (partnerMap.size() >= 1 && partnerMap.containsKey(id.toString()) && (partner = (DynamicObject)partnerMap.get(id.toString())) != null) {
                supplierEntry.set("suppliercontact", (Object)new LocaleString(partner.getString("username")));
            }
            if (this.needFlagNewSupplier()) {
                supplierEntry.set("isnew", (Object)Boolean.TRUE);
                supplierEntry.set("isfromproject", (Object)Boolean.FALSE);
            }
            if ((needflagnewsupplier = (Boolean)this.getModel().getValue("needflagnewsupplier")) == null || !needflagnewsupplier.booleanValue()) {
                supplierEntry.set("isnew", (Object)Boolean.TRUE);
            }
            String billName = dataModel.getDataEntityType().getName();
            if (StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (CharSequence)billName) || StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (CharSequence)billName) || StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (CharSequence)billName)) {
                Control control1;
                Control control = this.getControl("commentdetail");
                if (control != null) {
                    this.getModel().setValue("commentdetail", (Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidBillEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
                }
                if ((control1 = this.getControl("purdetail")) != null) {
                    this.getModel().setValue("purdetail", (Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidBillEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), newEntryRow);
                    if (this.getControl("openonlinesynergy") != null && billObject.getBoolean("openonlinesynergy")) {
                        this.getModel().setValue("purdetail", null, newEntryRow);
                    }
                }
            }
            if (!StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (CharSequence)billName) && !StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (CharSequence)billName) && !StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (CharSequence)billName)) continue;
            this.createNewPurdetailEntry(dataModel, supplier);
        }
        if (this.needFlagNewSupplier()) {
            this.updateBackCroundColour();
        }
        this.getView().updateView(this.SUPPLIER_ENTRY_ENTITY);
    }

    private String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    protected void createNewPurdetailEntry(IDataModel dataModel, DynamicObject supplier) {
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        String billName = dataModel.getDataEntityType().getName();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.SECTION_ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        int focusRow = selectRows[0];
        DynamicObjectCollection sectionEntryCollection = dataEntity.getDynamicObjectCollection(this.SECTION_ENTRY_ENTITY);
        String selectSectionName = ((DynamicObject)sectionEntryCollection.get(focusRow)).getString("sectionname");
        Object bidProjectId = dataEntity.getDynamicObject("bidproject").getPkValue();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        DynamicObjectCollection bidProjectSection = bidProject.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection thisBidSection = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject projectSection : bidProjectSection) {
            for (DynamicObject thisSection : thisBidSection) {
                if (!StringUtils.equals((CharSequence)projectSection.getString("sectionname"), (CharSequence)thisSection.getString("sectionname")) || !StringUtils.equals((CharSequence)selectSectionName, (CharSequence)thisSection.getString("sectionname"))) continue;
                DynamicObjectCollection projectEntryColl = projectSection.getDynamicObjectCollection("projectentry");
                if (StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (CharSequence)billName) || StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()), (CharSequence)billName)) {
                    DynamicObjectCollection newSupplierDetails = thisSection.getDynamicObjectCollection("supplierdetail");
                    for (DynamicObject projectEntry : projectEntryColl) {
                        this.setSupplierdetail(newSupplierDetails, billName, supplier, projectEntry);
                    }
                    thisSection.set("supplierdetail", (Object)newSupplierDetails);
                }
                if (!StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (CharSequence)billName)) continue;
                MainEntityType bidDecisionType = EntityMetadataCache.getDataEntityType((String)"bid_decision");
                EntityType supbackdetailType = (EntityType)bidDecisionType.getAllEntities().get("supbackdetail");
                EntityType supfinaldetailType = (EntityType)bidDecisionType.getAllEntities().get("supfinaldetail");
                DynamicObjectCollection newBackDetails = thisSection.getDynamicObjectCollection("supbackdetail");
                DynamicObjectCollection newFinalDetails = thisSection.getDynamicObjectCollection("supfinaldetail");
                for (DynamicObject projectEntry : projectEntryColl) {
                    DynamicObject newBackDetail = newBackDetails.addNew();
                    DynamicObject newFinalDetail = newFinalDetails.addNew();
                    newBackDetail.set("pursupplier", (Object)supplier);
                    newBackDetail.set("purentrycontent", projectEntry.get("purentrycontent"));
                    newBackDetail.set("purentryproject", projectEntry.get("purentryproject"));
                    newBackDetail.set("materialid", projectEntry.get("materialid"));
                    newBackDetail.set("baseunit", projectEntry.get("baseunit"));
                    newBackDetail.set("materialdes", projectEntry.get("materialdes"));
                    newBackDetail.set("qty", projectEntry.get("qty"));
                    if ("rebm".equals(this.getAppId())) {
                        newBackDetail.set("listnumber", projectEntry.get("listnumber"));
                        newBackDetail.set("listname", projectEntry.get("listname"));
                        newBackDetail.set("resourceitem", projectEntry.get("resourceitem"));
                    }
                    newFinalDetail.set("lpursupplier", (Object)supplier);
                    newFinalDetail.set("lpurentrycontent", projectEntry.get("purentrycontent"));
                    newFinalDetail.set("lpurentryproject", projectEntry.get("purentryproject"));
                    newFinalDetail.set("lmaterialid", projectEntry.get("materialid"));
                    newFinalDetail.set("lbaseunit", projectEntry.get("baseunit"));
                    newFinalDetail.set("lmaterialdes", projectEntry.get("materialdes"));
                    newFinalDetail.set("lqty", projectEntry.get("qty"));
                    if (!"rebm".equals(this.getAppId())) continue;
                    newFinalDetail.set("llistnumber", projectEntry.get("listnumber"));
                    newFinalDetail.set("llistname", projectEntry.get("listname"));
                    newFinalDetail.set("lresourceitem", projectEntry.get("resourceitem"));
                }
                thisSection.set("supbackdetail", (Object)newBackDetails);
                thisSection.set("supfinaldetail", (Object)newFinalDetails);
            }
        }
    }

    public void setSupplierdetail(DynamicObjectCollection newSupplierDetails, String billName, DynamicObject supplier, DynamicObject projectEntry) {
        DynamicObject newSupplierDetail = newSupplierDetails.addNew();
        newSupplierDetail.set("pursupplier", (Object)supplier);
        newSupplierDetail.set("purentrycontent", projectEntry.get("purentrycontent"));
        newSupplierDetail.set("purentryproject", projectEntry.get("purentryproject"));
        newSupplierDetail.set("materialid", projectEntry.get("materialid"));
        newSupplierDetail.set("baseunit", projectEntry.get("baseunit"));
        newSupplierDetail.set("materialdes", projectEntry.get("materialdes"));
        newSupplierDetail.set("qty", projectEntry.get("qty"));
        if ("rebm".equals(this.getAppId())) {
            newSupplierDetail.set("listnumber", projectEntry.get("listnumber"));
            newSupplierDetail.set("listname", projectEntry.get("listname"));
            newSupplierDetail.set("resourceitem", projectEntry.get("resourceitem"));
        }
    }

    protected void carryInfosBySupplier(IDataModel dataModel, Long bdSupplierId, int rowIndex, DynamicObject supplierEntry) {
        boolean invitationStatusFlag;
        String sourcePublish;
        Boolean needflagnewsupplier;
        String parentFormId = this.getModel().getDataEntityType().toString();
        if (this.needContact()) {
            QFilter[] qFilterArr;
            DynamicObject[] bdAddressInfo;
            DynamicObject bizpartner;
            DynamicObject syssupplier;
            boolean emailAddressFaxFlag;
            DynamicObject supplierInfo = null;
            Long bdSupplierIdTemp = bdSupplierId;
            boolean bl = emailAddressFaxFlag = parentFormId != null && !parentFormId.equals(FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass())) && !parentFormId.equals(FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass())) && !parentFormId.equals(FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
            if ("rebm".equals(this.getAppId()) && (syssupplier = (supplierInfo = BusinessDataServiceHelper.loadSingle((Object)bdSupplierId, (String)"resm_official_supplier", (String)"syssupplier")).getDynamicObject("syssupplier")) != null) {
                bdSupplierIdTemp = syssupplier.getLong("id");
            }
            if ((bizpartner = (supplierInfo = BusinessDataServiceHelper.loadSingle((Object)bdSupplierIdTemp, (String)"bd_supplier", (String)"bizpartner")).getDynamicObject("bizpartner")) != null) {
                QFilter qFilter = new QFilter("bizpartner", "=", bizpartner.getPkValue());
                qFilter.and("enable", "=", (Object)true);
                StringJoiner joiner = new StringJoiner(",");
                joiner.add("user");
                joiner.add("user.name");
                joiner.add("user.phone");
                joiner.add("user.email");
                joiner.add("enable");
                joiner.add("isadmin");
                DynamicObject[] bizpartneruserArr = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)joiner.toString(), (QFilter[])qFilter.toArray());
                if (bizpartneruserArr.length > 0) {
                    DynamicObject[] dynamicObjectArray = bizpartneruserArr;
                    int n = dynamicObjectArray.length;
                    for (int i = 0; i < n; ++i) {
                        DynamicObject user;
                        DynamicObject bizpartneruser = dynamicObjectArray[i];
                        Boolean isadmin = bizpartneruser.getBoolean("isadmin");
                        if (!isadmin.booleanValue() || (user = bizpartneruser.getDynamicObject("user")) == null) continue;
                        supplierEntry.set("suppliercontact", (Object)user.getString("name"));
                        supplierEntry.set("contactphone", (Object)user.getString("phone"));
                        if (supplierEntry.getDynamicObjectType().getProperty("email") == null) continue;
                        supplierEntry.set("email", (Object)user.getString("email"));
                    }
                }
            }
            if (emailAddressFaxFlag && (bdAddressInfo = BusinessDataServiceHelper.load((String)"bd_address", (String)"number,name,detailaddress,invalid,default", (QFilter[])(qFilterArr = new QFilter[]{new QFilter("supplierid", "=", (Object)bdSupplierIdTemp.toString())}))) != null && bdAddressInfo.length > 0) {
                for (DynamicObject bdAddress : bdAddressInfo) {
                    Boolean invalid = bdAddress.getBoolean("invalid");
                    Boolean defaultAddress = bdAddress.getBoolean("default");
                    if (!invalid.booleanValue() || !defaultAddress.booleanValue()) continue;
                    supplierEntry.set("address", bdAddress.get("detailaddress"));
                }
            }
        }
        if (this.needSupplierStatisticInfo()) {
            SupplierStatisticServiceImpl suppStatService = new SupplierStatisticServiceImpl();
            String appId = this.getModel().getDataEntityType().getAppId();
            DynamicObject supplierStatistic = suppStatService.getSupplierStatistic(bdSupplierId, appId + "_supplierstatistic");
            supplierEntry.set("supplierstatistic", (Object)supplierStatistic);
        }
        if (this.needFlagNewSupplier()) {
            supplierEntry.set("isnew", (Object)Boolean.TRUE);
            supplierEntry.set("isfromproject", (Object)Boolean.FALSE);
        }
        if ((needflagnewsupplier = (Boolean)this.getModel().getValue("needflagnewsupplier")) == null || !needflagnewsupplier.booleanValue()) {
            supplierEntry.set("isnew", (Object)Boolean.TRUE);
        }
        String billName = dataModel.getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (CharSequence)billName) && !StringUtils.isEmpty((CharSequence)(sourcePublish = dataModel.getValue("sourcepublish").toString())) && !"0".equals(sourcePublish)) {
            supplierEntry.set("pubstrategy", (Object)BidPubStrategyEnum.PLUS.getValue());
        }
        boolean bl = invitationStatusFlag = parentFormId != null && parentFormId.equals(FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        if (invitationStatusFlag) {
            supplierEntry.set("invitationstatus", (Object)"UNSEND");
        }
    }

    protected void updateBackCroundColour() {
        DynamicObjectCollection supllierEntry = this.getModel().getEntryEntity(this.SUPPLIER_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(this.SUPPLIER_ENTRY_ENTITY);
        if (supllierEntry != null && supllierEntry.size() > 0) {
            ArrayList<Integer> isNewList = new ArrayList<Integer>();
            for (int i = 0; i < supllierEntry.size(); ++i) {
                DynamicObject supplier = (DynamicObject)supllierEntry.get(i);
                if (!supplier.getBoolean("isnew")) continue;
                isNewList.add(i);
            }
            int[] isNewRows = new int[isNewList.size()];
            for (int i = 0; i < isNewList.size(); ++i) {
                isNewRows[i] = (Integer)isNewList.get(i);
            }
            grid.setRowBackcolor(NEW_SUPPLIER_BACKGROUND_COLOUR, isNewRows);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        super.propertyChanged(propertychangedargs);
        if ("supplier".equals(propertychangedargs.getProperty().getName())) {
            ChangeData[] changeSet = propertychangedargs.getChangeSet();
            EntryGrid grid = (EntryGrid)this.getView().getControl(this.SUPPLIER_ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            if (changeSet != null && changeSet.length > 0 && selectRows.length > 0) {
                DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
                if (newValue != null) {
                    DynamicObject supplier = (DynamicObject)this.getModel().getEntryEntity("supplierentry").get(selectRows[0]);
                    this.carryInfosBySupplier(this.getModel(), (Long)newValue.getPkValue(), selectRows[0], supplier);
                    return;
                }
                if (changeSet[0].getOldValue() != null) {
                    DynamicObject oldValue = (DynamicObject)changeSet[0].getOldValue();
                    int rowIndex = changeSet[0].getRowIndex();
                    if (rowIndex != -1) {
                        DynamicObject supplier = (DynamicObject)this.getModel().getEntryEntity("supplierentry").get(selectRows[0]);
                        this.getModel().setValue("supplier", (Object)oldValue, rowIndex);
                        this.carryInfosBySupplier(this.getModel(), (Long)oldValue.getPkValue(), selectRows[0], supplier);
                    }
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("wonqty".equals(fieldName) || "enrollwonqty".equals(fieldName)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            long curOrgId = RequestContext.get().getOrgId();
            String appId = BidBillEdit.getAppId(this.getView(), formId);
            String pernNumber = "QXX1100";
            boolean hasPerm = BidBillEdit.checkPermission(pernNumber, curOrgId, appId, formId);
            if (!hasPerm) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u67e5\u770b\u4e2d\u6807\u8be6\u60c5\u6743\u9650\u3002", (String)"BidBillEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> otherParam = null;
            DynamicObject supplierstatisticInfo = null;
            int rowIndex = -1;
            if ("wonqty".equals(fieldName)) {
                otherParam = this.getSupplierEntrySupperId();
                rowIndex = this.getModel().getEntryCurrentRowIndex(this.SUPPLIER_ENTRY_ENTITY);
                supplierstatisticInfo = (DynamicObject)this.getModel().getValue("supplierstatistic", rowIndex);
            } else if ("enrollwonqty".equals(fieldName)) {
                otherParam = this.getSupplierEnrollEntrySupperId();
                rowIndex = this.getModel().getEntryCurrentRowIndex(this.SUPPLIERENROLLENTRY);
                supplierstatisticInfo = (DynamicObject)this.getModel().getValue("enrollsupplierstatistic", rowIndex);
            }
            if (rowIndex <= -1) {
                return;
            }
            if (supplierstatisticInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4e2d\u6807\u4fe1\u606f", (String)"BidBillEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            int wonqty = supplierstatisticInfo.getInt("wonqty");
            if (wonqty > 0) {
                IFormView view = this.getView();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                Object orgPkValue = org.getPkValue();
                otherParam.put("orgid", orgPkValue);
                this.viewBiddingDetails(view, otherParam);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4e2d\u6807\u4fe1\u606f", (String)"BidBillEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void viewBiddingDetails(IFormView view, Map<String, Object> otherParam) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        String billFormId = this.getOpenBillFormId();
        showParameter.setBillFormId(billFormId);
        showParameter.setCustomParams(otherParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getListFilterParameter().setSelectEntity("supplierentry");
        view.showForm((FormShowParameter)showParameter);
    }

    protected String getOpenBillFormId() {
        String split;
        String billFormId = "bid_decisionwinning";
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId != null && "rebm".equals(split = formId.split("_")[0])) {
            billFormId = "rebm_decisionwinning";
        }
        return billFormId;
    }

    public Map<String, Object> getSupplierEntrySupperId() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(this.SUPPLIER_ENTRY_ENTITY);
        DynamicObject supplierInfo = (DynamicObject)this.getModel().getValue("supplier", rowIndex);
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        if (supplierInfo != null) {
            otherParam.put("supperid", supplierInfo.getPkValue());
        }
        return otherParam;
    }

    public Map<String, Object> getSupplierEnrollEntrySupperId() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(this.SUPPLIERENROLLENTRY);
        DynamicObject supplierInfo = (DynamicObject)this.getModel().getValue("enrollsupplier", rowIndex);
        HashMap<String, Object> otherParam = new HashMap<String, Object>();
        if (supplierInfo != null) {
            otherParam.put("supperid", supplierInfo.getPkValue());
        }
        return otherParam;
    }

    public static String getAppId(IFormView iFormView, String entityNumber) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appNumber = iFormView.getFormShowParameter().getServiceAppId();
        String appid = null;
        if (appNumber != null && appNumber.trim().length() != 0) {
            try {
                appid = AppMetadataCache.getAppInfo((String)entityNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if (appid == null) {
            appid = met.getAppId();
        }
        return appid;
    }

    public static boolean checkPermission(String pernNumber, Long orgId, String appId, String entityNum) {
        QFilter[] filter = new QFilter[]{new QFilter("number", "=", (Object)pernNumber)};
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id,number", (QFilter[])filter);
        int hasPermission = 0;
        if (permissionObj != null) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String permItemId = permissionObj.get("id").toString();
            hasPermission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        }
        return hasPermission == 1;
    }

    static {
        savePartnerMap.put("bid_project", "bidrollsection,supplierentry,supplier");
        savePartnerMap.put("rebm_project", "bidrollsection,supplierentry,suppliername");
        savePartnerMap.put("bid_supplierinvitation", "bidsection,supplierentry,supplier");
        savePartnerMap.put("rebm_supplierinvitation", "bidsection,supplierentry,supplier");
    }
}

