/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.BizLog;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bidcenter.impl.BidCenterServiceImpl;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.IBidBustalkSupplierFileService;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IBidPublishService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPublishServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.util.BidBustalkUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;
import kd.scm.bid.formplugin.bill.util.SupplierInvalUtil;

public class BidBustalkEditUI
extends BidBillEdit
implements UploadListener,
CellClickListener {
    private IBidBustalkService bidBustalkService = new BidBustalkServiceImpl();
    private IBidBustalkSupplierFileService bidBustalkSupplierFileService = new BidBustalkSupplierFileServiceImpl();
    private IBidEvaluationService evaluationService = new BidEvaluationServiceImpl();
    private IBidPublishService publishService = new BidPublishServiceImpl();
    private ISupplierInvitationService supplierInvitationService = new SupplierInvitationServiceImpl();
    private BidBustalkUtil bidBustalkUtil = new BidBustalkUtil();
    private static final String OPENONLINESYNERGY = "openonlinesynergy";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String status = (String)this.getModel().getValue("billstatus");
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        String purdetailText = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidBustalkEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        DynamicObject bustalk = this.getModel().getDataEntity(true);
        boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            DynamicObjectCollection supplierentrys = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : supplierentrys) {
                supplierentry.set("purdetail", (Object)purdetailText);
                if (OperationStatus.VIEW.equals((Object)formStatus) || !"A".equals(status) && !"D".equals(status)) {
                    purdetailText = ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidBustalkEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                    supplierentry.set("purdetail", (Object)purdetailText);
                }
                boolean isOffer = supplierentry.getBoolean("isoffer");
                if (!openonlinesynergy) continue;
                String offerrecordText = ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidBustalkEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                if (isOffer) {
                    supplierentry.set("offerrecord", (Object)offerrecordText);
                    continue;
                }
                DynamicObject offerperson = supplierentry.getDynamicObject("offerperson");
                if (offerperson != null) {
                    supplierentry.set("offerrecord", (Object)offerrecordText);
                }
                supplierentry.set("purdetail", null);
            }
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
        DynamicObjectCollection bidSections = bustalk.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection supllierEntry = ((DynamicObject)bidSections.get(0)).getDynamicObjectCollection("supplierentry");
        this.changeEntryFieldColor(grid, supllierEntry);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
        if (bidSectionColl != null && bidSectionColl.size() > 0) {
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObjectCollection supplierColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierDetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                if (supplierColl != null && supplierColl.size() > 0) {
                    for (int j = 0; j < supplierColl.size(); ++j) {
                        ((DynamicObject)supplierColl.get(j)).set("taxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierColl.get(j)).set("newrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("newrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierColl.get(j)).set("uprate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("uprate").multiply(new BigDecimal("100")));
                    }
                }
                if (supplierDetail == null || supplierDetail.size() <= 0) continue;
                for (int m = 0; m < supplierDetail.size(); ++m) {
                    ((DynamicObject)supplierDetail.get(m)).set("staxrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("staxrate").multiply(new BigDecimal("100")));
                    ((DynamicObject)supplierDetail.get(m)).set("costrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                }
            }
        }
        this.getView().updateView("supplierentry");
    }

    private void changeEntryFieldColor(EntryGrid grid, DynamicObjectCollection supllierEntry) {
        DecimalFormat df = new DecimalFormat("0.00");
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(supllierEntry.size());
        for (int j = 0; j < supllierEntry.size(); ++j) {
            DynamicObject entry = (DynamicObject)supllierEntry.get(j);
            BigDecimal decline = entry.getBigDecimal("decline");
            String declineStr = df.format(decline.multiply(new BigDecimal("100")));
            declineStr = declineStr.replaceAll("-", "");
            CellStyle style = new CellStyle();
            style.setRow(j);
            style.setFieldKey("decline_back");
            if (decline.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("decline_back", (Object)(declineStr + "% \u2191"), j);
                style.setForeColor("#FD6C6A");
            } else if (decline.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue("decline_back", (Object)(declineStr + "% \u2193"), j);
                style.setForeColor("#18BC71");
            } else {
                this.getModel().setValue("decline_back", (Object)"0.00%", j);
                style.setForeColor("#000");
            }
            styles.add(style);
        }
        grid.setCellStyle(styles);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        entryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
        IDataModel operate = grid.getModel();
        DynamicObjectCollection supllierEntry = operate.getEntryEntity("supplierentry");
        this.changeEntryFieldColor(grid, supllierEntry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cellClick(CellClickEvent var1) {
        boolean isbustalk_operationip;
        int row = var1.getRow();
        if (row < 0) {
            return;
        }
        Long id = (Long)this.getModel().getValue("id");
        DynamicObject bustalk = this.getView().getModel().getDataEntity(true);
        EntryGrid grid = (EntryGrid)var1.getSource();
        IDataModel operate = grid.getModel();
        DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
        String supplierid = supplier.getString("id");
        IDataModel operation = this.getModel();
        operation.setEntryCurrentRowIndex("bidsection", this.getModel().getEntryCurrentRowIndex("bidsection"));
        int currentSupplierIndex = operation.getEntryCurrentRowIndex("supplierentry");
        DynamicObject supEntry = this.getModel().getEntryRowEntity("supplierentry", row);
        String supplierEntryid = supEntry.getPkValue().toString();
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
        IDataModel sectionOperate = sectionGrid.getModel();
        int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
        DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
        String sectionId = sectionEntry.getString("id");
        String itemName = var1.getFieldKey();
        if ("purdetail".equals(itemName)) {
            boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
            Boolean isOffer = (Boolean)this.getModel().getValue("isoffer", currentSupplierIndex);
            if (openonlinesynergy && !isOffer.booleanValue()) {
                return;
            }
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bustalk.getDynamicObject("bidproject").getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            DynamicObjectCollection purAllDetails = sectionEntry.getDynamicObjectCollection("supplierdetail");
            MainEntityType bustalkType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            EntityType supplierDetailType = (EntityType)bustalkType.getAllEntities().get("supplierdetail");
            DynamicObjectCollection purDetails = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)sectionEntry);
            for (DynamicObject purDetail : purAllDetails) {
                DynamicObject pursupplierOb = purDetail.getDynamicObject("pursupplier");
                if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)pursupplierOb.getString("id"))) continue;
                purDetails.add((Object)purDetail);
            }
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            DynamicObject data = this.getModel().getDataEntity(true);
            String billStatus = data.getString("billStatus");
            if (billStatus.equals("A") || billStatus.equals("D")) {
                para.setStatus(OperationStatus.EDIT);
            } else {
                para.setStatus(OperationStatus.VIEW);
            }
            boolean isMaterialpur = bidProject.getBoolean("ismaterialpur");
            boolean isratebidding = bidProject.getBoolean("isratebidding");
            int bidType = bidProject.getInt("bidtype");
            Object isNew = supplierEntry.get("isnew");
            para.setFormId(FormTypeConstants.getFormConstant((String)"bustalk_purdetail", ((Object)((Object)this)).getClass()));
            para.setCustomParam("entryCurrentRowIndex", (Object)this.getModel().getEntryCurrentRowIndex("bidsection"));
            para.setCustomParam("billStatus", (Object)bustalk.getString("billstatus"));
            para.setCustomParam("supplierid", (Object)supplierid);
            para.setCustomParam("sectionId", (Object)sectionId);
            para.setCustomParam("purDetails", (Object)purDetails);
            para.setCustomParam("isMaterialpur", (Object)isMaterialpur);
            para.setCustomParam("isratebidding", (Object)isratebidding);
            para.setCustomParam("bidType", (Object)bidType);
            para.setCustomParam("currentSupplierIndex", (Object)currentSupplierIndex);
            para.setCustomParam("isNew", isNew);
            para.setCustomParam("id", (Object)id);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"bustalk_purdetail", ((Object)((Object)this)).getClass()));
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        } else if ("technology".equals(itemName) || "business".equals(itemName) || "otherfile".equals(itemName)) {
            String typeName = "techFile";
            if ("business".equals(itemName)) {
                typeName = "comFile";
            } else if ("otherfile".equals(itemName)) {
                typeName = "otherFile";
            }
            if (null == supplierEntryid || "0".equals(supplierEntryid)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
                EntityType supType = (EntityType)type.getAllEntities().get("supplierentry");
                supplierEntryid = ORM.create().genLongId((IDataEntityType)supType) + "";
                this.getModel().getEntryRowEntity("supplierentry", row).set("id", (Object)supplierEntryid);
            }
            DynamicObject file = this.bidBustalkSupplierFileService.getOneFileRecordByIds(Long.valueOf(Long.parseLong(supplierid)), Long.valueOf(Long.parseLong(supplierEntryid)), typeName, "id, status, sectionid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "bid_bustalk_file");
            OperationStatus status = null;
            String billstatus = bustalk.getString("billstatus");
            Boolean isOpenOnLine = (Boolean)this.getModel().getValue(OPENONLINESYNERGY);
            if (file == null) {
                if (!billstatus.equals(BillStatusEnum.SAVE.getVal()) && !billstatus.equals(BillStatusEnum.DISBEGIN.getVal())) return;
                if (isOpenOnLine.booleanValue()) {
                    return;
                }
                status = OperationStatus.ADDNEW;
            } else {
                String pkId = file.getString("id");
                map.put("pkId", pkId);
                status = billstatus.equals(BillStatusEnum.SAVE.getVal()) || billstatus.equals(BillStatusEnum.DISBEGIN.getVal()) ? (isOpenOnLine.booleanValue() ? OperationStatus.VIEW : OperationStatus.EDIT) : OperationStatus.VIEW;
            }
            FormShowParameter para = FormShowParameter.createFormShowParameter(map);
            para.setCustomParam("bidopenid", (Object)id);
            para.setCustomParam("sectionId", (Object)supplierEntryid);
            para.setCustomParam("supplierId", (Object)supplierid);
            para.setCustomParam("type", (Object)typeName);
            para.setCustomParam("clickFieldName", (Object)itemName);
            para.setCustomParam("clickRow", (Object)row);
            OpenStyle openStyle = para.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            para.setStatus(status);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "bid_bustalk_file");
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        }
        if (!"offerrecord".equals(itemName) || !(isbustalk_operationip = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"bustalk_operationip", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bustalkid.id", "=", (Object)Long.valueOf(bustalk.getPkValue().toString())), new QFilter("supplier.id", "=", (Object)Long.valueOf(supplierid))}))) return;
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(FormTypeConstants.getFormConstant((String)"bustalk_operationip", ((Object)((Object)this)).getClass()));
        para.setFormId("bos_list");
        OpenStyle openStyle = para.getOpenStyle();
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("500");
        styleCss.setWidth("1000");
        openStyle.setInlineStyleCss(styleCss);
        openStyle.setShowType(ShowType.Modal);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(new QFilter("bustalkid.id", "=", (Object)Long.valueOf(bustalk.getPkValue().toString())));
        qFilters.add(new QFilter("supplier.id", "=", (Object)Long.valueOf(supplierid)));
        para.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)para);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        BigDecimal newPrice;
        FormShowParameter formShowParameter;
        String customParam;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("judge".equals(actionId) && StringUtils.isNotEmpty((CharSequence)(customParam = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("BidCenter")))) {
            IFormView parentView = this.getView().getParentView();
            String opKey = "bidbustalk";
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            parentView.getModel().setValue("markcurrent", (Object)(opKey + "#" + uuid));
            this.getView().sendFormAction(parentView);
        }
        if (FormTypeConstants.getFormConstant((String)"bustalk_purdetail", ((Object)((Object)this)).getClass()).equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Object[] resultObject = (Object[])closedCallBackEvent.getReturnData();
            HashMap resultMap = (HashMap)resultObject[0];
            String appId = this.getModel().getDataEntityType().getAppId();
            int entryCurrentRowIndex = (Integer)resultMap.get("entryCurrentRowIndex");
            String supplierid = (String)resultMap.get("supplierid");
            ArrayList resultList = (ArrayList)resultMap.get("resultList");
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            model.setEntryCurrentRowIndex("bidsection", entryCurrentRowIndex);
            DynamicObject currencySection = model.getEntryRowEntity("bidsection", entryCurrentRowIndex);
            DynamicObjectCollection parentPurDetails = currencySection.getDynamicObjectCollection("supplierdetail");
            DynamicObjectCollection parentPurEntrys = currencySection.getDynamicObjectCollection("supplierentry");
            BigDecimal tenderprice = new BigDecimal(0);
            BigDecimal taxrate = new BigDecimal(0);
            BigDecimal pricevat = new BigDecimal(0);
            Object exceptvat = new BigDecimal(0);
            BigDecimal supplierRateSum = new BigDecimal(0);
            BigDecimal supplierRateCount = new BigDecimal(0);
            BigDecimal taxrateSum = new BigDecimal(0);
            for (int i = 0; i < parentPurDetails.size(); ++i) {
                DynamicObject parentPurDetail = (DynamicObject)parentPurDetails.get(i);
                String parentSupplierid = parentPurDetail.getDynamicObject("pursupplier").getString("id");
                String ppurentrycontent = parentPurDetail.getString("purentrycontent") == null ? "" : parentPurDetail.getString("purentrycontent");
                String ppurentryprojectid = parentPurDetail.getDynamicObject("purentryproject") == null ? "" : parentPurDetail.getDynamicObject("purentryproject").getString("id");
                String pmaterialid = parentPurDetail.getDynamicObject("materialid") == null ? "" : parentPurDetail.getDynamicObject("materialid").getString("id");
                String pmaterialdes = parentPurDetail.getString("materialdes") == null ? "" : parentPurDetail.getString("materialdes");
                String presourceitem = "";
                if ("rebm".equals(appId)) {
                    String string = presourceitem = parentPurDetail.getDynamicObject("resourceitem") == null ? "" : parentPurDetail.getDynamicObject("resourceitem").getString("id");
                }
                if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)parentSupplierid)) continue;
                for (int ii = 0; ii < resultList.size(); ++ii) {
                    String resourceitem;
                    Map resultDetailMap = (Map)resultList.get(ii);
                    String purentrycontent = (String)resultDetailMap.get("purentrycontent");
                    String purentryprojectid = (String)resultDetailMap.get("purentryprojectid");
                    String materialid = (String)resultDetailMap.get("materialid");
                    String materialdes = (String)resultDetailMap.get("materialdes");
                    String string = resourceitem = resultDetailMap.get("resourceitem") == null ? "" : (String)resultDetailMap.get("resourceitem");
                    if (!StringUtils.equals((CharSequence)ppurentrycontent, (CharSequence)purentrycontent) || !StringUtils.equals((CharSequence)ppurentryprojectid, (CharSequence)purentryprojectid) || !StringUtils.equals((CharSequence)pmaterialid, (CharSequence)materialid) || !StringUtils.equals((CharSequence)pmaterialdes, (CharSequence)materialdes) || !StringUtils.equals((CharSequence)presourceitem, (CharSequence)resourceitem)) continue;
                    model.setValue("inclutaxprice", resultDetailMap.get("inclutaxprice"), i);
                    model.setValue("inclutaxamount", resultDetailMap.get("inclutaxamount"), i);
                    model.setValue("staxrate", resultDetailMap.get("staxrate"), i);
                    model.setValue("taxamount", resultDetailMap.get("taxamount"), i);
                    model.setValue("excepttaxamount", resultDetailMap.get("excepttaxamount"), i);
                    model.setValue("costrate", resultDetailMap.get("costrate"), i);
                    model.setValue("bd_taxrate", resultDetailMap.get("bd_taxrate"), i);
                    tenderprice = tenderprice.add(new BigDecimal(resultDetailMap.get("inclutaxamount") + ""));
                    pricevat = pricevat.add(new BigDecimal(resultDetailMap.get("taxamount") + ""));
                    exceptvat = ((BigDecimal)exceptvat).add(new BigDecimal(resultDetailMap.get("excepttaxamount") + ""));
                    supplierRateSum = supplierRateSum.add(new BigDecimal(resultDetailMap.get("costrate") + ""));
                    supplierRateCount = supplierRateCount.add(new BigDecimal(1));
                    taxrateSum = taxrateSum.add(new BigDecimal(resultDetailMap.get("staxrate") + ""));
                }
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
            DecimalFormat df = new DecimalFormat("0.00");
            for (int i = 0; i < parentPurEntrys.size(); ++i) {
                DynamicObject parentPurEntry = (DynamicObject)parentPurEntrys.get(i);
                if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)parentPurEntry.getDynamicObject("supplier").getString("id"))) continue;
                model.setValue("new_price", (Object)tenderprice, i);
                model.setValue("pricevat", (Object)pricevat, i);
                model.setValue("bus_exceptvat", exceptvat, i);
                if (resultList.size() == 1) {
                    Map resultDetailMap = (Map)resultList.get(0);
                    model.setValue("taxrate", resultDetailMap.get("staxrate"), i);
                } else if (pricevat.compareTo(new BigDecimal(0)) != 0) {
                    taxrate = pricevat.divide((BigDecimal)exceptvat, 4, 4);
                    model.setValue("taxrate", (Object)taxrate.multiply(new BigDecimal("100")), i);
                }
                if (StringUtils.equals((CharSequence)"rebm", (CharSequence)appId)) {
                    if (taxrateSum.compareTo(new BigDecimal(0)) == 0) {
                        model.setValue("taxrate", (Object)new BigDecimal(0), i);
                    }
                    if (tenderprice.compareTo(new BigDecimal(0)) == 0) {
                        model.setValue("new_price", (Object)new BigDecimal(0), i);
                    }
                }
                BigDecimal upPrice = (BigDecimal)model.getValue("up_price", i);
                newPrice = tenderprice;
                if (upPrice.compareTo(BigDecimal.ZERO) <= 0 || newPrice.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal decline = newPrice.subtract(upPrice).divide(upPrice, 4, 4);
                this.getModel().setValue("decline", (Object)decline, i);
                String declineStr = df.format(decline.multiply(new BigDecimal("100")));
                declineStr = declineStr.replaceAll("-", "");
                CellStyle style = new CellStyle();
                style.setRow(i);
                style.setFieldKey("decline_back");
                if (decline.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("decline_back", (Object)(declineStr + "% \u2191"), i);
                    style.setForeColor("#FD6C6A");
                } else if (decline.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("decline_back", (Object)(declineStr + "% \u2193"), i);
                    style.setForeColor("#18BC71");
                } else {
                    this.getModel().setValue("decline_back", (Object)"0.00%", i);
                    style.setForeColor("#000");
                }
                styles.add(style);
            }
            grid.setCellStyle(styles);
        }
        if ("bid_bustalk_file".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            map = (Map)closedCallBackEvent.getReturnData();
            String clickFieldName = (String)map.get("clickFieldName");
            Integer clickRow = (Integer)map.get("clickRow");
            Integer size = (Integer)map.get("size");
            this.getModel().setValue(clickFieldName, (Object)size, clickRow.intValue());
        }
        if ("addsupplier".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject supplier;
            DynamicObject bidDecision;
            ListSelectedRowCollection returnObj = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String appId = this.getModel().getDataEntityType().getAppId();
            DynamicObject bustalk = this.getModel().getDataEntity(true);
            DynamicObject bidproject = bustalk.getDynamicObject("bidproject");
            Long bidprojectId = (Long)bidproject.getPkValue();
            int sectionRow = this.getModel().getEntryCurrentRowIndex("bidsection");
            boolean isratebidding = bidproject.getBoolean("isratebidding");
            HashMap<String, Long> busTalkTimeDateMap = new HashMap<String, Long>();
            DynamicObjectCollection bustalkList = this.bidBustalkService.findBustalkByBidprojectId(bidprojectId, "judge_num asc");
            for (DynamicObject b : bustalkList) {
                DynamicObject bb = null;
                bb = StringUtils.equals((CharSequence)"rebm", (CharSequence)appId) ? BusinessDataServiceHelper.loadSingle((Object)b.getLong("id"), (String)"rebm_bustalk") : this.bidBustalkService.getBustalkById(Long.valueOf(b.getLong("id")));
                DynamicObjectCollection bidsections = bb.getDynamicObjectCollection("bidsection");
                DynamicObjectCollection supplierentrys = ((DynamicObject)bidsections.get(sectionRow)).getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierentry : supplierentrys) {
                    Date busTalkAuditDate;
                    DynamicObject supplier2 = supplierentry.getDynamicObject("supplier");
                    BigDecimal newPrice2 = supplierentry.getBigDecimal("new_price");
                    if (isratebidding) {
                        newPrice2 = supplierentry.getBigDecimal("newrate").multiply(new BigDecimal("100"));
                    }
                    if ((busTalkAuditDate = bb.getDate("auditdate")) == null) continue;
                    busTalkTimeDateMap.put(supplier2.getPkValue().toString(), busTalkAuditDate.getTime());
                }
            }
            HashMap<String, BigDecimal> clarifyPrices = new HashMap<String, BigDecimal>();
            HashMap<String, Long> clarifySubmitDateMap = new HashMap<String, Long>();
            boolean isBidEvaluation = bidproject.getBoolean("bidevaluation");
            if (isBidEvaluation) {
                boolean enablemultisection = bidproject.getBoolean("enablemultisection");
                QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidprojectId);
                QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
                DynamicObject bidDecisionObject = QueryServiceHelper.queryOne((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter});
                String entityName = null;
                entityName = this.getModel().getDataEntityType().getAppId().equals("rebm") ? "rebm_decision" : "bid_decision";
                bidDecision = BusinessDataServiceHelper.loadSingle((Object)bidDecisionObject.getLong("id"), (String)entityName);
                DynamicObjectCollection bidsections = bidDecision.getDynamicObjectCollection("bidsection");
                DynamicObject bidsection = (DynamicObject)bidsections.get(sectionRow);
                String sectionName = bidsection.getString("sectionname");
                DynamicObjectCollection supplierentrys = bidsection.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierentrys.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                    supplier = supplierentry.getDynamicObject("supplier");
                    DynamicObject clarifyNewData = this.evaluationService.getBusinessDataFromLatestData(bidproject.getPkValue(), supplier.getPkValue(), enablemultisection, sectionName);
                    if (clarifyNewData == null) continue;
                    BigDecimal newPrice3 = (BigDecimal)clarifyNewData.get("tenderprice");
                    if (isratebidding) {
                        newPrice3 = clarifyNewData.getBigDecimal("rate").multiply(new BigDecimal("100"));
                    }
                    clarifyPrices.put(supplier.getPkValue().toString(), newPrice3);
                    Date submitDate = clarifyNewData.getDate("submitdate");
                    if (submitDate == null) continue;
                    clarifySubmitDateMap.put(supplier.getPkValue().toString(), submitDate.getTime());
                }
            }
            HashMap<String, BigDecimal> openPrices = new HashMap<String, BigDecimal>();
            boolean isBidOpen = bidproject.getBoolean("bidopen");
            if (isBidOpen) {
                QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidprojectId);
                QFilter qFilter_openType = new QFilter("opentype", "in", (Object)new String[]{BidOpenTypeEnum.BUSSINESS.getValue(), BidOpenTypeEnum.MULTI.getValue()});
                DynamicObject bidOpenID = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter_openType});
                if (bidOpenID != null) {
                    String entityName = null;
                    entityName = this.getModel().getDataEntityType().getAppId().equals("rebm") ? "rebm_bidopen" : "bid_bidopen";
                    DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenID.getLong("id"), (String)entityName);
                    DynamicObjectCollection bidsections = bidOpen.getDynamicObjectCollection("bidsection");
                    DynamicObjectCollection supplierentrys = ((DynamicObject)bidsections.get(sectionRow)).getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierentry : supplierentrys) {
                        DynamicObject supplier3 = supplierentry.getDynamicObject("supplier");
                        newPrice = supplierentry.getBigDecimal("supplier_tenderprice");
                        if (isratebidding) {
                            newPrice = supplierentry.getBigDecimal("supplier_rate").multiply(new BigDecimal("100"));
                        }
                        openPrices.put(supplier3.getPkValue().toString(), newPrice);
                    }
                }
            }
            HashMap<String, BigDecimal> decisionPrices = new HashMap<String, BigDecimal>();
            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidprojectId);
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
            bidDecision = QueryServiceHelper.queryOne((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter});
            if (bidDecision != null) {
                String entityName = null;
                entityName = this.getModel().getDataEntityType().getAppId().equals("rebm") ? "rebm_decision" : "bid_decision";
                DynamicObject realBidDecision = BusinessDataServiceHelper.loadSingle((Object)bidDecision.getLong("id"), (String)entityName);
                DynamicObjectCollection bidSections = realBidDecision.getDynamicObjectCollection("bidsection");
                DynamicObjectCollection supplierEntryList = ((DynamicObject)bidSections.get(sectionRow)).getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryList) {
                    supplier = supplierEntry.getDynamicObject("supplier");
                    BigDecimal newPrice4 = supplierEntry.getBigDecimal("finalprice");
                    if (isratebidding) {
                        newPrice4 = supplierEntry.getBigDecimal("finalrate").multiply(new BigDecimal("100"));
                    }
                    decisionPrices.put(supplier.getPkValue().toString(), newPrice4);
                }
            }
            for (ListSelectedRow r : returnObj) {
                String supplierId = r.getPrimaryKeyValue().toString();
                long busTalkTime = 0L;
                if (!busTalkTimeDateMap.isEmpty()) {
                    busTalkTime = busTalkTimeDateMap.get(supplierId) == null ? 0L : (Long)busTalkTimeDateMap.get(supplierId);
                }
                long clarifySubmitDate = 0L;
                if (!clarifySubmitDateMap.isEmpty()) {
                    clarifySubmitDate = clarifySubmitDateMap.get(supplierId) == null ? 0L : (Long)clarifySubmitDateMap.get(supplierId);
                }
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u65f6\u95f4\uff1a%1$s\uff0c\u8d28\u7591\u6f84\u6e05\u63d0\u4ea4\u65f6\u95f4\uff1a%2$s\u3002", (String)"BidBustalkEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), busTalkTime, clarifySubmitDate));
                if (busTalkTime >= clarifySubmitDate) {
                    BizLog.log((String)ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u6bd4\u8f83\u7ed3\u679c\uff1abusTalkTime\u5927\u4e8e\u4e14\u7b49\u4e8eclarifySubmitDate\u3002", (String)"BidBustalkEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    if (decisionPrices.size() > 0 && null != decisionPrices.get(supplierId)) {
                        BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u8bbe\u7f6e\u4f9b\u5e94\u5546id\uff1a%1$s\uff0c\u5b9a\u6807\u4ef7\u683c\u5230\u5546\u52a1\u8c08\u5224\uff1a%2$s\u3002", (String)"BidBustalkEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplierId, decisionPrices.get(supplierId)));
                        this.setUpPrice(bustalk, r, decisionPrices, sectionRow, isratebidding);
                        continue;
                    }
                    if (openPrices.size() <= 0 || null == openPrices.get(supplierId)) continue;
                    BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u8bbe\u7f6e\u4f9b\u5e94\u5546id\uff1a%1$s\uff0c\u5f00\u6807\u4ef7\u683c\u5230\u5546\u52a1\u8c08\u5224\uff1a%2$s\u3002", (String)"BidBustalkEditUI_5", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplierId, openPrices.get(supplierId)));
                    this.setUpPrice(bustalk, r, openPrices, sectionRow, isratebidding);
                    continue;
                }
                BizLog.log((String)ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u6bd4\u8f83\u7ed3\u679c\uff1abusTalkTime < clarifySubmitDate\u3002", (String)"BidBustalkEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                if (clarifyPrices.size() <= 0 || null == clarifyPrices.get(supplierId)) continue;
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u8bbe\u7f6e\u4f9b\u5e94\u5546id\uff1a%s\uff0c\u8d28\u7591\u3001\u6f84\u6e05\u4ef7\u683c\u5230\u5546\u52a1\u8c08\u5224\uff1a%1$s\u3002", (String)"BidBustalkEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]), supplierId, clarifyPrices.get(supplierId)));
                this.setUpPrice(bustalk, r, clarifyPrices, sectionRow, isratebidding);
            }
        }
        if ("setstoptime".equals(actionId)) {
            map = (Map)closedCallBackEvent.getReturnData();
            Boolean isok = (Boolean)map.get("isok");
            Date newstoptime = (Date)map.get("newstoptime");
            if (isok.booleanValue()) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u6210\u529f\u8c03\u6574\u4e3a\uff1a%s\u3002", (String)"BidBustalkEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), newstoptime.toLocaleString()));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u53d6\u6d88\u6216\u5931\u8d25\u3002", (String)"BidBustalkEditUI_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void setUpPrice(DynamicObject bustalk, ListSelectedRow r, Map<String, BigDecimal> prices, int sectionRow, boolean isratebidding) {
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection supplierentrys = ((DynamicObject)bidsections.get(sectionRow)).getDynamicObjectCollection("supplierentry");
        int i = 0;
        for (DynamicObject supplierentry : supplierentrys) {
            DynamicObject supplier = supplierentry.getDynamicObject("supplier");
            if (supplier.getPkValue().equals(r.getPrimaryKeyValue())) {
                BigDecimal upPrice = prices.get(r.getPrimaryKeyValue().toString());
                if (isratebidding) {
                    this.getModel().setValue("uprate", (Object)upPrice, i);
                } else {
                    this.getModel().setValue("up_price", (Object)upPrice, i);
                }
            }
            ++i;
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        Date offerstoptime;
        super.propertyChanged(propertychangedargs);
        if ("newrate".equals(propertychangedargs.getProperty().getName())) {
            int sectionRow = this.getModel().getEntryCurrentRowIndex("bidsection");
            int entryRow = this.getModel().getEntryCurrentRowIndex("supplierentry");
            DynamicObject bustalk = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
            DynamicObject bidsection = (DynamicObject)bidsections.get(sectionRow);
            DynamicObjectCollection supplierentrys = bidsection.getDynamicObjectCollection("supplierentry");
            DynamicObject supplierentry = (DynamicObject)supplierentrys.get(entryRow);
            EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
            ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
            DecimalFormat df = new DecimalFormat("0.00");
            BigDecimal upPrice = supplierentry.getBigDecimal("uprate");
            BigDecimal newPrice = supplierentry.getBigDecimal("newrate");
            if (upPrice.compareTo(BigDecimal.ZERO) > 0 && newPrice.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal decline = newPrice.subtract(upPrice).divide(upPrice, 4, 4);
                this.getModel().setValue("decline", (Object)decline, entryRow);
                String declineStr = df.format(decline.multiply(new BigDecimal("100")));
                declineStr = declineStr.replaceAll("-", "");
                CellStyle style = new CellStyle();
                style.setRow(entryRow);
                style.setFieldKey("decline_back");
                if (decline.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("decline_back", (Object)(declineStr + "% \u2191"), entryRow);
                    style.setForeColor("#FD6C6A");
                } else if (decline.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("decline_back", (Object)(declineStr + "% \u2193"), entryRow);
                    style.setForeColor("#18BC71");
                } else {
                    this.getModel().setValue("decline_back", (Object)"0.00%", entryRow);
                    style.setForeColor("#000");
                }
                styles.add(style);
            }
            grid.setCellStyle(styles);
        } else if (OPENONLINESYNERGY.equals(propertychangedargs.getProperty().getName())) {
            String billstatus;
            this.setOpenOnLine();
            ChangeData[] changeSet = propertychangedargs.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            Object oldValue = changeSet[0].getOldValue();
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (newValue == null) {
                return;
            }
            if (newValue == Boolean.TRUE && ((billstatus = (String)this.getModel().getValue("billstatus")).equals("D") || billstatus.equals("A"))) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection bidsectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                this.getModel().setValue("offerstoptime", null);
                for (int i = 0; i < bidsectionColl.size(); ++i) {
                    DynamicObjectCollection supplierentryColl = ((DynamicObject)bidsectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                    supplierentryColl.clear();
                    DynamicObjectCollection supplierdetailColl = ((DynamicObject)bidsectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                    supplierdetailColl.clear();
                }
            }
            this.getView().updateView("supplierentry");
        }
        if ("offerstoptime".equals(propertychangedargs.getProperty().getName()) && (offerstoptime = (Date)this.getModel().getValue("offerstoptime")) != null && offerstoptime.getTime() - new Date().getTime() <= 0L) {
            FieldTip qingjiaTip = new FieldTip(FieldTip.FieldTipType.Info, "offerstoptime", ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u670d\u52a1\u5668\u65f6\u95f4\u3002", (String)"BidBustalkEditUI_46", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().showFieldTip(qingjiaTip);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String appId;
        Long orgId;
        DynamicObject bidProject;
        boolean exsitInval;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("form", "edit");
        operate.getOption().setVariableValue("bos_checkFormDataVersion", "false");
        DynamicObject bustalk = this.getModel().getDataEntity(true);
        String key = operate.getOperateKey();
        if ("newdelete".equals(key) || "judge".equals(key) || "submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key)) {
            Object id = bustalk.getPkValue();
            DynamicObject bustalks = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_bustalk");
            String currentstep = bustalks.getString("bidproject.currentstep");
            boolean bidopen = bustalks.getBoolean("bidproject.bidopen");
            if (bidopen) {
                if (!currentstep.contains("BidBustalk") && !currentstep.contains("BidDecision")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u672a\u5230\u5f53\u524d\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if (!(currentstep.contains("BidBustalk") || currentstep.contains("BidAnswerQuestion") || currentstep.contains("BidDecision"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u672a\u5230\u5f53\u524d\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"judge")) {
            this.doJudge(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"newdelete")) {
            this.doDelete(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) {
            this.bidBustalkUtil.validatorSave(this.getView(), args, bustalk);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            this.bidBustalkUtil.validatorSubmit(this.getView(), args, bustalk);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"unaudit")) {
            this.bidBustalkUtil.validatorUnaudit(this.getView(), args, bustalk);
        }
        if ((StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) && (exsitInval = SupplierInvalUtil.checkExsitUnAuditSuppleirInvalBill((DynamicObject)(bidProject = bustalk.getDynamicObject("bidproject")), (String)this.getBillId().split("_")[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidBustalkEditUI_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"releaseletters")) {
            orgId = bustalk.getDynamicObject("org").getLong("id");
            boolean hasPermission = PermissionUtils.checkPermission("SWTP002", orgId, appId = this.getModel().getDataEntityType().getAppId(), FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u53d1\u5e03\u9080\u7ea6\u51fd\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c[\u53d1\u5e03\u9080\u7ea6\u51fd]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkEditUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"C".equals(bustalk.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u5546\u52a1\u8c08\u5224\u5355\u636e\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billstatus = bustalk.getString("billstatus");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u5df2\u5ba1\u6838\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u8bf7\u51fd\u3002", (String)"BidBustalkEditUI_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
            if (!openonlinesynergy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ebf\u4e0a\u534f\u540c\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date offerstoptime = bustalk.getDate("offerstoptime");
            if (offerstoptime == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\u3002", (String)"BidBustalkEditUI_52", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (offerstoptime.getTime() - new Date().getTime() <= 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u5230\u8fbe\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_53", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
            QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
            qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
            if (dyc.size() > 0 && !bustalk.getPkValue().toString().equals(((DynamicObject)dyc.get(0)).getString("id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_54", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String entitytypeid = bustalk.getString("entitytypeid");
            entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
            boolean bustalkid = QueryServiceHelper.exists((String)(entitytypeid + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", bustalk.getPkValue())});
            if (bustalkid) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u6dfb\u52a0\u4e86\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u67e5\u770b\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_55", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BillShowParameter para = new BillShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setFormId(entitytypeid + "_negotiate_invite");
            para.setCaption(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd", (String)"BidBustalkEditUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            para.setCustomParam("bustalkid", bustalk.getPkValue());
            para.setCustomParam("entitytypeid", (Object)bustalk.getString("entitytypeid"));
            this.getView().showForm((FormShowParameter)para);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"lookletters")) {
            if (bustalk == null) {
                return;
            }
            orgId = bustalk.getDynamicObject("org").getLong("id");
            boolean hasPermission = PermissionUtils.checkPermission("SWTP003", orgId, appId = this.getModel().getDataEntityType().getAppId(), FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u67e5\u770b\u9080\u7ea6\u51fd\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c[\u67e5\u770b\u9080\u7ea6\u51fd]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkEditUI_56", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
            if (!openonlinesynergy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ebf\u4e0a\u534f\u540c\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_57", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String entitytypeid = bustalk.getString("entitytypeid");
            entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
            boolean bustalkid = QueryServiceHelper.exists((String)(entitytypeid + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", bustalk.getPkValue())});
            if (!bustalkid) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkEditUI_58", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListShowParameter para = new ListShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setBillFormId(entitytypeid + "_negotiate_invite");
            para.setCaption(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u5217\u8868", (String)"BidBustalkEditUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            para.setCustomParam("bustalkid", bustalk.getPkValue());
            this.getView().showForm((FormShowParameter)para);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"setstoptime")) {
            this.setStopTime(args, bustalk);
        }
    }

    public void cellDoubleClick(CellClickEvent var1) {
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        int j;
        int j2;
        int i;
        DynamicObject bustalk;
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("newsupplierentry".equals(key)) {
            DynamicObject temp;
            bustalk = this.getModel().getDataEntity();
            DynamicObject bidProject = bustalk.getDynamicObject("bidproject");
            Long bidProjectId = bidProject.getLong("id");
            String bidmode = bidProject.getDynamicObject("bidmode").getString("name");
            boolean isBidEvaluation = bidProject.getBoolean("bidevaluation");
            boolean isBidOpen = bidProject.getBoolean("bidopen");
            boolean isBidPublish = bidProject.getBoolean("bidpublish");
            boolean isSupplierInvitation = bidProject.getBoolean("supplierinvitation");
            if (isBidEvaluation) {
                QFilter qFilter;
                DynamicObjectCollection supplierCollection = this.getModel().getEntryEntity(this.SUPPLIER_ENTRY_ENTITY);
                ArrayList<Object> oldIds = new ArrayList<Object>();
                for (int i2 = 0; i2 < supplierCollection.size(); ++i2) {
                    DynamicObject supplier;
                    DynamicObject supplierEntry = (DynamicObject)supplierCollection.get(i2);
                    if (supplierEntry == null || (supplier = supplierEntry.getDynamicObject("supplier")) == null) continue;
                    oldIds.add(supplier.getPkValue());
                }
                String bidOpenType = bidProject.getString("bidopentype");
                DynamicObject temp2 = new DynamicObject();
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                    qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    qFilter.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                    qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()));
                    temp2 = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                    qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    qFilter.and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                    qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()));
                    temp2 = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                } else {
                    qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()));
                    temp2 = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                }
                EntryGrid bidSectionGrid = (EntryGrid)this.getControl("bidsection");
                int currentRow = bidSectionGrid.getSelectRows()[0];
                ArrayList<String> bidOpenInvalidSupplierIdList = new ArrayList<String>();
                QFilter qFilter2 = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                qFilter2.and("billstatus", "=", (Object)"O");
                DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"bidsection, bidsection.sectionname, bidsection.supplierentry,supplier,supplier_isinvalid,supplier_istender", (QFilter[])new QFilter[]{qFilter2});
                if (bidOpens != null && bidOpens.length > 0) {
                    for (DynamicObject bidOpen : bidOpens) {
                        DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
                        int collRowIndex = -1;
                        for (DynamicObject bidSection : bidSectionCol) {
                            if (++collRowIndex != currentRow) continue;
                            DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                            for (DynamicObject supplierEntry : supplierEntryCol) {
                                Boolean supplierIsInvalid = supplierEntry.getBoolean("supplier_isinvalid");
                                Boolean supplierIstender = supplierEntry.getBoolean("supplier_istender");
                                if (!supplierIsInvalid.booleanValue() && supplierIstender.booleanValue()) continue;
                                String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                                bidOpenInvalidSupplierIdList.add(supplierId);
                            }
                        }
                    }
                }
                DynamicObject evaluation = this.evaluationService.getBidEvaluation(Long.valueOf(temp2.getLong("id")));
                int sectionRow = this.getModel().getEntryCurrentRowIndex("bidsection");
                DynamicObjectCollection bidsections = evaluation.getDynamicObjectCollection("bidsection");
                Long sectionId = (Long)((DynamicObject)bidsections.get(sectionRow)).getPkValue();
                DynamicObjectCollection supplierentrys = this.evaluationService.listBidEvalEntryBySections(sectionId, null);
                ArrayList<Object> pkids = new ArrayList<Object>();
                for (DynamicObject s : supplierentrys) {
                    if (oldIds.contains(s.get("supplier.id")) || !CollectionUtils.isEmpty(bidOpenInvalidSupplierIdList) && bidOpenInvalidSupplierIdList.contains(s.getString("supplier.id"))) continue;
                    pkids.add(s.get("supplier.id"));
                }
                this.showBDSupplierForm(pkids);
            } else if (isBidOpen) {
                DynamicObject tempOpen;
                QFilter qFilter;
                String bidOpenType = bidProject.getString("bidopentype");
                DynamicObject temp3 = new DynamicObject();
                if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                    qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                    qFilter.and("billstatus", "=", (Object)"O");
                    tempOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    temp3 = BusinessDataServiceHelper.loadSingle((Object)tempOpen.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
                } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                    qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                    qFilter.and("billstatus", "=", (Object)"O");
                    tempOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    temp3 = BusinessDataServiceHelper.loadSingle((Object)tempOpen.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
                } else {
                    qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    qFilter.and("billstatus", "=", (Object)"O");
                    DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (bidOpens != null && bidOpens.length > 0) {
                        temp3 = bidOpens[0];
                        temp3 = BusinessDataServiceHelper.loadSingle((Object)temp3.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
                    }
                }
                this.getSupplierFormPrev(temp3, 1, bidmode);
            } else if (isBidPublish) {
                temp = this.publishService.getBidPublishByProjectId(bidProjectId, null);
                DynamicObject publish = this.publishService.getBidPublishById(Long.valueOf(temp.getLong("id")));
                this.getSupplierFormPrev(publish, 2, bidmode);
            } else if (isSupplierInvitation) {
                temp = this.supplierInvitationService.getSupplierInvitationByProjectId(bidProjectId, null);
                DynamicObject supplierInvitation = this.supplierInvitationService.getSupplierInvitationById(Long.valueOf(temp.getLong("id")));
                this.getSupplierFormPrev(supplierInvitation, 3, bidmode);
            } else {
                super.afterDoOperation(afterDoOperationEventArgs);
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                bustalk = this.getModel().getDataEntity(true);
                boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
                IDataModel entryOperate = this.getModel();
                DynamicObjectCollection bidsections = this.getModel().getEntryEntity("bidsection");
                if (bidsections != null && bidsections.size() > 0) {
                    for (i = 0; i < bidsections.size(); ++i) {
                        DynamicObject section = (DynamicObject)bidsections.get(i);
                        entryOperate.setEntryCurrentRowIndex("bidsection", i);
                        DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
                        if (supplierentrys == null || supplierentrys.size() <= 0) continue;
                        for (j2 = 0; j2 < supplierentrys.size(); ++j2) {
                            this.getModel().setValue("purdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidBustalkEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), j2);
                            if (!openonlinesynergy || ((Boolean)this.getModel().getValue("isoffer", j2)).booleanValue()) continue;
                            this.getModel().setValue("purdetail", null, j2);
                        }
                    }
                }
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsection");
                int[] rows = entryEntityGrid.getSelectRows();
                if (bidsections != null && bidsections.size() > 0) {
                    entryOperate.setEntryCurrentRowIndex("bidsection", rows[0]);
                }
                this.getModel().setValue("auditdate", null);
                this.getModel().setValue("auditor", null);
                this.bidBustalkUtil.setBustalkAuditor(bustalk.getLong("id"), null, null);
            }
            this.getModel().setDataChanged(false);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit")) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                IDataModel entryOperate = this.getModel();
                Boolean openonlinesynergy = (Boolean)this.getModel().getValue(OPENONLINESYNERGY);
                DynamicObjectCollection sectionColl = this.getModel().getEntryEntity("bidsection");
                if (sectionColl != null && sectionColl.size() > 0) {
                    for (int i3 = 0; i3 < sectionColl.size(); ++i3) {
                        DynamicObject section = (DynamicObject)sectionColl.get(i3);
                        entryOperate.setEntryCurrentRowIndex("bidsection", i3);
                        DynamicObjectCollection entryEntity = section.getDynamicObjectCollection("supplierentry");
                        if (entryEntity == null || entryEntity.size() <= 0) continue;
                        for (j = 0; j < entryEntity.size(); ++j) {
                            this.getModel().setValue("purdetail", (Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidBustalkEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), j);
                            Boolean isOffer = (Boolean)this.getModel().getValue("isoffer", j);
                            if (!openonlinesynergy.booleanValue() || isOffer.booleanValue()) continue;
                            this.getModel().setValue("purdetail", null, j);
                        }
                    }
                    Iterator entryEntityGrid = (EntryGrid)this.getControl("bidsection");
                    int[] rows = entryEntityGrid.getSelectRows();
                    entryOperate.setEntryCurrentRowIndex("bidsection", rows[0]);
                }
            }
            this.getModel().setDataChanged(false);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save") || StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            ArrayList<Long> list = new ArrayList<Long>();
            ArrayList<Long> sections = new ArrayList<Long>();
            DynamicObjectCollection saveSections = this.getModel().getEntryEntity("bidsection");
            for (DynamicObject saveSection : saveSections) {
                DynamicObjectCollection saveSuppliers = saveSection.getDynamicObjectCollection("supplierentry");
                Long sectionId = saveSection.getLong("id");
                sections.add(sectionId);
                for (DynamicObject saveSupplier : saveSuppliers) {
                    Long supplierId = null;
                    try {
                        supplierId = saveSupplier.getLong("supplier.id");
                    }
                    catch (Exception e1) {
                        return;
                    }
                    DynamicObject tech = this.bidBustalkSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "techFile", "id");
                    DynamicObject com = this.bidBustalkSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "comFile", "id");
                    DynamicObject other = this.bidBustalkSupplierFileService.getOneFileRecordByIds(supplierId, sectionId, "otherFile", "id");
                    if (tech != null) {
                        list.add(tech.getLong("id"));
                    }
                    if (com != null) {
                        list.add(com.getLong("id"));
                    }
                    if (other == null) continue;
                    list.add(other.getLong("id"));
                }
            }
            QFilter qFilter1 = new QFilter("sectionid", "in", (Object)sections.toArray());
            QFilter qFilter2 = new QFilter("id", "not in", (Object)list.toArray());
            DeleteServiceHelper.delete((String)"bid_bustalk_file", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            DynamicObject bustalk2 = this.getModel().getDataEntity(true);
            bustalk2.set("auditdate", null);
            BusinessDataServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{bustalk2});
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int i4 = 0; i4 < bidSectionColl.size(); ++i4) {
                    DynamicObjectCollection supplierColl = ((DynamicObject)bidSectionColl.get(i4)).getDynamicObjectCollection("supplierentry");
                    DynamicObjectCollection supplierDetail = ((DynamicObject)bidSectionColl.get(i4)).getDynamicObjectCollection("supplierdetail");
                    if (supplierColl != null && supplierColl.size() > 0) {
                        for (int j3 = 0; j3 < supplierColl.size(); ++j3) {
                            ((DynamicObject)supplierColl.get(j3)).set("taxrate", (Object)((DynamicObject)supplierColl.get(j3)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierColl.get(j3)).set("newrate", (Object)((DynamicObject)supplierColl.get(j3)).getBigDecimal("newrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierColl.get(j3)).set("uprate", (Object)((DynamicObject)supplierColl.get(j3)).getBigDecimal("uprate").multiply(new BigDecimal("100")));
                        }
                    }
                    if (supplierDetail == null || supplierDetail.size() <= 0) continue;
                    for (int m = 0; m < supplierDetail.size(); ++m) {
                        ((DynamicObject)supplierDetail.get(m)).set("staxrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("staxrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierDetail.get(m)).set("costrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                    }
                }
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
            IDataModel operate = grid.getModel();
            DynamicObjectCollection supllierEntry = operate.getEntryEntity("supplierentry");
            this.changeEntryFieldColor(grid, supllierEntry);
            this.getView().updateView("supplierentry");
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.getModel().setValue("auditdate", (Object)new Date());
                RequestContext requestContext = RequestContext.get();
                this.getModel().setValue("auditor", (Object)requestContext.getUserId());
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (int i5 = 0; i5 < bidSectionColl.size(); ++i5) {
                        DynamicObjectCollection supplierColl = ((DynamicObject)bidSectionColl.get(i5)).getDynamicObjectCollection("supplierentry");
                        DynamicObjectCollection supplierDetail = ((DynamicObject)bidSectionColl.get(i5)).getDynamicObjectCollection("supplierdetail");
                        if (supplierColl != null && supplierColl.size() > 0) {
                            for (j = 0; j < supplierColl.size(); ++j) {
                                ((DynamicObject)supplierColl.get(j)).set("taxrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("newrate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("newrate").multiply(new BigDecimal("100")));
                                ((DynamicObject)supplierColl.get(j)).set("uprate", (Object)((DynamicObject)supplierColl.get(j)).getBigDecimal("uprate").multiply(new BigDecimal("100")));
                            }
                        }
                        if (supplierDetail == null || supplierDetail.size() <= 0) continue;
                        for (int m = 0; m < supplierDetail.size(); ++m) {
                            ((DynamicObject)supplierDetail.get(m)).set("staxrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("staxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierDetail.get(m)).set("costrate", (Object)((DynamicObject)supplierDetail.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                        }
                    }
                }
                this.getView().updateView("supplierentry");
            }
            this.getModel().setDataChanged(false);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                String appId = this.getModel().getDataEntityType().getAppId();
                this.bidBustalkUtil.unauditPriceToDecision(this.getModel(), this.getView(), appId);
                IDataModel entryOperate = this.getModel();
                Boolean openonlinesynergy = (Boolean)this.getModel().getValue(OPENONLINESYNERGY);
                DynamicObjectCollection sectionColl = this.getModel().getEntryEntity("bidsection");
                if (!CollectionUtils.isEmpty((Collection)sectionColl)) {
                    for (i = 0; i < sectionColl.size(); ++i) {
                        DynamicObject section = (DynamicObject)sectionColl.get(i);
                        entryOperate.setEntryCurrentRowIndex("bidsection", i);
                        DynamicObjectCollection entryEntity = section.getDynamicObjectCollection("supplierentry");
                        if (entryEntity == null || entryEntity.size() <= 0) continue;
                        for (j2 = 0; j2 < entryEntity.size(); ++j2) {
                            this.getModel().setValue("purdetail", (Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidBustalkEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]), j2);
                            Boolean isOffer = (Boolean)this.getModel().getValue("isoffer", j2);
                            if (!openonlinesynergy.booleanValue() || isOffer.booleanValue()) continue;
                            this.getModel().setValue("purdetail", null, j2);
                        }
                    }
                }
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsection");
                int[] rows = entryEntityGrid.getSelectRows();
                if (sectionColl != null && sectionColl.size() > 0) {
                    entryOperate.setEntryCurrentRowIndex("bidsection", rows[0]);
                }
            }
            this.getModel().setDataChanged(false);
        }
        if ("judge".equals(key)) {
            OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
            if (opResult != null && !opResult.isSuccess()) {
                return;
            }
            BidCenterServiceImpl bidCenterService = new BidCenterServiceImpl();
            DynamicObject data = this.getModel().getDataEntity();
            DynamicObject lastestBidBustalk = bidCenterService.getLastestBidBustalkRecobybidprojectid(data.getDynamicObject("bidproject").getPkValue());
            BillShowParameter showParameter = new BillShowParameter();
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            showParameter.setOpenStyle(openStyle);
            showParameter.setPkId(lastestBidBustalk.getPkValue());
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "judge");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        this.controlListBtnStatus();
    }

    private void controlListBtnStatus() {
        DynamicObject src = this.getModel().getDataEntity();
        String billStatus = src.getString("billstatus");
        IFormView view = this.getView();
        Long bidprojectId = src.getLong("bidproject.id");
        if (BillStatusEnum.SAVE.getVal().equals(billStatus) || BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_del"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
        }
        if (billStatus.equals(BillStatusEnum.AUDITED.getVal())) {
            boolean isExist = this.bidBustalkService.findBustalkByUnaudit(bidprojectId);
            if (!isExist) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tbljudge"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbljudge"});
        }
    }

    private void doDelete(BeforeDoOperationEventArgs args) {
        String agreeDelete = this.getPageCache().get("agreeDelete");
        if (null == agreeDelete) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("newdelete", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u5b9a\u662f\u5426\u5220\u9664?", (String)"BidBustalkEditUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        this.getPageCache().put("agreeDelete", null);
        DynamicObject bustalk = this.getBustalk();
        DynamicObject org = bustalk.getDynamicObject("org");
        Long mainOrgId = (Long)org.getPkValue();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean hasPermission = PermissionUtils.checkPermission("QXX0004", mainOrgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u5220\u9664\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkEditUI_59", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String billstatus = bustalk.getString("billstatus");
        if (!billstatus.equals(BillStatusEnum.SAVE.getVal()) && !billstatus.equals(BillStatusEnum.DISBEGIN.getVal())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u4e3a\u975e\u201c\u672a\u5f00\u59cb\u201d\u3001\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidBustalkEditUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            int judgeNum = bustalk.getInt("judge_num");
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            if (judgeNum == 0) {
                DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidsection : bidsections) {
                    bidsection.set("supplierentry", null);
                    bidsection.set("supplierdetail", null);
                }
                bustalk.set("billstatus", (Object)"D");
                bustalk.set("auditdate", null);
                bustalk.set("auditor", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bustalk});
                LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"BidBustalkEditUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5220\u9664\u9996\u6b21\u8c08\u5224\u6210\u529f\u3002", (String)"BidBustalkEditUI_60", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BidBustalkEditUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{bustalk.getPkValue()});
                LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"BidBustalkEditUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5220\u9664\u7b2c%s\u8f6e\u8c08\u5224\u6210\u529f\u3002", (String)"BidBustalkEditUI_61", (String)"scm-bid-formplugin", (Object[])new Object[0]), judgeNum + 1));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BidBustalkEditUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String customParam = (String)formShowParameter.getCustomParam("BidCenter");
            if (StringUtils.isNotEmpty((CharSequence)customParam)) {
                this.sendExitActionToParent();
            }
            this.getView().close();
        }
    }

    public void sendExitActionToParent() {
        IFormView parentView = this.getView().getParentView();
        parentView.getModel().setValue("exitmark", (Object)Boolean.TRUE);
        this.getView().sendFormAction(parentView);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("newdelete".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("agreeDelete", "yes");
                this.getView().invokeOperation("newdelete");
            } else {
                this.getPageCache().put("agreeDelete", null);
            }
        }
    }

    private void doJudge(BeforeDoOperationEventArgs args) {
        DynamicObject bustalk = this.getBustalk();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        DynamicObject org = bustalk.getDynamicObject("org");
        Long mainOrgId = (Long)org.getPkValue();
        boolean hasPermission = PermissionUtils.checkPermission("QXX0294", mainOrgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709[\u5546\u52a1\u8c08\u5224]\u7684\u64cd\u4f5c[\u8c08\u5224]\u7684\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c[\u8c08\u5224]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkEditUI_33", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
        boolean isExist = this.bidBustalkService.findBustalkByUnaudit(bidprojectId);
        if (isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkEditUI_34", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
        String billstatus = bustalk.getString("billstatus");
        if (openonlinesynergy) {
            boolean aBoolean;
            Date offerstoptime = bustalk.getDate("offerstoptime");
            if (offerstoptime.getTime() - new Date().getTime() > 0L) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u8fd8\u672a\u5230\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkEditUI_62", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
            qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
            qFilter1.and(new QFilter("id", "!=", bustalk.getPkValue()));
            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime,offerstoptime,openonlinesynergy", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
            if (dyc.size() > 0 && (aBoolean = ((DynamicObject)dyc.get(0)).getBoolean(OPENONLINESYNERGY)) && ((DynamicObject)dyc.get(0)).getDate("offerstoptime").getTime() - new Date().getTime() > 0L) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkEditUI_34", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isSuccess = this.bidBustalkService.createNextJudge(bidprojectId);
            if (isSuccess) {
                QFilter qFilter12 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
                DynamicObject[] dyc2 = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)"id,createtime,offerstoptime,openonlinesynergy", (QFilter[])new QFilter[]{qFilter12}, (String)"createtime desc", (int)1);
                if (dyc2.length > 0) {
                    Object systemParameterValue = SystemParamHelper.getSystemParameterValue((String)appId, (Long)Long.valueOf(org.getPkValue().toString()), (String)"enable");
                    DynamicObject dynamicObject = dyc2[0];
                    dynamicObject.set(OPENONLINESYNERGY, (Object)((Boolean)systemParameterValue));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u3002", (String)"BidBustalkEditUI_37", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6700\u65b0\u4e00\u8f6e\u5546\u52a1\u8c08\u5224\u7684\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BidBustalkEditUI_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        } else {
            boolean aBoolean;
            QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
            qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
            qFilter1.and(new QFilter("id", "!=", bustalk.getPkValue()));
            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime,offerstoptime,openonlinesynergy", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
            if (dyc.size() > 0 && (aBoolean = ((DynamicObject)dyc.get(0)).getBoolean(OPENONLINESYNERGY)) && ((DynamicObject)dyc.get(0)).getDate("offerstoptime").getTime() - new Date().getTime() > 0L) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkEditUI_34", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isSuccess = this.bidBustalkService.createNextJudge(bidprojectId);
            if (isSuccess) {
                QFilter qFilter12 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
                DynamicObject[] dyc2 = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)"id,createtime,offerstoptime,openonlinesynergy", (QFilter[])new QFilter[]{qFilter12}, (String)"createtime desc", (int)1);
                if (dyc2.length > 0) {
                    Object systemParameterValue = SystemParamHelper.getSystemParameterValue((String)appId, (Long)Long.valueOf(org.getPkValue().toString()), (String)"enable");
                    DynamicObject dynamicObject = dyc2[0];
                    dynamicObject.set(OPENONLINESYNERGY, (Object)((Boolean)systemParameterValue));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u3002", (String)"BidBustalkEditUI_37", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6700\u65b0\u4e00\u8f6e\u5546\u52a1\u8c08\u5224\u7684\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BidBustalkEditUI_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setStopTime(BeforeDoOperationEventArgs args, DynamicObject bustalk) {
        String appId;
        if (bustalk == null) {
            return;
        }
        Long orgId = bustalk.getDynamicObject("org").getLong("id");
        boolean hasPermission = PermissionUtils.checkPermission("SWTP001", orgId, appId = this.getModel().getDataEntityType().getAppId(), FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkEditUI_63", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean openonlinesynergy = bustalk.getBoolean(OPENONLINESYNERGY);
        if (!openonlinesynergy) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ebf\u4e0a\u534f\u540c\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkEditUI_64", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!"C".equals(bustalk.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u6570\u636e\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkEditUI_65", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
        boolean isExist = this.bidBustalkService.findBustalkByUnaudit(bidprojectId);
        if (isExist) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkEditUI_66", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
        if (dyc.size() > 0 && !bustalk.getPkValue().toString().equals(((DynamicObject)dyc.get(0)).getString("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkEditUI_66", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String entitytypeid = bustalk.getString("entitytypeid");
        entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId(entitytypeid + "_setstoptime");
        para.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u622a\u6b62\u65f6\u95f4", (String)"BidBustalkEditUI_43", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        para.setCustomParam("oldstoptime", (Object)bustalk.getDate("offerstoptime").getTime());
        para.setCustomParam("bustalkid", bustalk.getPkValue());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "setstoptime");
        para.setCloseCallBack(callBack);
        this.getView().showForm(para);
    }

    private DynamicObject getBustalk() {
        DynamicObject src = this.getModel().getDataEntity();
        Long id = (Long)src.getPkValue();
        DynamicObject bustalk = this.bidBustalkService.getBustalkById(id);
        return bustalk;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private void getSupplierFormPrev1(DynamicObject temp, int type, String bidmode) {
    }

    private void getSupplierFormPrev(DynamicObject temp, int type, String bidmode) {
        int sectionRow = this.getModel().getEntryCurrentRowIndex("bidsection");
        DynamicObjectCollection supplierCollection = this.getModel().getEntryEntity(this.SUPPLIER_ENTRY_ENTITY);
        ArrayList<Object> oldIds = new ArrayList<Object>();
        for (int i = 0; i < supplierCollection.size(); ++i) {
            DynamicObject supplier;
            DynamicObject supplierEntry = (DynamicObject)supplierCollection.get(i);
            if (supplierEntry == null || (supplier = supplierEntry.getDynamicObject("supplier")) == null) continue;
            oldIds.add(supplier.getPkValue());
        }
        ArrayList<String> bidOpenInvalidSupplierIdList = new ArrayList<String>();
        if (1 == type) {
            QFilter qFilter = new QFilter("bidproject.id", "=", temp.getDynamicObject("bidproject").getPkValue());
            qFilter.and("billstatus", "=", (Object)"O");
            DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"bidsection, bidsection.sectionname, bidsection.supplierentry,supplier,supplier_isinvalid,supplier_istender", (QFilter[])new QFilter[]{qFilter});
            if (bidOpens != null && bidOpens.length > 0) {
                for (DynamicObject bidOpen : bidOpens) {
                    DynamicObjectCollection bidSectionCol = bidOpen.getDynamicObjectCollection("bidsection");
                    DynamicObjectCollection supplierEntryCol = ((DynamicObject)bidSectionCol.get(sectionRow)).getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        Boolean supplierIsInvalid = supplierEntry.getBoolean("supplier_isinvalid");
                        Boolean supplierIstender = supplierEntry.getBoolean("supplier_istender");
                        if (!supplierIsInvalid.booleanValue() && supplierIstender.booleanValue()) continue;
                        String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                        bidOpenInvalidSupplierIdList.add(supplierId);
                    }
                }
            }
        }
        ArrayList<Object> pkids = new ArrayList<Object>();
        DynamicObjectCollection bidsections = temp.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection supplierentrys = ((DynamicObject)bidsections.get(sectionRow)).getDynamicObjectCollection("supplierentry");
        for (int i = 0; i < supplierentrys.size(); ++i) {
            DynamicObject supplier;
            DynamicObject supplierEntry = (DynamicObject)supplierentrys.get(i);
            if (supplierEntry.get("supplier") == null || oldIds.contains((supplier = (DynamicObject)supplierEntry.get("supplier")).getPkValue())) continue;
            if (1 == type) {
                boolean b = supplierEntry.getBoolean("supplier_isinvalid");
                if (!CollectionUtils.isEmpty(bidOpenInvalidSupplierIdList) && bidOpenInvalidSupplierIdList.contains(supplier.getString("id")) || b) continue;
                pkids.add(supplier.getPkValue());
                continue;
            }
            if (3 == type) {
                String invitationstatus = supplierEntry.getString("invitationstatus");
                if (ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807", (String)"BidBustalkEditUI_44", (String)"scm-bid-formplugin", (Object[])new Object[0]).equals(bidmode)) {
                    pkids.add(supplier.getPkValue());
                    continue;
                }
                if (!"UNSEND".equals(invitationstatus) && !"ACCEPTED".equals(invitationstatus)) continue;
                pkids.add(supplier.getPkValue());
                continue;
            }
            pkids.add(supplier.getPkValue());
        }
        this.showBDSupplierForm(pkids);
    }

    protected void showBDSupplierForm(List pkids) {
        String formId = null;
        String appId = this.getModel().getDataEntityType().getAppId();
        formId = appId.equals("rebm") ? "resm_official_supplier" : "bd_supplier";
        ListShowParameter para = ShowFormHelper.createShowListForm((String)formId, (boolean)true);
        para.setShowUsed(true);
        para.setShowQuickFilter(true);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (appId.equals("rebm")) {
            para.setCustomParam("selectorgId", org.getPkValue());
            if (!CollectionUtils.isEmpty((Collection)pkids)) {
                qFilters.add(new QFilter("id", "in", (Object)pkids));
                para.setCustomParam("isIncludeBlack", (Object)Boolean.TRUE);
            } else {
                DynamicObject bidProject;
                DynamicObjectCollection supplierGroupCol;
                qFilters.add(new QFilter("id", "in", (Object)pkids));
                DynamicObject bidProjectF7 = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
                if (bidProjectF7 != null && !CollectionUtils.isEmpty((Collection)(supplierGroupCol = (bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)"rebm_project", (String)"suppliergroup")).getDynamicObjectCollection("suppliergroup")))) {
                    ArrayList<Object> supplierGroupIdList = new ArrayList<Object>();
                    for (DynamicObject supplierGroup : supplierGroupCol) {
                        DynamicObject groupBaseData = supplierGroup.getDynamicObject("fbasedataid");
                        if (groupBaseData == null) continue;
                        supplierGroupIdList.add(groupBaseData.getPkValue());
                    }
                    para.setCustomParam("selectGroupId", supplierGroupIdList);
                }
                para.setCustomParam("isIncludeBlack", (Object)Boolean.FALSE);
            }
        } else {
            qFilters.add(new QFilter("id", "in", (Object)pkids));
            para.setCustomParam("groupStandard", (Object)"716529547008326656");
        }
        para.getListFilterParameter().setQFilters(qFilters);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.ADD_SUPPLIER_ACTION_ID);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String value = (String)this.getModel().getValue("billstatus");
        if (BillStatusEnum.INVALID.getVal().equals(value) || BillStatusEnum.COMPLETE.getVal().equals(value)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit", "bar_audit", "bar_save", "bar_submit"});
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        } else if (BillStatusEnum.AUDITING.getVal().equals(value)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bidsection", "supplierentry", "attachmentpanel"});
        }
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            this.getView().setEnable(Boolean.TRUE, new String[]{OPENONLINESYNERGY});
            this.getView().setVisible(Boolean.TRUE, new String[]{"releaseletters", "setstoptime"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{OPENONLINESYNERGY});
            this.getView().setVisible(Boolean.FALSE, new String[]{"releaseletters", "setstoptime"});
            if (BillStatusEnum.DISBEGIN.getVal().equals(value) || BillStatusEnum.SAVE.getVal().equals(value)) {
                this.getView().getModel().setValue(OPENONLINESYNERGY, (Object)Boolean.FALSE);
            }
        }
        this.controlListBtnStatus();
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        String docType = bidProject.getString("doctype");
        if (!StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)docType) && StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)docType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"technology"});
        }
        this.setOpenOnLine();
        this.setFileVisible();
    }

    public void setFileVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String docType = dataEntity.getString("bidproject.doctype");
        if ("BUSSINESS".equals(docType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"technology_new"});
        }
    }

    private void setOpenOnLine() {
        Boolean openonlinesynergy = (Boolean)this.getModel().getValue(OPENONLINESYNERGY);
        DateTimeEdit offerstoptime = (DateTimeEdit)this.getView().getControl("offerstoptime");
        EntryGrid supplierentry = (EntryGrid)this.getView().getControl("supplierentry");
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (openonlinesynergy.booleanValue()) {
            offerstoptime.setMustInput(true);
            supplierentry.setMustInput("bus_exceptvat", false);
            supplierentry.setMustInput("business", false);
        } else {
            offerstoptime.setMustInput(false);
            supplierentry.setMustInput("bus_exceptvat", true);
            supplierentry.setMustInput("business", true);
        }
        String status = (String)this.getModel().getValue("billstatus");
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        String purdetailText = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"BidBustalkEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        DynamicObject bustalk = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            DynamicObjectCollection supplierentrys = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry1 : supplierentrys) {
                supplierentry1.set("purdetail", (Object)purdetailText);
                if (OperationStatus.VIEW.equals((Object)formStatus) || !"A".equals(status) && !"D".equals(status)) {
                    purdetailText = ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidBustalkEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                    supplierentry1.set("purdetail", (Object)purdetailText);
                }
                boolean isOffer = supplierentry1.getBoolean("isoffer");
                if (!openonlinesynergy.booleanValue()) continue;
                String offerrecordText = ResManager.loadKDString((String)"\u67e5\u770b", (String)"BidBustalkEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                if (isOffer) {
                    supplierentry1.set("offerrecord", (Object)offerrecordText);
                    continue;
                }
                DynamicObject offerperson = supplierentry1.getDynamicObject("offerperson");
                if (offerperson != null) {
                    supplierentry1.set("offerrecord", (Object)offerrecordText);
                }
                supplierentry1.set("purdetail", null);
            }
        }
        this.getView().updateView("supplierentry");
    }

    @Override
    public String getBillId() {
        return FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass());
    }

    @Override
    protected boolean needHandleSupplier() {
        return true;
    }

    @Override
    protected boolean needFlagNewSupplier() {
        Boolean needflagnewsupplier = (Boolean)this.getModel().getValue("needflagnewsupplier");
        return needflagnewsupplier != null && needflagnewsupplier != false;
    }

    @Override
    protected boolean needContact() {
        return false;
    }
}

