/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.BidBustalkUtil;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidBustalkListUI
extends AbstractListPlugin {
    private static final String KEY_CURRENTSTEP = "bidproject_currentstep";
    private static final String BIDPROJECT_ID = "bidproject.id";
    private IBidBustalkService bidBustalkService = new BidBustalkServiceImpl();
    private BidBustalkUtil bidBustalkUtil = new BidBustalkUtil();

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        ((IListView)this.getView()).refresh();
    }

    public String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("bidproject_org", "");
        for (QFilter qFilter : qFilters) {
            if (!qFilter.getProperty().equals("bidproject.org")) continue;
            List orgIds = (List)qFilter.getValue();
            Object systemParameterValue = SystemParamHelper.getSystemParameterValue((String)this.getAppId(), (Long)Long.valueOf(orgIds.get(0).toString()), (String)"enable");
            if (!((Boolean)systemParameterValue).booleanValue()) continue;
            pageCache.put("bidproject_org", orgIds.get(0).toString());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (enable) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"setstoptime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"releaseletters"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"setstoptime"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"releaseletters"});
        }
    }

    public String getOpenFormId() {
        return "bid_projectprocess";
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)KEY_CURRENTSTEP, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            DynamicObject bustalk = this.bidBustalkService.getBustalkById((Long)id, BIDPROJECT_ID);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId());
            showParameter.setCustomParam("bidProjectId", bustalk.get(BIDPROJECT_ID));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
        if (StringUtils.equals((CharSequence)"bidproject_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            boolean exsitBackBid;
            BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            Long primaryKeyValue = (Long)event.getCurrentRow().getPrimaryKeyValue();
            DynamicObject bustalks = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bid_bustalk");
            String currentstep = bustalks.getString("bidproject.currentstep");
            boolean bidopen = bustalks.getBoolean("bidproject.bidopen");
            if (bidopen) {
                if (!currentstep.contains("BidBustalk") && !currentstep.contains("BidDecision")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u672a\u5230\u5f53\u524d\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if (!(currentstep.contains("BidBustalk") || currentstep.contains("BidAnswerQuestion") || currentstep.contains("BidDecision"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u672a\u5230\u5f53\u524d\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bustalks.getDynamicObject("bidproject").getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5546\u52a1\u8c08\u5224\u3002", (String)"BidBustalkListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasPermission;
        List mainOrgIds;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("form", "List");
        String key = operate.getOperateKey();
        DynamicObject bustalk = this.getBustalk(args);
        if (bustalk != null) {
            String billstatus;
            if ("judge".equals(key)) {
                Object bidprojectid = bustalk.getDynamicObject("bidproject").getPkValue();
                boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidprojectid);
                if (exsitBackBid) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5546\u52a1\u8c08\u5224\u3002", (String)"BidBustalkListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if ("newdelete".equals(key) || "judge".equals(key) || "submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key)) {
                Object id = bustalk.getPkValue();
                DynamicObject bustalks = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_bustalk");
                String currentstep = bustalks.getString("bidproject.currentstep");
                boolean bidopen = bustalks.getBoolean("bidproject.bidopen");
                if (bidopen) {
                    if (!currentstep.contains("BidBustalk") && !currentstep.contains("BidDecision")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u672a\u5230\u5f53\u524d\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                } else if (!(currentstep.contains("BidBustalk") || currentstep.contains("BidAnswerQuestion") || currentstep.contains("BidDecision"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u672a\u5230\u5f53\u524d\u9636\u6bb5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkListUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (!this.bidBustalkService.checkBidDocFinished(Long.valueOf(bustalk.getDynamicObject("bidproject").getLong("id")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"BidBustalkListUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"judge")) {
                long orgId = -1L;
                mainOrgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
                if (mainOrgIds != null && mainOrgIds.size() != 0) {
                    orgId = (Long)mainOrgIds.get(0);
                }
                String appId = this.getView().getFormShowParameter().getServiceAppId();
                hasPermission = PermissionUtils.checkPermission("QXX0294", orgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
                if (!hasPermission) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u8c08\u5224\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u8c08\u5224\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkListUI_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject org = bustalk.getDynamicObject("org");
                billstatus = bustalk.getString("billstatus");
                Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
                args.setCancel(true);
                if (billstatus.equals(BillStatusEnum.SAVE.getVal()) || billstatus.equals(BillStatusEnum.DISBEGIN.getVal()) || billstatus.equals(BillStatusEnum.SUBMIT.getVal())) {
                    this.getView().invokeOperation("modify");
                } else if (billstatus.equals(BillStatusEnum.AUDITING.getVal())) {
                    this.getView().invokeOperation("view");
                } else if (billstatus.equals(BillStatusEnum.AUDITED.getVal())) {
                    boolean isExist = this.bidBustalkService.findBustalkByUnaudit(bidprojectId);
                    if (isExist) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
                        if (openonlinesynergy) {
                            Date offerstoptime = bustalk.getDate("offerstoptime");
                            if (offerstoptime != null && offerstoptime.getTime() - new Date().getTime() > 0L) {
                                this.getView().invokeOperation("view");
                            } else {
                                QFilter qFilter1 = new QFilter(BIDPROJECT_ID, "=", (Object)bidprojectId);
                                qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
                                qFilter1.and(new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE));
                                qFilter1.and(new QFilter("id", "!=", bustalk.getPkValue()));
                                DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime,offerstoptime", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
                                if (dyc.size() > 0 && ((DynamicObject)dyc.get(0)).getDate("offerstoptime").getTime() - new Date().getTime() > 0L) {
                                    args.setCancel(true);
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                    return;
                                }
                                boolean isSuccess = this.bidBustalkService.createNextJudge(bidprojectId);
                                if (isSuccess) {
                                    QFilter qFilter12 = new QFilter(BIDPROJECT_ID, "=", (Object)bidprojectId);
                                    DynamicObject[] dyc2 = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)"id,createtime,offerstoptime,openonlinesynergy", (QFilter[])new QFilter[]{qFilter12}, (String)"createtime desc", (int)1);
                                    if (dyc2.length > 0) {
                                        Object systemParameterValue = SystemParamHelper.getSystemParameterValue((String)appId, (Long)Long.valueOf(org.getPkValue().toString()), (String)"enable");
                                        DynamicObject dynamicObject = dyc2[0];
                                        dynamicObject.set("openonlinesynergy", (Object)((Boolean)systemParameterValue));
                                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                                    }
                                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u3002", (String)"BidBustalkListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                    BillList x = (BillList)this.getView().getControl("billlistap");
                                    x.refresh();
                                } else {
                                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6700\u65b0\u4e00\u8f6e\u5546\u52a1\u8c08\u5224\u7684\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BidBustalkListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                }
                            }
                        } else {
                            Iterator qFilter1 = new QFilter(BIDPROJECT_ID, "=", (Object)bidprojectId);
                            qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
                            qFilter1.and(new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE));
                            qFilter1.and(new QFilter("id", "!=", bustalk.getPkValue()));
                            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime,offerstoptime", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
                            if (dyc.size() > 0 && ((DynamicObject)dyc.get(0)).getDate("offerstoptime").getTime() - new Date().getTime() > 0L) {
                                args.setCancel(true);
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u5355\u3002", (String)"BidBustalkListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            boolean isSuccess = this.bidBustalkService.createNextJudge(bidprojectId);
                            if (isSuccess) {
                                QFilter qFilter12 = new QFilter(BIDPROJECT_ID, "=", (Object)bidprojectId);
                                DynamicObject[] dyc2 = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)"id,createtime,offerstoptime,openonlinesynergy", (QFilter[])new QFilter[]{qFilter12}, (String)"createtime desc", (int)1);
                                if (dyc2.length > 0) {
                                    Object systemParameterValue = SystemParamHelper.getSystemParameterValue((String)appId, (Long)Long.valueOf(org.getPkValue().toString()), (String)"enable");
                                    DynamicObject dynamicObject = dyc2[0];
                                    dynamicObject.set("openonlinesynergy", (Object)((Boolean)systemParameterValue));
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                                }
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210\u4e0b\u4e00\u8f6e\u8c08\u5224\u3002", (String)"BidBustalkListUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                                BillList x = (BillList)this.getView().getControl("billlistap");
                                x.refresh();
                            } else {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6700\u65b0\u4e00\u8f6e\u5546\u52a1\u8c08\u5224\u7684\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BidBustalkListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            }
                        }
                    }
                } else if (billstatus.equals(BillStatusEnum.COMPLETE.getVal())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u8c08\u5224\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u8c08\u5224\u3002", (String)"BidBustalkListUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else if (billstatus.equals(BillStatusEnum.INVALID.getVal())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c08\u5224\u5355\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u8c08\u5224\u3002", (String)"BidBustalkListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newdelete")) {
                String agreeDelete = this.getPageCache().get("agreeDelete");
                if (null == agreeDelete) {
                    args.setCancel(true);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("newdelete", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u5b9a\u662f\u5426\u5220\u9664?", (String)"BidBustalkListUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    return;
                }
                this.getPageCache().put("agreeDelete", null);
                long orgId = -1L;
                List mainOrgIds2 = ((ListView)this.getView()).getSelectedMainOrgIds();
                if (mainOrgIds2 != null && mainOrgIds2.size() != 0) {
                    orgId = (Long)mainOrgIds2.get(0);
                }
                String appId = this.getView().getFormShowParameter().getServiceAppId();
                boolean hasPermission2 = PermissionUtils.checkPermission("QXX0004", orgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
                if (!hasPermission2) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u64cd\u4f5c\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"BidBustalkListUI_39", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                billstatus = bustalk.getString("billstatus");
                if (!billstatus.equals(BillStatusEnum.SAVE.getVal()) && !billstatus.equals(BillStatusEnum.DISBEGIN.getVal())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u4e3a\u975e\u201c\u672a\u5f00\u59cb\u201d\u3001\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidBustalkListUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    int judgeNum = bustalk.getInt("judge_num");
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bustalk");
                    if (judgeNum == 0) {
                        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
                        for (DynamicObject bidsection : bidsections) {
                            bidsection.set("supplierentry", null);
                            bidsection.set("supplierdetail", null);
                        }
                        bustalk.set("billstatus", (Object)"D");
                        bustalk.set("auditdate", null);
                        bustalk.set("auditor", null);
                        BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{bustalk});
                        args.setCancel(true);
                        BillList x = (BillList)this.getView().getControl("billlistap");
                        x.refresh();
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"BidBustalkListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5220\u9664\u9996\u6b21\u8c08\u5224\u6210\u529f\u3002", (String)"BidBustalkListUI_40", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BidBustalkListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])new Object[]{bustalk.getPkValue()});
                        args.setCancel(true);
                        BillList x = (BillList)this.getView().getControl("billlistap");
                        x.refresh();
                        LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"BidBustalkListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5220\u9664\u7b2c%s\u8f6e\u8c08\u5224\u6210\u529f\u3002", (String)"BidBustalkListUI_41", (String)"scm-bid-formplugin", (Object[])new Object[0]), judgeNum + 1));
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BidBustalkListUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"audit")) {
                String billstatus2 = bustalk.getString("billstatus");
                if (!billstatus2.equals(BillStatusEnum.SUBMIT.getVal())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u4e3a\u975e\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838\u3002", (String)"BidBustalkListUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    args.setCancel(false);
                }
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            this.bidBustalkUtil.validatorUnaudit(this.getView(), args, bustalk);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit")) {
            this.bidBustalkUtil.validatorSubmit(this.getView(), args, bustalk);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"setstoptime")) {
            if (bustalk == null) {
                return;
            }
            long orgId = -1L;
            mainOrgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            if (mainOrgIds != null && mainOrgIds.size() != 0) {
                orgId = (Long)mainOrgIds.get(0);
            }
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            hasPermission = PermissionUtils.checkPermission("SWTP001", orgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkListUI_42", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
            if (!openonlinesynergy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ebf\u4e0a\u534f\u540c\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkListUI_43", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"C".equals(bustalk.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u6570\u636e\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkListUI_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
            boolean isExist = this.bidBustalkService.findBustalkByUnaudit(bidprojectId);
            if (isExist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkListUI_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter qFilter1 = new QFilter(BIDPROJECT_ID, "=", (Object)bidprojectId);
            qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
            if (dyc.size() > 0 && !bustalk.getPkValue().toString().equals(((DynamicObject)dyc.get(0)).getString("id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u622a\u6b62\u65f6\u95f4\u3002", (String)"BidBustalkListUI_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String entitytypeid = bustalk.getString("entitytypeid");
            entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
            FormShowParameter para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setFormId(entitytypeid + "_setstoptime");
            para.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u622a\u6b62\u65f6\u95f4", (String)"BidBustalkListUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            para.setCustomParam("oldstoptime", (Object)bustalk.getDate("offerstoptime").getTime());
            para.setCustomParam("bustalkid", bustalk.getPkValue());
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "setstoptime");
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"releaseletters")) {
            if (bustalk == null) {
                return;
            }
            long orgId = -1L;
            mainOrgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            if (mainOrgIds != null && mainOrgIds.size() != 0) {
                orgId = (Long)mainOrgIds.get(0);
            }
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            hasPermission = PermissionUtils.checkPermission("SWTP002", orgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u53d1\u5e03\u9080\u7ea6\u51fd\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u53d1\u5e03\u9080\u7ea6\u51fd\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkListUI_46", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"C".equals(bustalk.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u7684\u5546\u52a1\u8c08\u5224\u5355\u636e\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String billstatus = bustalk.getString("billstatus");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u5df2\u5ba1\u6838\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u8bf7\u51fd\u3002", (String)"BidBustalkListUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
            if (!openonlinesynergy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ebf\u4e0a\u534f\u540c\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date offerstoptime = bustalk.getDate("offerstoptime");
            if (offerstoptime == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c\u3002", (String)"BidBustalkListUI_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (offerstoptime.getTime() - new Date().getTime() <= 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u5230\u8fbe\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long bidprojectId = bustalk.getDynamicObject("bidproject").getLong("id");
            QFilter qFilter1 = new QFilter(BIDPROJECT_ID, "=", (Object)bidprojectId);
            qFilter1.and(new QFilter("billstatus", "=", (Object)"C"));
            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter1}, (String)"createtime desc", (int)1);
            if (dyc.size() > 0 && !bustalk.getPkValue().toString().equals(((DynamicObject)dyc.get(0)).getString("id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_52", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String entitytypeid = bustalk.getString("entitytypeid");
            entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
            boolean bustalkid = QueryServiceHelper.exists((String)(entitytypeid + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", bustalk.getPkValue())});
            if (bustalkid) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u6dfb\u52a0\u4e86\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u67e5\u770b\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_53", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BillShowParameter para = new BillShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setFormId(entitytypeid + "_negotiate_invite");
            para.setCaption(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd", (String)"BidBustalkListUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            para.setCustomParam("bustalkid", bustalk.getPkValue());
            para.setCustomParam("entitytypeid", (Object)bustalk.getString("entitytypeid"));
            this.getView().showForm((FormShowParameter)para);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"lookletters")) {
            if (bustalk == null) {
                return;
            }
            long orgId = -1L;
            mainOrgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            if (mainOrgIds != null && mainOrgIds.size() != 0) {
                orgId = (Long)mainOrgIds.get(0);
            }
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            hasPermission = PermissionUtils.checkPermission("SWTP003", orgId, appId, FormTypeConstants.getFormConstant((String)"bustalk", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u201d\u7684\u201c\u67e5\u770b\u9080\u7ea6\u51fd\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c[\u67e5\u770b\u9080\u7ea6\u51fd]\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BidBustalkListUI_54", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean openonlinesynergy = bustalk.getBoolean("openonlinesynergy");
            if (!openonlinesynergy) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ebf\u4e0a\u534f\u540c\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_55", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String entitytypeid = bustalk.getString("entitytypeid");
            entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
            boolean bustalkid = QueryServiceHelper.exists((String)(entitytypeid + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", bustalk.getPkValue())});
            if (!bustalkid) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u53d1\u5e03\u9080\u7ea6\u51fd\u3002", (String)"BidBustalkListUI_56", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListShowParameter para = new ListShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setBillFormId(entitytypeid + "_negotiate_invite");
            para.setCaption(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u5217\u8868", (String)"BidBustalkListUI_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            para.setCustomParam("bustalkid", bustalk.getPkValue());
            this.getView().showForm((FormShowParameter)para);
        }
    }

    private DynamicObject getBustalk(BeforeDoOperationEventArgs args) {
        if (null != args.getListSelectedData() && args.getListSelectedData().size() > 0) {
            Long id = (Long)args.getListSelectedData().get(0).getPrimaryKeyValue();
            DynamicObject bustalk = this.bidBustalkService.getBustalkById(id);
            return bustalk;
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            this.bidBustalkUtil.unauditPriceToDecision(this.getModel(), this.getView(), appId);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"submit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            long id = (Long)rows.get(0).getPrimaryKeyValue();
            this.bidBustalkUtil.setBustalkAuditor(id, null, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("newdelete".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("agreeDelete", "yes");
                this.getView().invokeOperation("newdelete");
            } else {
                this.getPageCache().put("agreeDelete", null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("setstoptime".equals(actionId)) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            Boolean isok = (Boolean)map.get("isok");
            Date newstoptime = (Date)map.get("newstoptime");
            if (isok.booleanValue()) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u6210\u529f\u8c03\u6574\u4e3a\uff1a%s\u3002", (String)"BidBustalkListUI_36", (String)"scm-bid-formplugin", (Object[])new Object[0]), newstoptime.toLocaleString()));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u53d6\u6d88\u6216\u5931\u8d25\u3002", (String)"BidBustalkListUI_57", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

