/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidAnnocumentService;
import kd.scm.bid.business.bill.IBidDecisionService;
import kd.scm.bid.business.bill.serviceImpl.BidAnnocumentServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidDecisionServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.bill.BidTemplateConstant;
import kd.scm.bid.common.enums.BidAnnouncementEnum;
import kd.scm.bid.common.enums.BidProjectEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.DecisionEnum;
import kd.scm.bid.common.enums.WinBidAnnouncementEnum;
import kd.scm.bid.common.util.BidProjectAnnouncementsUtils;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.ReWfUtil;
import kd.scm.bid.formplugin.bill.helper.TemplateManageHelper;

public class BidProjectAnnouncementEditUI
extends AbstractFormPlugin
implements UploadListener,
BeforeF7SelectListener {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IBidAnnocumentService annocumentService = new BidAnnocumentServiceImpl();
    private IBidDecisionService bidDecisionService = new BidDecisionServiceImpl();
    private static final String QUALIFICATIONREQUIRED = "qualificationrequired";
    private static final String ORGNAME = "orgname";

    private String getAnnopublishSuffix() {
        return ResManager.loadKDString((String)"\u516c\u5f00\u62db\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_0", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    private String getAnnoWinSuffix() {
        return ResManager.loadKDString((String)"\u4e2d\u6807\u7ed3\u679c\u516c\u793a", (String)"BidProjectAnnouncementEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("bidanntemplate");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object pkid = parameter.getCustomParam("pkid");
        if (pkid != null) {
            this.getModel().setValue("publishstatus", (Object)BillStatusEnum.UNRELEASED.getVal());
            String parentType = (String)parameter.getCustomParam("parentType");
            if (parentType != null && StringUtils.equals((CharSequence)parentType, (CharSequence)"bidproject")) {
                this.setProjectAnnocument(pkid, parameter, "", null);
            } else if (parentType != null && StringUtils.equals((CharSequence)parentType, (CharSequence)"decision")) {
                this.setDecisionAnnocument(pkid, parameter, "");
            }
        }
    }

    public void setProjectAnnocument(Object pkid, FormShowParameter parameter, String newContent, Date enrolldeadlineDate) {
        this.getModel().setValue("annotype", (Object)"bidproject");
        this.getModel().setValue("bidproject", pkid);
        DynamicObject project = this.annocumentService.getSingleBidProjectById(pkid);
        if (project != null) {
            String bidName = project.getString("name");
            DynamicObject org = project.getDynamicObject("org");
            if (enrolldeadlineDate == null) {
                enrolldeadlineDate = project.getDate("enrolldeadline");
            }
            String annContent = "";
            DynamicObject template = null;
            if (StringUtils.isEmpty((CharSequence)newContent)) {
                DynamicObject templateType = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"templatetype", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
                if (templateType != null) {
                    QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("default", "=", (Object)"1"), new QFilter("type", "=", (Object)templateType.getLong("id")), new QFilter("org", "=", (Object)org.getLong("masterid"))};
                    template = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass()), (String)"content", (QFilter[])filters);
                    if (template != null) {
                        annContent = template.getString("content");
                    }
                }
            } else {
                annContent = newContent;
            }
            Lang lang = RequestContext.get().getLang();
            if (!StringUtils.isEmpty((CharSequence)annContent)) {
                annContent = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? annContent.replace(TemplateManageHelper.getSpecialValue(new BidTemplateConstant().getProjectName()), bidName).replace(TemplateManageHelper.getSpecialValue(BidAnnouncementEnum.ANNOUNCOMENTTITLE.getValue()), bidName + " " + this.getAnnopublishSuffix()) : annContent.replace(TemplateManageHelper.getSpecialValue(new BidTemplateConstant().getProjectName()), bidName).replace(TemplateManageHelper.getSpecialValue(BidAnnouncementEnum.ANNOUNCOMENTTITLE.getValue()), bidName + this.getAnnopublishSuffix());
                annContent = this.replaceBidProjectField(annContent, project, enrolldeadlineDate);
            }
            this.getModel().setValue("signendtime", (Object)enrolldeadlineDate);
            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                this.getModel().setValue("annotitle", (Object)(bidName + " " + this.getAnnopublishSuffix()));
            } else {
                this.getModel().setValue("annotitle", (Object)(bidName + this.getAnnopublishSuffix()));
            }
            this.getModel().setValue("content", (Object)annContent);
            this.getModel().setValue("publisher", (Object)RequestContext.get().getUserId());
            ((RichTextEditor)this.getView().getControl("richtexteditorap")).setText(annContent);
            this.getModel().setValue("org", (Object)org);
            if (template != null) {
                this.getModel().setValue("bidanntemplate", template);
            }
        }
    }

    private void setDecisionAnnocument(Object pkid, FormShowParameter parameter, String newContent) {
        this.getModel().setValue("annotype", (Object)"decision");
        this.getModel().setValue("bidproject", pkid);
        String appId = this.getAppId();
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkid.toString()), (String)(appId + "_project"), (String)"currency");
        DynamicObject currency = bidProject.getDynamicObject("currency");
        List sectionList = (List)parameter.getCustomParam("sectionList");
        String sectionName = (String)((Map)((Map)sectionList.get(0)).get("sectionname")).get("zh_CN");
        Lang lang = RequestContext.get().getLang();
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            sectionName = (String)((Map)((Map)sectionList.get(0)).get("sectionname")).get("en_US");
        }
        Object sectionPkid = ((Map)sectionList.get(0)).get("sectionPkid");
        Object dbid = parameter.getCustomParam("dbid");
        this.getModel().setValue("decision", dbid);
        StringBuilder isOrgStrSb = new StringBuilder();
        String moneyStr = "";
        String finalrateStr = "";
        DynamicObject decision = null;
        decision = "bid".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)dbid, (String)"bid_decision") : BusinessDataServiceHelper.loadSingle((Object)dbid, (String)"rebm_decision");
        DynamicObjectCollection bidSectionColl = (DynamicObjectCollection)decision.get("bidsection");
        Object sectionCount = parameter.getCustomParam("sectionCount");
        DynamicObjectCollection supEntryColl = new DynamicObjectCollection();
        supEntryColl = sectionCount != null ? (DynamicObjectCollection)((DynamicObject)bidSectionColl.get(((Integer)sectionCount).intValue())).get("supplierentry") : (DynamicObjectCollection)((DynamicObject)bidSectionColl.get(0)).get("supplierentry");
        for (DynamicObject supentry : supEntryColl) {
            BigDecimal finalrate;
            boolean isrecommended = supentry.getBoolean("isrecommended");
            if (!isrecommended) continue;
            BigDecimal money = supentry.getBigDecimal("finalprice");
            if (money != null && money.compareTo(BigDecimal.ZERO) != 0) {
                moneyStr = moneyStr + BidProjectAnnouncementEditUI.setMoneyFormat(money, currency) + "\u3001";
            }
            if ((finalrate = supentry.getBigDecimal("finalrate")) != null && finalrate.compareTo(BigDecimal.ZERO) != 0) {
                finalrateStr = finalrateStr + BidProjectAnnouncementEditUI.setRateFormat(finalrate) + "\u3001";
            }
            String isOrgStr = supentry.getDynamicObject("supplier").getString("name") + "#";
            isOrgStrSb.append(isOrgStr);
        }
        if (!"".equals(moneyStr)) {
            moneyStr = moneyStr.substring(0, moneyStr.length() - 1);
        }
        if (!"".equals(finalrateStr)) {
            finalrateStr = finalrateStr.substring(0, finalrateStr.length() - 1);
        }
        String[] StrArray = isOrgStrSb.toString().split("#");
        DynamicObject project = this.annocumentService.getSingleBidProjectById(pkid);
        if (project != null) {
            String bidName = project.getString("name");
            DynamicObject org = project.getDynamicObject("org");
            String winningOrg = "";
            if (StrArray != null && StrArray.length > 1) {
                String manyIsorg = "";
                for (int i = 0; i < StrArray.length; ++i) {
                    manyIsorg = i == 0 ? StrArray[0] : manyIsorg + "\u3001" + StrArray[i];
                }
                winningOrg = manyIsorg;
            } else if (StrArray.length == 1) {
                winningOrg = StrArray[0];
            }
            String annContent = "";
            DynamicObject template = null;
            if (StringUtils.isEmpty((CharSequence)newContent)) {
                DynamicObject templateType = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"templatetype", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
                if (templateType != null) {
                    QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("default", "=", (Object)"1"), new QFilter("type", "=", (Object)templateType.getLong("id")), new QFilter("org", "=", (Object)org.getLong("masterid"))};
                    template = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"templatemanage", ((Object)((Object)this)).getClass()), (String)"content", (QFilter[])filters);
                    if (template != null) {
                        annContent = template.getString("content");
                    }
                }
            } else {
                annContent = newContent;
            }
            String annoTitle = "";
            if (sectionCount != null) {
                annoTitle = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? bidName + " " + sectionName + this.getAnnoWinSuffix() : bidName + sectionName + this.getAnnoWinSuffix();
                this.getModel().setValue("annotitle", (Object)annoTitle);
            } else {
                annoTitle = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? bidName + " " + this.getAnnoWinSuffix() : bidName + this.getAnnoWinSuffix();
                this.getModel().setValue("annotitle", (Object)annoTitle);
            }
            if (!StringUtils.isEmpty((CharSequence)annContent)) {
                BidTemplateConstant bidTemplateConstant = new BidTemplateConstant();
                annContent = annContent.replace(TemplateManageHelper.getSpecialValue(bidTemplateConstant.getProjectName()), bidName).replace(TemplateManageHelper.getSpecialValue(WinBidAnnouncementEnum.DECISIONTITLE.getValue()), annoTitle).replace(TemplateManageHelper.getSpecialValue(bidTemplateConstant.getBidWinningValues()[2]), winningOrg).replace(TemplateManageHelper.getSpecialValue(bidTemplateConstant.getBidWinningValues()[3]), moneyStr);
                annContent = this.replaceBidProjectField(annContent, project, null);
                DynamicObject decisionProject = BusinessDataServiceHelper.loadSingle((Object)dbid, (String)"bid_decision");
                String evaluatedecideway = "";
                DynamicObject evalDyObject = decisionProject.getDynamicObject("evaluatedecideway");
                if (evalDyObject != null) {
                    evaluatedecideway = evalDyObject.getString("name");
                }
                BigDecimal controlamount = decisionProject.getBigDecimal("controlamount");
                String controlamountStr = BidProjectAnnouncementEditUI.setMoneyFormat(controlamount, currency);
                BigDecimal amount = decisionProject.getBigDecimal("amount");
                String amountStr = BidProjectAnnouncementEditUI.setMoneyFormat(amount, currency);
                annContent = annContent.replace(TemplateManageHelper.getSpecialValue(DecisionEnum.FINALRATE.getValue()), finalrateStr).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.CONTROLAMOUNT.getValue()), controlamountStr).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.EVALUATEDECIDEWAY.getValue()), evaluatedecideway).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.EXCTAXAMOUNT.getValue()), amountStr).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.SECTIONNAME.getValue()), sectionName).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.BIDPROJECT_NAME.getValue()), bidName).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.ISRECOMMENDED.getValue()), winningOrg).replace(TemplateManageHelper.getSpecialValue(DecisionEnum.FINALPRICE.getValue()), moneyStr);
            }
            this.getModel().setValue("content", (Object)annContent);
            this.getModel().setValue("publisher", (Object)RequestContext.get().getUserId());
            this.getModel().setValue("section", sectionPkid);
            this.getModel().setValue("winorgname", (Object)winningOrg);
            this.getModel().setValue("org", (Object)org);
            DynamicObject model = this.getModel().getDataEntity(true);
            boolean isHasCodeRule = CodeRuleServiceHelper.isExist((String)model.getDynamicObjectType().getName(), (DynamicObject)model, (String)(RequestContext.get().getOrgId() + ""));
            if (!isHasCodeRule) {
                this.getModel().setValue("billno", (Object)new Date().getTime());
            }
            if (template != null) {
                this.getModel().setValue("bidanntemplate", (Object)template);
            }
            ((RichTextEditor)this.getView().getControl("richtexteditorap")).setText(annContent);
        }
    }

    private String replaceBidProjectField(String annContent, DynamicObject project, Date enrolldeadlineDate) {
        String fax;
        String purentryProjectStr;
        if (StringUtils.isEmpty((CharSequence)annContent) || project == null) {
            return annContent;
        }
        String contentStr = "";
        StringBuilder purentryProjectStrSb = new StringBuilder();
        if ("rebm".equals(this.getAppId())) {
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"rebm_project");
        }
        int bidType = project.getInt("bidtype");
        DynamicObjectCollection sections = (DynamicObjectCollection)project.get("bidsection");
        if (sections != null && sections.size() != 0) {
            for (int m = 0; m < sections.size(); ++m) {
                if (sections.get(m) == null) continue;
                DynamicObject section = (DynamicObject)sections.get(m);
                String sectionName = "";
                if (project.getBoolean("enablemultisection")) {
                    sectionName = section.getLocaleString("sectionname").toString() + "\uff1a";
                }
                DynamicObjectCollection content = (DynamicObjectCollection)section.get("projectentry");
                String contentStrEntity = "";
                if (content == null) continue;
                for (int i = 0; i < content.size(); ++i) {
                    if (bidType == 1) {
                        DynamicObject material = ((DynamicObject)content.get(i)).getDynamicObject("materialid");
                        contentStrEntity = !contentStrEntity.equals("") ? contentStrEntity + "\uff0c" + material.getString("name") : material.getString("name");
                    } else if (bidType == 2) {
                        DynamicObject resourceItem = ((DynamicObject)content.get(i)).getDynamicObject("resourceitem");
                        contentStrEntity = !contentStrEntity.equals("") ? contentStrEntity + "\uff0c" + resourceItem.getString("name") : resourceItem.getString("name");
                    } else {
                        contentStrEntity = !contentStrEntity.equals("") ? contentStrEntity + "\uff0c" + ((DynamicObject)content.get(i)).get("purentrycontent") : ((DynamicObject)content.get(i)).get("purentrycontent").toString();
                    }
                    DynamicObject projectEntity = (DynamicObject)((DynamicObject)content.get(i)).get("purentryproject");
                    String projectStrEntity = "";
                    if (projectEntity != null) {
                        projectStrEntity = projectEntity.getString("name") + "\u3001";
                    }
                    purentryProjectStrSb.append(projectStrEntity);
                }
                contentStr = !"".equals(contentStr) ? contentStr + "\n" + sectionName + contentStrEntity : sectionName + contentStrEntity;
            }
        }
        if (!"".equals(purentryProjectStr = purentryProjectStrSb.toString())) {
            purentryProjectStr = purentryProjectStr.substring(0, purentryProjectStr.length() - 1);
        }
        String purtypeStr = " ";
        DynamicObject purtype = project.getDynamicObject("purtype");
        if (purtype != null) {
            purtypeStr = purtype.getString("name");
        }
        String bidmode = project.getDynamicObject("bidmode").getString("name");
        String bidOrg = project.getDynamicObject("org").getString("name");
        String qualificationrequired = project.getString(QUALIFICATIONREQUIRED) == null ? "" : project.getString(QUALIFICATIONREQUIRED);
        String purdescription = project.getString("purdescription") == null ? "" : project.getString("purdescription");
        DynamicObject contact = project.getDynamicObject("contact");
        String contactName = contact.getString("name");
        String contacttel = project.getString("contacttel") == null ? "" : project.getString("contacttel");
        String email = project.getString("proemail") == null ? "" : project.getString("proemail");
        String address = project.getString("proaddress") == null ? "" : project.getString("proaddress");
        String string = fax = project.getString("profax") == null ? "" : project.getString("profax");
        if (enrolldeadlineDate == null) {
            enrolldeadlineDate = project.getDate("enrolldeadline");
        }
        String enrolldeadline = this.setDateStyle(enrolldeadlineDate, Boolean.TRUE, "enrolldeadline");
        String supplierinvienddate = this.setDateStyle(project.getDate("supplierinvienddate"), Boolean.FALSE, "supplierinvienddate");
        String technicaldocenddate = this.setDateStyle(project.getDate("technicaldocenddate"), Boolean.FALSE, "technicaldocenddate");
        String commercialdocenddate = this.setDateStyle(project.getDate("commercialdocenddate"), Boolean.FALSE, "commercialdocenddate");
        String bidpublishdate = this.setDateStyle(project.getDate("bidpublishdate"), Boolean.FALSE, "bidpublishdate");
        String answerquestiontime = this.setDateStyle(project.getDate("answerquestiontime"), Boolean.TRUE, "answerquestiontime");
        String answercomplete = this.setDateStyle(project.getDate("answercomplete"), Boolean.FALSE, "answercomplete");
        String bidopendeadline = this.setDateStyle(project.getDate("bidopendeadline"), Boolean.TRUE, "bidopendeadline");
        String bidevaluationdate = this.setDateStyle(project.getDate("bidevaluationdate"), Boolean.FALSE, "bidevaluationdate");
        String biddecisiondate = this.setDateStyle(project.getDate("biddecisiondate"), Boolean.FALSE, "biddecisiondate");
        String approachdate = this.setDateStyle(project.getDate("approachdate"), Boolean.FALSE, "approachdate");
        annContent = annContent.replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.PURTYPE_NAME.getValue()), purtypeStr).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.PURENTRYPROJECT.getValue()), purentryProjectStr).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.CONTENT.getValue()), contentStr).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.CONTACT.getValue()), contactName).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.CONTACTTEL.getValue()), contacttel).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.EMAIL.getValue()), email).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ADDRESS.getValue()), address).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.FAX.getValue()), fax).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ENDTIME.getValue()), enrolldeadline).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDMODE.getValue()), bidmode).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ORG.getValue()), bidOrg).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.QUALIFICATIONREQUIRED.getValue()), qualificationrequired).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.PURDESCRIPTION.getValue()), purdescription).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.SUPPLIERINVIENDDATE.getValue()), supplierinvienddate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.TECHNICALDOCENDDTAE.getValue()), technicaldocenddate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.COMMERCIALDOCENDDATE.getValue()), commercialdocenddate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDPUBLISHDATE.getValue()), bidpublishdate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ANSWERQUESTIONTIME.getValue()), answerquestiontime).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ANSWERCOMPLETE.getValue()), answercomplete).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDOPENDEADLINE.getValue()), bidopendeadline).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDEVALUATIONDATE.getValue()), bidevaluationdate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDDECISIONDATE.getValue()), biddecisiondate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.APPROACHDATE.getValue()), approachdate);
        return annContent;
    }

    private String setDateStyle(Date date, Boolean isLongDate, String className) {
        String dateFromat = "";
        dateFromat = date != null ? (isLongDate.booleanValue() ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date) : new SimpleDateFormat("yyyy-MM-dd").format(date)) : "<span class=\"" + className + "\"></span>";
        return dateFromat;
    }

    private static String setMoneyFormat(BigDecimal value, DynamicObject currency) {
        if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        int scale = 2;
        String sign = "\u00a5";
        if (currency != null) {
            scale = currency.getInt("amtprecision");
            sign = currency.getString("sign");
        }
        return sign + value.setScale(scale, RoundingMode.HALF_UP);
    }

    private static String setRateFormat(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        DecimalFormat df = new DecimalFormat("0.00%");
        return df.format(value);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        boolean subAndAutiFlag = false;
        subAndAutiFlag = this.getModel().getValue("annotype").equals("bidproject") ? ReWfUtil.hasEableProcess((String)(this.getAppId() + "_project_announcement")) : ReWfUtil.hasEableProcess((String)(this.getAppId() + "_decisionannouncement"));
        if (subAndAutiFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitaudit"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"submitaudit"});
        }
        String billstatus = this.getView().getModel().getDataEntity(true).getString("billstatus");
        if (billstatus.equals(BillStatusEnum.AUDITING.getVal())) {
            status = OperationStatus.VIEW;
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if (status.equals((Object)OperationStatus.EDIT)) {
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"signendtime"});
                DateTimeEdit signendTime = (DateTimeEdit)this.getView().getControl("signendtime");
                signendTime.setMustInput(true);
            } else if (this.getModel().getValue("annotype").equals("decision")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"save_deci"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit_deci"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"signendtime"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"revoke"});
        } else if (status.equals((Object)OperationStatus.VIEW)) {
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"revoke"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"revoke_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"signendtime"});
            } else if (this.getModel().getValue("annotype").equals("decision")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"revoke"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"revoke_deci"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"signendtime"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"richtexteditorap"});
        } else if (status.equals((Object)OperationStatus.ADDNEW)) {
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save_deci"});
                DateTimeEdit signendTime = (DateTimeEdit)this.getView().getControl("signendtime");
                signendTime.setMustInput(true);
                this.getView().setVisible(Boolean.TRUE, new String[]{"signendtime"});
            } else if (this.getModel().getValue("annotype").equals("decision")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"save_deci"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"signendtime"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"preview"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"revoke"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"revoke_deci"});
            this.getModel().setValue("formtypeid", (Object)"addnew");
        }
        if (this.getModel().getValue("annotype").equals("bidproject")) {
            this.getModel().getDataEntityType().setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        } else if (this.getModel().getValue("annotype").equals("decision")) {
            this.getModel().getDataEntityType().setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        }
    }

    public String getAppId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String serviceAppId = formShowParameter.getServiceAppId();
        String appId = "bid";
        if (Arrays.asList("rebm", "resp").contains(serviceAppId)) {
            appId = "rebm";
        }
        return appId;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String content = (String)this.getModel().getValue("content");
        ((RichTextEditor)this.getView().getControl("richtexteditorap")).setText(content);
        Long project_id = Long.valueOf(this.getModel().getValue("bidproject").toString());
        String purTypeName = "";
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)project_id, (String)"bid_project");
        if (project != null) {
            Date enrolldeadlineDate = project.getDate("enrolldeadline");
            this.getModel().setValue("signendtime", (Object)enrolldeadlineDate);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (StringUtils.equals((CharSequence)"preview", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"bar_submit", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"submit_deci", (CharSequence)evt.getItemKey())) {
            this.getModel().setValue("content", (Object)((RichTextEditor)this.getView().getControl("richtexteditorap")).getText());
            DynamicObject allBill = this.getModel().getDataEntity();
            if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("content")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u544a\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidProjectAnnouncementEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allBill});
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
            if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
                Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
                AttachmentServiceHelper.saveTempAttachments((String)this.getView().getFormShowParameter().getFormId(), (Object)this.getModel().getDataEntity().getPkValue(), (String)this.getAppId(), (Map)attachmentInfo);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String bidProjectId;
        boolean sendAnnouncementsFlag;
        boolean multipleSendProjectAnnouncementsFlag;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String appId = this.getAppId();
        if (this.getModel().getValue("annotype").equals("bidproject") && (multipleSendProjectAnnouncementsFlag = BidProjectAnnouncementsUtils.multipleSendProjectAnnouncementsFlag((String)appId)) && !(sendAnnouncementsFlag = BidProjectAnnouncementsUtils.checkManyTimesSendAnnouncements((String)appId, (Long)Long.valueOf(bidProjectId = this.getModel().getValue("bidproject").toString())))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u9001\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementEditUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"saveproject") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"savedecision")) {
            String content = ((RichTextEditor)this.getView().getControl("richtexteditorap")).getText();
            if (StringUtils.isEmpty((CharSequence)content)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u544a\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidProjectAnnouncementEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("content", (Object)((RichTextEditor)this.getView().getControl("richtexteditorap")).getText());
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"release") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"release_deci")) {
            String billstatus = this.getModel().getDataEntity(true).getString("billstatus");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u544a\u4e0d\u5904\u4e8e\u5ba1\u6838\u72b6\u6001\uff0c\u65e0\u6cd5\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementEditUI_32", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String publishstatus = (String)this.getModel().getValue("publishstatus");
            if (StringUtils.equals((CharSequence)publishstatus, (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u544a\u5df2\u7ecf\u53d1\u5e03\uff0c\u5982\u9700\u91cd\u65b0\u53d1\u5e03\u8bf7\u70b9\u51fb\u64a4\u9500\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementEditUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submitaudit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            String publishstatus;
            String content = ((RichTextEditor)this.getView().getControl("richtexteditorap")).getText();
            if (StringUtils.isEmpty((CharSequence)content)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u544a\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BidProjectAnnouncementEditUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("content", (Object)((RichTextEditor)this.getView().getControl("richtexteditorap")).getText());
            DynamicObject model = this.getModel().getDataEntity(true);
            String annotype = model.getString("annotype");
            if (StringUtils.equals((CharSequence)annotype, (CharSequence)"decision")) {
                String dbid = model.getString("decision");
                DynamicObject bidDecision = this.bidDecisionService.getBidDecisionSingle(Long.valueOf(Long.parseLong(dbid)));
                DynamicObject bidProject = bidDecision.getDynamicObject("bidproject");
                String projectName = bidProject.getString("name");
                String billstatus = (String)bidDecision.get("billstatus");
                if (billstatus == null || "".equals(billstatus) || "A".equals(billstatus) || "B".equals(billstatus) || "D".equals(billstatus) || "I".equals(billstatus)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e2d\u6807\u516c\u544a: \u5b9a\u6807\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementEditUI_29", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                    args.setCancel(true);
                    return;
                }
                if ("X".equals(billstatus)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e2d\u6807\u516c\u544a: \u5b9a\u6807\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u53d1\u9001\u4e2d\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementEditUI_30", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName));
                    args.setCancel(true);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)(publishstatus = (String)this.getModel().getValue("publishstatus")), (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u544a\u5df2\u7ecf\u53d1\u5e03\uff0c\u5982\u9700\u91cd\u65b0\u53d1\u5e03\u8bf7\u70b9\u51fb\u64a4\u9500\u53d1\u5e03\u3002", (String)"BidProjectAnnouncementEditUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject announcement = this.getView().getModel().getDataEntity(true);
                String annostatus = announcement.getString("publishstatus");
                String signEndTime = announcement.getString("signendtime");
                if (this.getModel().getValue("annotype").equals("bidproject")) {
                    if (StringUtils.isEmpty((CharSequence)signEndTime)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u7acb\u9879\u8c03\u6574\u4e2d\u8bbe\u7f6e\u3002", (String)"BidProjectAnnouncementEditUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        Date date = format.parse(signEndTime);
                        Date date1 = new Date();
                        int compareTo = date1.compareTo(date);
                        if (compareTo > 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201d\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BidProjectAnnouncementEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    }
                    catch (ParseException e) {
                        this.LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (this.getModel().getValue("annotype").equals("bidproject") && StringUtils.equals((CharSequence)annostatus, (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u62db\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4\u3002", (String)"BidProjectAnnouncementEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.getModel().getValue("annotype").equals("decision") && StringUtils.equals((CharSequence)annostatus, (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u4e2d\u6807\u516c\u544a\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4\u3002", (String)"BidProjectAnnouncementEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
            String publishstatus = this.getView().getModel().getDataEntity(true).getString("publishstatus");
            if (StringUtils.equals((CharSequence)"L", (CharSequence)publishstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidProjectAnnouncementEditUI_33", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeanno") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeanno_deci")) {
            String annostatus = BusinessDataServiceHelper.loadSingle((Object)this.getMainDataPkID(), (String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass())).getString("publishstatus");
            Date signendtime = (Date)this.getModel().getValue("signendtime");
            Date nowdate = new Date();
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                if (!StringUtils.equals((CharSequence)BillStatusEnum.RELEASED.getVal(), (CharSequence)annostatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u53d1\u5e03\u4e0d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"BidProjectAnnouncementEditUI_34", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (signendtime != null && nowdate.compareTo(signendtime) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u7684\u201d\u6295\u6807\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u201c\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"BidProjectAnnouncementEditUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter filter1 = new QFilter("announcement", "=", this.getMainDataPkID());
                DynamicObject[] supplierenrollentry = BusinessDataServiceHelper.load((String)"ten_supplierenrollentry", (String)"announcement", (QFilter[])new QFilter[]{filter1});
                if (supplierenrollentry != null && supplierenrollentry.length != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u62a5\u540d\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u62db\u6807\u516c\u544a\u3002", (String)"BidProjectAnnouncementEditUI_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            } else if (this.getModel().getValue("annotype").equals("decision") && !StringUtils.equals((CharSequence)BillStatusEnum.RELEASED.getVal(), (CharSequence)annostatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a\u5df2\u7ecf\u64a4\u9500\uff0c\u65e0\u9700\u91cd\u590d\u64a4\u9500\u3002", (String)"BidProjectAnnouncementEditUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        IDataEntityProperty pro = e.getProperty();
        String filedName = pro.getName();
        if (newVal == null || newVal != null && newVal.equals(oldVal)) {
            return;
        }
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"formtypeid")) {
            if (StringUtils.equals((CharSequence)newVal.toString(), (CharSequence)"edit")) {
                String name = this.getModel().getDataEntityType().getName();
                DynamicObject annoContent = BusinessDataServiceHelper.loadSingle((Object)this.getMainDataPkID(), (String)name, (String)"content");
                if (annoContent != null && annoContent.get("content") != null) {
                    ((RichTextEditor)this.getView().getControl("richtexteditorap")).setText(annoContent.get("content").toString());
                }
            }
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"bidanntemplate")) {
            DynamicObject template = (DynamicObject)newVal;
            String templateContent = template.getString("content");
            StringBuilder buffer = new StringBuilder();
            buffer.append(templateContent);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            DynamicObject model = this.getModel().getDataEntity(true);
            Object pkid = parameter.getCustomParam("pkid");
            if (pkid == null) {
                String bidprojectStr = this.getView().getModel().getDataEntity(true).getString("bidproject");
                if (StringUtils.isNotBlank((CharSequence)bidprojectStr)) {
                    pkid = Long.parseLong(bidprojectStr);
                } else {
                    this.getView().showTipNotification("bidproject id is null!");
                    return;
                }
            }
            if (pkid != null && !pkid.equals(0L)) {
                String parentType = model.getString("annotype");
                if (parentType != null && StringUtils.equals((CharSequence)parentType, (CharSequence)"bidproject")) {
                    this.setProjectAnnocument(pkid, parameter, buffer.toString(), model.getDate("signendtime"));
                } else if (parentType != null && StringUtils.equals((CharSequence)parentType, (CharSequence)"decision")) {
                    this.setDecisionAnnocument(pkid, parameter, buffer.toString());
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"saveproject") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"savedecision")) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                Object formtypeid = this.getModel().getValue("formtypeid");
                if (formtypeid != null && StringUtils.equals((CharSequence)"addnew", (CharSequence)formtypeid.toString())) {
                    this.getModel().setValue("formtypeid", (Object)"edit");
                }
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                if (this.getModel().getValue("annotype").equals("bidproject")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"save_deci"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"preview"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"preview_deci"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"submit_deci"});
                } else if (this.getModel().getValue("annotype").equals("decision")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"save_deci"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"preview"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"preview_deci"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"submit_deci"});
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"release") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"release_deci")) {
            this.releaseAnnouncement();
            this.getModel().setValue("publishstatus", (Object)BillStatusEnum.RELEASED.getVal());
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
                String bidProjectId = dataEntity.getString("bidproject");
                String appId = this.getAppId();
                BidProjectAnnouncementsUtils.clearApplySupplierAndTenderData((Long)((Long)dataEntity.getPkValue()), (String)appId, (Long)Long.valueOf(bidProjectId));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u62db\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementEditUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"revoke"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"revoke_deci"});
                String name = this.getModel().getDataEntityType().getName();
                DynamicObject annoContent = BusinessDataServiceHelper.loadSingle((Object)this.getMainDataPkID(), (String)name, (String)"content");
                if (annoContent != null && annoContent.get("content") != null) {
                    ((RichTextEditor)this.getView().getControl("richtexteditorap")).setText(annoContent.get("content").toString());
                }
            } else if (this.getModel().getValue("annotype").equals("decision")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementEditUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"revoke"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"revoke_deci"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"submit_deci"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"revoke_deci"});
                String name = this.getModel().getDataEntityType().getName();
                DynamicObject annoContent = BusinessDataServiceHelper.loadSingle((Object)this.getMainDataPkID(), (String)name, (String)"content");
                if (annoContent != null && annoContent.get("content") != null) {
                    ((RichTextEditor)this.getView().getControl("richtexteditorap")).setText(annoContent.get("content").toString());
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"richtexteditorap"});
            this.getModel().setDataChanged(false);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeanno") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"revokeanno_deci")) {
            this.revokeAnnouncement();
            this.getModel().setValue("publishstatus", (Object)BillStatusEnum.UNRELEASED.getVal());
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u62db\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementEditUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit_deci"});
            } else if (this.getModel().getValue("annotype").equals("decision")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4e2d\u6807\u516c\u544a\u6210\u529f\u3002", (String)"BidProjectAnnouncementEditUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"preview"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"save_deci"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"preview_deci"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"submit_deci"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"revoke_deci"});
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"richtexteditorap"});
            this.getModel().setDataChanged(false);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"previewanno") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"preview_deci")) {
            DynamicObject purTypeObj;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId("announcement_preview"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("pk", dataEntity.getPkValue());
            Long project_id = Long.valueOf((String)this.getModel().getValue("bidproject"));
            String purTypeName = "";
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)project_id, (String)"bid_project");
            if (project != null && (purTypeObj = project.getDynamicObject("purtype")) != null) {
                purTypeName = purTypeObj.getString("name");
            }
            showParameter.setCustomParam("purtype", (Object)purTypeName);
            if (this.getModel().getValue("annotype").equals("bidproject")) {
                showParameter.setCustomParam("annotitle", (Object)ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a\u8be6\u60c5", (String)"BidProjectAnnouncementEditUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                showParameter.setCustomParam("projectId", (Object)project_id);
            } else if (this.getModel().getValue("annotype").equals("decision")) {
                showParameter.setCustomParam("annotitle", (Object)ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a\u8be6\u60c5", (String)"BidProjectAnnouncementEditUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            ILocaleString str = (ILocaleString)this.getModel().getValue("annotitle");
            showParameter.setCustomParam("annocomment", (Object)str.getLocaleValue());
            if (StringUtils.equals((CharSequence)((String)this.getModel().getValue("publishstatus")), (CharSequence)BillStatusEnum.RELEASED.getVal())) {
                showParameter.setCustomParam("releasetime", this.getModel().getValue("publishdate"));
            } else {
                showParameter.setCustomParam("releasetime", (Object)new Date());
            }
            String string = this.setRichTextEditorapStr();
            if (string != null) {
                showParameter.setCustomParam("info", (Object)string);
            } else {
                showParameter.setCustomParam("info", (Object)((RichTextEditor)this.getView().getControl("richtexteditorap")).getText());
            }
            OpenStyle openStyle = showParameter.getOpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
        if (this.getView().getFormShowParameter().getCustomParam("preturnview") != null && StringUtils.equals((CharSequence)operateKey, (CharSequence)"previewanno")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
        }
    }

    private String setRichTextEditorapStr() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        List attachs = this.annocumentService.getBillAttach((Object)this.getView().getFormShowParameter().getFormId(), pkValue);
        String richStr = ((RichTextEditor)this.getView().getControl("richtexteditorap")).getText();
        return TemplateManageHelper.getRichContent(attachs, richStr, null);
    }

    private void revokeAnnouncement() {
        this.annocumentService.changeBillStatusToA(this.getMainDataPkID());
    }

    private void releaseAnnouncement() {
        Date nowdate = new Date();
        this.annocumentService.changeBillStatusToL(this.getMainDataPkID(), nowdate);
    }

    private Object getMainDataPkID() {
        return this.getModel().getDataEntity().getLong("id");
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "announcement_preview": {
                return "bid_announcement_preview";
            }
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String fieldKey = paramBeforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bidanntemplate")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String annoType = dataEntity.getString("annotype");
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"BidProjectAnnouncementEditUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                paramBeforeF7SelectEvent.setCancel(true);
                return;
            }
            long mainOrgId = org.getLong("id");
            Set orgIds = OrgUnitHelper.getParentOrgUnitSet((Long)mainOrgId);
            QFilter qFilterOrg = new QFilter("org", "in", (Object)orgIds);
            QFilter qFilterEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter qFilterEnableIsNull = new QFilter("enable", "is null", null);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            if (StringUtils.equals((CharSequence)annoType, (CharSequence)"bidproject")) {
                showParameter.setCustomParam("modelType", (Object)"bidproject");
                QFilter qFilterModelType = new QFilter("type.name", "=", (Object)ResManager.loadKDString((String)"\u62db\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                QFilter finalQfilter = qFilterOrg.and(qFilterEnable.or(qFilterEnableIsNull)).and(qFilterModelType);
                this.LOG.info("BidProjectAnnouncementEditUI\u51fd\u4ef6\u6a21\u7248\u8fc7\u6ee4\u6761\u4ef6\uff1a" + finalQfilter);
                listFilterParameter.setFilter(finalQfilter);
            } else if (StringUtils.equals((CharSequence)annoType, (CharSequence)"decision")) {
                showParameter.setCustomParam("modelType", (Object)"decision");
                QFilter qFilterModelType = new QFilter("type.name", "=", (Object)ResManager.loadKDString((String)"\u4e2d\u6807\u516c\u544a", (String)"BidProjectAnnouncementEditUI_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                QFilter finalQfilter = qFilterOrg.and(qFilterEnable.or(qFilterEnableIsNull)).and(qFilterModelType);
                this.LOG.info("BidProjectAnnouncementEditUI\u51fd\u4ef6\u6a21\u7248\u8fc7\u6ee4\u6761\u4ef6\uff1a" + finalQfilter);
                listFilterParameter.setFilter(finalQfilter);
            }
            showParameter.setListFilterParameter(listFilterParameter);
        }
    }
}

