/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.IBidPublishService;
import kd.scm.bid.business.bill.IMyTenderService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidPublishServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.MyTenderServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidPubStrategyEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.DateUtils;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.bid.formplugin.bill.util.Date4Project;
import kd.scm.bid.formplugin.bill.util.OperationLogUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidPublishEditUI
extends BidBillEdit
implements UploadListener,
CellClickListener {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String LISTENTRY_ATTCHMENT = "fbasedataid";
    private IBidPublishService publishService = new BidPublishServiceImpl();
    private IMyTenderService myTenderService = new MyTenderServiceImpl();
    private static final String CONFIRMBID = "confirmbid";
    private static final String SECTIONNAMETAB = "sectionnametab";
    private static final String KEY_CONFIRMPUBLISH = "confirmpublish";
    private static final String INVITATION = "invitation";
    private static final String OPEN = "open";
    private static final String REBM = "rebm";
    private static final String BID = "bid";
    private static final String ISREPUBLISH = "isRePublish";
    private static final String FAKE_BIDSECTION_ENTITY = "fakebidsection";
    private static final String SUPPLIERINVITATIONID = "supplierinvitationid";
    private static String BIDDOCUMENT_EDIT = "_biddocument_edit";
    private static String COM_ATTACHMENTPANEL = "com_attachmentpanel";
    private static String TECH_ATTACHMENTPANELAP = "tech_attachmentpanelap";
    private static String ATTACHMENTPANEL = "attachmentpanel";
    private static String[] keys = new String[]{"A", "B", "C", "I", "D"};
    private IBidProjectService bidProjectService = new BidProjectServiceImpl();
    private static final IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    @Override
    public String getBillId() {
        return FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass());
    }

    @Override
    protected boolean needSupplierStatisticInfo() {
        return true;
    }

    @Override
    protected boolean needFlagNewSupplier() {
        Boolean needflagnewsupplier = this.getModel().getDataEntity(true).getBoolean("needflagnewsupplier");
        return needflagnewsupplier != null && needflagnewsupplier != false;
    }

    @Override
    protected boolean needContact() {
        return true;
    }

    @Override
    protected boolean needHandleSupplier() {
        return true;
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        AttachmentPanel comAttachmentpanel = (AttachmentPanel)this.getView().getControl("com_attachmentpanel");
        comAttachmentpanel.addUploadListener((UploadListener)this);
        AttachmentPanel techAttachmentpanelap = (AttachmentPanel)this.getView().getControl("tech_attachmentpanelap");
        techAttachmentpanelap.addUploadListener((UploadListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        AttachmentPanel com = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        com.addUploadListener((UploadListener)this);
        AttachmentPanel tech = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        tech.addUploadListener((UploadListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.SUPPLIER_ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl(this.SECTION_ENTRY_ENTITY);
        sectionGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid fakeSectionGrid = (EntryGrid)this.getView().getControl(FAKE_BIDSECTION_ENTITY);
        fakeSectionGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid supplierentry = (EntryGrid)this.getView().getControl("supplierentry");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    private void updatePubStrategy() {
        String sourcePublish = this.getModel().getValue("sourcepublish").toString();
        if (!StringUtils.isEmpty((CharSequence)sourcePublish) && !"0".equals(sourcePublish)) {
            DynamicObjectCollection bidSection = this.getModel().getEntryEntity("bidsection");
            for (int i = 0; i < bidSection.size(); ++i) {
                DynamicObject bidSectionRow = (DynamicObject)bidSection.get(i);
                DynamicObjectCollection supplierEntry = bidSectionRow.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntry.size(); ++j) {
                    DynamicObject supplierEntryRow = (DynamicObject)supplierEntry.get(j);
                    if (!BidPubStrategyEnum.PLUS.getValue().equals(supplierEntryRow.getString("pubstrategy"))) {
                        supplierEntryRow.set("pubstrategy", (Object)BidPubStrategyEnum.RE.getValue());
                    }
                    supplierEntryRow.set("tenderstrategy", (Object)"NEEDBID");
                }
            }
            this.getView().updateView("supplierentry");
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        this.getPageCache().put("isChanged", "1");
        this.changeDocText();
        this.updatePubStrategy();
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        this.getPageCache().put("isChanged", "1");
        this.changeDocText();
        this.updatePubStrategy();
    }

    public void changeDocText() {
        String sourcepublish = this.getModel().getValue("sourcepublish").toString();
        if (this.getView().getFormShowParameter().getCustomParam(ISREPUBLISH) != null || this.getView().getFormShowParameter().getCustomParam("sourcePublishId") != null || !sourcepublish.equals("0")) {
            this.getModel().getDataEntity().set("isdocchange", (Object)Boolean.TRUE);
            this.getView().setVisible(Boolean.TRUE, new String[]{"doccontent"});
            ((Label)this.getView().getControl("doccontent")).setText(ResManager.loadKDString((String)"\u6807\u4e66\u5185\u5bb9\u5df2\u53d1\u751f\u53d8\u5316\u3002", (String)"BidPublishEditUI_889", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.setTenderStrategy(this.getModel().getDataEntity(true));
        }
    }

    public void setTenderStrategy(DynamicObject publish) {
        boolean enablemultisection = publish.getDynamicObject("bidproject").getBoolean("enablemultisection");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("bidsection");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u6807\u6bb5\uff0c\u8bf7\u5148\u9009\u4e2d\u6807\u6bb5\u6216\u91cd\u65b0\u6253\u5f00\u5355\u636e\u8bd5\u4e00\u4e0b\u3002", (String)"BidPublishEditUI_888", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        int row = selectRows[0];
        Map<Long, Map<String, Object>> supplierAndSectionNameStatus = this.getTenderSuplierAndSectionStatus();
        if (!supplierAndSectionNameStatus.isEmpty()) {
            boolean isDocChange = publish.getBoolean("isdocchange");
            DynamicObjectCollection sectionColl = publish.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < sectionColl.size(); ++i) {
                String sectionName = ((DynamicObject)sectionColl.get(i)).getString("sectionname");
                DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                this.docChangeSetTenderStatusAndTenderstrategy(supplierEntryColl, supplierAndSectionNameStatus, sectionName, isDocChange);
                this.setTenderStrategyEditable(row);
            }
            this.getView().updateView("supplierentry");
        }
    }

    public void docChangeSetTenderStatusAndTenderstrategy(DynamicObjectCollection supplierEntryColl, Map<Long, Map<String, Object>> supplierAndSectionNameStatus, String sectionName, boolean isDocChange) {
        for (int j = 0; j < supplierEntryColl.size(); ++j) {
            DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
            Long supplierId = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
            String invalidflag = supplierEntry.getString("invalidflag");
            boolean isnew = supplierEntry.getBoolean("isnew");
            boolean isFromHistory = supplierEntry.getBoolean("isfromhistory");
            Map<String, Object> SectionNameStatusMap = supplierAndSectionNameStatus.get(supplierId);
            if (SectionNameStatusMap == null) continue;
            String tenderStatus = null;
            if (SectionNameStatusMap.get(sectionName) != null) {
                tenderStatus = SectionNameStatusMap.get(sectionName).toString();
            }
            if (isnew && !isFromHistory || tenderStatus == null) continue;
            if ("TENDERED".equals(tenderStatus) || "UNTENDERED".equals(tenderStatus) || "PRETENDERED".equals(tenderStatus)) {
                supplierEntry.set("tenderstatus", (Object)tenderStatus);
            }
            if (tenderStatus.equals("TENDERED")) {
                if (isDocChange) {
                    supplierEntry.set("tenderstrategy", (Object)"NEEDBID");
                    if (!invalidflag.equals("1")) continue;
                    supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
                    continue;
                }
                supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
                continue;
            }
            if (tenderStatus.equals("PRETENDERED")) {
                supplierEntry.set("tenderstrategy", (Object)"");
                continue;
            }
            if (!tenderStatus.equals("UNTENDERED")) continue;
            supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
        }
    }

    public void beforeBindData(EventObject e) {
        boolean isdocchange;
        Date auditDate;
        String appId;
        DynamicObject bidDocument;
        super.beforeBindData(e);
        DynamicObject publish = this.getModel().getDataEntity(true);
        String operateStatus = this.getView().getFormShowParameter().getStatus().name();
        Object pk = (Long)this.getModel().getDataEntity().getPkValue();
        String billStatus = (String)this.getModel().getValue("billstatus");
        String sourId = publish.get("sourcepublish").toString();
        DynamicObject bidProject = publish.getDynamicObject("bidproject");
        this.setBackbidWayVisible(bidProject);
        this.setFieldEditableAndVisble();
        this.setPublishTimes(publish, this.getModel().getDataEntityType().getAppId());
        Object sourcePublishId = this.getView().getFormShowParameter().getCustomParam("sourcePublishId");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (sourcePublishId != null || billStatus.equals("D") && !sourId.equals("0")) {
            boolean isdocchange2 = this.checkDocumentIsChange();
            String isChanged = this.getPageCache().get("isChanged");
            if (StringUtils.isNotEmpty((CharSequence)isChanged) && isChanged.equals("1")) {
                this.getModel().setValue("isdocchange", (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue("isdocchange", (Object)isdocchange2);
            }
        }
        boolean exists = this.checkIsExist();
        if (operateStatus.equals("ADDNEW")) {
            int i;
            Object id;
            this.getView().setVisible(Boolean.TRUE, new String[]{CONFIRMBID});
            if (StringUtils.equals((CharSequence)"0", (CharSequence)((Long)pk).toString())) {
                pk = id = Long.valueOf(ORM.create().genLongId((IDataEntityType)this.publishService.createBidPublishType()));
                this.getModel().setValue("id", pk);
            }
            if ((id = this.getView().getFormShowParameter().getCustomParam("sourcePublishId")) != null) {
                this.getModel().setValue("sourcepublish", (Object)Long.parseLong(id.toString()));
                this.getModel().setValue("source", (Object)"republish");
                this.getModel().setValue("projecttime", (Object)(bidProject.getPkValue().toString() + "" + new Date().getTime()));
                QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
                if (publish.getDynamicObject(SUPPLIERINVITATIONID) != null) {
                    bidProjectFilter.and(new QFilter(SUPPLIERINVITATIONID, "=", publish.getDynamicObject(SUPPLIERINVITATIONID).getPkValue()));
                }
                bidProjectFilter.and(new QFilter("billstatus", "!=", (Object)"XX"));
                DynamicObject[] openTempColl = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidopen"), (String)"id,billstatus,opentype,bidsection,bidsection.sectionname,bidsection.supplierentry,supplierentry.supplier,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.supplier_comment,supplierentry.supplier_isinvalid,supplierentry.supplier_istender", (QFilter[])new QFilter[]{bidProjectFilter});
                DynamicObjectCollection opens = new DynamicObjectCollection();
                for (i = 0; i < openTempColl.length; ++i) {
                    DynamicObject openTemp = openTempColl[i];
                    String openBillStatus = openTemp.getString("billstatus");
                    if (!StringUtils.equals((CharSequence)"O", (CharSequence)openBillStatus) && !StringUtils.equals((CharSequence)"C", (CharSequence)openBillStatus)) continue;
                    opens.add((Object)openTemp);
                }
                if (opens.size() > 0 && !exists) {
                    this.setOpenBillData(opens, publish);
                }
            }
            this.setSupplierEntryRow();
            DynamicObject bidPublish = this.getModel().getDataEntity(true);
            DynamicObjectCollection bidSection = bidPublish.getDynamicObjectCollection("bidsection");
            if (bidSection != null && bidSection.size() > 0) {
                ArrayList emptyList = new ArrayList(16);
                for (i = 0; i < bidSection.size(); ++i) {
                    DynamicObjectCollection supplierEntry;
                    ((DynamicObject)bidSection.get(i)).set("importtext", (Object)"importtext");
                    DynamicObjectCollection purColl = ((DynamicObject)bidSection.get(i)).getDynamicObjectCollection("projectdetail");
                    if (purColl != null && purColl.size() > 0) {
                        for (int j = 0; j < purColl.size(); ++j) {
                            ((DynamicObject)purColl.get(j)).set("importtext2", (Object)"importtext2");
                        }
                    }
                    if (!BillStatusEnum.SAVE.getVal().equals(billStatus) || (supplierEntry = ((DynamicObject)bidSection.get(i)).getDynamicObjectCollection("supplierentry")) == null || supplierEntry.size() <= 0) continue;
                    for (int j = 0; j < supplierEntry.size(); ++j) {
                        DynamicObject supplierEntryRow = (DynamicObject)supplierEntry.get(j);
                        supplierEntryRow.set("pubstrategy", (Object)BidPubStrategyEnum.KEEP.getValue());
                        supplierEntryRow.set("isfromhistory", (Object)Boolean.TRUE);
                        supplierEntryRow.set("isnew", (Object)Boolean.FALSE);
                        supplierEntryRow.set("repdescription", null);
                        DynamicObjectCollection republishattachment = supplierEntryRow.getDynamicObjectCollection("republishattachment");
                        republishattachment.clear();
                    }
                }
            }
            this.getView().updateView("supplierentry");
            String bidProjectId = bidProject.getString("id");
            DynamicObject biddocument = BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)"id,evaluatedecideway,entitytypeid,auditdate", (QFilter[])new QFilter[]{new QFilter(this.BID_PROJECT, "=", (Object)Long.valueOf(bidProjectId)), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal())});
            if (biddocument != null) {
                if (id != null) {
                    DynamicObject oldPublish = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_bidpublish");
                    this.getModel().setValue("evaluatedecideway", oldPublish.get("evaluatedecideway.id"));
                    Date finalDocAuditDate = biddocument.getDate("auditdate");
                    Date oldDate = oldPublish.getDate("modifytime");
                    if (finalDocAuditDate.getTime() > oldDate.getTime()) {
                        String bidDocumentId = String.valueOf(biddocument.get("id"));
                        boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
                        if (isseparatedoc) {
                            BidFileHelper.copyBidDocumentFileToBillExpComAndTech((String)this.getAppId(), (Object)bidDocumentId, (String)"all", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk);
                        } else {
                            BidFileHelper.copyBidDocumentFileToBill((String)this.getAppId(), (Object)bidDocumentId, (String)"all", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk);
                        }
                        this.getModel().setValue("evaluatedecideway", biddocument.get("evaluatedecideway.id"));
                        this.updatePubStrategy();
                    } else {
                        boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
                        if (isseparatedoc) {
                            BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"attachmentpanel", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"attachmentpanel");
                            BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"com_attachmentpanel", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"com_attachmentpanel");
                            BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"tech_attachmentpanelap", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"tech_attachmentpanelap");
                        } else {
                            BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"attachmentpanel", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"attachmentpanel");
                        }
                    }
                    this.getModel().setValue("biddocument", biddocument.getPkValue());
                }
            } else {
                boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
                if (isseparatedoc) {
                    BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"attachmentpanel", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"attachmentpanel");
                    BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"com_attachmentpanel", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"com_attachmentpanel");
                    BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"tech_attachmentpanelap", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"tech_attachmentpanelap");
                } else {
                    BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"attachmentpanel", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"attachmentpanel");
                }
            }
            BidFileHelper.copyFileFromAToB((String)(this.getAppId() + "_" + "bidpublish"), (Object)id, (String)"attachmentpanelap", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk, (String)"attachmentpanelap");
        }
        String sourceId = this.getModel().getValue("sourcepublish").toString();
        if ((billStatus.equals("A") || billStatus.equals("D")) && !sourceId.equals("0") && (bidDocument = BusinessDataServiceHelper.loadSingle((String)((appId = this.getModel().getDataEntityType().getAppId()) + "_biddocument_edit"), (String)"id,billstatus,auditdate", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"C")})) != null) {
            auditDate = bidDocument.getDate("auditdate");
            DynamicObject oldPublish = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sourceId), (String)"bid_bidpublish");
            Date oldModifytime = oldPublish.getDate("modifytime");
            Date modifyTime = publish.getDate("modifytime");
            if (oldModifytime != null && oldModifytime.compareTo(auditDate) < 0 && (modifyTime == null || modifyTime != null && auditDate.compareTo(modifyTime) > 0)) {
                this.deleteAttachment();
                boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
                if (bidDocument != null) {
                    if (isseparatedoc) {
                        BidFileHelper.copyBidDocumentFileToBillExpComAndTech((String)this.getAppId(), (Object)bidDocument.getPkValue(), (String)"all", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk);
                    } else {
                        BidFileHelper.copyBidDocumentFileToBill((String)this.getAppId(), (Object)bidDocument.getPkValue(), (String)"all", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk);
                    }
                }
            }
        }
        if (operateStatus.equals("EDIT") && sourceId.equals("0") && (billStatus.equals("A") || billStatus.equals("D")) && (bidDocument = BusinessDataServiceHelper.loadSingle((String)((appId = this.getModel().getDataEntityType().getAppId()) + "_biddocument_edit"), (String)"id,billstatus,auditdate", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "=", (Object)"C")})) != null) {
            auditDate = bidDocument.getDate("auditdate");
            Date modifyTime = publish.getDate("modifytime");
            if (modifyTime == null || modifyTime != null && auditDate.compareTo(modifyTime) > 0) {
                this.deleteAttachment();
                boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
                if (isseparatedoc) {
                    BidFileHelper.copyBidDocumentFileToBillExpComAndTech((String)this.getAppId(), (Object)bidDocument.getPkValue(), (String)"all", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk);
                } else {
                    BidFileHelper.copyBidDocumentFileToBill((String)this.getAppId(), (Object)bidDocument.getPkValue(), (String)"all", (String)(this.getAppId() + "_" + "bidpublish"), (Object)pk);
                }
            }
        }
        if ((isdocchange = this.getModel().getDataEntity().getBoolean("isdocchange")) && !sourceId.equals("0")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"doccontent"});
            ((Label)this.getView().getControl("doccontent")).setText(ResManager.loadKDString((String)"\u6807\u4e66\u5185\u5bb9\u5df2\u53d1\u751f\u53d8\u5316\u3002", (String)"BidPublishEditUI_889", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"doccontent"});
        }
        this.copyBidsectionToFakeBidsection_beforeBindData();
        String sourcePublish = publish.get("sourcepublish").toString();
        this.setDatetime();
        this.rePublish_BeforeBindData();
        if (this.getView().getFormShowParameter().getCustomParam(ISREPUBLISH) == null && "0".equals(sourcePublish) || billStatus.equals("J") && billStatus.equals("X")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tenderstrategy", "tenderstatus", "invalidflag", "republishattachment", "repdescription"});
        }
        this.getModel().setDataChanged(false);
    }

    public void setOpenBillData(DynamicObjectCollection opens, DynamicObject publish) {
        Object openSupplierEntry;
        List supplierList;
        String appId = this.getModel().getDataEntityType().getAppId();
        DynamicObject bidProject = publish.getDynamicObject("bidproject");
        String bidOpenType = bidProject.getString("bidopentype");
        DynamicObjectCollection publishBidSectionColl = publish.getDynamicObjectCollection("bidsection");
        HashMap sectionNameAndSupplierEntryMap = new HashMap();
        ArrayList<Object> openList = new ArrayList<Object>();
        int size = opens.size();
        if (size == 2) {
            DynamicObject open1 = (DynamicObject)opens.get(0);
            DynamicObject open2 = (DynamicObject)opens.get(1);
            String openType = open1.getString("opentype");
            if (bidOpenType.equals("TECHBUSINESS")) {
                if (openType.equals("TECHNICAL")) {
                    openList.add(open1);
                    openList.add(open2);
                } else {
                    openList.add(open2);
                    openList.add(open1);
                }
            } else if (openType.equals("TECHNICAL")) {
                openList.add(open2);
                openList.add(open1);
            } else {
                openList.add(open1);
                openList.add(open2);
            }
        } else {
            openList.add(opens.get(0));
        }
        for (int m = 0; m < openList.size(); ++m) {
            DynamicObject open = (DynamicObject)openList.get(m);
            DynamicObjectCollection openBidSectionColl = open.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < openBidSectionColl.size(); ++i) {
                int j;
                DynamicObject openBidSection = (DynamicObject)openBidSectionColl.get(i);
                String sectionName = openBidSection.getString("sectionname");
                supplierList = new ArrayList();
                DynamicObjectCollection openSupplierEntryColl = openBidSection.getDynamicObjectCollection("supplierentry");
                List supplierListTemp = (List)sectionNameAndSupplierEntryMap.get(sectionName);
                if (supplierListTemp != null) {
                    for (j = 0; j < supplierListTemp.size(); ++j) {
                        Map map = (Map)supplierListTemp.get(j);
                        DynamicObject supplier = (DynamicObject)map.get("supplier");
                        for (int k = 0; k < openSupplierEntryColl.size(); ++k) {
                            DynamicObject openSupplierEntry2 = (DynamicObject)openSupplierEntryColl.get(k);
                            DynamicObject openSuplier = openSupplierEntry2.getDynamicObject("supplier");
                            if (!supplier.getPkValue().toString().equals(openSuplier.getPkValue().toString())) continue;
                            map.put("supplier_istender", openSupplierEntry2.getString("supplier_istender"));
                            Boolean isInvalid = openSupplierEntry2.getBoolean("supplier_isinvalid");
                            map.put("supplier_isinvalid", isInvalid.toString());
                        }
                    }
                    continue;
                }
                for (j = 0; j < openSupplierEntryColl.size(); ++j) {
                    openSupplierEntry = (DynamicObject)openSupplierEntryColl.get(j);
                    HashMap<String, Object> supplierMap = new HashMap<String, Object>();
                    DynamicObject openSuplier = openSupplierEntry.getDynamicObject("supplier");
                    supplierMap.put("supplier", openSuplier);
                    supplierMap.put("suppliercontact", openSupplierEntry.getString("suppliercontact"));
                    supplierMap.put("contactphone", openSupplierEntry.getString("contactphone"));
                    supplierMap.put("supplier_istender", openSupplierEntry.getString("supplier_istender"));
                    supplierMap.put("suppliercomment", openSupplierEntry.getString("supplier_comment"));
                    Boolean isInvalid = openSupplierEntry.getBoolean("supplier_isinvalid");
                    supplierMap.put("supplier_isinvalid", isInvalid.toString());
                    supplierList.add(supplierMap);
                }
                sectionNameAndSupplierEntryMap.put(sectionName, supplierList);
            }
        }
        HashSet<Long> supplierIds = new HashSet<Long>();
        DynamicObjectCollection publishBidSectionCollTemp = publish.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < publishBidSectionCollTemp.size(); ++i) {
            DynamicObject publishBidSection = (DynamicObject)publishBidSectionCollTemp.get(i);
            DynamicObjectCollection openSupplierEntryColl = publishBidSection.getDynamicObjectCollection("supplierentry");
            for (int k = 0; k < openSupplierEntryColl.size(); ++k) {
                DynamicObject openSupplierEntry3 = (DynamicObject)openSupplierEntryColl.get(k);
                DynamicObject supplier = openSupplierEntry3.getDynamicObject("supplier");
                supplierIds.add((Long)supplier.getPkValue());
            }
        }
        DynamicObject[] supplierStatistics = BusinessDataServiceHelper.load((String)(appId + "_supplierstatistic"), (String)"id,supplier,invitedqty,wonqty,entitytypeid", (QFilter[])new QFilter[]{new QFilter("supplier.id", "in", supplierIds)});
        for (int k = 0; k < publishBidSectionColl.size(); ++k) {
            DynamicObject publishBidSection = (DynamicObject)publishBidSectionColl.get(k);
            String publishSectionName = publishBidSection.getString("sectionname");
            supplierList = (List)sectionNameAndSupplierEntryMap.get(publishSectionName);
            DynamicObjectCollection pubSupplierEntryColl = publishBidSection.getDynamicObjectCollection("supplierentry");
            pubSupplierEntryColl.clear();
            for (int n = 0; n < supplierList.size(); ++n) {
                DynamicObject pubSupplierEntryNew = pubSupplierEntryColl.addNew();
                openSupplierEntry = (Map)supplierList.get(n);
                pubSupplierEntryNew.set("supplier", openSupplierEntry.get("supplier"));
                pubSupplierEntryNew.set("suppliercontact", openSupplierEntry.get("suppliercontact"));
                pubSupplierEntryNew.set("contactphone", openSupplierEntry.get("contactphone"));
                pubSupplierEntryNew.set("suppliercomment", openSupplierEntry.get("suppliercomment"));
                String isInvalid = (String)openSupplierEntry.get("supplier_isinvalid");
                if (isInvalid.equals("true")) {
                    pubSupplierEntryNew.set("invalidflag", (Object)"1");
                } else {
                    pubSupplierEntryNew.set("invalidflag", (Object)"0");
                }
                for (int l = 0; l < supplierStatistics.length; ++l) {
                    DynamicObject supplierStatistic = supplierStatistics[l];
                    DynamicObject temp = supplierStatistic.getDynamicObject("supplier");
                    if (!temp.getPkValue().toString().equals(((DynamicObject)openSupplierEntry.get("supplier")).getPkValue().toString())) continue;
                    pubSupplierEntryNew.set("supplierstatistic", (Object)supplierStatistic);
                }
            }
        }
    }

    @Override
    public void afterBindData(EventObject eventobject) {
        boolean enable;
        String billStatus;
        String operateStatus;
        super.afterBindData(eventobject);
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        this.setBidModelStatus();
        this.setButtonVisible();
        this.setBillStatus();
        this.setBackbidWayVisible(bidProject);
        Object id = this.getView().getFormShowParameter().getCustomParam("sourcePublishId");
        if (id != null) {
            this.getModel().setValue("sourcepublish", (Object)Long.parseLong(id.toString()));
        }
        if ((operateStatus = this.getView().getFormShowParameter().getStatus().name()).equals("ADDNEW")) {
            this.getModel().setDataChanged(false);
        }
        if ((billStatus = (String)this.getModel().getValue("billstatus")).equals(BillStatusEnum.DISBEGIN.getVal())) {
            Object fromUpdecide = this.getModel().getValue("evaluatedecideway");
            if (fromUpdecide == null) {
                this.getModel().setValue("evaluatedecideway", (Object)this.getDecideWay());
            }
            this.getPageCache().put("isChanged", "0");
        }
        this.getPageCache().put("isChanged", "0");
        String sourcepublish = this.getModel().getValue("sourcepublish").toString();
        if (StringUtils.isEmpty((CharSequence)sourcepublish) || "0".equals(sourcepublish)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pubstrategy"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pubstrategy"});
        }
        this.setPurTypeModelStatus();
        this.controlListBtnStatus();
        this.getModel().setDataChanged(false);
        if (!BillStatusEnum.PUBLISHED.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrepublishbid"});
        } else if (!this.canRePublish(bidProject.getLong("id"), false)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrepublishbid"});
        }
        DynamicObject bidProEvaluateDecideWay = bidProject.getDynamicObject("evaluatedecideway");
        if (bidProEvaluateDecideWay != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"evaluatedecideway"});
        }
        if (!(enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrepublishbid"});
        }
        if (!billStatus.equals("A") && !billStatus.equals("D")) {
            this.setTenderStrategy();
        } else {
            this.setTenderStrategyEditable(0);
        }
        if (enable && !Arrays.asList(keys).contains(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isillegalbid", "isdowndoc", "downdoctime", "downdocip", "downdocuser", "downrecord"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isillegalbid", "isdowndoc", "downdoctime", "downdocip", "downdocuser", "downrecord"});
        }
        DynamicObject bidproject = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
        bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(this.getAppId() + "_project"), (String)"is_enc_enable");
        boolean isEncEnable = bidproject.getBoolean("is_enc_enable");
        long sourcepublish1 = (Long)this.getModel().getValue("sourcepublish");
        if (sourcepublish1 == 0L || !isEncEnable) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"shuffleorderflag"});
        }
    }

    public void copyBidsectionToFakeBidsection_beforeBindData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSections = dataEntity.getDynamicObjectCollection(this.SECTION_ENTRY_ENTITY);
        DynamicObjectCollection fakeBidSections = dataEntity.getDynamicObjectCollection(FAKE_BIDSECTION_ENTITY);
        fakeBidSections.clear();
        if (!bidSections.isEmpty()) {
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSections.get(i);
                DynamicObject addfakeBidSection = fakeBidSections.addNew();
                addfakeBidSection.set("fakebidsectionname", bidSection.get("sectionname"));
                addfakeBidSection.set("seq", (Object)(i + 1));
            }
        }
    }

    public void copyBidsectionToFakeBidsection_afterDoOperation() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSections = dataEntity.getDynamicObjectCollection(this.SECTION_ENTRY_ENTITY);
        DynamicObjectCollection fakeBidSections = dataEntity.getDynamicObjectCollection(FAKE_BIDSECTION_ENTITY);
        fakeBidSections.clear();
        if (!bidSections.isEmpty()) {
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSections.get(i);
                int index = this.getModel().createNewEntryRow(FAKE_BIDSECTION_ENTITY);
                this.getModel().setValue("fakebidsectionname", bidSection.get("sectionname"), index);
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void cearleFakeBidsection() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection fakeBidSections = dataEntity.getDynamicObjectCollection(FAKE_BIDSECTION_ENTITY);
        fakeBidSections.clear();
    }

    @Override
    public void entryRowClick(RowClickEvent rowclickevent) {
        super.entryRowClick(rowclickevent);
        EntryGrid entryGrid = (EntryGrid)rowclickevent.getSource();
        int rowIndex = rowclickevent.getRow();
        if (rowIndex != -1) {
            if (this.SECTION_ENTRY_ENTITY.equals(entryGrid.getKey())) {
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl(FAKE_BIDSECTION_ENTITY);
                entryEntityGrid.selectRows(rowIndex, true);
                String billStatus = this.getModel().getDataEntity().getString("billstatus");
                if (!billStatus.equals("A") && !billStatus.equals("D")) {
                    this.setTenderStrategy();
                    return;
                }
                DynamicObjectCollection sectionColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
                for (int i = 0; i < sectionColl.size(); ++i) {
                    if (i != rowIndex) continue;
                    DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        this.getView().setEnable(Boolean.FALSE, new String[]{"tenderstrategy"});
                        String tenderStatus = supplierEntry.getString("tenderstatus");
                        if (!StringUtils.isEmpty((CharSequence)tenderStatus)) {
                            if (tenderStatus.equals("PRETENDERED")) {
                                this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
                                continue;
                            }
                            this.getView().setEnable(Boolean.TRUE, j, new String[]{"tenderstrategy"});
                            continue;
                        }
                        this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
                    }
                }
                this.getView().updateView("supplierentry");
            } else if (FAKE_BIDSECTION_ENTITY.equals(entryGrid.getKey())) {
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl(this.SECTION_ENTRY_ENTITY);
                entryEntityGrid.selectRows(rowIndex, true);
            }
        }
    }

    private void setPurTypeModelStatus() {
        DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
        DynamicObject projectdata = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bid_project");
        int bidtype = projectdata.getInt("bidtype");
        boolean isMultisection = project.getBoolean("enablemultisection");
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        if (splitContainer != null) {
            if (isMultisection) {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
        }
        boolean isratebidding = project.getBoolean("isratebidding");
        if (bidtype == 1 || bidtype == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialdes"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxprice"});
            if (!isratebidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"costrate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"excepttaxamount"});
            }
        }
    }

    public Long getDecideWay() {
        return 493255064807351296L;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (billStatus != null) {
            String changeFlag;
            if (billStatus.equals(BillStatusEnum.DISBEGIN.getVal())) {
                String changeFlag2 = this.getPageCache().get("isChanged");
                if (changeFlag2.equals("0")) {
                    this.getModel().setDataChanged(false);
                }
            } else if (!billStatus.equals(BillStatusEnum.SAVE.getVal()) && (changeFlag = this.getPageCache().get("isChanged")).equals("0")) {
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject bidPublish;
        Object pkValue;
        boolean exists;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey()) && !(exists = QueryServiceHelper.exists((String)"bid_bidpublish", (Object)(pkValue = this.getModel().getDataEntity().getPkValue())))) {
            args.setCancel(true);
            return;
        }
        String operateStatus = this.getView().getFormShowParameter().getStatus().name();
        this.cearleFakeBidsection();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save") || StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            if (operateStatus.equals("ADDNEW")) {
                Long id;
                DynamicObject isHave;
                Long sId = Long.valueOf(String.valueOf(this.getModel().getValue("sourcepublish")));
                if (sId != null && !String.valueOf(sId).equals("0") && (isHave = this.publishService.getBidPublishUnique(sId, id = (Long)this.getModel().getValue("id"), this.getView().getEntityId())) != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u5df2\u5b58\u5728\u518d\u6b21\u53d1\u6807\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BidPublishEditUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean canRePub = this.publishService.checkNextStepUnStarted((DynamicObject)this.getModel().getValue("bidproject"), BidStepEnum.BidAnswerQuestion);
                if (canRePub) {
                    DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
                    Long l = project.getLong("id");
                }
            }
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)((String)this.getModel().getValue("billstatus"))) && this.getModel().getDataChanged()) {
                this.getModel().setValue("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            }
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            this.checkDocument(args);
            DynamicObject bidPublish2 = this.getModel().getDataEntity(true);
            Long projectId = (Long)bidPublish2.getDynamicObject("bidproject").getPkValue();
            QFilter bidProjectFilter = new QFilter("bidproject.id", "=", (Object)projectId);
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"B").or(new QFilter("billstatus", "=", (Object)"I"));
            DynamicObject[] supplierInvitations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            DynamicObject[] bidDocuments = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"B", "I", "P"}), bidProjectFilter});
            DynamicObject[] onlineBidEvals = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            if (supplierInvitations.length > 0) {
                DynamicObject supplierInvitation = supplierInvitations[0];
                String billstatus = supplierInvitation.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishEditUI_890", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishEditUI_891", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (bidDocuments.length > 0) {
                DynamicObject bidDocument = bidDocuments[0];
                String billstatus = bidDocument.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishEditUI_892", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishEditUI_893", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (bidOpens.length > 0) {
                DynamicObject bidOpen = bidOpens[0];
                String billstatus = bidOpen.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else if (billstatus.equals("I")) {
                    this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u4e2d", (String)"BidPublishEditUI_116", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (onlineBidEvals.length > 0) {
                DynamicObject onlineBidEval = onlineBidEvals[0];
                String billstatus = onlineBidEval.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishEditUI_894", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishEditUI_895", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (bidEvaluations.length > 0) {
                DynamicObject bidEvaluation = bidEvaluations[0];
                String billstatus = bidEvaluation.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
        }
        if ("deleteentry".equals(operate.getOperateKey())) {
            EntryGrid sectionGrid = (EntryGrid)this.getControl("bidsection");
            int[] selects = sectionGrid.getSelectRows();
            EntryGrid supplierGrid = (EntryGrid)this.getControl("supplierentry");
            int[] suppliers = supplierGrid.getSelectRows();
            DynamicObjectCollection bidSectionColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
            if (suppliers != null && suppliers.length > 0) {
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    if (selects[0] != i) continue;
                    DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        if (suppliers[0] != j) continue;
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                        boolean isNew = supplierEntry.getBoolean("isnew");
                        boolean isFromProject = supplierEntry.getBoolean("isfromproject");
                        if (isFromProject || isNew) continue;
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u4f9b\u5e94\u5546\u662f\u7531\u5165\u56f4\u73af\u8282\u5e26\u5165\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BidPublishEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"republish")) {
            if (this.validatorRePublish()) {
                args.setCancel(true);
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getCustomParams().put("iscopy", Boolean.TRUE);
            parameter.getCustomParams().put("isCopyRelateEntity", Boolean.TRUE);
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setPkId(this.getModel().getDataEntity().getPkValue());
            parameter.setCustomParam("sourcePublishId", this.getModel().getDataEntity().getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "doRepublish");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)parameter);
        }
        if ("delete".equals(operate.getOperateKey()) && (bidPublish = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"bidproject.billno,bidproject.name,source,billstatus")) != null) {
            String source = bidPublish.getString("source");
            if (!StringUtils.isEmpty((CharSequence)"source") && source.equals("resupplierInvitation")) {
                String billStatus = bidPublish.getString("billstatus");
                if (!billStatus.equals("A")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u6570\u636e\u3002", (String)"BidPublishEditUI_117", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
                } else {
                    bidPublish.set("billstatus", (Object)"D");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
                    this.getView().close();
                }
                args.setCancel(true);
                return;
            }
        }
    }

    protected boolean validatorRePublish() {
        DynamicObject bidDecision;
        String billStatusTemp;
        DynamicObject bidPublish = this.getModel().getDataEntity(true);
        String billStatus = bidPublish.getString("billstatus");
        boolean isNewBill = bidPublish.getBoolean("isnewbill");
        if (!isNewBill) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u62db\u6807\u7acb\u9879\u5df2\u5b58\u5728\u65b0\u7684\u53d1\u6807\u5355\u636e\uff0c\u8bf7\u5bf9\u65b0\u5355\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"BidPublishEditUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
            return true;
        }
        QFilter projectFilter = new QFilter("bidproject", "=", bidPublish.getDynamicObject("bidproject").getPkValue());
        DynamicObject[] bidDecisionCol = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{projectFilter});
        if (bidDecisionCol != null && bidDecisionCol.length > 0 && !(billStatusTemp = (bidDecision = bidDecisionCol[0]).getString("billstatus")).equals("D") && !billStatusTemp.equals("XX")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u62db\u6807\u7acb\u9879\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidDecisionCol[0].get("bidproject.billno")));
            return true;
        }
        if (!StringUtils.equals((CharSequence)BillStatusEnum.PUBLISHED.getVal(), (CharSequence)billStatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u4ec5\u652f\u6301\u5bf9\u5df2\u786e\u8ba4\u53d1\u6807\u7684\u53d1\u6807\u5355\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_896", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
            return true;
        }
        Object bidproject = bidPublish.getDynamicObject("bidproject").getPkValue();
        boolean flag = QueryServiceHelper.exists((String)(this.getAppId() + "_supplierinvalid"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "!=", (Object)"C")});
        if (flag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return true;
        }
        String appId = this.getAppId();
        boolean exsitBackBid = new ReBackBidUtil(appId).checkBackBidFinished(bidproject);
        if (exsitBackBid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5728\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_60", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return true;
        }
        String checkQueryIsProcess = questionClarifyService.checkQueryIsProcess(Long.valueOf(Long.parseLong(bidproject.toString())), appId);
        if (StringUtils.isNotBlank((CharSequence)checkQueryIsProcess)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)checkQueryIsProcess, (String)"BidPublishListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return true;
        }
        Long projectId = (Long)bidPublish.getDynamicObject("bidproject").getPkValue();
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"B").or(new QFilter("billstatus", "=", (Object)"I"));
        DynamicObject[] supplierInvitations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
        DynamicObject[] bidDocuments = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
        DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"B", "I", "P"}), bidProjectFilter});
        DynamicObject[] onlineBidEvals = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
        DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
        if (supplierInvitations.length > 0) {
            DynamicObject supplierInvitation = supplierInvitations[0];
            String billstatus = supplierInvitation.getString("billstatus");
            if (billstatus.equals("B")) {
                this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishEditUI_890", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishEditUI_891", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        if (bidDocuments.length > 0) {
            DynamicObject bidDocument = bidDocuments[0];
            String billstatus = bidDocument.getString("billstatus");
            if (billstatus.equals("B")) {
                this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishEditUI_892", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishEditUI_893", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        if (bidOpens.length > 0) {
            DynamicObject bidOpen = bidOpens[0];
            String billstatus = bidOpen.getString("billstatus");
            if (billstatus.equals("B")) {
                this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishEditUI_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else if (billstatus.equals("I")) {
                this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishEditUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u4e2d", (String)"BidPublishEditUI_116", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        if (onlineBidEvals.length > 0) {
            DynamicObject onlineBidEval = onlineBidEvals[0];
            String billstatus = onlineBidEval.getString("billstatus");
            if (billstatus.equals("B")) {
                this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishEditUI_894", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishEditUI_895", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        if (bidEvaluations.length > 0) {
            DynamicObject bidEvaluation = bidEvaluations[0];
            String billstatus = bidEvaluation.getString("billstatus");
            if (billstatus.equals("B")) {
                this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishEditUI_10", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        boolean existFlag = QueryServiceHelper.exists((String)(appId + "_bustalk"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "in", (Object)new String[]{"B", "I"})});
        if (existFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_118", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject[] bustalks = BusinessDataServiceHelper.load((String)(appId + "_bustalk"), (String)"id,offerstoptime,createtime,openonlinesynergy,offerstoptime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "in", (Object)new String[]{"C"}), new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE)}, (String)"createtime desc");
        if (bustalks.length > 0) {
            DynamicObject bustalk = bustalks[0];
            boolean existsInvite = QueryServiceHelper.exists((String)(appId + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", (Object)((Long)bustalk.getPkValue())), new QFilter("status", "in", (Object)new String[]{"B", "I"})});
            if (existsInvite) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_119", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (bustalk.getBoolean("openonlinesynergy") && bustalk.getDate("offerstoptime").after(new Date())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u672a\u5230\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_120", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void showTip(String tips) {
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002\r\n %s", (String)"BidPublishEditUI_121", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips), MessageBoxOptions.OKCancel);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        FormShowParameter formShowParameter;
        String customParam;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("doRepublish".equals(actionId) && StringUtils.isNotEmpty((CharSequence)(customParam = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("BidCenter")))) {
            IFormView parentView = this.getView().getParentView();
            String opKey = "bidpublish";
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            parentView.getModel().setValue("markcurrent", (Object)(opKey + "#" + uuid));
            this.getView().sendFormAction(parentView);
        }
        if (returnData != null && this.ADD_SUPPLIER_ACTION_ID.equals(actionId)) {
            ArrayList data = (ArrayList)returnData;
            int returnSize = data.size();
            DynamicObjectCollection sectionEntry = this.getModel().getEntryEntity("bidsection");
            EntryGrid sectionGrid = (EntryGrid)this.getControl("bidsection");
            int[] selects = sectionGrid.getSelectRows();
            if (selects.length > 0) {
                for (int i = 0; i < sectionEntry.size(); ++i) {
                    if (selects[0] != i) continue;
                    DynamicObject sectionEntryRow = (DynamicObject)sectionEntry.get(i);
                    DynamicObjectCollection supplierEntry = sectionEntryRow.getDynamicObjectCollection("supplierentry");
                    int size = supplierEntry.size();
                    int starSize = size - returnSize;
                    for (int j = 0; j < supplierEntry.size(); ++j) {
                        DynamicObject supplierEntryRow = (DynamicObject)supplierEntry.get(j);
                        if (BidPubStrategyEnum.PLUS.getValue().equals(supplierEntryRow.getString("pubstrategy"))) {
                            this.getView().setEnable(Boolean.FALSE, j, new String[]{"pubstrategy"});
                        }
                        if (j < starSize) continue;
                        this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
                    }
                }
                this.getView().updateView("supplierentry");
            }
        }
    }

    public boolean canRePublish(Long bidProjectId, boolean isShowTips) {
        DynamicObject[] biddecisionCol;
        QFilter filter = new QFilter("bidproject", "=", (Object)bidProjectId);
        QFilter bidDocustatusFilter = new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.ADJUSTING.getVal(), BillStatusEnum.INVALID.getVal(), BillStatusEnum.INVALIDXX.getVal()});
        DynamicObject[] bidOpenCol = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billno,bidproject,billstatus,createtime", (QFilter[])new QFilter[]{filter}, (String)"createtime asc");
        DynamicObject[] bidDocumentEditCol = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{filter, bidDocustatusFilter});
        String editStatus = BillStatusEnum.AUDITED.getVal();
        Object billno = null;
        if (bidDocumentEditCol != null && bidDocumentEditCol.length > 0) {
            editStatus = bidDocumentEditCol[0].getString("billstatus");
            billno = bidDocumentEditCol[0].get("bidproject.billno");
        }
        if (bidOpenCol.length != 0) {
            String billStatus = bidOpenCol[0].getString("billStatus");
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.SUBMIT.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.AUDITING.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)billStatus)) {
                if (StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)editStatus)) {
                    return true;
                }
                if (isShowTips) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u8bf7\u5ba1\u6279\u540e\u518d\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_122", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                }
                return false;
            }
            if (StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)"P", (CharSequence)billStatus)) {
                // empty if block
            }
        }
        if ((biddecisionCol = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{filter})).length != 0) {
            String billStatus = biddecisionCol[0].getString("billStatus");
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus)) {
                if (StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)editStatus)) {
                    return true;
                }
            } else if (StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.AUDITING.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.SUBMIT.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getVal(), (CharSequence)billStatus)) {
                if (isShowTips) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u53d1\u751f\u5b9a\u6807\u4e1a\u52a1\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishEditUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]), biddecisionCol[0].get("bidproject.billno")));
                }
                return false;
            }
        }
        return true;
    }

    private String getAppId() {
        return this.getModel().getDataEntityType().getAppId();
    }

    private void addLog(String operation, String number, String tip) {
        LogServiceHelper logServiceHelper = new LogServiceHelper();
        AppLogInfo appLogInfo = OperationLogUtil.buildLogInfo(operation, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s", (String)"BidPublishEditUI_123", (String)"scm-bid-formplugin", (Object[])new Object[0]), number + "\uff0c" + tip), this.getAppId(), this.getView().getEntityId());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object sourcePublish;
        DynamicObject publish;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        this.controlListBtnStatus();
        this.getModel().deleteEntryData(FAKE_BIDSECTION_ENTITY);
        this.copyBidsectionToFakeBidsection_afterDoOperation();
        if (key.equals(KEY_CONFIRMPUBLISH)) {
            if (!args.getOperationResult().isSuccess()) {
                return;
            }
            this.getView().setStatus(OperationStatus.VIEW);
            IDataModel dataModel = this.getModel();
            Long id = (Long)dataModel.getValue("id");
            DynamicObject data = this.publishService.getBidPublishById(id);
            dataModel.setValue("modifytime", (Object)data.getDate("modifytime"));
            dataModel.setValue("modifier", (Object)data.getLong("modifier.id"));
            dataModel.setValue("auditor", (Object)data.getLong("auditor.id"));
            dataModel.setValue("auditdate", (Object)data.getDate("auditdate"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u6807\u6210\u529f\u3002", (String)"BidPublishEditUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            dataModel.setDataChanged(false);
            if (args.getOperationResult().isSuccess()) {
                DynamicObject[] bidOpenCol;
                boolean enable;
                DynamicObject bidProject = data.getDynamicObject("bidproject");
                DynamicObjectCollection bidSectionColl = data.getDynamicObjectCollection("bidsection");
                DynamicObjectCollection supplierEntryColl = new DynamicObjectCollection();
                if (!bidSectionColl.isEmpty()) {
                    for (int i = 0; i < bidSectionColl.size(); ++i) {
                        DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                        for (DynamicObject item : bidSection.getDynamicObjectCollection("supplierentry")) {
                            supplierEntryColl.add((Object)item);
                        }
                    }
                }
                if (enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable")) {
                    DynamicObject bidProjectdy = (DynamicObject)this.getModel().getValue("bidproject");
                    boolean openBiddingFlag = BidModeHelper.isPublicBidding(bidProjectdy);
                    DynamicObjectCollection bidSectionSS = bidProjectdy.getDynamicObjectCollection("bidsection");
                    Object bidProjectNo = bidProjectdy.get("billno");
                    QFilter qFilter = new QFilter("bidproject.billno", "=", bidProjectNo);
                    QFilter qFilter2 = new QFilter("billstatus", "=", (Object)"C");
                    DynamicObject nowObject = this.getModel().getDataEntity();
                    DynamicObjectCollection nowSections = nowObject.getDynamicObjectCollection("bidsection");
                    BidPublishEditUI bidPublishEditUI = this;
                    synchronized (bidPublishEditUI) {
                        DynamicObjectCollection bidSections;
                        DynamicObject supplierinvitation;
                        if (!openBiddingFlag && (supplierinvitation = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"bidsection,sectionname,supplierentry,supplier,invitationstatus", (QFilter[])new QFilter[]{qFilter, qFilter2})) != null && (bidSections = supplierinvitation.getDynamicObjectCollection("bidsection")) != null && bidSections.size() > 0) {
                            for (int i = 0; i < bidSections.size(); ++i) {
                                DynamicObjectCollection suppliers = ((DynamicObject)bidSections.get(i)).getDynamicObjectCollection("supplierentry");
                                for (DynamicObject supplier : suppliers) {
                                    DynamicObjectCollection nowSuppliers = ((DynamicObject)nowSections.get(i)).getDynamicObjectCollection("supplierentry");
                                    if (nowSuppliers.size() <= 0) continue;
                                    for (DynamicObject nowSupplier : nowSuppliers) {
                                        DynamicObject invitationSupplierObject = supplier.getDynamicObject("supplier");
                                        DynamicObject nowSupplierObject = nowSupplier.getDynamicObject("supplier");
                                        if (!invitationSupplierObject.getPkValue().equals(nowSupplierObject.getPkValue()) || supplier.getString("invitationstatus").equals("ACCEPTED")) continue;
                                        this.returnWriteToMyTender(invitationSupplierObject, (DynamicObject)bidSectionSS.get(i), bidProjectdy, INVITATION);
                                    }
                                }
                            }
                        }
                        DynamicObject supplierinvitationForThis = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"bidsection,supplierentry,supplier,invitationstatus", (QFilter[])new QFilter[]{qFilter, qFilter2});
                        DynamicObjectCollection sectionForThis = null;
                        if (supplierinvitationForThis != null) {
                            sectionForThis = supplierinvitationForThis.getDynamicObjectCollection("bidsection");
                        }
                        int sum = 0;
                        for (int m = 0; m < nowSections.size(); ++m) {
                            DynamicObjectCollection nowSuppliers = ((DynamicObject)nowSections.get(m)).getDynamicObjectCollection("supplierentry");
                            if (nowSuppliers.size() <= 0) continue;
                            if (sectionForThis != null) {
                                DynamicObjectCollection suppliersForThis = ((DynamicObject)sectionForThis.get(m)).getDynamicObjectCollection("supplierentry");
                                for (int n = 0; n < nowSuppliers.size(); ++n) {
                                    sum = 0;
                                    long nowSupplier = ((DynamicObject)nowSuppliers.get(n)).getLong("supplier.id");
                                    for (int q = 0; q < suppliersForThis.size(); ++q) {
                                        long supplierForThis = ((DynamicObject)suppliersForThis.get(q)).getLong("supplier.id");
                                        if (nowSupplier == supplierForThis) {
                                            ++sum;
                                        }
                                        if (sum != 1 || !((DynamicObject)suppliersForThis.get(q)).getString("invitationstatus").equals("REJECTED")) continue;
                                        sum = 0;
                                    }
                                    if (sum != 1) {
                                        if (openBiddingFlag) {
                                            this.returnWriteToMyTender(((DynamicObject)nowSuppliers.get(n)).getDynamicObject("supplier"), (DynamicObject)bidSectionSS.get(m), bidProjectdy, OPEN);
                                        } else {
                                            this.returnWriteToMyTender(((DynamicObject)nowSuppliers.get(n)).getDynamicObject("supplier"), (DynamicObject)bidSectionSS.get(m), bidProjectdy, INVITATION);
                                        }
                                    }
                                    this.updateIsFromReBack(((DynamicObject)nowSuppliers.get(n)).getDynamicObject("supplier"), (DynamicObject)bidSectionSS.get(m), bidProjectdy);
                                }
                                continue;
                            }
                            for (int n = 0; n < nowSuppliers.size(); ++n) {
                                if (openBiddingFlag) {
                                    this.returnWriteToMyTender(((DynamicObject)nowSuppliers.get(n)).getDynamicObject("supplier"), (DynamicObject)bidSectionSS.get(m), bidProjectdy, OPEN);
                                    continue;
                                }
                                this.returnWriteToMyTender(((DynamicObject)nowSuppliers.get(n)).getDynamicObject("supplier"), (DynamicObject)bidSectionSS.get(m), bidProjectdy, INVITATION);
                            }
                        }
                    }
                }
                if (data.getLong("sourcepublish") != 0L && (bidOpenCol = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)"XX")})) != null) {
                    HashSet<Long> supplierIdSet = new HashSet<Long>(16);
                    for (int i = 0; i < bidOpenCol.length; ++i) {
                        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpenCol[i].getPkValue(), (String)"bid_bidopen");
                        DynamicObjectCollection bidSection = bidOpen.getDynamicObjectCollection("bidsection");
                        DynamicObjectCollection curSection = dataModel.getEntryEntity("bidsection");
                        for (DynamicObject bidSectionRow : bidSection) {
                            for (DynamicObject curSectionRow : curSection) {
                                if (!bidSectionRow.getString("sectionname").equals(curSectionRow.getString("sectionname"))) continue;
                                DynamicObjectCollection supplierEntry = bidSectionRow.getDynamicObjectCollection("supplierentry");
                                DynamicObjectCollection curSupplierEntry = curSectionRow.getDynamicObjectCollection("supplierentry");
                                DynamicObjectCollection pSupplierDetails = this.bidProjectService.getMaDetailCollectionByProjectAndSec(bidProject, bidSectionRow.getString("sectionname"));
                                supplierIdSet.clear();
                                for (DynamicObject supplierEntryRow : supplierEntry) {
                                    if (supplierEntryRow.getDynamicObject("supplier") == null || supplierIdSet.contains(supplierEntryRow.getDynamicObject("supplier").getLong("id"))) continue;
                                    supplierIdSet.add(supplierEntryRow.getDynamicObject("supplier").getLong("id"));
                                }
                                if (supplierEntry.size() >= curSupplierEntry.size()) continue;
                                for (DynamicObject curSupplierEntryRow : curSupplierEntry) {
                                    if (supplierIdSet.contains(curSupplierEntryRow.getDynamicObject("supplier").getLong("id")) || !StringUtils.equals((CharSequence)BidPubStrategyEnum.PLUS.getValue(), (CharSequence)curSupplierEntryRow.getString("pubstrategy")) && !StringUtils.equals((CharSequence)BidPubStrategyEnum.RE.getValue(), (CharSequence)curSupplierEntryRow.getString("pubstrategy"))) continue;
                                    DynamicObject newSupplierEntryRow = new DynamicObject(supplierEntry.getDynamicObjectType());
                                    newSupplierEntryRow.set("seq", curSupplierEntryRow.get("seq"));
                                    newSupplierEntryRow.set("supplier", (Object)curSupplierEntryRow.getDynamicObject("supplier"));
                                    newSupplierEntryRow.set("supplier_istender", (Object)Boolean.FALSE);
                                    newSupplierEntryRow.set("suppliercontact", (Object)curSupplierEntryRow.getLocaleString("suppliercontact"));
                                    newSupplierEntryRow.set("contactphone", curSupplierEntryRow.get("contactphone"));
                                    newSupplierEntryRow.set("supplier_techfile", (Object)0);
                                    newSupplierEntryRow.set("supplier_comfile", (Object)0);
                                    newSupplierEntryRow.set("supplier_deposittype", (Object)"NOTPAY");
                                    supplierEntry.add((Object)newSupplierEntryRow);
                                    DynamicObjectCollection supplierEntryDetail = bidSectionRow.getDynamicObjectCollection("supplierdetail");
                                    for (DynamicObject pSupplierDetail : pSupplierDetails) {
                                        DynamicObject newSupplierDetail = new DynamicObject(supplierEntryDetail.getDynamicObjectType());
                                        newSupplierDetail.set("pursupplier", (Object)curSupplierEntryRow.getDynamicObject("supplier"));
                                        newSupplierDetail.set("purentrycontent", pSupplierDetail.get("purentrycontent"));
                                        newSupplierDetail.set("purentryproject", pSupplierDetail.get("purentryproject"));
                                        newSupplierDetail.set("materialid", pSupplierDetail.get("materialid"));
                                        newSupplierDetail.set("materialdes", pSupplierDetail.get("materialdes"));
                                        newSupplierDetail.set("qty", pSupplierDetail.get("qty"));
                                        supplierEntryDetail.add((Object)newSupplierDetail);
                                    }
                                }
                            }
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
                    }
                }
                if (args.getOperationResult().isSuccess()) {
                    dataModel.setValue("billstatus", (Object)BillStatusEnum.PUBLISHED.getVal());
                    dataModel.setDataChanged(false);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"baritem_del"});
                }
                this.sendMessage(key, data);
            }
        } else if ("viewhistory".equals(key)) {
            DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
            Long bidProjectId = project.getLong("id");
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            if (BidHistoryUtil.havePublishHistory(appId, bidProjectId).booleanValue()) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("bidProjectId", (Object)bidProjectId);
                listShowParameter.setCustomParam("viewhistory", (Object)"viewhistory");
                listShowParameter.setMultiSelect(false);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"bidpublish_history", ((Object)((Object)this)).getClass()));
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u518d\u6b21\u53d1\u6807\u8bb0\u5f55\u3002", (String)"BidPublishEditUI_897", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        if ("republish".equals(key)) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
        this.setSupplierEntryRow();
        String billStatus = (String)this.getModel().getValue("billstatus");
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!BillStatusEnum.PUBLISHED.getVal().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrepublishbid"});
        } else if (enable && this.canRePublish(bidProject.getLong("id"), false)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblrepublishbid"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrepublishbid"});
        }
        if (key.equals("audit") || key.equals("submit") || key.equals(CONFIRMBID)) {
            if (args.getOperationResult().isSuccess()) {
                publish = this.getModel().getDataEntity(true);
                sourcePublish = publish.get("sourcepublish");
                if (!(this.getView().getFormShowParameter().getCustomParam(ISREPUBLISH) == null && "0".equals(sourcePublish) || billStatus.equals("J") && billStatus.equals("X"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"planbidpublishdate1", "answeringendtime", "plananswerquestiontime", "planbidopendeadline", "techbackbidtime", "busbackbidtime", "planbidevaluationdate", "bidbustalkdate", "planbiddecisiondate"});
                }
                this.setTenderStrategy();
                if (key.equals("audit")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{CONFIRMBID});
                }
            } else if (!billStatus.equals("A") && !billStatus.equals("D")) {
                this.setTenderStrategy();
            } else {
                EntryGrid sectionGrid = (EntryGrid)this.getControl("bidsection");
                int[] selects = sectionGrid.getSelectRows();
                this.setTenderStrategyEditable(selects[0]);
            }
        }
        if ((key.equals("unaudit") || key.equals("unsubmit")) && args.getOperationResult().isSuccess()) {
            publish = this.getModel().getDataEntity(true);
            sourcePublish = publish.get("sourcepublish");
            if (!(this.getView().getFormShowParameter().getCustomParam(ISREPUBLISH) == null && "0".equals(sourcePublish) || billStatus.equals("J") && billStatus.equals("X"))) {
                this.setFieldEditableAndVisble();
            }
            this.getView().invokeOperation("refresh");
        }
        if (key.equals("refresh")) {
            if (args.getOperationResult() != null) {
                args.getOperationResult().setShowMessage(false);
            }
        } else if (key.equals("save") && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void updateIsFromReBack(DynamicObject supplier, DynamicObject section, DynamicObject bidProject) {
        DynamicObject tender;
        Object bidProjectPkValue = bidProject.getPkValue();
        String appid = this.getModel().getDataEntityType().getAppId();
        String tenderEntityName = "ten_mytender";
        String selector = "entry,entry.seq,projectsection,sectionname,sectionstatus,fromrebackflag";
        if (StringUtils.equals((CharSequence)REBM, (CharSequence)appid)) {
            tenderEntityName = "resp_mytender";
            selector = String.join((CharSequence)",", selector, "listentry", "listentry_sectionname", "listentry_listbill", "listentry_resume", "listentry_description");
        }
        if ((tender = BusinessDataServiceHelper.loadSingle((String)tenderEntityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("supplier", "=", supplier.getPkValue()), new QFilter("bidproject", "=", bidProjectPkValue)})) != null) {
            DynamicObjectCollection entrys = tender.getDynamicObjectCollection("entry");
            String string = "";
            StringBuilder hasSectionSb = new StringBuilder();
            String sectionNames = "";
            int sectionIndex = -1;
            for (int e = 0; e < entrys.size(); ++e) {
                DynamicObject hasSection = ((DynamicObject)entrys.get(e)).getDynamicObject("projectsection");
                if (StringUtils.equals((CharSequence)((DynamicObject)entrys.get(e)).getString("sectionstatus"), (CharSequence)MyTenderStatus.UNINVITED.getValue())) {
                    sectionNames = sectionNames + hasSection.getString("sectionname");
                    sectionIndex = e;
                    continue;
                }
                String str = hasSection.getPkValue() + ",";
                hasSectionSb.append(str);
            }
            String nowStr = section.getPkValue().toString();
            string = hasSectionSb.toString();
            if (string.contains(nowStr)) {
                for (DynamicObject entry : entrys) {
                    entry.set("fromrebackflag", (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tender});
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tender});
        }
    }

    private void setSupplierEntryRow() {
        DynamicObjectCollection sectionEntry = this.getModel().getEntryEntity("bidsection");
        EntryGrid sectionGrid = (EntryGrid)this.getControl("bidsection");
        int[] selects = sectionGrid.getSelectRows();
        if (selects.length > 0) {
            for (int i = 0; i < sectionEntry.size(); ++i) {
                if (selects[0] != i) continue;
                DynamicObject sectionEntryRow = (DynamicObject)sectionEntry.get(i);
                DynamicObjectCollection supplierEntry = sectionEntryRow.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntry.size(); ++j) {
                    DynamicObject supplierEntryRow = (DynamicObject)supplierEntry.get(j);
                    if (!BidPubStrategyEnum.PLUS.getValue().equals(supplierEntryRow.getString("pubstrategy"))) continue;
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"pubstrategy"});
                }
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"bidproject", (CharSequence)propertyName)) {
            // empty if block
        }
        if (StringUtils.equals((CharSequence)"bidopendeadline", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"bidevaluationdate", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"biddecisiondate", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"approachdate", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"planbidpublishdate1", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"plananswerquestiontime", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"planbidopendeadline", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"busbackbidtime", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"planbidevaluationdate", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"planbiddecisiondate", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"answeringendtime", (CharSequence)propertyName) || StringUtils.equals((CharSequence)"bidbustalkdate", (CharSequence)propertyName)) {
            Date date = (Date)propValue;
            Date date1 = this.getNeedSetFormatDate(propertyName, date);
            this.compareDate(propertyName, date1);
            return;
        }
        if (field.equals("bd_taxrate")) {
            int rowindex = valueSet[0].getRowIndex();
            Object newVal = valueSet[0].getNewValue();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                DynamicObject bd_taxrate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bd_taxrate.getBigDecimal("taxrate"), rowindex);
            }
        }
    }

    public void compareDate(String dateType, Date date) {
        if (date == null) {
            return;
        }
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue(this.BID_PROJECT);
        boolean isBidOpen = bidProject.getBoolean("bidopen");
        boolean isBidEvaluation = bidProject.getBoolean("bidevaluation");
        HashMap<String, Boolean> status = new HashMap<String, Boolean>();
        status.put("bidopendeadline", isBidOpen);
        status.put("bidevaluationdate", isBidEvaluation);
        Date4Project curDate = Date4Project.valueOf((String)dateType);
        int index = curDate.getIndex();
        List dates4Later = Arrays.stream(Date4Project.values()).filter(dateEnum -> dateEnum.getIndex() < index).collect(Collectors.toList());
        Collections.sort(dates4Later, (d1, d2) -> d2.getIndex() - d1.getIndex());
        for (Date4Project date4Project : dates4Later) {
            boolean dateFlag;
            Boolean isUsed = (Boolean)status.get(date4Project.name());
            if (isUsed != null && !isUsed.booleanValue()) continue;
            Date compareDate = (Date)this.getModel().getValue(date4Project.name());
            Date compareFormatDate = this.getNeedSetFormatDate(date4Project.name(), compareDate);
            String curDateName = curDate.name();
            String date4ProjectName = date4Project.name();
            boolean curFlag = "planbidopendeadline".equals(curDateName) || "busbackbidtime".equals(curDateName);
            boolean bl = dateFlag = "planbidopendeadline".equals(date4ProjectName) || "busbackbidtime".equals(date4ProjectName);
            if (curFlag && dateFlag || compareFormatDate == null || this.compareDate(date, compareFormatDate) >= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u987b\u5927\u4e8e\u7b49\u4e8e%2$s\u3002", (String)"BidPublishEditUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]), curDate.getAlias(), date4Project.getAlias() + "\uff01"));
            this.getModel().setValue(curDate.name(), null);
            return;
        }
        List dates4Early = Arrays.stream(Date4Project.values()).filter(dateEnum -> dateEnum.getIndex() > index).collect(Collectors.toList());
        Collections.sort(dates4Early, (d1, d2) -> d1.getIndex() - d2.getIndex());
        for (Date4Project date4Project : dates4Early) {
            boolean dateFlag;
            Boolean isUsed = (Boolean)status.get(date4Project.name());
            if (isUsed != null && !isUsed.booleanValue()) continue;
            Date compareDate = (Date)this.getModel().getValue(date4Project.name());
            Date compareFormatDate = this.getNeedSetFormatDate(date4Project.name(), compareDate);
            String curDateName = curDate.name();
            String date4ProjectName = date4Project.name();
            boolean curFlag = "planbidopendeadline".equals(curDateName) || "busbackbidtime".equals(curDateName);
            boolean bl = dateFlag = "planbidopendeadline".equals(date4ProjectName) || "busbackbidtime".equals(date4ProjectName);
            if (curFlag && dateFlag || compareFormatDate == null || this.compareDate(date, compareFormatDate) <= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u987b\u5c0f\u4e8e\u7b49\u4e8e%2$s\u3002", (String)"BidPublishEditUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]), curDate.getAlias(), date4Project.getAlias() + "\uff01"));
            this.getModel().setValue(curDate.name(), null);
            return;
        }
    }

    private int compareDate(Date d1, Date d2) {
        String ds2;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String ds1 = format.format(d1);
        if (ds1.equals(ds2 = format.format(d2))) {
            return 0;
        }
        return d1.compareTo(d2);
    }

    private void setButtonVisible() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        String operateStatus = this.getView().getFormShowParameter().getStatus().name();
        if (!(BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.AUDITED.getVal().equals(billStatus) || operateStatus.equals(OperationStatus.ADDNEW.name()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRMBID});
            return;
        }
        boolean isEmptySupplier = false;
        DynamicObjectCollection bidSections = (DynamicObjectCollection)this.getModel().getValue("bidsection");
        for (DynamicObject section : bidSections) {
            DynamicObjectCollection suppliers = section.getDynamicObjectCollection("supplierentry");
            if (suppliers.size() != 0) continue;
            isEmptySupplier = true;
        }
        if (isEmptySupplier) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRMBID});
            return;
        }
    }

    private void setBidModelStatus() {
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        boolean isBidOpen = bidProject.getBoolean("bidopen");
        boolean isBidEvaluation = bidProject.getBoolean("bidevaluation");
        boolean isBidAnswerQuestion = bidProject.getBoolean("bidanswerquestion");
        boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
        String docTypeStr = bidProject.getString("doctype");
        if (isseparatedoc) {
            if (BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tech_attachmentpanelap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"com_attachmentpanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
            } else if (BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tech_attachmentpanelap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"com_attachmentpanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
            } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tech_attachmentpanelap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"com_attachmentpanel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"com_attachmentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tech_attachmentpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
        this.setDateVisible(isBidOpen, isBidEvaluation, isBidAnswerQuestion);
    }

    private void setDateVisible(boolean isBidOpen, boolean isBidEvaluation, boolean isBidAnswerQuestion) {
        if (isBidOpen) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"planbidopendeadline"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"planbidopendeadline"});
        }
        if (isBidEvaluation) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidevaluationdate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidevaluationdate"});
        }
        if (isBidAnswerQuestion) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"plananswerquestiontime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"answerquestiondeadline"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"plananswerquestiontime"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"answerquestiondeadline"});
        }
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue("billstatus");
                if (BillStatusEnum.SAVE.getVal().equals(value) || BillStatusEnum.DISBEGIN.getVal().equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if (BillStatusEnum.SUBMIT.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if (BillStatusEnum.AUDITED.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                } else if (BillStatusEnum.INVALID.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                } else if (BillStatusEnum.PUBLISHED.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                } else if (BillStatusEnum.ADJUSTING.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                } else if (BillStatusEnum.AUDITING.getVal().equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                }
            }
        }
    }

    public Map<String, DynamicObject> collectionPartner() {
        HashMap<String, DynamicObject> partnerUserMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection bidsections = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            DynamicObjectCollection supplierentry = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierRow : supplierentry) {
                DynamicObject supplier = supplierRow.getDynamicObject("supplier");
                DynamicObject projectpartner = supplierRow.getDynamicObject("projectpartner");
                partnerUserMap.put(supplier.getPkValue().toString(), projectpartner);
            }
        }
        return partnerUserMap;
    }

    public void updatewEntry(DynamicObject tender, DynamicObject supplier1, String appId, DynamicObject project, Map<String, DynamicObject> partnerUserMap) {
        DynamicObject dynamicObject = partnerUserMap.get(supplier1.getPkValue().toString());
        if (dynamicObject != null) {
            tender.set("tenderer", dynamicObject.getPkValue());
        }
        if (!REBM.equals(appId)) {
            return;
        }
        QFilter sourceQFilter = new QFilter("source", "=", (Object)"mytender");
        QFilter bidProjectQFilter = new QFilter("bidproject", "=", project.getPkValue());
        DynamicObject[] transfdataRecords = BusinessDataServiceHelper.load((String)"resp_transfdata_record", (String)"id,bidproject,supplier,afteruser", (QFilter[])new QFilter[]{bidProjectQFilter, sourceQFilter});
        if (transfdataRecords == null || transfdataRecords.length == 0) {
            return;
        }
        DynamicObject afterUser = null;
        for (DynamicObject transfdataRecord : transfdataRecords) {
            DynamicObject supplier = transfdataRecord.getDynamicObject("supplier");
            DynamicObject partner = partnerUserMap.get(supplier.getPkValue().toString());
            afterUser = new DynamicObject();
            if (partner == null) {
                QFilter manageFile;
                DynamicObject bizpartner = supplier.getDynamicObject("bizpartner");
                QFilter partnerFilter = new QFilter("bizpartner", "=", bizpartner.getPkValue());
                DynamicObject[] bos_bizpartnerusers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{partnerFilter, manageFile = new QFilter("isadmin", "=", (Object)"1")});
                if (bos_bizpartnerusers != null && bos_bizpartnerusers.length > 0) {
                    DynamicObject user;
                    afterUser = user = bos_bizpartnerusers[0].getDynamicObject("user");
                }
            } else {
                afterUser = partner;
            }
            if (afterUser == null) continue;
            supplier.getDynamicObject("bizpartner");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"resp_usermanagement", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", supplier.getDynamicObject("bizpartner").getPkValue()), new QFilter("user", "=", afterUser.getPkValue())});
            transfdataRecord.set("afteruser", (Object)load[0]);
        }
        SaveServiceHelper.update((DynamicObject[])transfdataRecords);
    }

    private void returnWriteToMyTender(DynamicObject supplier, DynamicObject section, DynamicObject bidProject, String bidType) {
        Object bidProjectPkValue = bidProject.getPkValue();
        String appid = this.getModel().getDataEntityType().getAppId();
        String tenderEntityName = "ten_mytender";
        String selector = "entry,entry.seq,projectsection,sectionname,sectionstatus,fromrebackflag";
        if (StringUtils.equals((CharSequence)REBM, (CharSequence)appid)) {
            tenderEntityName = "resp_mytender";
            selector = String.join((CharSequence)",", selector, "listentry", "listentry_sectionname", "listentry_listbill", "listentry_resume", "listentry_description");
        }
        Map<String, DynamicObject> partnerMap = this.collectionPartner();
        DynamicObject tender = BusinessDataServiceHelper.loadSingle((String)tenderEntityName, (String)selector, (QFilter[])new QFilter[]{new QFilter("supplier", "=", supplier.getPkValue()), new QFilter("bidproject", "=", bidProjectPkValue)});
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appid + "_project"));
        if (tender == null) {
            DynamicObject myTender = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)tenderEntityName));
            String name = "";
            Date date = null;
            DynamicObject invitation = null;
            DynamicObject open = null;
            QFilter qFilter = new QFilter("bidproject", "=", bidProjectPkValue);
            if (bidType.equals(INVITATION)) {
                invitation = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)INVITATION, ((Object)((Object)this)).getClass()), (String)"name,publishdate", (QFilter[])new QFilter[]{qFilter});
                if (invitation != null) {
                    name = invitation.getString("name");
                    date = invitation.getDate("publishdate");
                } else {
                    name = String.format(ResManager.loadKDString((String)"%s\u9080\u8bf7\u51fd", (String)"BidPublishEditUI_31", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidProject.getString("name"));
                    date = new Date();
                }
            } else if (bidType.equals(OPEN)) {
                QFilter qFilter1 = new QFilter("bidproject", "=", (Object)bidProjectPkValue.toString());
                QFilter qFilter2 = new QFilter("annotype", "=", (Object)"bidproject");
                open = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"announcement", ((Object)((Object)this)).getClass()), (String)"annotitle,publishdate", (QFilter[])new QFilter[]{qFilter1.and(qFilter2)});
                if (open != null) {
                    name = open.getString("annotitle");
                    date = open.getDate("publishdate");
                } else {
                    name = String.format(ResManager.loadKDString((String)"%s\u516c\u5f00\u62db\u6807\u516c\u544a", (String)"BidPublishEditUI_124", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidProject.getString("name"));
                    date = new Date();
                }
            }
            myTender.set("currency", bidProject.get("currency"));
            myTender.set("name", (Object)name);
            myTender.set("billstatus", (Object)"C");
            myTender.set("publishdate", date);
            myTender.set("org", (Object)bidProject.getDynamicObject("org"));
            myTender.set("bidproject", (Object)bidProject);
            if (bidType.equals(INVITATION)) {
                myTender.set("ispublicbid", (Object)Boolean.FALSE);
                myTender.set(INVITATION, (Object)invitation);
            } else if (bidType.equals(OPEN)) {
                myTender.set("ispublicbid", (Object)Boolean.TRUE);
                myTender.set("announcement", (Object)open);
            }
            myTender.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
            myTender.set("supplier", (Object)supplier);
            myTender.set("isformpublish", (Object)1);
            DynamicObject tempSupplier = supplier;
            if (StringUtils.equals((CharSequence)REBM, (CharSequence)appid)) {
                supplier = SupplierHelper.getSysSupByRESMSup((Long)((Long)supplier.getPkValue()));
            }
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"bizpartner");
            long bizpartnerid = loadSingle.getLong("bizpartner.id");
            DynamicObject pur_supuser = BusinessDataServiceHelper.loadSingle((String)"pur_supuser", (String)"user", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)bizpartnerid), new QFilter("isadmin", "=", (Object)"1")});
            myTender.set("tenderer", pur_supuser.getDynamicObject("user").getPkValue());
            this.updatewEntry(myTender, tempSupplier, appid, bidProject, partnerMap);
            myTender.set("createtime", (Object)new Date());
            myTender.set("entitytypeid", (Object)tenderEntityName);
            EntityType myTenderEntryEntityType = (EntityType)EntityMetadataCache.getDataEntityType((String)tenderEntityName).getAllEntities().get("entry");
            DynamicObjectCollection myTenderEntryColl = new DynamicObjectCollection((DynamicObjectType)myTenderEntryEntityType, (Object)myTender);
            DynamicObject myTenderEntry = new DynamicObject((DynamicObjectType)myTenderEntryEntityType);
            DynamicObject projectSection = section;
            myTenderEntry.set("projectSection", (Object)projectSection);
            myTenderEntry.set("seq", (Object)1);
            myTenderEntry.set("sectionname", projectSection.get("sectionname"));
            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
            myTenderEntry.set("fromrebackflag", (Object)Boolean.FALSE);
            myTenderEntryColl.add((Object)myTenderEntry);
            myTender.set("entry", (Object)myTenderEntryColl);
            String backBidWay = this.getModel().getDataEntity().getString("backbidway");
            if (StringUtils.isNotEmpty((CharSequence)backBidWay) && backBidWay.equals("totaltechnical")) {
                myTender.set("backbidtype", (Object)"TECHANDBUSS");
            } else if (StringUtils.isNotEmpty((CharSequence)backBidWay) && backBidWay.equals("firsttechnical")) {
                myTender.set("backbidtype", (Object)"TECHNICAL");
            }
            myTender.set("rounds", (Object)1);
            myTender.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"BidPublishEditUI_125", (String)"scm-bid-formplugin", (Object[])new Object[0]), CommonUtil.toChinese((String)"1")));
            String docType = bidProject.getString("doctype");
            if (StringUtils.isNotEmpty((CharSequence)docType) && docType.equals("BUSSINESS")) {
                myTender.set("backbidtype", (Object)"BUSSINESS");
            }
            myTender.set("backbidway", (Object)backBidWay);
            if (StringUtils.equals((CharSequence)REBM, (CharSequence)appid)) {
                this.createListCardEntrys(myTender, section);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myTender});
        } else {
            DynamicObjectCollection entrys = tender.getDynamicObjectCollection("entry");
            String string = "";
            StringBuilder hasSectionSb = new StringBuilder();
            String sectionNames = "";
            int sectionIndex = -1;
            for (int e = 0; e < entrys.size(); ++e) {
                DynamicObject hasSection = ((DynamicObject)entrys.get(e)).getDynamicObject("projectsection");
                if (StringUtils.equals((CharSequence)((DynamicObject)entrys.get(e)).getString("sectionstatus"), (CharSequence)MyTenderStatus.UNINVITED.getValue())) {
                    sectionNames = sectionNames + hasSection.getString("sectionname");
                    sectionIndex = e;
                    continue;
                }
                String str = hasSection.getPkValue() + ",";
                hasSectionSb.append(str);
            }
            String nowStr = section.getPkValue().toString();
            String nowSectionName = section.getString("sectionname");
            if (sectionNames.contains(nowSectionName) && sectionIndex != -1) {
                for (DynamicObject entryone : entrys) {
                    if (!StringUtils.equals((CharSequence)nowSectionName, (CharSequence)entryone.getString("sectionname"))) continue;
                    entryone.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
                }
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject tempEntry = (DynamicObject)entrys.get(i);
                    if (i == sectionIndex) {
                        tempEntry.set("seq", (Object)(entrys.size() - 1));
                        continue;
                    }
                    tempEntry.set("seq", (Object)(tempEntry.getInt("seq") - 1));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tender});
                return;
            }
            string = hasSectionSb.toString();
            if (string.contains(nowStr)) {
                for (DynamicObject entry : entrys) {
                    entry.set("fromrebackflag", (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tender});
                return;
            }
            DynamicObject addNew = entrys.addNew();
            DynamicObject projectSection = section;
            addNew.set("projectSection", (Object)projectSection);
            addNew.set("sectionname", projectSection.get("sectionname"));
            addNew.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
            addNew.set("seq", (Object)entrys.size());
            addNew.set("fromrebackflag", (Object)Boolean.FALSE);
            if (StringUtils.equals((CharSequence)REBM, (CharSequence)appid)) {
                this.createListCardEntrys(tender, section);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tender});
        }
    }

    private Date getNewDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = simpleDateFormat.format(date);
        Date nowDate = null;
        try {
            nowDate = simpleDateFormat.parse(sDate);
        }
        catch (ParseException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
        return nowDate;
    }

    public void cellClick(CellClickEvent paramCellClickEvent) {
        String itemName = paramCellClickEvent.getFieldKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("downrecord".equals(itemName)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("supplierentry");
            int curRow = grid.getModel().getEntryCurrentRowIndex("supplierentry");
            DynamicObject supplierEntry = grid.getModel().getEntryRowEntity("supplierentry", curRow);
            String downrecord = supplierEntry.getString("downrecord");
            if (downrecord == null || downrecord.isEmpty()) {
                return;
            }
            EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
            IDataModel sectionOperate = sectionGrid.getModel();
            int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsection");
            DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsection", sectionRow);
            Object bidprojectId = dataEntity.getDynamicObject("bidproject").getPkValue();
            Object supplierId = supplierEntry.getDynamicObject("supplier").getPkValue();
            String tenderstrategy = supplierEntry.getString("tenderstrategy");
            Object publishId = dataEntity.getPkValue();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(this.getAppId() + "_record_show");
            formShowParameter.setCustomParam("bidprojectId", bidprojectId);
            formShowParameter.setCustomParam("supplierId", supplierId);
            if ("NEEDBID".equals(tenderstrategy)) {
                formShowParameter.setCustomParam("publishId", Collections.singletonList(publishId));
            } else {
                DynamicObjectCollection query = QueryServiceHelper.query((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectId)});
                if (query.size() > 0) {
                    List ids = query.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
                    formShowParameter.setCustomParam("publishId", ids);
                } else {
                    formShowParameter.setCustomParam("publishId", Collections.singletonList(publishId));
                }
            }
            formShowParameter.setCustomParam("sectionName", (Object)sectionEntry.getString("sectionname"));
            formShowParameter.setCustomParam("appId", (Object)this.getAppId());
            formShowParameter.setCustomParam("bill", (Object)"publish");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6807\u4e66\u4e0b\u8f7d\u8bb0\u5f55", (String)"BidPublishEditUI_126", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(formShowParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    private void controlListBtnStatus() {
        DynamicObject src = this.getModel().getDataEntity();
        String billStatus = src.getString("billstatus");
        IFormView view = this.getView();
        if (BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"baritem_del"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"baritem_del"});
        }
        DynamicObject bidproject = src.getDynamicObject("bidproject");
        String bidprojectBillStatus = bidproject.getString("billstatus");
        Object bidProjectId = bidproject.getPkValue();
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        Boolean haveHistory = BidHistoryUtil.havePublishHistory(appId, bidProjectId);
        if (haveHistory.booleanValue()) {
            if ("X".equals(bidprojectBillStatus)) {
                String sourcepublish = src.getString("sourcepublish");
                if ("0".equals(sourcepublish)) {
                    view.setVisible(Boolean.TRUE, new String[]{"viewhistory"});
                } else {
                    view.setVisible(Boolean.FALSE, new String[]{"viewhistory"});
                }
            } else if (BillStatusEnum.ADJUSTING.getVal().equals(billStatus) || BillStatusEnum.INVALID.getVal().equals(billStatus)) {
                view.setVisible(Boolean.FALSE, new String[]{"viewhistory"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"viewhistory"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"viewhistory"});
        }
    }

    public void sendMessage(String key, DynamicObject data) {
        block29: {
            String notifyTypes;
            Long tenderPk;
            DynamicObject myTender;
            HashMap<String, Object> msgParam;
            DynamicObjectCollection supplierEntryColl;
            Long projectId;
            DynamicObject bidProject;
            block30: {
                block27: {
                    block28: {
                        String appId = this.getAppId();
                        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
                        if (!enable) {
                            return;
                        }
                        bidProject = data.getDynamicObject("bidproject");
                        projectId = (Long)bidProject.getPkValue();
                        DynamicObjectCollection bidSectionColl = data.getDynamicObjectCollection("bidsection");
                        supplierEntryColl = new DynamicObjectCollection();
                        if (!bidSectionColl.isEmpty()) {
                            for (int i = 0; i < bidSectionColl.size(); ++i) {
                                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                                for (DynamicObject item : bidSection.getDynamicObjectCollection("supplierentry")) {
                                    supplierEntryColl.add((Object)item);
                                }
                            }
                        }
                        String projectName = bidProject.getString("name");
                        String title = "";
                        String content = "";
                        msgParam = new HashMap<String, Object>();
                        BigDecimal tenderFee = bidProject.getBigDecimal("tenderfee");
                        BigDecimal deposit = bidProject.getBigDecimal("deposit");
                        msgParam.put("id", data.getPkValue());
                        msgParam.put("appId", this.getModel().getDataEntityType().getAppId());
                        msgParam.put("operation", key);
                        if (BID.equals(this.getModel().getDataEntityType().getAppId())) {
                            msgParam.put("formId", "ten_mytender");
                        } else {
                            msgParam.put("formId", "resp_mytender");
                        }
                        String chargingstage = bidProject.getString("chargingstage");
                        if (!"notstage".equals(chargingstage) || tenderFee.compareTo(BigDecimal.ZERO) != 0) break block27;
                        if (data.getLong("sourcepublish") != 0L) break block28;
                        HashSet<Long> sentSupplierIds = new HashSet<Long>();
                        msgParam.put("tplScene", "bidpublish");
                        msgParam.put("msgentity", "bid_bidpublish");
                        msgParam.put("title", null);
                        msgParam.put("content", null);
                        msgParam.put("targetButtonId", "button_bid_file");
                        msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
                        for (DynamicObject supplierEntry : supplierEntryColl) {
                            if (supplierEntry.getDynamicObject("supplier") == null) continue;
                            Long l = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
                            if (data.getLong("sourcepublish") != 0L || l == null) continue;
                            sentSupplierIds.add(l);
                        }
                        if (sentSupplierIds == null || sentSupplierIds.size() <= 0) break block29;
                        for (Long supplierId : sentSupplierIds) {
                            DynamicObject dynamicObject = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, supplierId);
                            Long tenderPk3 = 0L;
                            if (dynamicObject != null) {
                                tenderPk3 = dynamicObject.getLong("id");
                            }
                            msgParam.put("pkId", tenderPk3);
                            String notifyTypes3 = MessageChannelUtil.getNotifyType((String)"bidpublish", (String)"bid_bidpublish");
                            this.sendMessage(msgParam, bidProject.getPkValue(), supplierId, false, notifyTypes3);
                        }
                        break block29;
                    }
                    Set<Object> newSupplierIds = new HashSet();
                    HashSet<Long> reSupplierIds = new HashSet<Long>();
                    for (DynamicObject dynamicObject : supplierEntryColl) {
                        if (dynamicObject.getDynamicObject("supplier") == null) continue;
                        Long supplierId = (Long)dynamicObject.getDynamicObject("supplier").getPkValue();
                        String tenderStrategy = dynamicObject.getString("tenderstrategy");
                        if ("UNNEEDBID".equals(tenderStrategy)) continue;
                        String tenderstatus = dynamicObject.getString("tenderstatus");
                        if (supplierId != null && "".equals(tenderstatus)) {
                            newSupplierIds.add(supplierId);
                            continue;
                        }
                        reSupplierIds.add(supplierId);
                    }
                    newSupplierIds = newSupplierIds.stream().filter(o -> !reSupplierIds.contains(o)).collect(Collectors.toSet());
                    msgParam.put("msgentity", "bid_bidpublish");
                    msgParam.put("title", null);
                    msgParam.put("content", null);
                    msgParam.put("targetButtonId", "button_bid_file");
                    msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
                    if (newSupplierIds.size() > 0) {
                        for (Long l : newSupplierIds) {
                            msgParam.put("tplScene", "bidpublish");
                            DynamicObject myTender2 = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, l);
                            Long tenderPk2 = 0L;
                            if (myTender2 != null) {
                                tenderPk2 = myTender2.getLong("id");
                            }
                            msgParam.put("pkId", tenderPk2);
                            String notifyTypes2 = MessageChannelUtil.getNotifyType((String)"bidpublish", (String)"bid_bidpublish");
                            this.sendMessage(msgParam, bidProject.getPkValue(), l, false, notifyTypes2);
                        }
                    }
                    if (reSupplierIds.size() <= 0) break block29;
                    for (Long l : reSupplierIds) {
                        msgParam.put("tplScene", "bidrepublish");
                        DynamicObject myTender2 = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, l);
                        Long tenderPk2 = 0L;
                        if (myTender2 != null) {
                            tenderPk2 = myTender2.getLong("id");
                        }
                        msgParam.put("pkId", tenderPk2);
                        String notifyTypes2 = MessageChannelUtil.getNotifyType((String)"bidrepublish", (String)"bid_bidpublish");
                        this.sendMessage(msgParam, bidProject.getPkValue(), l, false, notifyTypes2);
                    }
                    break block29;
                }
                if (data.getLong("sourcepublish") != 0L) break block30;
                HashSet<Long> sentSupplierIds = new HashSet<Long>();
                msgParam.put("tplScene", "bidpublishfee");
                msgParam.put("msgentity", "bid_bidpublish");
                msgParam.put("title", null);
                msgParam.put("content", null);
                msgParam.put("targetButtonId", "button_bid_pay");
                msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    if (supplierEntry.getDynamicObject("supplier") == null) continue;
                    Long l = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
                    if (data.getLong("sourcepublish") != 0L || l == null) continue;
                    sentSupplierIds.add(l);
                }
                if (sentSupplierIds == null || sentSupplierIds.size() <= 0) break block29;
                for (Long supplierId : sentSupplierIds) {
                    DynamicObject dynamicObject = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, supplierId);
                    Long tenderPk4 = 0L;
                    if (dynamicObject != null) {
                        tenderPk4 = dynamicObject.getLong("id");
                    }
                    msgParam.put("pkId", tenderPk4);
                    String notifyTypes4 = MessageChannelUtil.getNotifyType((String)"bidpublishfee", (String)"bid_bidpublish");
                    this.sendMessage(msgParam, bidProject.getPkValue(), supplierId, false, notifyTypes4);
                }
                break block29;
            }
            Set<Object> newSupplierIds = new HashSet<Long>();
            HashSet<Long> reSupplierIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : supplierEntryColl) {
                if (dynamicObject.getDynamicObject("supplier") == null) continue;
                Long supplierId = (Long)dynamicObject.getDynamicObject("supplier").getPkValue();
                String tenderStrategy = dynamicObject.getString("tenderstrategy");
                if ("UNNEEDBID".equals(tenderStrategy)) continue;
                String tenderstatus = dynamicObject.getString("tenderstatus");
                if (supplierId != null && "".equals(tenderstatus)) {
                    newSupplierIds.add(supplierId);
                    continue;
                }
                reSupplierIds.add(supplierId);
            }
            msgParam.put("msgentity", "bid_bidpublish");
            msgParam.put("title", null);
            msgParam.put("content", null);
            msgParam.put("targetButtonId", "button_bid_file");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "targetButtonId"));
            newSupplierIds = newSupplierIds.stream().filter(o -> !reSupplierIds.contains(o)).collect(Collectors.toSet());
            if (newSupplierIds.size() > 0) {
                for (Long l : newSupplierIds) {
                    msgParam.put("tplScene", "bidpublishfee");
                    myTender = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, l);
                    tenderPk = 0L;
                    if (myTender != null) {
                        tenderPk = myTender.getLong("id");
                    }
                    msgParam.put("pkId", tenderPk);
                    notifyTypes = MessageChannelUtil.getNotifyType((String)"bidpublishfee", (String)"bid_bidpublish");
                    this.sendMessage(msgParam, bidProject.getPkValue(), l, false, notifyTypes);
                }
            }
            if (reSupplierIds.size() > 0) {
                for (Long l : reSupplierIds) {
                    msgParam.put("tplScene", "bidrepublishfee");
                    myTender = this.myTenderService.getMyTenderByBidProjectAndSupplier(projectId, l);
                    tenderPk = 0L;
                    if (myTender != null) {
                        tenderPk = myTender.getLong("id");
                    }
                    msgParam.put("pkId", tenderPk);
                    notifyTypes = MessageChannelUtil.getNotifyType((String)"bidrepublishfee", (String)"bid_bidpublish");
                    this.sendMessage(msgParam, bidProject.getPkValue(), l, false, notifyTypes);
                }
            }
        }
    }

    public void sendMessage(HashMap<String, Object> msgParam, Object bidProjectid, Long supplierIds, boolean isPlus, String notifyTypes) {
        if (StringUtils.isEmpty((CharSequence)notifyTypes)) {
            return;
        }
        String AppId = this.getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)AppId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        String appId = project.getString("entitytypeid").split("_")[0];
        DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"bidsection,bidsection.supplierentry,supplierentry,supplierentry.supplier,supplierentry.projectpartner", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectid), new QFilter("billstatus", "=", (Object)"P")}, (String)"createtime desc");
        if (bidPublishArray != null && bidPublishArray.length > 0) {
            DynamicObject bidPublish = bidPublishArray[0];
            DynamicObjectCollection bidSectionCol = bidPublish.getDynamicObjectCollection("bidsection");
            HashMap<Long, Long> hasMap = new HashMap<Long, Long>();
            for (DynamicObject bidSection : bidSectionCol) {
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    DynamicObject projectPartner;
                    Long supplierId = supplierEntry.getLong("supplier.id");
                    if (!supplierIds.equals(supplierId) || (projectPartner = supplierEntry.getDynamicObject("projectpartner")) == null) continue;
                    hasMap.put(supplierId, projectPartner.getLong("id"));
                }
            }
            Long supplierUserId = (Long)hasMap.get(supplierIds);
            msgParam.put("supplierId", supplierIds);
            if (supplierUserId != null) {
                msgParam.put("supplierBizUser", supplierUserId);
            } else {
                msgParam.remove("supplierBizUser");
            }
            MessageCenterHelper.sendMessages(msgParam, (boolean)true, (String)appId, (String)notifyTypes);
        }
    }

    public Set<Long> getBizPartnerUser(Long supplierId) {
        HashSet<Long> partnerUserSet = new HashSet<Long>(50);
        DynamicObject publish = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionColl = publish.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSectionColl) {
            String bidSectionPk = bidSection.getPkValue().toString();
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntryColl) {
                if (!supplierEntry.getDynamicObject("supplier").getPkValue().toString().equals(supplierId.toString()) || supplierEntry.getDynamicObject("projectpartner") == null) continue;
                partnerUserSet.add(supplierEntry.getDynamicObject("projectpartner").getLong("id"));
            }
        }
        return partnerUserSet;
    }

    public void rePublish_BeforeBindData() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        Object sourcePublish = publish.get("sourcepublish");
        String billStatus = publish.getString("billstatus");
        this.setFieldVisible(Boolean.FALSE);
        if (!(this.getView().getFormShowParameter().getCustomParam(ISREPUBLISH) == null && "0".equals(sourcePublish.toString()) || billStatus.equals("J") && billStatus.equals("X"))) {
            if (!billStatus.equals("C")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRMBID});
            }
            if (billStatus.equals("A") || billStatus.equals("D")) {
                this.setFieldEditableAndVisble();
            }
            this.setFieldVisible(Boolean.TRUE);
            Map<Long, Map<String, Object>> supplierAndSectionNameStatus = this.getTenderSuplierAndSectionStatus();
            if (!supplierAndSectionNameStatus.isEmpty()) {
                this.setSupplierEntryStatus(supplierAndSectionNameStatus, publish);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tenderstrategy", "tenderstatus", "invalidflag", "republishattachment", "repdescription"});
        }
    }

    public void setSupplierEntryStatus(Map<Long, Map<String, Object>> supplierAndSectionNameStatus, DynamicObject publish) {
        boolean isDocChange = publish.getBoolean("isdocchange");
        boolean isNewBill = publish.getBoolean("isnewbill");
        if (!isNewBill) {
            return;
        }
        String billStatus = publish.getString("billstatus");
        if (billStatus.equals("P")) {
            return;
        }
        boolean enablemultisection = publish.getDynamicObject("bidproject").getBoolean("enablemultisection");
        boolean exists = this.checkIsExist();
        DynamicObjectCollection sectionColl = publish.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < sectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionColl.get(i);
            String sectionName = section.getString("sectionname");
            DynamicObjectCollection supplierEntryColl = section.getDynamicObjectCollection("supplierentry");
            this.setTenderStatusAndTenderstrategy(supplierEntryColl, sectionName, exists, billStatus, isDocChange, supplierAndSectionNameStatus);
        }
        this.getView().updateView("supplierentry");
    }

    public void setTenderStatusAndTenderstrategy(DynamicObjectCollection supplierEntryColl, String sectionName, boolean exists, String billStatus, boolean isDocChange, Map<Long, Map<String, Object>> supplierAndSectionNameStatus) {
        for (int j = 0; j < supplierEntryColl.size(); ++j) {
            String status;
            DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
            Long supplierId = (Long)supplierEntry.getDynamicObject("supplier").getPkValue();
            Map<String, Object> sectionNameStatusMap = supplierAndSectionNameStatus.get(supplierId);
            if (sectionNameStatusMap == null) continue;
            String tenderStatus = null;
            if (sectionNameStatusMap.get(sectionName) != null) {
                tenderStatus = (String)sectionNameStatusMap.get(sectionName);
            }
            String invalid = supplierEntry.getString("invalidflag");
            if (tenderStatus == null) continue;
            if (("TENDERED".equals(tenderStatus) || "UNTENDERED".equals(tenderStatus) || "PRETENDERED".equals(tenderStatus)) && !exists) {
                supplierEntry.set("tenderstatus", (Object)tenderStatus);
            }
            this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
            if (tenderStatus.equals("TENDERED")) {
                if (isDocChange) {
                    if (!(!billStatus.equals("D") && exists || invalid.equals("1"))) {
                        supplierEntry.set("tenderstrategy", (Object)"NEEDBID");
                    }
                    if (!billStatus.equals("D") && exists || !invalid.equals("1")) continue;
                    supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
                    continue;
                }
                if (!billStatus.equals("D") && !billStatus.equals("A") && exists || !StringUtils.isNotEmpty((CharSequence)(status = supplierEntry.getString("tenderstatus"))) || exists && !billStatus.equals("D")) continue;
                supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
                continue;
            }
            if (tenderStatus.equals("PRETENDERED")) {
                if (exists) continue;
                supplierEntry.set("tenderstrategy", (Object)"");
                continue;
            }
            if (!tenderStatus.equals("UNTENDERED") || !billStatus.equals("D") && !billStatus.equals("A") && exists || !StringUtils.isNotEmpty((CharSequence)(status = supplierEntry.getString("tenderstatus"))) || !billStatus.equals("D") && exists) continue;
            supplierEntry.set("tenderstrategy", (Object)"UNNEEDBID");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Object pkValue;
        boolean exists;
        super.beforeItemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getOperationKey(), (CharSequence)KEY_CONFIRMPUBLISH)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_CONFIRMPUBLISH, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u6807\u540e\u5c06\u4e0d\u80fd\u64a4\u9500\uff0c\u786e\u5b9a\u8981\u53d1\u6807\u5417\uff1f", (String)"BidPublishEditUI_47", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            evt.setCancel(true);
            return;
        }
        if ("refresh".equals(evt.getOperationKey()) && !(exists = QueryServiceHelper.exists((String)"bid_bidpublish", (Object)(pkValue = this.getModel().getDataEntity().getPkValue())))) {
            evt.setCancel(true);
            return;
        }
    }

    public Boolean checkDocument(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pk = dataEntity.getPkValue();
        String key = "TampAttCache" + this.getView().getPageId();
        String xObject = this.getPageCache().get(key);
        JSONObject attObject = null;
        String formID = FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass());
        DynamicObject bidProject = this.getModel().getDataEntity(true).getDynamicObject(this.BID_PROJECT);
        boolean isseparatedoc = bidProject.getBoolean("isseparatedoc");
        String docTypeStr = bidProject.getString("doctype");
        if (isseparatedoc) {
            List comAttachmentpanel = AttachmentServiceHelper.getAttachments((String)formID, (Object)pk, (String)"com_attachmentpanel");
            List techAttachmentpanelap = AttachmentServiceHelper.getAttachments((String)formID, (Object)pk, (String)"tech_attachmentpanelap");
            if (xObject != null) {
                attObject = (JSONObject)JSONArray.parse((String)this.getPageCache().get(key));
                JSONArray comAttachment = (JSONArray)attObject.get((Object)"com_attachmentpanel");
                JSONArray techAttachment = (JSONArray)attObject.get((Object)"tech_attachmentpanelap");
                if (docTypeStr.equals(BidOpenTypeEnum.BUSSINESS.getValue()) || docTypeStr.equals(BidOpenTypeEnum.MULTI.getValue())) {
                    if (comAttachment != null) {
                        if (comAttachment.isEmpty() && comAttachmentpanel.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            if (args != null) {
                                args.setCancel(true);
                            }
                            return Boolean.FALSE;
                        }
                    } else if (attObject.get((Object)"com_attachmentpanel") == null && comAttachmentpanel.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        if (args != null) {
                            args.setCancel(true);
                        }
                        return Boolean.FALSE;
                    }
                }
                if (docTypeStr.equals(BidOpenTypeEnum.TECHNICAL.getValue()) || docTypeStr.equals(BidOpenTypeEnum.MULTI.getValue())) {
                    if (techAttachment != null) {
                        if (techAttachment.isEmpty() && techAttachmentpanelap.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                            if (args != null) {
                                args.setCancel(true);
                            }
                            return Boolean.FALSE;
                        }
                    } else if (attObject.get((Object)"tech_attachmentpanelap") == null && techAttachmentpanelap.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        if (args != null) {
                            args.setCancel(true);
                        }
                        return Boolean.FALSE;
                    }
                }
            } else {
                if ((docTypeStr.equals(BidOpenTypeEnum.BUSSINESS.getValue()) || docTypeStr.equals(BidOpenTypeEnum.MULTI.getValue())) && comAttachmentpanel.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    if (args != null) {
                        args.setCancel(true);
                    }
                    return Boolean.FALSE;
                }
                if ((docTypeStr.equals(BidOpenTypeEnum.TECHNICAL.getValue()) || docTypeStr.equals(BidOpenTypeEnum.MULTI.getValue())) && techAttachmentpanelap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    if (args != null) {
                        args.setCancel(true);
                    }
                    return Boolean.FALSE;
                }
            }
        } else {
            List attachmentList = AttachmentServiceHelper.getAttachments((String)formID, (Object)pk, (String)"attachmentpanel");
            if (xObject != null) {
                attObject = (JSONObject)JSONArray.parse((String)this.getPageCache().get(key));
                JSONArray attachment = (JSONArray)attObject.get((Object)"attachmentpanel");
                if (attachment != null) {
                    if (attachment.isEmpty() && attachmentList.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u62db\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        if (args != null) {
                            args.setCancel(true);
                        }
                        return Boolean.FALSE;
                    }
                } else if (attObject.get((Object)"attachmentpanel") == null && attachmentList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u62db\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    if (args != null) {
                        args.setCancel(true);
                    }
                    return Boolean.FALSE;
                }
            } else if (attachmentList.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u62db\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishEditUI_50", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                if (args != null) {
                    args.setCancel(true);
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (KEY_CONFIRMPUBLISH.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String billStatus;
            DynamicObject project = (DynamicObject)this.getModel().getValue("bidproject");
            Long projectId = project.getLong("id");
            boolean canRePublish = this.canRePublish(projectId, true);
            if (!canRePublish) {
                return;
            }
            String changeFlag = this.getPageCache().get("isChanged");
            boolean isDataChanged = true;
            if (changeFlag != null && changeFlag.equals("0") && !this.getModel().getDataChanged()) {
                isDataChanged = false;
            }
            if (!(StringUtils.equals((CharSequence)(billStatus = (String)this.getModel().getValue("billstatus")), (CharSequence)BillStatusEnum.AUDITED.getVal()) || !isDataChanged && StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus))) {
                if (isDataChanged) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4fe1\u606f\u6709\u4fee\u6539\uff0c\u8bf7\u5ba1\u6279\u901a\u8fc7\u540e\u518d\u786e\u8ba4\u53d1\u6807\u3002", (String)"BidPublishEditUI_51", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    DynamicObject model = this.getModel().getDataEntity();
                    this.addLog(ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u6807", (String)"BidPublishEditUI_52", (String)"scm-bid-formplugin", (Object[])new Object[0]), model.getString("billno"), ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u6807\u5931\u8d25", (String)"BidPublishEditUI_53", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u5ba1\u6838\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u80fd\u786e\u8ba4\u53d1\u6807\u3002", (String)"BidPublishEditUI_54", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                DynamicObject model = this.getModel().getDataEntity();
                this.addLog(ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u6807", (String)"BidPublishEditUI_52", (String)"scm-bid-formplugin", (Object[])new Object[0]), model.getString("billno"), ResManager.loadKDString((String)"\u786e\u8ba4\u53d1\u6807\u5931\u8d25", (String)"BidPublishEditUI_53", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean checkDocument = this.checkDocument(null);
            if (checkDocument.booleanValue()) {
                this.getView().invokeOperation(KEY_CONFIRMPUBLISH);
            }
        }
    }

    public void setTenderStrategy() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        DynamicObjectCollection sectionColl = publish.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < sectionColl.size(); ++i) {
            DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < supplierEntryColl.size(); ++j) {
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
            }
        }
    }

    public void setTenderStrategyEditable(int row) {
        DynamicObjectCollection sectionColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        for (int i = 0; i < sectionColl.size(); ++i) {
            if (i != row) continue;
            DynamicObjectCollection supplierEntryColl = ((DynamicObject)sectionColl.get(i)).getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < supplierEntryColl.size(); ++j) {
                DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                this.getView().setEnable(Boolean.FALSE, new String[]{"tenderstrategy"});
                String tenderStatus = supplierEntry.getString("tenderstatus");
                if (!StringUtils.isEmpty((CharSequence)tenderStatus)) {
                    if (tenderStatus.equals("PRETENDERED")) {
                        this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
                        continue;
                    }
                    this.getView().setEnable(Boolean.TRUE, j, new String[]{"tenderstrategy"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"tenderstrategy"});
            }
        }
        this.getView().updateView("supplierentry");
    }

    protected void createListCardEntrys(DynamicObject myTender, DynamicObject section) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection listEntrys = dataEntity.getDynamicObjectCollection("listentry");
        if (listEntrys.size() == 0) {
            return;
        }
        String sectionName = section.getString("sectionname");
        DynamicObjectCollection tenderListEntrys = myTender.getDynamicObjectCollection("listentry");
        HashMap<String, DynamicObject> tenderListEntryMap = new HashMap<String, DynamicObject>();
        for (DynamicObject tenderListEntry : tenderListEntrys) {
            String tenderSectionName = tenderListEntry.getString("listentry_sectionname");
            tenderListEntryMap.put(tenderSectionName, tenderListEntry);
        }
        for (DynamicObject listEntry : listEntrys) {
            String listSectionName = listEntry.getString("listentry_sectionname");
            if (!sectionName.equals(listSectionName)) continue;
            DynamicObject oldTenderListEntry = (DynamicObject)tenderListEntryMap.get(sectionName);
            if (null == oldTenderListEntry) {
                DynamicObject tenderListEntry = tenderListEntrys.addNew();
                tenderListEntry.set("listentry_sectionname", (Object)listSectionName);
                tenderListEntry.set("listentry_listbill", listEntry.get("listentry_listbill"));
                tenderListEntry.set("listentry_resume", listEntry.get("listentry_resume"));
                DynamicObjectCollection newListDesColl = tenderListEntry.getDynamicObjectCollection("listentry_description");
                DynamicObjectCollection decriptionColl = listEntry.getDynamicObjectCollection("listentry_description");
                for (DynamicObject listDesObj : decriptionColl) {
                    DynamicObject newListDesObj = newListDesColl.addNew();
                    newListDesObj.set(LISTENTRY_ATTCHMENT, listDesObj.get(LISTENTRY_ATTCHMENT));
                }
                break;
            }
            oldTenderListEntry.set("listentry_resume", listEntry.get("listentry_resume"));
            DynamicObjectCollection newListDesColl = oldTenderListEntry.getDynamicObjectCollection("listentry_description");
            newListDesColl.clear();
            DynamicObjectCollection decriptionColl = listEntry.getDynamicObjectCollection("listentry_description");
            for (DynamicObject listDesObj : decriptionColl) {
                DynamicObject newListDesObj = newListDesColl.addNew();
                newListDesObj.set(LISTENTRY_ATTCHMENT, listDesObj.get(LISTENTRY_ATTCHMENT));
            }
        }
    }

    public boolean checkDocumentIsChange() {
        boolean flag;
        DynamicObject publish = this.getModel().getDataEntity(true);
        DynamicObject project = publish.getDynamicObject("bidproject");
        boolean isseparatedoc = project.getBoolean("isseparatedoc");
        String appId = this.getModel().getDataEntityType().getAppId();
        Object sourId = publish.get("sourcepublish");
        DynamicObject bidDocument = BusinessDataServiceHelper.loadSingle((String)(appId + "_biddocument_edit"), (String)"id,billstatus,auditdate,modifytime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", project.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
        Object sourcepublishId = this.getView().getFormShowParameter().getCustomParam("sourcePublishId");
        if (sourcepublishId == null) {
            sourcepublishId = sourId;
        }
        boolean bl = flag = bidDocument != null && sourcepublishId != null && !"0".equals(sourcepublishId);
        if (flag) {
            DynamicObject oldPublish = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sourcepublishId.toString()), (String)"bid_bidpublish");
            Date finalDocAuditDate = bidDocument.getDate("auditdate");
            Date oldDate = oldPublish.getDate("modifytime");
            if (finalDocAuditDate.getTime() > oldDate.getTime()) {
                return true;
            }
        }
        return false;
    }

    public void deleteAttachment() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        DynamicObject project = publish.getDynamicObject("bidproject");
        boolean isseparatedoc = project.getBoolean("isseparatedoc");
        if (isseparatedoc) {
            Map map;
            int i;
            List docTechFileList = AttachmentServiceHelper.getAttachments((String)this.getBillId(), (Object)publish.getPkValue(), (String)TECH_ATTACHMENTPANELAP);
            List docComFileList = AttachmentServiceHelper.getAttachments((String)this.getBillId(), (Object)publish.getPkValue(), (String)COM_ATTACHMENTPANEL);
            for (i = 0; i < docTechFileList.size(); ++i) {
                map = (Map)docTechFileList.get(i);
                this.removeBidPublishAttachment(this.getBillId(), publish.getPkValue(), map.get("uid"));
            }
            for (i = 0; i < docComFileList.size(); ++i) {
                map = (Map)docComFileList.get(i);
                this.removeBidPublishAttachment(this.getBillId(), publish.getPkValue(), map.get("uid"));
            }
        } else {
            List docAttachmentList = AttachmentServiceHelper.getAttachments((String)this.getBillId(), (Object)publish.getPkValue(), (String)ATTACHMENTPANEL);
            for (int i = 0; i < docAttachmentList.size(); ++i) {
                Map map = (Map)docAttachmentList.get(i);
                this.removeBidPublishAttachment(this.getBillId(), publish.getPkValue(), map.get("uid"));
            }
        }
    }

    protected void removeBidPublishAttachment(String formId, Object pkId, Object fileUid) {
        QFilter[] filters;
        DynamicObjectCollection dynamicObjectCollection;
        if (pkId != null) {
            Object object = pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        if (null != (dynamicObjectCollection = QueryServiceHelper.query((String)"bos_attachment", (String)"FFileId", (QFilter[])(filters = new QFilter[]{new QFilter("FNUMBER", "=", fileUid), new QFilter("FInterID", "=", pkId), new QFilter("FBillType", "=", (Object)formId)}))) && dynamicObjectCollection.size() > 0) {
            DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])filters);
        }
    }

    public List<Long> getSupplierInvitationNewSupplier() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        String source = publish.getString("source");
        ArrayList<Long> invSupplierIds = new ArrayList<Long>();
        if (!StringUtils.isEmpty((CharSequence)"source") && source.equals("resupplierInvitation")) {
            DynamicObject invitation = publish.getDynamicObject(SUPPLIERINVITATIONID);
            DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)invitation.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()));
            DynamicObjectCollection invBidsectionColl = supplierInvitation.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < invBidsectionColl.size(); ++i) {
                DynamicObjectCollection supplierEntryColl = ((DynamicObject)invBidsectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntryColl.size(); ++j) {
                    DynamicObject supplier = ((DynamicObject)supplierEntryColl.get(j)).getDynamicObject("supplier");
                    Boolean isNew = ((DynamicObject)supplierEntryColl.get(j)).getBoolean("isnew");
                    if (!isNew.booleanValue()) continue;
                    invSupplierIds.add((Long)supplier.getPkValue());
                }
            }
        }
        return invSupplierIds;
    }

    public void setDatetime() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        DynamicObject bidProject = this.getModel().getDataEntity(true).getDynamicObject("bidproject");
        boolean isnewbill = publish.getBoolean("isnewbill");
        String billstatus = publish.getString("billstatus");
        if (isnewbill && billstatus.equals("D")) {
            publish.set("planbidpublishdate1", bidProject.get("bidpublishdate"));
            publish.set("plananswerquestiontime", bidProject.get("answerquestiontime"));
            publish.set("answeringendtime", bidProject.get("answercomplete"));
            publish.set("planbidopendeadline", bidProject.get("bidopendeadline"));
            publish.set("techbackbidtime", bidProject.get("techbackbidtime"));
            publish.set("busbackbidtime", bidProject.get("busbackbidtime"));
            publish.set("planbidevaluationdate", bidProject.get("bidevaluationdate"));
            publish.set("bidbustalkdate", bidProject.get("bidbustalkdate"));
            publish.set("planbiddecisiondate", bidProject.get("biddecisiondate"));
        } else {
            publish.set("planbidpublishdate1", publish.get("planbidpublishdate1"));
            publish.set("plananswerquestiontime", publish.get("plananswerquestiontime"));
            publish.set("answeringendtime", publish.get("answeringendtime"));
            publish.set("planbidopendeadline", publish.get("planbidopendeadline"));
            publish.set("techbackbidtime", publish.get("techbackbidtime"));
            publish.set("busbackbidtime", publish.get("busbackbidtime"));
            publish.set("planbidevaluationdate", publish.get("planbidevaluationdate"));
            publish.set("bidbustalkdate", publish.get("bidbustalkdate"));
            publish.set("planbiddecisiondate", publish.get("planbiddecisiondate"));
        }
    }

    public void setFieldEditableAndVisble() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        DynamicObject bidProject = publish.getDynamicObject("bidproject");
        String billStatus = publish.getString("billstatus");
        DynamicObject bidmode = bidProject.getDynamicObject("bidmode");
        DynamicObject mode = BusinessDataServiceHelper.loadSingle((Object)bidmode.getPkValue(), (String)"bid_bidmode");
        if (!billStatus.equals("A") && !billStatus.equals("D")) {
            boolean bidanswerquestion = mode.getBoolean("bidanswerquestion");
            if (bidanswerquestion) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"answeringendtime", "plananswerquestiontime"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"answeringendtime", "plananswerquestiontime"});
            }
            String doctype = bidProject.getString("doctype");
            String backbidway = bidProject.getString("backbidway");
            boolean bidevaluation = mode.getBoolean("bidevaluation");
            if (bidevaluation) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"planbidevaluationdate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"planbidevaluationdate"});
            }
            boolean isBidbustalk = mode.getBoolean("bidbustalk");
            if (isBidbustalk) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bidbustalkdate"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bidbustalkdate"});
            }
            return;
        }
        Object bidpublishdate = bidProject.get("bidpublishdate");
        if (bidpublishdate == null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"planbidpublishdate1"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"planbidpublishdate1"});
        }
        boolean bidanswerquestion = mode.getBoolean("bidanswerquestion");
        if (bidanswerquestion) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"answeringendtime", "plananswerquestiontime"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"answeringendtime", "plananswerquestiontime"});
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"plananswerquestiontime"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"planbidopendeadline"});
        String doctype = bidProject.getString("doctype");
        String backbidway = bidProject.getString("backbidway");
        boolean bidevaluation = mode.getBoolean("bidevaluation");
        if (bidevaluation) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"planbidevaluationdate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"planbidevaluationdate"});
        }
        boolean isBidbustalk = mode.getBoolean("bidbustalk");
        if (isBidbustalk) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bidbustalkdate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidbustalkdate"});
        }
    }

    public void setFieldVisible(Boolean visible) {
        this.getView().setVisible(visible, new String[]{"isnew"});
    }

    public Map<Long, Map<String, Object>> getTenderSuplierAndSectionStatus() {
        DynamicObject publish = this.getModel().getDataEntity(true);
        Long pk = (Long)publish.getDynamicObject("bidproject").getPkValue();
        String tenderForm = null;
        tenderForm = BID.equals(this.getModel().getDataEntityType().getAppId()) ? "ten_mytender" : "resp_mytender";
        DynamicObject[] mytenders = BusinessDataServiceHelper.load((String)tenderForm, (String)"id,tenderstatus,supplier,entry.sectionstatus,entry.sectionname", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)pk)});
        HashMap<Long, Map<String, Object>> supplierAndSectionNameStatus = new HashMap<Long, Map<String, Object>>(16);
        for (int i = 0; i < mytenders.length; ++i) {
            DynamicObject mytender = mytenders[i];
            Long supplierId = (Long)mytender.getDynamicObject("supplier").getPkValue();
            DynamicObjectCollection entryColl = mytender.getDynamicObjectCollection("entry");
            HashMap<String, String> SectionNameAndStatusMap = new HashMap<String, String>();
            for (DynamicObject entry : entryColl) {
                String sectionStatus = entry.getString("sectionstatus");
                String sectionName = entry.getString("sectionname");
                SectionNameAndStatusMap.put(sectionName, sectionStatus);
            }
            supplierAndSectionNameStatus.put(supplierId, SectionNameAndStatusMap);
        }
        return supplierAndSectionNameStatus;
    }

    public boolean checkIsExist() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("id", "=", (Object)pkValue);
        boolean exists = QueryServiceHelper.exists((String)"bid_bidpublish", (QFilter[])new QFilter[]{qFilter});
        return exists;
    }

    public void setBackbidWayVisible(DynamicObject bidProject) {
        String doctype = bidProject.getString("doctype");
        if (!StringUtils.isEmpty((CharSequence)doctype) && !doctype.equals("MULTI")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"backbidway", "bidopentype", "planbidopendeadline"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"busbackbidtime"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"backbidway", "bidopentype", "planbidopendeadline"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"busbackbidtime"});
        }
    }

    public void setPublishTimes(DynamicObject publish, String appId) {
        Long pkValue = publish.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)pkValue);
        boolean exists = QueryServiceHelper.exists((String)"bid_bidpublish", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            return;
        }
        long bidprojectId = publish.getDynamicObject("bidproject").getLong("id");
        QFilter bidFilter = new QFilter("bidproject", "=", (Object)bidprojectId);
        DynamicObject[] historyBidpubs = BusinessDataServiceHelper.load((String)(appId + "_bidpublish"), (String)"id", (QFilter[])bidFilter.toArray());
        int publishtimes = 0;
        if (historyBidpubs != null) {
            publishtimes = historyBidpubs.length;
        }
        if (!exists) {
            publish.set("publishtimes", (Object)this.getroundsList(String.valueOf(publishtimes + 1) + ""));
        }
    }

    public String getroundsList(String str) {
        StringBuilder result = new StringBuilder();
        result.append(ResManager.loadKDString((String)"\u7b2c", (String)"BidPublishEditUI_127", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                result.append(this.getS1()[num]).append(this.getS2()[n - 2 - i]);
                continue;
            }
            result.append(this.getS1()[num]);
        }
        result.append(ResManager.loadKDString((String)"\u8f6e\u53d1\u6807", (String)"BidPublishEditUI_128", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        return result.toString();
    }

    protected String[] getS1() {
        return new String[]{ResManager.loadKDString((String)"\u96f6", (String)"BidPublishEditUI_129", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"BidPublishEditUI_130", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"BidPublishEditUI_131", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"BidPublishEditUI_132", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"BidPublishEditUI_133", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"BidPublishEditUI_134", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"BidPublishEditUI_135", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"BidPublishEditUI_136", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"BidPublishEditUI_137", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"BidPublishEditUI_138", (String)"scm-bid-formplugin", (Object[])new Object[0])};
    }

    protected String[] getS2() {
        return new String[]{ResManager.loadKDString((String)"\u5341", (String)"BidPublishEditUI_139", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishEditUI_140", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishEditUI_141", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"BidPublishEditUI_142", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidPublishEditUI_139", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishEditUI_140", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishEditUI_141", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"BidPublishEditUI_143", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidPublishEditUI_139", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidPublishEditUI_140", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidPublishEditUI_141", (String)"scm-bid-formplugin", (Object[])new Object[0])};
    }

    protected Date getNeedSetFormatDate(String dateType, Date date) {
        if (date == null) {
            return date;
        }
        ArrayList<String> dateTypeList = new ArrayList<String>(16);
        dateTypeList.add("planbidpublishdate1");
        dateTypeList.add("answeringendtime");
        dateTypeList.add("planbidevaluationdate");
        dateTypeList.add("bidbustalkdate");
        dateTypeList.add("planbiddecisiondate");
        if (dateTypeList.contains(dateType)) {
            return DateUtils.endOfDay((Date)date);
        }
        return date;
    }
}

