/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.bid.formplugin.bill.util.OperationLogUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class BidPublishListUI
extends AbstractListPlugin {
    private static final IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        ((IListView)this.getView()).refresh();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        Boolean enable = StringUtils.isNotEmpty((CharSequence)viewhistory);
        if (enable.booleanValue()) {
            List CommonFilter = args.getCommonFilterColumns();
            List SchemeFilterColumn = args.getSchemeFilterColumns();
            CommonFilter.clear();
            SchemeFilterColumn.clear();
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (IListColumn item : columnList) {
            String fieldName = item.getListFieldKey();
            if ("modifytime".equals(fieldName)) {
                item.setVisible(0);
            }
            if (!"billstatus".equals(fieldName)) continue;
            item.setVisible(63);
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        filters.forEach(filter -> {
            if ("projectajdustname".equals(filter.getProperty())) {
                filter.__setProperty("bidproject.name");
                filter.getNests(true).forEach(item -> item.getFilter().__setProperty("bidproject.name"));
            }
        });
        if (StringUtils.isEmpty((CharSequence)viewhistory)) {
            filters.add(BidHistoryUtil.getPublishListQFilter());
        } else {
            Object bidProjectId = parameter.getCustomParam("bidProjectId");
            filters.add(new QFilter("bidproject.id", "=", (Object)((Long)bidProjectId)));
            filters.add(new QFilter("billstatus", "=", (Object)"X"));
            filters.add(new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()));
            filters.add(new QFilter("isnewbill", "!=", (Object)Boolean.TRUE));
            e.setMainOrgQFilter(null);
        }
        super.setFilter(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if ("viewhistory".equals(operateKey)) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object bidProjectId = BusinessDataServiceHelper.loadSingle((Object)sr.getPrimaryKeyValue(), (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass())).getDynamicObject("bidproject").getPkValue();
            if (BidHistoryUtil.havePublishHistory("bid", bidProjectId).booleanValue()) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("bidProjectId", bidProjectId);
                listShowParameter.setCustomParam("viewhistory", (Object)"viewhistory");
                listShowParameter.setMultiSelect(false);
                listShowParameter.setHasRight(true);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"bidpublish_history", ((Object)((Object)this)).getClass()));
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u518d\u6b21\u53d1\u6807\u8bb0\u5f55\u3002", (String)"BidPublishListUI_80", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        if (StringUtils.equals((CharSequence)"tblbidpublish", (CharSequence)evt.getItemKey())) {
            String billstatus;
            if (listSelectedRowCollection.isEmpty() || listSelectedRowCollection.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BidPublishListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            RequestContext context = RequestContext.get();
            String userId = context.getUserId();
            String selectNode = String.valueOf(listSelectedRowCollection.get(0).getPrimaryKeyValue());
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(selectNode));
            String entityName = FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass());
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"billstatus,billno,bidproject.billno", (QFilter[])new QFilter[]{filter});
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5bf9\u591a\u6761\u6570\u636e\u8fdb\u884c\u7f16\u5236\u64cd\u4f5c\u3002", (String)"BidPublishListUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (!StringUtils.equals((CharSequence)(billstatus = bidPublish.getString("billstatus")), (CharSequence)BillStatusEnum.DISBEGIN.getVal()) && !StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.SAVE.getVal())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u7f16\u5236\u672a\u5f00\u59cb\u548c\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"BidPublishListUI_81", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
                evt.setCancel(true);
                return;
            }
        }
    }

    private String getAppId() {
        String formID = ((IListView)this.getView()).getBillFormId();
        return BidUtils.getAppID((String)formID);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object pk;
        String billStatus;
        DynamicObject bidPublish;
        super.beforeDoOperation(args);
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        FormOperate operate = (FormOperate)args.getSource();
        if ("republish".equals(operate.getOperateKey())) {
            DynamicObject bidDecision;
            String billStatusTemp;
            if (listSelectedRowCollection.isEmpty() || listSelectedRowCollection.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BidPublishListUI_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String selectNode = String.valueOf(listSelectedRowCollection.get(0).getPrimaryKeyValue());
            QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(selectNode));
            bidPublish = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"billstatus,billno,bidproject,isnewbill", (QFilter[])new QFilter[]{filter});
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u540c\u65f6\u5bf9\u591a\u6761\u6570\u636e\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u64cd\u4f5c\u3002", (String)"BidPublishListUI_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean isNewBill = bidPublish.getBoolean("isnewbill");
            billStatus = bidPublish.getString("billStatus");
            if (!isNewBill) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u6709\u65b0\u53d1\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_82", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
                args.setCancel(true);
                return;
            }
            QFilter projectFilter = new QFilter("bidproject", "=", bidPublish.getDynamicObject("bidproject").getPkValue());
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
            DynamicObject[] bidDecisionCol = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{projectFilter, statusFilter});
            if (bidDecisionCol != null && bidDecisionCol.length > 0 && !(billStatusTemp = (bidDecision = bidDecisionCol[0]).getString("billstatus")).equals("D") && !billStatusTemp.equals("XX")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u62db\u6807\u7acb\u9879\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_69", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
                args.setCancel(true);
                return;
            }
            Object bidproject = bidPublish.getDynamicObject("bidproject").getPkValue();
            boolean flag = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"supplierinvalid", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "!=", (Object)"C")});
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidproject);
            if (exsitBackBid) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5728\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_73", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!StringUtils.equals((CharSequence)BillStatusEnum.PUBLISHED.getVal(), (CharSequence)billStatus)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u4ec5\u652f\u6301\u5bf9\u5df2\u786e\u8ba4\u53d1\u6807\u7684\u53d1\u6807\u5355\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_83", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
                args.setCancel(true);
                return;
            }
            Long projectId = (Long)bidPublish.getDynamicObject("bidproject").getPkValue();
            Object project = this.getView().getModel().getDataEntity(true).getPkValue();
            String appId = this.getAppId();
            String checkQueryIsProcess = questionClarifyService.checkQueryIsProcess(projectId, appId);
            if (StringUtils.isNotBlank((CharSequence)checkQueryIsProcess)) {
                this.getView().showErrorNotification(checkQueryIsProcess);
                return;
            }
            QFilter bidProjectFilter = new QFilter("bidproject.id", "=", (Object)projectId);
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"B").or(new QFilter("billstatus", "=", (Object)"I"));
            DynamicObject[] supplierInvitations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            DynamicObject[] bidDocuments = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"B", "I", "P"}), bidProjectFilter});
            DynamicObject[] onlineBidEvals = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
            if (supplierInvitations.length > 0) {
                DynamicObject supplierInvitation = supplierInvitations[0];
                String billstatus = supplierInvitation.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishListUI_84", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (bidDocuments.length > 0) {
                DynamicObject bidDocument = bidDocuments[0];
                String billstatus = bidDocument.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishListUI_85", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishListUI_86", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (bidOpens.length > 0) {
                DynamicObject bidOpen = bidOpens[0];
                String billstatus = bidOpen.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else if (billstatus.equals("I")) {
                    this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishListUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u4e2d", (String)"BidPublishListUI_75", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (onlineBidEvals.length > 0) {
                DynamicObject onlineBidEval = onlineBidEvals[0];
                String billstatus = onlineBidEval.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishListUI_87", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishListUI_88", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if (bidEvaluations.length > 0) {
                DynamicObject bidEvaluation = bidEvaluations[0];
                String billstatus = bidEvaluation.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishListUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            DynamicObject bidProject = bidPublish.getDynamicObject("bidproject");
            if (!this.canRePublish((Long)bidProject.getPkValue())) {
                this.addLog(ResManager.loadKDString((String)"\u91cd\u65b0\u53d1\u6807", (String)"BidPublishListUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cd\u65b0\u53d1\u6807\u5931\u8d25", (String)"BidPublishListUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean existFlag = QueryServiceHelper.exists((String)(appId + "_bustalk"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "in", (Object)new String[]{"B", "I"})});
            if (existFlag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_76", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject[] bustalks = BusinessDataServiceHelper.load((String)(appId + "_bustalk"), (String)"id,offerstoptime,createtime,openonlinesynergy,offerstoptime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE), new QFilter("billstatus", "in", (Object)new String[]{"C"})}, (String)"createtime desc");
            if (bustalks.length > 0) {
                DynamicObject bustalk = bustalks[0];
                boolean existsInvite = QueryServiceHelper.exists((String)(appId + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", (Object)((Long)bustalk.getPkValue())), new QFilter("status", "in", (Object)new String[]{"B", "I"})});
                if (existsInvite) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_77", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (bustalk.getBoolean("openonlinesynergy") && bustalk.getDate("offerstoptime").after(new Date())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u672a\u5230\u622a\u6b62\u65f6\u95f4\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_78", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getCustomParams().put("iscopy", Boolean.TRUE);
            parameter.getCustomParams().put("isCopyRelateEntity", Boolean.TRUE);
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setPkId((Object)Long.parseLong(bidPublish.getPkValue().toString()));
            parameter.setCustomParam("sourcePublishId", (Object)Long.parseLong(bidPublish.getPkValue().toString()));
            parameter.setCustomParam("isRePublish", (Object)Boolean.TRUE);
            this.getView().showForm((FormShowParameter)parameter);
        }
        if ("submit".equals(operate.getOperateKey())) {
            for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                String billstatus;
                String tip;
                pk = listSelectedRowCollection.get(i).getPrimaryKeyValue();
                bidPublish = BusinessDataServiceHelper.loadSingle((Object)pk, (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"bidproject.name");
                Object name = bidPublish.getDynamicObject("bidproject").get("name");
                boolean isseparatedoc = bidPublish.getDynamicObject("bidproject").getBoolean("isseparatedoc");
                if (isseparatedoc) {
                    List comAttachmentpanel = AttachmentServiceHelper.getAttachments((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (Object)pk, (String)"com_attachmentpanel");
                    if (comAttachmentpanel.isEmpty()) {
                        tip = String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165%s\u7684\u201c\u5546\u52a1\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishListUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]), name);
                        this.getView().showTipNotification(tip);
                        args.setCancel(true);
                        return;
                    }
                    List techAttachmentpanelap = AttachmentServiceHelper.getAttachments((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (Object)pk, (String)"tech_attachmentpanelap");
                    if (techAttachmentpanelap.isEmpty()) {
                        String tip2 = String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165%s\u7684\u201c\u6280\u672f\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishListUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]), name);
                        this.getView().showTipNotification(tip2);
                        args.setCancel(true);
                        return;
                    }
                } else {
                    List attachmentList = AttachmentServiceHelper.getAttachments((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (Object)pk, (String)"attachmentpanel");
                    if (attachmentList.isEmpty()) {
                        tip = String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165%s\u7684\u201c\u62db\u6807\u6587\u4ef6\u9644\u4ef6\u201d\u3002", (String)"BidPublishListUI_24", (String)"scm-bid-formplugin", (Object[])new Object[0]), name);
                        this.getView().showTipNotification(tip);
                        args.setCancel(true);
                        return;
                    }
                }
                Long projectId = (Long)bidPublish.getDynamicObject("bidproject").getPkValue();
                QFilter bidProjectFilter = new QFilter("bidproject.id", "=", (Object)projectId);
                QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"B").or(new QFilter("billstatus", "=", (Object)"I"));
                DynamicObject[] supplierInvitations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
                DynamicObject[] bidDocuments = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
                DynamicObject[] bidOpens = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
                DynamicObject[] onlineBidEvals = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
                DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{billStatusFilter, bidProjectFilter});
                if (supplierInvitations.length > 0) {
                    DynamicObject supplierInvitation = supplierInvitations[0];
                    billstatus = supplierInvitation.getString("billstatus");
                    if (billstatus.equals("B")) {
                        this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishListUI_9", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        this.showTip(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishListUI_84", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                if (bidDocuments.length > 0) {
                    DynamicObject bidDocument = bidDocuments[0];
                    billstatus = bidDocument.getString("billstatus");
                    if (billstatus.equals("B")) {
                        this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishListUI_85", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        this.showTip(ResManager.loadKDString((String)"\u6807\u4e66\u7f16\u5236\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishListUI_86", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                if (bidOpens.length > 0) {
                    DynamicObject bidOpen = bidOpens[0];
                    billstatus = bidOpen.getString("billstatus");
                    if (billstatus.equals("B")) {
                        this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishListUI_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        this.showTip(ResManager.loadKDString((String)"\u5f00\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishListUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                if (onlineBidEvals.length > 0) {
                    DynamicObject onlineBidEval = onlineBidEvals[0];
                    billstatus = onlineBidEval.getString("billstatus");
                    if (billstatus.equals("B")) {
                        this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5df2\u63d0\u4ea4\u3002", (String)"BidPublishListUI_87", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    } else {
                        this.showTip(ResManager.loadKDString((String)" \u5728\u7ebf\u8bc4\u6807\u5ba1\u6838\u4e2d\u3002", (String)"BidPublishListUI_88", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                if (bidEvaluations.length <= 0) continue;
                DynamicObject bidEvaluation = bidEvaluations[0];
                billstatus = bidEvaluation.getString("billstatus");
                if (billstatus.equals("B")) {
                    this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5df2\u63d0\u4ea4", (String)"BidPublishListUI_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                } else {
                    this.showTip(ResManager.loadKDString((String)"\u8bc4\u6807\u5ba1\u6838\u4e2d", (String)"BidPublishListUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
        }
        if ("delete".equals(operate.getOperateKey())) {
            for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                pk = listSelectedRowCollection.get(i).getPrimaryKeyValue();
                bidPublish = BusinessDataServiceHelper.loadSingle((Object)pk, (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"bidproject.billno,bidproject.name,source,billstatus");
                String source = bidPublish.getString("source");
                if (StringUtils.isEmpty((CharSequence)"source") || !source.equals("resupplierInvitation")) continue;
                billStatus = bidPublish.getString("billstatus");
                if (!billStatus.equals("A")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u6570\u636e\u3002", (String)"BidPublishListUI_89", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidPublish.get("bidproject.billno")));
                } else {
                    bidPublish.set("billstatus", (Object)"D");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidPublish});
                    this.getView().invokeOperation("refresh");
                }
                args.setCancel(true);
                return;
            }
        }
    }

    private void addLog(String operation, String tip) {
        LogServiceHelper logServiceHelper = new LogServiceHelper();
        AppLogInfo appLogInfo = OperationLogUtil.buildLogInfo(operation, tip, this.getAppId(), this.getView().getEntityId());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    public void showTip(String tips) {
        String tip = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u518d\u6b21\u53d1\u6807\u3002\r\n %1$s", (String)"BidPublishListUI_90", (String)"scm-bid-formplugin", (Object[])new Object[0]), tips);
        this.getView().showConfirm(tip, MessageBoxOptions.OKCancel);
    }

    public boolean canRePublish(Long bidProjectId) {
        QFilter filter = new QFilter("bidproject", "=", (Object)bidProjectId);
        QFilter bidDocustatusFilter = new QFilter("billstatus", "not in", (Object)new String[]{BillStatusEnum.ADJUSTING.getVal(), BillStatusEnum.INVALID.getVal(), BillStatusEnum.INVALIDXX.getVal()});
        DynamicObject[] bidOpenCol = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billno,bidproject,billstatus,createtime", (QFilter[])new QFilter[]{filter}, (String)"createtime asc");
        DynamicObject[] bidDocumentEditCol = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"biddocument_edit", ((Object)((Object)this)).getClass()), (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{filter, bidDocustatusFilter});
        String editStatus = BillStatusEnum.AUDITED.getVal();
        Object billno = null;
        if (bidDocumentEditCol != null && bidDocumentEditCol.length > 0) {
            editStatus = bidDocumentEditCol[0].getString("billstatus");
            billno = bidDocumentEditCol[0].get("bidproject.billno");
        }
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        DynamicObject[] biddecisionCol = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"decision", ((Object)((Object)this)).getClass()), (String)"billno,bidproject,billstatus", (QFilter[])new QFilter[]{filter, statusFilter});
        if (biddecisionCol.length != 0) {
            String billStatus = biddecisionCol[0].getString("billStatus");
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus)) {
                if (StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)editStatus)) {
                    return true;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u8bf7\u5ba1\u6279\u540e\u518d\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                return false;
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u62db\u6807\u7acb\u9879\u5df2\u8fdb\u5165\u5b9a\u6807\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_69", (String)"scm-bid-formplugin", (Object[])new Object[0]), biddecisionCol[0].get("bidproject.billno")));
            return false;
        }
        if (bidOpenCol.length != 0) {
            String billStatus = bidOpenCol[0].getString("billStatus");
            if (StringUtils.equals((CharSequence)BillStatusEnum.DISBEGIN.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.SUBMIT.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.AUDITING.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)billStatus)) {
                if (StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)editStatus)) {
                    return true;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u672a\u5ba1\u6279\u7684\u6807\u4e66\u7f16\u5236\uff0c\u8bf7\u5ba1\u6279\u540e\u518d\u518d\u6b21\u53d1\u6807\u3002", (String)"BidPublishListUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                return false;
            }
            if (StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)billStatus) || StringUtils.equals((CharSequence)"P", (CharSequence)billStatus)) {
                // empty if block
            }
        }
        return true;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"bidproject_currentstep", (CharSequence)args.getHyperLinkClickEvent().getFieldName()) || StringUtils.equals((CharSequence)"bidstep", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            Object bidProjectId = BusinessDataServiceHelper.loadSingle((Object)id, (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass())).getDynamicObject("bidproject").getPkValue();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"projectprocess", ((Object)((Object)this)).getClass()));
            showParameter.setCustomParam("bidProjectId", bidProjectId);
            showParameter.setCustomParam("showFormType", (Object)"fb");
            showParameter.setCustomParam("nowId", id);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Boolean isCopy = (Boolean)e.getParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            e.getParameter().setCustomParam("sourcePublishId", (Object)Long.parseLong(id.toString()));
        }
    }

    public void afterBindData(EventObject e) {
        boolean enable;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        if (StringUtils.isNotEmpty((CharSequence)viewhistory)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblbidpublish", "tbldel", "tblsubmit", "tblcheck", "tblrepublishbid", "viewhistory", "baritemap1", "bar_more", "filtercontainer"});
        }
        if (!(enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrepublishbid"});
        }
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "projectprocess": {
                return FormTypeConstants.getFormConstant((String)"projectprocess", ((Object)((Object)this)).getClass());
            }
        }
        return null;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                String projectName = row.getString("bidproject.name");
                DynamicObject bidProject = row.getDynamicObject("bidproject");
                String currentStep = bidProject.getString("currentstep");
                String billStatus = row.getString("billstatus");
                boolean isNewBill = row.getBoolean("isnewbill");
                if (!isNewBill && StringUtils.isNotEmpty((CharSequence)projectName) && !BillStatusEnum.INVALID.getVal().equals(billStatus) && !projectName.endsWith(ResManager.loadKDString((String)"\uff08\u4fee\u8ba2\u4e2d\uff09", (String)"BidPublishListUI_28", (String)"scm-bid-formplugin", (Object[])new Object[0]))) {
                    String format = String.format(ResManager.loadKDString((String)"%1$s\uff08\u4fee\u8ba2\u4e2d\uff09", (String)"BidPublishListUI_72", (String)"scm-bid-formplugin", (Object[])new Object[0]), projectName);
                    row.set("projectajdustname", (Object)format);
                    continue;
                }
                row.set("projectajdustname", (Object)projectName);
                if (billStatus.equals("A") || billStatus.equals("B") || billStatus.equals("I")) {
                    row.set("bidstep", (Object)",BidPublish,");
                    continue;
                }
                row.set("bidstep", (Object)currentStep);
            }
            return rows;
        }
    }
}

