/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.RichTextEditorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.bid.common.constant.bill.BidTemplateConstant;
import kd.scm.bid.common.enums.BidProjectEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.formplugin.bill.helper.TemplateManageHelper;
import kd.scm.bid.formplugin.bill.util.DateUtils;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;

public class NegotiateInviteEditUI
extends AbstractBillPlugIn
implements UploadListener,
BeforeF7SelectListener {
    private static String ATTACHE_TAG = "atta";
    private static String SUPPLIERTAB = "suppliertab";
    private static String RICHTEXT_TAG = "negotiaterich";

    public void beforeBindData(EventObject e) {
        OperationStatus formStatus;
        super.beforeBindData(e);
        String status = this.getView().getModel().getDataEntity(true).getString("status");
        if (StringUtils.equals((CharSequence)status, (CharSequence)"X")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete", "bar_save", "bar_submit", "unsubmit", "bar_submitandaudit", "bar_audit", "bar_unaudit", "publish", "unpublish"});
        }
        if (OperationStatus.ADDNEW.equals((Object)(formStatus = this.getView().getFormShowParameter().getStatus()))) {
            this.setValue();
        }
    }

    public void setValue() {
        String autoNumber;
        Object bustalkidobj = this.getView().getFormShowParameter().getCustomParam("bustalkid");
        String bustalkid = String.valueOf(bustalkidobj);
        if (bustalkid.isEmpty() || "null".equals(bustalkid)) {
            this.getView().close();
            return;
        }
        if (StringUtils.isBlank((CharSequence)bustalkid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5f00\u9014\u5f84\u5f02\u5e38,\u7f3a\u5c11\u53c2\u6570\u3002", (String)"NegotiateInviteEditUI_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        String entitytypeid = this.getView().getFormShowParameter().getCustomParam("entitytypeid").toString();
        entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
        Long busPkvalue = Long.parseLong(bustalkid);
        String appId = this.getAppId();
        DynamicObject bustalk_f7 = BusinessDataServiceHelper.loadSingle((Object)busPkvalue, (String)(appId + "_bustalk_f7"));
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)busPkvalue, (String)(appId + "_bustalk"));
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        dataEntity.set("publicman", (Object)bos_user);
        dataEntity.set("offerstoptime", bustalk.get("offerstoptime"));
        dataEntity.set("bidproject", bustalk.get("bidproject"));
        dataEntity.set("org", (Object)bustalk.getDynamicObject("org"));
        dataEntity.set("bustalkid", (Object)bustalk_f7);
        dataEntity.set("entitytypeid", (Object)(appId + "_negotiate_invite"));
        String number = dataEntity.getString("number");
        if (StringUtils.isBlank((CharSequence)number) && (autoNumber = CodeRuleServiceHelper.getNumber((String)(appId + "_negotiate_invite"), (DynamicObject)dataEntity, null)) != null) {
            dataEntity.set("number", (Object)autoNumber);
        }
        DynamicObjectCollection newDidsections = dataEntity.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            DynamicObject newBidSectionRow = newDidsections.addNew();
            newBidSectionRow.set("sectionname", (Object)bidsection.getString("sectionname"));
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            Iterator supplierIter = querySupplierEntity.iterator();
            DynamicObjectCollection supplierentry = newBidSectionRow.getDynamicObjectCollection("supplierentry");
            while (supplierIter.hasNext()) {
                DynamicObject entity = (DynamicObject)supplierIter.next();
                DynamicObject supplier = entity.getDynamicObject("supplier");
                DynamicObject addNew = supplierentry.addNew();
                addNew.set("supplier", (Object)supplier);
            }
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.visiableAnn();
    }

    private void visiableAnn() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String billstatus = this.getView().getModel().getDataEntity(true).getString("status");
        boolean visiFlag = StringUtils.isBlank((CharSequence)billstatus) || billstatus.equals("A");
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidRow : bidsection) {
            String sectionname = bidRow.getString("sectionname");
            DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject supplier = row.getDynamicObject("supplier");
                String content = row.getString("content");
                String contenTag = row.getString("content_tag");
                if (!StringUtils.isBlank((CharSequence)contenTag)) {
                    content = contenTag;
                }
                String richContentKey = this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString());
                if (this.getView().getControl(richContentKey) != null) {
                    RichTextEditor richContent = (RichTextEditor)this.getView().getControl(richContentKey);
                    richContent.setText(content);
                    this.getView().updateView(richContentKey);
                }
                String attaKey = this.appendStr(ATTACHE_TAG, supplier.getPkValue().toString());
                AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(attaKey);
                panel.setKey(attaKey);
                panel.setDefaultCollapse(false);
                this.getView().updateView(attaKey);
                if (visiFlag) continue;
                this.visiablePanel(attaKey, visiFlag);
            }
        }
        if (!visiFlag) {
            this.visiablePanel("attachmentpanelap", visiFlag);
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    public void visiablePanel(String key, boolean flag) {
        AttachmentPanel panel = (AttachmentPanel)this.getControl(key);
        List attachmentData = panel.getAttachmentData();
        if (attachmentData == null || attachmentData.isEmpty()) {
            return;
        }
        char visiable = '0';
        if (flag) {
            visiable = '1';
        }
        for (Map attachmentMap : attachmentData) {
            StringBuilder builder = new StringBuilder();
            char visiablePreview = visiable;
            char visiableDownload = '1';
            char visiableRename = visiable;
            char visiableDelete = visiable;
            builder.append(visiablePreview).append(visiableDownload).append(visiableRename).append(visiableDelete);
            builder.append('0');
            attachmentMap.put("visible", builder.toString());
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(key, "data", (Object)attachmentData);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        Object bustalkid;
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        if (formShowParameter == null) {
            formShowParameter = this.getView().getFormShowParameter();
        }
        if ((bustalkid = formShowParameter.getCustomParam("bustalkid")) == null) {
            Object pkId = ((BillShowParameter)formShowParameter).getPkId();
            DynamicObject negotiate = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(formShowParameter.getServiceAppId() + "_negotiate_invite"));
            bustalkid = negotiate.getDynamicObject("bustalkid").getPkValue();
        }
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(bustalkid.toString()), (String)(formShowParameter.getServiceAppId() + "_bustalk"));
        HashMap<String, DynamicObject> bidSupplier = new HashMap<String, DynamicObject>();
        DynamicObjectCollection newDidsections = bustalk.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : newDidsections) {
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject entity : querySupplierEntity) {
                DynamicObject supplier = entity.getDynamicObject("supplier");
                if (bidSupplier.containsKey(supplier.getPkValue().toString())) continue;
                bidSupplier.put(supplier.getPkValue().toString(), supplier);
            }
        }
        Map<String, Object> mapHead = this.getMapHead(bidSupplier);
        e.getItems().add(mapHead);
    }

    private Map<String, Object> getMapHead(Map<String, DynamicObject> bidSupplier) {
        TabAp tab = this.createDynamicTabAp(bidSupplier);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", SUPPLIERTAB);
        mapHead.put("items", tab.createControl().get("items"));
        return mapHead;
    }

    private TabAp createDynamicTabAp(Map<String, DynamicObject> bidSupplier) {
        TabAp tab = new TabAp();
        tab.setKey(SUPPLIERTAB);
        Set<Map.Entry<String, DynamicObject>> entries = bidSupplier.entrySet();
        for (Map.Entry<String, DynamicObject> entry : entries) {
            String key = entry.getKey();
            DynamicObject value = entry.getValue();
            TabPageAp tpa = this.createTabPageAp(value);
            tab.getItems().add(tpa);
        }
        return tab;
    }

    private TabPageAp createTabPageAp(DynamicObject supplier) {
        String supplierId = supplier.getString("id");
        String supplierName = supplier.getString("name");
        TabPageAp tpa = new TabPageAp();
        tpa.setKey(supplierId);
        tpa.setId(supplierId);
        tpa.setName(new LocaleString(supplierName));
        RichTextEditorAp richTextAp = new RichTextEditorAp();
        String richKey = RICHTEXT_TAG + supplierId;
        richTextAp.setId(richKey);
        richTextAp.setKey(richKey);
        richTextAp.setName(new LocaleString(supplierName));
        richTextAp.setLock("view");
        richTextAp.setHeight(new LocaleString("400px"));
        richTextAp.setAutoSave(true);
        tpa.getItems().add(richTextAp);
        AttachmentPanelAp attaAp = new AttachmentPanelAp();
        String attaKey = ATTACHE_TAG + supplierId;
        attaAp.setId(attaKey);
        attaAp.setKey(attaKey);
        attaAp.setLock("view");
        attaAp.setCollapsible(true);
        attaAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4e13\u5c5e\u9644\u4ef6", (String)"NegotiateInviteEditUI_2", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("50px");
        style.setMargin(margin);
        attaAp.setStyle(style);
        Tips ctlTips = new Tips();
        ctlTips.setContent(new LocaleString(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u540e\u4f1a\u663e\u793a\u5230\u9009\u4e2d\u4f9b\u5e94\u5546\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u4e2d\u3002", (String)"NegotiateInviteEditUI_20", (String)"scm-bid-formplugin", (Object[])new Object[0])));
        ctlTips.setTriggerType("hover");
        ctlTips.setType("text");
        ctlTips.setShowIcon(true);
        attaAp.setCtlTips(ctlTips);
        tpa.getItems().add(attaAp);
        return tpa;
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith(RICHTEXT_TAG)) {
            RichTextEditor rechText = new RichTextEditor();
            String richKey = e.getKey();
            rechText.setKey(richKey);
            rechText.setView(this.getView());
            e.setControl((Control)rechText);
        } else if (e.getKey().startsWith(ATTACHE_TAG)) {
            AttachmentPanel panel = new AttachmentPanel();
            String key = e.getKey();
            panel.setKey(key);
            panel.setDefaultCollapse(false);
            panel.setView(this.getView());
            e.setControl((Control)panel);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        StringBuilder buffer;
        String templateContent;
        Object newValue;
        ChangeData data;
        ChangeData[] datas;
        super.propertyChanged(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            return;
        }
        IDataEntityProperty pro = e.getProperty();
        String filedName = pro.getName();
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"negotiatetemplate")) {
            datas = e.getChangeSet();
            data = datas[0];
            newValue = data.getNewValue();
            if (newValue == null) {
                return;
            }
            DynamicObject template = (DynamicObject)newValue;
            templateContent = template.getString("content");
            buffer = new StringBuilder();
            buffer.append(templateContent);
            this.getNewContent(buffer);
        }
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"name")) {
            datas = e.getChangeSet();
            data = datas[0];
            newValue = data.getNewValue();
            if (newValue == null) {
                return;
            }
            DynamicObject negotiatetemplate = (DynamicObject)this.getModel().getValue("negotiatetemplate");
            if (negotiatetemplate == null) {
                negotiatetemplate = this.getDefaultTemplate();
                if (negotiatetemplate == null) {
                    return;
                }
                this.getModel().setValue("negotiatetemplate", (Object)negotiatetemplate);
                this.getView().updateView("negotiatetemplate");
            } else {
                templateContent = negotiatetemplate.getString("content");
                buffer = new StringBuilder();
                buffer.append(templateContent);
                this.getNewContent(buffer);
            }
        }
    }

    private DynamicObject getDefaultTemplate() {
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        if (bidProject != null) {
            Set orgIds = OrgUnitHelper.getParentOrgUnitSet((Long)bidProject.getLong("org.id"));
            QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
            String appId = this.getAppId();
            DynamicObject[] load = BusinessDataServiceHelper.load((String)(appId + "_templatetype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd", (String)"NegotiateInviteEditUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
            if (load.length > 0) {
                QFilter typeFilter = new QFilter("type", "=", load[0].getPkValue());
                QFilter appFilter = new QFilter("entitytypeid", "=", (Object)(appId + "_templatemanage"));
                QFilter defaultFilter = new QFilter("default", "=", (Object)"1");
                defaultFilter.and(new QFilter("enable", "=", (Object)"1"));
                return BusinessDataServiceHelper.loadSingle((String)(appId + "_templatemanage"), (String)"id,content", (QFilter[])new QFilter[]{qFilter, typeFilter, appFilter, defaultFilter});
            }
        }
        return null;
    }

    private void getNewContent(StringBuilder content) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject bidprojectF7 = dataEntity.getDynamicObject("bidproject");
        DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((Object)bidprojectF7.getPkValue(), (String)(this.getAppId() + "_project"));
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidRow : bidsection) {
            String sectionname = bidRow.getString("sectionname");
            DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject supplier = row.getDynamicObject("supplier");
                this.updateContent(bidproject, supplier, content, row);
            }
        }
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierentry");
    }

    private void updateContent(DynamicObject bidProject, DynamicObject supplier, StringBuilder content, DynamicObject row) {
        String contentStr = "";
        String richContentKey = this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString());
        if (!StringUtils.isEmpty((CharSequence)content)) {
            contentStr = this.replaceContent(bidProject, supplier, new String(content));
            if (this.getView().getControl(richContentKey) != null) {
                ((RichTextEditor)this.getView().getControl(richContentKey)).setText(contentStr);
                this.getView().updateView(richContentKey);
            }
        }
        if (contentStr.length() > 200) {
            row.set("content", (Object)contentStr.substring(0, 200));
            row.set("content_tag", (Object)contentStr);
        } else {
            row.set("content", (Object)contentStr);
        }
    }

    private String replaceContent(DynamicObject bidProject, DynamicObject supplier, String content) {
        String supplierName = supplier.getString("name");
        String projectName = bidProject.getString("name");
        String title = this.getModel().getDataEntity().getString("name");
        String orgName = bidProject.getDynamicObject("org").getString("name");
        Date offerstoptime = this.getModel().getDataEntity().getDate("offerstoptime");
        String dataStr = DateUtils.date2StringSimpleOrDetail((Date)offerstoptime, (Boolean)Boolean.FALSE);
        DynamicObject contact = bidProject.getDynamicObject("contact");
        String contactName = contact == null ? "" : contact.getString("name");
        String contacttel = bidProject.getString("contacttel");
        String email = bidProject.getString("proemail");
        String address = bidProject.getString("proaddress");
        String[] supplierAddressAndDate = this.getSupplierAddressAndDate(supplier.getPkValue().toString(), this.getSupplierCount(supplier.getPkValue().toString()));
        String sAddress = supplierAddressAndDate[0];
        String sDate = supplierAddressAndDate[1];
        String[] negotiateValues = new BidTemplateConstant().getBidNegotiateValues();
        String result = content.replace(TemplateManageHelper.getSpecialValue(new BidTemplateConstant().getNegotiateSupplierName()), supplierName).replace(TemplateManageHelper.getSpecialValue(new BidTemplateConstant().getProjectName()), projectName).replace(TemplateManageHelper.getSpecialValue(negotiateValues[0]), supplierName).replace(TemplateManageHelper.getSpecialValue(negotiateValues[1]), projectName).replace(TemplateManageHelper.getSpecialValue(negotiateValues[2]), title == null ? "" : title).replace(TemplateManageHelper.getSpecialValue(negotiateValues[3]), orgName).replace(TemplateManageHelper.getSpecialValue(negotiateValues[4]), sAddress).replace(TemplateManageHelper.getSpecialValue(negotiateValues[5]), sDate).replace(TemplateManageHelper.getSpecialValue(negotiateValues[6]), dataStr).replace(TemplateManageHelper.getSpecialValue(negotiateValues[7]), contactName).replace(TemplateManageHelper.getSpecialValue(negotiateValues[8]), contacttel).replace(TemplateManageHelper.getSpecialValue(negotiateValues[9]), email).replace(TemplateManageHelper.getSpecialValue(negotiateValues[10]), address);
        result = this.replaceBidProjectField(result, bidProject, null);
        return result;
    }

    private String replaceBidProjectField(String annContent, DynamicObject project, Date enrolldeadlineDate) {
        String fax;
        String purentryProjectStr;
        if (StringUtils.isEmpty((CharSequence)annContent) || project == null) {
            return annContent;
        }
        String contentStr = "";
        StringBuilder purentryProjectStrSb = new StringBuilder();
        if ("rebm".equals(this.getAppId())) {
            project = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"rebm_project");
        }
        int bidType = project.getInt("bidtype");
        DynamicObjectCollection sections = (DynamicObjectCollection)project.get("bidsection");
        if (sections != null && sections.size() != 0) {
            for (int m = 0; m < sections.size(); ++m) {
                if (sections.get(m) == null) continue;
                DynamicObject section = (DynamicObject)sections.get(m);
                String sectionName = "";
                if (project.getBoolean("enablemultisection")) {
                    sectionName = section.getLocaleString("sectionname").toString() + "\uff1a";
                }
                DynamicObjectCollection content = (DynamicObjectCollection)section.get("projectentry");
                String contentStrEntity = "";
                if (content == null) continue;
                for (int i = 0; i < content.size(); ++i) {
                    if (bidType == 1) {
                        DynamicObject material = ((DynamicObject)content.get(i)).getDynamicObject("materialid");
                        contentStrEntity = !contentStrEntity.equals("") ? contentStrEntity + "\uff0c" + material.getString("name") : material.getString("name");
                    } else if (bidType == 2) {
                        DynamicObject resourceItem = ((DynamicObject)content.get(i)).getDynamicObject("resourceitem");
                        contentStrEntity = !contentStrEntity.equals("") ? contentStrEntity + "\uff0c" + resourceItem.getString("name") : resourceItem.getString("name");
                    } else {
                        contentStrEntity = !contentStrEntity.equals("") ? contentStrEntity + "\uff0c" + ((DynamicObject)content.get(i)).get("purentrycontent") : ((DynamicObject)content.get(i)).get("purentrycontent").toString();
                    }
                    DynamicObject projectEntity = (DynamicObject)((DynamicObject)content.get(i)).get("purentryproject");
                    String projectStrEntity = "";
                    if (projectEntity != null) {
                        projectStrEntity = projectEntity.getString("name") + "\u3001";
                    }
                    purentryProjectStrSb.append(projectStrEntity);
                }
                contentStr = !"".equals(contentStr) ? contentStr + "\n" + sectionName + contentStrEntity : sectionName + contentStrEntity;
            }
        }
        if (!"".equals(purentryProjectStr = purentryProjectStrSb.toString())) {
            purentryProjectStr = purentryProjectStr.substring(0, purentryProjectStr.length() - 1);
        }
        String purtypeStr = " ";
        DynamicObject purtype = project.getDynamicObject("purtype");
        if (purtype != null) {
            purtypeStr = purtype.getString("name");
        }
        String bidmode = project.getDynamicObject("bidmode").getString("name");
        String bidOrg = project.getDynamicObject("org").getString("name");
        String qualificationrequired = project.getString("qualificationrequired") == null ? "" : project.getString("qualificationrequired");
        String purdescription = project.getString("purdescription") == null ? "" : project.getString("purdescription");
        DynamicObject contact = project.getDynamicObject("contact");
        String contactName = contact.getString("name");
        String contacttel = project.getString("contacttel") == null ? "" : project.getString("contacttel");
        String email = project.getString("proemail") == null ? "" : project.getString("proemail");
        String address = project.getString("proaddress") == null ? "" : project.getString("proaddress");
        String string = fax = project.getString("profax") == null ? "" : project.getString("profax");
        if (enrolldeadlineDate == null) {
            enrolldeadlineDate = project.getDate("enrolldeadline");
        }
        String enrolldeadline = this.setDateStyle(enrolldeadlineDate, Boolean.TRUE, "enrolldeadline");
        String supplierinvienddate = this.setDateStyle(project.getDate("supplierinvienddate"), Boolean.FALSE, "supplierinvienddate");
        String technicaldocenddate = this.setDateStyle(project.getDate("technicaldocenddate"), Boolean.FALSE, "technicaldocenddate");
        String commercialdocenddate = this.setDateStyle(project.getDate("commercialdocenddate"), Boolean.FALSE, "commercialdocenddate");
        String bidpublishdate = this.setDateStyle(project.getDate("bidpublishdate"), Boolean.FALSE, "bidpublishdate");
        String answerquestiontime = this.setDateStyle(project.getDate("answerquestiontime"), Boolean.TRUE, "answerquestiontime");
        String answercomplete = this.setDateStyle(project.getDate("answercomplete"), Boolean.FALSE, "answercomplete");
        String bidopendeadline = this.setDateStyle(project.getDate("bidopendeadline"), Boolean.TRUE, "bidopendeadline");
        String bidevaluationdate = this.setDateStyle(project.getDate("bidevaluationdate"), Boolean.FALSE, "bidevaluationdate");
        String biddecisiondate = this.setDateStyle(project.getDate("biddecisiondate"), Boolean.FALSE, "biddecisiondate");
        String approachdate = this.setDateStyle(project.getDate("approachdate"), Boolean.FALSE, "approachdate");
        annContent = annContent.replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.PURTYPE_NAME.getValue()), purtypeStr).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.PURENTRYPROJECT.getValue()), purentryProjectStr).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.CONTENT.getValue()), contentStr).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.CONTACT.getValue()), contactName).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.CONTACTTEL.getValue()), contacttel).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.EMAIL.getValue()), email).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ADDRESS.getValue()), address).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.FAX.getValue()), fax).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ENDTIME.getValue()), enrolldeadline).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDMODE.getValue()), bidmode).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ORG.getValue()), bidOrg).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.QUALIFICATIONREQUIRED.getValue()), qualificationrequired).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.PURDESCRIPTION.getValue()), purdescription).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.SUPPLIERINVIENDDATE.getValue()), supplierinvienddate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.TECHNICALDOCENDDTAE.getValue()), technicaldocenddate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.COMMERCIALDOCENDDATE.getValue()), commercialdocenddate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDPUBLISHDATE.getValue()), bidpublishdate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ANSWERQUESTIONTIME.getValue()), answerquestiontime).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.ANSWERCOMPLETE.getValue()), answercomplete).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDOPENDEADLINE.getValue()), bidopendeadline).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDEVALUATIONDATE.getValue()), bidevaluationdate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.BIDDECISIONDATE.getValue()), biddecisiondate).replace(TemplateManageHelper.getSpecialValue(BidProjectEnum.APPROACHDATE.getValue()), approachdate);
        return annContent;
    }

    private String setDateStyle(Date date, Boolean isLongDate, String className) {
        String dateFromat = "";
        dateFromat = date != null ? (isLongDate.booleanValue() ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date) : new SimpleDateFormat("yyyy-MM-dd").format(date)) : "<span class=\"" + className + "\"></span>";
        return dateFromat;
    }

    private int getSupplierCount(String supplierId) {
        int i = 0;
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidRow : bidsection) {
            DynamicObjectCollection supplierentry = bidRow.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject supplier = row.getDynamicObject("supplier");
                if (!supplierId.equals(supplier.getPkValue().toString())) continue;
                ++i;
            }
        }
        return i;
    }

    private String[] getSupplierAddressAndDate(String supplierId, int supplierCount) {
        String[] reslult = new String[2];
        StringBuilder address = new StringBuilder();
        StringBuilder date = new StringBuilder();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String entitytypeid = dataEntity.getString("entitytypeid");
        entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
        DynamicObject bustalk = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getDynamicObject("bustalkid").getPkValue(), (String)(this.getAppId() + "_bustalk"));
        DynamicObjectCollection bidsections = bustalk.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection : bidsections) {
            String sectionname = bidsection.getString("sectionname");
            DynamicObjectCollection querySupplierEntity = bidsection.getDynamicObjectCollection("supplierentry");
            for (DynamicObject entity : querySupplierEntity) {
                DynamicObject supplier = entity.getDynamicObject("supplier");
                if (!supplierId.equals(supplier.getPkValue().toString())) continue;
                if (supplierCount > 1) {
                    address.append(sectionname);
                    address.append(':');
                    address.append(entity.getString("bus_address"));
                    address.append("  ");
                    date.append(sectionname);
                    date.append(':');
                    date.append(DateUtils.date2StringSimpleOrDetail((Date)entity.getDate("judge_date"), (Boolean)Boolean.TRUE));
                    date.append("  ");
                    continue;
                }
                address.append(entity.getString("bus_address"));
                date.append(DateUtils.date2StringSimpleOrDetail((Date)entity.getDate("judge_date"), (Boolean)Boolean.TRUE));
            }
        }
        reslult[0] = address.toString();
        reslult[1] = date.toString();
        return reslult;
    }

    protected boolean getWorkflowProcess(String formId) {
        QFilter designProFilter = new QFilter("entrabill", "=", (Object)formId).and("publish", "=", (Object)Boolean.TRUE).and("discard", "=", (Object)Boolean.FALSE);
        ArrayList<String> processNumList = new ArrayList<String>(10);
        DynamicObject[] designObjs = BusinessDataServiceHelper.load((String)"wf_model", (String)"key,name,description,orgunitid,entrabill,categoryid,version,operation,type,creatorid,modifierid,createdate,parentprocid,modifydate,entrabillid,pngid,deploymentid,bpmnxmlid,graphid,publish,discard,applicationid,businessid", (QFilter[])designProFilter.toArray());
        if (null != designObjs && designObjs.length > 0) {
            for (DynamicObject designObj : designObjs) {
                processNumList.add(String.valueOf(designObj.get("key")));
            }
            QFilter proManagementFilter = new QFilter("entrabill", "=", (Object)formId).and("enable", "=", (Object)"enable").and("key", "in", processNumList);
            Map proMagObjMap = BusinessDataServiceHelper.loadFromCache((String)"wf_processdefinition", (String)"key,category,graphname,enable,engineversion,entrabill,entrabillid,orgunitid,publishname,creatorid,createdate,modifierid,modifydate,name,description,categoryname,operation,version,graphicaldefined,type,versiondesc,businessid,pname,entrabillname,startcondition,orgunitname,pdescription,deploymentid,resourceid,parentprocid,modelid,categoryid,versionstate,template,applicationid", (QFilter[])proManagementFilter.toArray());
            return null != proMagObjMap && !proMagObjMap.isEmpty();
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasPermission;
        Long mainOrgId;
        DynamicObject org;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String appId = this.getAppId();
        if (StringUtils.equals((CharSequence)"submitandaudit", (CharSequence)key)) {
            org = dataEntity.getDynamicObject("org");
            mainOrgId = (Long)org.getPkValue();
            hasPermission = PermissionUtils.checkPermission("SWTP006", mainOrgId, appId, appId + "_negotiate_invite");
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u201d\u7684\u201c\u63d0\u4ea4\u5e76\u5ba1\u6838\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u63d0\u4ea4\u5e76\u5ba1\u6838\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NegotiateInviteEditUI_21", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean workflowProcess = this.getWorkflowProcess(this.getAppId() + "_negotiate_invite");
            if (workflowProcess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u542f\u7528\u5de5\u4f5c\u6d41\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u5e76\u5ba1\u6838\u3002", (String)"NegotiateInviteEditUI_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)"publish", (CharSequence)key) && !(hasPermission = PermissionUtils.checkPermission("SWTP004", mainOrgId = (Long)(org = dataEntity.getDynamicObject("org")).getPkValue(), appId, this.getAppId() + "_negotiate_invite"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u201d\u7684\u201c\u53d1\u5e03\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u53d1\u5e03\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NegotiateInviteEditUI_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"unpublish", (CharSequence)key) && !(hasPermission = PermissionUtils.checkPermission("SWTP005", mainOrgId = (Long)(org = dataEntity.getDynamicObject("org")).getPkValue(), appId, this.getAppId() + "_negotiate_invite"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u201d\u7684\u201c\u64a4\u9500\u53d1\u5e03\u201d\u529f\u80fd\u6743\u9650\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u8d4b\u4e88\u5f53\u524d\u7ec4\u7ec7\u7684\u64cd\u4f5c\u201c\u64a4\u9500\u53d1\u5e03\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NegotiateInviteEditUI_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save") || StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)"submitandaudit", (CharSequence)key)) {
            String name = dataEntity.getString("name");
            if (StringUtils.isBlank((CharSequence)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u6807\u9898\u3002", (String)"NegotiateInviteEditUI_24", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Date offerstoptime = dataEntity.getDate("offerstoptime");
            if (offerstoptime == null) {
                FieldTip qingjiaTip = new FieldTip(FieldTip.FieldTipType.Info, "offerstoptime", ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NegotiateInviteEditUI_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getView().showFieldTip(qingjiaTip);
                args.setCancel(true);
                return;
            }
            if (offerstoptime.getTime() - new Date().getTime() <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u670d\u52a1\u5668\u65f6\u95f4\u3002", (String)"NegotiateInviteEditUI_25", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean exists = QueryServiceHelper.exists((String)(appId + "_bidopen"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", dataEntity.getDynamicObject("bidproject").getPkValue()), new QFilter("billstatus", "in", (Object)new String[]{"D", "A", "B", "I", "C"})});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5f00\u6807\u7684\u5f00\u6807\u5355\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"NegotiateInviteEditUI_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
            for (DynamicObject bidNext : bidsections) {
                DynamicObjectCollection supplierentry = bidNext.getDynamicObjectCollection("supplierentry");
                for (DynamicObject suppluerRow : supplierentry) {
                    DynamicObject supplier = suppluerRow.getDynamicObject("supplier");
                    String richContentKey = this.appendStr(RICHTEXT_TAG, supplier.getPkValue().toString());
                    RichTextEditor richText = (RichTextEditor)this.getView().getControl(richContentKey);
                    if (richText == null) continue;
                    String contentStr = richText.getText();
                    if (StringUtils.isBlank((CharSequence)contentStr)) {
                        return;
                    }
                    if (contentStr.length() > 200) {
                        suppluerRow.set("content", (Object)contentStr.substring(0, 200));
                    } else {
                        suppluerRow.set("content", (Object)contentStr);
                    }
                    suppluerRow.set("content_tag", (Object)contentStr);
                }
                this.getView().updateView("bidsection");
                this.getView().updateView("supplierentry");
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)"submitandaudit", (CharSequence)key) || StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
            String status = dataEntity.getString("status");
            if (StringUtils.equals((CharSequence)"submitandaudit", (CharSequence)key) && StringUtils.equals((CharSequence)status, (CharSequence)"A")) {
                dataEntity.set("publishstatus", (Object)"0");
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"unaudit")) {
                String publishstatus = dataEntity.getString("publishstatus");
                if (!StringUtils.equals((CharSequence)status, (CharSequence)"C") || !StringUtils.equals((CharSequence)publishstatus, (CharSequence)"0")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5df2\u5ba1\u6838\u4e14\u672a\u53d1\u5e03\u7684\u6570\u636e\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"NegotiateInviteEditUI_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            this.getView().updateView("publishstatus");
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"publish") || StringUtils.equals((CharSequence)key, (CharSequence)"submit") || StringUtils.equals((CharSequence)key, (CharSequence)"audit") || StringUtils.equals((CharSequence)"submitandaudit", (CharSequence)key)) {
            DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
            DynamicObject[] loadInvitation = BusinessDataServiceHelper.load((String)(this.getAppId() + "_supplierinvitation"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject.getPkValue())), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"})});
            if (loadInvitation.length == 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u4e0d\u5141\u8bb8\u5904\u7406\u5546\u52a1\u8c08\u5224\u4e1a\u52a1\u3002", (String)"NegotiateInviteEditUI_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject[] loadBidpublish = BusinessDataServiceHelper.load((String)(this.getAppId() + "_bidpublish"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject.getPkValue())), new QFilter("billstatus", "not in", (Object)new String[]{"X"})});
            if (loadBidpublish.length == 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4fee\u8ba2\u4e2d\u72b6\u6001\u7684\u53d1\u6807\u5355\uff0c\u8bf7\u5148\u5904\u7406\u5b8c\u6210\u540e\uff0c\u518d\u8fdb\u884c\u540e\u7eed\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"NegotiateInviteEditUI_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.visiableAnn();
        String key = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String status = dataEntity.getString("status");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mdelbasedata = (BasedataEdit)this.getView().getControl("negotiatetemplate");
        mdelbasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection bidsections = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidNext : bidsections) {
            DynamicObjectCollection supplierentry = bidNext.getDynamicObjectCollection("supplierentry");
            for (DynamicObject suppluerRow : supplierentry) {
                DynamicObject supplier = suppluerRow.getDynamicObject("supplier");
                if (supplier == null) continue;
                String attaKey = this.appendStr(ATTACHE_TAG, supplier.getPkValue().toString());
                AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(attaKey);
                if (panel == null) continue;
                panel.addUploadListener((UploadListener)this);
            }
        }
        AttachmentPanel atta = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        atta.addUploadListener((UploadListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String appId = this.getAppId();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"negotiatetemplate")) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject tempBidProject = (DynamicObject)this.getModel().getValue("bidproject");
            if (tempBidProject != null) {
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)tempBidProject.getPkValue(), (String)(appId + "_project"));
                Object orgId = bidProject.getDynamicObject("org").getPkValue();
                Set orgIds = OrgUnitHelper.getParentOrgUnitSet((Long)Long.parseLong(orgId.toString()));
                QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
                String entitytypeid = dataEntity.getString("entitytypeid");
                entitytypeid = StringUtils.isBlank((CharSequence)entitytypeid) ? "bid" : entitytypeid.split("_")[0];
                DynamicObject[] load = BusinessDataServiceHelper.load((String)(appId + "_templatetype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd", (String)"NegotiateInviteEditUI_14", (String)"scm-bid-formplugin", (Object[])new Object[0]))});
                if (load.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u672a\u6dfb\u52a0\u51fd\u4ef6\u6a21\u677f\u7c7b\u522b\u201c\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\u201d\uff0c\u8bf7\u5148\u6dfb\u52a0\u8be5\u6a21\u677f\u7c7b\u522b\u3002", (String)"NegotiateInviteEditUI_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter typeFilter = new QFilter("type", "=", load[0].getPkValue());
                QFilter appFilter = new QFilter("entitytypeid", "=", (Object)(appId + "_templatemanage"));
                ArrayList<QFilter> lists = new ArrayList<QFilter>();
                lists.add(qFilter);
                lists.add(typeFilter);
                lists.add(appFilter);
                showParameter.setBillFormId(appId + "_templatemanage");
                showParameter.setCustomParam("modelType", (Object)"negotiate");
                showParameter.getListFilterParameter().setQFilters(lists);
            }
        }
    }

    public String appendStr(String ... strings) {
        StringBuilder buffer = new StringBuilder();
        for (String s : strings) {
            buffer.append(s);
        }
        return buffer.toString();
    }

    public String getAppId() {
        String appName = null;
        IFormView view = this.getView();
        appName = view == null ? ((Object)((Object)this)).getClass().getName().split("\\.")[2] : view.getFormShowParameter().getServiceAppId();
        return appName;
    }
}

