/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidEvalMethodEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.BidBillEdit;
import kd.scm.bid.formplugin.bill.OnlineBidEvalEdit;
import kd.scm.bid.formplugin.bill.util.InvalidBillUtil;
import kd.scm.bid.formplugin.bill.util.NumberUtil;
import kd.scm.bid.formplugin.bill.util.OnlineBidEvalScoreUtil;
import kd.scm.bid.formplugin.bill.util.OnlineBidEvalUtil;
import kd.scm.bid.formplugin.bill.util.QuestionClarifyUtil;
import kd.scm.bid.formplugin.bill.util.SupplierInvalUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class OnlineBidEvalEdit
extends BidBillEdit
implements RowClickEventListener,
ProgresssListener,
CellClickListener {
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String QUESTIONCLARIFYLIST = "questionclarifylist";
    protected QuestionClarifyUtil questionClarifyUtil = new QuestionClarifyUtil();
    protected OnlineBidEvalUtil onlineBidEvalUtil = new OnlineBidEvalUtil();
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    protected IBidSupplierFileService bidSupplierFileService = new BidSupplierFileServiceImpl();

    public String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    @Override
    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String status = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.INVALID.getVal())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unsubmit", "bar_save"});
        } else if (StringUtils.equals((CharSequence)status, (CharSequence)BillStatusEnum.AUDITING.getVal())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bidevaluationdate", "bar_submit", "bar_unsubmit", "bar_save"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String status = (String)this.getModel().getValue("billstatus");
        e.setCheckDataChange(false);
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
        sectionEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid sectionEnRollEntryGrid = (EntryGrid)this.getControl("bidsectionenroll");
        sectionEnRollEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid sectionEnCellEntryGrid = (EntryGrid)this.getView().getControl("bidsectionenroll");
        sectionEnCellEntryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("supplierentry");
        entryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsection");
        sectionGrid.addCellClickListener((CellClickListener)this);
        LargeTextEdit techevaladvice = (LargeTextEdit)this.getView().getControl("techevaladvice");
        techevaladvice.addClickListener((ClickListener)this);
        LargeTextEdit bsevaladvice = (LargeTextEdit)this.getView().getControl("bsevaladvice");
        bsevaladvice.addClickListener((ClickListener)this);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        LargeTextEdit largeTextEdit;
        super.propertyChanged(e);
        IDataEntityProperty obj = e.getProperty();
        ChangeData[] changeSet = e.getChangeSet();
        String newValue = changeSet[0].getNewValue() == null ? null : changeSet[0].getNewValue().toString();
        int rowIndex = changeSet[0].getRowIndex();
        if (obj != null && "techevaladvice_tag".equals(obj.getName())) {
            largeTextEdit = (LargeTextEdit)this.getView().getControl("techevaladvice");
            field = largeTextEdit.getFieldKey();
            this.getModel().setValue(field, (Object)newValue, rowIndex);
        }
        if (obj != null && "bsevaladvice_tag".equals(obj.getName())) {
            largeTextEdit = (LargeTextEdit)this.getView().getControl("bsevaladvice");
            field = largeTextEdit.getFieldKey();
            this.getModel().setValue(field, (Object)newValue, rowIndex);
        }
        if (obj != null && "techevaladvice".equals(obj.getName())) {
            Object techevaladvice_tag = this.getModel().getValue("techevaladvice_tag");
            this.getModel().setValue("techevaladvice", techevaladvice_tag, rowIndex);
        }
        if (obj != null && "bsevaladvice".equals(obj.getName())) {
            Object bsevaladvice_tag = this.getModel().getValue("bsevaladvice_tag");
            this.getModel().setValue("bsevaladvice", bsevaladvice_tag, rowIndex);
        }
        if (obj != null && "bd_taxrate".equals(obj.getName())) {
            int rowindex = changeSet[0].getRowIndex();
            Object newVal = changeSet[0].getNewValue();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                DynamicObject bd_taxrate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bd_taxrate.getBigDecimal("taxrate"), rowindex);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        FormShowParameter formShowParameter = ((IFormView)e.getSource()).getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        IDataModel dataModel = this.getModel();
        String billStatus = (String)dataModel.getValue("billstatus");
        if ((BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus)) && OperationStatus.EDIT.equals((Object)operationStatus)) {
            this.startSaveProgress();
        }
        if (BillStatusEnum.DISBEGIN.getVal().equals(billStatus) || BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            dataModel.setValue("bidevaluationdate", (Object)new Date());
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if (BidEvalMethodEnum.DX.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
        } else if (BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) || BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        }
        this.clickFristRows();
    }

    public void clickFristRows() {
        IDataModel dataModel = this.getModel();
        int sectionRowCount = dataModel.getEntryRowCount("bidsection");
        if (sectionRowCount > 0) {
            EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
            sectionEntryGrid.addRowClickListener((RowClickEventListener)this);
            EntryGrid sectionEnRollGrid = (EntryGrid)this.getControl("bidsectionenroll");
            sectionEnRollGrid.addRowClickListener((RowClickEventListener)this);
            sectionEntryGrid.selectRows(0, true);
            sectionEnRollGrid.selectRows(0, true);
            sectionEntryGrid.entryRowClick(Integer.valueOf(0));
            sectionEnRollGrid.entryRowClick(Integer.valueOf(0));
        }
    }

    public void startSaveProgress() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u3002", (String)"OnlineBidEvalEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        progressBar.start();
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "true");
        this.getPageCache().put(CACHEKEY_PROGRESS, "0");
    }

    public void stopSaveProgress() {
        this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "false");
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataModel dataModel = this.getModel();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("bidsection".equals(entryGrid.getKey())) {
            int rowIndex = evt.getRow();
            DynamicObject section = dataModel.getEntryRowEntity("bidsection", rowIndex);
            if (section != null) {
                Long sectionId = section.getLong("id");
                String cacheSectionId = this.getPageCache().get("sectionId");
                if (cacheSectionId != null) {
                    if (cacheSectionId.equals(sectionId.toString())) {
                        return;
                    }
                    String childPageId = this.getPageCache().get("childPageId");
                    IFormView childFormView = this.getView().getView(childPageId);
                    try {
                        DynamicObjectCollection onlineBidEvalScoreColl = childFormView.getModel().getEntryEntity("onlinebidevalscore");
                        this.getPageCache().put(cacheSectionId, SerializationUtils.toJsonString((Object)onlineBidEvalScoreColl));
                        this.getPageCache().put(cacheSectionId + "falseVisableField", childFormView.getPageCache().get("falseVisableField"));
                    }
                    catch (Exception e) {
                        return;
                    }
                    childFormView.close();
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setParentFormId(this.getModel().getDataEntity().getPkValue().toString());
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.InContainer);
                openStyle.setTargetKey("onlinebidevalscoreap");
                formShowParameter.setOpenStyle(openStyle);
                formShowParameter.setFormId(this.getOpenFormId("onlinebidevalscore"));
                formShowParameter.setCustomParam("onlinebidevalId", dataModel.getValue("id"));
                formShowParameter.setCustomParam("sectionId", (Object)sectionId);
                formShowParameter.setCustomParam("scoreMode", dataModel.getValue("scoremode"));
                formShowParameter.setCustomParam("evaltype", dataModel.getValue("evaltype"));
                formShowParameter.setCustomParam("sectionName", (Object)section.getString("sectionname"));
                formShowParameter.setCustomParam("currBidOpenId", this.getModel().getValue("bidopenid"));
                formShowParameter.setCustomParam("iscaneditautoscore", this.getModel().getValue("iscaneditautoscore"));
                formShowParameter.setCustomParam("isscorecalculatedauto", this.getModel().getValue("isscorecalculatedauto"));
                formShowParameter.setCustomParam("billstatus", this.getModel().getValue("billstatus"));
                String cacheOnlineBidEvalScoreCollStr = this.getPageCache().get(sectionId.toString());
                String falseVisableField = this.getPageCache().get(sectionId + "falseVisableField");
                if (StringUtils.isNotEmpty((CharSequence)cacheOnlineBidEvalScoreCollStr)) {
                    formShowParameter.setCustomParam("cacheData", (Object)cacheOnlineBidEvalScoreCollStr);
                    formShowParameter.setCustomParam("falseVisableField", (Object)falseVisableField);
                }
                String billstatus = (String)dataModel.getValue("billstatus");
                if (BillStatusEnum.DISBEGIN.getVal().equals(billstatus) || BillStatusEnum.SAVE.getVal().equals(billstatus)) {
                    if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                        formShowParameter.setStatus(OperationStatus.VIEW);
                    } else {
                        formShowParameter.setStatus(OperationStatus.EDIT);
                    }
                } else {
                    formShowParameter.setStatus(OperationStatus.VIEW);
                }
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bid_onlinebidevalscore"));
                this.getView().showForm(formShowParameter);
                String pageId = formShowParameter.getPageId();
                this.getPageCache().put("childPageId", pageId);
                this.getPageCache().put("sectionId", sectionId.toString());
            }
            EntryGrid sectionEntityGrid = (EntryGrid)this.getControl("bidsection");
            sectionEntityGrid.selectRows(rowIndex, true);
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("bidsectionenroll");
            entryEntityGrid.selectRows(rowIndex, true);
        } else if ("bidsectionenroll".equals(entryGrid.getKey())) {
            // empty if block
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean exsitInval;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        formOperate.getOption().setVariableValue("bos_checkFormDataVersion", "false");
        String operateKey = formOperate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
        String evalType = dataEntity.getString("evaltype");
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        String billno = bidProject.getString("billno");
        String fileName = String.format(ResManager.loadKDString((String)"%s\u5728\u7ebf\u8bc4\u6807\u9644\u4ef6", (String)"OnlineBidEvalEdit_16", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno);
        if ("alldownfile".equals(operateKey)) {
            this.getView().download(BidFileHelper.downAllFile((String)fileName, (Object)dataEntity.getPkValue(), (String)(serviceAppId + "_onlinebideval"), (String)serviceAppId, (String)evalType));
        }
        Object bidproject = this.getView().getModel().getDataEntity(true).getDynamicObject("bidproject").getPkValue();
        boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkEvalutionOp(operateKey, bidproject);
        if (exsitBackBid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"OnlineBidEvalEdit_8", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ((StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) && (exsitInval = SupplierInvalUtil.checkExsitUnAuditSuppleirInvalBill((DynamicObject)this.getModel().getDataEntity().getDynamicObject("bidproject"), (String)this.getAppId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u4f9b\u5e94\u5546\u6dd8\u6c70\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"OnlineBidEvalEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        switch (operateKey) {
            case "save": {
                if (!BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) && !BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) break;
                this.saveOnlineBidEvalScoreDataInCache();
                boolean scoreRight = this.checkScope();
                if (scoreRight) break;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u51fa\u8303\u56f4\u7684\u8bc4\u5206", (String)"OnlineBidEvalEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            case "submit": {
                FormOperate operate = (FormOperate)args.getSource();
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm) || !BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod) && !BidEvalMethodEnum.DL_DX.getCode().equals(evaluatedMethod)) break;
                this.saveOnlineBidEvalScoreDataInCache();
                boolean scoreRight = this.checkScope();
                if (!scoreRight) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u51fa\u8303\u56f4\u7684\u8bc4\u5206", (String)"OnlineBidEvalEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean canSubmit = this.validateOnlineBidEvalScoreData();
                if (canSubmit) break;
                args.setCancel(true);
                break;
            }
            case "dosript": {
                this.toListPriceComparison();
                break;
            }
        }
    }

    public boolean checkScope() {
        Map<Long, String> cacheOnlineBidEvalScoreData = this.getOnlineBidEvalScoreDataInCache();
        boolean scoreRight = this.onlineBidEvalUtil.checkScopeOnlineBidEvalScoreData(cacheOnlineBidEvalScoreData, this.getAppId());
        return scoreRight;
    }

    public void toListPriceComparison() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"listpricecomparison", ((Object)((Object)this)).getClass()));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        EntryGrid sectionEntryGrid = (EntryGrid)this.getView().getControl("bidsection");
        AbstractGrid.GridState sectionEntryState = sectionEntryGrid.getEntryState();
        int sectionEntryFocusRow = sectionEntryState.getFocusRow();
        Long opensrcsectionid = ((DynamicObject)this.getModel().getEntryEntity("bidsection").get(sectionEntryFocusRow)).getLong("opensrcsectionid");
        showParameter.setCustomParam("sectionid", (Object)opensrcsectionid);
        String sectionName = ((DynamicObject)this.getModel().getEntryEntity("bidsection").get(sectionEntryFocusRow)).getString("sectionname");
        showParameter.setCustomParam("sectionname", (Object)sectionName);
        DynamicObject onlineEval = this.getModel().getDataEntity(true);
        DynamicObject bidProject = onlineEval.getDynamicObject("bidproject");
        showParameter.setCustomParam("bidproject", bidProject.getPkValue());
        String evalType = onlineEval.getString("evaltype");
        showParameter.setCustomParam("isOnlineEval", (Object)Boolean.TRUE);
        boolean isDark = onlineEval.getBoolean("isdark");
        showParameter.setCustomParam("isDark", (Object)isDark);
        showParameter.setCustomParam("evaltype", (Object)evalType);
        this.getView().showForm(showParameter);
    }

    public void saveOnlineBidEvalScoreDataInCache() {
        Object billstatus;
        EntryGrid sectionEntryGrid = (EntryGrid)this.getControl("bidsection");
        sectionEntryGrid.getEntryState().getFocusRow();
        int[] selectRows = sectionEntryGrid.getSelectRows();
        if (selectRows.length > 0) {
            int selectRowIndex = selectRows[0];
            DynamicObject section = this.getModel().getEntryRowEntity("bidsection", selectRowIndex);
            Long sectionId = section.getLong("id");
            String childPageId = this.getPageCache().get("childPageId");
            IFormView childFormView = this.getView().getView(childPageId);
            if (childFormView.getModel().getEntryEntity("onlinebidevalscore") != null) {
                DynamicObjectCollection onlineBidEvalScoreColl = childFormView.getModel().getEntryEntity("onlinebidevalscore");
                this.getPageCache().put(sectionId.toString(), SerializationUtils.toJsonString((Object)onlineBidEvalScoreColl));
                this.getPageCache().put(sectionId.toString() + "falseVisableField", childFormView.getPageCache().get("falseVisableField"));
            }
        }
        if ((billstatus = this.getModel().getValue("billstatus")).toString().equals("D")) {
            this.getModel().setValue("billstatus", (Object)"A");
        }
    }

    public boolean validateOnlineBidEvalScoreData() {
        OnlineBidEvalScoreUtil onlineBidEvalScoreUtil = new OnlineBidEvalScoreUtil();
        String appId = this.getAppId();
        Map<Long, String> cacheOnlineBidEvalScoreData = this.getOnlineBidEvalScoreDataInCache();
        DynamicObjectCollection sectionColl = this.getModel().getEntryEntity("bidsection");
        HashSet<Long> sectionIdSet = new HashSet<Long>(16);
        for (int i = 0; i < sectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionColl.get(i);
            Long l = section.getLong("id");
            sectionIdSet.add(l);
        }
        boolean isHasTen = false;
        for (Map.Entry entry : cacheOnlineBidEvalScoreData.entrySet()) {
            Long sectionId = (Long)entry.getKey();
            sectionIdSet.remove(sectionId);
            List<String> supplierColumnKeyList = onlineBidEvalScoreUtil.getOnlineBidEvalSupplierColumnKeys(null, sectionId, appId);
            String cacheOnlineBidEvalScoreCollStr = cacheOnlineBidEvalScoreData.get(sectionId);
            List onlineBidEvalScoreList = (List)SerializationUtils.fromJsonString((String)cacheOnlineBidEvalScoreCollStr, Object.class);
            Map<String, Integer> totalRowIndexMap = onlineBidEvalScoreUtil.getTotalRowIndex(sectionId, this.getAppId());
            int technicalTotalScoreIndex = totalRowIndexMap.get("technicalscore");
            int commercialTotalScoreIndex = totalRowIndexMap.get("commercialscore");
            int scoreIndex = totalRowIndexMap.get("totalscore");
            if (onlineBidEvalScoreList == null || onlineBidEvalScoreList.size() <= 0) continue;
            isHasTen = true;
            for (int i = 0; i < scoreIndex; ++i) {
                if (i == technicalTotalScoreIndex || i == commercialTotalScoreIndex) continue;
                LinkedHashMap rowData = (LinkedHashMap)onlineBidEvalScoreList.get(i);
                for (int j = 0; j < supplierColumnKeyList.size(); ++j) {
                    BigDecimal suppScore;
                    String columnKey = supplierColumnKeyList.get(j);
                    if (!columnKey.startsWith("suppscore_") || (suppScore = NumberUtil.toBigDecimal(rowData.get(columnKey))) != null && BigDecimal.ZERO.compareTo(suppScore) < 0) continue;
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"OnlineBidEvalEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    return false;
                }
            }
        }
        if (!isHasTen) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"OnlineBidEvalEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (sectionIdSet.size() > 0) {
            for (Long l : sectionIdSet) {
                String scoreDetailSelectFields = "id,entryseq,score";
                DynamicObjectCollection onlineScoreDetailColl = this.onlineBidEvalService.listOnlineScoreDetailBySections(l, scoreDetailSelectFields, this.getAppId());
                for (int i = 0; i < onlineScoreDetailColl.size(); ++i) {
                    DynamicObject onlineScoreDetail = (DynamicObject)onlineScoreDetailColl.get(i);
                    BigDecimal suppScore = onlineScoreDetail.getBigDecimal("score");
                    if (suppScore != null && BigDecimal.ZERO.compareTo(suppScore) < 0) continue;
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"OnlineBidEvalEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    return false;
                }
            }
        }
        return true;
    }

    public Map<Long, String> getOnlineBidEvalScoreDataInCache() {
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection sectionColl = this.getModel().getEntryEntity("bidsection");
        HashMap<Long, String> cacheOnlineBidEvalScoreData = new HashMap<Long, String>();
        for (int i = 0; i < sectionColl.size(); ++i) {
            DynamicObject section = (DynamicObject)sectionColl.get(i);
            Long sectionId = section.getLong("id");
            String cacheOnlineBidEvalScoreCollStr = pageCache.get(sectionId.toString());
            if (!StringUtils.isNotEmpty((CharSequence)cacheOnlineBidEvalScoreCollStr)) continue;
            cacheOnlineBidEvalScoreData.put(sectionId, cacheOnlineBidEvalScoreCollStr);
        }
        return cacheOnlineBidEvalScoreData;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        if (operateKey.equals("alldownfile") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5168\u90e8\u9644\u4ef6\u6210\u529f", (String)"OnlineBidEvalEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        }
        switch (operateKey) {
            case "save": {
                this.saveOnlineBidEvalScoreData();
                break;
            }
            case "submit": {
                this.saveOnlineBidEvalScoreData();
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
                this.stopSaveProgress();
                break;
            }
            case "unsubmit": {
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
                this.startSaveProgress();
                break;
            }
            case "unaudit": {
                this.getPageCache().put("sectionId", null);
                this.clickFristRows();
            }
        }
        if (QUESTIONCLARIFYLIST.equals(operateKey)) {
            String doctype;
            String bidopentype = bidProject.getString("bidopentype");
            String evaltype = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype) ? (doctype = bidProject.getString("doctype")) : (String)this.getModel().getValue("evaltype");
            ListShowParameter listShowParameter = this.questionClarifyUtil.getOnlineBidEvalQCList(this.getAppId(), bidProject.getPkValue(), evaltype);
            long bidOpenId = dataEntity.getLong("bidopenid");
            boolean isDark = BidDarkUtil.isDarkEvaluation((String)this.getAppId(), (Object)bidOpenId, (String)bidopentype);
            listShowParameter.setCustomParam("isDark", (Object)isDark);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void saveOnlineBidEvalScoreData() {
        Map<Long, String> cacheOnlineBidEvalScoreData = this.getOnlineBidEvalScoreDataInCache();
        this.onlineBidEvalUtil.saveOnlineBidEvalScoreData(cacheOnlineBidEvalScoreData, this.getAppId());
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "onlinebidevalscore": {
                return "bid_onlinebidevalscore";
            }
        }
        return null;
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isBlank((CharSequence)startProgress)) {
            paramProgressEvent.setProgress(0);
            paramProgressEvent.setText(ResManager.loadKDString((String)"\u672a\u5f00\u59cb\u3002", (String)"OnlineBidEvalEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return;
        }
        int progress = 0;
        String text = ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\u3002", (String)"OnlineBidEvalEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        if (startProgress.equals("false")) {
            progress = 100;
            text = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u6267\u884c\u3002", (String)"OnlineBidEvalEdit_21", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        } else {
            String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
            if (StringUtils.isNotBlank((CharSequence)cacheProgress)) {
                progress = Integer.parseInt(cacheProgress);
            }
            if (progress >= 90) {
                progress = 0;
                text = ResManager.loadKDString((String)"\u672a\u5f00\u59cb\u3002", (String)"OnlineBidEvalEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                this.getView().invokeOperation("save");
            } else {
                progress += 6;
            }
        }
        this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(progress));
        paramProgressEvent.setProgress(progress);
        paramProgressEvent.setText(text);
    }

    @Override
    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        this.setListPriceComparisonVisible();
        this.handleViceSectionEntry();
        this.updateSupplierEntry();
        this.setSupplierEntryVisible();
        EntryGrid sectionEnRollGrid = (EntryGrid)this.getControl("bidsectionenroll");
        sectionEnRollGrid.selectRows(0, true);
        this.getModel().setDataChanged(false);
        String listrounds = this.getView().getModel().getDataEntity(true).getString("listrounds");
        if (StringUtils.isBlank((CharSequence)listrounds)) {
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            String evaltype = this.getModel().getValue("evaltype").toString();
            String billstatus = this.getModel().getValue("billstatus").toString();
            this.setRoundNumber(bidProject, evaltype, billstatus);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billno = this.getModel().getDataEntity(true).getString("billno");
        this.getModel().setValue("billno", (Object)(ID.genLongId() + ""));
    }

    public void setRoundNumber(DynamicObject project, String evaltype, String billstatus) {
        String format = "";
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"XX")) {
            format = this.getModel().getValue("listrounds").toString();
        } else {
            QFilter pFilter = new QFilter("bidproject", "=", project.getPkValue());
            QFilter eFilter = new QFilter("evaltype", "=", (Object)evaltype);
            QFilter sFilter = new QFilter("billstatus", "=", (Object)"XX");
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)(this.getAppId() + "_onlinebideval"), (String)"id", (QFilter[])new QFilter[]{pFilter, eFilter, sFilter});
            int rounds = 1;
            if (ids != null && ids.length > 0) {
                rounds += ids.length;
            }
            format = String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u8bc4\u6807", (String)"OnlineBidEvalEdit_9", (String)"scm-bid-formplugin", (Object[])new Object[0]), InvalidBillUtil.toChinese(rounds + ""));
        }
        this.getView().getModel().getDataEntity(true).set("listrounds", (Object)format);
        this.getView().updateView("listrounds");
    }

    public DynamicObject getSourceBidOpen() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long bidOpenId = dataEntity.getLong("bidopenid");
        QFilter qFilter = null;
        if (bidOpenId == 0L) {
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            String bidOpenSelectType = bidProject.getString("bidopentype");
            String evalType = dataEntity.getString("evaltype");
            String docType = bidProject.getString("doctype");
            qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.OPEN.getVal());
            if (BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType)) {
                if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
                    qFilter = qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                } else if (BidOpenTypeEnum.MULTI.getValue().equals(docType)) {
                    qFilter = qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
                }
            } else {
                qFilter = qFilter.and(new QFilter("opentype", "=", (Object)evalType));
            }
            qFilter = qFilter.and(new QFilter("bidproject", "=", bidProject.getPkValue()));
        } else {
            qFilter = new QFilter("id", "=", (Object)bidOpenId);
        }
        ORM orm = ORM.create();
        DynamicObject obj = orm.queryOne(FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), "id", new QFilter[]{qFilter});
        if (obj != null) {
            return BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
        }
        return null;
    }

    public void handleViceSectionEntry() {
        DynamicObject bidProject = this.getModel().getDataEntity().getDynamicObject("bidproject");
        boolean enableMultiSec = bidProject.getBoolean(this.ENABLE_MULTI_SECTION);
        SplitContainer splitContainer = (SplitContainer)this.getControl("sectionsplitcontainer1");
        if (splitContainer != null) {
            if (enableMultiSec) {
                splitContainer.changeFlexStatus(SplitDirection.left, false);
            } else {
                splitContainer.changeFlexStatus(SplitDirection.left, true);
            }
        }
    }

    public void updateSupplierEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionEnRoll = dataEntity.getDynamicObjectCollection("bidsectionenroll");
        DynamicObject bidOpen = this.getSourceBidOpen();
        DynamicObjectCollection bidSectionEntry = bidOpen.getDynamicObjectCollection("bidsection");
        String entityType = bidOpen.getString("entitytypeid");
        DynamicObject bid_bidDark = null;
        bid_bidDark = "bid_bidopen".equals(entityType) ? BusinessDataServiceHelper.loadSingle((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())}) : BusinessDataServiceHelper.loadSingle((String)"rebm_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())});
        boolean onlineEvalDark = dataEntity.getBoolean("isdark");
        HashMap supplierDarkNameMap = new HashMap();
        if (bid_bidDark != null) {
            supplierDarkNameMap = BidDarkUtil.getSupplierDarkName((DynamicObject)bid_bidDark, (boolean)onlineEvalDark);
        }
        HashMap<String, DynamicObjectCollection> purDetailMap = new HashMap<String, DynamicObjectCollection>();
        for (DynamicObject bidSection : bidSectionEntry) {
            DynamicObjectCollection purDetails = bidSection.getDynamicObjectCollection("supplierdetail");
            if (CollectionUtils.isEmpty((Collection)purDetails)) continue;
            purDetailMap.put(bidSection.getString("id"), purDetails);
        }
        if (CollectionUtils.isEmpty((Collection)bidSectionEnRoll) || bidSectionEnRoll.size() == 0) {
            Collections.sort(bidSectionEntry, new SortBySeq());
            for (int i = 0; i < bidSectionEntry.size(); ++i) {
                DynamicObject bidSection;
                bidSection = (DynamicObject)bidSectionEntry.get(i);
                DynamicObject bidSectionEn = bidSectionEnRoll.addNew();
                bidSectionEn.set("opensectionid", (Object)bidSection.getLong("id"));
                bidSectionEn.set("sectionname2", bidSection.get("sectionname"));
                DynamicObjectCollection tenderSupplierEntryCol = bidSectionEn.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supplierEntry = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntryRow : supplierEntry) {
                    boolean isTender = supplierEntryRow.getBoolean("supplier_istender");
                    boolean isInvalid = supplierEntryRow.getBoolean("supplier_isinvalid");
                    DynamicObject supplier = supplierEntryRow.getDynamicObject("supplier");
                    if (!isTender || isInvalid || supplier == null) continue;
                    DynamicObject tenderSupplierEntry = tenderSupplierEntryCol.addNew();
                    tenderSupplierEntry.set("detailid", (Object)supplierEntryRow.getString("id"));
                    tenderSupplierEntry.set("supplier", (Object)supplierEntryRow.getDynamicObject("supplier"));
                    if (onlineEvalDark) {
                        List supplierList = (List)supplierDarkNameMap.get(bidSection.getString("sectionname"));
                        for (HashMap supplierNameMap : supplierList) {
                            Long supplierId;
                            if (!supplierNameMap.containsKey(supplierId = (Long)supplierEntryRow.getDynamicObject("supplier").getPkValue())) continue;
                            String supplierDarkName = (String)supplierNameMap.get(supplierId);
                            tenderSupplierEntry.set("supplierdarkname_entry", (Object)supplierDarkName);
                        }
                    }
                    tenderSupplierEntry.set("techevalresult", (Object)"1");
                    tenderSupplierEntry.set("bsevalresult", (Object)"1");
                    this.copySupplierEntryBdAttachment(tenderSupplierEntry, supplierEntryRow, "supplier_techattach");
                    this.copySupplierEntryBdAttachment(tenderSupplierEntry, supplierEntryRow, "supplier_comattach");
                    tenderSupplierEntry.set("supplier_rate", (Object)supplierEntryRow.getBigDecimal("supplier_rate").multiply(new BigDecimal("100")));
                    tenderSupplierEntry.set("supplier_tenderprice", (Object)supplierEntryRow.getBigDecimal("supplier_tenderprice"));
                    tenderSupplierEntry.set("supplier_taxrate", (Object)supplierEntryRow.getBigDecimal("supplier_taxrate").multiply(new BigDecimal("100")));
                    tenderSupplierEntry.set("supplier_pricevat", (Object)supplierEntryRow.getBigDecimal("supplier_pricevat"));
                    tenderSupplierEntry.set("supplier_exceptvat", (Object)supplierEntryRow.getBigDecimal("supplier_exceptvat"));
                    tenderSupplierEntry.set("purdetail", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"OnlineBidEvalEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    tenderSupplierEntry.set("supplier_illustration", (Object)supplierEntryRow.getString("supplier_illustration"));
                    tenderSupplierEntry.set("isfrombackbid", (Object)supplierEntryRow.getBoolean("supplier_isfrombackbid"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        }
        for (DynamicObject bidSectionEn : bidSectionEnRoll) {
            DynamicObjectCollection supplierDetail = (DynamicObjectCollection)purDetailMap.get(bidSectionEn.getString("opensectionid"));
            DynamicObjectCollection supplierDetailCol = bidSectionEn.getDynamicObjectCollection("supplierdetail");
            supplierDetailCol.clear();
            if (supplierDetail == null) continue;
            for (DynamicObject supplierDetailRow : supplierDetail) {
                DynamicObject supplierDetailEntry = supplierDetailCol.addNew();
                supplierDetailEntry.set("pursupplier", (Object)supplierDetailRow.getDynamicObject("pursupplier"));
                supplierDetailEntry.set("purentrycontent", (Object)supplierDetailRow.getString("purentrycontent"));
                supplierDetailEntry.set("purentryproject", (Object)supplierDetailRow.getDynamicObject("purentryproject"));
                supplierDetailEntry.set("materialid", (Object)supplierDetailRow.getDynamicObject("materialid"));
                supplierDetailEntry.set("baseunit", (Object)supplierDetailRow.getDynamicObject("baseunit"));
                supplierDetailEntry.set("materialdes", (Object)supplierDetailRow.getString("materialdes"));
                supplierDetailEntry.set("qty", (Object)supplierDetailRow.getBigDecimal("qty"));
                supplierDetailEntry.set("inclutaxprice", (Object)supplierDetailRow.getBigDecimal("inclutaxprice"));
                supplierDetailEntry.set("inclutaxamount", (Object)supplierDetailRow.getBigDecimal("inclutaxamount"));
                supplierDetailEntry.set("bd_taxrate", (Object)supplierDetailRow.getDynamicObject("bd_taxrate"));
                supplierDetailEntry.set("taxrate", (Object)supplierDetailRow.getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                supplierDetailEntry.set("taxamount", (Object)supplierDetailRow.getBigDecimal("taxamount"));
                supplierDetailEntry.set("excepttaxamount", (Object)supplierDetailRow.getBigDecimal("excepttaxamount"));
                supplierDetailEntry.set("costrate", (Object)supplierDetailRow.getBigDecimal("costrate").multiply(new BigDecimal("100")));
                if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId())) continue;
                supplierDetailEntry.set("listnumber", supplierDetailRow.get("listnumber"));
                supplierDetailEntry.set("listname", supplierDetailRow.get("listname"));
                supplierDetailEntry.set("resourceitem", supplierDetailRow.get("resourceitem"));
            }
        }
        this.getView().updateView("bidsectionenroll");
        if (bidSectionEntry.size() > 0) {
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("bidsectionenroll", 0);
        }
    }

    public void copySupplierEntryBdAttachment(DynamicObject tenderSupplierEntry, DynamicObject supplierEntryRow, String fileField) {
        DynamicObjectCollection onlineAttachCol = tenderSupplierEntry.getDynamicObjectCollection(fileField);
        onlineAttachCol.clear();
        DynamicObjectCollection openAttachColl = supplierEntryRow.getDynamicObjectCollection(fileField);
        for (DynamicObject openAttach : openAttachColl) {
            DynamicObject newAttach = onlineAttachCol.addNew();
            DynamicObject newFile = BidFileHelper.copyBdAttachment((DynamicObject)openAttach.getDynamicObject("fbasedataid"));
            if (newFile != null) {
                newAttach.set("fbasedataid", (Object)newFile);
                continue;
            }
            newAttach.set("fbasedataid", (Object)openAttach.getDynamicObject("fbasedataid"));
        }
    }

    public void setSupplierEntryVisible() {
        boolean isRateBidding;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String evalType = dataEntity.getString("evaltype");
        boolean isDark = dataEntity.getBoolean("isdark");
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bsevaladvice", "bsevalresult", "supplier_comfile", "supplier_comattach", "supplier_rate", "supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "purdetail", "supplier_illustration", "float_scale"});
        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)evalType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"techevaladvice", "techevalresult", "supplier_techfile", "supplier_techattach"});
            isRateBidding = bidProject.getBoolean("isratebidding");
            if (isRateBidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"techevaladvice", "techevalresult", "supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "float_scale"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_rate"});
            }
        } else if (StringUtils.equals((CharSequence)BidOpenTypeEnum.MULTI.getValue(), (CharSequence)evalType)) {
            isRateBidding = bidProject.getBoolean("isratebidding");
            if (isRateBidding) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_tenderprice", "supplier_taxrate", "supplier_pricevat", "supplier_exceptvat", "float_scale"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"supplier_rate"});
            }
        }
        String evaluatedMethod = dataEntity.getString("evaluatedmethod");
        if (BidEvalMethodEnum.DL.getCode().equals(evaluatedMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"techevalresult", "bsevalresult"});
        }
        if (isDark) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplier"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplierdarkname_entry"});
        }
    }

    public void setListPriceComparisonVisible() {
        DynamicObject user;
        int j;
        this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
        DynamicObject bideValuation = this.getModel().getDataEntity();
        String evalType = bideValuation.getString("evaltype");
        if (evalType.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
            return;
        }
        long curUserId = UserServiceHelper.getCurrentUserId();
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext.getUserName();
        DynamicObject bidProject = bideValuation.getDynamicObject("bidproject");
        Long bidProjectPk = (Long)bidProject.getPkValue();
        boolean flag = CommonUtil.isBidAdmin((String)this.getAppId(), (Long)RequestContext.get().getCurrUserId());
        if (flag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
            return;
        }
        DynamicObject bidProjectColl = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"memberentity,user,respbusiness,isdirector,memberleaderentity,userleader,respbusinessleader");
        DynamicObjectCollection memberEntityColl = bidProjectColl.getDynamicObjectCollection("memberentity");
        for (int i = 0; i < memberEntityColl.size(); ++i) {
            DynamicObject memberEntity = (DynamicObject)memberEntityColl.get(i);
            DynamicObject user2 = memberEntity.getDynamicObject("user");
            Long userPk = (Long)user2.getPkValue();
            String respBussiness = memberEntity.getString("respbusiness");
            String[] resupBussinessList = respBussiness.split(",");
            Boolean idDirector = memberEntity.getBoolean("isdirector");
            if (idDirector.booleanValue() && userPk.compareTo(curUserId) == 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                return;
            }
            for (j = 0; j < resupBussinessList.length; ++j) {
                if (!resupBussinessList[j].equals("07") && !resupBussinessList[j].equals("14") || userPk.compareTo(curUserId) != 0) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                return;
            }
        }
        DynamicObjectCollection memberleaderentityColl = bidProjectColl.getDynamicObjectCollection("memberleaderentity");
        for (int i = 0; i < memberleaderentityColl.size(); ++i) {
            DynamicObject memberleaderentity = (DynamicObject)memberleaderentityColl.get(i);
            user = memberleaderentity.getDynamicObject("userleader");
            Long userPk = (Long)user.getPkValue();
            String respbusinessleader = memberleaderentity.getString("respbusinessleader");
            String[] respbusinessleaderList = respbusinessleader.split(",");
            for (j = 0; j < respbusinessleaderList.length; ++j) {
                if (!respbusinessleaderList[j].equals("07") && !respbusinessleaderList[j].equals("14") || userPk.compareTo(curUserId) != 0) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                return;
            }
        }
        DynamicObject billUserId = bideValuation.getDynamicObject("bidevaluator");
        DynamicObject userbidProficient = BusinessDataServiceHelper.loadSingle((Object)billUserId.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"proficient", ((Object)((Object)this)).getClass()), (String)"proficientname,name");
        user = userbidProficient.getDynamicObject("proficientname");
        Long userId = 0L;
        if (user != null) {
            userId = user.getLong("id");
        }
        QFilter qFilter_openType = null;
        String bidOpenSelectType = bidProject.getString("bidopentype");
        qFilter_openType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? new QFilter("opentype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()) : new QFilter("opentype", "=", (Object)evalType);
        DynamicObject open = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"opentype,bidopen_proficient,proficient,proficient_commercial", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectPk), qFilter_openType});
        if (open == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
        } else {
            DynamicObjectCollection proFicientColl = open.getDynamicObjectCollection("bidopen_proficient");
            for (int i = 0; i < proFicientColl.size(); ++i) {
                DynamicObject proFicient = (DynamicObject)proFicientColl.get(i);
                DynamicObject proficient = (DynamicObject)proFicient.get("proficient");
                long proficientPk = (Long)proficient.getPkValue();
                DynamicObject bidProficient = BusinessDataServiceHelper.loadSingle((Object)proficientPk, (String)FormTypeConstants.getFormConstant((String)"proficient", ((Object)((Object)this)).getClass()), (String)"proficientname,name");
                if (bidProficient == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                    return;
                }
                DynamicObject prficientName = bidProficient.getDynamicObject("proficientname");
                String name = bidProficient.getString("name");
                if (prficientName == null) {
                    if (StringUtils.equals((CharSequence)name, (CharSequence)userName)) {
                        Boolean idCommerical = proFicient.getBoolean("proficient_commercial");
                        if (idCommerical.booleanValue()) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                        } else {
                            this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                        }
                        return;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                    continue;
                }
                Long prificientPk = (Long)prficientName.getPkValue();
                if (prificientPk.compareTo(userId) != 0) continue;
                Boolean idCommerical = proFicient.getBoolean("proficient_commercial");
                if (idCommerical.booleanValue()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"lispricecomparison"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lispricecomparison"});
                }
                return;
            }
        }
    }

    public void cellClick(CellClickEvent arg0) {
        Iterator para;
        String itemName = arg0.getFieldKey();
        int rowCount = arg0.getRow();
        String typeName = null;
        String type = null;
        if ("supplier_techfile".equals(itemName)) {
            typeName = "techattachment";
            type = "techFile";
        } else if ("supplier_comfile".equals(itemName)) {
            typeName = "busattachment";
            type = "comFile";
        } else if ("supplier_tenfile".equals(itemName)) {
            typeName = "inviteattachment";
            type = "tenFile";
        } else if ("supplier_otherfile".equals(itemName)) {
            typeName = "otherattachment";
            type = "otherFile";
        }
        if ("supplier_techfile".equals(itemName) || "supplier_comfile".equals(itemName) || "supplier_tenfile".equals(itemName) || "supplier_otherfile".equals(itemName)) {
            String pkId;
            DynamicObject file;
            Long openSectionEntryId;
            DynamicObjectCollection bidSection;
            DynamicObject tempBidOpen;
            DynamicObject bidOpen;
            String clickFieldName = itemName;
            Integer clickRow = rowCount;
            EntryGrid grid = (EntryGrid)this.getView().getControl("bidsection");
            IDataModel operate = grid.getModel();
            int sectionRow = operate.getEntryCurrentRowIndex("bidsectionenroll");
            DynamicObject sectionEntry = operate.getEntryRowEntity("bidsectionenroll", sectionRow);
            DynamicObject supplierEntry = operate.getEntryRowEntity("supplierentry", rowCount);
            Long sectionEntryId = ((DynamicObject)this.getModel().getEntryEntity("bidsectionenroll").get(sectionRow)).getLong("opensectionid");
            Long supplierEntryId = supplierEntry.getLong("supplier.id");
            String sectionName = sectionEntry.getString("sectionname2");
            Boolean isfrombackbid = supplierEntry.getBoolean("isfrombackbid");
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            String billStatus = this.getModel().getDataEntity(true).getString("billstatus");
            boolean isHistory = false;
            if (BillStatusEnum.INVALIDXX.getVal().equals(billStatus)) {
                isHistory = true;
            }
            if (isfrombackbid.booleanValue()) {
                bidOpen = this.getSourceBidOpen();
                tempBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
                bidSection = tempBidOpen.getDynamicObjectCollection("bidsection");
                openSectionEntryId = null;
                for (int i = 0; i < bidSection.size(); ++i) {
                    if (!((DynamicObject)bidSection.get(i)).getString("sectionname").equals(sectionName)) continue;
                    openSectionEntryId = (Long)((DynamicObject)bidSection.get(i)).getPkValue();
                    break;
                }
                file = this.bidSupplierFileService.getOneFileRecordByIds(supplierEntryId, openSectionEntryId, type, "id,status,sectionid");
                BillShowParameter para2 = new BillShowParameter();
                pkId = file.getString("id");
                para2.setPkId((Object)pkId);
                para2.setCustomParam("bidProjectId", bidProject.getPkValue());
                para2.setCustomParam("sectionId", (Object)sectionEntryId);
                para2.setCustomParam("supplierId", (Object)supplierEntryId);
                para2.setCustomParam("sectionName", (Object)sectionName);
                para2.setCustomParam("isFromBackBid", (Object)isfrombackbid);
                para2.setCustomParam("isHistory", (Object)isHistory);
                para2.setCustomParam("clickRow", (Object)clickRow);
                para2.setCustomParam("typeName", (Object)typeName);
                para2.setCustomParam("bidpublishid", this.getModel().getValue("bidpublishid"));
                para2.setCustomParam("clickFieldName", (Object)clickFieldName);
                para2.setFormId(FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
                OpenStyle openStyle = para2.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                para2.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)para2);
            } else {
                bidOpen = this.getSourceBidOpen();
                tempBidOpen = BusinessDataServiceHelper.loadSingle((Object)bidOpen.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
                bidSection = tempBidOpen.getDynamicObjectCollection("bidsection");
                openSectionEntryId = null;
                for (int i = 0; i < bidSection.size(); ++i) {
                    if (!((DynamicObject)bidSection.get(i)).getString("sectionname").equals(sectionName)) continue;
                    openSectionEntryId = (Long)((DynamicObject)bidSection.get(i)).getPkValue();
                    break;
                }
                if ((file = this.bidSupplierFileService.getOneFileRecordByIds(supplierEntryId, openSectionEntryId, type, "id,status,sectionid")) != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("formId", FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass()));
                    pkId = file.getString("id");
                    map.put("pkId", pkId);
                    para = FormShowParameter.createFormShowParameter(map);
                    para.setCustomParam("bidopenid", (Long)bidOpen.getPkValue());
                    para.setCustomParam("supplierId", supplierEntryId);
                    para.setCustomParam("type", typeName);
                    para.setCustomParam("isFromBackBid", isfrombackbid);
                    para.setCustomParam("isHistory", isHistory);
                    para.setCustomParam("clickFieldName", clickFieldName);
                    para.setCustomParam("clickRow", clickRow);
                    OpenStyle openStyle = para.getOpenStyle();
                    openStyle.setShowType(ShowType.Modal);
                    para.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)para);
                }
            }
        }
        if ("purdetail".equals(itemName)) {
            DynamicObject bidopen = this.getSourceBidOpen();
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidopen.getDynamicObject("bidproject").getPkValue(), (String)(this.getAppId() + "_project"));
            boolean isMaterialpur = bidProject.getBoolean("ismaterialpur");
            boolean isratebidding = bidProject.getBoolean("isratebidding");
            int bidType = bidProject.getInt("bidtype");
            EntryGrid grid = (EntryGrid)arg0.getSource();
            IDataModel operate = grid.getModel();
            int row = arg0.getRow();
            DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            String supplierid = supplier.getString("id");
            EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsectionenroll");
            IDataModel sectionOperate = sectionGrid.getModel();
            int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsectionenroll");
            DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsectionenroll", sectionRow);
            String sectionId = sectionEntry.getString("id");
            String sectionName = sectionEntry.getString("sectionname2");
            DynamicObjectCollection purAllDetails = sectionEntry.getDynamicObjectCollection("supplierdetail");
            MainEntityType bidOpenType = EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()));
            EntityType supplierDetailType = (EntityType)bidOpenType.getAllEntities().get("supplierdetail");
            DynamicObjectCollection purDetails = new DynamicObjectCollection((DynamicObjectType)supplierDetailType, (Object)sectionEntry);
            for (DynamicObject purDetail : purAllDetails) {
                DynamicObject pursupplierOb = purDetail.getDynamicObject("pursupplier");
                if (!StringUtils.equals((CharSequence)supplierid, (CharSequence)pursupplierOb.getString("id"))) continue;
                purDetails.add((Object)purDetail);
            }
            para = new FormShowParameter();
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            para.setStatus(OperationStatus.VIEW);
            para.setFormId(FormTypeConstants.getFormConstant((String)"bidopen_purdetail", ((Object)((Object)this)).getClass()));
            para.setCustomParam("supplierid", supplierid);
            para.setCustomParam("sectionId", sectionId);
            para.setCustomParam("sectionName", sectionName);
            para.setCustomParam("isMaterialpur", isMaterialpur);
            para.setCustomParam("isratebidding", isratebidding);
            para.setCustomParam("bidType", bidType);
            para.setCustomParam("tendergrading", Boolean.TRUE);
            para.setCustomParam("purDetails", purDetails);
            para.setCustomParam("bidOpenId", bidopen.getLong("id"));
            para.setCustomParam("bidProject", bidProject.getPkValue());
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, FormTypeConstants.getFormConstant((String)"bidopen_purdetail", ((Object)((Object)this)).getClass()));
            para.setCloseCallBack(callBack);
            this.getView().showForm((FormShowParameter)para);
        }
        if ("operationcolumnap".equals(itemName)) {
            this.fileDownLoad(arg0);
        }
    }

    public void fileDownLoad(CellClickEvent arg0) {
        EntryGrid sectionGrid = (EntryGrid)this.getView().getControl("bidsectionenroll");
        IDataModel sectionOperate = sectionGrid.getModel();
        int sectionRow = sectionOperate.getEntryCurrentRowIndex("bidsectionenroll");
        DynamicObject sectionEntry = sectionOperate.getEntryRowEntity("bidsectionenroll", sectionRow);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String sectionId = "";
        String sectionName = "";
        if (sectionEntry != null) {
            sectionId = sectionEntry.getString("id");
            sectionName = sectionEntry.getString("sectionname2");
        }
        boolean isDark = dataEntity.getBoolean("isdark");
        EntryGrid grid = (EntryGrid)arg0.getSource();
        IDataModel operate = grid.getModel();
        int row = arg0.getRow();
        DynamicObject supplierEntry = operate.getEntryRowEntity(grid.getKey(), row);
        String supplierId = "";
        String supplierName = "";
        if (supplierEntry != null) {
            DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
            supplierId = supplier.getString("id");
            supplierName = isDark ? supplierEntry.getString("supplierdarkname_entry") : supplier.getString("name");
            if (sectionId.equals("") || supplierId.equals("")) {
                return;
            }
            String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
            ArrayList attachmentIds = new ArrayList();
            DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
            Object bidprojectId = bidproject.getPkValue();
            String evalType = dataEntity.getString("evaltype");
            BidFileHelper.getFileUrl((DynamicObject)supplierEntry, (String)evalType, attachmentIds, (String)(serviceAppId + "_onlinebideval"), (Object)bidprojectId);
            String fielZipName = this.getFileZipName(bidprojectId, sectionName, supplierName, serviceAppId + "_onlinebideval", dataEntity.getPkValue(), serviceAppId);
            if (attachmentIds.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002", (String)"OnlineBidEvalEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().download(BidFileHelper.downloadByAttachmentIds((String)fielZipName, attachmentIds));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\u3002", (String)"OnlineBidEvalEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]), attachmentIds.size()));
            }
        }
    }

    public String getFileZipName(Object bidprojectId, String sectionName, String supplierName, String formBillno, Object formId, String appid) {
        return BidFileHelper.getFileZipName((Object)bidprojectId, (String)sectionName, (String)supplierName, (String)formBillno, (Object)formId, (String)appid);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

