/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.QuestionClarifyUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class OnlineBidEvalList
extends AbstractListPlugin {
    protected QuestionClarifyUtil questionClarifyUtil = new QuestionClarifyUtil();
    protected IOnlineBidEvalService onlineBidEvalService = new OnlineBidEvalServiceImpl();
    private static String QUESTIONCLARIFYLIST = "questionclarifylist";

    private String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public String getBidAdminRoleID() {
        return "/FFXFSRKI73+";
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FormShowParameter parameter;
        String bidCenter;
        boolean enable = SystemParamHelper.getSystemParameter((String)this.getAppId(), (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"checkhistory"});
        }
        if (enable = StringUtils.isNotEmpty((CharSequence)(bidCenter = (String)(parameter = this.getView().getFormShowParameter()).getCustomParam("BidCenter")))) {
            List CommonFilter = args.getCommonFilterColumns();
            for (int i = 0; i < CommonFilter.size(); ++i) {
                if (!"org.name".equals(((FilterColumn)CommonFilter.get(i)).getFieldName())) continue;
                CommonFilter.remove(i);
            }
            List SchemeFilterColumn = args.getSchemeFilterColumns();
            for (int i = 0; i < SchemeFilterColumn.size(); ++i) {
                if (!"org.name".equals(((FilterColumn)SchemeFilterColumn.get(i)).getFieldName())) continue;
                SchemeFilterColumn.remove(i);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String checkhistory = (String)parameter.getCustomParam("checkhistory");
        if (StringUtils.isEmpty((CharSequence)checkhistory)) {
            QFilter qFilter;
            Optional<QFilter> of;
            QFilter filter4Org = null;
            boolean isOrg = false;
            if (qFilters != null && (of = qFilters.stream().filter(filter -> "org.name".equals(filter.getProperty())).findFirst()).isPresent()) {
                isOrg = true;
                QFilter f = of.get();
                qFilters.remove(f);
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", f.getCP(), f.getValue())});
                Set orgIds = orgs.stream().map(org -> org.get("id")).collect(Collectors.toSet());
                QFilter q1 = new QFilter("bidproject.org", "in", orgIds);
                QFilter q2 = new QFilter("bidproject.entrustmentorgunit", "in", orgIds);
                filter4Org = q1.or(q2);
            }
            long orgId = -1L;
            List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
            if (orgIds != null && orgIds.size() != 0 && !isOrg) {
                orgId = (Long)orgIds.get(0);
                filter4Org = new QFilter("bidproject.org", "in", (Object)orgIds).or(new QFilter("bidproject.entrustmentorgunit", "in", (Object)orgIds));
            }
            if (filter4Org != null && qFilters != null) {
                qFilters.add(filter4Org);
            }
            BaseDataServiceHelper helper = new BaseDataServiceHelper();
            String formId = ((BillList)e.getSource()).getBillFormId();
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)formId, (Long)orgId);
            if (qfilter != null && qFilters != null) {
                qFilters.add(qfilter);
            }
            e.setMainOrgQFilter(null);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String customParam = (String)formShowParameter.getCustomParam("BidCenter");
            if (StringUtils.isNotEmpty((CharSequence)customParam)) {
                super.setFilter(e);
                return;
            }
            boolean isAdmin = CommonUtil.isBidAdmin((String)this.getAppId(), (Long)RequestContext.get().getCurrUserId());
            if (!isAdmin && qFilters != null) {
                qFilter = this.getProficientFilter();
                QFilter directorOrAppraiserFilter = this.getDirectorOrAppraiserFilter(orgId);
                if (directorOrAppraiserFilter != null) {
                    qFilter.or(directorOrAppraiserFilter);
                }
                qFilters.add(qFilter);
            }
            qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
            if (qFilters != null) {
                qFilters.add(qFilter);
            }
        } else {
            Object bidProjectId = parameter.getCustomParam("bidProjectId");
            Object bidevaluator = parameter.getCustomParam("bidevaluator");
            DynamicObject bidProject = QueryServiceHelper.queryOne((String)"bid_project", (String)"bidopentype", (QFilter[])new QFilter[]{new QFilter("id", "=", bidProjectId)});
            Object evalType = parameter.getCustomParam("evalType");
            QFilter qFilter = new QFilter("bidproject", "=", (Object)Long.parseLong(bidProjectId.toString())).and("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()).and("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()).and("bidevaluator", "=", bidevaluator);
            if (!"UNIONOPEN".equals(bidProject.getString("bidopentype"))) {
                qFilter.and("evaltype", "=", evalType);
            }
            qFilters.add(qFilter);
        }
        e.setMainOrgQFilter(null);
        super.setFilter(e);
    }

    private QFilter getProficientFilter() {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter filter = new QFilter("bidevaluator.proficientname.id", "=", (Object)userId);
        return filter;
    }

    private QFilter getDirectorOrAppraiserFilter(long orgId) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        QFilter qFilter = new QFilter("user", "=", (Object)userId);
        QFilter f = new QFilter("respbusiness", "like", (Object)"%07%").or(new QFilter("isdirector", "=", (Object)"1")).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalEval.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessEval.getVal() + "%")));
        qFilter.and(f);
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
        QFilter qFilter_eval_member = this.evaluationQFilterMember(members);
        QFilter qFilter_eval_leader = this.evaluationQFilterLeader(leaders);
        if (qFilter_eval_member == null) {
            return qFilter_eval_leader;
        }
        return qFilter_eval_member.or(qFilter_eval_leader);
    }

    public QFilter evaluationQFilterMember(DynamicObject[] members) {
        QFilter qFilter_eval = null;
        for (int i = 0; i < members.length; ++i) {
            long bidProjectId;
            DynamicObject member = members[i];
            long l = bidProjectId = !StringUtils.isEmpty((CharSequence)member.getString("bidproject")) ? Long.parseLong(member.getString("bidproject")) : 0L;
            if (i == 0) {
                if (member.getBoolean("isdirector")) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                    continue;
                }
                if (member.getString("respbusiness").contains(RespBusiness.TechnicalEval.getVal())) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                }
                if (member.getString("respbusiness").contains(RespBusiness.BusinessEval.getVal())) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                }
                if (member.getString("respbusiness").contains(RespBusiness.TechnicalEval.getVal()) && member.getString("respbusiness").contains(RespBusiness.BusinessEval.getVal())) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                    qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())));
                }
                if (!member.getString("respbusiness").contains(RespBusiness.BidEvaluation.getVal())) continue;
                qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                continue;
            }
            if (member.getBoolean("isdirector")) {
                if (qFilter_eval == null) continue;
                qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId));
                continue;
            }
            if (member.getString("respbusiness").contains(RespBusiness.TechnicalEval.getVal()) && qFilter_eval != null) {
                qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())));
            }
            if (member.getString("respbusiness").contains(RespBusiness.BusinessEval.getVal()) && qFilter_eval != null) {
                qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())));
            }
            if (!member.getString("respbusiness").contains(RespBusiness.BidEvaluation.getVal()) || qFilter_eval == null) continue;
            qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId));
        }
        return qFilter_eval;
    }

    public QFilter evaluationQFilterLeader(DynamicObject[] leaders) {
        QFilter qFilter_eval = null;
        for (int i = 0; i < leaders.length; ++i) {
            long bidProjectId;
            DynamicObject member = leaders[i];
            long l = bidProjectId = !StringUtils.isEmpty((CharSequence)member.getString("bidproject")) ? Long.parseLong(member.getString("bidproject")) : 0L;
            if (i == 0) {
                if (member.getString("respbusiness").contains(RespBusiness.TechnicalEval.getVal())) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                }
                if (member.getString("respbusiness").contains(RespBusiness.BusinessEval.getVal())) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                }
                if (member.getString("respbusiness").contains(RespBusiness.TechnicalEval.getVal()) && member.getString("respbusiness").contains(RespBusiness.BusinessEval.getVal())) {
                    qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                    qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())));
                }
                if (!member.getString("respbusiness").contains(RespBusiness.BidEvaluation.getVal())) continue;
                qFilter_eval = new QFilter("bidproject.id", "=", (Object)bidProjectId);
                continue;
            }
            if (member.getString("respbusiness").contains(RespBusiness.TechnicalEval.getVal()) && qFilter_eval != null) {
                qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue())));
            }
            if (member.getString("respbusiness").contains(RespBusiness.BusinessEval.getVal()) && qFilter_eval != null) {
                qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue())));
            }
            if (!member.getString("respbusiness").contains(RespBusiness.BidEvaluation.getVal()) || qFilter_eval == null) continue;
            qFilter_eval.or(new QFilter("bidproject.id", "=", (Object)bidProjectId));
        }
        return qFilter_eval;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        IFormView view = this.getView();
        BillList onlineBidEvalList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = onlineBidEvalList.getSelectedRows();
        if ("tblmodify".equals(key)) {
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OnlineBidEvalList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u7f16\u5236\u591a\u6761\u6570\u636e\u3002", (String)"OnlineBidEvalList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long onlineBidEvalId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject onlineBidEval = this.onlineBidEvalService.getOnlineBidEval(onlineBidEvalId);
            String billstatus = onlineBidEval.getString("billstatus");
            DynamicObject bidProject = onlineBidEval.getDynamicObject("bidproject");
            if (!BillStatusEnum.DISBEGIN.getVal().equals(billstatus) && !BillStatusEnum.SAVE.getVal().equals(billstatus)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53ea\u80fd\u7f16\u5236\u672a\u5f00\u59cb\u548c\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"OnlineBidEvalList_2", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidProject.getString("billno")));
                evt.setCancel(true);
                return;
            }
            String evaltype = onlineBidEval.getString("evaltype");
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidProject.getPkValue(), evaltype);
            if (exsitBackBid) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5728\u7ebf\u8bc4\u6807\u3002", (String)"OnlineBidEvalList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("tblsubmit".equals(key)) {
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OnlineBidEvalList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (selectedRows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u63d0\u4ea4\u8bc4\u6807\u6570\u636e\u3002", (String)"OnlineBidEvalList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long onlineBidEvalId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject onlineBidEval = this.onlineBidEvalService.getOnlineBidEval(onlineBidEvalId);
            String billstatus = onlineBidEval.getString("billstatus");
            DynamicObject bidProject = onlineBidEval.getDynamicObject("bidproject");
            if (!BillStatusEnum.SAVE.getVal().equals(billstatus) && !BillStatusEnum.DISBEGIN.getVal().equals(billstatus)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53ea\u6709\u672a\u5f00\u59cb\u6216\u8005\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"OnlineBidEvalList_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), bidProject.getString("billno")));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        ReBackBidUtil reBackBidUtil = new ReBackBidUtil(this.getAppId());
        if (reBackBidUtil.judgeOp(operateKey)) {
            ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u7740\u6570\u636e\uff0c\u5728\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OnlineBidEvalList_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = listSelectedRows.get(0);
            Long bidEvaluationId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((Object)bidEvaluationId, (String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()));
            DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkEvalutionOp(operateKey, bidProject.getPkValue());
            if (exsitBackBid) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"OnlineBidEvalList_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if ("submit".equals(operateKey)) {
            boolean canSubmit;
            FormOperate operate = (FormOperate)args.getSource();
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm) && !(canSubmit = this.validateOnlineBidEvalScoreData())) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormShowParameter formShowParameter;
        String customParam;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        String operateKey = formOperate.getOperateKey();
        if (QUESTIONCLARIFYLIST.equals(operateKey)) {
            String doctype;
            ListSelectedRow currentSelectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject bidevaluation = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRow.getPrimaryKeyValue(), (String)"bid_onlinebideval");
            DynamicObject bidProject = bidevaluation.getDynamicObject("bidproject");
            String bidopentype = bidProject.getString("bidopentype");
            String evaltype = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidopentype) ? (doctype = bidProject.getString("doctype")) : bidevaluation.getString("evaltype");
            ListShowParameter listShowParameter = this.questionClarifyUtil.getOnlineBidEvalQCList(this.getAppId(), bidProject.getPkValue(), evaltype);
            long bidOpenId = bidevaluation.getLong("bidopenid");
            boolean isDark = BidDarkUtil.isDarkEvaluation((String)this.getAppId(), (Object)bidOpenId, (String)bidopentype);
            listShowParameter.setCustomParam("isDark", (Object)isDark);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(customParam = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("BidCenter"))) && "close".equals(operateKey)) {
            IFormView parentView = this.getView().getParentView();
            parentView.getModel().setValue("exitmark", (Object)Boolean.TRUE);
            this.getView().sendFormAction(parentView);
        }
        if (StringUtils.equals((CharSequence)"checkhistory", (CharSequence)operateKey)) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object openKeyValue = sr.getPrimaryKeyValue();
            DynamicObject onlineBidEval = BusinessDataServiceHelper.loadSingle((Object)openKeyValue, (String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()));
            Object bidProjectId = onlineBidEval.getDynamicObject("bidproject").getPkValue();
            DynamicObject[] openColl = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProjectId), new QFilter("bidevaluator", "=", onlineBidEval.getDynamicObject("bidevaluator").getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()), new QFilter("sourcebillstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal())});
            if (openColl != null && openColl.length > 0) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("bidProjectId", bidProjectId);
                listShowParameter.setCustomParam("bidevaluator", onlineBidEval.getDynamicObject("bidevaluator").getPkValue());
                listShowParameter.setCustomParam("evalType", (Object)onlineBidEval.getString("evaltype"));
                listShowParameter.setCustomParam("checkhistory", (Object)"checkhistory");
                listShowParameter.setMultiSelect(false);
                listShowParameter.setHasRight(true);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String appId = this.getAppId();
                if (appId.equals("bid")) {
                    listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"onlinebideval_history", ((Object)((Object)this)).getClass()));
                } else {
                    listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"onlinebideval_histor", ((Object)((Object)this)).getClass()));
                }
                this.getView().showForm((FormShowParameter)listShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u5728\u7ebf\u8bc4\u6807\u8bb0\u5f55\u3002", (String)"OnlineBidEvalList_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean validateOnlineBidEvalScoreData() {
        String selectFields;
        BillList dataList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = dataList.getSelectedRows();
        ListSelectedRow selectedRow = selectedRows.get(0);
        Long onlinebidevalId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObjectCollection onlineScoreDetailColl = this.onlineBidEvalService.listOnlineScoreDetails(onlinebidevalId, selectFields = "id, score", this.getAppId());
        if (onlineScoreDetailColl != null && onlineScoreDetailColl.size() > 0) {
            for (int i = 0; i < onlineScoreDetailColl.size(); ++i) {
                DynamicObject onlineScoreDetail = (DynamicObject)onlineScoreDetailColl.get(i);
                BigDecimal score = onlineScoreDetail.getBigDecimal("score");
                if (score != null && BigDecimal.ZERO.compareTo(score) < 0) continue;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5f97\u5206\u4e3a0\u7684\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"OnlineBidEvalList_10", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                return false;
            }
        } else {
            String evaluatedMethod;
            DynamicObject bidOnlinebideval = BusinessDataServiceHelper.loadSingle((Object)onlinebidevalId, (String)(this.getAppId() + "_onlinebideval"));
            if (bidOnlinebideval != null && "1".equals(evaluatedMethod = bidOnlinebideval.getString("evaluatedmethod"))) {
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f9b\u5e94\u5546\u4fe1\u606f\u201d\u4e3a\u7a7a\u3002", (String)"OnlineBidEvalList_11", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("bidproject.name".equals(fieldName)) {
            BillList onlineBidEvalList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = onlineBidEvalList.getSelectedRows();
            ListSelectedRow selectedRow = selectedRows.get(0);
            Long onlineBidEvalId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject onlineBidEval = this.onlineBidEvalService.getOnlineBidEval(onlineBidEvalId);
            DynamicObject bidProject = onlineBidEval.getDynamicObject("bidproject");
            String evaltype = onlineBidEval.getString("evaltype");
            boolean exsitBackBid = new ReBackBidUtil(this.getAppId()).checkBackBidFinished(bidProject.getPkValue(), evaltype);
            if (exsitBackBid) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u5728\u7ebf\u8bc4\u6807\u3002", (String)"OnlineBidEvalList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    static /* synthetic */ String access$000(OnlineBidEvalList x0) {
        return x0.getAppId();
    }
}

