/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.SupplierInvitationList;
import kd.scm.bid.formplugin.bill.helper.BidModeHelper;
import kd.scm.bid.formplugin.bill.helper.PermissionHepler;
import kd.scm.bid.formplugin.bill.util.SendMessageUtil;
import kd.scm.bid.formplugin.bill.util.SupplierInvitationUtil;
import kd.scm.bid.formplugin.util.ReBackBidUtil;

public class SupplierInvitationList
extends AbstractListPlugin {
    private static final String KEY_CURRENTSTEP = "bidproject_currentstep";
    private static final String KEY_SUPPLIERENROLL = "bid_supplierenroll";
    private static final String KEY_INVITATION = "bid_invitation";
    protected ISupplierInvitationService suppInviService = new SupplierInvitationServiceImpl();
    private static final IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"listcurrentstep", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingleFromCache((Object)((Long)id), (String)this.suppInviService.getFormId(), (String)"id,bidproject.id,billstatus,sourcebillid");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(this.getOpenFormId("projectprocess"));
            showParameter.setCustomParam("bidProjectId", supplierInvitation.get("bidproject.id"));
            showParameter.setCustomParam("showFormType", (Object)"gfrw");
            showParameter.setCustomParam("nowId", id);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"supplierenrollqty", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            CloseCallBack back = new CloseCallBack((IFormPlugin)this, this.getAppId() + "_supplierenroll");
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            Object id = sr.getPrimaryKeyValue();
            DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingleFromCache((Object)((Long)id), (String)this.suppInviService.getFormId(), (String)"id,bidproject,bidproject.bidmode.name,org");
            if (BidModeHelper.isPublicBidding(supplierInvitation.getDynamicObject("bidproject"))) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(FormTypeConstants.getFormConstant((String)"supplierenroll", ((Object)((Object)this)).getClass()));
                showParameter.setCustomParam("bidProjectId", supplierInvitation.get("bidproject.id"));
                showParameter.setCustomParam("orgid", supplierInvitation.getDynamicObject("org").getPkValue());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCloseCallBack(back);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getCustomQFilters();
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        filters.add(billStatusFilter);
        super.setFilter(e);
    }

    public String getAppId() {
        BillList view = (BillList)this.getView().getControl("billlistap");
        return ((BillEntityType)view.getEntityType()).getAppId();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList x = (BillList)this.getView().getControl("billlistap");
        x.refresh();
    }

    public void beforeItemClick(BeforeItemClickEvent beforeitemclickevent) {
        if ("edit".equals(beforeitemclickevent.getItemKey())) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u7f16\u5236\u591a\u6761\u6570\u636e\u3002", (String)"SupplierInvitationList_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                beforeitemclickevent.setCancel(true);
                return;
            }
            if (rows.size() == 1) {
                ListSelectedRow selectedRow = rows.get(0);
                String billStatus = selectedRow.getBillStatus();
                if (!BillStatusEnum.DISBEGIN.getVal().equals(billStatus) && !BillStatusEnum.SAVE.getVal().equals(billStatus)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53ea\u80fd\u7f16\u5236\u672a\u5f00\u59cb\u548c\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"SupplierInvitationList_1", (String)"scm-bid-formplugin", (Object[])new Object[0]), selectedRow.getBillNo()));
                    beforeitemclickevent.setCancel(true);
                    return;
                }
            }
        }
    }

    public String getOpenFormId(String formType) {
        switch (formType) {
            case "projectprocess": {
                return "bid_projectprocess";
            }
            case "bid_supplierenroll": {
                return KEY_SUPPLIERENROLL;
            }
            case "bid_invitation": {
                return KEY_INVITATION;
            }
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection collList;
        DynamicObject supplierInvitation;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String appId = this.getAppId();
        long orgId = -1L;
        List orgIds = ((ListView)this.getView()).getSelectedMainOrgIds();
        if (orgIds != null && orgIds.size() != 0) {
            orgId = (Long)orgIds.get(0);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addinvitation")) {
            String status;
            QFilter statusFilter;
            ListSelectedRowCollection coll = ((IListView)this.getView()).getSelectedRows();
            if (coll == null) {
                return;
            }
            if (coll != null && coll.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u53d1\u5e03\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"SupplierInvitationList_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long rowId = (Long)coll.get(0).getPrimaryKeyValue();
            boolean hasPermission = PermissionHepler.checkPermission("QXX0125", orgId, appId, appId + "_supplierinvitation");
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9080\u8bf7\u51fd\u53d1\u5e03\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"SupplierInvitationList_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject supplierInvitation2 = this.suppInviService.getSupplierInvitationById(rowId);
            if (!"A".equals(supplierInvitation2.getString("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u624d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationList_4", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject bidProject = supplierInvitation2.getDynamicObject("bidproject");
            if (BidModeHelper.isPublicBidding(bidProject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8bb0\u5f55\u662f\u516c\u5f00\u62db\u6807\uff0c\u4e0d\u5141\u8bb8\u53d1\u5e03\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationList_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<String> unsendSupplierEntryList = this.hasSendInvitation(coll.get(0).getPrimaryKeyValue());
            if (unsendSupplierEntryList != null && unsendSupplierEntryList.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u9080\u8bf7\u51fd\u3002", (String)"SupplierInvitationList_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProject.getLong("id"));
            DynamicObjectCollection invitationColl = QueryServiceHelper.query((String)KEY_INVITATION, (String)"id,status,releasestatus", (QFilter[])new QFilter[]{qFilter, statusFilter = new QFilter("status", "not in", (Object)new String[]{"XX", "X"})}, (String)"createtime desc");
            if (invitationColl != null && invitationColl.size() > 0 && !"A".equals(status = ((DynamicObject)invitationColl.get(0)).getString("status"))) {
                for (DynamicObject invitation : invitationColl) {
                    boolean flag = "P".equals(invitation.getString("releasestatus")) && "C".equals(invitation.getString("status"));
                    if (flag) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u9080\u8bf7\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SupplierInvitationList_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"newdelete")) {
            ListSelectedRowCollection coll = ((IListView)this.getView()).getSelectedRows();
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    Long id = (Long)coll.get(0).getPrimaryKeyValue();
                    DynamicObject supplierInvitation3 = null;
                    if (id != null) {
                        supplierInvitation3 = this.suppInviService.getSupplierInvitationById(id);
                    }
                    if (supplierInvitation3 == null) continue;
                    String billno = supplierInvitation3.getString("bidproject.billno");
                    DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_supplierinvitation");
                    boolean isAgainSupplierInvitation = SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation3);
                    DynamicObjectCollection bidSectionColl = supplier.getDynamicObjectCollection("bidsection");
                    if (bidSectionColl != null && bidSectionColl.size() > 0) {
                        for (int m = 0; m < bidSectionColl.size(); ++m) {
                            DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(m)).getDynamicObjectCollection("supplierentry");
                            if (supplierEntry == null || supplierEntry.size() <= 0) continue;
                            for (int n = 0; n < supplierEntry.size(); ++n) {
                                boolean invitationStatusFlag;
                                String invitationStatus = ((DynamicObject)supplierEntry.get(n)).getString("invitationstatus");
                                if (!StringUtils.isNotBlank((CharSequence)invitationStatus)) continue;
                                boolean bl = invitationStatusFlag = !"UNSEND".equals(invitationStatus);
                                if (isAgainSupplierInvitation) {
                                    if (!invitationStatusFlag || !((DynamicObject)supplierEntry.get(n)).getBoolean("isnew")) continue;
                                    args.setCancel(true);
                                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0 [%s]:\u5b58\u5728\u5df2\u53d1\u9001\u9080\u8bf7\u51fd\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationList_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                                    return;
                                }
                                if (!invitationStatusFlag) continue;
                                args.setCancel(true);
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0 [%s]:\u5b58\u5728\u5df2\u53d1\u9001\u9080\u8bf7\u51fd\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationList_8", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                                return;
                            }
                        }
                    }
                    DynamicObjectCollection bidenrollsection = supplier.getDynamicObjectCollection("bidenrollsection");
                    if (bidSectionColl == null || bidSectionColl.size() <= 0) continue;
                    for (int m = 0; m < bidSectionColl.size(); ++m) {
                        DynamicObjectCollection supplierenrollentry = ((DynamicObject)bidenrollsection.get(m)).getDynamicObjectCollection("supplierenrollentry");
                        if (supplierenrollentry == null || supplierenrollentry.size() <= 0 || isAgainSupplierInvitation) continue;
                        args.setCancel(true);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u62db\u6807\u540d\u79f0[%1$s]:\u5df2\u5b58\u5728\u62a5\u540d\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SupplierInvitationList_9", (String)"scm-bid-formplugin", (Object[])new Object[0]), billno));
                        return;
                    }
                }
            }
            RefObject afterConfirm = new RefObject();
            if (!formOperate.getOption().tryGetVariableValue("newdelete", afterConfirm)) {
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("newdelete", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"SupplierInvitationList_11", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            String yqhCheckResult;
            Object dateLine;
            ListSelectedRowCollection coll = ((IListView)this.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)coll) || coll.get(0) == null) {
                return;
            }
            if (coll.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u63d0\u4ea4\u3002", (String)"SupplierInvitationList_12", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject supplierInvitation4 = this.suppInviService.getSupplierInvitationById((Long)coll.get(0).getPrimaryKeyValue());
            DynamicObject bidProject = supplierInvitation4.getDynamicObject("bidproject");
            if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation4)) {
                String checkResult;
                String sourceBillId = supplierInvitation4.getString("sourcebillid");
                if (!StringUtils.isEmpty((CharSequence)sourceBillId) && !StringUtils.isEmpty((CharSequence)(checkResult = SupplierInvitationUtil.checkIsSubmitAudit(sourceBillId, appId)))) {
                    this.getView().showTipNotification(checkResult);
                    args.setCancel(true);
                    return;
                }
                boolean flag = false;
                DynamicObjectCollection sections = supplierInvitation4.getDynamicObjectCollection("bidsection");
                if (!CollectionUtils.isEmpty((Collection)sections)) {
                    block5: for (DynamicObject section : sections) {
                        DynamicObjectCollection supplierEntryList = section.getDynamicObjectCollection("supplierentry");
                        for (DynamicObject publishSupplierEntry : supplierEntryList) {
                            boolean invalid = publishSupplierEntry.getBoolean("isnew");
                            if (!invalid) continue;
                            flag = true;
                            continue block5;
                        }
                    }
                }
                if (!flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u56f4\u4f9b\u5e94\u5546\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u9700\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationList_13", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable") && (dateLine = bidProject.get("invitationdeadline")) != null) {
                Date newDate = (Date)dateLine;
                Date now = new Date();
                if (newDate.getTime() > now.getTime()) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String str = dateFormat.format(newDate.getTime());
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5230\u201c\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u201d%s\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"SupplierInvitationList_14", (String)"scm-bid-formplugin", (Object[])new Object[0]), str));
                    args.setCancel(true);
                    return;
                }
            }
            boolean unconfirm = false;
            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)((Long)coll.get(0).getPrimaryKeyValue()), (String)"bid_supplierinvitation");
            DynamicObjectCollection bidSectionColl = supplier.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                    if (supplierEntry == null || supplierEntry.size() <= 0) continue;
                    for (int m = 0; m < supplierEntry.size(); ++m) {
                        if (((DynamicObject)supplierEntry.get(m)).getString("invitationstatus").equals("UNSEND")) continue;
                        unconfirm = true;
                    }
                }
            }
            if (!unconfirm && SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable") && !BidModeHelper.isPublicBidding(bidProject) && !"1".equals(yqhCheckResult = this.getPageCache().get("yqhCheckResult"))) {
                args.setCancel(true);
                this.getPageCache().put("yqhCheck", "1");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u65e0\u4f9b\u5e94\u5546\u63a5\u53d7\u9080\u8bf7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4?", (String)"SupplierInvitationList_15", (String)"scm-bid-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addinvitationview")) {
            ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)rows) || rows.get(0) == null) {
                return;
            }
            DynamicObject supplierInvitation5 = this.suppInviService.getSupplierInvitationById((Long)rows.get(0).getPrimaryKeyValue());
            DynamicObject bidProject = supplierInvitation5.getDynamicObject("bidproject");
            if (bidProject != null) {
                if (rows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u9080\u8bf7\u51fd\u4e0d\u5141\u8bb8\u591a\u9009\u3002", (String)"SupplierInvitationList_126", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean hasPermission = PermissionHepler.checkPermission("BIDINVITE002", orgId, appId, appId + "_supplierinvitation");
                if (!hasPermission) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u9080\u8bf7\u51fd\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"SupplierInvitationList_127", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setCustomParam("bidProjectPk", bidProject.getPkValue());
                listShowParameter.setBillFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
                listShowParameter.setHasRight(true);
                listShowParameter.setMultiSelect(false);
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd\u5217\u8868", (String)"SupplierInvitationList_16", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"tblagaininvitation")) {
            ListSelectedRowCollection collList2 = ((IListView)this.getView()).getSelectedRows();
            DynamicObject supplierInvitation6 = this.suppInviService.getSupplierInvitationById((Long)collList2.get(0).getPrimaryKeyValue());
            if (supplierInvitation6 != null) {
                boolean existsInvite;
                String checkResult = SupplierInvitationUtil.checkAgainSupplierInvitation(supplierInvitation6);
                if (!StringUtils.isEmpty((CharSequence)checkResult)) {
                    this.getView().showTipNotification(checkResult);
                    args.setCancel(true);
                    return;
                }
                Object bidproject = supplierInvitation6.getDynamicObject("bidproject").getPkValue();
                boolean flag = QueryServiceHelper.exists((String)FormTypeConstants.getFormConstant((String)"supplierinvalid", ((Object)((Object)this)).getClass()), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "!=", (Object)"C")});
                if (flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationList_17", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean exsitBackBid = new ReBackBidUtil(appId).checkBackBidFinished(bidproject);
                if (exsitBackBid) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u529e\u7406\u5b8c\u6210\u7684\u91cd\u65b0\u56de\u6807\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationList_128", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String checkQueryIsProcess = questionClarifyService.checkQueryIsProcess(Long.valueOf(Long.parseLong(bidproject.toString())), appId);
                if (StringUtils.isNotBlank((CharSequence)checkQueryIsProcess)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)checkQueryIsProcess, (String)"SupplierInvitationEdit_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean existFlag = QueryServiceHelper.exists((String)(appId + "_bustalk"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("billstatus", "in", (Object)new String[]{"B", "I"})});
                if (existFlag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationList_129", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject[] bustalks = BusinessDataServiceHelper.load((String)(appId + "_bustalk"), (String)"id,offerstoptime,createtime", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)((Long)bidproject)), new QFilter("openonlinesynergy", "=", (Object)Boolean.TRUE), new QFilter("billstatus", "in", (Object)new String[]{"C"})}, (String)"createtime desc");
                if (bustalks.length > 0 && (existsInvite = QueryServiceHelper.exists((String)(appId + "_negotiate_invite"), (QFilter[])new QFilter[]{new QFilter("bustalkid", "=", (Object)((Long)bustalks[0].getPkValue())), new QFilter("status", "in", (Object)new String[]{"B", "I"})}))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5904\u4e8e\u5ba1\u6279\u4e2d\u7684\u5546\u52a1\u8c08\u5224\u9080\u7ea6\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u589e\u8865\u5165\u56f4\u3002", (String)"SupplierInvitationList_130", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getCustomParams().put("iscopy", Boolean.TRUE);
                parameter.getCustomParams().put("isCopyRelateEntity", Boolean.TRUE);
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.setCaption(ResManager.loadKDString((String)"\u589e\u8865\u5165\u56f4", (String)"SupplierInvitationList_18", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                parameter.setPkId(supplierInvitation6.getPkValue());
                parameter.setCustomParam("sourcebillid", (Object)supplierInvitation6.getLong("id"));
                this.getView().showForm((FormShowParameter)parameter);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit")) {
            ListSelectedRowCollection collList3 = ((IListView)this.getView()).getSelectedRows();
            DynamicObject supplierInvitation7 = this.suppInviService.getSupplierInvitationById((Long)collList3.get(0).getPrimaryKeyValue());
            if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation7)) {
                String tipMessage;
                String checkResult;
                String sourceBillId = supplierInvitation7.getString("sourcebillid");
                if (!StringUtils.isEmpty((CharSequence)sourceBillId) && !StringUtils.isEmpty((CharSequence)(checkResult = SupplierInvitationUtil.checkIsSubmitAudit(sourceBillId, appId)))) {
                    this.getView().showTipNotification(checkResult);
                    args.setCancel(true);
                    return;
                }
                DynamicObject bidProject = supplierInvitation7.getDynamicObject("bidproject");
                if (bidProject != null && !StringUtils.isEmpty((CharSequence)(tipMessage = SupplierInvitationUtil.invalidTipMessage(bidProject.getPkValue(), sourceBillId)))) {
                    RefObject afterConfirm = new RefObject();
                    if (!formOperate.getOption().tryGetVariableValue("audit", afterConfirm)) {
                        args.setCancel(true);
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("audit", (IFormPlugin)this);
                        this.getView().showConfirm(tipMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    }
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"unaudit")) {
            ListSelectedRowCollection collList4 = ((IListView)this.getView()).getSelectedRows();
            DynamicObject supplierInvitation8 = this.suppInviService.getSupplierInvitationById((Long)collList4.get(0).getPrimaryKeyValue());
            if (supplierInvitation8 != null) {
                DynamicObject bidProject;
                if (SupplierInvitationUtil.existAgainSupplierInvitation(supplierInvitation8.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u65b0\u7684\u589e\u8865\u5165\u56f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u539f\u5355\u636e\u3002", (String)"SupplierInvitationList_19", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (SupplierInvitationUtil.isAgainSupplierInvitation(supplierInvitation8) && (bidProject = supplierInvitation8.getDynamicObject("bidproject")) != null && SupplierInvitationUtil.checkAgainSupplierInvitationNextBusiness(bidProject.getPkValue(), supplierInvitation8.getPkValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u4e1a\u52a1\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SupplierInvitationList_20", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"viewhistory") && (supplierInvitation = this.suppInviService.getSupplierInvitationById((Long)(collList = ((IListView)this.getView()).getSelectedRows()).get(0).getPrimaryKeyValue())) != null) {
            DynamicObject bidProject = supplierInvitation.getDynamicObject("bidproject");
            boolean existsHistory = QueryServiceHelper.exists((String)(appId + "_supplierinvitation"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()), new QFilter("bidproject", "=", bidProject.getPkValue())});
            if (!existsHistory) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5386\u53f2\u589e\u8865\u5165\u56f4\u8bb0\u5f55\u3002", (String)"SupplierInvitationList_131", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setCustomParam("bidProjectPk", (Object)bidProject.getPkValue().toString());
            listShowParameter.setMultiSelect(false);
            listShowParameter.setHasRight(true);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u4f9b\u65b9\u5165\u56f4\u8bb0\u5f55", (String)"SupplierInvitationList_22", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if ("bid".equals(appId)) {
                listShowParameter.setBillFormId("bid_supplierinvitation_ls");
            } else {
                listShowParameter.setBillFormId("rebm_supplierinvitatio_ls");
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        formOperate.getOption().setVariableValue("newdelete", "true");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        OperateOption operateOption;
        super.confirmCallBack(messageBoxClosedEvent);
        if ("newdelete".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("newdelete", "true");
            this.getView().invokeOperation("newdelete", operateOption);
        }
        if ("submit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("yqhCheckResult", "1");
            this.getView().invokeOperation("submit");
        }
        if ("audit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("audit", "true");
            this.getView().invokeOperation("audit", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addinvitation")) {
            ListSelectedRow sr = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            this.addInvitation(sr);
            DynamicObjectCollection supplierEntry = this.getModel().getEntryEntity("supplierentry");
            if (supplierEntry != null && supplierEntry.size() > 0) {
                for (int i = 0; i < supplierEntry.size(); ++i) {
                    if (((DynamicObject)supplierEntry.get(i)).getString("invitationstatus").equals("UNSEND")) continue;
                    EntryGrid entryEntityGrid = (EntryGrid)this.getControl("supplierentry");
                    entryEntityGrid.setColumnProperty("supplier", "l", (Object)55);
                }
            }
        }
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"newdelete") && opResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SupplierInvitationList_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            BillList x = (BillList)this.getView().getControl("billlistap");
            x.refresh();
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"audit") && opResult.isSuccess()) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            SendMessageUtil sendMessageUtil = new SendMessageUtil();
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow selectedRow = selectedRows.get(i);
                Long invitationId = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.suppInviService.getSupplierInvitationById(invitationId);
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && opResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public List<String> hasSendInvitation(Object id) {
        ArrayList<String> unsendSupplierEntryList = new ArrayList<String>();
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)((Long)id), (String)"bid_supplierinvitation");
        DynamicObjectCollection bidSectionColl = supplier.getDynamicObjectCollection("bidsection");
        if (bidSectionColl != null && bidSectionColl.size() > 0) {
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObjectCollection supplierEntry = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierentry");
                if (supplierEntry == null || supplierEntry.size() <= 0) continue;
                for (int m = 0; m < supplierEntry.size(); ++m) {
                    if (!((DynamicObject)supplierEntry.get(m)).getString("invitationstatus").equals("UNSEND")) continue;
                    unsendSupplierEntryList.add(((DynamicObject)supplierEntry.get(m)).getString("id"));
                }
            }
        }
        return unsendSupplierEntryList;
    }

    private void addInvitation(ListSelectedRow selectRow) {
        Object supplierInvitationId = selectRow.getPrimaryKeyValue();
        List<String> unsendSupplierEntryList = this.hasSendInvitation(supplierInvitationId);
        Lang lang = RequestContext.get().getLang();
        if (unsendSupplierEntryList != null && unsendSupplierEntryList.size() > 0) {
            QFilter statusFilter;
            QFilter qFilter;
            DynamicObject[] invitationCol;
            String operateName = ResManager.loadKDString((String)"\u53d1\u5e03", (String)"SupplierInvitationList_24", (String)"scm-bid-formplugin", (Object[])new Object[0]);
            DynamicObject supplierInvitation = this.suppInviService.getSupplierInvitationById((Long)supplierInvitationId);
            DynamicObject bidProject = supplierInvitation.getDynamicObject("bidProject");
            Object bidProjectId = null;
            Object invitationId = null;
            if (bidProject != null && (invitationCol = BusinessDataServiceHelper.load((String)KEY_INVITATION, (String)"id,status", (QFilter[])new QFilter[]{qFilter = new QFilter("bidproject.id", "=", bidProjectId = bidProject.getPkValue()), statusFilter = new QFilter("status", "=", (Object)"A")}, (String)"createtime desc")) != null && invitationCol.length > 0) {
                invitationId = invitationCol[0].get("id");
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("supplierInvitationId", supplierInvitationId);
            showParameter.setCustomParam("bidProjectId", bidProjectId);
            showParameter.setCustomParam("unsendSupplierEntryList", unsendSupplierEntryList);
            showParameter.setPkId(invitationId);
            if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
                showParameter.setCaption(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd", (String)"SupplierInvitationList_25", (String)"scm-bid-formplugin", (Object[])new Object[0]) + " " + operateName);
            } else {
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd%1$s", (String)"SupplierInvitationList_125", (String)"scm-bid-formplugin", (Object[])new Object[0]), operateName));
            }
            showParameter.setStatus(invitationId == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void invitationView(ListSelectedRow selectRow) {
        QFilter statusFilter;
        QFilter qFilter;
        DynamicObjectCollection invitationColl;
        Object supplierInvitationId = selectRow.getPrimaryKeyValue();
        String operateName = ResManager.loadKDString((String)"\u67e5\u770b", (String)"SupplierInvitationList_26", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        OperationStatus operateStattus = OperationStatus.VIEW;
        DynamicObject supplierInvitation = this.suppInviService.getSupplierInvitationById((Long)supplierInvitationId);
        DynamicObject bidProject = supplierInvitation.getDynamicObject("bidProject");
        Object bidProjectId = null;
        Object invitationId = null;
        if (bidProject != null && (invitationColl = QueryServiceHelper.query((String)KEY_INVITATION, (String)"id,status", (QFilter[])new QFilter[]{qFilter = new QFilter("bidproject.id", "=", bidProjectId = bidProject.getPkValue()), statusFilter = new QFilter("status", "=", (Object)"B")}, (String)"publishdate desc")) != null && invitationColl.size() > 0) {
            invitationId = ((DynamicObject)invitationColl.get(0)).get("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FormTypeConstants.getFormConstant((String)"invitation", ((Object)((Object)this)).getClass()));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("supplierInvitationId", supplierInvitationId);
        showParameter.setCustomParam("bidProjectId", bidProjectId);
        showParameter.setPkId(invitationId);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9080\u8bf7\u51fd%1$s", (String)"SupplierInvitationList_125", (String)"scm-bid-formplugin", (Object[])new Object[0]), operateName));
        showParameter.setStatus(operateStattus);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String appId = this.getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        this.getView().setVisible(Boolean.valueOf(enable), new String[]{"addinvitation"});
        if (!enable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblagaininvitation"});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columnList = args.getListColumns();
        String appId = this.getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        for (IListColumn item : columnList) {
            String fieldName = item.getListFieldKey();
            if ("supplierenrollqty".equals(fieldName)) {
                item.setVisible(enable ? 63 : 0);
                continue;
            }
            if (!"sourcebillid".equals(fieldName)) continue;
            item.setVisible(0);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider(this));
    }
}

