/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.bidcenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.control.Image;
import kd.bos.list.ListFilterParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.constant.entity.bidcenter.BidCenterConstant;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.util.CommonUtil;
import kd.scm.bid.formplugin.bill.bidcenter.BidCenterEdit;
import kd.scm.bid.formplugin.bill.bidcenter.BidSubCenterJsUtil;
import kd.scm.bid.formplugin.bill.util.BidProjectProcessUtil;

public class BidSubCenterEdit
extends BidCenterEdit {
    public static final String FORMID = "formId";
    public static final String BIDPROJECTID = "biprojectId";
    public static final String TYPE = "type";
    public static final String TYPEFIELDNAME = "typeFieldName";

    @Override
    public void doBidProcessOp(String operateKey) {
        super.doBidProcessOp(operateKey);
        if (this.operateKeyToStepMap().containsKey(operateKey)) {
            this.getModel().setValue("exitmark", (Object)Boolean.FALSE);
            this.openMainFromByBidProcess(operateKey);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (!fieldKey.equals("refreshmark")) {
            super.propertyChanged(e);
        } else {
            ChangeData cd = e.getChangeSet()[0];
            String newVal = cd.getNewValue().toString();
            if (StringUtils.isNotEmpty((CharSequence)newVal)) {
                String opKey = newVal.split("#")[0];
                DynamicObject bidProject = this.getModel().getDataEntity();
                Object bidProjectId = bidProject.getPkValue();
                boolean separateOpen = BidProjectProcessUtil.isSeparateOpen(bidProject = BidProjectProcessUtil.getBidProjectData(bidProjectId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass())));
                if (!separateOpen) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_bidopen_js", "flex_bidopen_sw", "flex_bidevaluation_js", "flex_bidevaluation_sw"});
                    return;
                }
                this.setOrRefreshImagePanel(opKey, bidProject);
            }
        }
    }

    @Override
    public void openMainFromByBidProcess(String operateKey) {
        boolean flag;
        Object projectId = this.getModel().getDataEntity().getPkValue();
        if (projectId == null) {
            super.openMainFromByBidProcess(operateKey);
            return;
        }
        DynamicObject bidProjectData = BidProjectProcessUtil.getBidProjectData(projectId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        boolean separateOpen = BidProjectProcessUtil.isSeparateOpen(bidProjectData);
        if (!separateOpen) {
            super.openMainFromByBidProcess(operateKey);
            return;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put(BIDPROJECTID, projectId);
        String formId = BidCenterConstant.getFormIdByOPKey((String)operateKey, ((Object)((Object)this)).getClass());
        paramsMap.put(FORMID, formId);
        if ("busibidopen".equals(operateKey)) {
            paramsMap.put(TYPE, BidOpenTypeEnum.TECHNICAL.getValue());
            paramsMap.put(TYPEFIELDNAME, "opentype");
            DynamicObject[] techDatas = this.loadDataByFormIdAndType(paramsMap);
            Optional<DynamicObject> first = Arrays.stream(techDatas).filter(data -> !"O".equals(data.getString("billstatus"))).findFirst();
            if (first.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807\u5c1a\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u67e5\u770b\u5546\u52a1\u6807\u3002", (String)"BidSubCenterEdit_5", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("busonlineevaluation".equals(operateKey) || "techonlineevaluation".equals(operateKey)) {
            String qFilter = new QFilter("bidproject", "=", bidProjectData.getPkValue());
            QFilter evalTypeFilter = null;
            if ("busonlineevaluation".equals(operateKey)) {
                evalTypeFilter = new QFilter("evaltype", "=", (Object)"BUSSINESS");
            } else if ("techonlineevaluation".equals(operateKey)) {
                evalTypeFilter = new QFilter("evaltype", "=", (Object)"TECHNICAL");
            }
            qFilter.and(evalTypeFilter);
            if (!this.isBidAdmin()) {
                QFilter proficientFilter = this.getProficientFilter((Long)bidProjectData.getPkValue());
                QFilter directorOrAppraiserFilter = this.getDirectorOrAppraiserFilter((Long)bidProjectData.getPkValue());
                if (directorOrAppraiserFilter != null) {
                    proficientFilter.or(directorOrAppraiserFilter);
                }
                qFilter.and(proficientFilter);
            }
            QFilter statusQFilter = new QFilter("billstatus", "!=", (Object)"XX");
            qFilter.and(statusQFilter);
            DynamicObject[] evalDataArray = BusinessDataServiceHelper.load((String)formId, (String)"id,org,billstatus,evaltype", (QFilter[])new QFilter[]{qFilter});
            if (evalDataArray == null || evalDataArray.length == 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5c1a\u672a\u53d1\u751f%s\u4e1a\u52a1,\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidSubCenterEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.getBillChineseNameByOperation().get(operateKey)));
                return;
            }
            if (evalDataArray.length > 1) {
                String orderBys = "createtime desc";
                ListFilterParameter listFilterParameter = this.getListFilterParameter((QFilter)qFilter, orderBys);
                this.synOpenList(formId, (Long)bidProjectData.getPkValue(), listFilterParameter, operateKey);
            } else {
                DynamicObject evalData = evalDataArray[0];
                this.openMainFrom(formId, evalData.getPkValue(), evalData.getString("billstatus"), operateKey);
            }
            return;
        }
        switch (operateKey) {
            case "techbidopen": {
                paramsMap.put(TYPE, BidOpenTypeEnum.TECHNICAL.getValue());
                paramsMap.put(TYPEFIELDNAME, "opentype");
                break;
            }
            case "busibidopen": {
                paramsMap.put(TYPE, BidOpenTypeEnum.BUSSINESS.getValue());
                paramsMap.put(TYPEFIELDNAME, "opentype");
                break;
            }
            case "techbidevaluation": {
                paramsMap.put(TYPE, BidOpenTypeEnum.TECHNICAL.getValue());
                paramsMap.put(TYPEFIELDNAME, "evaltype");
                break;
            }
            case "busibidevaluation": {
                paramsMap.put(TYPE, BidOpenTypeEnum.BUSSINESS.getValue());
                paramsMap.put(TYPEFIELDNAME, "evaltype");
                break;
            }
            default: {
                super.openMainFromByBidProcess(operateKey);
                return;
            }
        }
        DynamicObject[] datas = this.loadDataByFormIdAndType(paramsMap);
        if (datas == null || datas.length == 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7acb\u9879\u5c1a\u672a\u53d1\u751f%s\u4e1a\u52a1,\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"BidSubCenterEdit_4", (String)"scm-bid-formplugin", (Object[])new Object[0]), this.getBillChineseNameByOperation().get(operateKey)));
            return;
        }
        DynamicObject data2 = null;
        if (datas.length == 1) {
            data2 = datas[0];
        } else {
            Optional<DynamicObject> first = Arrays.stream(datas).filter(item -> Arrays.asList("O", "C").contains(item.getString("billstatus"))).findFirst();
            data2 = first.orElseGet(() -> datas[0]);
        }
        if (("techbidevaluation".equals(operateKey) || "busibidevaluation".equals(operateKey)) && !(flag = this.checkEvaluation(this.getView(), data2.getPkValue(), formId, bidProjectData))) {
            return;
        }
        this.openMainFrom(formId, data2.getPkValue(), data2.getString("billstatus"), operateKey);
    }

    public Map<String, String> getBillChineseNameByOperation() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("techbidopen", ResManager.loadKDString((String)"\u6280\u672f\u6807\u5f00\u6807", (String)"BidSubCenterEdit_0", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        map.put("busibidopen", ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5f00\u6807", (String)"BidSubCenterEdit_1", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        map.put("techbidevaluation", ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807", (String)"BidSubCenterEdit_2", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        map.put("busibidevaluation", ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807", (String)"BidSubCenterEdit_3", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        map.put("techonlineevaluation", ResManager.loadKDString((String)"\u6280\u672f\u6807\u5728\u7ebf\u8bc4\u6807", (String)"BidSubCenterEdit_6", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        map.put("busonlineevaluation", ResManager.loadKDString((String)"\u5546\u52a1\u6807\u5728\u7ebf\u8bc4\u6807", (String)"BidSubCenterEdit_7", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        return map;
    }

    public DynamicObject[] loadDataByFormIdAndType(Map<String, Object> paramsMap) {
        return BusinessDataServiceHelper.load((String)((String)paramsMap.get(FORMID)), (String)String.join((CharSequence)",", "billstatus", "id"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", paramsMap.get(BIDPROJECTID)), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}), new QFilter((String)paramsMap.get(TYPEFIELDNAME), "=", paramsMap.get(TYPE))});
    }

    @Override
    public void controlProcess(String operateKey) {
        super.controlProcess(operateKey);
        Object projectId = this.getModel().getDataEntity().getPkValue();
        if (projectId == null) {
            return;
        }
        DynamicObject bidProjectData = BidProjectProcessUtil.getBidProjectData(projectId, FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        boolean separateOpen = BidProjectProcessUtil.isSeparateOpen(bidProjectData);
        if (!separateOpen) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_bidopen_js", "flex_bidopen_sw", "flex_bidevaluation_js", "flex_bidevaluation_sw", "flex_onbidevaluation_tech", "flex_onbidevaluation_bus"});
            return;
        }
        this.setOrRefreshImagePanel(operateKey, bidProjectData);
    }

    protected void setOrRefreshImagePanel(String operateKey, DynamicObject bidProjectData) {
        Set<String> hasPermBillSet = BidProjectProcessUtil.hasPermissionEntityBill(bidProjectData);
        if (this.isBidAdmin()) {
            hasPermBillSet = BidProjectProcessUtil.allHasPermissionEntityBill(bidProjectData);
        }
        if (hasPermBillSet.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_bidopen_js", "flex_bidopen_sw", "flex_bidevaluation_js", "flex_bidevaluation_sw", "flex_onbidevaluation_tech", "flex_onbidevaluation_bus"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_bidopen", "flex_bidevaluation", "flex_onbidevaluation"});
        Map allMetaDataMap = BidSubCenterJsUtil.getAllMetaDataMap();
        Set<String> finalHasPermBillSet = hasPermBillSet;
        allMetaDataMap.forEach((key, value) -> {
            if (!finalHasPermBillSet.contains(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{(String)value.get("panelkey")});
                return;
            }
            boolean exsit = this.exsitCurrentStepData((String)key, bidProjectData.getPkValue());
            Image image = (Image)this.getControl((String)value.get("imagekey"));
            image.setUrl(exsit ? (String)value.get("dataimage") : (String)value.get("nodataimage"));
            Container panel = (Container)this.getControl((String)value.get("panelkey"));
            panel.setBackgroundImg("/icons/pc/other/blued_bg.png");
        });
        Map mediaMap = (Map)allMetaDataMap.get(this.operateKeyToStepMap().get(operateKey));
        if (mediaMap == null) {
            return;
        }
        Container panel = (Container)this.getControl((String)mediaMap.get("panelkey"));
        panel.setBackgroundImg("/icons/pc/other/white_bg.png");
        Image image = (Image)this.getControl((String)mediaMap.get("imagekey"));
        image.setUrl((String)mediaMap.get("clickdataimage"));
    }

    public Map<String, String> operateKeyToStepMap() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("techbidopen", "11");
        map.put("busibidopen", "12");
        map.put("techbidevaluation", "13");
        map.put("busibidevaluation", "14");
        map.put("techonlineevaluation", "13t");
        map.put("busonlineevaluation", "14s");
        return map;
    }

    public boolean exsitCurrentStepData(String step, Object bidprojectId) {
        String formId = null;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(5);
        qFilterList.add(new QFilter("bidproject", "=", bidprojectId));
        qFilterList.add(new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"}));
        switch (step) {
            case "11": {
                formId = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                break;
            }
            case "12": {
                formId = FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                break;
            }
            case "13": {
                formId = FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                break;
            }
            case "14": {
                formId = FormTypeConstants.getFormConstant((String)"bidevaluation", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                break;
            }
            case "13t": {
                formId = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
                if (this.isBidAdmin()) break;
                QFilter qFilter = this.getProficientFilter((Long)bidprojectId);
                QFilter directorOrAppraiserFilter = this.getDirectorOrAppraiserFilter((Long)bidprojectId);
                if (directorOrAppraiserFilter != null) {
                    qFilter.or(directorOrAppraiserFilter);
                }
                qFilterList.add(qFilter);
                break;
            }
            case "14s": {
                formId = FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass());
                qFilterList.add(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
                if (this.isBidAdmin()) break;
                QFilter qFilter = this.getProficientFilter((Long)bidprojectId);
                QFilter directorOrAppraiserFilter = this.getDirectorOrAppraiserFilter((Long)bidprojectId);
                if (directorOrAppraiserFilter != null) {
                    qFilter.or(directorOrAppraiserFilter);
                }
                qFilterList.add(qFilter);
            }
        }
        return QueryServiceHelper.exists((String)formId, (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    public boolean isBidAdmin() {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        return CommonUtil.isBidAdmin((String)appId, (Long)RequestContext.get().getCurrUserId());
    }

    public String bidAdminRoleId() {
        return "/FFXFSRKI73+";
    }
}

