/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.clarify;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.QuestionClarifyServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyReplyStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;
import kd.scm.bid.formplugin.bill.util.PermissionUtils;
import kd.scm.bid.formplugin.bill.util.QuestionClarifyUtil;

public class QuestionClarifyEdit
extends AbstractBillPlugIn {
    protected IQuestionClarifyService questionClarifyService = new QuestionClarifyServiceImpl();
    protected QuestionClarifyUtil questionClarifyUtil = new QuestionClarifyUtil();
    public static final String BAR_SEND = "bar_send";
    public static final String BAR_UNSUBMIT = "bar_unsubmit";
    public static final String BAR_UNCANCEL = "bar_cancel";
    public static final String BAR_SAVE = "bar_save";
    public static final String BAR_SUBMIT = "bar_submit";
    public static final String BTN_IMPORTDATA = "btn_importdata";
    public static final String KEY_IMPORTDATA = "importlatestdata";
    public static final String NEEDCLARIFYINFO_PANEL = "needclarifyinfopanel";
    public static final String SUPCLARIFYINFO_PANEL = "supclarifyinfopanel";

    public void beforeBindData(EventObject e) {
        DynamicObject org;
        DynamicObject project;
        DynamicObject bidProject;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        String billstatus = (String)this.getModel().getValue("billstatus");
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        String bigquestiondescription = dataEntity.getString("bigquestiondescription_tag");
        if (StringUtils.isBlank((CharSequence)bigquestiondescription)) {
            String questiondescription = dataEntity.getString("questiondescription");
            dataEntity.set("bigquestiondescription_tag", (Object)questiondescription);
            this.getView().updateView("bigquestiondescription");
            this.getView().updateView("bigquestiondescription_tag");
        }
        if (enable) {
            if (OperationStatus.VIEW.equals((Object)status) && !StringUtils.equals((CharSequence)ClarifyStatusEnum.CLARIFIED.getValue(), (CharSequence)billstatus) && !StringUtils.equals((CharSequence)ClarifyStatusEnum.INVALID.getValue(), (CharSequence)billstatus) && !StringUtils.equals((CharSequence)ClarifyStatusEnum.INVALIDXX.getValue(), (CharSequence)billstatus)) {
                this.getModel().setValue("tenderprice", null);
                this.getModel().setValue("pricevat", null);
                this.getModel().setValue("tax", null);
                this.getModel().setValue("notaxtenderprice", null);
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SEND, BAR_SAVE, BAR_UNSUBMIT, BAR_SUBMIT});
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d01", (String)"QuestionClarifyEdit_32", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        if (StringUtils.equals((CharSequence)ClarifyStatusEnum.CLARIFIED.getValue(), (CharSequence)billstatus)) {
            BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d02", (String)"QuestionClarifyEdit_33", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            this.setComboEditValuesByBidProjectId(Long.parseLong(bidProject.getPkValue().toString()));
            project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"org");
            org = project.getDynamicObject("org");
            if (org != null) {
                this.getPageCache().put("mianOrgPageCache", org.getPkValue().toString());
            }
        } else if (OperationStatus.ADDNEW.equals((Object)status)) {
            BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d03", (String)"QuestionClarifyEdit_34", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            String opentype = (String)showParameter.getCustomParam("opentype");
            Long bidPrjoctId = Long.parseLong(showParameter.getCustomParam("bidproject").toString());
            this.getModel().setValue("bidproject", (Object)bidPrjoctId);
            this.getModel().setValue("clarifytype", (Object)opentype);
            this.getModel().setValue("opentype", (Object)opentype);
            this.setComboEditValuesByBidProjectId(bidPrjoctId);
            DynamicObject project2 = BusinessDataServiceHelper.loadSingle((Object)bidPrjoctId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"org");
            DynamicObject org2 = project2.getDynamicObject("org");
            if (org2 != null) {
                this.getPageCache().put("mianOrgPageCache", org2.getPkValue().toString());
            }
        } else {
            BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d04", (String)"QuestionClarifyEdit_35", (String)"scm-bid-formplugin", (Object[])new Object[0]));
            bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            this.setComboEditValuesByBidProjectId(Long.parseLong(bidProject.getPkValue().toString()));
            project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"org");
            org = project.getDynamicObject("org");
            if (org != null) {
                this.getPageCache().put("mianOrgPageCache", org.getPkValue().toString());
            }
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d05", (String)"QuestionClarifyEdit_36", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        String orgId = this.getPageCache().get("MainOrgPageCache");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            DynamicObject bos_org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            dataEntity.set("org", (Object)bos_org);
        }
        BigDecimal pricevat = dataEntity.getBigDecimal("pricevat");
        BigDecimal rate = dataEntity.getBigDecimal("rate");
        dataEntity.set("pricevat", (Object)pricevat.multiply(new BigDecimal("100")));
        dataEntity.set("rate", (Object)rate.multiply(new BigDecimal("100")));
        DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
        if (bidSectionColl != null && bidSectionColl.size() > 0) {
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObjectCollection supplierDetailColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d20", (String)"QuestionClarifyEdit_37", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                if (supplierDetailColl == null || supplierDetailColl.size() <= 0) continue;
                for (int m = 0; m < supplierDetailColl.size(); ++m) {
                    ((DynamicObject)supplierDetailColl.get(m)).set("taxrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                    ((DynamicObject)supplierDetailColl.get(m)).set("costrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                    BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d21", (String)"QuestionClarifyEdit_38", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                }
            }
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d22", (String)"QuestionClarifyEdit_39", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        this.getView().updateView("bid_questionclarify");
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d23", (String)"QuestionClarifyEdit_40", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        this.getView().updateView("supplierdetail");
        BizLog.log((String)(ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d24: ", (String)"QuestionClarifyEdit_41", (String)"scm-bid-formplugin", (Object[])new Object[0]) + dataEntity));
        this.getModel().setDataChanged(false);
        super.beforeBindData(e);
    }

    public String getAppId() {
        String appName = this.getView().getFormShowParameter().getServiceAppId();
        return appName;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d25", (String)"QuestionClarifyEdit_42", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        String appId = this.getModel().getDataEntityType().getAppId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BizLog.log((String)(ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d26: ", (String)"QuestionClarifyEdit_43", (String)"scm-bid-formplugin", (Object[])new Object[0]) + appId));
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d06", (String)"QuestionClarifyEdit_44", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("enable", String.valueOf(enable));
        String billstatus = (String)this.getModel().getValue("billstatus");
        IFormView view = this.getView();
        this.ControlBtnByEnable(enable);
        boolean aBoolean = dataEntity.getDynamicObject("bidproject").getBoolean("enablemultisection");
        if (aBoolean) {
            String string = ((DynamicObject)dataEntity.getDynamicObjectCollection("bidsection").get(0)).getString("sectionname");
            dataEntity.set("visisection", (Object)string);
            this.getView().updateView("visisection");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"visisection"});
        }
        String clarifysupplier = dataEntity.getString("clarifysupplier");
        String[] values = clarifysupplier.split("&&");
        String supplierName = values[1];
        dataEntity.set("suppliername", (Object)supplierName);
        String type = dataEntity.getString("opentype");
        long bidOpenId = dataEntity.getLong("bidopenid");
        boolean isDark = BidDarkUtil.isDarkEvaluation((String)appId, (Object)bidOpenId, (String)type);
        this.getView().updateView("suppliername");
        if (isDark) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"suppliername"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"supdarkname"});
        }
        if (!StringUtils.equals((CharSequence)ClarifyStatusEnum.CLARIFIED.getValue(), (CharSequence)billstatus) && (OperationStatus.ADDNEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status))) {
            if (enable) {
                this.getView().setEnable(Boolean.FALSE, new String[]{SUPCLARIFYINFO_PANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{SUPCLARIFYINFO_PANEL});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{SUPCLARIFYINFO_PANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{SUPCLARIFYINFO_PANEL});
                this.setControlMustInput("clarification");
            }
            DynamicObject bidproject = (DynamicObject)this.getModel().getValue("bidproject");
            String bidopentype = bidproject.getString("bidopentype");
            if (!StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidopentype)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"clarifytype"});
            }
        } else if (enable) {
            String replystatus = (String)this.getModel().getValue("replystatus");
            if (ClarifyReplyStatusEnum.A.getValue().equals(replystatus) || StringUtils.isEmpty((CharSequence)replystatus)) {
                view.setVisible(Boolean.FALSE, new String[]{SUPCLARIFYINFO_PANEL});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{SUPCLARIFYINFO_PANEL});
            }
            if (ClarifyStatusEnum.CLARIFIED.getValue().equals(billstatus) || ClarifyStatusEnum.NOCLARIFIED.getValue().equals(billstatus)) {
                view.setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT});
            }
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d07", (String)"QuestionClarifyEdit_45", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        Boolean resubmisstenders = (Boolean)this.getModel().getValue("resubmisstenders");
        if (!resubmisstenders.booleanValue()) {
            this.setVisibleByResubmisstenders(Boolean.FALSE);
        } else {
            String clarifytype = (String)this.getModel().getValue("clarifytype");
            this.setVisibleByClarifytype(clarifytype);
        }
        Boolean LookLock = (Boolean)showParameter.getCustomParam("LookLock");
        if (LookLock != null && LookLock.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SEND, BAR_UNSUBMIT, BAR_SAVE, BAR_SUBMIT, BAR_UNCANCEL, BTN_IMPORTDATA});
        }
        if (StringUtils.equals((CharSequence)ClarifyStatusEnum.CLARIFIED.getValue(), (CharSequence)billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SEND, BAR_UNSUBMIT});
        }
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        String docType = bidProject.getString("doctype");
        if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
            this.getModel().setValue("clarifytype", (Object)docType);
            this.getView().setEnable(Boolean.FALSE, new String[]{"clarifytype"});
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d08", (String)"QuestionClarifyEdit_46", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        this.compareTenderPrice(dataEntity, appId);
        this.getView().updateView("supplierdetail");
    }

    public void ControlBtnByEnable(Boolean enable) {
        if (enable.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SEND, BAR_UNSUBMIT});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_SUBMIT, BTN_IMPORTDATA});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SEND, BAR_UNSUBMIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT, BTN_IMPORTDATA});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("send".equals(operateKey)) {
            String openType;
            long orgId = 0L;
            String orgIdStr = this.getPageCache().get("mianOrgPageCache");
            if (orgIdStr != null) {
                orgId = Long.parseLong(orgIdStr);
            }
            String appId = this.getView().getFormShowParameter().getServiceAppId();
            boolean hasPermission = PermissionUtils.checkPermission("QXX0296", orgId, appId, FormTypeConstants.getFormConstant((String)"onlinebideval", ((Object)((Object)this)).getClass()));
            if (!hasPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"QuestionClarifyEdit_15", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            Long bidprojectId = Long.parseLong(bidProject.getPkValue().toString());
            String notification = this.questionClarifyUtil.checkBidEvalStatusCanSendOrUnSubmmit((Object)bidprojectId, openType = (String)this.getModel().getValue("opentype"), operateKey);
            if (notification != null) {
                this.getView().showTipNotification(notification);
                args.setCancel(true);
                return;
            }
        } else if ("unsubmit".equals(operateKey)) {
            String openType;
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            Long bidprojectId = Long.parseLong(bidProject.getPkValue().toString());
            String notification = this.questionClarifyUtil.checkBidEvalStatusCanSendOrUnSubmmit((Object)bidprojectId, openType = (String)this.getModel().getValue("opentype"), operateKey);
            if (notification != null) {
                this.getView().showTipNotification(notification);
                args.setCancel(true);
                return;
            }
        } else if ("docancel".equals(operateKey)) {
            String status = (String)this.getModel().getValue("billstatus");
            if (!"SUBMITTED".equals(status) && !"CLARIFIED".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4\u5355\u636e\u624d\u80fd\u64a4\u9500\u3002", (String)"QuestionClarifyEdit_47", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            String clarifytype;
            Boolean resubmisstenders = (Boolean)this.getModel().getValue("resubmisstenders");
            if (resubmisstenders.booleanValue() && this.checkAttachMustInputByClarifytype(clarifytype = (String)this.getModel().getValue("clarifytype")).booleanValue()) {
                args.setCancel(true);
                return;
            }
            clarifytype = (String)this.getModel().getValue("clarifytype");
            if (resubmisstenders.booleanValue() && !BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
                DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
                DynamicObject bidProjectdata = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
                int bidtype = bidProjectdata.getInt("bidtype");
                Boolean ismaterialpur = bidProject.getBoolean("ismaterialpur");
                Boolean isratebidding = bidProject.getBoolean("isratebidding");
                String msgPer = ResManager.loadKDString((String)"\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u3002", (String)"QuestionClarifyEdit_17", (String)"scm-bid-formplugin", (Object[])new Object[0]);
                DynamicObjectCollection clarifyBidsection = (DynamicObjectCollection)this.getModel().getValue("bidsection");
                DynamicObjectCollection supplierdetails = ((DynamicObject)clarifyBidsection.get(0)).getDynamicObjectCollection("supplierdetail");
                for (int i = 0; i < supplierdetails.size(); ++i) {
                    BigDecimal taxrate;
                    DynamicObject detail = (DynamicObject)supplierdetails.get(i);
                    String rowTip = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"QuestionClarifyEdit_18", (String)"scm-bid-formplugin", (Object[])new Object[0]), String.valueOf(i + 1));
                    if (isratebidding.booleanValue()) {
                        BigDecimal costrate = detail.getBigDecimal("costrate");
                        if (costrate != null && !(costrate.doubleValue() <= 0.0)) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u8d39\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuestionClarifyEdit_19", (String)"scm-bid-formplugin", (Object[])new Object[0]), msgPer, rowTip));
                        args.setCancel(true);
                        return;
                    }
                    if (bidtype == 1) {
                        BigDecimal inclutaxprice = detail.getBigDecimal("inclutaxprice");
                        if (inclutaxprice == null || inclutaxprice.doubleValue() <= 0.0) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuestionClarifyEdit_20", (String)"scm-bid-formplugin", (Object[])new Object[0]), msgPer, rowTip));
                            args.setCancel(true);
                            return;
                        }
                        taxrate = detail.getBigDecimal("taxrate");
                        if (taxrate != null) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u7a0e\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuestionClarifyEdit_21", (String)"scm-bid-formplugin", (Object[])new Object[0]), msgPer, rowTip));
                        args.setCancel(true);
                        return;
                    }
                    BigDecimal inclutaxamount = detail.getBigDecimal("inclutaxamount");
                    if (inclutaxamount == null || inclutaxamount.doubleValue() <= 0.0) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u542b\u7a0e\u603b\u4ef7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuestionClarifyEdit_22", (String)"scm-bid-formplugin", (Object[])new Object[0]), msgPer, rowTip));
                        args.setCancel(true);
                        return;
                    }
                    taxrate = detail.getBigDecimal("taxrate");
                    if (taxrate != null) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u7a0e\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuestionClarifyEdit_21", (String)"scm-bid-formplugin", (Object[])new Object[0]), msgPer, rowTip));
                    args.setCancel(true);
                    return;
                }
            }
        }
        if (KEY_IMPORTDATA.equals(operateKey)) {
            DynamicObject[] latestDatas;
            String clarifysupplier = (String)this.getModel().getValue("clarifysupplier");
            if (StringUtils.isEmpty((CharSequence)clarifysupplier)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6f84\u6e05\u7684\u4f9b\u5e94\u5546\u3002", (String)"QuestionClarifyEdit_23", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return;
            }
            String[] values = clarifysupplier.split("&&");
            Long supplierId = Long.parseLong(values[0]);
            String clarifySectionName = "";
            if (values.length == 3) {
                clarifySectionName = values[2];
            }
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
            boolean enablemultisection = bidProject.getBoolean("enablemultisection");
            if (enablemultisection) {
                supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + clarifySectionName)));
            }
            QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
            QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI));
            QFilter resubmisstendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
            String orderBys = "submitdate desc";
            int top = 1;
            StringBuilder selectPro = new StringBuilder();
            selectPro.append("id,bidsection,bidsection.sectionname,bidsection.pursupplier,supplierdetail,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate");
            if ("rebm".equals(this.getAppId())) {
                selectPro.append(",supplierdetail.listname,supplierdetail.listnumber,supplierdetail.resourceitem");
                latestDatas = BusinessDataServiceHelper.load((String)"rebm_questionclarify", (String)selectPro.toString(), (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifyTypeFilter, billstatusFilter, resubmisstendersFilter}, (String)orderBys, (int)top);
            } else {
                latestDatas = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)selectPro.toString(), (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifyTypeFilter, billstatusFilter, resubmisstendersFilter}, (String)orderBys, (int)top);
            }
            if (latestDatas.length > 0) {
                DynamicObject latestData = latestDatas[0];
                this.importDataFromlatestData(latestData);
            } else {
                this.importDataFromOpenBid(clarifysupplier, true);
            }
            this.addBillsum();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int m;
        DynamicObjectCollection supplierDetailColl;
        DynamicObjectCollection bidSectionColl;
        BigDecimal rate;
        BigDecimal pricevat;
        DynamicObject dataEntity;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult opResult = e.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if ("send".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
        if ("submit".equals(operateKey)) {
            if (e.getOperationResult().isSuccess()) {
                dataEntity = this.getModel().getDataEntity(true);
                pricevat = dataEntity.getBigDecimal("pricevat");
                rate = dataEntity.getBigDecimal("rate");
                dataEntity.set("pricevat", (Object)pricevat.multiply(new BigDecimal("100")));
                dataEntity.set("rate", (Object)rate.multiply(new BigDecimal("100")));
                bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (int i = 0; i < bidSectionColl.size(); ++i) {
                        supplierDetailColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                        if (supplierDetailColl == null || supplierDetailColl.size() <= 0) continue;
                        for (m = 0; m < supplierDetailColl.size(); ++m) {
                            ((DynamicObject)supplierDetailColl.get(m)).set("taxrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierDetailColl.get(m)).set("costrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                        }
                    }
                }
                this.getView().updateView("bid_questionclarify");
                String appId = this.getAppId();
                this.compareTenderPrice(dataEntity, appId);
                this.getView().updateView("supplierdetail");
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
        } else if ("docancel".equals(operateKey) || "unsubmit".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(operateKey) && e.getOperationResult().isSuccess()) {
            dataEntity = this.getModel().getDataEntity(true);
            pricevat = dataEntity.getBigDecimal("pricevat");
            rate = dataEntity.getBigDecimal("rate");
            dataEntity.set("pricevat", (Object)pricevat.multiply(new BigDecimal("100")));
            dataEntity.set("rate", (Object)rate.multiply(new BigDecimal("100")));
            bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    supplierDetailColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                    if (supplierDetailColl == null || supplierDetailColl.size() <= 0) continue;
                    for (m = 0; m < supplierDetailColl.size(); ++m) {
                        ((DynamicObject)supplierDetailColl.get(m)).set("taxrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                        ((DynamicObject)supplierDetailColl.get(m)).set("costrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                    }
                }
            }
            this.getView().updateView("bid_questionclarify");
            this.getView().updateView("supplierdetail");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String status = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)status, (CharSequence)"UNSENT") || StringUtils.equals((CharSequence)status, (CharSequence)"SAVED") || StringUtils.equals((CharSequence)status, (CharSequence)"SUBMITTED") || StringUtils.equals((CharSequence)status, (CharSequence)"UNCLARIFIED") || StringUtils.equals((CharSequence)status, (CharSequence)"CLARIFIED")) {
            this.getModel().setDataChanged(false);
        }
    }

    public void setVisibleByResubmisstenders(Boolean resubmisstenders) {
        this.getView().setVisible(resubmisstenders, new String[]{"tax", "rate", "pricevat", "tenderprice", "notaxtenderprice", "technicaltenderattach", "businesstenderattach", "procuredetailpanel", "projectmanage", "workday"});
    }

    public void compareTenderPrice(DynamicObject dataEntity, String appId) {
        String openType;
        Date clarifyDate = dataEntity.getDate("submitdate");
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        QFilter projectFilter = new QFilter("bidproject.id", "=", bidProject.getPkValue());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"O");
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d09", (String)"QuestionClarifyEdit_48", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        DynamicObject[] bidOpens = null;
        bidOpens = appId.equals("bid") ? BusinessDataServiceHelper.load((String)"bid_bidopen", (String)String.join((CharSequence)",", "opentype", "bidsection", "supplierentry", "bidsection.sectionname", "bidsection.supplier", "bidsection.supplier_tenderprice", "realbidopendate"), (QFilter[])new QFilter[]{projectFilter, billStatusFilter}, (String)"realbidopendate desc") : BusinessDataServiceHelper.load((String)"rebm_bidopen", (String)String.join((CharSequence)",", "opentype", "bidsection", "supplierentry", "bidsection.sectionname", "bidsection.supplier", "bidsection.supplier_tenderprice", "realbidopendate"), (QFilter[])new QFilter[]{projectFilter, billStatusFilter}, (String)"realbidopendate desc");
        DynamicObject bidOpen = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (bidOpens != null) {
            for (DynamicObject open : bidOpens) {
                Date auditDate = open.getDate("realbidopendate");
                if (clarifyDate == null || auditDate == null || df.format(clarifyDate).compareTo(df.format(auditDate)) <= 0) continue;
                bidOpen = BusinessDataServiceHelper.loadSingle((Object)open.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(appId + "_bidopen")));
                break;
            }
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u8d28\u7591\u5b9a\u4f4d10", (String)"QuestionClarifyEdit_49", (String)"scm-bid-formplugin", (Object[])new Object[0]));
        if (bidOpen != null && (openType = bidOpen.getString("opentype")) != null && !openType.equals("TECHNICAL")) {
            DynamicObjectCollection openSectionEntry = bidOpen.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection clarifySectionEntry = dataEntity.getDynamicObjectCollection("bidsection");
            BigDecimal clarifyTender = dataEntity.getBigDecimal("tenderprice");
            if (clarifyTender != null) {
                HashMap<String, String> ctrl = new HashMap<String, String>(16);
                HashMap<String, HashMap<String, String>> ctrlItem = new HashMap<String, HashMap<String, String>>(16);
                block1: for (DynamicObject clarifySection : clarifySectionEntry) {
                    String clarifySectionName = clarifySection.getString("sectionname");
                    DynamicObjectCollection clarifySupplierEntry = clarifySection.getDynamicObjectCollection("supplierdetail");
                    boolean i = false;
                    for (DynamicObject clarifySupplier : clarifySupplierEntry) {
                        DynamicObject purSupplier = clarifySupplier.getDynamicObject("pursupplier");
                        for (DynamicObject openSection : openSectionEntry) {
                            DynamicObjectCollection openSupplierEntry = openSection.getDynamicObjectCollection("supplierentry");
                            String openSectionName = openSection.getString("sectionname");
                            if (clarifySectionName == null || openSectionName == null || !clarifySectionName.equals(openSectionName)) continue;
                            for (DynamicObject openSupplier : openSupplierEntry) {
                                DynamicObject supplier = openSupplier.getDynamicObject("supplier");
                                BigDecimal openTender = openSupplier.getBigDecimal("supplier_tenderprice");
                                if (!purSupplier.getPkValue().equals(supplier.getPkValue())) continue;
                                if (openTender != null && clarifyTender.compareTo(openTender) > 0) {
                                    ctrl.put("fc", "#ff0000");
                                } else {
                                    ctrl.put("fc", "#000000");
                                }
                                ctrlItem.put("item", ctrl);
                                break block1;
                            }
                        }
                    }
                }
                this.getView().updateControlMetadata("tenderprice", ctrlItem);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        String filedName = e.getProperty().getName();
        String appId = this.getModel().getDataEntityType().getAppId();
        boolean enable = SystemParamHelper.getSystemParameter((String)appId, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"enable");
        if (!enable) {
            if (StringUtils.equals((CharSequence)"resubmisstenders", (CharSequence)filedName)) {
                if (!((Boolean)newVal).booleanValue()) {
                    this.setVisibleByResubmisstenders(Boolean.FALSE);
                } else {
                    String clarifytype = (String)this.getModel().getValue("clarifytype");
                    this.setVisibleByClarifytype(clarifytype);
                }
            } else if (StringUtils.equals((CharSequence)"clarifytype", (CharSequence)filedName)) {
                Boolean resubmisstenders = (Boolean)this.getModel().getValue("resubmisstenders");
                if (!resubmisstenders.booleanValue()) {
                    this.setVisibleByResubmisstenders(Boolean.FALSE);
                } else {
                    this.setVisibleByClarifytype((String)newVal);
                }
            }
            if (StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxprice") || StringUtils.equals((CharSequence)filedName, (CharSequence)"taxrate") || StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxamount")) {
                this.addBillsum();
            }
            if (StringUtils.equals((CharSequence)filedName, (CharSequence)"clarifysupplier")) {
                String clarifysupplier = (String)this.getModel().getValue("clarifysupplier");
                this.importDataFromOpenBid(clarifysupplier, false);
            }
        } else {
            int compareTo;
            Date clarifydeadline;
            if (newVal != null && StringUtils.equals((CharSequence)filedName, (CharSequence)"clarifysupplier")) {
                String clarifysupplier = (String)newVal;
                if (StringUtils.isEmpty((CharSequence)clarifysupplier)) {
                    return;
                }
                DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
                Long bidprojectId = Long.parseLong(bidProject.getPkValue().toString());
                String[] values = clarifysupplier.split("&&");
                Long supplierId = Long.parseLong(values[0]);
                String openType = (String)this.getModel().getValue("opentype");
                Boolean checkRepeatedSupplier = this.questionClarifyService.checkRepeatedSupplier((Object)bidprojectId, openType, (Object)supplierId);
                if (checkRepeatedSupplier.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u53d1\u8d77\u65b0\u7684\u6f84\u6e05\u3002", (String)"QuestionClarifyEdit_26", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("clarifysupplier", null);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)"clarifydeadline", (CharSequence)filedName)) {
                if (newVal != null) {
                    Date nowDate = new Date();
                    int compareTo2 = nowDate.compareTo((Date)newVal);
                    if (compareTo2 >= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4\u3002", (String)"QuestionClarifyEdit_27", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("clarifydeadline", null);
                        return;
                    }
                    Date initiationtime = (Date)this.getModel().getValue("initiationtime");
                    if (initiationtime != null && (compareTo2 = initiationtime.compareTo((Date)newVal)) >= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5fc5\u987b\u665a\u4e8e\u6f84\u6e05\u53d1\u8d77\u65f6\u95f4\u3002", (String)"QuestionClarifyEdit_28", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("clarifydeadline", null);
                        return;
                    }
                }
            } else if (StringUtils.equals((CharSequence)"initiationtime", (CharSequence)filedName) && newVal != null && (clarifydeadline = (Date)this.getModel().getValue("clarifydeadline")) != null && (compareTo = clarifydeadline.compareTo((Date)newVal)) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u53d1\u8d77\u65f6\u95f4\u201d\u5fc5\u987b\u65e9\u4e8e\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u3002", (String)"QuestionClarifyEdit_29", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("initiationtime", null);
                return;
            }
        }
    }

    public void addBillsum() {
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection detailEntryCols = ((DynamicObject)bidSectionEntry.get(0)).getDynamicObjectCollection("supplierdetail");
        BigDecimal sumInclutaxprice = BigDecimal.ZERO;
        BigDecimal sumtaxrate = BigDecimal.ZERO;
        BigDecimal sumtaxamount = BigDecimal.ZERO;
        BigDecimal sumexcepttaxamount = BigDecimal.ZERO;
        for (DynamicObject supplierdetailcol : detailEntryCols) {
            BigDecimal singleInclutaxprice = supplierdetailcol.getBigDecimal("inclutaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("inclutaxamount");
            BigDecimal singletaxamount = supplierdetailcol.getBigDecimal("taxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("taxamount");
            BigDecimal singleexcepttaxamount = supplierdetailcol.getBigDecimal("excepttaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("excepttaxamount");
            sumInclutaxprice = sumInclutaxprice.add(singleInclutaxprice);
            sumtaxamount = sumtaxamount.add(singletaxamount);
            sumexcepttaxamount = sumexcepttaxamount.add(singleexcepttaxamount);
        }
        if (sumexcepttaxamount.intValue() == 0) {
            return;
        }
        sumtaxamount = sumtaxamount.setScale(6);
        sumtaxrate = sumtaxamount.divide(sumexcepttaxamount, 4, 4);
        this.getModel().setValue("tenderprice", (Object)sumInclutaxprice);
        this.getModel().setValue("pricevat", (Object)sumtaxrate);
        this.getModel().setValue("tax", (Object)sumtaxamount);
        this.getModel().setValue("notaxtenderprice", (Object)sumexcepttaxamount);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal rate = dataEntity.getBigDecimal("rate");
        if (detailEntryCols.size() == 1) {
            sumtaxrate = ((DynamicObject)detailEntryCols.get(0)).getBigDecimal("taxrate");
            dataEntity.set("pricevat", (Object)sumtaxrate);
        } else {
            dataEntity.set("pricevat", (Object)sumtaxrate.multiply(new BigDecimal("100")));
        }
        dataEntity.set("rate", (Object)rate.multiply(new BigDecimal("100")));
        this.getView().updateView("pricevat");
        this.getView().updateView("rate");
    }

    public void setVisibleByClarifytype(String clarifytype) {
        IFormView view = this.getView();
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
            view.setVisible(Boolean.FALSE, new String[]{"tax", "rate", "pricevat", "tenderprice", "notaxtenderprice", "projectmanage", "workday"});
            view.setVisible(Boolean.TRUE, new String[]{"technicaltenderattach"});
            view.setVisible(Boolean.FALSE, new String[]{"businesstenderattach", "procuredetailpanel"});
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(clarifytype)) {
            view.setVisible(Boolean.FALSE, new String[]{"technicaltenderattach"});
            view.setVisible(Boolean.TRUE, new String[]{"businesstenderattach", "procuredetailpanel"});
            this.setVisibleByMaterialpurAndRate();
        } else if (BidOpenTypeEnum.MULTI.getValue().equals(clarifytype)) {
            view.setVisible(Boolean.TRUE, new String[]{"technicaltenderattach", "businesstenderattach", "procuredetailpanel"});
            this.setVisibleByMaterialpurAndRate();
        }
    }

    public Boolean checkAttachMustInputByClarifytype(String clarifytype) {
        IFormView view = this.getView();
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
            Boolean checkflag = this.checkAttachMustInput("techattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"QuestionClarifyEdit_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(clarifytype)) {
            Boolean checkflag = this.checkAttachMustInput("commercattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"QuestionClarifyEdit_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
        } else if (BidOpenTypeEnum.MULTI.getValue().equals(clarifytype)) {
            Boolean checkflag = this.checkAttachMustInput("techattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"QuestionClarifyEdit_30", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
            checkflag = this.checkAttachMustInput("commercattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"QuestionClarifyEdit_31", (String)"scm-bid-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Boolean checkAttachMustInput(String attachmentpanelName) {
        JSONArray attachment;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pk = dataEntity.getPkValue();
        String key = "TampAttCache" + this.getView().getPageId();
        String xObject = this.getPageCache().get(key);
        JSONObject attObject = null;
        String formID = "bid_questionclarify";
        String appName = this.getAppId();
        if ("rebm".equals(appName)) {
            formID = "rebm_questionclarify";
        }
        List attachmentList = AttachmentServiceHelper.getAttachments((String)formID, (Object)pk, (String)attachmentpanelName);
        if (xObject != null ? ((attachment = (JSONArray)(attObject = (JSONObject)JSONArray.parse((String)this.getPageCache().get(key))).get((Object)attachmentpanelName)) != null ? attachment.isEmpty() && attachmentList.isEmpty() : attObject.get((Object)attachmentpanelName) == null && attachmentList.isEmpty()) : attachmentList.isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setVisibleByMaterialpurAndRate() {
        IFormView view = this.getView();
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        DynamicObject bidProjectData = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project");
        int bidtype = bidProjectData.getInt("bidtype");
        Boolean ismaterialpur = bidProject.getBoolean("ismaterialpur");
        Boolean isratebidding = bidProject.getBoolean("isratebidding");
        if (bidtype == 1 || bidtype == 2) {
            view.setVisible(Boolean.TRUE, new String[]{"tenderprice", "tax", "pricevat", "notaxtenderprice"});
            this.setControlMustInput("tenderprice,tax,pricevat,notaxtenderprice");
            view.setVisible(Boolean.FALSE, new String[]{"rate", "projectmanage", "workday"});
            view.setVisible(Boolean.TRUE, new String[]{"materialid", "materialname", "model", "unit", "baseunit", "materialdes", "qty", "inclutaxprice"});
            if (bidtype == 2) {
                view.setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "sourcemodel", "sourceunit"});
            }
            view.setVisible(Boolean.FALSE, new String[]{"purentrycontent", "costrate"});
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("supplierdetail");
            entryEntityGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
            this.setControlMustInput("inclutaxprice,taxrate");
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit", "baseunit", "materialdes", "qty", "inclutaxprice", "bd_taxrate"});
            view.setVisible(Boolean.TRUE, new String[]{"projectmanage", "workday"});
            view.setVisible(Boolean.TRUE, new String[]{"purentrycontent"});
            if (isratebidding.booleanValue()) {
                view.setVisible(Boolean.FALSE, new String[]{"tenderprice", "tax", "pricevat", "notaxtenderprice"});
                view.setVisible(Boolean.TRUE, new String[]{"rate"});
                view.setVisible(Boolean.FALSE, new String[]{"purentrycontent", "inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
                view.setVisible(Boolean.TRUE, new String[]{"costrate"});
                this.setControlMustInput("costrate,rate");
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"tenderprice", "pricevat", "tax", "notaxtenderprice"});
                this.setControlMustInput("tenderprice,tax,pricevat,notaxtenderprice");
                view.setVisible(Boolean.FALSE, new String[]{"rate"});
                view.setVisible(Boolean.TRUE, new String[]{"purentrycontent", "inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
                this.setControlMustInput("inclutaxamount,taxrate");
                view.setVisible(Boolean.FALSE, new String[]{"costrate"});
            }
        }
    }

    public void setControlMustInput(String arg0) {
        String[] arr;
        for (String thisArg : arr = arg0.split(",")) {
            FieldEdit purTypeControl = (FieldEdit)this.getView().getControl(thisArg);
            purTypeControl.setMustInput(true);
        }
    }

    public void setComboEditValuesByBidProjectId(Long bidPrjoctId) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("clarifysupplier");
        ArrayList<ComboItem> modelItems = new ArrayList<ComboItem>();
        String openType = (String)this.getModel().getValue("opentype");
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_istender,supplierentry.supplier_isinvalid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidPrjoctId), openTypeFilter});
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            String sectionname = "";
            if (enablemultisection) {
                sectionname = bidsection.getString("sectionname");
            }
            DynamicObjectCollection suppliereEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < suppliereEntryColl.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)suppliereEntryColl.get(j);
                Boolean istender = supplierentry.getBoolean("supplier_istender");
                Boolean isinvalid = supplierentry.getBoolean("supplier_isinvalid");
                if (!istender.booleanValue() || isinvalid.booleanValue()) continue;
                DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                String supplierName = supplier.getString("name");
                String supplierId = supplier.getPkValue().toString();
                LocaleString caption = null;
                caption = enablemultisection ? new LocaleString(supplierName + "(" + sectionname + ")") : new LocaleString(supplierName);
                String value = supplierId + "&&" + supplierName + "&&" + sectionname;
                modelItems.add(new ComboItem(caption, value));
            }
        }
        comboEdit.setComboItems(modelItems);
    }

    public void importDataFromlatestData(DynamicObject latestData) {
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
        bidSectionEntry.clear();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection bidsectioncoll = latestData.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
            int index = model.createNewEntryRow("bidsection");
            model.setValue("sectionname", (Object)bidsection.getString("sectionname"), index);
            for (int j = 0; j < supplierDetail.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                model.setEntryCurrentRowIndex("bidsection", index);
                int supplierdetailIndex = model.createNewEntryRow("supplierdetail");
                model.setValue("pursupplier", supplierentry.get("pursupplier"), supplierdetailIndex);
                model.setValue("purentrycontent", supplierentry.get("purentrycontent"), supplierdetailIndex);
                model.setValue("materialid", supplierentry.get("materialid"), supplierdetailIndex);
                model.setValue("purentryproject", supplierentry.get("purentryproject"), supplierdetailIndex);
                model.setValue("materialdes", supplierentry.get("materialdes"), supplierdetailIndex);
                model.setValue("qty", supplierentry.get("qty"), supplierdetailIndex);
                model.setValue("inclutaxprice", supplierentry.get("inclutaxprice"), supplierdetailIndex);
                model.setValue("inclutaxamount", supplierentry.get("inclutaxamount"), supplierdetailIndex);
                model.setValue("taxamount", supplierentry.get("taxamount"), supplierdetailIndex);
                model.setValue("excepttaxamount", supplierentry.get("excepttaxamount"), supplierdetailIndex);
                model.setValue("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal(100)), supplierdetailIndex);
                model.setValue("costrate", (Object)supplierentry.getBigDecimal("costrate").multiply(new BigDecimal(100)), supplierdetailIndex);
                if (!StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId())) continue;
                model.setValue("listnumber", supplierentry.get("listnumber"), supplierdetailIndex);
                model.setValue("listname", supplierentry.get("listname"), supplierdetailIndex);
                model.setValue("resourceitem", supplierentry.get("resourceitem"), supplierdetailIndex);
            }
        }
        model.endInit();
        this.getView().updateView("supplierdetail");
    }

    public void importDataFromOpenBid(String clarifysupplier, boolean isAddOriginalAmount) {
        DynamicObject bidOpen;
        String[] values = clarifysupplier.split("&&");
        Long supplierId = Long.parseLong(values[0]);
        String clarifySectionName = "";
        if (values.length == 3) {
            clarifySectionName = values[2];
        }
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        String opentype = dataentity.getString("opentype");
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)opentype);
        StringBuilder selectPro = new StringBuilder();
        selectPro.append("id,bidsection,bidsection.sectionname,bidsection.pursupplier,supplierdetail,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate");
        if ("rebm".equals(this.getAppId())) {
            selectPro.append(",supplierdetail.listname,supplierdetail.listnumber,supplierdetail.resourceitem");
            bidOpen = BusinessDataServiceHelper.loadSingle((String)"rebm_bidopen", (String)selectPro.toString(), (QFilter[])new QFilter[]{bidProjectFilter, openTypeFilter});
        } else {
            bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)selectPro.toString(), (QFilter[])new QFilter[]{bidProjectFilter, openTypeFilter});
        }
        DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
        bidSectionEntry.clear();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            String sectionName = bidsection.getString("sectionname");
            if (enablemultisection && !clarifySectionName.equals(sectionName)) continue;
            DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
            int index = model.createNewEntryRow("bidsection");
            model.setValue("sectionname", (Object)sectionName, index);
            for (int j = 0; j < supplierDetail.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                if (!supplierId.equals(((DynamicObject)supplierDetail.get(j)).getDynamicObject("pursupplier").getPkValue())) continue;
                model.setEntryCurrentRowIndex("bidsection", index);
                int supplierdetailIndex = model.createNewEntryRow("supplierdetail");
                model.setValue("pursupplier", supplierentry.get("pursupplier"), supplierdetailIndex);
                model.setValue("purentrycontent", supplierentry.get("purentrycontent"), supplierdetailIndex);
                model.setValue("materialid", supplierentry.get("materialid"), supplierdetailIndex);
                model.setValue("purentryproject", supplierentry.get("purentryproject"), supplierdetailIndex);
                model.setValue("materialdes", supplierentry.get("materialdes"), supplierdetailIndex);
                model.setValue("qty", supplierentry.get("qty"), supplierdetailIndex);
                if (StringUtils.equals((CharSequence)"rebm", (CharSequence)this.getAppId())) {
                    model.setValue("listnumber", supplierentry.get("listnumber"), supplierdetailIndex);
                    model.setValue("listname", supplierentry.get("listname"), supplierdetailIndex);
                    model.setValue("resourceitem", supplierentry.get("resourceitem"), supplierdetailIndex);
                }
                if (!isAddOriginalAmount) continue;
                model.setValue("inclutaxprice", supplierentry.get("inclutaxprice"), supplierdetailIndex);
                model.setValue("inclutaxamount", supplierentry.get("inclutaxamount"), supplierdetailIndex);
                model.setValue("taxamount", supplierentry.get("taxamount"), supplierdetailIndex);
                model.setValue("excepttaxamount", supplierentry.get("excepttaxamount"), supplierdetailIndex);
                model.setValue("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal("100")), supplierdetailIndex);
                model.setValue("costrate", (Object)supplierentry.getBigDecimal("costrate").multiply(new BigDecimal("100")), supplierdetailIndex);
            }
        }
        model.endInit();
        this.getView().updateView("bidsection");
        this.getView().updateView("supplierdetail");
    }
}

