/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.formplugin.bill.util;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.common.constant.entity.BidEvaluationConstant;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.util.BidDarkUtil;

public class ExpertGradingUtil {
    protected IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();
    protected BidEvaluationConstant bidEvaluationConstant = new BidEvaluationConstant();

    public EntryAp createDynamicExpertGradingAp(Long bidEvaluationId, Long sectionId, boolean isOnlineEval) {
        EntryAp expertGradingAp = new EntryAp();
        expertGradingAp.setKey("expertGradAp");
        expertGradingAp.setShowSeq(true);
        this.createProfIdFieldAp(expertGradingAp);
        this.createProfNameFieldAp(expertGradingAp);
        this.createMajorTypeFieldAp(expertGradingAp);
        this.createIsTechnicalFieldAp(expertGradingAp);
        this.createIsCommercialFieldAp(expertGradingAp);
        this.createSupplierFieldAp(expertGradingAp, bidEvaluationId, sectionId, isOnlineEval);
        return expertGradingAp;
    }

    public EntryAp createDynamicExpertGradingAp(Long bidEvaluationId, Long sectionId, boolean isOnlineEval, String evalType) {
        EntryAp expertGradingAp = new EntryAp();
        expertGradingAp.setKey("expertGradAp");
        expertGradingAp.setShowSeq(true);
        this.createProfIdFieldAp(expertGradingAp);
        this.createProfNameFieldAp(expertGradingAp);
        this.createMajorTypeFieldAp(expertGradingAp);
        this.createIsTechnicalFieldAp(expertGradingAp);
        this.createIsCommercialFieldAp(expertGradingAp);
        this.createSupplierFieldAp(expertGradingAp, bidEvaluationId, sectionId, isOnlineEval, evalType);
        return expertGradingAp;
    }

    protected void createProfIdFieldAp(EntryAp expertGradingAp) {
        EntryFieldAp profIdFieldAp = new EntryFieldAp();
        profIdFieldAp.setId("proficientid");
        profIdFieldAp.setKey("proficientid");
        profIdFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameProficientId()));
        profIdFieldAp.setLock("new,edit,view,submit,audit");
        profIdFieldAp.setVisible("");
        BigIntField profIdField = new BigIntField();
        profIdField.setId("proficientid");
        profIdField.setKey("proficientid");
        profIdFieldAp.setField((Field)profIdField);
        expertGradingAp.getItems().add(profIdFieldAp);
    }

    protected void createProfNameFieldAp(EntryAp expertGradingAp) {
        EntryFieldAp profNameFieldAp = new EntryFieldAp();
        profNameFieldAp.setId("proficientname");
        profNameFieldAp.setKey("proficientname");
        profNameFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameProficientName()));
        profNameFieldAp.setLock("new,edit,view,submit,audit");
        TextField profNameField = new TextField();
        profNameField.setId("proficientname");
        profNameField.setKey("proficientname");
        profNameFieldAp.setField((Field)profNameField);
        expertGradingAp.getItems().add(profNameFieldAp);
    }

    public void createMajorTypeFieldAp(EntryAp expertGradingAp) {
        EntryFieldAp majorTypeFieldAp = new EntryFieldAp();
        majorTypeFieldAp.setId("majortypenames");
        majorTypeFieldAp.setKey("majortypenames");
        majorTypeFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameMagorType()));
        majorTypeFieldAp.setLock("new,edit,view,submit,audit");
        TextField majorTypeField = new TextField();
        majorTypeField.setId("majortypenames");
        majorTypeField.setKey("majortypenames");
        majorTypeFieldAp.setField((Field)majorTypeField);
        expertGradingAp.getItems().add(majorTypeFieldAp);
    }

    protected void createIsTechnicalFieldAp(EntryAp expertGradingAp) {
        EntryFieldAp isTechnicalFieldAp = new EntryFieldAp();
        isTechnicalFieldAp.setId("istechnical");
        isTechnicalFieldAp.setKey("istechnical");
        isTechnicalFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameIsTechnical()));
        isTechnicalFieldAp.setLock("new,edit,view,submit,audit");
        isTechnicalFieldAp.setVisible("");
        CheckBoxField isTechnicalField = new CheckBoxField();
        isTechnicalField.setId("istechnical");
        isTechnicalField.setKey("istechnical");
        isTechnicalFieldAp.setField((Field)isTechnicalField);
        expertGradingAp.getItems().add(isTechnicalFieldAp);
    }

    protected void createIsCommercialFieldAp(EntryAp expertGradingAp) {
        EntryFieldAp isCommercialFieldAp = new EntryFieldAp();
        isCommercialFieldAp.setId("iscommercial");
        isCommercialFieldAp.setKey("iscommercial");
        isCommercialFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameIsCommercial()));
        isCommercialFieldAp.setLock("new,edit,view,submit,audit");
        isCommercialFieldAp.setVisible("");
        CheckBoxField isCommercialField = new CheckBoxField();
        isCommercialField.setId("iscommercial");
        isCommercialField.setKey("iscommercial");
        isCommercialFieldAp.setField((Field)isCommercialField);
        expertGradingAp.getItems().add(isCommercialFieldAp);
    }

    public void createSupplierFieldAp(EntryAp expertGradingAp, Long bidEvaluationId, Long sectionId, boolean isOnlineEval) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name,score,section.sectionname";
        Table<String, Object, String> darkTable = this.getDarkTable(bidEvaluationId);
        DynamicObjectCollection bidEvaluationEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(sectionId, selectFields);
        for (int i = 0; i < bidEvaluationEntryColl.size(); ++i) {
            String darkName;
            DynamicObject bidEvaluationEntry = (DynamicObject)bidEvaluationEntryColl.get(i);
            String bidsectionName = bidEvaluationEntry.getString("section.sectionname");
            Long supplierId = bidEvaluationEntry.getLong("supplier.id");
            String supplierName = bidEvaluationEntry.getString("supplier.name");
            String supplierNumber = bidEvaluationEntry.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String supplierGroupKey = "supplier_" + supplierNumber;
            String supplierIdKey = "supplierid_" + supplierNumber;
            String technicalKey = "technical_" + supplierNumber;
            String commercialKey = "commercial_" + supplierNumber;
            EntryFieldAp supplierIdFieldAp = new EntryFieldAp();
            supplierIdFieldAp.setId(supplierIdKey);
            supplierIdFieldAp.setKey(supplierIdKey);
            supplierIdFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameSupplierId()));
            supplierIdFieldAp.setLock("new,edit,view,submit,audit");
            supplierIdFieldAp.setVisible("");
            BigIntField supplierIdField = new BigIntField();
            supplierIdField.setId(supplierIdKey);
            supplierIdField.setKey(supplierIdKey);
            supplierIdFieldAp.setField((Field)supplierIdField);
            EntryFieldAp technicalFieldAp = new EntryFieldAp();
            technicalFieldAp.setId(technicalKey);
            technicalFieldAp.setKey(technicalKey);
            technicalFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameTechnical()));
            technicalFieldAp.setFireUpdEvt(true);
            technicalFieldAp.setLock("new,view,submit,audit");
            technicalFieldAp.setBackColor("#ffffff");
            technicalFieldAp.setWidth(new LocaleString("300px"));
            technicalFieldAp.setTextAlign("center");
            DecimalField technicalField = new DecimalField();
            technicalField.setId(technicalKey);
            technicalField.setKey(technicalKey);
            technicalField.setScale(2);
            technicalField.setDataScope("[0,100]");
            technicalFieldAp.setField((Field)technicalField);
            EntryFieldAp commercialFieldAp = new EntryFieldAp();
            commercialFieldAp.setId(commercialKey);
            commercialFieldAp.setKey(commercialKey);
            commercialFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameCommercial()));
            commercialFieldAp.setFireUpdEvt(true);
            commercialFieldAp.setLock("new,view,submit,audit");
            commercialFieldAp.setBackColor("#ffffff");
            commercialFieldAp.setWidth(new LocaleString("300px"));
            commercialFieldAp.setTextAlign("center");
            DecimalField commercialField = new DecimalField();
            commercialField.setId(commercialKey);
            commercialField.setKey(commercialKey);
            commercialField.setScale(2);
            commercialField.setDataScope("[0,100]");
            commercialFieldAp.setField((Field)commercialField);
            EntryFieldGroupAp supplierFieldGroupAp = new EntryFieldGroupAp();
            supplierFieldGroupAp.setId(supplierGroupKey);
            supplierFieldGroupAp.setKey(supplierGroupKey);
            String showName = supplierName;
            if (darkTable != null && StringUtils.isNotEmpty((CharSequence)(darkName = (String)darkTable.get((Object)bidsectionName, (Object)supplierId)))) {
                showName = darkName;
            }
            supplierFieldGroupAp.setName(new LocaleString(showName));
            supplierFieldGroupAp.getItems().add(supplierIdFieldAp);
            supplierFieldGroupAp.getItems().add(technicalFieldAp);
            supplierFieldGroupAp.getItems().add(commercialFieldAp);
            expertGradingAp.getItems().add(supplierFieldGroupAp);
        }
    }

    public Table<String, Object, String> getDarkTable(Long bidEvaluationId) {
        QFilter qFilter = new QFilter("id", "=", (Object)bidEvaluationId);
        DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"entitytypeid, bidopenid, evaltype", (QFilter[])qFilter.toArray());
        String appId = "bid";
        Long openId = bidEvaluation.getLong("bidopenid");
        String evaltype = bidEvaluation.getString("evaltype");
        if (bidEvaluation.getString("entitytypeid").startsWith("rebm_")) {
            appId = "rebm";
        }
        if (BidDarkUtil.isDarkEvaluation((String)appId, (Object)openId, (String)evaltype)) {
            Table darkTable = BidDarkUtil.getEvaluationDarkByEvaluationId((String)appId, (Object)bidEvaluationId);
            return darkTable;
        }
        return null;
    }

    public void createSupplierFieldAp(EntryAp expertGradingAp, Long bidEvaluationId, Long sectionId, boolean isOnlineEval, String evalType) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name,score, section.sectionname";
        DynamicObjectCollection bidEvaluationEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(sectionId, selectFields);
        Table<String, Object, String> darkTable = this.getDarkTable(bidEvaluationId);
        for (int i = 0; i < bidEvaluationEntryColl.size(); ++i) {
            String darkName;
            DynamicObject bidEvaluationEntry = (DynamicObject)bidEvaluationEntryColl.get(i);
            String bidsectionName = bidEvaluationEntry.getString("section.sectionname");
            Long supplierId = bidEvaluationEntry.getLong("supplier.id");
            String supplierName = bidEvaluationEntry.getString("supplier.name");
            String supplierNumber = bidEvaluationEntry.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String supplierGroupKey = "supplier_" + supplierNumber;
            String supplierIdKey = "supplierid_" + supplierNumber;
            String technicalKey = "technical_" + supplierNumber;
            String commercialKey = "commercial_" + supplierNumber;
            EntryFieldAp supplierIdFieldAp = new EntryFieldAp();
            supplierIdFieldAp.setId(supplierIdKey);
            supplierIdFieldAp.setKey(supplierIdKey);
            supplierIdFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameSupplierId()));
            supplierIdFieldAp.setLock("new,edit,view,submit,audit");
            supplierIdFieldAp.setVisible("");
            BigIntField supplierIdField = new BigIntField();
            supplierIdField.setId(supplierIdKey);
            supplierIdField.setKey(supplierIdKey);
            supplierIdFieldAp.setField((Field)supplierIdField);
            EntryFieldGroupAp supplierFieldGroupAp = new EntryFieldGroupAp();
            supplierFieldGroupAp.setId(supplierGroupKey);
            supplierFieldGroupAp.setKey(supplierGroupKey);
            String showName = supplierName;
            if (darkTable != null && StringUtils.isNotEmpty((CharSequence)(darkName = (String)darkTable.get((Object)bidsectionName, (Object)supplierId)))) {
                showName = darkName;
            }
            supplierFieldGroupAp.setName(new LocaleString(showName));
            supplierFieldGroupAp.getItems().add(supplierIdFieldAp);
            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.TECHNICAL.getValue(), (CharSequence)evalType)) {
                EntryFieldAp technicalFieldAp = new EntryFieldAp();
                technicalFieldAp.setId(technicalKey);
                technicalFieldAp.setKey(technicalKey);
                technicalFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameTechnical()));
                technicalFieldAp.setFireUpdEvt(true);
                technicalFieldAp.setLock("new,view,submit,audit");
                technicalFieldAp.setBackColor("#ffffff");
                technicalFieldAp.setWidth(new LocaleString("300px"));
                technicalFieldAp.setTextAlign("center");
                DecimalField technicalField = new DecimalField();
                technicalField.setId(technicalKey);
                technicalField.setKey(technicalKey);
                technicalField.setScale(2);
                technicalField.setDataScope("[0,100]");
                technicalFieldAp.setField((Field)technicalField);
                supplierFieldGroupAp.getItems().add(technicalFieldAp);
            }
            if (StringUtils.equals((CharSequence)BidOpenTypeEnum.BUSSINESS.getValue(), (CharSequence)evalType)) {
                EntryFieldAp commercialFieldAp = new EntryFieldAp();
                commercialFieldAp.setId(commercialKey);
                commercialFieldAp.setKey(commercialKey);
                commercialFieldAp.setName(new LocaleString(this.bidEvaluationConstant.getColNameCommercial()));
                commercialFieldAp.setFireUpdEvt(true);
                commercialFieldAp.setLock("new,view,submit,audit");
                commercialFieldAp.setBackColor("#ffffff");
                commercialFieldAp.setWidth(new LocaleString("300px"));
                commercialFieldAp.setTextAlign("center");
                DecimalField commercialField = new DecimalField();
                commercialField.setId(commercialKey);
                commercialField.setKey(commercialKey);
                commercialField.setScale(2);
                commercialField.setDataScope("[0,100]");
                commercialFieldAp.setField((Field)commercialField);
                supplierFieldGroupAp.getItems().add(commercialFieldAp);
            }
            expertGradingAp.getItems().add(supplierFieldGroupAp);
        }
    }

    public void registDynamicProps(MainEntityType newMainType, Long bidEvaluationId, Long sectionId) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("expertgrading");
        this.registProfIdProp(entryType);
        this.registProfNameProp(entryType);
        this.registMajorTypeProp(entryType);
        this.registIsTechnicalProp(entryType);
        this.registIsCommercialProp(entryType);
        this.registSupplierProps(entryType, bidEvaluationId, sectionId);
    }

    protected void registProfIdProp(EntryType entryType) {
        BigIntProp profIdBigIntProp = new BigIntProp();
        profIdBigIntProp.setName("proficientid");
        profIdBigIntProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameProficientId()));
        profIdBigIntProp.setDbIgnore(true);
        profIdBigIntProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)profIdBigIntProp);
    }

    protected void registProfNameProp(EntryType entryType) {
        TextProp profNameTextProp = new TextProp();
        profNameTextProp.setName("proficientname");
        profNameTextProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameProficientName()));
        profNameTextProp.setDbIgnore(true);
        profNameTextProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)profNameTextProp);
    }

    protected void registMajorTypeProp(EntryType entryType) {
        TextProp majorTypeTextProp = new TextProp();
        majorTypeTextProp.setName("majortypenames");
        majorTypeTextProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameMagorType()));
        majorTypeTextProp.setDbIgnore(true);
        majorTypeTextProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)majorTypeTextProp);
    }

    protected void registIsTechnicalProp(EntryType entryType) {
        BooleanProp isTechBooleanProp = new BooleanProp();
        isTechBooleanProp.setName("istechnical");
        isTechBooleanProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameIsTechnical()));
        isTechBooleanProp.setDbIgnore(true);
        isTechBooleanProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)isTechBooleanProp);
    }

    protected void registIsCommercialProp(EntryType entryType) {
        BooleanProp isCommBooleanProp = new BooleanProp();
        isCommBooleanProp.setName("iscommercial");
        isCommBooleanProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameIsCommercial()));
        isCommBooleanProp.setDbIgnore(true);
        isCommBooleanProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)isCommBooleanProp);
    }

    public Set<String> getOutSupplier(Long sectionId) {
        DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id,entitytypeid,bidsection,bidsection.sectionname,bidsection.opensrcsectionid,bidopenid,evaltype", (QFilter[])new QFilter[]{new QFilter("bidsection.id", "=", (Object)sectionId)});
        HashSet<String> outSupplierIdSet = new HashSet<String>();
        String senctionName = "";
        Long bidOpenId = 0L;
        DynamicObject bidEvaluation = bidEvaluations[0];
        DynamicObjectCollection bidsections = bidEvaluation.getDynamicObjectCollection("bidsection");
        bidOpenId = bidEvaluation.getLong("bidopenid");
        for (DynamicObject bidsection : bidsections) {
            if (!StringUtils.equals((CharSequence)sectionId.toString(), (CharSequence)bidsection.getPkValue().toString())) continue;
            senctionName = bidsection.getString("sectionname");
            break;
        }
        String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
        DynamicObject bidOpenDyn = null;
        bidOpenDyn = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)"rebm_bidopen") : BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)"bid_bidopen");
        String evalType = bidEvaluation.getString("evaltype");
        String techEvalResult = ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"ExpertGradingUtil_2", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        String busEvalResult = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"ExpertGradingUtil_3", (String)"scm-bid-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection bidsection_DOC = bidOpenDyn.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection_DO : bidsection_DOC) {
            String bidopSection = bidsection_DO.getString("sectionname");
            if (!StringUtils.equals((CharSequence)bidopSection, (CharSequence)senctionName)) continue;
            DynamicObjectCollection supplierEntry_DOC = bidsection_DO.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry_DO : supplierEntry_DOC) {
                boolean openOutFlag;
                boolean evalOutFlag;
                boolean isTender = supplierEntry_DO.getBoolean("supplier_istender");
                boolean openOut = supplierEntry_DO.getBoolean("supplier_isinvalid");
                boolean evalOut = supplierEntry_DO.getBoolean("evalsupplierinvalid");
                String evalResult = supplierEntry_DO.getString("supplier_invalidreason");
                String supplierId = supplierEntry_DO.getDynamicObject("supplier").getPkValue().toString();
                if ("MULTI".equals(evalType)) {
                    if (!isTender) {
                        outSupplierIdSet.add(supplierId);
                    }
                    if (evalOut || !openOut) continue;
                    outSupplierIdSet.add(supplierId);
                    continue;
                }
                if ("BUSSINESS".equals(evalType)) {
                    if (!isTender) {
                        outSupplierIdSet.add(supplierId);
                        continue;
                    }
                    evalOutFlag = evalOut && openOut && techEvalResult.equals(evalResult);
                    boolean bl = openOutFlag = !evalOut && openOut;
                    if (!evalOutFlag && !openOutFlag) continue;
                    outSupplierIdSet.add(supplierId);
                    continue;
                }
                if (!"TECHNICAL".equals(evalType)) continue;
                if (!isTender) {
                    outSupplierIdSet.add(supplierId);
                    continue;
                }
                evalOutFlag = evalOut && openOut && busEvalResult.equals(evalResult);
                boolean bl = openOutFlag = !evalOut && openOut;
                if (!evalOutFlag && !openOutFlag) continue;
                outSupplierIdSet.add(supplierId);
            }
        }
        return outSupplierIdSet;
    }

    protected void registSupplierProps(EntryType entryType, Long bidEvaluationId, Long sectionId) {
        String selectFields = "id,entryseq,supplier.id,supplier.number,supplier.name,score";
        DynamicObjectCollection bidEvaluationEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(sectionId, selectFields);
        if (bidEvaluationEntryColl == null) {
            return;
        }
        Set<String> outSupplier = this.getOutSupplier(sectionId);
        for (int i = 0; i < bidEvaluationEntryColl.size(); ++i) {
            DynamicObject bidEvaluationEntry = (DynamicObject)bidEvaluationEntryColl.get(i);
            String id = bidEvaluationEntry.get("supplier.id").toString();
            if (outSupplier.contains(id)) continue;
            String supplierNumber = bidEvaluationEntry.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            String supplierIdKey = "supplierid_" + supplierNumber;
            String technicalKey = "technical_" + supplierNumber;
            String commercialKey = "commercial_" + supplierNumber;
            BigIntProp supplierIdBigIntProp = new BigIntProp();
            supplierIdBigIntProp.setName(supplierIdKey);
            supplierIdBigIntProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameSupplierId()));
            supplierIdBigIntProp.setDbIgnore(true);
            supplierIdBigIntProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)supplierIdBigIntProp);
            DecimalProp technicalDecimalProp = new DecimalProp();
            technicalDecimalProp.setName(technicalKey);
            technicalDecimalProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameTechnical()));
            technicalDecimalProp.setDbIgnore(true);
            technicalDecimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)technicalDecimalProp);
            DecimalProp commercialDecimalProp = new DecimalProp();
            commercialDecimalProp.setName(commercialKey);
            commercialDecimalProp.setDisplayName(new LocaleString(this.bidEvaluationConstant.getColNameCommercial()));
            commercialDecimalProp.setDbIgnore(true);
            commercialDecimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)commercialDecimalProp);
        }
    }

    public List<String> getExpertGradingColumnKeys(Long sectionId) {
        List<String> columnKeys = this.getExpertGradingSupplierColumnKeys(sectionId);
        columnKeys.add("proficientid");
        columnKeys.add("proficientname");
        columnKeys.add("majortypenames");
        columnKeys.add("istechnical");
        columnKeys.add("iscommercial");
        return columnKeys;
    }

    public List<String> getExpertGradingSupplierColumnKeys(Long sectionId) {
        String selectFields = "id,entryseq,section.id,supplier.id,supplier.number,supplier.name,score";
        DynamicObjectCollection bidEvaluationEntryColl = this.bidEvaluationService.listBidEvalEntryBySections(sectionId, selectFields);
        ArrayList<String> supplierColumnKeyList = new ArrayList<String>(10);
        for (int i = 0; i < bidEvaluationEntryColl.size(); ++i) {
            DynamicObject bidEvaluationEntry = (DynamicObject)bidEvaluationEntryColl.get(i);
            String supplierNumber = bidEvaluationEntry.getString("supplier.number").toLowerCase();
            supplierNumber = supplierNumber.replace('.', '_');
            supplierColumnKeyList.add("supplierid_" + supplierNumber);
            supplierColumnKeyList.add("technical_" + supplierNumber);
            supplierColumnKeyList.add("commercial_" + supplierNumber);
        }
        return supplierColumnKeyList;
    }
}

