/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.ten.business.basedata.ITenInvitationService;
import kd.scm.ten.business.basedata.serviceImpl.TenInvitationServiceImpl;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenInvitationOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String BTN_CONFIRM = "confirm";
    private static final String ORG = "org";
    private static final String CONTACTS = "contacts";
    private static final String PHONE = "phone";
    private static final String ADDRESS = "address";
    private static final String FAX = "fax";
    private static final String EMAIL = "email";
    private static final String NOTE = "note";
    private static final String INSTRUCTION = "instruction";
    private static final String BIDPROJECT = "bidproject";
    private static final String SUPPLIERENTRY = "supplierentry";
    private static final String BIDENROLLSECTION = "bidsection";
    private List<String> sectionList = new ArrayList<String>();
    private HashMap<String, DynamicObject> projectSectionIDMap = new HashMap();
    private HashMap<Long, DynamicObject> projectSectionMap = new HashMap();
    private ITenInvitationService invitationService = new TenInvitationServiceImpl();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ValidatorRegister());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add(ORG);
        keys.add(CONTACTS);
        keys.add(PHONE);
        keys.add(ADDRESS);
        keys.add(FAX);
        keys.add(EMAIL);
        keys.add(NOTE);
        keys.add(INSTRUCTION);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        DynamicObject currentSupplier = SupplierUtil.getSupplier();
        Set supplierByUser = SupplierUtil.getSupplierPkSet();
        if (StringUtils.equals((CharSequence)BTN_CONFIRM, (CharSequence)key)) {
            BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u201cbeginOperationTransaction\u201d\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\u5f00\u59cb\u3002", (String)"TenInvitationOperationServicePlugin_4", (String)"scm-ten-opplugin", (Object[])new Object[0]));
            DynamicObject data = datas[0];
            Object bidProjectID = data.get(BIDPROJECT);
            DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidProjectID, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            QFilter[] supplierEntryFilter = new QFilter[]{new QFilter("supplierentry.id", "=", (Object)Long.parseLong(data.get(SUPPLIERENTRY).toString())), new QFilter("id", "=", (Object)Long.parseLong(data.get("invitationid").toString()))};
            DynamicObject bidInvitationDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bid_invitation", (String)"id,supplierentry.invitationuser,supplierentry.invitationstatus,publishdate,name,supplierentry.confirmman,supplierentry.confirmdate,supplierentry.supplier", (QFilter[])supplierEntryFilter);
            if (bidInvitationDynamicObject != null) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u6295\u6807\u201cbeginOperationTransaction\u201d\u4f9b\u5e94\u5546\u9080\u8bf7\u51fd\u786e\u8ba4\uff0c\u9080\u8bf7\u51fdid\uff08%s\uff09\u3002", (String)"TenInvitationOperationServicePlugin_5", (String)"scm-ten-opplugin", (Object[])new Object[0]), bidInvitationDynamicObject.getPkValue()));
                DynamicObjectCollection supplierEntryCollection = bidInvitationDynamicObject.getDynamicObjectCollection(SUPPLIERENTRY);
                for (int i = 0; i < supplierEntryCollection.size(); ++i) {
                    DynamicObject tempSupplier = ((DynamicObject)supplierEntryCollection.get(i)).getDynamicObject("supplier");
                    String pk = tempSupplier.getPkValue().toString();
                    if (!supplierByUser.contains(pk)) continue;
                    currentSupplier = tempSupplier;
                    break;
                }
            }
            this.invitationService.acceptInvitation(data, this.sectionList, currentSupplier, this.projectSectionMap);
            this.sendMessage(data.get("invitationid"), currentSupplier, bid_project);
        }
    }

    private boolean isEnd(DynamicObject invitation) {
        int compareTo = 0;
        Date now = new Date();
        Date deadlineDateString = (Date)invitation.get("bidproject.invitationdeadline");
        compareTo = now.compareTo(deadlineDateString);
        return compareTo > 0;
    }

    public void sendMessage(Object invitationId, DynamicObject supplier, DynamicObject bid_project) {
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        msgParam.put("formId", "bid_supplierinvitation");
        msgParam.put("appId", "bid");
        DynamicObject[] tender = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()), (String)"id,entry,entry.sectionname,supplier,entry.projectsection", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)Long.parseLong(bid_project.getPkValue().toString())).and(new QFilter("supplier", "=", (Object)Long.parseLong(supplier.getPkValue().toString())))});
        DynamicObject invitationdata = BusinessDataServiceHelper.loadSingle((Object)invitationId, (String)"bid_invitation");
        DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((Object)invitationdata.getDynamicObject(BIDPROJECT).getPkValue(), (String)"bid_project");
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidproject.getPkValue())}, (String)"createtime desc");
        msgParam.put("id", tender[0].getPkValue());
        msgParam.put("pkId", dynamicObject[0].getPkValue());
        msgParam.put("supplierId", supplier.getPkValue());
        msgParam.put("title", null);
        msgParam.put("operation", "btn_tender");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId"));
        DynamicObjectCollection memberColl = bid_project.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        ArrayList<Long> receiveUserIds = new ArrayList<Long>();
        for (DynamicObject member : memberColl) {
            String[] values = member.getString("respbusiness").split(",");
            if (values != null && values.length > 0) {
                for (int m = 0; m < values.length; ++m) {
                    if (!"02".equals(values[m])) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        if (!memberSet.isEmpty()) {
            for (DynamicObject set : memberSet) {
                receiveUserIds.add(set.getLong("id"));
            }
        }
        msgParam.put("msgentity", TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()));
        msgParam.put("content", null);
        msgParam.put("tplScene", "supagreesec");
        String notifyType = MessageChannelUtil.getNotifyType((String)"supagreesec", (String)"ten_mytender");
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }

    protected String getRejectSectionBySupplierInvitation(DynamicObject dataEntity, DynamicObject currentSupplier) {
        QFilter[] bidProjectFilter = new QFilter[]{new QFilter(BIDPROJECT, "=", (Object)Long.parseLong(dataEntity.get(BIDPROJECT).toString()))};
        DynamicObject bidsupplierinvitationobject = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)"bidsection,bidsection.sectionname,supplierentry,supplierentry.invitationstatus,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.email,supplierentry.address,supplierentry.fax,supplierentry.supplier,supplierentry.invitation", (QFilter[])bidProjectFilter);
        DynamicObjectCollection bidSectionCollection = bidsupplierinvitationobject.getDynamicObjectCollection(BIDENROLLSECTION);
        StringJoiner sectionNameJoiner = new StringJoiner("\u3001");
        bidSectionCollection.stream().forEach(bidSection -> {
            DynamicObjectCollection supplierEntry = bidSection.getDynamicObjectCollection(SUPPLIERENTRY);
            supplierEntry.stream().filter(supplierEntryRow -> "REJECTED".equals(supplierEntryRow.getString("invitationstatus"))).filter(supplierEntryRow -> currentSupplier.getPkValue().equals(supplierEntryRow.getDynamicObject("supplier").getPkValue())).filter(supplierEntryRow -> supplierEntryRow.getDynamicObject("invitation") != null).filter(supplierEntryRow -> supplierEntryRow.getDynamicObject("invitation").getString("id").equals(dataEntity.getString("invitationid"))).forEach(supplierEntryRow -> sectionNameJoiner.add(bidSection.getString("sectionname")));
        });
        return sectionNameJoiner.toString();
    }

    protected String getRejectSectionByBidProject(DynamicObject data, DynamicObject currentSupplier) {
        StringJoiner stringJoiner = new StringJoiner("\u3001");
        if (null == currentSupplier) {
            return stringJoiner.toString();
        }
        Long bidProjectId = Long.parseLong(data.get(BIDPROJECT).toString());
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        DynamicObjectCollection sectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
        block0: for (DynamicObject sectionEntry : sectionEntryColl) {
            DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection(SUPPLIERENTRY);
            for (DynamicObject supplierEntry : supplierEntryColl) {
                DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                if (null == supplier || !supplier.getPkValue().equals(currentSupplier.getPkValue()) || !"REJECTED".equals(supplierEntry.getString("invitationstatus"))) continue;
                stringJoiner.add(sectionEntry.getString("rollsectionname"));
                continue block0;
            }
        }
        return stringJoiner.toString();
    }

    protected class ValidatorRegister
    extends AbstractValidator {
        protected ValidatorRegister() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)TenInvitationOperationServicePlugin.BTN_CONFIRM, (CharSequence)key)) {
                ExtendedDataEntity dataEntity = dataEntities[0];
                Object bidProjectID = dataEntity.getValue(TenInvitationOperationServicePlugin.BIDPROJECT);
                DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectID.toString()), (String)"bid_project");
                Object orgPk = bid_project.getDynamicObject(TenInvitationOperationServicePlugin.ORG).getPkValue();
                DynamicObject currentSupplier = SupplierUtil.getSupplierByOrg((Object)bid_project.getPkValue(), (Object)orgPk);
                Long supplierId = (Long)currentSupplier.get("id");
                QFilter[] supplierEntryFilter = new QFilter[]{new QFilter("supplierentry.id", "=", (Object)Long.parseLong(dataEntity.getValue(TenInvitationOperationServicePlugin.SUPPLIERENTRY).toString()))};
                DynamicObject bidInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_invitation", (String)"id,supplierentry.invitationstatus,publishdate,name,supplierentry.confirmman,supplierentry.confirmdate,supplierinvitation,bidproject.invitationdeadline", (QFilter[])supplierEntryFilter);
                if (bidInvitation == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9080\u8bf7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TenInvitationOperationServicePlugin_0", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject supplierInvitation = bidInvitation.getDynamicObject("supplierinvitation");
                boolean hasConfirm = null != supplierInvitation ? this.checkBySupplierInvitation(supplierId, dataEntity) : this.checkByBidProjectInvitation(supplierId, dataEntity);
                if (hasConfirm) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u9080\u8bf7\u51fd\u5df2\u7ecf\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"TenInvitationOperationServicePlugin_1", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                }
                DynamicObjectCollection supplierEntryColl = (DynamicObjectCollection)bidInvitation.get(TenInvitationOperationServicePlugin.SUPPLIERENTRY);
                for (int i = 0; i < supplierEntryColl.size(); ++i) {
                    DynamicObject item = (DynamicObject)supplierEntryColl.get(i);
                    if (!dataEntity.getValue(TenInvitationOperationServicePlugin.SUPPLIERENTRY).toString().equals(item.get("id").toString()) || "UNCONFIRM".equals(item.get("invitationstatus").toString())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u9080\u8bf7\u51fd\u5df2\u7ecf\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"TenInvitationOperationServicePlugin_1", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (TenInvitationOperationServicePlugin.this.isEnd(bidInvitation)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u6b21\u62db\u6807\u201c\u9080\u8bf7\u786e\u8ba4\u65f6\u95f4\u201d\u5df2\u622a\u6b62\u3002", (String)"TenInvitationOperationServicePlugin_2", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                Boolean enablemultisection = (Boolean)bid_project.get("enablemultisection");
                String purmodel = (String)bid_project.get("purmodel");
                if (!enablemultisection.booleanValue() || "02".equals(purmodel)) {
                    return;
                }
                for (DynamicObject projectSection : bid_project.getDynamicObjectCollection(TenInvitationOperationServicePlugin.BIDENROLLSECTION)) {
                    TenInvitationOperationServicePlugin.this.projectSectionIDMap.put(projectSection.getString("sectionname"), projectSection);
                }
                boolean isFromBidPrj = null == supplierInvitation;
                this.addSectionBySupplierInvitation(bidInvitation.get("id").toString(), bid_project, isFromBidPrj, dataEntity);
                if (TenInvitationOperationServicePlugin.this.sectionList.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u7684\u786e\u8ba4\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u5168\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u518d\u786e\u8ba4\u3002", (String)"TenInvitationOperationServicePlugin_3", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }

        protected DynamicObjectCollection getSupplierInvitation(String bidProjectId, String invitationId) {
            DynamicObject supplierInvitationInfo;
            DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            Object orgPk = bid_project.getDynamicObject(TenInvitationOperationServicePlugin.ORG).getPkValue();
            DynamicObject currentSupplier = SupplierUtil.getSupplierByOrg((Object)bid_project.getPkValue(), (Object)orgPk);
            DynamicObject invitationObject = BusinessDataServiceHelper.loadSingle((Object)invitationId, (String)"bid_invitation");
            DynamicObject supplierInvitation = null;
            if (invitationObject != null && (supplierInvitationInfo = invitationObject.getDynamicObject("supplierinvitation")) != null) {
                supplierInvitation = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(supplierInvitationInfo.getPkValue().toString()), (String)"bid_supplierinvitation");
            }
            if (supplierInvitation == null) {
                QFilter filter = new QFilter(TenInvitationOperationServicePlugin.BIDPROJECT, "=", (Object)Long.parseLong(bidProjectId));
                supplierInvitation = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.invitation,entitytypeid", (QFilter[])new QFilter[]{filter});
            }
            DynamicObjectCollection bidSectionColl = supplierInvitation.getDynamicObjectCollection(TenInvitationOperationServicePlugin.BIDENROLLSECTION);
            Iterator bidSectionIterator = bidSectionColl.iterator();
            while (bidSectionIterator.hasNext()) {
                DynamicObject bidSectionItem = (DynamicObject)bidSectionIterator.next();
                DynamicObjectCollection supplierEntryColl = (DynamicObjectCollection)bidSectionItem.get(TenInvitationOperationServicePlugin.SUPPLIERENTRY);
                boolean isDelete = true;
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    DynamicObject supplier = (DynamicObject)supplierEntry.get("supplier");
                    DynamicObject invitation = (DynamicObject)supplierEntry.get("invitation");
                    Object supplierId = supplier.get("id");
                    if (invitation == null || !invitationId.equals(invitation.get("id").toString()) || !supplierId.toString().equals(currentSupplier.getPkValue().toString())) continue;
                    isDelete = false;
                }
                if (!isDelete) continue;
                bidSectionIterator.remove();
            }
            return bidSectionColl;
        }

        protected boolean checkBySupplierInvitation(Object supplierId, ExtendedDataEntity dataEntity) {
            QFilter[] bidProjectFilter = new QFilter[]{new QFilter(TenInvitationOperationServicePlugin.BIDPROJECT, "=", (Object)Long.parseLong(dataEntity.getValue(TenInvitationOperationServicePlugin.BIDPROJECT).toString()))};
            DynamicObject bidSupplierInvitation = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"bidsection,supplierentry,supplierentry.invitationstatus,supplierentry.supplier,supplierentry.invitation", (QFilter[])bidProjectFilter);
            DynamicObjectCollection bidSectionColl = bidSupplierInvitation.getDynamicObjectCollection(TenInvitationOperationServicePlugin.BIDENROLLSECTION);
            QFilter[] supplierEntryFilter = new QFilter[]{new QFilter("supplierentry.id", "=", (Object)Long.parseLong(dataEntity.getValue(TenInvitationOperationServicePlugin.SUPPLIERENTRY).toString()))};
            DynamicObject bidInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_invitation", (String)"id,supplierentry.invitationstatus,publishdate,name,supplierentry.confirmman,supplierentry.confirmdate,bidproject.invitationdeadline", (QFilter[])supplierEntryFilter);
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                if (TenInvitationOperationServicePlugin.this.sectionList.size() > 0 && !TenInvitationOperationServicePlugin.this.sectionList.contains(bidSection.get("id").toString())) continue;
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection(TenInvitationOperationServicePlugin.SUPPLIERENTRY);
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    DynamicObject supplierItem = (DynamicObject)supplierEntry.get("supplier");
                    DynamicObject supplierEntryInvitation = (DynamicObject)supplierEntry.get("invitation");
                    if (supplierEntryInvitation == null || !bidInvitation.get("id").toString().equals(supplierEntryInvitation.get("id").toString()) || !supplierId.toString().equals(supplierItem.get("id").toString()) || "UNCONFIRM".equals(supplierEntry.get("invitationstatus").toString())) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean checkByBidProjectInvitation(Object supplierId, ExtendedDataEntity dataEntity) {
            Object bidProjectId = dataEntity.getValue(TenInvitationOperationServicePlugin.BIDPROJECT);
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectId.toString()), (String)"bid_project");
            DynamicObjectCollection sectionEntryColl = bidProject.getDynamicObjectCollection("bidrollsection");
            for (DynamicObject sectionEntry : sectionEntryColl) {
                DynamicObjectCollection supplierEntryColl = sectionEntry.getDynamicObjectCollection(TenInvitationOperationServicePlugin.SUPPLIERENTRY);
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    if (!supplierId.toString().equals(supplier.getPkValue().toString()) || "UNCONFIRM".equals(supplierEntry.get("invitationstatus").toString())) continue;
                    return true;
                }
            }
            return false;
        }

        protected void addSectionBySupplierInvitation(String invitationId, DynamicObject bid_project, boolean isFromBidPrj, ExtendedDataEntity dataEntity) {
            DynamicObjectCollection bidProjectColls = this.getSupplierInvitation(bid_project.getPkValue().toString(), invitationId);
            DynamicObjectCollection sectionEntryColl = bid_project.getDynamicObjectCollection("bidrollsection");
            for (DynamicObject temp : bidProjectColls) {
                boolean isCheck;
                String sectionName = temp.getString("sectionname");
                String sectionId = temp.getPkValue().toString();
                if (isFromBidPrj) {
                    for (DynamicObject sectionEntry : sectionEntryColl) {
                        if (!sectionName.equals(sectionEntry.getString("rollsectionname"))) continue;
                        sectionId = sectionEntry.getPkValue().toString();
                        break;
                    }
                }
                if (!(isCheck = ((Boolean)dataEntity.getValue("section" + sectionId)).booleanValue())) continue;
                TenInvitationOperationServicePlugin.this.sectionList.add(temp.getPkValue().toString());
                if (!TenInvitationOperationServicePlugin.this.projectSectionIDMap.containsKey(sectionName)) continue;
                TenInvitationOperationServicePlugin.this.projectSectionMap.put((Long)temp.getPkValue(), TenInvitationOperationServicePlugin.this.projectSectionIDMap.get(sectionName));
            }
        }
    }
}

