/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.ten.formplugin.util.TenBiddingExportUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OnlieBustalkEditPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    private static final String ATTACHE_TAG = "atta";
    private static final String TEXT = "text";
    private static final String TEXT_DETAIL_COSTRATE = "costrate";
    private static final String TEXT_PURENTRYCONTENT = "purentrycontent";
    private final TenBiddingExportUtil tenBiddingExportUtil = new TenBiddingExportUtil();
    private static final String TEXT_TENDERPRICE = "texttenderprice";
    private static final String TEXT_NOTAXTENDERPRICE = "textnotaxtenderprice";
    private static final String TEXT_TAX = "texttax";
    private static final String TEXT_PROJECTMANAGE = "textprojectmanage";
    private static final String TEXT_WORKDAY = "textworkday";
    private static final String FIRSTTABAPKEY = "firsttabapkey";
    private static final String TEXT_RATE = "textrate";
    private static final String[] TEXT_FEILD_ID = new String[]{"texttenderprice", "textpricevat", "texttax", "textnotaxtenderprice", "textprojectmanage", "textworkday"};
    private static final String TEXT_PRICEVAT = "textpricevat";
    private static final String TEXT_TENDERSTATE = "texttenderstate";
    private static final String[] ATTACH_FEILD_ID = new String[]{"attatech", "attacommerce", "attaother"};

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object pkId = this.getModel().getDataEntity().getPkValue();
        List<Map<String, String>> list = this.getIdAndName(pkId);
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        TabAp dynamicPanel = this.createDynamicTabAp(list, formShowParameter);
        Container myFldPanel = (Container)this.getView().getControl("sectiontab");
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        this.setTabContent(pkId, list);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (StringUtils.equals((CharSequence)"exportlist_expt", (CharSequence)afterDoOperationEventArgs.getOperateKey())) {
            DynamicObject dataentity = this.getView().getModel().getDataEntity(true);
            DynamicObject bidProjectF7 = dataentity.getDynamicObject("bidproject");
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"));
            DynamicObjectCollection entry = dataentity.getDynamicObjectCollection("entry");
            boolean enablemultisection = entry.size() > 1;
            DynamicObject defaultEntry = null;
            defaultEntry = enablemultisection && this.getEntrySeq() != -1 ? (DynamicObject)entry.get(this.getEntrySeq()) : (DynamicObject)entry.get(0);
            String url = TenBiddingExportUtil.exportEntry((DynamicObjectCollection)defaultEntry.getDynamicObjectCollection("supplierdetail"), (DynamicObject)bidProject);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                this.getView().download(url);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"OnlieBustalkEditPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1aurl\u751f\u6210\u5931\u8d25\u3002", (String)"OnlieBustalkEditPlugin_33", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)"uploadentry", (CharSequence)afterDoOperationEventArgs.getOperateKey())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "ten_entry_upload");
            FormShowParameter para = FormShowParameter.createFormShowParameter(map);
            OpenStyle openStyle = para.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            para.setStatus(OperationStatus.ADDNEW);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "ten_entry_upload");
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        }
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)afterDoOperationEventArgs.getOperateKey()) || StringUtils.equals((CharSequence)"unsubmit", (CharSequence)afterDoOperationEventArgs.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("ten_entry_upload".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            String fileUrl = (String)map.get("fileUrl");
            String fileName = (String)map.get("fileName");
            if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
                this.loadXLSXFile(fileName, fileUrl);
                this.getView().updateView("supplierdetail");
            }
        }
    }

    protected void loadXLSXFile(String fileName, String url) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(url);
        XSSFWorkbook workbook = null;
        InputStream is = inputStream;
        if (is != null) {
            if (fileName.endsWith("xlsx")) {
                try {
                    workbook = new XSSFWorkbook(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    workbook = new HSSFWorkbook(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (workbook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"OnlieBustalkEditPlugin_34", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataentity = this.getView().getModel().getDataEntity(true);
        DynamicObject bidProject = dataentity.getDynamicObject("bidproject");
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        int amtPrecision = 2;
        DynamicObject currency = bidProject.getDynamicObject("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        for (int numSheet = 0; numSheet < 1; ++numSheet) {
            Sheet sheet = workbook.getSheetAt(numSheet);
            if (sheet == null) continue;
            if (sheet.getLastRowNum() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u6a21\u677f\uff0c\u8bf7\u5728\u62a5\u4ef7\u660e\u7ec6\u5bfc\u51fa\u6a21\u677f\u3002", (String)"OnlieBustalkEditPlugin_35", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            Row headRow = sheet.getRow(0);
            int bidType = bidProject.getInt("bidtype");
            String[] headArray = bidType == 1 ? this.tenBiddingExportUtil.materialpurHeadArray : (bidType == 2 ? this.tenBiddingExportUtil.resourcepurHeadArray : this.tenBiddingExportUtil.tenHeadArray);
            if (headArray.length != headRow.getLastCellNum()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5bfc\u51fa\u6a21\u677f\u3002", (String)"OnlieBustalkEditPlugin_36", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < headArray.length; ++i) {
                if (headArray[i].equals(headRow.getCell(i).getStringCellValue())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5bfc\u51fa\u6a21\u677f\u3002", (String)"OnlieBustalkEditPlugin_36", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entry = dataentity.getDynamicObjectCollection("entry");
            boolean enablemultisection = entry.size() > 1;
            DynamicObject defaultEntry = null;
            defaultEntry = enablemultisection && this.getEntrySeq() != -1 ? (DynamicObject)entry.get(this.getEntrySeq()) : (DynamicObject)entry.get(0);
            DynamicObjectCollection supplierDetailEntry = defaultEntry.getDynamicObjectCollection("supplierdetail");
            BigDecimal sumInclutaxprice = BigDecimal.ZERO;
            BigDecimal sumtaxamount = BigDecimal.ZERO;
            for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                String detailCompareproject;
                Row row = sheet.getRow(rowNum);
                DynamicObject supplierDetail = (DynamicObject)supplierDetailEntry.get(rowNum - 1);
                String id = this.getCellStringValue(row, 0);
                if (bidType != 0) {
                    String purentryproject = this.getCellStringValue(row, 1);
                    String purId = this.getCellStringValue(row, 2);
                    String purName = "";
                    purName = bidType == 1 ? "materialid" : "resourceitem";
                    if (!supplierDetail.getString("id").equals(id) || !supplierDetail.getDynamicObject(purName).getString("number").equals(purId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u62a5\u4ef7\u660e\u7ec6\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"OnlieBustalkEditPlugin_37", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BigDecimal inclutaxprice = new BigDecimal(this.getCellStringValue(row, 8));
                    BigDecimal qty = supplierDetail.getBigDecimal("qty");
                    BigDecimal inclutaxamount = qty.multiply(inclutaxprice).setScale(amtPrecision, 4);
                    BigDecimal taxrate = BigDecimal.ZERO;
                    if (StringUtils.isNotEmpty((CharSequence)this.getCellStringValue(row, 11)) && this.validTaxrate(taxrate = new BigDecimal(this.getCellStringValue(row, 11)).setScale(2, 4))) {
                        return;
                    }
                    String bdTaxRateId = this.getCellStringValue(row, 10);
                    if (StringUtils.isNotEmpty((CharSequence)bdTaxRateId)) {
                        DynamicObject bdTaxRate = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(bdTaxRateId), (String)"bd_taxrate");
                        supplierDetail.set("bd_taxrate", (Object)bdTaxRate);
                    }
                    BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), amtPrecision, 4);
                    sumInclutaxprice = sumInclutaxprice.add(inclutaxamount);
                    sumtaxamount = sumtaxamount.add(taxamount);
                    supplierDetail.set("inclutaxprice", (Object)inclutaxprice);
                    supplierDetail.set("inclutaxamount", (Object)inclutaxamount);
                    supplierDetail.set("taxrate", (Object)taxrate);
                    supplierDetail.set("taxamount", (Object)taxamount);
                    supplierDetail.set("excepttaxamount", (Object)inclutaxamount.subtract(taxamount));
                    continue;
                }
                String purentrycontent = this.getCellStringValue(row, 1);
                String purentryproject = this.getCellStringValue(row, 2);
                String string = detailCompareproject = supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getLocaleString("name").getLocaleValue();
                if (!(supplierDetail.getString("id").equals(id) && supplierDetail.getString(TEXT_PURENTRYCONTENT).equals(purentrycontent) && StringUtils.equals((CharSequence)detailCompareproject, (CharSequence)purentryproject))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u62a5\u4ef7\u660e\u7ec6\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"OnlieBustalkEditPlugin_37", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal inclutaxamount = new BigDecimal(0);
                if (StringUtils.isNotEmpty((CharSequence)this.getCellStringValue(row, 3))) {
                    inclutaxamount = new BigDecimal(this.getCellStringValue(row, 3)).setScale(amtPrecision, 4);
                }
                BigDecimal taxrate = new BigDecimal(0);
                if (StringUtils.isNotEmpty((CharSequence)this.getCellStringValue(row, 4)) && this.validTaxrate(taxrate = new BigDecimal(this.getCellStringValue(row, 4)).setScale(2, 4))) {
                    return;
                }
                supplierDetail.set("inclutaxamount", (Object)inclutaxamount);
                supplierDetail.set("taxrate", (Object)taxrate);
                BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), amtPrecision, 4);
                sumInclutaxprice = sumInclutaxprice.add(inclutaxamount);
                sumtaxamount = sumtaxamount.add(taxamount);
                supplierDetail.set("taxamount", (Object)taxamount);
                supplierDetail.set("excepttaxamount", (Object)inclutaxamount.subtract(taxamount));
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            BigDecimal sumexcepttaxamount = sumInclutaxprice.subtract(sumtaxamount);
            BigDecimal sumtaxrate = BigDecimal.ZERO;
            sumtaxrate = sumexcepttaxamount.compareTo(BigDecimal.ZERO) != 0 ? sumtaxamount.divide(sumexcepttaxamount, 4, 4) : BigDecimal.ZERO;
            dataEntity.set(TEXT_TENDERPRICE + this.getDisPlaySectionID(), (Object)sumInclutaxprice);
            dataEntity.set(TEXT_PRICEVAT + this.getDisPlaySectionID(), (Object)sumtaxrate.multiply(new BigDecimal("100")));
            this.getView().updateView(TEXT_TENDERPRICE + this.getDisPlaySectionID());
            this.getView().updateView(TEXT_PRICEVAT + this.getDisPlaySectionID());
            this.getModel().setValue(TEXT_NOTAXTENDERPRICE + this.getDisPlaySectionID(), (Object)sumexcepttaxamount);
            this.getModel().setValue(TEXT_TAX + this.getDisPlaySectionID(), (Object)sumtaxamount);
            try {
                is.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getCellStringValue(Row row, int index) {
        String value = "";
        Cell cell = row.getCell(index);
        if (cell != null) {
            CellType resultType;
            CellType cellType = cell.getCellType();
            value = cellType.equals((Object)CellType.NUMERIC) ? cell.getNumericCellValue() + "" : (cellType.equals((Object)CellType.FORMULA) ? ((resultType = cell.getCachedFormulaResultType()).equals((Object)CellType.NUMERIC) ? cell.getNumericCellValue() + "" : cell.getStringCellValue()) : cell.getStringCellValue());
        }
        return value;
    }

    private boolean validTaxrate(BigDecimal taxrate) {
        if (taxrate.compareTo(new BigDecimal(0)) < 0 || taxrate.compareTo(new BigDecimal(100)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u7a0e\u7387\u8d85\u51fa\u6570\u5b57\u8303\u56f4\uff1a0\u2264\u7a0e\u7387\u2264100\u3002", (String)"OnlieBustalkEditPlugin_38", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        DynamicObject onlie_bustalk = this.getModel().getDataEntity(true);
        if (onlie_bustalk == null) {
            return;
        }
        String operateKey = operate.getOperateKey();
        DynamicObjectCollection entry = onlie_bustalk.getDynamicObjectCollection("entry");
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            DynamicObject bidproject = this.getView().getModel().getDataEntity(true).getDynamicObject("bidproject");
            bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(this.getBidAppId() + "_" + "project"));
            boolean isratebidding = bidproject.getBoolean("isratebidding");
            String tip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u6295\u6807\u4ef7\u683c\u3002", (String)"OnlieBustalkEditPlugin_7", (String)"scm-ten-formplugin", (Object[])new Object[0]);
            if (isratebidding) {
                tip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u8d39\u7387\u3002", (String)"OnlieBustalkEditPlugin_30", (String)"scm-ten-formplugin", (Object[])new Object[0]);
            }
            for (DynamicObject e : entry) {
                DynamicObjectCollection supplierdetail = e.getDynamicObjectCollection("supplierdetail");
                for (int i = 0; i < supplierdetail.size(); ++i) {
                    DynamicObject row = (DynamicObject)supplierdetail.get(i);
                    BigDecimal inclutaxamount = row.getBigDecimal("inclutaxamount");
                    if (!isratebidding) continue;
                    inclutaxamount = row.getBigDecimal(TEXT_DETAIL_COSTRATE);
                }
            }
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            DynamicObject bidProjectF7 = (DynamicObject)onlie_bustalk.get("bidproject");
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_" + "project"));
            Boolean enablemultisection = entry.size() > 1;
            Boolean isRateBidding = bidProject.getBoolean("isratebidding");
            String docTypeStr = bidProject.getString("doctype");
            int bidType = bidProject.getInt("bidtype");
            if (bidType != 0) {
                DynamicObjectCollection entry1 = onlie_bustalk.getDynamicObjectCollection("entry");
                for (int i = 0; i < entry1.size(); ++i) {
                    String sectionname = ((DynamicObject)entry1.get(i)).getString("sectionname");
                    DynamicObjectCollection supplierdetail = ((DynamicObject)entry1.get(i)).getDynamicObjectCollection("supplierdetail");
                    for (int i1 = 0; i1 < supplierdetail.size(); ++i1) {
                        DynamicObject bd_taxrate = ((DynamicObject)supplierdetail.get(i1)).getDynamicObject("bd_taxrate");
                        if (bd_taxrate != null) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165%s\u7684\u201d\u7a0e\u7387\u540d\u79f0\u201c\u3002", (String)"OnlieBustalkEditPlugin_8", (String)"scm-ten-formplugin", (Object[])new Object[]{sectionname}));
                        args.setCancel(true);
                        return;
                    }
                }
            }
            List<Map<String, String>> idNamelist = this.getIdAndName(onlie_bustalk.getPkValue());
            for (int i = 0; i < idNamelist.size(); ++i) {
                String commerceKey;
                String xObject;
                String key;
                Map<String, String> map = idNamelist.get(i);
                if (isRateBidding.booleanValue() && (BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) || BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr))) {
                    String str;
                    Object rate = this.getModel().getValue(TEXT_RATE + map.get("id"));
                    Float rateFloat = Float.valueOf(Float.parseFloat(rate + ""));
                    if (rate == null || rateFloat.floatValue() == 0.0f || rateFloat.floatValue() < 0.0f) {
                        if (enablemultisection.booleanValue()) {
                            str = String.format(ResManager.loadKDString((String)"%s\u201c\u7efc\u5408\u8d39\u7387\u201d\u9700\u5927\u4e8e0\u3002", (String)"OnlieBustalkEditPlugin_39", (String)"scm-ten-formplugin", (Object[])new Object[0]), map.get("sectionname"));
                            this.getView().showTipNotification(str);
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7efc\u5408\u8d39\u7387\u201d\u9700>0\u3002", (String)"OnlieBustalkEditPlugin_12", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        }
                        args.setCancel(true);
                        return;
                    }
                    if (rateFloat.floatValue() > 100.0f) {
                        if (enablemultisection.booleanValue()) {
                            str = String.format(ResManager.loadKDString((String)"%s\u201c\u7efc\u5408\u8d39\u7387\u201d\u9700\u5c0f\u4e8e\u4e14\u7b49\u4e8e100\u3002", (String)"OnlieBustalkEditPlugin_31", (String)"scm-ten-formplugin", (Object[])new Object[0]), map.get("sectionname"));
                            this.getView().showTipNotification(str);
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7efc\u5408\u8d39\u7387\u201d\u9700\u5c0f\u4e8e\u4e14\u7b49\u4e8e100\u3002", (String)"OnlieBustalkEditPlugin_32", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        }
                        args.setCancel(true);
                        return;
                    }
                }
                DynamicObject dataEntity = onlie_bustalk;
                if (!this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW) || dataEntity != null) {
                    Object pk = dataEntity.getPkValue();
                    key = "TampAttCache" + this.getView().getPageId();
                    xObject = this.getPageCache().get(key);
                    String entryId = map.get("id");
                    commerceKey = "attacommerce" + entryId;
                    JSONObject attObject = null;
                    List commerceFileList = AttachmentServiceHelper.getAttachments((String)(this.getAppId() + "_onlie_bustalk"), (Object)pk, (String)commerceKey);
                    if (xObject != null) {
                        attObject = (JSONObject)JSONArray.parse((String)this.getPageCache().get(key));
                        JSONArray commerce = (JSONArray)attObject.get((Object)commerceKey);
                        if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) && !BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) continue;
                        if (commerce != null) {
                            if (!commerce.isEmpty() || !commerceFileList.isEmpty()) continue;
                            if (enablemultisection.booleanValue()) {
                                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_40", (String)"scm-ten-formplugin", (Object[])new Object[0]), map.get("sectionname")));
                            } else {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_14", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                            }
                            args.setCancel(true);
                            return;
                        }
                        if (attObject.get((Object)commerceKey) != null || !commerceFileList.isEmpty()) continue;
                        if (enablemultisection.booleanValue()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_40", (String)"scm-ten-formplugin", (Object[])new Object[0]), map.get("sectionname")));
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_14", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        }
                        args.setCancel(true);
                        return;
                    }
                    if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) && !BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr) || !commerceFileList.isEmpty()) continue;
                    if (enablemultisection.booleanValue()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_40", (String)"scm-ten-formplugin", (Object[])new Object[0]), map.get("sectionname")));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_14", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                String entryId = map.get("id");
                key = "TampAttCache" + this.getView().getPageId();
                xObject = this.getPageCache().get(key);
                if (xObject != null) {
                    JSONObject attObject = (JSONObject)JSONArray.parse((String)this.getPageCache().get(key));
                    if (attObject.get((Object)(commerceKey = "attacommerce" + entryId)) != null) continue;
                    if (enablemultisection.booleanValue()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_40", (String)"scm-ten-formplugin", (Object[])new Object[0]), map.get("name")));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"OnlieBustalkEditPlugin_14", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    }
                    args.setCancel(true);
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"OnlieBustalkEditPlugin_16", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith(TEXT_RATE)) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(e.getKey());
            decimalEdit.setView(this.getView());
            e.setControl((Control)decimalEdit);
        } else if (e.getKey().startsWith(TEXT)) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        } else if (e.getKey().startsWith(ATTACHE_TAG)) {
            AttachmentPanel panel = new AttachmentPanel();
            String key = e.getKey();
            panel.setKey(key);
            panel.setDefaultCollapse(false);
            panel.setView(this.getView());
            e.setControl((Control)panel);
        }
    }

    public void setTabContent(Object pkId, List<Map<String, String>> list) {
        String billstatus;
        DynamicObject onlie_bustalk = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(this.getAppId() + "_onlie_bustalk"));
        DynamicObjectCollection entryColl = onlie_bustalk.getDynamicObjectCollection("entry");
        DynamicObject bidProjectF7 = onlie_bustalk.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"));
        String negotiatetabpage = this.getView().getFormShowParameter().getCustomParam("negotiatetabpage").toString();
        if (!negotiatetabpage.isEmpty() && negotiatetabpage.equals("true")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"titlepanel", "exportentry", "uploadentry", "fs_baseinfo"});
            billstatus = onlie_bustalk.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entry", "sectiontab", "flexpanelap51", "fieldsetpanelap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"fs_baseinfo"});
            }
        }
        if ("A".equals(billstatus = onlie_bustalk.getString("billstatus"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unsubmit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"sectiontab", "supplierdetail"});
        }
        if ("B".equals(billstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unsubmit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"sectiontab", "supplierdetail"});
        }
        Date offerstoptime = onlie_bustalk.getDate("offerstoptime");
        if (new Date().getTime() > offerstoptime.getTime()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unsubmit"});
        }
        this.setPluginVisible(bidProject, list);
        if (!entryColl.isEmpty()) {
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject biddingEntry = (DynamicObject)entryColl.get(i);
                String entryId = biddingEntry.getString("sectionid");
                this.getModel().setValue(TEXT_TENDERPRICE + entryId, biddingEntry.get("tenderprice"));
                this.getModel().setValue(TEXT_PROJECTMANAGE + entryId, biddingEntry.get("projectmanage"));
                this.getModel().setValue(TEXT_NOTAXTENDERPRICE + entryId, biddingEntry.get("notaxtenderprice"));
                this.getModel().setValue(TEXT_TAX + entryId, biddingEntry.get("tax"));
                this.getModel().setValue(TEXT_WORKDAY + entryId, biddingEntry.get("workday"));
                this.getModel().setValue(TEXT_TENDERSTATE + entryId, biddingEntry.get("tenderstate"));
                this.getModel().setValue(TEXT_PRICEVAT + entryId, (Object)biddingEntry.getBigDecimal("pricevat").multiply(new BigDecimal("100")));
                this.getModel().setValue(TEXT_RATE + entryId, (Object)biddingEntry.getBigDecimal("rate").multiply(new BigDecimal("100")));
                String techKey = "attatech" + entryId;
                AttachmentPanel techPanel = (AttachmentPanel)this.getView().getControl(techKey);
                techPanel.setKey(techKey);
                techPanel.setDefaultCollapse(false);
                this.getView().updateView(techKey);
                String commerceKey = "attacommerce" + entryId;
                AttachmentPanel commercePanel = (AttachmentPanel)this.getView().getControl(commerceKey);
                commercePanel.setKey(commerceKey);
                commercePanel.setDefaultCollapse(false);
                this.getView().updateView(commerceKey);
                String otherKey = "attaother" + entryId;
                AttachmentPanel otherPanel = (AttachmentPanel)this.getView().getControl(otherKey);
                otherPanel.setKey(otherKey);
                otherPanel.setDefaultCollapse(false);
                this.getView().updateView(otherKey);
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BillShowParameter formShowParameter = (BillShowParameter)e.getSource();
        Object pkId = formShowParameter.getPkId();
        List<Map<String, String>> list = this.getIdAndName(pkId);
        TabAp tab = this.createDynamicTabAp(list, formShowParameter);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "sectiontab");
        mapHead.put("items", (String)tab.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("OnlieBustalkEditPlugin", exp.getMessage()), new Object[0]);
        }
        Object pkId = this.getView().getFormShowParameter().getCustomParam("onlieBustalkId");
        List<Map<String, String>> list = this.getIdAndName(pkId);
        this.registDynamicProps(newMainType, list);
        e.setNewEntityType(newMainType);
    }

    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        super.propertyChanged(propertychangedargs);
        IDataEntityProperty pro = propertychangedargs.getProperty();
        String filedName = pro.getName();
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxprice") || StringUtils.equals((CharSequence)filedName, (CharSequence)"taxrate") || StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxamount")) {
            DynamicObject bidproject = dataentity.getDynamicObject("bidproject");
            DynamicObjectCollection entry = dataentity.getDynamicObjectCollection("entry");
            boolean enablemultisection = entry.size() > 1;
            DynamicObject defaultEntry = null;
            defaultEntry = enablemultisection && this.getEntrySeq() != -1 ? (DynamicObject)entry.get(this.getEntrySeq()) : (DynamicObject)entry.get(0);
            DynamicObjectCollection detailEntryCols = defaultEntry.getDynamicObjectCollection("supplierdetail");
            BigDecimal sumInclutaxprice = BigDecimal.ZERO;
            BigDecimal sumtaxrate = BigDecimal.ZERO;
            BigDecimal sumtaxamount = BigDecimal.ZERO;
            BigDecimal sumexcepttaxamount = BigDecimal.ZERO;
            DynamicObject bidProject = dataentity.getDynamicObject("bidproject");
            boolean isMaterialpur = bidProject.getBoolean("ismaterialpur");
            ChangeData[] datas = propertychangedargs.getChangeSet();
            ChangeData changedata = datas[0];
            int index = changedata.getRowIndex();
            DynamicObject supplierDetailRow = (DynamicObject)detailEntryCols.get(index);
            if (isMaterialpur) {
                BigDecimal inclutaxprice = Objects.isNull(supplierDetailRow.getBigDecimal("inclutaxprice")) ? BigDecimal.ZERO : supplierDetailRow.getBigDecimal("inclutaxprice");
                BigDecimal qty = supplierDetailRow.getBigDecimal("qty");
                BigDecimal inclutaxamount = qty.multiply(inclutaxprice).setScale(10, 4);
                BigDecimal taxrate = supplierDetailRow.getBigDecimal("taxrate");
                BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), 10, 4);
                this.getModel().setValue("taxamount", (Object)taxamount, index);
            } else {
                BigDecimal inclutaxamount = Objects.isNull(supplierDetailRow.getBigDecimal("inclutaxamount")) ? BigDecimal.ZERO : supplierDetailRow.getBigDecimal("inclutaxamount");
                BigDecimal taxrate = supplierDetailRow.getBigDecimal("taxrate");
                BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), 10, 4);
                this.getModel().setValue("taxamount", (Object)taxamount, index);
            }
            HashSet<BigDecimal> taxSet = new HashSet<BigDecimal>();
            for (DynamicObject supplierdetailcol : detailEntryCols) {
                taxSet.add(supplierdetailcol.getBigDecimal("taxrate"));
                BigDecimal singleInclutaxprice = supplierdetailcol.getBigDecimal("inclutaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("inclutaxamount");
                BigDecimal singletaxamount = supplierdetailcol.getBigDecimal("taxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("taxamount");
                BigDecimal singleexcepttaxamount = supplierdetailcol.getBigDecimal("excepttaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("excepttaxamount");
                sumInclutaxprice = sumInclutaxprice.add(singleInclutaxprice);
                sumtaxamount = sumtaxamount.add(singletaxamount);
                sumexcepttaxamount = sumexcepttaxamount.add(singleexcepttaxamount);
            }
            sumtaxrate = sumexcepttaxamount.compareTo(BigDecimal.ZERO) != 0 ? sumtaxamount.divide(sumexcepttaxamount, 4, 4) : BigDecimal.ZERO;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.set(TEXT_TENDERPRICE + this.getDisPlaySectionID(), (Object)sumInclutaxprice);
            if (detailEntryCols.size() == 1 || taxSet.size() == 1) {
                dataEntity.set(TEXT_PRICEVAT + this.getDisPlaySectionID(), (Object)((DynamicObject)detailEntryCols.get(0)).getBigDecimal("taxrate"));
            } else {
                dataEntity.set(TEXT_PRICEVAT + this.getDisPlaySectionID(), (Object)sumtaxrate.multiply(new BigDecimal("100")));
            }
            BigDecimal inclutaxprice = (BigDecimal)this.getModel().getValue("inclutaxprice", index);
            if (Objects.isNull(inclutaxprice)) {
                this.getModel().setValue("inclutaxprice", (Object)BigDecimal.ZERO, index);
            }
            this.getView().updateView(TEXT_TENDERPRICE + this.getDisPlaySectionID());
            this.getView().updateView(TEXT_PRICEVAT + this.getDisPlaySectionID());
            this.getModel().setValue(TEXT_NOTAXTENDERPRICE + this.getDisPlaySectionID(), (Object)sumexcepttaxamount);
            this.getModel().setValue(TEXT_TAX + this.getDisPlaySectionID(), (Object)sumtaxamount);
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)(TEXT_TENDERPRICE + this.getDisPlaySectionID())) || StringUtils.equals((CharSequence)filedName, (CharSequence)(TEXT_PRICEVAT + this.getDisPlaySectionID()))) {
            if ("resp".equals(((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2])) {
                BigDecimal priceVat = dataentity.getBigDecimal(TEXT_PRICEVAT + this.getDisPlaySectionID()).divide(new BigDecimal("100"));
                BigDecimal tenderPrice = dataentity.getBigDecimal(TEXT_TENDERPRICE + this.getDisPlaySectionID());
                BigDecimal tax = BigDecimal.ZERO;
                BigDecimal notTaxTenderPrice = BigDecimal.ZERO;
                if ((priceVat.compareTo(BigDecimal.ZERO) <= 0 || tenderPrice.compareTo(BigDecimal.ZERO) <= 0) && priceVat.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue(TEXT_NOTAXTENDERPRICE + this.getDisPlaySectionID(), (Object)tenderPrice);
                }
            }
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"bd_taxrate")) {
            ChangeData[] datas = propertychangedargs.getChangeSet();
            ChangeData changedata = datas[0];
            Object newVal = changedata.getNewValue();
            int rowindex = changedata.getRowIndex();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                DynamicObject bd_taxrate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bd_taxrate.getBigDecimal("taxrate"), rowindex);
            }
        }
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entry");
        if (!entryColl.isEmpty()) {
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject biddingEntry = (DynamicObject)entryColl.get(i);
                String entryId = biddingEntry.getString("sectionid");
                String techKey = "attatech" + entryId;
                String commerceKey = "attacommerce" + entryId;
                AttachmentPanel techPanel = (AttachmentPanel)this.getView().getControl(techKey);
                List techFileList = techPanel.getAttachmentData();
                System.out.println(techFileList.size());
            }
        }
    }

    private void setPluginVisible(DynamicObject bidProject, List<Map<String, String>> list) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(this.getBidAppId() + "_" + "project"));
        DynamicObject[] openProjectArray = BusinessDataServiceHelper.load((String)(this.getBidAppId() + "_" + "bidopen"), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "J"})});
        Date date = project.getDate("bidopendeadline");
        DynamicObject org = project.getDynamicObject("org");
        Boolean isratebidding = project.getBoolean("isratebidding");
        int bidType = project.getInt("bidtype");
        for (int i = 0; i < list.size(); ++i) {
            Map<String, String> map = list.get(i);
            String setcionId = map.get("id");
            if (isratebidding.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_TENDERPRICE + setcionId});
                FieldEdit tenderPrice = (FieldEdit)this.getView().getControl(TEXT_TENDERPRICE + setcionId);
                tenderPrice.setMustInput(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_PRICEVAT + setcionId});
                FieldEdit pricevat = (FieldEdit)this.getView().getControl(TEXT_PRICEVAT + setcionId);
                pricevat.setMustInput(false);
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_RATE + setcionId});
                if (bidType != 0) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_PROJECTMANAGE + setcionId});
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_WORKDAY + setcionId});
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_DETAIL_COSTRATE + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_TENDERPRICE + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_NOTAXTENDERPRICE + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_TAX + setcionId});
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_RATE + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxprice"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bd_taxrate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"excepttaxamount"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"unit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialdes"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"qty"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resitemname"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resourcemodel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"resourceunit"});
                this.setControlMustInput(TEXT_RATE + setcionId + ",costrate");
                this.getView().setEnable(Boolean.TRUE, new String[]{TEXT_RATE + setcionId});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_TENDERPRICE + setcionId});
            this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_PRICEVAT + setcionId});
            this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_RATE + setcionId});
            this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_DETAIL_COSTRATE});
            FieldEdit rate = (FieldEdit)this.getView().getControl(TEXT_RATE + setcionId);
            rate.setMustInput(false);
            this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_TENDERPRICE + setcionId});
            this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_NOTAXTENDERPRICE + setcionId});
            this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_TAX + setcionId});
            this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_PRICEVAT + setcionId});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourceunit"});
            if (bidType != 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_PROJECTMANAGE + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_WORKDAY + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_PURENTRYCONTENT});
                this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent,costrate"});
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_PRICEVAT + setcionId});
                this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_RATE + setcionId});
                this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_TENDERPRICE + setcionId});
                this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_TENDERPRICE + setcionId});
                this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_NOTAXTENDERPRICE + setcionId});
                this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_TAX + setcionId});
                this.getView().setEnable(Boolean.FALSE, new String[]{TEXT_PRICEVAT + setcionId});
                this.getView().setVisible(Boolean.TRUE, new String[]{"baseunit"});
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl("supplierdetail");
                entryEntityGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
                entryEntityGrid.setColumnProperty("taxrate", "l", (Object)55);
                this.setControlMustInput("bd_taxrate");
                if (bidType == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resitemname"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourcemodel"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceunit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TEXT_PURENTRYCONTENT});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
                }
                this.setControlMustInput("inclutaxprice,taxrate");
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_PROJECTMANAGE + setcionId});
            this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_WORKDAY + setcionId});
            this.getView().setVisible(Boolean.TRUE, new String[]{TEXT_PURENTRYCONTENT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialid"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"model"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"materialdes"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"qty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxprice"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"inclutaxamount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resitemname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourcemodel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"resourceunit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bd_taxrate"});
            this.setControlMustInput("inclutaxamount,taxrate");
        }
    }

    private void setControlMustInput(String arg0) {
        String[] arr;
        for (String thisArg : arr = arg0.split(",")) {
            FieldEdit purTypeControl = (FieldEdit)this.getView().getControl(thisArg);
            purTypeControl.setMustInput(true);
        }
    }

    private void registDynamicProps(MainEntityType newMainType, List<Map<String, String>> list) {
        for (int i = 0; i < list.size(); ++i) {
            String sercionId = list.get(i).get("id");
            DecimalProp rateProp = new DecimalProp();
            rateProp.setName(TEXT_RATE + sercionId);
            rateProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u8d39\u7387(%)", (String)"OnlieBustalkEditPlugin_17", (String)"scm-ten-formplugin", (Object[])new Object[0])));
            rateProp.setDbIgnore(true);
            rateProp.setAlias(ResManager.loadKDString((String)"\u8d39\u7387(%)", (String)"OnlieBustalkEditPlugin_17", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            newMainType.registerSimpleProperty((DynamicSimpleProperty)rateProp);
            for (int j = 0; j < this.getTEXT_FEILD().length; ++j) {
                if (this.getTEXT_FEILD()[j].equals(ResManager.loadKDString((String)"\u5de5\u671f\uff08\u5929\u6570\uff09", (String)"OnlieBustalkEditPlugin_18", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                    IntegerProp integerProp = new IntegerProp();
                    integerProp.setName(TEXT_FEILD_ID[j] + sercionId);
                    integerProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                    integerProp.setDbIgnore(true);
                    integerProp.setAlias(this.getTEXT_FEILD()[j]);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)integerProp);
                    continue;
                }
                if (this.getTEXT_FEILD()[j].equals(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09", (String)"OnlieBustalkEditPlugin_19", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                    DecimalProp amountProp = new DecimalProp();
                    amountProp.setName(TEXT_FEILD_ID[j] + sercionId);
                    amountProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                    amountProp.setDbIgnore(true);
                    amountProp.setAlias(this.getTEXT_FEILD()[j]);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)amountProp);
                    continue;
                }
                if (this.getTEXT_FEILD()[j].equals(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09", (String)"OnlieBustalkEditPlugin_20", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                    DecimalProp notaxamountProp = new DecimalProp();
                    notaxamountProp.setName(TEXT_FEILD_ID[j] + sercionId);
                    notaxamountProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                    notaxamountProp.setDbIgnore(true);
                    notaxamountProp.setAlias(this.getTEXT_FEILD()[j]);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)notaxamountProp);
                    continue;
                }
                if (this.getTEXT_FEILD()[j].equals(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"OnlieBustalkEditPlugin_21", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                    DecimalProp taxProp = new DecimalProp();
                    taxProp.setName(TEXT_FEILD_ID[j] + sercionId);
                    taxProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                    taxProp.setDbIgnore(true);
                    taxProp.setAlias(this.getTEXT_FEILD()[j]);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)taxProp);
                    continue;
                }
                if (this.getTEXT_FEILD()[j].equals(ResManager.loadKDString((String)"\u9879\u76ee\u7ecf\u7406", (String)"OnlieBustalkEditPlugin_22", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                    MuliLangTextProp muliLangProp = new MuliLangTextProp();
                    muliLangProp.setName(TEXT_FEILD_ID[j] + sercionId);
                    muliLangProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                    muliLangProp.setDbIgnore(true);
                    muliLangProp.setAlias(this.getTEXT_FEILD()[j]);
                    newMainType.registerSimpleProperty((DynamicSimpleProperty)muliLangProp);
                    DynamicObjectType localeDt = newMainType.getOrCreateLocaleType();
                    TextProp muliLange_textProp = new TextProp();
                    muliLange_textProp.setName(TEXT_FEILD_ID[j] + sercionId);
                    muliLange_textProp.setDbIgnore(true);
                    muliLange_textProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                    muliLange_textProp.setAlias(this.getTEXT_FEILD()[j]);
                    localeDt.registerSimpleProperty((DynamicSimpleProperty)muliLange_textProp);
                    DynamicCollectionProperty localeProp = newMainType.getLocaleProperty();
                    muliLangProp.setLocaleProperty((IDataEntityProperty)localeProp, (DynamicSimpleProperty)muliLange_textProp);
                    continue;
                }
                if (!this.getTEXT_FEILD()[j].equals(ResManager.loadKDString((String)"\u7efc\u5408\u7a0e\u7387(%)", (String)"OnlieBustalkEditPlugin_23", (String)"scm-ten-formplugin", (Object[])new Object[0]))) continue;
                DecimalProp pricevatProp = new DecimalProp();
                pricevatProp.setName(TEXT_FEILD_ID[j] + sercionId);
                pricevatProp.setDisplayName(new LocaleString(this.getTEXT_FEILD()[j]));
                pricevatProp.setDbIgnore(true);
                pricevatProp.setAlias(ResManager.loadKDString((String)"\u7efc\u5408\u7a0e\u7387(%)", (String)"OnlieBustalkEditPlugin_23", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                newMainType.registerSimpleProperty((DynamicSimpleProperty)pricevatProp);
            }
            MuliLangTextProp muliLangProp = new MuliLangTextProp();
            muliLangProp.setName(TEXT_TENDERSTATE + sercionId);
            muliLangProp.setAlias(ResManager.loadKDString((String)"\u62a5\u4ef7\u8bf4\u660e", (String)"OnlieBustalkEditPlugin_24", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            newMainType.registerSimpleProperty((DynamicSimpleProperty)muliLangProp);
            DynamicObjectType localeDt = newMainType.getOrCreateLocaleType();
            TextProp muliLange_textProp = new TextProp();
            muliLange_textProp.setName(TEXT_TENDERSTATE + sercionId);
            muliLange_textProp.setDbIgnore(true);
            muliLange_textProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u4ef7\u8bf4\u660e", (String)"OnlieBustalkEditPlugin_24", (String)"scm-ten-formplugin", (Object[])new Object[0])));
            muliLange_textProp.setAlias(ResManager.loadKDString((String)"\u62a5\u4ef7\u8bf4\u660e", (String)"OnlieBustalkEditPlugin_24", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            localeDt.registerSimpleProperty((DynamicSimpleProperty)muliLange_textProp);
            DynamicCollectionProperty localeProp = newMainType.getLocaleProperty();
            muliLangProp.setLocaleProperty((IDataEntityProperty)localeProp, (DynamicSimpleProperty)muliLange_textProp);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control contractTab = this.getView().getControl("sectiontab");
        ((Tab)contractTab).addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Object pkid = this.getView().getModel().getDataEntity().getPkValue();
        List<Map<String, String>> list = this.getIdAndName(pkid);
        String fieldkey = tabSelectEvent.getTabKey();
        String[] sectionIds = fieldkey.split("\\_");
        String sectionId = sectionIds[0];
        int rowInt = 0;
        for (int i = 0; i < list.size(); ++i) {
            String sectionMapId = list.get(i).get("id");
            if (!StringUtils.equals((CharSequence)sectionId, (CharSequence)sectionMapId)) continue;
            rowInt = i;
            this.setDisPlaySectionID(sectionMapId);
            this.setEntrySeq(i);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("entry");
        if (grid != null) {
            grid.selectRows(rowInt);
        }
    }

    private void setEntrySeq(int entrySeq) {
        if (this.getView() != null) {
            this.getPageCache().put("entrySeq", Integer.toString(entrySeq));
        }
    }

    private int getEntrySeq() {
        return StringUtils.isEmpty((CharSequence)this.getPageCache().get("entrySeq")) ? -1 : Integer.parseInt(this.getPageCache().get("entrySeq"));
    }

    private List<Map<String, String>> getIdAndName(Object pkId) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        DynamicObject onlie_bustalk = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(this.getAppId() + "_onlie_bustalk"));
        DynamicObjectCollection sectionentry = onlie_bustalk.getDynamicObjectCollection("entry");
        DynamicObject bidProjectF7 = onlie_bustalk.getDynamicObject("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)(this.getBidAppId() + "_project"), (String)"enablemultisection,doctype");
        String docTypeStr = bidProject.getString("doctype");
        for (DynamicObject section : sectionentry) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", section.getString("sectionid"));
            map.put("sectionname", section.getString("sectionname"));
            map.put("doctype", docTypeStr);
            map.put("seq", section.getString("seq"));
            list.add(map);
        }
        return list;
    }

    private TabAp createDynamicTabAp(List<Map<String, String>> list, BillShowParameter formShowParameter) {
        DynamicObject currency;
        EntityItem item;
        TabAp tab = new TabAp();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)(this.getAppId() + "_onlie_bustalk"));
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        String currencyFieldId = null;
        if (items != null && items.size() > 0 && (item = items.stream().filter(e -> e.getKey().equals("currency")).findFirst().get()) != null) {
            currencyFieldId = item.getId();
        }
        Object pkId = formShowParameter.getCustomParam("onlieBustalkId");
        DynamicObject onlineBusTalk = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(this.getAppId() + "_onlie_bustalk"));
        int amtPrecision = 2;
        if (onlineBusTalk != null && (currency = onlineBusTalk.getDynamicObject("currency")) != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                this.setDisPlaySectionID(list.get(0).get("id"));
            }
            Map<String, String> map = list.get(i);
            tab.setKey("sectiontab" + i);
            TabPageAp tpa = this.createTabPageAp(map, currencyFieldId, entityMetadata, amtPrecision);
            tab.getItems().add(tpa);
        }
        return tab;
    }

    private String[] getTEXT_FEILD() {
        return new String[]{ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09", (String)"OnlieBustalkEditPlugin_19", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7efc\u5408\u7a0e\u7387(%)", (String)"OnlieBustalkEditPlugin_23", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7a0e\u989d", (String)"OnlieBustalkEditPlugin_21", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09", (String)"OnlieBustalkEditPlugin_20", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9879\u76ee\u7ecf\u7406", (String)"OnlieBustalkEditPlugin_22", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u671f\uff08\u5929\u6570\uff09", (String)"OnlieBustalkEditPlugin_18", (String)"scm-ten-formplugin", (Object[])new Object[0])};
    }

    private TabPageAp createTabPageAp(Map<String, String> map, String currencyFieldId, EntityMetadata entityMeta, int amtPrecision) {
        String firstTabapKey;
        String setcionId = map.get("id");
        String sectionName = map.get("sectionname");
        String docTypeStr = map.get("doctype");
        String seq = map.get("seq");
        TabPageAp tpa = new TabPageAp();
        String tpaKey = setcionId + "_" + seq;
        tpa.setKey(tpaKey);
        tpa.setId(setcionId);
        tpa.setName(new LocaleString(sectionName));
        IPageCache pageCache = this.getPageCache();
        if (pageCache != null && (firstTabapKey = pageCache.get(FIRSTTABAPKEY)) == null) {
            pageCache.put(FIRSTTABAPKEY, tpaKey);
        }
        FlexPanelAp fpa = new FlexPanelAp();
        fpa.setKey("container");
        fpa.setId("container");
        fpa.setWidth(new LocaleString("100%"));
        fpa.setBackColor("#EBEEF2");
        FieldsetPanelAp fpa1 = new FieldsetPanelAp();
        fpa1.setCollapsible(true);
        fpa1.setName(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"OnlieBustalkEditPlugin_25", (String)"scm-ten-formplugin", (Object[])new Object[0])));
        fpa1.setKey("container1");
        fpa1.setId("container1");
        fpa1.setBackColor("#ffffff");
        FieldAp rateAp = new FieldAp();
        String rateKey = TEXT_RATE + setcionId;
        rateAp.setId(rateKey);
        rateAp.setKey(rateKey);
        rateAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7efc\u5408\u8d39\u7387(%)", (String)"OnlieBustalkEditPlugin_26", (String)"scm-ten-formplugin", (Object[])new Object[0])));
        rateAp.setBackColor("#FFFFFF");
        rateAp.setFireUpdEvt(true);
        rateAp.setNoDisplayScaleZero(true);
        DecimalField rateField = new DecimalField();
        rateField.setId(rateKey);
        rateField.setKey(rateKey);
        rateField.setScale(2);
        rateField.setDataScope("[0,100]");
        rateField.setZeroShow(true);
        rateField.setMustInput(true);
        rateAp.setField((Field)rateField);
        fpa1.getItems().add(rateAp);
        for (int i = 0; i < this.getTEXT_FEILD().length; ++i) {
            FieldAp fieldAp = new FieldAp();
            String key = TEXT_FEILD_ID[i] + setcionId;
            fieldAp.setId(key);
            fieldAp.setKey(key);
            fieldAp.setName(new LocaleString(this.getTEXT_FEILD()[i]));
            fieldAp.setBackColor("#FFFFFF");
            fieldAp.setFireUpdEvt(true);
            if (this.getTEXT_FEILD()[i].equals(ResManager.loadKDString((String)"\u5de5\u671f\uff08\u5929\u6570\uff09", (String)"OnlieBustalkEditPlugin_18", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                IntegerField inField = new IntegerField();
                inField.setId(key);
                inField.setKey(key);
                inField.setMustInput(false);
                inField.setDataScope("[0,]");
                fieldAp.setField((Field)inField);
                fpa1.getItems().add(fieldAp);
                continue;
            }
            if (this.getTEXT_FEILD()[i].equals(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u542b\u7a0e\u4ef7\uff09", (String)"OnlieBustalkEditPlugin_19", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) && !BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) continue;
                DecimalField amountField = new DecimalField();
                amountField.setId(key);
                amountField.setKey(key);
                amountField.setDataScope("[0,]");
                amountField.setZeroShow(true);
                amountField.setScale(amtPrecision);
                amountField.setMustInput(true);
                entityMeta.getItems().add(amountField);
                fieldAp.setField((Field)amountField);
                fpa1.getItems().add(fieldAp);
                continue;
            }
            if (this.getTEXT_FEILD()[i].equals(ResManager.loadKDString((String)"\u6295\u6807\u62a5\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09", (String)"OnlieBustalkEditPlugin_20", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) && !BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) continue;
                DecimalField notaxamountField = new DecimalField();
                notaxamountField.setId(key);
                notaxamountField.setKey(key);
                notaxamountField.setDataScope("[0,]");
                notaxamountField.setScale(amtPrecision);
                notaxamountField.setZeroShow(true);
                entityMeta.getItems().add(notaxamountField);
                notaxamountField.setMustInput(true);
                fieldAp.setField((Field)notaxamountField);
                fpa1.getItems().add(fieldAp);
                continue;
            }
            if (this.getTEXT_FEILD()[i].equals(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"OnlieBustalkEditPlugin_21", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) && !BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) continue;
                DecimalField taxField = new DecimalField();
                taxField.setId(key);
                taxField.setKey(key);
                taxField.setDataScope("[0,]");
                taxField.setZeroShow(true);
                taxField.setScale(amtPrecision);
                taxField.setMustInput(true);
                taxField.setZeroShow(true);
                taxField.setDefValue(BigDecimal.ZERO);
                entityMeta.getItems().add(taxField);
                fieldAp.setField((Field)taxField);
                fpa1.getItems().add(fieldAp);
                continue;
            }
            if (this.getTEXT_FEILD()[i].equals(ResManager.loadKDString((String)"\u9879\u76ee\u7ecf\u7406", (String)"OnlieBustalkEditPlugin_22", (String)"scm-ten-formplugin", (Object[])new Object[0]))) {
                MuliLangTextField field = new MuliLangTextField();
                field.setId(key);
                field.setKey(key);
                field.setMustInput(false);
                field.setMaxLength(20);
                fieldAp.setField((Field)field);
                fpa1.getItems().add(fieldAp);
                continue;
            }
            if (!this.getTEXT_FEILD()[i].equals(ResManager.loadKDString((String)"\u7efc\u5408\u7a0e\u7387(%)", (String)"OnlieBustalkEditPlugin_23", (String)"scm-ten-formplugin", (Object[])new Object[0])) || !BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) && !BidOpenTypeEnum.MULTI.getValue().equals(docTypeStr)) continue;
            FieldAp pricevatAp = new FieldAp();
            String pricevatKey = TEXT_PRICEVAT + setcionId;
            pricevatAp.setId(pricevatKey);
            pricevatAp.setKey(pricevatKey);
            pricevatAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7efc\u5408\u7a0e\u7387(%)", (String)"OnlieBustalkEditPlugin_23", (String)"scm-ten-formplugin", (Object[])new Object[0])));
            pricevatAp.setBackColor("#FFFFFF");
            pricevatAp.setFireUpdEvt(true);
            pricevatAp.setNoDisplayScaleZero(true);
            DecimalField pricevatField = new DecimalField();
            pricevatField.setId(pricevatKey);
            pricevatField.setKey(pricevatKey);
            pricevatField.setMustInput(true);
            pricevatField.setDataScope("[0,100]");
            pricevatField.setZeroShow(true);
            pricevatField.setDefValue(BigDecimal.ZERO);
            pricevatField.setScale(2);
            pricevatField.setZeroShow(true);
            pricevatAp.setField((Field)pricevatField);
            fpa1.getItems().add(pricevatAp);
        }
        FieldAp fieldAp = new FieldAp();
        String key = TEXT_TENDERSTATE + setcionId;
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u4ef7\u8bf4\u660e", (String)"OnlieBustalkEditPlugin_24", (String)"scm-ten-formplugin", (Object[])new Object[0])));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        fieldAp.setFullLine(true);
        fieldAp.setFieldStyle(0);
        MuliLangTextField muField = new MuliLangTextField();
        muField.setId(key);
        muField.setKey(key);
        muField.setMustInput(false);
        muField.setMutiLine(true);
        muField.setMaxLength(800);
        fieldAp.setField((Field)muField);
        fpa1.getItems().add(fieldAp);
        fpa.getItems().add(fpa1);
        for (int i = 0; i < this.getATTACH_FEILD().length; ++i) {
            if (i == 0 && BidOpenTypeEnum.BUSSINESS.getValue().equals(docTypeStr) || i == 1 && BidOpenTypeEnum.TECHNICAL.getValue().equals(docTypeStr)) continue;
            AttachmentPanelAp attaAp = new AttachmentPanelAp();
            String attaKey = ATTACH_FEILD_ID[i] + setcionId;
            attaAp.setId(attaKey);
            attaAp.setKey(attaKey);
            attaAp.setMaxAtmSize(1048);
            attaAp.setLock("view");
            attaAp.setCollapsible(true);
            attaAp.setWidth(new LocaleString("100%"));
            attaAp.setName(new LocaleString(this.getATTACH_FEILD()[i]));
            attaAp.setBackColor("#ffffff");
            fpa.getItems().add(attaAp);
        }
        tpa.getItems().add(fpa);
        return tpa;
    }

    private String[] getATTACH_FEILD() {
        return new String[]{ResManager.loadKDString((String)"\u6280\u672f\u6807\u4e66", (String)"OnlieBustalkEditPlugin_27", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u52a1\u6807\u4e66", (String)"OnlieBustalkEditPlugin_28", (String)"scm-ten-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5546\u52a1\u8c08\u5224\u9644\u4ef6", (String)"OnlieBustalkEditPlugin_29", (String)"scm-ten-formplugin", (Object[])new Object[0])};
    }

    private void setDisPlaySectionID(String sectionId) {
        if (this.getView() != null) {
            this.getPageCache().put("displaySetcionId", sectionId);
        }
    }

    private String getDisPlaySectionID() {
        return this.getPageCache().get("displaySetcionId");
    }

    public String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    public String getBidAppId() {
        return this.getAppId().equals("ten") ? "bid" : "rebm";
    }
}

