/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.onlinebid;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.ten.formplugin.util.TenBiddingExportUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TenOnlineBidExportPlugin
extends AbstractFormPlugin {
    private final TenBiddingExportUtil tenBiddingExportUtil = new TenBiddingExportUtil();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"exportlist_expt", (CharSequence)operateKey)) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            Object bidProjectId = dataEntity.getDynamicObject("bidproject").getPkValue();
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidtype, isratebidding, currency");
            DynamicObjectCollection supplierDetailCol = dataEntity.getDynamicObjectCollection("supplierdetail");
            String url = TenBiddingExportUtil.exportEntry((DynamicObjectCollection)supplierDetailCol, (DynamicObject)bidProject);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                this.getView().download(url);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"TenOnlineBidExportPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1aurl\u751f\u6210\u5931\u8d25\u3002", (String)"TenOnlineBidExportPlugin_7", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((CharSequence)"uploadentry", (CharSequence)operateKey)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "ten_entry_upload");
            FormShowParameter para = FormShowParameter.createFormShowParameter(map);
            OpenStyle openStyle = para.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            para.setStatus(OperationStatus.ADDNEW);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "ten_entry_upload");
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("ten_entry_upload".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            String fileUrl = (String)map.get("fileUrl");
            String fileName = (String)map.get("fileName");
            if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
                this.loadXLSXFile(fileName, fileUrl);
                this.getView().updateView("supplierdetail");
            }
        }
    }

    public void loadXLSXFile(String fileName, String url) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(url);
        XSSFWorkbook workbook = null;
        InputStream is = inputStream;
        if (is != null) {
            if (fileName.endsWith("xlsx")) {
                try {
                    workbook = new XSSFWorkbook(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    workbook = new HSSFWorkbook(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (workbook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"TenOnlineBidExportPlugin_8", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int numSheet = 0; numSheet < 1; ++numSheet) {
            Sheet sheet = workbook.getSheetAt(numSheet);
            if (sheet == null) continue;
            if (sheet.getLastRowNum() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4f7f\u7528\u6709\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5bfc\u51fa\u6a21\u677f\u3002", (String)"TenOnlineBidExportPlugin_9", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            Row headRow = sheet.getRow(0);
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            Object bidProjectId = dataEntity.getDynamicObject("bidproject").getPkValue();
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            String bidType = bidProject.getString("bidtype");
            boolean isRateBidding = bidProject.getBoolean("isratebidding");
            String[] headArray = isRateBidding ? (BidTypeEnum.PROJECT.getValue().equals(bidType) ? this.tenBiddingExportUtil.rateHeadArray : new String[]{}) : (BidTypeEnum.MATERIAL.getValue().equals(bidType) ? this.tenBiddingExportUtil.materialpurHeadArray : (BidTypeEnum.RESOURCE.getValue().equals(bidType) ? this.tenBiddingExportUtil.resourcepurHeadArray : this.tenBiddingExportUtil.tenHeadArray));
            if (headArray.length != headRow.getLastCellNum()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5bfc\u51fa\u6a21\u677f\u3002", (String)"TenOnlineBidExportPlugin_10", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < headArray.length; ++i) {
                if (headArray[i].equals(headRow.getCell(i).getStringCellValue())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5bfc\u51fa\u6a21\u677f\u3002", (String)"TenOnlineBidExportPlugin_10", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            int amtPrecision = 2;
            DynamicObject currency = bidProject.getDynamicObject("currency");
            if (currency != null) {
                amtPrecision = currency.getInt("amtprecision");
            }
            DynamicObjectCollection supplierDetailEntry = dataEntity.getDynamicObjectCollection("supplierdetail");
            if (isRateBidding ? this.loadRatebidding(sheet, bidType, supplierDetailEntry, amtPrecision) : this.loadNotRatebidding(sheet, bidType, supplierDetailEntry, amtPrecision)) {
                return;
            }
            try {
                is.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean loadRatebidding(Sheet sheet, String bidType, DynamicObjectCollection supplierDetailEntry, int amtPrecision) {
        for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            if (!BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                return true;
            }
            Row row = sheet.getRow(rowNum);
            DynamicObject supplierDetail = (DynamicObject)supplierDetailEntry.get(rowNum - 1);
            String id = this.tenBiddingExportUtil.getCellStringValue(row, 0);
            String purentryproject = this.tenBiddingExportUtil.getCellStringValue(row, 2);
            String purentrycontent = this.tenBiddingExportUtil.getCellStringValue(row, 1);
            DynamicObject purEntryProjectObj = supplierDetail.getDynamicObject("purentryproject");
            String purEntryProjectName = null;
            if (purEntryProjectObj != null) {
                purEntryProjectName = purEntryProjectObj.getLocaleString("name").getLocaleValue();
            }
            if (purEntryProjectName == null || StringUtils.isEmpty(purEntryProjectName)) {
                if (!supplierDetail.getString("id").equals(id) || !supplierDetail.getString("purentrycontent").equals(purentrycontent)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"TenOnlineBidExportPlugin_11", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    return true;
                }
            } else if (!(supplierDetail.getString("id").equals(id) && supplierDetail.getString("purentrycontent").equals(purentrycontent) && purEntryProjectName.equals(purentryproject))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"TenOnlineBidExportPlugin_11", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return true;
            }
            String costrateValue = this.tenBiddingExportUtil.getCellStringValue(row, 3);
            BigDecimal costrate = BigDecimal.ZERO;
            if (StringUtils.isNotBlank((CharSequence)costrateValue) && !"null".equals(costrateValue)) {
                costrate = new BigDecimal(costrateValue);
            }
            supplierDetail.set("costrate", (Object)costrate);
        }
        return false;
    }

    protected boolean loadNotRatebidding(Sheet sheet, String bidType, DynamicObjectCollection supplierDetailEntry, int amtPrecision) {
        BigDecimal sumIncludeTaxPrice = BigDecimal.ZERO;
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            DynamicObject supplierDetail = (DynamicObject)supplierDetailEntry.get(rowNum - 1);
            String id = this.tenBiddingExportUtil.getCellStringValue(row, 0);
            if (!BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                String purId = this.tenBiddingExportUtil.getCellStringValue(row, 2);
                String purName = "";
                purName = BidTypeEnum.MATERIAL.getValue().equals(bidType) ? "materialid" : "resourceitem";
                if (!supplierDetail.getString("id").equals(id) || !supplierDetail.getDynamicObject(purName).getString("number").equals(purId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"TenOnlineBidExportPlugin_11", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    return true;
                }
                BigDecimal includeTaxPrice = BigDecimal.ZERO;
                String includeTaxPriceValue = this.tenBiddingExportUtil.getCellStringValue(row, 8);
                if (StringUtils.isNotBlank((CharSequence)includeTaxPriceValue) && !"null".equals(includeTaxPriceValue)) {
                    includeTaxPrice = new BigDecimal(includeTaxPriceValue);
                }
                BigDecimal qty = supplierDetail.getBigDecimal("qty");
                BigDecimal includeTaxAmount = qty.multiply(includeTaxPrice).setScale(amtPrecision, 4);
                BigDecimal taxRate = BigDecimal.ZERO;
                String taxRateValue = this.tenBiddingExportUtil.getCellStringValue(row, 13);
                if (StringUtils.isNotBlank((CharSequence)taxRateValue) && !"null".equals(taxRateValue)) {
                    taxRate = new BigDecimal(taxRateValue);
                }
                if (this.validTaxRate(taxRate)) {
                    return true;
                }
                String bdTaxRateId = this.tenBiddingExportUtil.getCellStringValue(row, 10);
                if (StringUtils.isNotBlank((CharSequence)bdTaxRateId)) {
                    DynamicObject bdTaxRate = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(bdTaxRateId), (String)"bd_taxrate");
                    supplierDetail.set("bd_taxrate", (Object)bdTaxRate);
                }
                BigDecimal taxAmount = includeTaxAmount.multiply(taxRate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxRate.divide(new BigDecimal("100"))), amtPrecision, 4);
                sumIncludeTaxPrice = sumIncludeTaxPrice.add(includeTaxAmount);
                sumTaxAmount = sumTaxAmount.add(taxAmount);
                supplierDetail.set("inclutaxprice", (Object)includeTaxPrice);
                supplierDetail.set("inclutaxamount", (Object)includeTaxAmount);
                supplierDetail.set("taxrate", (Object)taxRate);
                supplierDetail.set("taxamount", (Object)taxAmount);
                supplierDetail.set("excepttaxamount", (Object)includeTaxAmount.subtract(taxAmount));
                continue;
            }
            String purEntryContent = this.tenBiddingExportUtil.getCellStringValue(row, 1);
            String purEntryProject = this.tenBiddingExportUtil.getCellStringValue(row, 2);
            if (supplierDetail.getDynamicObject("purentryproject") == null) {
                if (!supplierDetail.getString("id").equals(id) || !supplierDetail.getString("purentrycontent").equals(purEntryContent)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"TenOnlineBidExportPlugin_11", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    return true;
                }
            } else {
                String detailCompareProject;
                String string = detailCompareProject = supplierDetail.getDynamicObject("purentryproject") == null ? "" : supplierDetail.getDynamicObject("purentryproject").getLocaleString("name").getLocaleValue();
                if (!(supplierDetail.getString("id").equals(id) && supplierDetail.getString("purentrycontent").equals(purEntryContent) && StringUtils.equals((CharSequence)detailCompareProject, (CharSequence)purEntryProject))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u5728\u201c\u62a5\u4ef7\u660e\u7ec6\u201d\u5f53\u524d\u9875\u9762\u5bfc\u51fa\u6570\u636e\u3002", (String)"TenOnlineBidExportPlugin_11", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    return true;
                }
            }
            BigDecimal inclutaxamount = new BigDecimal(0);
            if (StringUtils.isNotEmpty((CharSequence)this.tenBiddingExportUtil.getCellStringValue(row, 3))) {
                inclutaxamount = new BigDecimal(this.tenBiddingExportUtil.getCellStringValue(row, 3)).setScale(amtPrecision, 4);
            }
            BigDecimal taxrate = new BigDecimal(0);
            if (StringUtils.isNotEmpty((CharSequence)this.tenBiddingExportUtil.getCellStringValue(row, 3)) && this.validTaxRate(taxrate = new BigDecimal(this.tenBiddingExportUtil.getCellStringValue(row, 4)).setScale(2, 4))) {
                return true;
            }
            supplierDetail.set("inclutaxamount", (Object)inclutaxamount);
            supplierDetail.set("taxrate", (Object)taxrate);
            BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), amtPrecision, 4);
            sumIncludeTaxPrice = sumIncludeTaxPrice.add(inclutaxamount);
            sumTaxAmount = sumTaxAmount.add(taxamount);
            supplierDetail.set("taxamount", (Object)taxamount);
            supplierDetail.set("excepttaxamount", (Object)inclutaxamount.subtract(taxamount));
        }
        BigDecimal sumExceptTaxAmount = sumIncludeTaxPrice.subtract(sumTaxAmount);
        BigDecimal sumTaxRate = BigDecimal.ZERO;
        if (sumExceptTaxAmount.compareTo(BigDecimal.ZERO) > 0) {
            sumTaxRate = sumTaxAmount.divide(sumExceptTaxAmount, 4, 4);
        }
        this.getModel().setValue("tenderprice", (Object)sumIncludeTaxPrice);
        this.getModel().setValue("pricevat", (Object)sumTaxRate.multiply(new BigDecimal("100")));
        this.getView().updateView("tenderprice");
        this.getView().updateView("pricevat");
        this.getModel().setValue("notaxtenderprice", (Object)sumExceptTaxAmount);
        this.getModel().setValue("tax", (Object)sumTaxAmount);
        return false;
    }

    public boolean validTaxRate(BigDecimal taxRate) {
        if (taxRate.compareTo(new BigDecimal(0)) < 0 || taxRate.compareTo(new BigDecimal(100)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u9519\u8bef\uff0c\u7a0e\u7387\u8d85\u51fa\u6570\u5b57\u8303\u56f4\uff1a0\u2264\u7a0e\u7387\u2264100\u3002", (String)"TenOnlineBidExportPlugin_12", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

