/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class CrlMethodUtil {
    protected static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ScmMethodUtil_asyncInvokeMethod", (int)500);

    public static Object invokeMethod(String serviceName, String methodName, Object ... args) {
        try {
            Class<?> cls = Class.forName(serviceName);
            Method method = CrlMethodUtil.findMethod(cls, methodName, args == null ? 0 : args.length);
            if (null == method) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u7c7b%1$s\u7684\u65b9\u6cd5%2$s\u3002", (String)"CrlMethodUtil_0", (String)"scm-ten-common", (Object[])new Object[0]), serviceName, methodName));
                return null;
            }
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            return method.invoke(isStatic ? null : cls.newInstance(), args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            BizLog.log((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        return null;
    }

    public static void asyncInvokeMethod(Runnable task) {
        if (null == task) {
            return;
        }
        threadPool.execute(task);
    }

    private static Method findMethod(Class<?> clazz, String method, int paramterLength) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equalsIgnoreCase(method) || m.getParameterCount() != paramterLength) continue;
            return m;
        }
        return null;
    }
}

