/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.am.common.enums.RelBillEnum;
import kd.tmc.am.common.helper.AmCommonHelper;
import kd.tmc.am.common.helper.AmHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.VisibleVirtualAcctHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class BankAccountEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(BankAccountEdit.class);
    private String CALLBACKKEY_SAVE = "save";

    public void afterCreateNewData(EventObject e) {
        BillShowParameter billShowParameter;
        OperationStatus status;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection currencys = model.getDataEntity().getDynamicObjectCollection("currency");
        if (null != currencys && currencys.size() > 0) {
            this.currencyChange(currencys);
        }
        if ((status = (billShowParameter = (BillShowParameter)this.getView().getFormShowParameter()).getStatus()).equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"acctstatus"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"acctstatus"});
        }
    }

    protected void loadFields() {
        this.verifyProcParam();
        IDataModel model = this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        String finorgType = bankAcct.getString("finorgtype");
        if (finorgType != null && !finorgType.trim().isEmpty() && finorgType.equals(FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_bebankinfo"});
        }
        Object scene = this.getView().getFormShowParameter().getCustomParam("SCENE");
        this.getRelations(bankAcct);
        if (status == OperationStatus.ADDNEW || scene != null && scene.equals("AUDITFLOW")) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
        }
        if (model.getValue("inneracct") == null && model.getDataEntity().getBoolean("issetbankinterface")) {
            this.initBankVersionBox(false);
        }
    }

    public void afterBindData(EventObject e) {
        boolean isBank;
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        this.getView().setVisible(Boolean.valueOf("am".equals(appId)), new String[]{"bar_change"});
        this.handleBtnShow();
        this.loadFields();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            DynamicObject bankAcct = this.getModel().getDataEntity();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isvirtual"});
        }
        if (OperationStatus.EDIT.equals((Object)status)) {
            Map map = billShowParameter.getCustomParams();
            boolean isChangeOp = map.get("changeOp") == null ? false : (Boolean)map.get("changeOp");
            boolean isChangeApply = AmParameterHelper.getAppBoolParameter((long)((DynamicObject)this.getModel().getValue("company")).getLong("id"), (String)TmcParamEnum.AM003.getValue());
            this.getView().setVisible(Boolean.valueOf(!isChangeApply && isChangeOp), new String[]{"changetipsap"});
        }
        if (isBank = ((Boolean)this.getModel().getValue("issetbankinterface")).booleanValue()) {
            ((ComboEdit)this.getControl("bebankfunc")).setMustInput(true);
            ((ComboEdit)this.getControl("bankinterface")).setMustInput(true);
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvi();
        this.innitAcctPurpose();
        CardEntry cardEntry = (CardEntry)this.getView().getControl("relationentry");
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"bankfunction"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"bankfunction", (CharSequence)control.getKey())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("am_bankfunclist");
            formShowParameter.setCustomParam("pkid", (Object)this.getModel().getDataEntity().getPkValue().toString());
            formShowParameter.setCustomParam("opendate", this.getModel().getValue("opendate"));
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
            if (entries != null && !entries.isEmpty()) {
                ArrayList listMap = new ArrayList();
                for (DynamicObject row : entries) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("e_enable", row.get("e_enable"));
                    map.put("id", row.getPkValue());
                    map.put("e_bankfunction", row.get("e_bankfunction"));
                    map.put("e_predictopendate", row.get("e_predictopendate"));
                    map.put("e_actualopendate", row.get("e_actualopendate"));
                    map.put("e_billinfo", row.get("e_billinfo"));
                    map.put("seq", row.get("seq"));
                    listMap.add(map);
                }
                formShowParameter.setCustomParam("entries", listMap);
            }
            formShowParameter.setCustomParam("iselecpayment", this.getModel().getValue("iselecpayment"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "am_bankfunclist"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void innitAcctPurpose() {
        DynamicObject bankAcct = this.getModel().getDataEntity();
        DynamicObject company = bankAcct.getDynamicObject("company");
        BasedataEdit accProp = (BasedataEdit)this.getControl("acctproperty");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            return;
        }
        boolean isShowEnd = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"isselectend");
        if (!isShowEnd) {
            return;
        }
        accProp.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("isleaf", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    protected void initControlEvi() {
        DynamicObject bankAcct = this.getModel().getDataEntity();
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit defaultCurrencyF7 = (BasedataEdit)this.getControl("defaultcurrency");
        defaultCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter currencyQFilter = this.getCurrencyQFilter(bankAcct);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(currencyQFilter);
        });
        BasedataEdit strategyF7 = (BasedataEdit)this.getControl("strategy");
        strategyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("currency.id", "in", (Object)bankAcct.getLong("defaultcurrency.id"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit settlementtypeF7 = (BasedataEdit)this.getControl("settlementtype");
        settlementtypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")).and(new QFilter("settlementtype", "!=", (Object)"0"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit proxyCurrency = (BasedataEdit)this.getControl("proxycurrency");
        proxyCurrency.addBeforeF7SelectListener(evt -> {
            QFilter currencyQFilter = this.getCurrencyQFilter(bankAcct);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(currencyQFilter);
        });
    }

    public QFilter getCurrencyQFilter(DynamicObject bankAcct) {
        DynamicObjectCollection currencyCol = bankAcct.getDynamicObjectCollection("currency");
        HashSet<Long> currencyIDs = new HashSet<Long>();
        for (DynamicObject prop : currencyCol) {
            currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
        }
        QFilter qFilter = new QFilter("id", "in", currencyIDs);
        return qFilter;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        boolean isSetBankInterface = this.getModel().getDataEntity().getBoolean("issetbankinterface");
        String bebankfunc = (String)this.getModel().getValue("bebankfunc");
        String funcStr = this.getBankFunction(isSetBankInterface, bebankfunc);
        this.getModel().setValue("bankfunction", (Object)funcStr);
    }

    public String getBankFunction(boolean isSetBankInterface, String bebankfunc) {
        StringBuilder names = new StringBuilder();
        if (isSetBankInterface) {
            this.initBankVersionBox(false);
            if (StringUtils.isNotBlank((CharSequence)bebankfunc)) {
                if (bebankfunc.startsWith(",")) {
                    bebankfunc = bebankfunc.substring(1);
                }
                String[] values = bebankfunc.split(",");
                for (int i = 0; i < values.length; ++i) {
                    if (!StringUtils.isNotBlank((CharSequence)values[i])) continue;
                    String value = BankFuncEnum.getName((String)values[i]);
                    names.append(value);
                    names.append("\uff1b");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)names)) {
                names.deleteCharAt(names.length() - 1);
            }
        }
        return names.toString();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        if ("billname".equals(key)) {
            this.dealRelation(evt);
        }
    }

    private void dealRelation(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("relationentry", rowIndex);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("pkValue", entryRowEntity.get("relationbillid"));
            paramMap.put("formId", entryRowEntity.get("billtype"));
            paramMap.put("showType", ShowType.MainNewTabPage);
            AmCommonHelper.showWebBill(paramMap, (AbstractFormPlugin)this);
        }
    }

    private void getRelations(DynamicObject bankAcct) {
        List<Map<String, Object>> billMap = this.getInfoObject(bankAcct);
        TmcViewInputHelper.batchFillEntity((String)"relationentry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billMap);
    }

    private List<Map<String, Object>> getInfoObject(DynamicObject bankAcct) {
        String bankNum = bankAcct.getString("bankaccountnumber");
        if (EmptyUtil.isEmpty((String)bankNum)) {
            return new ArrayList<Map<String, Object>>();
        }
        Object bankAcctId = bankAcct.getPkValue();
        QFilter numFilter = new QFilter("bankaccountnumber", "in", (Object)bankNum);
        Map<Object, Object> bill = new HashMap();
        DynamicObject[] openBills = TmcDataServiceHelper.load((String)"am_accopenbill", (String)"id,createtime,applier", (QFilter[])new QFilter[]{numFilter});
        QFilter bankFilter = new QFilter("accountbank", "in", bankAcctId);
        DynamicObject[] closeBills = TmcDataServiceHelper.load((String)"am_acctclosebill", (String)"id,createtime,applier", (QFilter[])new QFilter[]{bankFilter});
        QFilter changeFilter = new QFilter("entryentity2.e_accountbank", "in", bankAcctId);
        DynamicObject[] changeBills = TmcDataServiceHelper.load((String)"am_changeapply", (String)"id,createtime,applyuser", (QFilter[])new QFilter[]{changeFilter}, (String)"createtime");
        ArrayList billList = new ArrayList(openBills.length + closeBills.length);
        for (DynamicObject openBill : openBills) {
            bill = this.getRelationBill(String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4%2$s", (String)"BankAccountEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), openBill.get("applier.name"), RelBillEnum.OPENBILL.getName()), RelBillEnum.OPENBILL.getValue(), openBill.getDate("createtime"), openBill.getPkValue());
            billList.add(bill);
        }
        for (DynamicObject closeBill : closeBills) {
            bill = this.getRelationBill(String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4%2$s", (String)"BankAccountEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), closeBill.get("applier.name"), RelBillEnum.CLOSEBILL.getName()), RelBillEnum.CLOSEBILL.getValue(), closeBill.getDate("createtime"), closeBill.getPkValue());
            billList.add(bill);
        }
        for (DynamicObject changeBill : changeBills) {
            bill = this.getRelationBill(String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4%2$s", (String)"BankAccountEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), changeBill.get("applyuser.name"), RelBillEnum.CHANGEBILL.getName()), RelBillEnum.CHANGEBILL.getValue(), changeBill.getDate("createtime"), changeBill.getPkValue());
            billList.add(bill);
        }
        billList.sort((bill1, bill2) -> {
            Date date1 = (Date)bill1.get("createdate");
            Date date2 = (Date)bill2.get("createdate");
            return date1.compareTo(date2);
        });
        return billList.stream().peek(map -> {
            Date date = (Date)map.get("createdate");
            map.put("createdate", DateUtils.formatString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }).collect(Collectors.toList());
    }

    public Map<String, Object> getRelationBill(String billName, String billType, Date createDate, Object pkValue) {
        HashMap<String, Object> bill = new HashMap<String, Object>();
        bill.put("billname", billName);
        bill.put("billtype", billType);
        bill.put("createdate", createDate);
        bill.put("relationbillid", pkValue);
        return bill;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] valueSet = args.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel model = this.getModel();
        switch (propName) {
            case "company": {
                this.verifyProcParam();
                break;
            }
            case "bank": {
                DynamicObject bankCate;
                DynamicObject bankObj;
                this.getModel().setValue("issetbankinterface", (Object)"0");
                this.getModel().setValue("acctname", null);
                DynamicObject dynamicObject = bankObj = null != propValue ? (DynamicObject)propValue : null;
                if (bankObj == null || !AmHelper.isNotEmpty((Object)(bankCate = bankObj.getDynamicObject("bank_cate")))) break;
                Long id = (Long)bankCate.getPkValue();
                String isvirtual = EmptyUtil.isNoEmpty((Long)id) && Boolean.TRUE.equals(VisibleVirtualAcctHelper.checkVirtualAcct((Long)id)) ? "1" : "0";
                this.getModel().setValue("isvirtual", (Object)isvirtual);
                break;
            }
            case "currency": {
                DynamicObjectCollection props;
                DynamicObjectCollection dynamicObjectCollection = props = null != propValue ? (DynamicObjectCollection)propValue : null;
                if (props == null) break;
                this.currencyChange(props);
                break;
            }
            case "defaultcurrency": {
                this.defCurrencyChange(propValue);
                break;
            }
            case "accttype": {
                model.setValue("isdefaultpay", (Object)"0");
                model.setValue("isdefaultrec", (Object)"0");
                break;
            }
            case "opendate": {
                Date newDate;
                Date operDateFormat;
                Date operDate = (Date)model.getValue("opendate");
                if (EmptyUtil.isEmpty((Object)operDate) || (operDateFormat = DateUtils.getDataFormat((Date)operDate, (boolean)true)).compareTo(newDate = DateUtils.getDataFormat((Date)new Date(), (boolean)true)) <= 0) break;
                model.setValue("opendate", (Object)new Date());
                this.getView().showTipNotification(new AmBizResource().getOpendateError());
                break;
            }
            case "issetbankinterface": {
                if (model.getDataEntity().getBoolean("issetbankinterface")) {
                    DynamicObject bank = model.getDataEntity().getDynamicObject("bank");
                    if (EmptyUtil.isEmpty((DynamicObject)bank)) {
                        this.getView().showErrorNotification(new AmBizResource().getErrorMissfinorg());
                        model.setValue("issetbankinterface", (Object)"0");
                        break;
                    }
                    int BankVersionSize = 0;
                    ComboEdit bankInterfaceControl = (ComboEdit)this.getControl("bankinterface");
                    try {
                        BankVersionSize = this.initBankVersionBox(true);
                    }
                    catch (Exception e) {
                        model.setValue("issetbankinterface", (Object)"0");
                        bankInterfaceControl.setMustInput(false);
                        this.getView().showErrorNotification(e.getMessage());
                        ((ComboEdit)this.getControl("bebankfunc")).setMustInput(false);
                        return;
                    }
                    if (BankVersionSize < 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u524d\u5f80\u201c\u8d44\u91d1\u4e91>\u94f6\u4f01\u4e92\u8054>\u94f6\u4f01\u670d\u52a1\u914d\u7f6e\u201d\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"BankAccountEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                        bankInterfaceControl.setComboItems(null);
                    }
                    ((ComboEdit)this.getControl("bebankfunc")).setMustInput(true);
                    bankInterfaceControl.setMustInput(true);
                    break;
                }
                ((ComboEdit)this.getControl("bebankfunc")).setMustInput(false);
                break;
            }
            case "isdefaultrec": {
                Object[] bankAcctRecs;
                if (!model.getDataEntity().getBoolean("isdefaultrec") || ArrayUtils.isEmpty((Object[])(bankAcctRecs = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue()), new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("company")).getPkValue()), new QFilter("isdefaultrec", "=", (Object)Boolean.TRUE), new QFilter("acctstatus", "!=", (Object)"closed")})))) break;
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u91d1\u7ec4\u7ec7\u5df2\u8bbe\u7f6e\u94f6\u884c\u8d26\u53f7\u201c%1$s\u201d\u4e3a\u9ed8\u8ba4\u6536\u6b3e\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d8\u66f4\u94f6\u884c\u8d26\u53f7\u201c%2$s\u201d\u505a\u4e3a\u9ed8\u8ba4\u6536\u6b3e\u6237\uff1f", (String)"BankAccountEdit_3", (String)"tmc-am-formplugin", (Object[])new Object[0]), bankAcctRecs[0].getString("bankaccountnumber"), this.getModel().getValue("bankaccountnumber")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("defaultrec", (IFormPlugin)this));
                break;
            }
            case "isdefaultpay": {
                Object[] bankAcctPays;
                if (!model.getDataEntity().getBoolean("isdefaultpay") || ArrayUtils.isEmpty((Object[])(bankAcctPays = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue()), new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("company")).getPkValue()), new QFilter("isdefaultpay", "=", (Object)Boolean.TRUE), new QFilter("acctstatus", "!=", (Object)"closed")})))) break;
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u91d1\u7ec4\u7ec7\u5df2\u8bbe\u7f6e\u94f6\u884c\u8d26\u53f7\u201c%1$s\u201d\u4e3a\u9ed8\u8ba4\u4ed8\u6b3e\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d8\u66f4\u94f6\u884c\u8d26\u53f7\u201c%2$s\u201d\u505a\u4e3a\u9ed8\u8ba4\u4ed8\u6b3e\u6237\uff1f", (String)"BankAccountEdit_4", (String)"tmc-am-formplugin", (Object[])new Object[0]), bankAcctPays[0].getString("bankaccountnumber"), this.getModel().getValue("bankaccountnumber")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("defaultpay", (IFormPlugin)this));
                break;
            }
            case "bankinterface": {
                this.initBankAcctTypes();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"defaultrec") && !MessageBoxResult.Yes.equals((Object)res)) {
            this.getModel().setValue("isdefaultrec", (Object)false);
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)"defaultpay") && !MessageBoxResult.Yes.equals((Object)res)) {
            this.getModel().setValue("isdefaultpay", (Object)false);
        } else if (StringUtils.equals((CharSequence)id, (CharSequence)this.CALLBACKKEY_SAVE) && MessageBoxResult.Yes.equals((Object)res)) {
            this.getView().getPageCache().put("saveConfirmCallBack", "1");
            this.getView().invokeOperation(this.CALLBACKKEY_SAVE);
        }
    }

    private int initBankVersionBox(boolean isSelectFirst) {
        int BankVersionSize = 0;
        try {
            EBGetLoginListResult loginListResult = BankServiceHelper.getLoginListResult((DynamicObject)this.getModel().getDataEntity());
            Map bankVersionMap = loginListResult.getLoginMap();
            this.getView().getPageCache().put("EBGetLoginListResult", JSON.toJSONString((Object)loginListResult));
            logger.info("BankAccountEdit initBankAcctTypes cache Str 1:{}", (Object)JSON.toJSONString((Object)loginListResult));
            if (null != bankVersionMap) {
                ArrayList<String> bankVersionList;
                if (Boolean.TRUE.equals(this.getModel().getValue("iselecpayment"))) {
                    bankVersionList = new ArrayList<String>(10);
                    for (String string : bankVersionMap.keySet()) {
                        if (string.contains("ECNY")) continue;
                        bankVersionList.add(string);
                    }
                    bankVersionList.forEach(bankVersionMap::remove);
                } else {
                    bankVersionList = new ArrayList(10);
                    for (String string : bankVersionMap.keySet()) {
                        if (!string.contains("ECNY")) continue;
                        bankVersionList.add(string);
                    }
                    bankVersionList.forEach(bankVersionMap::remove);
                }
                ArrayList<ComboItem> bankVersionItems = new ArrayList<ComboItem>(bankVersionMap.size());
                for (Map.Entry entry : bankVersionMap.entrySet()) {
                    ComboItem item = new ComboItem(new LocaleString((String)entry.getValue() + "  " + (String)entry.getKey()), (String)entry.getKey());
                    bankVersionItems.add(item);
                }
                ComboEdit bankVersion = (ComboEdit)this.getControl("bankinterface");
                bankVersion.setComboItems(bankVersionItems);
                BankVersionSize = bankVersionItems.size();
                if (isSelectFirst) {
                    String string = this.getKeyword(this.getModel().getDataEntity());
                    List keywordMatchList = bankVersionMap.entrySet().stream().filter(o -> ((String)o.getValue()).contains(keyword.trim())).collect(Collectors.toList());
                    String bankInterFace = "";
                    if (string != null && keywordMatchList.size() > 0) {
                        bankInterFace = (String)((Map.Entry)keywordMatchList.get(0)).getKey();
                    } else if (bankVersionItems.size() > 0) {
                        bankInterFace = ((ComboItem)bankVersionItems.get(0)).getValue();
                    }
                    this.getModel().setValue("bankinterface", (Object)bankInterFace);
                }
            }
            this.initBankAcctTypes();
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u94f6\u884c\u63a5\u53e3\u4e0b\u62c9\u5217\u8868\u5f02\u5e38\u3002", (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
        }
        return BankVersionSize;
    }

    public void initBankAcctTypes() {
        Map bankAccTypeMap;
        String pageCacheStr = this.getView().getPageCache().get("EBGetLoginListResult");
        logger.info("BankAccountEdit initBankAcctTypes cache Str 2:{}", (Object)pageCacheStr);
        EBGetLoginListResult loginListResult = (EBGetLoginListResult)JSON.parseObject((String)pageCacheStr, EBGetLoginListResult.class);
        if (EmptyUtil.isNoEmpty((Object)loginListResult) && null != (bankAccTypeMap = loginListResult.getBankAccTypeMap())) {
            logger.info("BankAccountEdit initBankAcctTypes cache Str 3:{}", this.getModel().getValue("bankinterface"));
            Map stringMap = (Map)bankAccTypeMap.get(this.getModel().getValue("bankinterface"));
            if (null != stringMap) {
                ArrayList<ComboItem> bankAccTypeItems = new ArrayList<ComboItem>(stringMap.size());
                for (Map.Entry entry : stringMap.entrySet()) {
                    ComboItem item = new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey());
                    bankAccTypeItems.add(item);
                }
                ComboEdit bankVersion = (ComboEdit)this.getControl("additionalproperty");
                bankVersion.setComboItems(bankAccTypeItems);
                Object obj = this.getModel().getValue("additionalproperty");
                if (obj == null && bankAccTypeItems.size() > 0) {
                    this.getModel().setValue("additionalproperty", (Object)((ComboItem)bankAccTypeItems.get(0)).getValue());
                }
            }
        }
    }

    private String getKeyword(DynamicObject bankAcct) {
        String keyword = null;
        DynamicObject finOrg = bankAcct.getDynamicObject("bank");
        if (finOrg != null) {
            String finOrgType = bankAcct.getString("finorgtype");
            if (finOrgType.equals("0")) {
                DynamicObject bankCate = finOrg.getDynamicObject("bank_cate");
                if (bankCate != null) {
                    keyword = bankCate.getString("name");
                }
            } else {
                keyword = finOrg.getString("name");
            }
        }
        return keyword;
    }

    private void currencyChange(DynamicObjectCollection currencys) {
        DynamicObject currency;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
            return;
        }
        IDataModel model = this.getModel();
        int size = currencys.size();
        if (size != 0 && !EmptyUtil.isEmpty((Object)(currency = (DynamicObject)currencys.get(0)).get("fbasedataid"))) {
            model.setValue("defaultcurrency", (Object)((Long)((DataEntityBase)currency.get("fbasedataid")).getPkValue()));
            this.defCurrencyChange(model.getValue("defaultcurrency"));
        }
        if (size <= 1) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"defaultcurrency"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"defaultcurrency"});
        }
    }

    private void defCurrencyChange(Object propValue) {
        if (!EmptyUtil.isEmpty((Object)propValue)) {
            DynamicObject defCurrency = (DynamicObject)propValue;
            this.getModel().setValue("managecurrency", (Object)defCurrency);
        }
        this.getModel().setValue("strategy", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (Objects.equals("preclose", operateKey)) {
            String createOrg = (String)this.getView().getFormShowParameter().getCustomParam("createorg");
            FormOperate operate = (FormOperate)args.getSource();
            operate.getOption().setVariableValue("createorg", createOrg);
        } else if (Objects.equals("save", operateKey)) {
            String saveConfirmCallBack = this.getView().getPageCache().get("saveConfirmCallBack");
            if (!"1".equals(saveConfirmCallBack)) {
                Object[] proxyAcctDc;
                IDataModel model = this.getModel();
                DynamicObject bankAcct = model.getDataEntity();
                String beBankFunc = bankAcct.getString("bebankfunc");
                if (beBankFunc != null && !beBankFunc.contains("proxyinquiry") && EmptyUtil.isNoEmpty((Object)bankAcct.getPkValue()) && EmptyUtil.isNoEmpty((Object[])(proxyAcctDc = BusinessDataServiceHelper.load((String)"am_proxyinquiryaccount", (String)"id", (QFilter[])new QFilter[]{new QFilter("bankacct", "=", bankAcct.getPkValue())})))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8d26\u6237\u5b58\u5728\u5bf9\u5e94\u4ee3\u7406\u67e5\u8be2\u8d26\u6237\uff0c\u5f53\u524d\u64cd\u4f5c\u4f1a\u5220\u9664\u76f8\u5173\u7684\u4ee3\u7406\u67e5\u8be2\u8d26\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8fdb\u884c\u7ee7\u7eed\uff1f", (String)"BankAccountProxyInquiryTips_0", (String)"tmc-am-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(this.CALLBACKKEY_SAVE));
                    args.setCancel(Boolean.TRUE.booleanValue());
                }
            } else {
                this.getView().getPageCache().put("saveConfirmCallBack", "0");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        OperationResult result = args.getOperationResult();
        if (null == result) {
            return;
        }
        if (result.isSuccess()) {
            QFilter idFilter;
            String entityName;
            if (operateKey.equals("preclose")) {
                DynamicObject company = bankAcct.getDynamicObject("company");
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashMap<String, DynamicObject> customParam = new HashMap<String, DynamicObject>();
                customParam.put("accountbank", bankAcct);
                param.put("customParam", customParam);
                boolean isCloseAcctByProcess = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)TmcParamEnum.AM002.getValue());
                if (!isCloseAcctByProcess && !BankAcctHelper.isInnerAcct((DynamicObject)bankAcct)) {
                    param.put("formId", "am_acctclosedetail");
                    param.put("showType", ShowType.Modal);
                    param.put("needCallBack", Boolean.TRUE);
                    AmCommonHelper.showWebForm(param, (AbstractFormPlugin)this);
                } else {
                    param.put("formId", "am_acctclosebill");
                    param.put("showType", ShowType.MainNewTabPage);
                    AmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                }
            } else if (operateKey.equals("change")) {
                Object pkValue = bankAcct.getPkValue();
                boolean isChangeApply = AmParameterHelper.getAppBoolParameter((long)((DynamicObject)this.getModel().getValue("company")).getLong("id"), (String)TmcParamEnum.AM003.getValue());
                if (!isChangeApply) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6240\u5c5e\u8d44\u91d1\u7ec4\u7ec7\u6ca1\u6709\u5f00\u542f\u201c\u94f6\u884c\u8d26\u6237\u5fc5\u987b\u901a\u8fc7\u53d8\u66f4\u6d41\u7a0b\u53d8\u66f4\u201d\u53c2\u6570\uff0c\u65e0\u9700\u8d70\u53d8\u66f4\u6d41\u7a0b\u3002", (String)"BankAccountEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                } else {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    HashMap<String, String> customParam = new HashMap<String, String>();
                    customParam.put("accountbank", JSON.toJSONString((Object)new Object[]{pkValue}));
                    param.put("customParam", customParam);
                    param.put("formId", "am_changeapply");
                    param.put("showType", ShowType.MainNewTabPage);
                    AmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                }
            } else if (operateKey.equals("uncloseacct") || operateKey.equals("closeacct")) {
                this.getView().invokeOperation("refresh");
                this.handleBtnShow();
            } else if (operateKey.equals("save")) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acctstatus"});
                this.loadFields();
            } else if (operateKey.equals("checkupchangebill")) {
                entityName = "am_changeapply";
                idFilter = new QFilter("entryentity2.e_accountbank.id", "=", bankAcct.getPkValue());
                this.queryRelevancyBill(entityName, idFilter);
            } else if (operateKey.equals("checkupclosedbill")) {
                entityName = "am_acctclosebill";
                idFilter = new QFilter("accountbank.id", "in", bankAcct.getPkValue());
                this.queryRelevancyBill(entityName, idFilter);
            }
        }
        if (operateKey.equals("save")) {
            FormOperate operate = (FormOperate)args.getSource();
            String currencyIsReduce = operate.getOption().getVariables().getOrDefault("currencyIsReduce", null);
            if (StringUtil.isEmpty((String)currencyIsReduce)) {
                this.getView().updateView("company");
            }
            this.loadFields();
        }
        this.getModel().setDataChanged(false);
    }

    public void queryRelevancyBill(String entityName, QFilter idFilter) {
        Set<Object> idSet = this.getBillIds(entityName, idFilter);
        int count = idSet.size();
        if (count <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"BankAccountList_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        } else if (idSet.size() > 1) {
            this.showBillList(entityName, idSet);
        } else {
            this.showBill(entityName, idSet);
        }
    }

    public Set<Object> getBillIds(String entityName, QFilter idFilter) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{idFilter});
        HashSet<Object> idSet = new HashSet<Object>(10);
        if (bills != null && bills.size() > 0) {
            for (DynamicObject item : bills) {
                idSet.add(item.get("id"));
            }
        }
        return idSet;
    }

    public void showBillList(String formId, Set<Object> ids) {
        QFilter idFilter = new QFilter("id", "in", (Object)ids.toArray());
        ListShowParameter listShowParameter = new ListShowParameter();
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(idFilter);
        listShowParameter.setListFilterParameter(lfp);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(formId);
        listShowParameter.setCustomParam("from", (Object)"am_accountbank");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void showBill(String formId, Set<Object> ids) {
        BaseShowParameter billShowParameter = new BaseShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setFormId(formId);
        billShowParameter.setPkId(ids.stream().toArray()[0]);
        billShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String bebankfunc = (String)this.getModel().getValue("bebankfunc");
        StringBuilder names = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)bebankfunc)) {
            if (bebankfunc.startsWith(",")) {
                bebankfunc = bebankfunc.substring(1);
            }
            String[] values = bebankfunc.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)values[i])) continue;
                String value = BankFuncEnum.getName((String)values[i]);
                names.append(value);
                names.append("\uff1b");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)names)) {
            names.deleteCharAt(names.length() - 1);
            this.getModel().setValue("bankfunction", (Object)names.toString());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"am_acctclosedetail")) {
            Map data2 = (Map)closedCallBackEvent.getReturnData();
            if (data2 != null) {
                Date closeDate = (Date)data2.get("closedate");
                String reason = (String)data2.get("closereason");
                OperateOption option = OperateOption.create();
                option.setVariableValue("closereason", reason);
                option.setVariableValue("closedate", DateUtils.formatString((Date)closeDate, (String)"yyyy-MM-dd HH:mm:ss"));
                this.getView().invokeOperation("closeacct", option);
            }
        } else if (StringUtils.equals((CharSequence)action, (CharSequence)"am_bankfunclist") && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            DynamicObjectCollection rows = (DynamicObjectCollection)data.get("rows");
            StringBuilder values = new StringBuilder();
            StringBuilder names = new StringBuilder();
            ArrayList listMap = new ArrayList();
            for (DynamicObject row : rows) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (row.getBoolean("enable")) {
                    values.append(row.get("bankfunction")).append(",");
                    names.append(BankFuncEnum.getName((String)row.getString("bankfunction"))).append("\uff1b");
                }
                map.put("e_enable", row.get("enable"));
                map.put("id", row.getPkValue());
                map.put("e_bankfunction", row.get("bankfunction"));
                map.put("e_predictopendate", row.get("predictopendate"));
                map.put("e_actualopendate", row.get("actualopendate"));
                map.put("e_billinfo", row.get("billinfo"));
                map.put("seq", row.get("seq"));
                listMap.add(map);
            }
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), listMap);
            if (StringUtils.isNotBlank((CharSequence)values)) {
                values.deleteCharAt(values.length() - 1);
            }
            this.getModel().setValue("bebankfunc", (Object)values);
            if (StringUtils.isNotBlank((CharSequence)names)) {
                names.deleteCharAt(names.length() - 1);
            }
            this.getModel().setValue("bankfunction", (Object)names);
        }
    }

    private void handleBtnShow() {
        DynamicObject bankAcct = this.getModel().getDataEntity();
        String acctStatus = bankAcct.getString("acctstatus");
        IFormView view = this.getView();
        if (BankAcctStatusEnum.NORMAL.getValue().equals(acctStatus)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"attachmentpanelap"});
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            OperationStatus status = billShowParameter.getStatus();
            if (status == OperationStatus.ADDNEW) {
                view.setVisible(Boolean.FALSE, new String[]{"barcloseacct", "baruncloseacct", "bar_change"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"barcloseacct", "bar_save", "bar_change"});
                view.setVisible(Boolean.FALSE, new String[]{"baruncloseacct"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_change"});
        }
        if (BankAcctStatusEnum.CLOSING.getValue().equals(acctStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"barcloseacct", "baruncloseacct", "bar_save"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
        }
        if (BankAcctStatusEnum.CLOSED.getValue().equals(acctStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{"barcloseacct", "bar_save"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
            long currentOrg = RequestContext.get().getOrgId();
            boolean closeMustByPro = AmParameterHelper.getAppBoolParameter((long)currentOrg, (String)TmcParamEnum.AM002.getValue());
            if (closeMustByPro) {
                view.setVisible(Boolean.FALSE, new String[]{"baruncloseacct"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"baruncloseacct"});
            }
        }
        view.setVisible(Boolean.FALSE, new String[]{"changetipsap"});
    }

    private void verifyProcParam() {
        IDataModel model = this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        DynamicObject company = bankAcct.getDynamicObject("company");
        String isOpenByProcess = "0";
        if (!EmptyUtil.isEmpty((DynamicObject)company)) {
            isOpenByProcess = AmParameterHelper.getAppStringParameter((long)company.getLong("id"), (String)TmcParamEnum.AM001.getValue());
        }
        if (status == OperationStatus.ADDNEW && "1".equals(isOpenByProcess)) {
            this.getView().showTipNotification(new AmBizResource().getErrorUndIrectopen());
            model.setValue("company", null);
            model.setValue("openorg", null);
        }
    }
}

