/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.bankacct;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.sdk.tmc.am.extpoint.bankacct.IBankAccountFilter;
import kd.tmc.am.common.errorcode.BankAcctErrorCode;
import kd.tmc.am.common.helper.AmCommonHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.am.common.helper.BankAcctHelper;
import kd.tmc.am.common.resource.BankAcctBizResource;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.TmcParamEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class BankAccountList
extends AbstractTmcDataBaseList {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (null != result && result.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (operateKey.equals("preclose")) {
                Object pkValue = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject bankAcct = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)"bd_accountbanks");
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashMap<String, DynamicObject> customParam = new HashMap<String, DynamicObject>();
                customParam.put("accountbank", bankAcct);
                param.put("customParam", customParam);
                boolean isCloseAcctByProcess = AmParameterHelper.getAppBoolParameter((long)bankAcct.getDynamicObject("company").getLong("id"), (String)TmcParamEnum.AM002.getValue());
                if (!isCloseAcctByProcess && !BankAcctHelper.isInnerAcct((DynamicObject)bankAcct)) {
                    param.put("formId", "am_acctclosedetail");
                    param.put("showType", ShowType.Modal);
                    param.put("needCallBack", Boolean.TRUE);
                    AmCommonHelper.showWebForm(param, (AbstractFormPlugin)this);
                } else {
                    param.put("formId", "am_acctclosebill");
                    param.put("showType", ShowType.MainNewTabPage);
                    AmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                }
            } else if (operateKey.equals("change")) {
                Set pkValues = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                QFilter idQFilter = new QFilter("id", "in", pkValues);
                DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,company.id", (QFilter[])new QFilter[]{idQFilter});
                boolean isChangeApply = AmParameterHelper.getAppBoolParameter((long)bankAccounts[0].getDynamicObject("company").getLong("id"), (String)TmcParamEnum.AM003.getValue());
                if (!isChangeApply) {
                    this.showBill((Long)pkValues.iterator().next(), true);
                } else {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    HashMap<String, String> customParam = new HashMap<String, String>();
                    customParam.put("accountbank", JSON.toJSONString(pkValues));
                    param.put("customParam", customParam);
                    param.put("formId", "am_changeapply");
                    param.put("showType", ShowType.MainNewTabPage);
                    AmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
                }
            } else if (operateKey.equals("checkupchangebill")) {
                Set pkValues = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                String entityName = "am_changeapply";
                QFilter idFilter = new QFilter("entryentity2.e_accountbank.id", "in", (Object)pkValues.toArray());
                this.queryRelevancyBill(entityName, idFilter);
            } else if (operateKey.equals("checkupclosedbill")) {
                Set pkValues = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                String entityName = "am_acctclosebill";
                QFilter idFilter = new QFilter("accountbank.id", "in", (Object)pkValues.toArray());
                this.queryRelevancyBill(entityName, idFilter);
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"managetransfer")) {
                Object pkValue = selectedRows.get(0).getPrimaryKeyValue();
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                HashMap<String, Object> customParam = new HashMap<String, Object>(8);
                customParam.put("id", pkValue);
                param.put("customParam", customParam);
                param.put("showType", ShowType.MainNewTabPage);
                param.put("formId", "am_management_transfer");
                AmCommonHelper.showWebBill(param, (AbstractFormPlugin)this);
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"assigncancel")) {
                List pkValues = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                HashMap customParam = new HashMap(8);
                customParam.put("accountbank", pkValues);
                param.put("customParam", customParam);
                param.put("showType", ShowType.MainNewTabPage);
                param.put("formId", "am_assign_cancel");
                AmCommonHelper.showWebForm(param, (AbstractFormPlugin)this);
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"managetransferlist")) {
                Object pkValue = selectedRows.get(0).getPrimaryKeyValue();
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("showType", ShowType.MainNewTabPage);
                param.put("billFormId", "am_management_transfer");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                qFilters.add(new QFilter("accountbank", "=", pkValue));
                param.put("filters", qFilters);
                AmCommonHelper.showFormList(param, (AbstractFormPlugin)this);
            }
        }
        ((BillList)this.getControl("billlistap")).refreshData();
    }

    public void queryRelevancyBill(String entityName, QFilter idFilter) {
        Set<Object> idSet = this.getBillIds(entityName, idFilter);
        int count = idSet.size();
        if (count <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"BankAccountList_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        } else if (idSet.size() > 1) {
            this.showBillList(entityName, idSet);
        } else {
            this.showBill(entityName, idSet);
        }
    }

    public Set<Object> getBillIds(String entityName, QFilter idFilter) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{idFilter});
        HashSet<Object> idSet = new HashSet<Object>(10);
        if (bills != null && bills.size() > 0) {
            for (DynamicObject item : bills) {
                idSet.add(item.get("id"));
            }
        }
        return idSet;
    }

    public void showBillList(String formId, Set<Object> ids) {
        QFilter idFilter = new QFilter("id", "in", (Object)ids.toArray());
        ListShowParameter listShowParameter = new ListShowParameter();
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(idFilter);
        listShowParameter.setListFilterParameter(lfp);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId(formId);
        listShowParameter.setCustomParam("from", (Object)"am_accountbank");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void showBill(String formId, Set<Object> ids) {
        BaseShowParameter billShowParameter = new BaseShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setFormId(formId);
        billShowParameter.setPkId(ids.stream().toArray()[0]);
        billShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (Objects.equals("bankaccountnumber", fieldName)) {
            args.setCancel(true);
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String customFilter = this.getPageCache().get("customfilter");
            if (!StringUtils.isEmpty((CharSequence)customFilter)) {
                formShowParameter.setCustomParam("customfilter", (Object)customFilter);
            }
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow selectedRowInfo = billList.getCurrentSelectedRowInfo();
            Long id = (Long)selectedRowInfo.getPrimaryKeyValue();
            this.showBill(id);
        }
    }

    private void showBill(Long billId) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("am_accountbank");
        parameter.setCustomParam("createorg", (Object)this.getPageCache().get("createOrg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showBill(Long billId, boolean isChangeOp) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setFormId("am_accountbank");
        parameter.setCustomParam("createorg", (Object)this.getPageCache().get("createOrg"));
        parameter.setCustomParam("changeOp", (Object)isChangeOp);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String createOrg;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String cacheCreateOrg = this.getPageCache().get("createOrg");
        OperateOption option = operate.getOption();
        if (operateKey.equals("freeze") || operateKey.equals("unfreeze") || operateKey.equals("assign")) {
            createOrg = this.getPageCache().get("createOrg");
            operate.getOption().setVariableValue("createOrg", createOrg);
        }
        if ("delete".equals(operateKey)) {
            List selectedIdList = this.getSelectedIdList();
            DeleteServiceHelper.delete((String)"cas_bankvccheck", (QFilter[])new QFilter[]{new QFilter("accountbank", "in", (Object)selectedIdList)});
        }
        if ("preclose".equals(operateKey)) {
            createOrg = this.getPageCache().get("createOrg");
            operate.getOption().setVariableValue("createorg", createOrg);
        }
        switch (operateKey) {
            case "managetransfer": 
            case "assigncancel": {
                option.setVariableValue("createorg", cacheCreateOrg);
                break;
            }
            case "managetransferlist": {
                List selectedIdList = this.getSelectedIdList();
                if (selectedIdList.size() <= 1) break;
                this.getView().showTipNotification(new BankAcctErrorCode().BATCH_OP_ERROR().getMessage());
                args.setCancel(true);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"am_acctclosedetail") && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            Date closeDate = (Date)data.get("closedate");
            String reason = (String)data.get("closereason");
            OperateOption option = OperateOption.create();
            option.setVariableValue("closereason", reason);
            option.setVariableValue("closedate", DateUtils.formatString((Date)closeDate, (String)"yyyy-MM-dd HH:mm:ss"));
            this.getView().invokeOperation("closeacct", option);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237", (String)"BankAccountList_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        String useOrgStr = this.getPageCache().get("createOrg");
        if (EmptyUtil.isNoEmpty((String)useOrgStr)) {
            List<Long> selOrgs = Collections.singletonList(Long.valueOf(useOrgStr));
            e.getParameter().getCustomParams().put("selectedFilterOrgs", JSON.toJSONString(selOrgs));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        BillList billList;
        if (evt.getItemKey().equals("bar_copy")) {
            billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() != 1) {
                return;
            }
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject bankAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"am_accountbank", (String)"finorgtype");
            if (Objects.nonNull(bankAccount) && Objects.equals(bankAccount.get("finorgtype"), FinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5185\u90e8\u8d26\u6237\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"BankAccountList_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            }
        }
        if ("bdctrlchange".equals(evt.getItemKey())) {
            DynamicObject[] bankAcctArray;
            billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            List accountIds = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            QFilter acctFilter = new QFilter("id", "in", accountIds);
            for (DynamicObject bankAcct : bankAcctArray = TmcDataServiceHelper.load((String)"am_accountbank", (String)"id,bankaccountnumber,iselecpayment", (QFilter[])new QFilter[]{acctFilter})) {
                QFilter acctCloseFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
                acctCloseFilter.and(new QFilter("accountbank", "=", bankAcct.getPkValue()));
                boolean isExistAcctCloseBill = TmcDataServiceHelper.exists((String)"am_acctclosebill", (QFilter[])new QFilter[]{acctCloseFilter});
                if (isExistAcctCloseBill) {
                    this.getView().showErrorNotification(new BankAcctBizResource().getExistAcctCloseBill(bankAcct.getString("bankaccountnumber")));
                    evt.setCancel(true);
                    break;
                }
                QFilter acctChangeApplyFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
                acctChangeApplyFilter.and(new QFilter("entryentity2.e_accountbank", "=", bankAcct.getPkValue()));
                boolean isExitsChangeApplyBill = QueryServiceHelper.exists((String)"am_changeapply", (QFilter[])new QFilter[]{acctChangeApplyFilter});
                if (isExitsChangeApplyBill) {
                    this.getView().showErrorNotification(new BankAcctBizResource().getExistChangeApplyBill(bankAcct.getString("bankaccountnumber")));
                    evt.setCancel(true);
                    break;
                }
                if (!bankAcct.getBoolean("iselecpayment")) continue;
                this.getView().showTipNotification(new BankAcctBizResource().getElecPaymentValidator(bankAcct.getString("bankaccountnumber")));
                evt.setCancel(true);
                break;
            }
        }
        switch (evt.getItemKey()) {
            case "orgpermchange": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u94f6\u884c\u8d26\u6237\u7684\u3010\u7ba1\u7406\u6743\u8f6c\u8ba9\u3011\u529f\u80fd\u3002", (String)"BankAccountList_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.setIFilters(e, this.getView());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.addIFilterColumn(args, this.getView());
    }

    private void addIFilterColumn(FilterContainerInitArgs args, IFormView formView) {
        PluginProxy pluginProxy = PluginProxy.create(IBankAccountFilter.class, (String)"kd.sdk.tmc.am.extpoint.bankacct.interest.IBankAccountFilter");
        pluginProxy.callReplace(proxy -> {
            proxy.addIFilterColumn(args, formView);
            return null;
        });
    }

    private void setIFilters(SetFilterEvent e, IFormView formView) {
        PluginProxy pluginProxy = PluginProxy.create(IBankAccountFilter.class, (String)"kd.sdk.tmc.am.extpoint.bankacct.interest.IBankAccountFilter");
        pluginProxy.callReplace(proxy -> {
            proxy.setIFilters(e, formView);
            return null;
        });
    }
}

