/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.changeapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.am.common.enums.AmPropertyTypeEnum;
import kd.tmc.am.common.helper.AccountBankHelper;
import kd.tmc.am.common.helper.AmParameterHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class ChangeApplyEdit
extends AbstractBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(ChangeApplyEdit.class);
    private static final String AM_CHANGEAPPLY_CONFIG = "am_changeapply_config";
    private static final String[] HIDE_FIELDS = new String[]{"sourcedata", "modifier", "netbank", "number", "scorg", "sourcebillid", "authquerpt", "acctstatus", "status", "modifytime", "financialchapter", "ismulcurrency", "createtime", "creator", "inneracct", "org", "bankaccountnumber", "closereason", "bitindex", "srcindex", "finorgtype", "commonseal", "legalperson"};
    private static final String[] HIDE_INNER_FIELDS = new String[]{"sourcedata", "modifier", "netbank", "number", "scorg", "sourcebillid", "authquerpt", "acctstatus", "status", "modifytime", "financialchapter", "ismulcurrency", "createtime", "creator", "inneracct", "org", "bankaccountnumber", "closereason", "bitindex", "srcindex", "finorgtype", "commonseal", "legalperson", "isopenbank", "bankfunc", "currencyname", "issetbankinterface", "noopenbeireason", "defaultcurrency", "currency", "bankinterface", "enable", "bank", "noopenlinereason"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"e_beforechange", "e_afterchange", "e_afterchangename"});
        this.initSettleAcct();
    }

    private void innitAcctPurpose(ItemClassEdit basedataProp) {
        DynamicObject bankAcct = this.getModel().getDataEntity(true).getDynamicObject("accountbank");
        DynamicObject company = bankAcct.getDynamicObject("company");
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            return;
        }
        boolean isShowEnd = AmParameterHelper.getAppBoolParameter((long)company.getLong("id"), (String)"isselectend");
        if (!isShowEnd) {
            return;
        }
        basedataProp.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("isleaf", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initProxyCurrencyF7(ItemClassEdit baseDataProp) {
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntity2 = dataEntity.getDynamicObjectCollection("entryentity2");
        ArrayList currencyList = new ArrayList(10);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<Object> changeCurrencies = new ArrayList<Object>(10);
        if (entryEntity != null && entryEntity.size() > 0) {
            for (DynamicObject entry : entryEntity) {
                DynamicObjectCollection eCurrencies;
                if (!"currency".equals(entry.getString("e_changefield")) || (eCurrencies = entry.getDynamicObjectCollection("e_currency")) == null || eCurrencies.size() <= 0) continue;
                for (DynamicObject data : eCurrencies) {
                    DynamicObject obj = data.getDynamicObject("fbasedataid");
                    if (EmptyUtil.isEmpty((DynamicObject)obj)) continue;
                    changeCurrencies.add(obj.getPkValue());
                }
            }
        }
        if (changeCurrencies.size() > 0) {
            currencyList.addAll(changeCurrencies);
        } else if (entryEntity2 != null && entryEntity2.size() > 0) {
            for (DynamicObject entry : entryEntity2) {
                DynamicObject eAccountBank = entry.getDynamicObject("e_accountbank");
                if (eAccountBank == null) continue;
                DynamicObjectCollection acctCurrencies = eAccountBank.getDynamicObjectCollection("currency");
                ArrayList<Object> entryCur = new ArrayList<Object>(10);
                if (acctCurrencies == null || acctCurrencies.size() <= 0) continue;
                for (DynamicObject data : acctCurrencies) {
                    DynamicObject obj = data.getDynamicObject("fbasedataid");
                    if (EmptyUtil.isEmpty((DynamicObject)obj)) continue;
                    entryCur.add(obj.getPkValue());
                }
                if (currencyList.size() > 0) {
                    currencyList.retainAll(entryCur);
                    continue;
                }
                currencyList.addAll(entryCur);
            }
        }
        baseDataProp.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", (Object)currencyList.toArray());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initSettleAcct() {
        BasedataEdit settleAcctF7 = (BasedataEdit)this.getControl("e_relatedsettleacct");
        settleAcctF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            qFilter.and("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
            qFilter.and("iselecpayment", "!=", (Object)true);
            DynamicObjectCollection accountEntryEntities = this.getModel().getEntryEntity("entryentity2");
            DynamicObject bankAcct = ((DynamicObject)accountEntryEntities.get(0)).getDynamicObject("e_accountbank");
            Set acctSet = AccountBankHelper.getElecPaymentRelatedAcctIds((Long)bankAcct.getLong("id"));
            qFilter.and("id", "not in", (Object)acctSet);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void afterCreateNewData(EventObject e) {
        IBillModel model = (IBillModel)this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List bankAcctIds = JSONArray.parseArray(customParams.get("accountbank") == null ? null : customParams.get("accountbank").toString(), Object.class);
        if (bankAcctIds != null && bankAcctIds.size() > 0) {
            for (Object bankAcctId : bankAcctIds) {
                int rowIndex = this.getModel().createNewEntryRow("entryentity2");
                this.getModel().setValue("e_accountbank", bankAcctId, rowIndex);
            }
            model.setValue("accountbank", bankAcctIds.get(0));
            model.setValue("company", ((DynamicObject)this.getModel().getValue("accountbank")).getDynamicObject("company").getPkValue());
            this.getView().updateView();
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.initBillBusinessFieldComboEditControl();
    }

    private void initBillBusinessFieldComboEditControl() {
        ComboEdit businessBillComboEdit = (ComboEdit)this.getControl("e_changefield");
        Map<String, LocaleString> fieldColumn = this.getFields();
        this.dealElecPayment(fieldColumn);
        ArrayList<ComboItem> businessBillComboItemList = new ArrayList<ComboItem>(fieldColumn.size());
        for (Map.Entry<String, LocaleString> entry : fieldColumn.entrySet()) {
            LocaleString displayName = entry.getValue();
            String key = entry.getKey();
            if ("closedate".equals(key) || "createorg".equals(key)) continue;
            ComboItem comboItem = new ComboItem();
            if ("managecurrency".equals(key)) {
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u8d39\u5e01\u79cd", (String)"ChangeApplyEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0])));
                comboItem.setValue(key);
            } else if ("acctmanageamt".equals(key)) {
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u8d39\u91d1\u989d", (String)"ChangeApplyEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0])));
                comboItem.setValue(key);
            } else {
                comboItem.setCaption(displayName);
                comboItem.setValue(key);
            }
            businessBillComboItemList.add(comboItem);
        }
        businessBillComboEdit.setComboItems(businessBillComboItemList);
    }

    private Map<String, LocaleString> getFields() {
        String businessBill = "am_accountbank";
        DynamicObject[] showFieldDys = TmcDataServiceHelper.load((String)AM_CHANGEAPPLY_CONFIG, (String)"id,billno,showfields,company", null);
        if (showFieldDys.length > 0) {
            DynamicObject showFieldDy = showFieldDys[0];
            String showFieldStr = showFieldDy.getString("showfields");
            Set keySet = Arrays.stream(showFieldStr.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            DynamicObject accountBank = this.getModel().getDataEntity(true).getDynamicObject("accountbank");
            if (accountBank != null) {
                if ("1".equals(accountBank.getString("finorgtype"))) {
                    Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)businessBill, (boolean)false, (boolean)true, (String[])HIDE_INNER_FIELDS);
                    return fieldColumn.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                }
                Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)businessBill, (boolean)false, (boolean)true, (String[])HIDE_FIELDS);
                return fieldColumn.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)businessBill, (boolean)false, (boolean)true, (String[])HIDE_FIELDS);
            return fieldColumn.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return new HashMap<String, LocaleString>(1);
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        if ("e_afterchange".equals(btnKey) || "e_afterchangename".equals(btnKey)) {
            String fieldName;
            int row = this.getModel().getEntryCurrentRowIndex("entryentity");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"am_accountbank");
            Map allFields = dataEntityType.getAllFields();
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldName = (String)this.getModel().getValue("e_changefield", row));
            if (property instanceof BasedataProp) {
                ItemClassEdit baseData = (ItemClassEdit)this.getControl("e_basedata");
                if ("acctproperty".equals(fieldName)) {
                    this.innitAcctPurpose(baseData);
                } else if ("proxycurrency".equals(fieldName)) {
                    this.initProxyCurrencyF7(baseData);
                }
                baseData.click();
            } else if (property instanceof TextProp) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u7c7b\u578b\u8bf7\u76f4\u63a5\u8f93\u5165", (String)"ChangeApplyEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            } else if (property instanceof MulBasedataProp) {
                if ("currency".equals(fieldName)) {
                    MulBasedataEdit baseData = (MulBasedataEdit)this.getControl("e_currency");
                    baseData.click();
                } else if ("settlementtype".equals(fieldName)) {
                    MulBasedataEdit baseData = (MulBasedataEdit)this.getControl("e_settlementtype");
                    baseData.click();
                } else if ("multigoods".equals(fieldName)) {
                    MulBasedataEdit baseData = (MulBasedataEdit)this.getControl("multigoods");
                    baseData.click();
                } else if ("relatedsettleacct".equals(fieldName)) {
                    MulBasedataEdit baseData = (MulBasedataEdit)this.getControl("e_relatedsettleacct");
                    baseData.click();
                }
            } else if (property instanceof ComboProp || property instanceof DateProp || property instanceof BooleanProp || property instanceof AmountProp) {
                if ("bankinterface".equals(fieldName)) {
                    ((ComboProp)property).setComboItems(this.initBankVersionBox(false));
                }
                FormShowParameter parameter = this.createComBoxDefaultValue(row, property, fieldName);
                this.getView().showForm(parameter);
            }
        }
    }

    private FormShowParameter createComBoxDefaultValue(int row, IDataEntityProperty property, String fieldName) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("am_changeapply_cdv");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String propType = null;
        String comBoxValue = null;
        if (property instanceof BooleanProp) {
            comBoxValue = ResManager.loadKDString((String)"true:\u662f,false:\u5426", (String)"CrossTranTypeEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
            propType = AmPropertyTypeEnum.BOOLEAN_PROP.getValue();
        } else if (property instanceof ComboProp) {
            if (((ComboProp)property).getComboItems().size() > 0) {
                comBoxValue = StringUtils.join((Object[])((ComboProp)property).getComboItems().stream().map(o -> o.getValue() + ":" + o.getName()).toArray(), (String)",");
                propType = "bebankfunc".equals(fieldName) || "bankfunc".equals(fieldName) ? AmPropertyTypeEnum.MUL_COM_BOX_PROP.getValue() : AmPropertyTypeEnum.COM_BOX_PROP.getValue();
            } else {
                comBoxValue = "";
                propType = AmPropertyTypeEnum.COM_BOX_PROP.getValue();
            }
        } else if (property instanceof DateProp) {
            comBoxValue = (String)this.getModel().getValue("e_beforechange", row);
            propType = AmPropertyTypeEnum.DATE_PROP.getValue();
        } else if (property instanceof AmountProp) {
            comBoxValue = (String)this.getModel().getValue("e_beforechange", row);
            propType = AmPropertyTypeEnum.AMOUNT_PROP.getValue();
        }
        parameter.setCustomParam("propType", (Object)propType);
        parameter.setCustomParam("comBoxValue", (Object)comBoxValue);
        if (property instanceof ComboProp && ((ComboProp)property).getComboItems().size() > 0 && "bankinterface".equals(fieldName) && ObjectUtils.isEmpty((Object)this.getModel().getValue("e_beforechange", row))) {
            String keyword = this.getKeyword((DynamicObject)this.getModel().getValue("accountbank"));
            List keywordMatchList = ((ComboProp)property).getComboItems().stream().filter(o -> o.getName().getLocaleValue().contains(keyword.trim())).collect(Collectors.toList());
            LOGGER.info("createComBoxDefaultValue getKeyword:{}, keywordMatchList.size:{}", (Object)keyword, (Object)keywordMatchList.size());
            if (keyword != null && keywordMatchList.size() > 0) {
                parameter.setCustomParam("defaultValue", (Object)((ValueMapItem)keywordMatchList.get(0)).getValue());
            }
        } else {
            parameter.setCustomParam("defaultValue", this.getModel().getValue("e_beforechange", row));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "defaultvalue"));
        return parameter;
    }

    private String getKeyword(DynamicObject bankAcct) {
        String keyword = null;
        DynamicObject finOrg = bankAcct.getDynamicObject("bank");
        if (finOrg != null) {
            String finOrgType = bankAcct.getString("finorgtype");
            if (finOrgType.equals("0")) {
                DynamicObject finOrgDb = TmcDataServiceHelper.loadSingle((Object)finOrg.getPkValue(), (String)"bd_finorginfo");
                DynamicObject bankCate = finOrgDb.getDynamicObject("bank_cate");
                if (bankCate != null) {
                    keyword = bankCate.getString("name");
                }
            } else {
                keyword = finOrg.getString("name");
            }
        }
        return keyword;
    }

    private List<ValueMapItem> initBankVersionBox(boolean isShowMsg) {
        ArrayList<ValueMapItem> bankVersionItems;
        block8: {
            bankVersionItems = new ArrayList<ValueMapItem>(0);
            try {
                DynamicObject accountbank = this.getModel().getDataEntity(true).getDynamicObject("accountbank");
                DynamicObject finOrg = accountbank.getDynamicObject("bank");
                finOrg = BusinessDataServiceHelper.loadSingle((Object)finOrg.getPkValue(), (String)finOrg.getDynamicObjectType().getName(), (String)"id,name,number,bank_cate");
                accountbank.set("bank", (Object)finOrg);
                EBGetLoginListResult loginListResult = BankServiceHelper.getLoginListResult((DynamicObject)accountbank);
                Map bankVersionMap = loginListResult.getLoginMap();
                this.getView().getPageCache().put("EBGetLoginListResult", JSON.toJSONString((Object)loginListResult));
                if (null != bankVersionMap) {
                    ArrayList<String> bankVersionList;
                    LOGGER.info("initBankVersionBox bankVersionMap.size is {},bankVersionMap = {}", (Object)bankVersionMap.size(), (Object)bankVersionMap.toString());
                    if (Boolean.TRUE.equals(accountbank.getBoolean("iselecpayment"))) {
                        bankVersionList = new ArrayList<String>(10);
                        for (String key : bankVersionMap.keySet()) {
                            if (key.contains("ECNY")) continue;
                            bankVersionList.add(key);
                        }
                        bankVersionList.forEach(bankVersionMap::remove);
                    } else {
                        bankVersionList = new ArrayList(10);
                        for (String key : bankVersionMap.keySet()) {
                            if (!key.contains("ECNY")) continue;
                            bankVersionList.add(key);
                        }
                        bankVersionList.forEach(bankVersionMap::remove);
                    }
                    for (Map.Entry entry : bankVersionMap.entrySet()) {
                        ValueMapItem item = new ValueMapItem(null, (String)entry.getKey(), new LocaleString((String)entry.getValue() + "  " + (String)entry.getKey()));
                        bankVersionItems.add(item);
                    }
                }
            }
            catch (Exception e) {
                if (!isShowMsg) break block8;
                this.getView().showErrorNotification(e.getMessage());
            }
        }
        LOGGER.info("initBankVersionBox bankVersionItems.size is {}", (Object)bankVersionItems.size());
        return bankVersionItems;
    }

    public List<ValueMapItem> initBankAcctTypes() {
        ArrayList<ValueMapItem> bankTypeItems = new ArrayList<ValueMapItem>(2);
        String pageCacheStr = this.getView().getPageCache().get("EBGetLoginListResult");
        EBGetLoginListResult loginListResult = new EBGetLoginListResult();
        DynamicObject accountBank = this.getModel().getDataEntity(true).getDynamicObject("accountbank");
        accountBank = BusinessDataServiceHelper.loadSingle((Object)accountBank.getPkValue(), (String)accountBank.getDynamicObjectType().getName());
        loginListResult = EmptyUtil.isEmpty((String)pageCacheStr) ? BankServiceHelper.getLoginListResult((DynamicObject)accountBank) : (EBGetLoginListResult)JSON.parseObject((String)pageCacheStr, EBGetLoginListResult.class);
        Map bankAccTypeMap = loginListResult.getBankAccTypeMap();
        if (null != bankAccTypeMap) {
            Map stringMap;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            String bankInterFaceValue = "";
            if (entryEntity != null && entryEntity.size() > 0) {
                for (DynamicObject entry : entryEntity) {
                    if (!"bankinterface".equals(entry.getString("e_changefield")) || entry.getString("e_afterchangename") == null) continue;
                    bankInterFaceValue = entry.getString("e_afterchangename");
                }
            }
            if (EmptyUtil.isEmpty((String)bankInterFaceValue)) {
                bankInterFaceValue = accountBank.getString("bankinterface");
            }
            if (null != (stringMap = (Map)bankAccTypeMap.get(bankInterFaceValue))) {
                for (Map.Entry entry : stringMap.entrySet()) {
                    ValueMapItem item = new ValueMapItem(null, (String)entry.getKey(), new LocaleString((String)entry.getValue()));
                    bankTypeItems.add(item);
                }
            }
        }
        return bankTypeItems;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        if ("defaultvalue".equals(closedCallBackEvent.getActionId()) && StringUtils.isNotBlank((CharSequence)(returnData = (String)closedCallBackEvent.getReturnData()))) {
            String newValueName = returnData;
            newValueName = this.subString50(newValueName);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("e_afterchange", (Object)newValueName, entryCurrentRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int row = e.getChangeSet()[0].getRowIndex();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "e_basedata": {
                DynamicObject newValueDy = (DynamicObject)newValue;
                if (!Objects.nonNull(newValueDy)) break;
                this.getModel().setValue("e_afterchange", newValueDy.get("name"), row);
                this.getModel().setValue("e_basedata", (Object)newValueDy, row);
                break;
            }
            case "e_changefield": {
                String oldValueStr = (String)oldValue;
                String newValueStr = (String)newValue;
                this.fieldChange(oldValueStr, newValueStr, row);
                break;
            }
            case "e_currency": 
            case "e_settlementtype": {
                DynamicObjectCollection newValueColl = (DynamicObjectCollection)newValue;
                String join = newValueColl.stream().map(c -> c.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining("\uff1b"));
                join = this.subString50(join);
                this.getModel().setValue("e_afterchange", (Object)join);
                break;
            }
            case "multigoods": {
                DynamicObjectCollection goodsColl = (DynamicObjectCollection)newValue;
                String goodsName = goodsColl.stream().map(c -> c.getDynamicObject("fbasedataid").getString("goodsname")).collect(Collectors.joining("\uff1b"));
                goodsName = this.subString50(goodsName);
                this.getModel().setValue("e_afterchange", (Object)goodsName);
                break;
            }
            case "e_relatedsettleacct": {
                DynamicObjectCollection relatedAcct = (DynamicObjectCollection)newValue;
                String acctName = relatedAcct.stream().map(c -> c.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.joining("\uff1b"));
                String goodsName = this.subString50(acctName);
                this.getModel().setValue("e_afterchange", (Object)goodsName);
                break;
            }
            case "e_afterchange": {
                Object[] bankAcctPays;
                Object[] bankAcctRecs;
                String beforeChange = (String)this.getModel().getValue("e_beforechange", row);
                String fieldName = (String)this.getModel().getValue("e_changefield", row);
                String AfterNewValueStr = (String)newValue;
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"am_accountbank");
                Map allFields = dataEntityType.getAllFields();
                IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldName);
                this.initChangeName(key, property, AfterNewValueStr, row);
                if (StringUtils.isNotEmpty((CharSequence)beforeChange) && StringUtils.isNotEmpty((CharSequence)AfterNewValueStr) && property instanceof MulBasedataProp && "currency".equals(fieldName)) {
                    DynamicObjectCollection eCurrency = (DynamicObjectCollection)this.getModel().getValue("e_currency", row);
                    AfterNewValueStr = eCurrency.stream().map(c -> c.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining("\uff1b"));
                    boolean isAll = this.containArray(beforeChange.split("\uff1b"), AfterNewValueStr.split("\uff1b"));
                    if (!isAll) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u589e\u52a0\u5e01\u79cd\uff0c\u4e0d\u80fd\u51cf\u5c11\u5e01\u79cd\u3002", (String)"ChangeApplyEdit_3", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("e_afterchange", null);
                    }
                }
                if ("true".equals(AfterNewValueStr) && property instanceof BooleanProp && "isdefaultrec".equals(fieldName) && !ArrayUtils.isEmpty((Object[])(bankAcctRecs = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "!=", ((DynamicObject)this.getModel().getValue("accountbank")).getPkValue()), new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("accountbank")).getDynamicObject("company").getPkValue()), new QFilter("isdefaultrec", "=", (Object)Boolean.TRUE), new QFilter("acctstatus", "!=", (Object)"closed")})))) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u91d1\u7ec4\u7ec7\u5df2\u8bbe\u7f6e\u94f6\u884c\u8d26\u53f7\u201c%1$s\u201d\u4e3a\u9ed8\u8ba4\u6536\u6b3e\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d8\u66f4\u94f6\u884c\u8d26\u53f7\u201c%2$s\u201d\u505a\u4e3a\u9ed8\u8ba4\u6536\u6b3e\u6237\uff1f", (String)"ChangeApplyEdit_8", (String)"tmc-am-formplugin", (Object[])new Object[0]), bankAcctRecs[0].getString("bankaccountnumber"), ((DynamicObject)this.getModel().getValue("accountbank")).getString("bankaccountnumber")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("defaultrec", (IFormPlugin)this));
                }
                if (!"true".equals(AfterNewValueStr) || !(property instanceof BooleanProp) || !"isdefaultpay".equals(fieldName) || ArrayUtils.isEmpty((Object[])(bankAcctPays = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company,isdefaultpay,isdefaultrec,bankaccountnumber", (QFilter[])new QFilter[]{new QFilter("id", "!=", ((DynamicObject)this.getModel().getValue("accountbank")).getPkValue()), new QFilter("company", "=", ((DynamicObject)this.getModel().getValue("accountbank")).getDynamicObject("company").getPkValue()), new QFilter("isdefaultpay", "=", (Object)Boolean.TRUE), new QFilter("acctstatus", "!=", (Object)"closed")})))) break;
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u91d1\u7ec4\u7ec7\u5df2\u8bbe\u7f6e\u94f6\u884c\u8d26\u53f7\u201c%1$s\u201d\u4e3a\u9ed8\u8ba4\u4ed8\u6b3e\u6237\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u53d8\u66f4\u94f6\u884c\u8d26\u53f7\u201c%2$s\u201d\u505a\u4e3a\u9ed8\u8ba4\u4ed8\u6b3e\u6237\uff1f", (String)"ChangeApplyEdit_9", (String)"tmc-am-formplugin", (Object[])new Object[0]), bankAcctPays[0].getString("bankaccountnumber"), ((DynamicObject)this.getModel().getValue("accountbank")).getString("bankaccountnumber")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("defaultpay", (IFormPlugin)this));
                break;
            }
            case "e_beforechange": {
                String fieldNameBef = (String)this.getModel().getValue("e_changefield", row);
                String newValueBef = (String)e.getChangeSet()[0].getNewValue();
                MainEntityType dataEntityTypeBef = MetadataServiceHelper.getDataEntityType((String)"am_accountbank");
                Map allFieldBef = dataEntityTypeBef.getAllFields();
                IDataEntityProperty propertyBef = (IDataEntityProperty)allFieldBef.get(fieldNameBef);
                this.initChangeName(key, propertyBef, newValueBef, row);
                break;
            }
            case "applydate": {
                Date bizDate;
                Date currentDate = DateUtils.getCurrentDate();
                if (EmptyUtil.isEmpty((Object)newValue) || !(bizDate = (Date)newValue).after(currentDate)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65e5\u671f", (String)"ChangeApplyEdit_4", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("applydate", null);
                break;
            }
            case "e_afterchangename": {
                String fieldNameAft = (String)this.getModel().getValue("e_changefield", row);
                String newValueAft = (String)e.getChangeSet()[0].getNewValue();
                String oldValueAft = (String)e.getChangeSet()[0].getOldValue();
                MainEntityType dataEntityTypeAft = MetadataServiceHelper.getDataEntityType((String)"am_accountbank");
                Map allFieldAft = dataEntityTypeAft.getAllFields();
                IDataEntityProperty propertyAft = (IDataEntityProperty)allFieldAft.get(fieldNameAft);
                Object afterchange = this.getModel().getValue("e_afterchange", row);
                if (propertyAft instanceof TextProp || propertyAft instanceof IntegerProp || propertyAft instanceof DecimalProp) {
                    this.setValWithoutDataChanged(this.getView(), "e_afterchange", newValueAft, row);
                    break;
                }
                if (ObjectUtils.isEmpty((Object)afterchange) && StringUtils.isNotEmpty((CharSequence)newValueAft)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6587\u672c\u7c7b\u578b\u4e0d\u652f\u6301\u76f4\u63a5\u8f93\u5165", (String)"ChangeApplyEdit_6", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                    this.setValWithoutDataChanged(this.getView(), "e_afterchangename", null, row);
                    break;
                }
                if (ObjectUtils.isEmpty((Object)afterchange) || StringUtils.equals((CharSequence)newValueAft, (CharSequence)oldValueAft)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u6587\u672c\u7c7b\u578b\u4e0d\u652f\u6301\u76f4\u63a5\u8f93\u5165", (String)"ChangeApplyEdit_6", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("e_afterchange", null, row);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"defaultrec") && !MessageBoxResult.Yes.equals((Object)res)) {
            this.getModel().setValue("e_afterchange", (Object)false, row);
            this.getModel().setValue("e_afterchangename", (Object)ResManager.loadKDString((String)"\u5426", (String)"ChangeApplyEdit_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]), row);
        }
        if (StringUtils.equals((CharSequence)id, (CharSequence)"defaultpay") && !MessageBoxResult.Yes.equals((Object)res)) {
            this.getModel().setValue("e_afterchange", (Object)false, row);
            this.getModel().setValue("e_afterchangename", (Object)ResManager.loadKDString((String)"\u5426", (String)"ChangeApplyEdit_7", (String)"tmc-bei-formplugin", (Object[])new Object[0]), row);
        }
    }

    private String subString50(String newValueName) {
        if (newValueName != null && newValueName.length() > 50) {
            newValueName = newValueName.substring(0, 46) + "...";
        }
        return newValueName;
    }

    private void fieldChange(String oldValue, String newValue, int row) {
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        if (ObjectUtils.isEmpty((Object)(accountBank = BusinessDataServiceHelper.loadSingle((Object)accountBank.getPkValue(), (String)"am_accountbank")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u53ef\u4e3a\u7a7a", (String)"ChangeApplyEdit_5", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("e_changefieldname", (Object)"", row);
            this.clearEntryRow(row);
            return;
        }
        this.clearEntryRow(row);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"am_accountbank");
        Map allFields = dataEntityType.getAllFields();
        if (newValue.equals(oldValue)) {
            return;
        }
        this.getModel().setValue("e_changefieldname", (Object)((IDataEntityProperty)allFields.get(newValue)).getDisplayName(), row);
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(newValue);
        if (property instanceof BasedataProp) {
            this.getModel().setValue("e_basedatatype", (Object)((BasedataProp)property).getBaseEntityId(), row);
            this.getModel().setValue("e_beforechange", this.getBaseDataTypeName(((BasedataProp)property).getBaseEntityId(), accountBank.get(newValue)), row);
        } else if (property instanceof MulBasedataProp) {
            DynamicObjectCollection collection = accountBank.getDynamicObjectCollection(newValue);
            String join = collection.stream().map(c -> c.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining("\uff1b"));
            this.getModel().setValue("e_beforechange", (Object)join, row);
        } else if (property instanceof DateProp) {
            this.getModel().setValue("e_beforechange", accountBank.get(newValue) == null ? null : DateUtils.formatString((Date)((Date)accountBank.get(newValue)), (String)"yyyy-MM-dd"), row);
        } else if (property instanceof MulComboProp) {
            this.getModel().setValue("e_beforechange", accountBank.get(newValue), row);
        } else if (property instanceof ComboProp) {
            if ("bankinterface".equals(newValue)) {
                ((ComboProp)property).setComboItems(this.initBankVersionBox(false));
            } else if ("additionalproperty".equals(newValue)) {
                ((ComboProp)property).setComboItems(this.initBankAcctTypes());
            }
            this.getModel().setValue("e_beforechange", accountBank.get(newValue), row);
        } else if (property instanceof TextProp || property instanceof IntegerProp) {
            this.getModel().setValue("e_beforechange", accountBank.get(newValue), row);
        } else if (property instanceof AmountProp) {
            this.getModel().setValue("e_beforechange", (Object)(accountBank.get(newValue) == null ? Integer.valueOf(0) : new BigDecimal(accountBank.get(newValue).toString()).setScale(2, 4)), row);
        } else if (property instanceof BooleanProp) {
            this.getModel().setValue("e_beforechange", (Object)accountBank.getString(newValue), row);
        }
    }

    private Object getBaseDataTypeName(String baseEntityId, Object BaseDataValue) {
        if (BaseDataValue != null && ("bd_accountbanks".equals(baseEntityId) || "am_accountbank".equals(baseEntityId))) {
            return ((DynamicObject)BaseDataValue).get("number");
        }
        if (BaseDataValue != null) {
            return ((DynamicObject)BaseDataValue).get("name");
        }
        return "";
    }

    private void initChangeName(String key, IDataEntityProperty property, String newValue, int row) {
        String newValueName = null;
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            newValueName = newValue;
        } else if (property instanceof MulComboProp) {
            if (((ComboProp)property).getComboItems().size() > 0) {
                CharSequence[] comBoxValue = (String[])((ComboProp)property).getComboItems().stream().filter(o -> Arrays.asList(newValue.split(",")).contains(o.getValue())).map(o -> o.getName().getLocaleValue()).toArray(String[]::new);
                newValueName = comBoxValue != null ? String.join((CharSequence)",", comBoxValue) : "";
            }
        } else if (property instanceof ComboProp) {
            Optional<ValueMapItem> comBoxValue;
            if (((ComboProp)property).getComboItems().size() > 0 && (comBoxValue = ((ComboProp)property).getComboItems().stream().filter(o -> o.getValue().equals(newValue)).findFirst()).isPresent()) {
                newValueName = comBoxValue.get().getName().getLocaleValue();
            }
        } else if (property instanceof BooleanProp) {
            String comBoxValue = ResManager.loadKDString((String)"true:\u662f,false:\u5426", (String)"CrossTranTypeEdit_1", (String)"tmc-bei-formplugin", (Object[])new Object[0]);
            for (String value : comBoxValue.split(",")) {
                String[] kv = value.split(":");
                if (!kv[0].equals(newValue)) continue;
                newValueName = kv[1];
            }
        } else {
            newValueName = newValue;
        }
        if ("e_beforechange".equals(key)) {
            this.setValWithoutDataChanged(this.getView(), "e_beforechangename", newValueName, row);
        } else if ("e_afterchange".equals(key)) {
            if (newValueName != null && newValueName.length() > 50) {
                newValueName = newValueName.substring(0, 46) + "...";
            }
            this.setValWithoutDataChanged(this.getView(), "e_afterchangename", newValueName, row);
        }
    }

    private void setValWithoutDataChanged(IFormView view, String propName, Object value, int row) {
        view.getModel().beginInit();
        view.getModel().setValue(propName, value, row);
        view.getModel().endInit();
        view.updateView(propName, row);
    }

    private void clearEntryRow(int row) {
        this.getModel().setValue("e_beforechange", null, row);
        this.getModel().setValue("e_afterchange", null, row);
        this.getModel().setValue("e_reason", null, row);
        this.getModel().setValue("e_basedatatype", null, row);
        this.getModel().setValue("e_basedata", null, row);
        this.getModel().setValue("e_currency", null, row);
        this.getModel().setValue("e_settlementtype", null, row);
        this.getModel().setValue("e_relatedsettleacct", null, row);
        this.getModel().setValue("e_changefieldname", null, row);
    }

    private boolean containArray(String[] a, String[] b) {
        return Arrays.asList(b).containsAll(Arrays.asList(a));
    }

    private void dealElecPayment(Map<String, LocaleString> fieldColumn) {
        fieldColumn.remove("iselecpayment");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity2");
        Set isElecPayment = entryEntity.stream().map(entry -> entry.getDynamicObject("e_accountbank").getBoolean("iselecpayment")).collect(Collectors.toSet());
        if (isElecPayment.isEmpty()) {
            return;
        }
        if (entryEntity.size() > 1) {
            fieldColumn.remove("relatedsettleacct");
            if (isElecPayment.size() > 1) {
                fieldColumn.remove("elecpaymenttype");
                fieldColumn.remove("elecpaymentlevel");
                fieldColumn.remove("issetbankinterface");
                fieldColumn.remove("bankfunc");
                fieldColumn.remove("bebankfunc");
                fieldColumn.remove("bankinterface");
                fieldColumn.remove("currency");
                fieldColumn.remove("defaultcurrency");
                fieldColumn.remove("openorg");
                fieldColumn.remove("company");
            } else if (Boolean.TRUE.equals(isElecPayment.iterator().next())) {
                fieldColumn.remove("currency");
                fieldColumn.remove("openorg");
                fieldColumn.remove("company");
            } else {
                fieldColumn.remove("elecpaymenttype");
                fieldColumn.remove("elecpaymentlevel");
            }
        } else if (!Boolean.TRUE.equals(isElecPayment.iterator().next())) {
            fieldColumn.remove("relatedsettleacct");
            fieldColumn.remove("elecpaymenttype");
            fieldColumn.remove("elecpaymentlevel");
        } else {
            fieldColumn.remove("openorg");
            fieldColumn.remove("company");
            fieldColumn.remove("currency");
        }
    }
}

