/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.formplugin.strategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.am.common.constants.AmBizConstant;
import kd.tmc.am.common.enums.BillStrategyEnum;
import kd.tmc.am.common.enums.LimitWayEnum;
import kd.tmc.am.common.helper.PermissionHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankAcctStrategyEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public static final String OVER_PANELAP_FLEX = "overpanelapflex";
    public static final String LIMIT_PANELAP_FLEX = "limitpanelapflex";
    public static final String LIMIT_ADD = "limitadd";
    public static final String LIMIT_ADD_CONTROL = "limitaddcontrol";
    public static final String LIMIT_UPDATE_IMG = "limitupdateimg";
    public static final String KEEP_PANELAP_FLEX = "keeppanelapflex";
    public static final String KEEP_ADD = "keepadd";
    public static final String KEEP_ADD_CONTROL = "keepaddcontrol";
    public static final String KEEP_UPDATE_IMG = "keepupdateimg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OVER_PANELAP_FLEX, LIMIT_PANELAP_FLEX, LIMIT_ADD, LIMIT_ADD_CONTROL, LIMIT_UPDATE_IMG, KEEP_PANELAP_FLEX, KEEP_ADD, KEEP_ADD_CONTROL, KEEP_UPDATE_IMG});
        BillList bankaccbilllistap = (BillList)this.getControl("bankaccbilllistap");
        bankaccbilllistap.addHyperClickListener((HyperLinkClickListener)this);
        BillList inneraccbilllistap = (BillList)this.getControl("inneraccbilllistap");
        inneraccbilllistap.addHyperClickListener((HyperLinkClickListener)this);
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            QFilter strategyFilter = this.getQueryFilter("strategy");
            bankaccbilllistap.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(strategyFilter));
            QFilter mgrstratgFilter = this.getQueryFilter("mgrstratg");
            inneraccbilllistap.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(mgrstratgFilter));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initBillListData();
    }

    private void initBillListData() {
        BillList bankaccbilllistap = (BillList)this.getControl("bankaccbilllistap");
        QFilter strategyFilter = this.getQueryFilter("strategy");
        bankaccbilllistap.getFilterParameter().getQFilters().add(strategyFilter);
        bankaccbilllistap.refreshData();
        BillList inneraccbilllistap = (BillList)this.getControl("inneraccbilllistap");
        QFilter mgrstratgFilter = this.getQueryFilter("mgrstratg");
        inneraccbilllistap.getFilterParameter().getQFilters().add(mgrstratgFilter);
        inneraccbilllistap.refreshData();
    }

    private QFilter getQueryFilter(String idProp) {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return QFilter.of((String)"1 = 2", (Object[])new Object[0]);
        }
        Long pkId = (Long)this.getModel().getValue("id");
        QFilter qFilter = new QFilter(idProp, "=", (Object)pkId);
        qFilter.and("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
        return qFilter;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        long orgId = TmcOrgDataHelper.getCurrentOrgId();
        if (model.getProperty("currency") != null) {
            DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)orgId);
            model.setValue("currency", EmptyUtil.isEmpty((DynamicObject)currency) ? null : currency.getPkValue());
        }
        model.setValue("isallowover", (Object)"0");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = String.valueOf(this.getView().getFormShowParameter().getStatus());
        if ("ADDNEW".equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"barlog"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applist"});
            Container fs_baseinfo = (Container)this.getView().getControl("fs_baseinfo");
            fs_baseinfo.setCollapse(false);
        } else if ("EDIT".equals(status) || "VIEW".equals(status)) {
            Container fs_baseinfo = (Container)this.getView().getControl("fs_baseinfo");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            fs_baseinfo.setCollapse(true);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            BillList bankaccbilllistap = (BillList)this.getControl("bankaccbilllistap");
            BillList inneraccbilllistap = (BillList)this.getControl("inneraccbilllistap");
            if ((Long)pkValue != 0L) {
                QFilter strategyFilter = new QFilter("strategy", "=", pkValue);
                boolean acctexists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{strategyFilter});
                strategyFilter.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
                QFilter mgrstratgFilter = new QFilter("mgrstratg", "=", pkValue);
                mgrstratgFilter.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
                boolean innerexists = TmcDataServiceHelper.exists((String)"ifm_inneracct", (QFilter[])new QFilter[]{mgrstratgFilter});
                if (acctexists || innerexists) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
                }
                bankaccbilllistap.setFilter(strategyFilter);
                inneraccbilllistap.setFilter(mgrstratgFilter);
            } else {
                bankaccbilllistap.setFilter(new QFilter("strategy", "=", null));
                inneraccbilllistap.setFilter(new QFilter("mgrstratg", "=", null));
            }
            bankaccbilllistap.refresh();
            inneraccbilllistap.refresh();
        }
        this.initLimitEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        boolean bisoverdraftstrategy = (Boolean)this.getModel().getValue("isoverstrgy");
        boolean bislimitstrategy = (Boolean)this.getModel().getValue("islimitstrgy");
        switch (key) {
            case "isoverstrgy": 
            case "islimitstrgy": {
                String a = "";
                String b = "";
                if (bisoverdraftstrategy) {
                    a = a + new AmBizConstant().getOverdrafts();
                    b = b + "1,";
                }
                if (bislimitstrategy) {
                    a = EmptyUtil.isNoEmpty((String)a) ? a + "," + new AmBizConstant().getLimit() : a + new AmBizConstant().getLimit();
                    b = b + "2,";
                }
                this.getModel().setValue("openstrgy", (Object)a);
                this.getModel().setValue("involstrgy", (Object)(!"".equals(b) ? "," + b : ""));
                break;
            }
            case "limitway": {
                this.limitWayChange();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            this.setHeadLimitInfo();
        } else if ("overmodifyentry".equals(operateKey)) {
            this.updateCheckOp("entry");
        } else if ("overnewentry".equals(operateKey)) {
            this.openCardEntry("entry");
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "overpanelapflex": {
                String appId = this.getView().getFormShowParameter().getAppId();
                boolean hasAddNewRight = PermissionHelper.checkCurUserPermission((String)appId, (String)this.getView().getEntityId(), (String)"47156aff000000ac");
                if (!hasAddNewRight) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8d26\u6237\u7ba1\u7406\u7b56\u7565\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BankAcctStrategyEdit_1", (String)"tmc-am-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openCardEntry("entry");
                break;
            }
            case "limitadd": 
            case "limitaddcontrol": 
            case "limitpanelapflex": {
                this.openCardEntry("limitentry");
                break;
            }
            case "keepadd": 
            case "keepaddcontrol": 
            case "keeppanelapflex": {
                this.openCardEntry("keepentry");
                break;
            }
            case "limitupdateimg": {
                this.updateCheckOp("limitentry");
                break;
            }
            case "keepupdateimg": {
                this.updateCheckOp("keepentry");
            }
        }
    }

    private void openCardEntry(String entryProp) {
        ListShowParameter billStrategyForm = ShowFormHelper.createShowListForm((String)"ifm_strategysetting", (boolean)Boolean.TRUE);
        billStrategyForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entryProp));
        DynamicObjectCollection entitys = this.getModel().getEntryEntity(entryProp);
        QFilter qFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        if (((Boolean)this.getModel().getValue("isinnerstrategy")).booleanValue()) {
            qFilter.and("strategyrange", "=", (Object)"inner");
        } else {
            qFilter.and("strategyrange", "=", (Object)"bank");
        }
        if ("limitentry".equals(entryProp)) {
            DynamicObjectCollection limitEntrys = this.getModel().getEntryEntity("limitwayentry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)limitEntrys)) {
                Set limitWay = limitEntrys.stream().map(s -> s.getString("limitway")).collect(Collectors.toSet());
                qFilter.and("modeltype.detail", "in", limitWay);
            } else {
                qFilter.and("1", "=", (Object)2);
            }
        }
        qFilter.and("modeltype.type", "=", (Object)BillStrategyEnum.getModelType((String)entryProp));
        if (entitys.size() > 0) {
            List yetChooseIdList = entitys.stream().filter(s -> EmptyUtil.isNoEmpty((DynamicObject)s.getDynamicObject(BillStrategyEnum.getBillStrategyProp((String)entryProp)))).map(s -> s.getDynamicObject(BillStrategyEnum.getBillStrategyProp((String)entryProp)).getLong("id")).collect(Collectors.toList());
            qFilter.and("id", "not in", yetChooseIdList);
        }
        billStrategyForm.getListFilterParameter().getQFilters().add(qFilter);
        this.getView().showForm((FormShowParameter)billStrategyForm);
    }

    private void updateCheckOp(String entryProp) {
        int row = this.getModel().getEntryCurrentRowIndex(entryProp);
        String strategyProp = BillStrategyEnum.getBillStrategyProp((String)entryProp);
        DynamicObject strategyValue = (DynamicObject)this.getModel().getValue(strategyProp, row);
        if (EmptyUtil.isNoEmpty((DynamicObject)strategyValue)) {
            String checkOpProp = BillStrategyEnum.getCheckOpProp((String)entryProp);
            String checkOpValue = (String)this.getModel().getValue(checkOpProp, row);
            String checkOpNameProp = BillStrategyEnum.getCheckOpNameProp((String)entryProp);
            String checkOpNameValue = (String)this.getModel().getValue(checkOpNameProp, row);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("am_strategy_updateop");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("initCheckOpPropValue", (Object)checkOpValue);
            parameter.setCustomParam("initCheckOpNamePropValue", (Object)checkOpNameValue);
            parameter.setCustomParam("allCheckOpPropValue", (Object)strategyValue.getString("checkop"));
            parameter.setCustomParam("allCheckOpNamePropValue", (Object)strategyValue.getString("checkopname"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entryProp + "#update"));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5355\u636e\u63a7\u5236\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"BankAcctStrategyEdit_2", (String)"tmc-am-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "entry": 
            case "limitentry": 
            case "keepentry": {
                this.callBackSetEntryInfo(e, actionId);
                break;
            }
            case "entry#update": 
            case "limitentry#update": 
            case "keepentry#update": {
                this.callBackUpdateOpInfo(e, actionId.split("#")[0]);
            }
        }
    }

    private void callBackSetEntryInfo(ClosedCallBackEvent e, String entryProp) {
        Object returnData = e.getReturnData();
        if (returnData != null) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            Map setMap = TmcDataServiceHelper.loadFromCache((String)"ifm_strategysetting", (String)"id, checkop, checkopname", (QFilter[])filter.toArray());
            ArrayList dataMap = new ArrayList(10);
            for (DynamicObject setting : setMap.values()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(BillStrategyEnum.getBillStrategyProp((String)entryProp), setting.getPkValue());
                map.put(BillStrategyEnum.getCheckOpNameProp((String)entryProp), setting.getString("checkopname"));
                map.put(BillStrategyEnum.getCheckOpProp((String)entryProp), setting.getString("checkop"));
                dataMap.add(map);
            }
            TmcViewInputHelper.batchFillEntity((String)entryProp, (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap, (boolean)false);
        }
    }

    private void callBackUpdateOpInfo(ClosedCallBackEvent e, String entryProp) {
        Map returnData = (Map)e.getReturnData();
        if (returnData != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(entryProp);
            String defaultName = (String)returnData.get("defaultname");
            String defaultValue = (String)returnData.get("defaultvalue");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)BillStrategyEnum.getCheckOpNameProp((String)entryProp), (Object)defaultName, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)BillStrategyEnum.getCheckOpProp((String)entryProp), (Object)defaultValue, (int)rowIndex);
        }
    }

    private void limitWayChange() {
        int row = this.getModel().getEntryCurrentRowIndex("limitwayentry");
        String limitWay = (String)this.getModel().getValue("limitway", row);
        if (LimitWayEnum.SINGLE.getValue().equals(limitWay)) {
            this.getModel().setValue("limitcount", null, row);
            this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"limitcount"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), row, new String[]{"limitcount"});
        }
    }

    private void setHeadLimitInfo() {
        boolean isPayLimit = (Boolean)this.getModel().getValue("ispaylimit");
        if (isPayLimit) {
            this.clearLimitInfo();
            DynamicObjectCollection limitEntrys = this.getModel().getEntryEntity("limitwayentry");
            for (DynamicObject limitEntry : limitEntrys) {
                String limitWay = limitEntry.getString("limitway");
                if (!EmptyUtil.isNoEmpty((String)limitWay)) continue;
                BigDecimal limitAmount = limitEntry.getBigDecimal("limitamount");
                String limitAmtProp = LimitWayEnum.getLimitAmtProp((String)limitWay);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)limitAmtProp, (Object)limitAmount);
                if (LimitWayEnum.SINGLE.getValue().equals(limitWay)) continue;
                int limitCount = limitEntry.getInt("limitcount");
                String limitCountProp = LimitWayEnum.getLimitCountProp((String)limitWay);
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)limitCountProp, (Object)limitCount);
            }
        }
    }

    private void initLimitEntry() {
        boolean isPayLimit = (Boolean)this.getModel().getValue("ispaylimit");
        if (isPayLimit) {
            List props = Arrays.stream(LimitWayEnum.values()).map(s -> s.getValue() + "#" + s.getLimitAmtProp() + "#" + s.getLimitCountProp()).collect(Collectors.toList());
            int index = 0;
            DynamicObjectCollection limitEntrys = this.getModel().getEntryEntity("limitwayentry");
            for (String prop : props) {
                String[] split = prop.split("#");
                String value = split[0];
                String amtProp = split[1];
                Object amtValue = this.getModel().getValue(amtProp);
                Object countValue = null;
                if (!LimitWayEnum.SINGLE.getValue().equals(value)) {
                    String countProp = split[2];
                    countValue = this.getModel().getValue(countProp);
                }
                if (!EmptyUtil.isNoEmpty((Object)amtValue) && !EmptyUtil.isNoEmpty(countValue)) continue;
                DynamicObject addNew = limitEntrys.addNew();
                addNew.set("limitway", (Object)value);
                addNew.set("limitamount", amtValue);
                addNew.set("limitcount", countValue);
                if (LimitWayEnum.SINGLE.getValue().equals(value)) {
                    this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"limitcount"});
                }
                ++index;
            }
            this.getView().updateView("limitwayentry");
            this.getModel().setDataChanged(false);
        }
    }

    private void clearLimitInfo() {
        List<String> allAmountProps = Arrays.stream(LimitWayEnum.values()).map(LimitWayEnum::getLimitAmtProp).collect(Collectors.toList());
        allAmountProps.forEach(prop -> TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)prop, null));
        List<String> allCountProps = Arrays.stream(LimitWayEnum.values()).filter(s -> !LimitWayEnum.SINGLE.getValue().equals(s.getValue())).map(LimitWayEnum::getLimitCountProp).collect(Collectors.toList());
        allCountProps.forEach(prop -> TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)prop, null));
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    private void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        if ("limitway".equals(key)) {
            this.checkLimitWay(value, e);
        }
    }

    private void checkLimitWay(Object value, BeforeFieldPostBackEvent e) {
        DynamicObjectCollection limitWayEntry;
        boolean exists;
        int index = e.getRowIndex();
        if (value != null && (exists = (limitWayEntry = this.getModel().getEntryEntity("limitwayentry")).stream().anyMatch(s -> String.valueOf(value).equals(s.getString("limitway"))))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5f53\u524d\u9650\u5b9a\u65b9\u5f0f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BankAcctStrategyEdit_0", (String)"tmc-am-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        this.getView().updateView("limitway", index);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"bankaccountnumber")) {
            Object focusRowPkId = ((BillList)event.getSource()).getFocusRowPkId();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("bd_accountbanks");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId(focusRowPkId);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"number")) {
            Object focusRowPkId = ((BillList)event.getSource()).getFocusRowPkId();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("ifm_inneracct");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPkId(focusRowPkId);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

