/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.am.business.validate.bankacct;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.am.common.helper.CountryHelper;
import kd.tmc.am.common.resource.AmBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BankAcctSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("bankinterface");
        sic.add("currency");
        sic.add("opendate");
        sic.add("issetbankinterface");
        sic.add("closedatef");
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        AmBizResource amBizResource = new AmBizResource();
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean originalVirtual;
            DynamicObject orignalBankAcct;
            DynamicObject bankAcct = data.getDataEntity();
            boolean isVirtual = bankAcct.getBoolean("isvirtual");
            boolean isFromDB = bankAcct.getDataEntityState().getFromDatabase();
            if (isFromDB && (orignalBankAcct = TmcDataServiceHelper.loadSingle((Object)bankAcct.getPkValue(), (String)"am_accountbank", (String)"isvirtual")) != null && isVirtual != (originalVirtual = orignalBankAcct.getBoolean("isvirtual"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u7684\u865a\u62df\u8d26\u6237\u72b6\u6001\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"BankAccountSaveValidator_10", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            boolean isSetInterface = bankAcct.getBoolean("issetbankinterface");
            boolean isOpenBank = bankAcct.getBoolean("isopenbank");
            if (isVirtual && (isSetInterface || isOpenBank)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u865a\u62df\u8d26\u6237\u4e0d\u80fd\u5f00\u901a\u94f6\u4f01\u4ee5\u53ca\u7f51\u4e0a\u94f6\u884c\u3002", (String)"BankAccountSaveValidator_7", (String)"tmc-am-business", (Object[])new Object[0]));
            }
            if (isSetInterface) {
                Pair<Boolean, String> verifyFinOrg = this.verifyFinOrg(bankAcct);
                if (!((Boolean)verifyFinOrg.getLeft()).booleanValue()) {
                    this.addErrorMessage(data, (String)verifyFinOrg.getRight());
                }
                String bankinterface = bankAcct.getString("bankinterface");
                if (bankAcct.get("inneracct") == null && EmptyUtil.isEmpty((String)bankinterface)) {
                    this.addErrorMessage(data, amBizResource.getErrorBankInterface());
                }
            }
            Date openDate = bankAcct.getDate("opendate");
            Date closeDatef = bankAcct.getDate("closeDatef");
            if (openDate == null || closeDatef == null || closeDatef.compareTo(openDate) > 0) continue;
            this.addErrorMessage(data, amBizResource.getCloseDatefVal());
        }
    }

    private Pair<Boolean, String> verifyFinOrg(DynamicObject bankAcct) {
        boolean isNullOrNotChina;
        Pair pair = Pair.of((Object)Boolean.TRUE, (Object)"");
        DynamicObject bank = TmcDataServiceHelper.loadSingle((Object)bankAcct.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo");
        DynamicObject country = bank.getDynamicObject("country");
        String unionNumber = bank.getString("union_number");
        String type = bankAcct.getString("finorgtype");
        boolean bl = isNullOrNotChina = country == null || country != null && !CountryHelper.isChina((DynamicObject)country);
        if (!isNullOrNotChina && StringUtils.isEmpty((CharSequence)unionNumber) && "0".equalsIgnoreCase(type)) {
            String msg = ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784\u7684\u8054\u884c\u53f7\u672a\u586b\u5199\uff0c\u8bf7\u5148\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u3002", (String)"BankAcctSaveValidator_0", (String)"tmc-am-business", (Object[])new Object[0]);
            pair = Pair.of((Object)Boolean.FALSE, (Object)msg);
            return pair;
        }
        return pair;
    }
}

